/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.dql;

import com.scudata.dm.query.dql.DQLUtils;
import com.scudata.dm.query.dql.FieldNode;
import com.scudata.dm.query.dql.TableConvertor;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.ForeignKey;
import com.scudata.dm.query.metadata.IField;
import com.scudata.dm.query.metadata.ITable;
import com.scudata.dm.query.metadata.LevelFunction;

class FieldConvertor {
    static final String FIELD_REF = "~.";
    private FieldConvertor leftField;
    private TableConvertor tableConvertor;
    private IField field;
    private LevelFunction level;
    private TableConvertor refTable;
    private String srcName;
    private String refExp;
    private String valueRefExp;

    public FieldConvertor(TableConvertor tableConvertor, IField field, LevelFunction level) {
        this.tableConvertor = tableConvertor;
        this.field = field;
        this.level = level;
    }

    public FieldConvertor(TableConvertor tableConvertor, IField field, LevelFunction level, TableConvertor refTable) {
        this(tableConvertor, field, level);
        this.setRefTable(refTable);
    }

    public boolean isCompatible(FieldNode fieldNode) {
        String fieldName = fieldNode.getFieldName();
        if (!this.field.isEquals(fieldName)) {
            return false;
        }
        String levelName = fieldNode.getLevelName();
        if (levelName != null ? this.level == null || !this.level.isEquals(levelName) : this.level != null) {
            return false;
        }
        String tableName = fieldNode.getTableName();
        return tableName == null || this.field.getTable().isEquals(tableName);
    }

    public boolean isCompatible(ForeignKey foreignKey) {
        if (this.field != foreignKey && !foreignKey.isEquals(this.field.getName())) {
            return false;
        }
        return this.refTable.getTable() == foreignKey.getRefTable();
    }

    public boolean isCompatible(FieldNode fieldNode, FieldNode rightFieldNode) {
        if (!this.isCompatible(fieldNode)) {
            return false;
        }
        if (this.refTable != null) {
            ITable table = this.refTable.getTable();
            String tableName = rightFieldNode.getTableName();
            if (tableName != null) {
                return table.isEquals(tableName);
            }
            String fieldName = rightFieldNode.getFieldName();
            return table.getField(fieldName) != null;
        }
        return false;
    }

    public FieldConvertor getLeftField() {
        return this.leftField;
    }

    public void setLeftField(FieldConvertor leftField) {
        this.leftField = leftField;
    }

    public TableConvertor getTableConvertor() {
        return this.tableConvertor;
    }

    public IField getField() {
        return this.field;
    }

    public LevelFunction getLevel() {
        return this.level;
    }

    public TableConvertor getRefTable() {
        return this.refTable;
    }

    public void setRefTable(TableConvertor refTable) {
        this.refTable = refTable;
    }

    public FieldConvertor getFieldConvertor(FieldNode fieldNode) {
        FieldConvertor fieldConvertor = this.refTable.getFieldConvertor(fieldNode);
        fieldConvertor.setLeftField(this);
        return fieldConvertor;
    }

    public FieldConvertor getFieldConvertor(FieldNode fieldNode, FieldNode rightFieldNode) {
        FieldConvertor fieldConvertor = this.refTable.getFieldConvertor(fieldNode, rightFieldNode);
        fieldConvertor.setLeftField(this);
        return fieldConvertor;
    }

    static String getFieldRefExp(String fieldName) {
        return "'" + fieldName + "'";
    }

    static String getFieldValueRefExp(String refField) {
        return String.valueOf(refField) + ".key()";
    }

    static String getFieldValueRefExp(Field field) {
        if (field.isRefField()) {
            return "'" + field.getSource() + "'" + ".key()";
        }
        return "'" + field.getSource() + "'";
    }

    public void analyse() {
        if (this.refTable != null) {
            this.refTable.analyse();
        }
        if (this.field instanceof Field) {
            if (!(this.refTable == null || this.field.isJoined() && this.field.getRefTable() == this.refTable.getTable())) {
                this.srcName = this.tableConvertor.addForeignKey(this.field, this.level, this.refTable);
                this.refExp = FieldConvertor.getFieldRefExp(this.srcName);
                this.valueRefExp = FieldConvertor.getFieldValueRefExp(this.refExp);
            } else {
                this.srcName = ((Field)this.field).getSource();
                this.tableConvertor.addSelectField(this.srcName);
                this.refExp = FieldConvertor.getFieldRefExp(this.srcName);
                this.valueRefExp = FieldConvertor.getFieldValueRefExp((Field)this.field);
            }
        } else {
            if (this.refTable == null) {
                throw new RuntimeException("Select foreign key error");
            }
            ForeignKey fk = (ForeignKey)this.field;
            if (!fk.isJoined() || fk.getRefTable() != this.refTable.getTable()) {
                this.srcName = this.tableConvertor.addForeignKey(fk, null, this.refTable);
                this.valueRefExp = this.refExp = FieldConvertor.getFieldRefExp(this.srcName);
            } else {
                this.srcName = fk.getName();
                this.tableConvertor.addSelectField(this.srcName);
                this.valueRefExp = this.refExp = FieldConvertor.getFieldRefExp(this.srcName);
            }
        }
    }

    public String getSrcName() {
        return this.srcName;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public String getRefExp() {
        if (this.leftField == null) {
            String joinFieldName = this.tableConvertor.getJoinFieldName();
            if (joinFieldName == null) {
                return this.refExp;
            }
            return String.valueOf(joinFieldName) + '.' + this.refExp;
        }
        return String.valueOf(this.leftField.getRefExp()) + '.' + this.refExp;
    }

    public void toExpression(StringBuffer out) {
        if (this.level == null || this.refTable != null) {
            if (this.leftField == null) {
                String joinFieldName = this.tableConvertor.getJoinFieldName();
                if (joinFieldName != null) {
                    out.append(joinFieldName);
                    out.append('.');
                } else {
                    out.append(FIELD_REF);
                }
            } else {
                out.append(this.leftField.getRefExp());
                out.append('.');
            }
            out.append(this.valueRefExp);
        } else {
            String joinFieldName;
            String fieldExp = this.leftField == null ? ((joinFieldName = this.tableConvertor.getJoinFieldName()) != null ? String.valueOf(joinFieldName) + '.' + this.valueRefExp : FIELD_REF + this.valueRefExp) : String.valueOf(this.leftField.getRefExp()) + '.' + this.valueRefExp;
            fieldExp = DQLUtils.convert(fieldExp, this.level);
            out.append('(');
            out.append(fieldExp);
            out.append(')');
        }
    }
}

