/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.dql;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Table;
import com.scudata.dm.query.dql.DQLUtils;
import com.scudata.dm.query.dql.FieldNode;
import com.scudata.dm.query.dql.TableNode;
import com.scudata.dm.query.dql.Token;
import com.scudata.dm.query.dql.Tokenizer;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.FieldList;
import com.scudata.dm.query.metadata.ForeignKey;
import com.scudata.dm.query.metadata.ForeignKeyList;
import com.scudata.dm.query.metadata.IJSONObject;
import com.scudata.dm.query.metadata.LevelFunction;
import com.scudata.dm.query.metadata.LevelFunctionList;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.TableList;
import com.scudata.dm.query.resources.ParseMessage;
import com.scudata.dm.query.utils.IOUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicList {
    private List<Object[]> _$2 = new ArrayList<Object[]>();
    private LogicMetaData _$1 = null;

    public LogicList(String dql, LogicMetaData lmd) {
        if (lmd == null) {
            throw new RQException("\u7f3a\u5c11\u5143\u6570\u636e\u914d\u7f6e");
        }
        this._$1 = lmd;
        Token[] tokens = Tokenizer.parseList(dql);
        if (tokens.length == 0) {
            throw new RQException("\u8bed\u6cd5\u9519\u8bef");
        }
        this._$1(tokens, 0, tokens.length);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(Token[] tokens, int start, int next) {
        if (!tokens[start].isKeyWord("LIST")) {
            throw new RQException("This is not a list command!");
        }
        if (++start >= next) {
            throw new RQException("\u8bed\u6cd5\u9519\u8bef");
        }
        int colPos = start;
        int ofPos = -1;
        for (int i = colPos; i < next; ++i) {
            Token token = tokens[i];
            if (!token.isKeyWord("OF")) continue;
            if (ofPos != -1) {
                throw new RQException("\u8bed\u6cd5\u9519\u8bef");
            }
            ofPos = i;
        }
        if (ofPos == -1) {
            if (start + 1 != next) {
                throw new RQException("\u8bed\u6cd5\u9519\u8bef");
            }
            if (tokens[start].isKeyWord("TABLE")) {
                this._$3();
                return;
            } else if (tokens[start].isKeyWord("DIM")) {
                this._$2();
                return;
            } else {
                if (!tokens[start].isKeyWord("METADATA")) throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                this._$1();
            }
            return;
        }
        if (tokens[start].isKeyWord("DIM") && start + 4 == next && tokens[start + 1].isKeyWord("TABLE") && tokens[start + 2].isKeyWord("OF") && tokens[start + 3].getType() == '\u0001') {
            com.scudata.dm.query.metadata.Table tb = this._$1(tokens[start + 3]);
            this._$3(tb);
            return;
        }
        if (tokens[start].isKeyWord("SUB") && start + 4 == next && tokens[start + 1].isKeyWord("TABLE") && tokens[start + 2].isKeyWord("OF") && tokens[start + 3].getType() == '\u0001') {
            com.scudata.dm.query.metadata.Table tb = this._$1(tokens[start + 3]);
            this._$2(tb);
            return;
        }
        if (tokens[start].isKeyWord("LAYER") && start + 3 == next && tokens[start + 1].isKeyWord("OF") && tokens[start + 2].getType() == '\u0001') {
            com.scudata.dm.query.metadata.Table dm = this._$1(tokens[start + 2].getString());
            this._$1(dm);
            return;
        }
        if (tokens[start].isKeyWord("FIELD") && start + 2 < next && start + 1 <= ofPos && ofPos + 1 < next && tokens[ofPos + 1].getType() == '\u0001') {
            void var14_33;
            com.scudata.dm.query.metadata.Table tb = this._$1(tokens[ofPos + 1]);
            int depth = 1;
            int depthPos = Tokenizer.scanKeyWord("DEPTH", tokens, ofPos + 1, next);
            if (depthPos > 0) {
                if (depthPos + 1 >= next) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
                if (!(depthPos + 2 >= next || tokens[depthPos + 2].isKeyWord("PRIMARY") || tokens[depthPos + 2].isKeyWord("FOREIGN") || tokens[depthPos + 2].isKeyWord("DIM"))) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
                try {
                    depth = Integer.parseInt(tokens[depthPos + 1].getString());
                    if (depth < 0) {
                        throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef", (Throwable)nfe);
                }
            }
            int dimPos = Tokenizer.scanKeyWord("DIM", tokens, ofPos + 1, next);
            com.scudata.dm.query.metadata.Table dimLimit = null;
            if (dimPos > 0) {
                if (dimPos + 1 >= next) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
                if (!(dimPos + 2 >= next || tokens[dimPos + 2].isKeyWord("PRIMARY") || tokens[dimPos + 2].isKeyWord("FOREIGN") || tokens[dimPos + 2].isKeyWord("DEPTH"))) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
                dimLimit = this._$1(tokens[dimPos + 1].getString());
            }
            int primaryPos = Tokenizer.scanKeyWord("PRIMARY", tokens, ofPos + 1, next);
            boolean pkLimit = false;
            if (primaryPos > 0) {
                if (primaryPos + 1 >= next) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
                if (!tokens[primaryPos + 1].isKeyWord("KEY")) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
                if (!(primaryPos + 2 >= next || tokens[primaryPos + 2].isKeyWord("DIM") || tokens[primaryPos + 2].isKeyWord("FOREIGN") || tokens[primaryPos + 2].isKeyWord("DEPTH"))) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
                if (tb.getPK() != null && !tb.getPK().isEmpty()) {
                    pkLimit = true;
                }
            }
            int foreignPos = Tokenizer.scanKeyWord("FOREIGN", tokens, ofPos + 1, next);
            Object var14_30 = null;
            if (foreignPos > 0) {
                if (foreignPos + 1 >= next) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
                if (!tokens[foreignPos + 1].isKeyWord("KEY")) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
                if (!(foreignPos + 2 >= next || tokens[foreignPos + 2].isKeyWord("DIM") || tokens[foreignPos + 2].isKeyWord("PRIMARY") || tokens[foreignPos + 2].isKeyWord("DEPTH"))) {
                    if (tokens[foreignPos + 2].isKeyWord()) {
                        throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                    }
                    ForeignKey foreignKey = this._$1(tb, tokens[foreignPos + 2].getString());
                } else {
                    com.scudata.dm.query.metadata.Table table = tb;
                }
            }
            ArrayList<Integer> infoList = new ArrayList<Integer>();
            for (int k = start; k < ofPos; k += 2) {
                if (!tokens[k].isKeyWord("FIELD") && !tokens[k].isKeyWord("DIM") && !tokens[k].isKeyWord("TYPE")) throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                if (tokens[k].isKeyWord("FIELD")) {
                    infoList.clear();
                } else if (tokens[k].isKeyWord("DIM")) {
                    infoList.add(1);
                } else if (tokens[k].isKeyWord("TYPE")) {
                    infoList.add(2);
                }
                if (k + 1 >= ofPos || tokens[k + 1].getType() == ',') continue;
                throw new RQException("\u8bed\u6cd5\u9519\u8bef");
            }
            this._$1(tb, infoList, depth, dimLimit, pkLimit, (IJSONObject)var14_33);
            return;
        }
        if (tokens[start].isKeyWord("FIELD") || start + 2 >= next || start + 1 > ofPos || ofPos + 1 >= next || tokens[ofPos + 1].getType() != '\u0001') throw new RQException("\u8bed\u6cd5\u9519\u8bef");
        ArrayList<Integer> infoList = new ArrayList<Integer>();
        for (int k = start; k < ofPos; k += 2) {
            if (!tokens[k].isKeyWord("TABLE") && !tokens[k].isKeyWord("DIM") && !tokens[k].isKeyWord("TYPE")) throw new RQException("\u8bed\u6cd5\u9519\u8bef");
            if (tokens[k].isKeyWord("TABLE")) {
                infoList.add(0);
            } else if (tokens[k].isKeyWord("DIM")) {
                infoList.add(1);
            } else if (tokens[k].isKeyWord("TYPE")) {
                infoList.add(2);
            }
            if (k + 1 >= ofPos || tokens[k + 1].getType() == ',') continue;
            throw new RQException("\u8bed\u6cd5\u9519\u8bef");
        }
        HashMap<String, Field> fdMap = new HashMap<String, Field>();
        int begin = ofPos + 1;
        while (begin < next) {
            int k;
            int commaPos = Tokenizer.scanComma(tokens, begin, next);
            StringBuffer temp = new StringBuffer();
            ArrayList<Token> fieldTokenList = new ArrayList<Token>();
            if (commaPos < 0) {
                for (k = begin; k < next; ++k) {
                    temp.append(tokens[k].getString());
                    fieldTokenList.add(tokens[k]);
                }
                begin = next;
            } else {
                for (k = begin; k < commaPos; ++k) {
                    temp.append(tokens[k].getString());
                    fieldTokenList.add(tokens[k]);
                }
                begin = commaPos + 1;
                if (begin >= next) {
                    throw new RQException("\u8bed\u6cd5\u9519\u8bef");
                }
            }
            Token[] fieldTokens = new Token[fieldTokenList.size()];
            fieldTokenList.toArray(fieldTokens);
            String item = temp.toString();
            Field field = this._$1(fieldTokens);
            if (field == null) {
                throw new RQException("\u5b57\u6bb5\u4e0d\u5b58\u5728");
            }
            fdMap.put(item, field);
        }
        this._$1(fdMap, infoList);
    }

    private Field _$1(Token[] tokens) {
        int len = tokens.length;
        if (len < 3 || tokens[1].getType() != '.') {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[0].getPos());
        }
        com.scudata.dm.query.metadata.Table table = this._$1(tokens[0]);
        TableNode tableNode = new TableNode(table);
        FieldNode fieldNode = DQLUtils.scanField(tableNode, tokens, 2, len);
        return (Field)fieldNode.getField();
    }

    private com.scudata.dm.query.metadata.Table _$1(Token token) {
        String tableName = token.getString();
        com.scudata.dm.query.metadata.Table table = this._$1.getTableByName(tableName);
        if (table == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(tableName + mm.getMessage("syntax.unknownTable") + token.getPos());
        }
        return table;
    }

    private com.scudata.dm.query.metadata.Table _$1(String dimName) {
        if (dimName == null || dimName.isEmpty()) {
            throw new RQException("\u975e\u6cd5\u7684\u7ef4\u8868\u540d");
        }
        com.scudata.dm.query.metadata.Table dim = null;
        for (com.scudata.dm.query.metadata.Table table : this._$1.getDimList()) {
            if (!table.getName().equalsIgnoreCase(dimName)) continue;
            dim = table;
            break;
        }
        if (dim == null) {
            throw new RQException("\u672a\u77e5\u7684\u7ef4\u540d");
        }
        return dim;
    }

    private ForeignKey _$1(com.scudata.dm.query.metadata.Table table, String fkName) {
        if (table == null || fkName == null || fkName.isEmpty()) {
            throw new RQException("\u975e\u6cd5\u7684\u5916\u952e\u540d");
        }
        ForeignKey fk = table.getForeignKeyByName(fkName);
        if (fk == null) {
            throw new RQException("\u672a\u77e5\u7684\u5916\u952e\u540d");
        }
        return fk;
    }

    private List<List<Object>> _$1(com.scudata.dm.query.metadata.Table table, int depth) {
        if (depth < 0) {
            throw new RQException("DEPTH N\u4e2d\u7684N\u5fc5\u987b\u4e3a\u975e\u8d1f\u6574\u6570");
        }
        if (table != null) {
            return table.getGenericFieldList(depth);
        }
        return null;
    }

    private void _$3() {
        this._$2.add(new Object[]{"tableName", "pseudo"});
        TableList list = this._$1.getTableList();
        if (list != null) {
            for (com.scudata.dm.query.metadata.Table tb : list) {
                if (tb == null) continue;
                this._$2.add(new Object[]{tb.getName(), tb.getType() == 1});
            }
        }
    }

    private void _$2() {
        this._$2.add(new Object[]{"dimName"});
        TableList list = this._$1.getDimList();
        if (list != null) {
            for (com.scudata.dm.query.metadata.Table dm : list) {
                if (dm == null) continue;
                this._$2.add(new Object[]{dm.getName()});
            }
        }
    }

    private void _$1() {
        try {
            String json = this._$1.toJsonString();
            this._$2.add(new Object[]{"metadata"});
            this._$2.add(new Object[]{json});
        }
        catch (JSONException e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    private void _$1(Map<String, Field> fdMap, ArrayList<Integer> infoList) {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add("fieldName");
        if (infoList != null && !infoList.isEmpty()) {
            for (int info : infoList) {
                if (info == 0) {
                    objList.add("tableName");
                    continue;
                }
                if (info == 1) {
                    objList.add("dimName");
                    continue;
                }
                if (info != 2) continue;
                objList.add("dataType");
            }
        }
        Object[] objs = new Object[objList.size()];
        objList.toArray(objs);
        this._$2.add(objs);
        if (fdMap != null && !fdMap.isEmpty()) {
            for (Map.Entry<String, Field> entry : fdMap.entrySet()) {
                String exp = entry.getKey();
                Field fd = entry.getValue();
                if (fd == null) continue;
                objList = new ArrayList();
                objList.add(exp);
                for (int info : infoList) {
                    if (info == 0) {
                        com.scudata.dm.query.metadata.Table tb = fd.getTable();
                        if (tb == null) continue;
                        objList.add(tb.getName());
                        continue;
                    }
                    if (info == 1) {
                        com.scudata.dm.query.metadata.Table dim = fd.getDim() == null ? null : fd.getDim().getTable();
                        objList.add(dim == null || dim.getName() == null ? "" : dim.getName());
                        continue;
                    }
                    if (info != 2) continue;
                    int dataType = fd.getDataType();
                    objList.add(dataType);
                }
                objs = new Object[objList.size()];
                objList.toArray(objs);
                this._$2.add(objs);
            }
        }
    }

    private void _$3(com.scudata.dm.query.metadata.Table table) {
        TableList tableList;
        this._$2.add(new Object[]{"tableName", "pseudo"});
        if (table != null && (tableList = table.getAnnexTableList()) != null && !tableList.isEmpty()) {
            for (com.scudata.dm.query.metadata.Table same : tableList) {
                if (same == null || same.equals(table)) continue;
                this._$2.add(new Object[]{same.getName(), same.getType() == 1});
            }
        }
    }

    private void _$2(com.scudata.dm.query.metadata.Table table) {
        this._$2.add(new Object[]{"tableName", "pseudo"});
        if (table != null) {
            TableList detailList = table.getDetailTableList();
            for (com.scudata.dm.query.metadata.Table detail : detailList) {
                if (detail == null) continue;
                this._$2.add(new Object[]{detail.getName(), detail.getType() == 1});
            }
        }
    }

    private void _$1(com.scudata.dm.query.metadata.Table dim) {
        this._$2.add(new Object[]{"dimName", "levelName"});
        if (dim != null) {
            if (dim.getName() == null || dim.getName().isEmpty()) {
                throw new RQException("\u5f02\u5e38\u7684\u7ef4\u8868\u540d");
            }
            LevelFunctionList list = ((Field)dim.getPKFieldList().get(0)).getLevelFunctionList();
            if (list != null) {
                for (LevelFunction v : list) {
                    if (v == null) continue;
                    this._$2.add(new Object[]{dim.getName(), v.getName()});
                }
            }
        } else {
            throw new RQException("\u7ef4\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static String getGenericFieldName(Map<String, String> tableAliasNameMap, List<Object> genericField) {
        StringBuffer sb = new StringBuffer();
        int sz = genericField.size();
        for (int i = 0; i < sz; ++i) {
            Object obj = genericField.get(i);
            if (obj instanceof com.scudata.dm.query.metadata.Table && i == 0) {
                String aliasName = tableAliasNameMap.get(((com.scudata.dm.query.metadata.Table)obj).getName());
                if (aliasName == null) {
                    aliasName = ((com.scudata.dm.query.metadata.Table)obj).getName();
                }
                sb.append(aliasName);
                continue;
            }
            if (obj instanceof ForeignKey && i > 0 && i <= sz - 1) {
                sb.append(".");
                sb.append(((ForeignKey)obj).getName());
                continue;
            }
            if (obj instanceof LevelFunction && i > 0 && i <= sz - 1) {
                sb.append("#");
                sb.append(((LevelFunction)obj).getName());
                continue;
            }
            if (obj instanceof Field && i > 0 && i <= sz - 1) {
                sb.append(".");
                sb.append(((Field)obj).getName());
                continue;
            }
            if (obj instanceof com.scudata.dm.query.metadata.Table && i == sz - 1) {
                sb.append("@");
                sb.append(((com.scudata.dm.query.metadata.Table)obj).getName());
                continue;
            }
            throw new RQException("\u65e0\u6548\u7684\u5e7f\u4e49\u5b57\u6bb5\u5bf9\u8c61\uff1a" + obj == null ? "null" : obj.getClass().getName());
        }
        return sb.toString();
    }

    private void _$1(com.scudata.dm.query.metadata.Table table, List<Integer> infoList, int depth, com.scudata.dm.query.metadata.Table dimLimit, boolean pkLimit, IJSONObject fkLimit) {
        block14: {
            List<List<Object>> genericFieldList;
            ArrayList<Object> objList;
            block15: {
                Object[] objs;
                objList = new ArrayList<Object>();
                objList.add("tableName");
                if (fkLimit != null && fkLimit instanceof com.scudata.dm.query.metadata.Table && fkLimit.equals(table)) {
                    objList.add("FKName");
                    objs = new Object[objList.size()];
                    objList.toArray(objs);
                    this._$2.add(objs);
                } else {
                    objList.add("fieldName");
                    if (infoList != null && !infoList.isEmpty()) {
                        for (int info : infoList) {
                            if (info == 1) {
                                objList.add("dimName");
                                continue;
                            }
                            if (info != 2) continue;
                            objList.add("dataType");
                        }
                    }
                    objs = new Object[objList.size()];
                    objList.toArray(objs);
                    this._$2.add(objs);
                }
                if (table == null) break block14;
                if (fkLimit == null || !(fkLimit instanceof com.scudata.dm.query.metadata.Table) || !fkLimit.equals(table)) break block15;
                ForeignKeyList fkList = table.getForeignKeyList();
                if (fkList == null || fkList.isEmpty()) break block14;
                for (ForeignKey fk : fkList) {
                    FieldList fl;
                    if (fk == null || (fl = fk.getFieldList()) == null || fl.size() <= 1) continue;
                    objList = new ArrayList();
                    objList.add(table.getName());
                    objList.add(fk.getName());
                    Object[] objs2 = new Object[objList.size()];
                    objList.toArray(objs2);
                    this._$2.add(objs2);
                }
                break block14;
            }
            if (pkLimit && table.getPKFieldList() != null && depth > 0) {
                depth = 0;
            }
            if (fkLimit != null && fkLimit instanceof ForeignKey && ((ForeignKey)fkLimit).getFieldList() != null && depth > 0) {
                depth = 0;
            }
            if ((genericFieldList = this._$1(table, depth)) != null && !genericFieldList.isEmpty()) {
                for (List<Object> genericField : genericFieldList) {
                    com.scudata.dm.query.metadata.Table dim;
                    if (genericField == null || genericField.isEmpty()) continue;
                    Object tail = genericField.get(genericField.size() - 1);
                    Field fd = tail instanceof LevelFunction ? ((LevelFunction)tail).getDestDim() : (Field)tail;
                    com.scudata.dm.query.metadata.Table table2 = dim = fd.getDim() == null ? null : fd.getDim().getTable();
                    if (dimLimit != null && (dim == null || !dimLimit.equals(dim)) || pkLimit && table.getPKFieldList() != null && !table.getPKFieldList().contains(fd) || fkLimit != null && fkLimit instanceof ForeignKey && ((ForeignKey)fkLimit).getFieldList() != null && !((ForeignKey)fkLimit).getFieldList().contains(fd)) continue;
                    objList = new ArrayList();
                    objList.add(fd.getTable().getName());
                    LinkedHashMap<String, String> tableAliasNameMap = new LinkedHashMap<String, String>();
                    for (com.scudata.dm.query.metadata.Table t : this._$1.getTableList()) {
                        tableAliasNameMap.put(t.getName(), t.getName());
                    }
                    objList.add(LogicList.getGenericFieldName(tableAliasNameMap, genericField));
                    if (infoList != null && !infoList.isEmpty()) {
                        Iterator<Object> i$ = infoList.iterator();
                        while (i$.hasNext()) {
                            int info = (Integer)i$.next();
                            if (info == 1) {
                                objList.add(dim == null || dim.getName() == null ? "" : dim.getName());
                                continue;
                            }
                            if (info != 2) continue;
                            int dataType = fd.getDataType();
                            objList.add(dataType);
                        }
                    }
                    Object[] objs = new Object[objList.size()];
                    objList.toArray(objs);
                    this._$2.add(objs);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        for (Object[] results : this.getResult()) {
            if (stb.length() > 0) {
                stb.append("\n");
            }
            StringBuffer tmp = new StringBuffer();
            for (Object result : results) {
                if (tmp.length() > 0) {
                    tmp.append("\t");
                }
                tmp.append(result.toString());
            }
            stb.append(tmp.toString());
        }
        return stb.toString();
    }

    public Table toTable() {
        List<Object[]> resultList = this._$2;
        int len = resultList.size();
        if (len == 0) {
            return null;
        }
        Object[] objs = resultList.get(0);
        int fcount = objs.length;
        String[] names = new String[fcount];
        for (int f = 0; f < fcount; ++f) {
            names[f] = (String)objs[f];
        }
        Table result = new Table(names, len);
        for (int i = 1; i < len; ++i) {
            objs = resultList.get(i);
            result.newLast(objs);
        }
        return result;
    }

    public List<Object[]> getResult() {
        return this._$2;
    }

    public static Object test(String lmdFile, String strDql) throws Exception {
        LogicMetaData lmd = IOUtil.readLogicMetaData(lmdFile);
        lmd.prepare(new Context());
        LogicList list = new LogicList(strDql, lmd);
        return list.getResult();
    }
}

