/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.metadata;

import com.scudata.common.ICloneable;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.query.metadata.IJSONObject;
import com.scudata.dm.query.metadata.TableItem;
import com.scudata.dm.query.resources.ParseMessage;
import com.scudata.dm.query.utils.JsonUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassItem
implements IJSONObject,
ICloneable,
Externalizable {
    private static final long serialVersionUID = 1L;
    public final transient String className = ClassItem.class.getName();
    private String _$3 = "";
    private List<TableItem> _$2 = null;
    private List<String> _$1 = null;

    public String getName() {
        return this._$3;
    }

    public void setName(String name) {
        this._$3 = name;
    }

    public List<String> getTableItemNameList() {
        if (this._$2 == null) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        int size = this._$2.size();
        for (int i = 0; i < size; ++i) {
            nameList.add(this._$2.get(i).getName());
        }
        return nameList;
    }

    public List<TableItem> getTableItemList() {
        return this._$2;
    }

    public void setTableItemList(List<TableItem> tableItemList) {
        this._$2 = tableItemList;
    }

    public TableItem getTableItem(int index) {
        if (this._$2 == null) {
            return null;
        }
        return this._$2.get(index);
    }

    public TableItem getTableItem(String tableItemName) {
        if (this._$2 == null || tableItemName == null) {
            return null;
        }
        int iCount = this._$2.size();
        for (int i = 0; i < iCount; ++i) {
            TableItem item = this._$2.get(i);
            if (item == null || !tableItemName.equalsIgnoreCase(item.getName())) continue;
            return item;
        }
        return null;
    }

    public List<String> getDimItemNameList() {
        return this._$1;
    }

    public void setDimItemNameList(List<String> dimItemNameList) {
        this._$1 = dimItemNameList;
    }

    public Object deepClone() {
        ClassItem ci = new ClassItem();
        ci.setName(this._$3);
        if (this._$2 != null) {
            ArrayList<TableItem> tableItemList = new ArrayList<TableItem>();
            for (TableItem item : this._$2) {
                if (item != null) {
                    tableItemList.add((TableItem)item.deepClone());
                    continue;
                }
                tableItemList.add(null);
            }
            ci.setTableItemList(tableItemList);
        }
        if (this._$1 != null) {
            ArrayList<String> dimItemNameList = new ArrayList<String>();
            dimItemNameList.addAll(this._$1);
            ci.setDimItemNameList(dimItemNameList);
        }
        return ci;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._$3 = (String)in.readObject();
        this._$2 = (List)in.readObject();
        this._$1 = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this._$3);
        out.writeObject(this._$2);
        out.writeObject(this._$1);
    }

    @Override
    public void setParamsFromJson(JSONObject jo) {
        int i;
        JSONArray ja;
        if (jo == null) {
            return;
        }
        this._$3 = JsonUtils.getString(jo, "name");
        try {
            ja = jo.getJSONArray("tableItemList");
            if (ja != null) {
                this._$2 = new ArrayList<TableItem>();
                for (i = 0; i < ja.length(); ++i) {
                    TableItem item = new TableItem();
                    item.setParamsFromJson(JsonUtils.getJSONObject(ja.get(i)));
                    this._$2.add(item);
                }
            }
        }
        catch (JSONException je) {
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        try {
            ja = jo.getJSONArray("dimItemNameList");
            if (ja != null) {
                this._$1 = new ArrayList<String>();
                for (i = 0; i < ja.length(); ++i) {
                    this._$1.add(ja.getString(i));
                }
            }
        }
        catch (JSONException je) {
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setParamsFromJson(String json) {
        if (!StringUtils.isValidString((Object)json)) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.invalidJSON") + json);
        }
        JSONObject jo = null;
        try {
            jo = new JSONObject(json);
        }
        catch (JSONException ex) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.invalidJSON") + json, (Throwable)ex);
        }
        this.setParamsFromJson(jo);
    }

    @Override
    public String toJsonString() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("className", (Object)this.className);
        jo.put("name", (Object)this._$3);
        JsonUtils.setList(jo, "tableItemList", this._$2);
        JsonUtils.setList(jo, "dimItemNameList", this._$1);
        return jo.toString();
    }
}

