/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.metadata;

import com.scudata.common.ICloneable;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.query.metadata.AggrItem;
import com.scudata.dm.query.metadata.IJSONObject;
import com.scudata.dm.query.resources.ParseMessage;
import com.scudata.dm.query.utils.JsonUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataItem
implements IJSONObject,
ICloneable,
Externalizable {
    private static final long serialVersionUID = 1L;
    public final transient String className = DataItem.class.getName();
    public String name = "";
    public String objectName = "";
    public String format = "";
    public String alias = "";
    public String[] fakeValues = null;
    public List<AggrItem> aggrItemList = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String on) {
        this.objectName = on;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String fmt) {
        this.format = fmt;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<AggrItem> getAggrItemList() {
        return this.aggrItemList;
    }

    public void setAggrItemList(List<AggrItem> list) {
        this.aggrItemList = list;
    }

    public String[] getFakeValues() {
        return this.fakeValues;
    }

    public void setFakeValues(String[] fakeValues) {
        this.fakeValues = fakeValues;
    }

    public Object deepClone() {
        DataItem di = new DataItem();
        di.setName(this.name);
        di.setObjectName(this.objectName);
        di.setFormat(this.format);
        di.setAlias(this.alias);
        di.setFakeValues(this.fakeValues);
        if (this.aggrItemList != null) {
            ArrayList<AggrItem> aggrItemList = new ArrayList<AggrItem>();
            for (AggrItem item : this.aggrItemList) {
                if (item != null) {
                    aggrItemList.add((AggrItem)item.deepClone());
                    continue;
                }
                aggrItemList.add(null);
            }
            di.setAggrItemList(aggrItemList);
        }
        return di;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.name = (String)in.readObject();
        this.objectName = (String)in.readObject();
        this.format = (String)in.readObject();
        this.alias = (String)in.readObject();
        this.fakeValues = (String[])in.readObject();
        this.aggrItemList = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.name);
        out.writeObject(this.objectName);
        out.writeObject(this.format);
        out.writeObject(this.alias);
        out.writeObject(this.fakeValues);
        out.writeObject(this.aggrItemList);
    }

    @Override
    public void setParamsFromJson(String json) {
        if (!StringUtils.isValidString((Object)json)) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.invalidJSON") + json);
        }
        JSONObject jo = null;
        try {
            jo = new JSONObject(json);
        }
        catch (JSONException ex) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.invalidJSON") + json, (Throwable)ex);
        }
        this.setParamsFromJson(jo);
    }

    @Override
    public void setParamsFromJson(JSONObject jo) {
        JSONArray ja;
        if (jo == null) {
            return;
        }
        this.name = JsonUtils.getString(jo, "name");
        this.objectName = JsonUtils.getString(jo, "objectName");
        this.format = JsonUtils.getString(jo, "format");
        this.alias = JsonUtils.getString(jo, "alias");
        try {
            ja = jo.getJSONArray("fakeValues");
            if (ja != null) {
                int size = ja.length();
                this.fakeValues = new String[size];
                for (int i = 0; i < size; ++i) {
                    this.fakeValues[i] = ja.getString(i);
                }
            }
        }
        catch (JSONException je) {
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        try {
            ja = jo.getJSONArray("aggrItemList");
            if (ja != null) {
                this.aggrItemList = new ArrayList<AggrItem>();
                for (int i = 0; i < ja.length(); ++i) {
                    AggrItem item = new AggrItem();
                    item.setParamsFromJson(JsonUtils.getJSONObject(ja.get(i)));
                    this.aggrItemList.add(item);
                }
            }
        }
        catch (JSONException je) {
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String toJsonString() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("className", (Object)this.className);
        jo.put("name", (Object)this.name);
        jo.put("objectName", (Object)this.objectName);
        jo.put("format", (Object)this.format);
        jo.put("alias", (Object)this.alias);
        JsonUtils.setStringArray(jo, "fakeValues", this.fakeValues);
        JsonUtils.setList(jo, "aggrItemList", this.aggrItemList);
        return jo.toString();
    }
}

