/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.metadata;

import com.scudata.common.ICloneable;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.query.metadata.ErrorData;
import com.scudata.dm.query.metadata.FieldList;
import com.scudata.dm.query.metadata.ForeignKey;
import com.scudata.dm.query.metadata.ForeignKeyList;
import com.scudata.dm.query.metadata.IField;
import com.scudata.dm.query.metadata.IJSONObject;
import com.scudata.dm.query.metadata.LevelFunction;
import com.scudata.dm.query.metadata.LevelFunctionList;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.resources.ParseMessage;
import com.scudata.dm.query.utils.JsonUtils;
import com.scudata.pseudo.Pseudo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
implements IJSONObject,
ICloneable,
Externalizable,
IField {
    private static final long serialVersionUID = 1L;
    private static final Field _$13 = new Field();
    private String _$12 = "";
    private String _$11 = "";
    private int _$10 = 0;
    private LevelFunctionList _$9 = new LevelFunctionList();
    private transient Table _$8 = null;
    private transient ForeignKeyList _$7 = new ForeignKeyList();
    private transient ForeignKeyList _$6 = new ForeignKeyList();
    private transient Field _$5 = null;
    private transient boolean _$4 = false;
    private transient LevelFunctionList _$3 = new LevelFunctionList();
    private transient LogicMetaData _$2 = null;
    private transient boolean _$1 = false;

    public Field() {
    }

    public Field(LogicMetaData lmd) {
        this._$2 = lmd;
    }

    @Override
    public String getName() {
        return this._$12;
    }

    public void setName(String name) {
        this._$12 = name;
    }

    @Override
    public boolean isEquals(String fieldName) {
        return LogicMetaData.equalSymbol(this._$12, fieldName);
    }

    public String getSource() {
        return this._$11;
    }

    public void setSource(String ds) {
        this._$11 = ds;
    }

    public int getDataType() {
        return this._$10;
    }

    public void setDataType(int dt) {
        this._$10 = dt;
    }

    public LevelFunctionList getLevelFunctionList() {
        return this._$9;
    }

    public void setLevelFunctionList(LevelFunctionList list) {
        this._$9 = list;
    }

    public LevelFunctionList getLevelFunctionRefList() {
        return this._$3;
    }

    @Override
    public Table getTable() {
        return this._$8;
    }

    public void setTable(Table t) {
        this._$8 = t;
    }

    @Override
    public Field getDim() {
        return this._$5;
    }

    public void setDim(Field dim) {
        this._$5 = dim;
    }

    @Override
    public Table getRefTable() {
        if (this._$5 == null) {
            return null;
        }
        Table table = this._$5.getTable();
        if (table.getPKCount() == 1) {
            return table;
        }
        return null;
    }

    public ForeignKeyList getForeignKeyList() {
        return this._$7;
    }

    public ForeignKeyList getForeignKeyRefList() {
        return this._$6;
    }

    void _$2() {
        this._$7.clear();
        this._$6.clear();
        this._$5 = null;
        this._$4 = false;
        this._$3.clear();
    }

    @Override
    public boolean isPrimary() {
        return this._$4;
    }

    public void setPrimary(boolean isPrimary) {
        this._$4 = isPrimary;
    }

    @Override
    public boolean isRefField() {
        if (this._$5 == null || this._$8.getSourceObject() instanceof Pseudo) {
            return false;
        }
        Table dimTable = this._$5.getTable();
        Object dimData = dimTable.getSourceObject();
        if (dimData == null || dimData instanceof Pseudo) {
            return false;
        }
        if (this._$4 && this._$8.getPKFieldList().get(0) == this) {
            return false;
        }
        ForeignKey fk = this._$8.getForeignKeyByName(this._$12);
        if (fk == null) {
            return false;
        }
        FieldList list = fk.getFieldList();
        return list.size() == 1 && list.get(0) == this;
    }

    Field _$1(List<ErrorData> result) {
        if (this._$5 == _$13) {
            MessageManager mm = ParseMessage.get();
            String msg = mm.getMessage("config.fieldCircularRef", (Object)this._$8.getName(), (Object)this._$12);
            ErrorData error = new ErrorData(1, this._$8, msg);
            result.add(error);
            this._$5 = null;
            return null;
        }
        if (this._$5 != null) {
            return this._$5;
        }
        this._$5 = _$13;
        if (this._$7 != null) {
            for (ForeignKey fk : this._$7) {
                int index;
                FieldList fieldList = fk.getFieldList();
                FieldList refFieldList = fk.getRefFieldList();
                if (fieldList == null || refFieldList == null || fieldList.size() != refFieldList.size() || (index = fieldList.indexOf(this)) == -1) continue;
                this._$5 = ((Field)refFieldList.get(index))._$1(result);
                return this._$5;
            }
        }
        this._$5 = this.isPrimary() ? this : null;
        return this._$5;
    }

    Field _$1() {
        if (this._$5 == _$13) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.fieldCircularRef", (Object)this._$8.getName(), (Object)this._$12));
        }
        if (this._$5 != null) {
            return this._$5;
        }
        this._$5 = _$13;
        if (this._$7 != null) {
            for (ForeignKey fk : this._$7) {
                int index;
                FieldList fieldList = fk.getFieldList();
                FieldList refFieldList = fk.getRefFieldList();
                if (fieldList == null || refFieldList == null || fieldList.size() != refFieldList.size() || (index = fieldList.indexOf(this)) == -1) continue;
                this._$5 = ((Field)refFieldList.get(index))._$1();
                return this._$5;
            }
        }
        this._$5 = this.isPrimary() ? this : null;
        return this._$5;
    }

    public LevelFunction getLevelFunctionByName(String lfName) {
        if (this._$5 != null) {
            for (LevelFunction lf : this._$5.getLevelFunctionList()) {
                if (!lf.getName().equalsIgnoreCase(lfName)) continue;
                return lf;
            }
        }
        return null;
    }

    public LogicMetaData getLogicMetaData() {
        return this._$2;
    }

    void _$1(LogicMetaData lmd) {
        this._$2 = lmd;
        for (LevelFunction lf : this._$9) {
            if (lf == null) continue;
            lf._$1(lmd);
        }
    }

    public Object deepClone() {
        Field f = new Field(this._$2);
        f.setName(this._$12);
        f.setSource(this._$11);
        f.setDataType(this._$10);
        if (this._$9 != null) {
            f._$9 = (LevelFunctionList)this._$9.deepClone();
        }
        return f;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._$12 = (String)in.readObject();
        this._$11 = (String)in.readObject();
        this._$10 = in.readInt();
        this._$9 = (LevelFunctionList)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this._$12);
        out.writeObject(this._$11);
        out.writeInt(this._$10);
        out.writeObject(this._$9);
    }

    @Override
    public void setParamsFromJson(String json) {
        if (!StringUtils.isValidString((Object)json)) {
            throw new RQException("\u65e0\u6548\u7684json\u4e32:" + json);
        }
        JSONObject jo = null;
        try {
            jo = new JSONObject(json);
        }
        catch (JSONException ex) {
            throw new RQException("\u65e0\u6548\u7684json\u4e32:" + json, (Throwable)ex);
        }
        this.setParamsFromJson(jo);
    }

    @Override
    public void setParamsFromJson(JSONObject jo) {
        if (jo == null) {
            return;
        }
        if (jo.has("type")) {
            this._$10 = JsonUtils.getInt(jo, "type");
        } else if (jo.has("dataType")) {
            int dataType = JsonUtils.getInt(jo, "dataType");
            this._$10 = LogicMetaData.getTypeBySQLType(dataType);
        }
        try {
            JSONArray ja = jo.getJSONArray("levelList");
            if (ja != null) {
                this._$9.clear();
                for (int i = 0; i < ja.length(); ++i) {
                    LevelFunction lv = new LevelFunction(this._$2);
                    lv.setParamsFromJson(JsonUtils.getJSONObject(ja.get(i)));
                    this._$9.add(lv);
                }
            }
        }
        catch (JSONException je) {
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        this._$12 = JsonUtils.getString(jo, "name");
        this._$11 = JsonUtils.getString(jo, "source");
        if (this._$8 != null) {
            boolean isPK;
            if (jo.has("formatExp")) {
                String dimFormatExp = JsonUtils.getString(jo, "formatExp");
                this._$8.setDimFormatExp(dimFormatExp);
            }
            if (jo.has("pattern")) {
                String dimPattern = JsonUtils.getString(jo, "pattern");
                this._$8.setDimPattern(dimPattern);
            }
            if (jo.has("isPK") && (isPK = JsonUtils.getBoolean(jo, "isPK"))) {
                List<String> pkNames = this._$8.getPK();
                if (pkNames == null) {
                    pkNames = new ArrayList<String>();
                    this._$8.setPK(pkNames);
                }
                pkNames.add(this._$12);
            }
            if (jo.has("dimType")) {
                int reportDimType = JsonUtils.getInt(jo, "dimType");
                int dimType = 0;
                switch (reportDimType) {
                    case 1: {
                        dimType = 1;
                        break;
                    }
                    case 2: {
                        dimType = 2;
                        break;
                    }
                    case 3: {
                        dimType = 3;
                        break;
                    }
                    case 4: {
                        dimType = 4;
                        break;
                    }
                    case 5: {
                        dimType = 5;
                        break;
                    }
                    case 6: {
                        dimType = 6;
                    }
                }
                this._$8.setDimType(dimType);
            }
        }
    }

    @Override
    public String toJsonString() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("type", this._$10);
        JsonUtils.setList(jo, "levelList", this._$9);
        jo.put("name", (Object)this._$12);
        jo.put("source", (Object)this._$11);
        return jo.toString();
    }

    @Override
    public boolean isJoined() {
        return this._$1;
    }

    void _$1(boolean isJoined) {
        this._$1 = isJoined;
    }

    @Override
    public boolean isAggrField() {
        return this._$5 == null && this._$10 >= 1 && this._$10 <= 7;
    }
}

