/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.dm.query.sqlplus.ITable;
import com.scudata.dm.query.sqlplus.Select;
import java.util.ArrayList;
import java.util.List;

class And {
    private Select.Exp exp;
    private List<Select.FieldNode> fieldList;
    private List<ITable> tableList;

    public And(Select.Exp exp, List<Select.FieldNode> fieldList) {
        this.exp = exp;
        this.fieldList = fieldList;
        if (fieldList != null) {
            this.tableList = new ArrayList<ITable>();
            for (Select.FieldNode field : fieldList) {
                ITable table = field.getTable();
                if (this.tableList.contains(table)) continue;
                this.tableList.add(table);
            }
        }
    }

    public boolean containTable(ITable table) {
        return this.tableList != null && this.tableList.contains(table);
    }

    public boolean isSingleTable(ITable table) {
        return this.tableList != null && this.tableList.size() == 1 && this.tableList.contains(table);
    }

    public boolean isTable(ITable leftTable, ITable rightTable) {
        if (this.tableList == null || this.tableList.size() != 2) {
            return false;
        }
        return this.tableList.contains(leftTable) && this.tableList.contains(rightTable);
    }

    public boolean isTable(List<ITable> tableList) {
        List<ITable> list = this.tableList;
        if (list != null) {
            for (ITable table : list) {
                if (tableList.contains(table)) continue;
                return false;
            }
        }
        return true;
    }

    public Select.Exp getExp() {
        return this.exp;
    }

    public void setExp(Select.Exp exp) {
        this.exp = exp;
    }

    public List<Select.FieldNode> getFieldList() {
        return this.fieldList;
    }

    public List<ITable> getTableList() {
        return this.tableList;
    }
}

