/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.DataStruct;
import com.scudata.dm.query.sqlplus.ITable;
import com.scudata.dm.query.sqlplus.Select;
import com.scudata.resources.ParseMessage;
import java.util.ArrayList;
import java.util.List;

class Column {
    private Select select;
    private Select.Exp exp;
    private String aliasName;
    private String tableName;

    public Column(Select select, Select.Exp exp, String aliasName) {
        this.select = select;
        this.exp = exp;
        this.aliasName = aliasName == null ? exp.getFieldName() : aliasName;
    }

    public Column(Select select, String tableName) {
        this.select = select;
        this.tableName = tableName;
    }

    public boolean isEquals(String name) {
        return this.aliasName != null && Select.isEquals(this.aliasName, name);
    }

    public boolean isEquals(Select.Exp exp) {
        return this.exp != null && this.exp.isEquals(exp);
    }

    public Select.Exp getExp() {
        return this.exp;
    }

    public void setExp(Select.Exp exp) {
        this.exp = exp;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isAllFields() {
        return this.exp == null;
    }

    public ArrayList<ITable> getAllTables() {
        ArrayList<ITable> tableList = new ArrayList<ITable>();
        if (this.tableName == null) {
            this.select.getFrom().getAllTables(tableList);
        } else {
            ITable table = this.select.getFromTable(this.tableName);
            if (table == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(this.tableName) + mm.getMessage("syntax.unknownTable"));
            }
            tableList.add(table);
        }
        return tableList;
    }

    public void getResultField(List<String> nameList) {
        if (this.exp != null) {
            nameList.add(this.aliasName);
        } else if (this.tableName != null) {
            String[] names;
            ITable table = this.select.getFromTable(this.tableName);
            if (table == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(this.tableName) + mm.getMessage("syntax.unknownTable"));
            }
            DataStruct ds = table.getDataStruct();
            String[] stringArray = names = ds.getFieldNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                nameList.add(name);
                ++n2;
            }
        } else {
            ArrayList<ITable> tableList = new ArrayList<ITable>();
            this.select.getFrom().getAllTables(tableList);
            for (ITable table : tableList) {
                String[] names;
                DataStruct ds = table.getDataStruct();
                String[] stringArray = names = ds.getFieldNames();
                int n = names.length;
                int n3 = 0;
                while (n3 < n) {
                    String name = stringArray[n3];
                    nameList.add(name);
                    ++n3;
                }
            }
        }
    }

    public void analyseFieldNode() {
        if (this.exp != null) {
            return;
        }
        if (this.tableName != null) {
            ITable table = this.select.getFromTable(this.tableName);
            if (table == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(this.tableName) + mm.getMessage("syntax.unknownTable"));
            }
            table.addUsedField(null);
        } else {
            ArrayList<ITable> tableList = new ArrayList<ITable>();
            this.select.getFrom().getAllTables(tableList);
            for (ITable table : tableList) {
                table.addUsedField(null);
            }
        }
    }

    public String toSPL() {
        List<Select.Exp> byList = this.select.getGroupBy();
        if (byList != null) {
            int byCount = byList.size();
            int i = 0;
            while (i < byCount) {
                Select.Exp byExp = byList.get(i);
                if (byExp.isEquals(this.exp)) {
                    return "#" + (i + 1);
                }
                ++i;
            }
            return this.exp.toSPL(byCount);
        }
        if (this.select.getGatherCount() > 0) {
            return this.exp.toSPL(0);
        }
        return this.exp.toSPL();
    }
}

