/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.query.sqlplus.And;
import com.scudata.dm.query.sqlplus.ITable;
import com.scudata.dm.query.sqlplus.Join;
import com.scudata.dm.query.sqlplus.Select;
import com.scudata.expression.Expression;
import com.scudata.util.CursorUtil;
import java.util.ArrayList;
import java.util.List;

class ImplicitJoin {
    private ArrayList<And> andList = new ArrayList();
    private ITable leftTable;
    private ITable rightTable;
    private ArrayList<ImplicitJoin> leftTableJoinList = new ArrayList();
    private ArrayList<ImplicitJoin> rightTableJoinList = new ArrayList();
    private boolean isRightDimTable = false;

    public ImplicitJoin(And and) {
        this.andList.add(and);
        List<ITable> tableList = and.getTableList();
        this.leftTable = tableList.get(0);
        this.rightTable = tableList.get(1);
    }

    public void addLeftTableJoin(ImplicitJoin join) {
        this.leftTableJoinList.add(join);
    }

    public void addRightTableJoin(ImplicitJoin join) {
        this.rightTableJoinList.add(join);
    }

    public boolean putJoinRelation(And and) {
        List<ITable> tableList = and.getTableList();
        if (tableList.contains(this.leftTable) && tableList.contains(this.rightTable)) {
            this.andList.add(and);
            return true;
        }
        return false;
    }

    public ITable getLeftTable() {
        return this.leftTable;
    }

    public ITable getRightTable() {
        return this.rightTable;
    }

    public ArrayList<And> getAndList() {
        return this.andList;
    }

    public boolean isRightDimTable() {
        return this.isRightDimTable;
    }

    public void analyzeDimTable() {
        List<Select.FieldNode> fieldList;
        String pk;
        int n;
        int n2;
        String[] stringArray;
        boolean sign;
        String[] leftPKs = this.leftTable.getPrimaryKey();
        String[] rightPKs = this.rightTable.getPrimaryKey();
        if (rightPKs != null && rightPKs.length > 0) {
            sign = true;
            stringArray = rightPKs;
            n2 = rightPKs.length;
            n = 0;
            while (n < n2) {
                block12: {
                    pk = stringArray[n];
                    for (And and : this.andList) {
                        fieldList = and.getFieldList();
                        for (Select.FieldNode field : fieldList) {
                            if (field.getTable() != this.rightTable || !field.isEqualField(pk)) {
                                continue;
                            }
                            break block12;
                        }
                    }
                    sign = false;
                    break;
                }
                ++n;
            }
            if (sign) {
                this.isRightDimTable = true;
            }
        }
        if (!this.isRightDimTable && leftPKs != null && leftPKs.length > 0) {
            sign = true;
            stringArray = leftPKs;
            n2 = leftPKs.length;
            n = 0;
            while (n < n2) {
                block13: {
                    pk = stringArray[n];
                    for (And and : this.andList) {
                        fieldList = and.getFieldList();
                        for (Select.FieldNode field : fieldList) {
                            if (field.getTable() != this.leftTable || !field.isEqualField(pk)) {
                                continue;
                            }
                            break block13;
                        }
                    }
                    sign = false;
                    break;
                }
                ++n;
            }
            if (sign) {
                ITable table = this.leftTable;
                this.leftTable = this.rightTable;
                this.rightTable = table;
                this.isRightDimTable = true;
            }
        }
    }

    private void setJoinFieldName(String fieldName) {
        this.rightTable.setJoinFieldName(fieldName);
        for (ImplicitJoin join : this.rightTableJoinList) {
            join.setJoinFieldName(fieldName);
        }
    }

    private void setRightTableJoinFieldName(String fieldName) {
        for (ImplicitJoin join : this.rightTableJoinList) {
            join.setJoinFieldName(fieldName);
        }
    }

    private void setLeftTableJoinFieldName(String fieldName) {
        for (ImplicitJoin join : this.leftTableJoinList) {
            join.setJoinFieldName(fieldName);
        }
    }

    public Object join(Object leftData, Object rightData, String joinFieldName, Context ctx) {
        ArrayList<Expression> leftExpList = new ArrayList<Expression>();
        ArrayList<Expression> rightExpList = new ArrayList<Expression>();
        ArrayList<Select.Exp> xjoinFilterList = new ArrayList<Select.Exp>();
        for (And and : this.andList) {
            Select.Exp exp = and.getExp();
            xjoinFilterList.add(exp);
            if (leftExpList == null || exp.splitJionExp(this.leftTable, this.rightTable, leftExpList, rightExpList)) continue;
            leftExpList = null;
            rightExpList = null;
        }
        if (leftExpList == null) {
            Sequence leftSeq = Join.toSequence(leftData);
            if (leftSeq == null || leftSeq.length() == 0) {
                return null;
            }
            Sequence rightSeq = Join.toSequence(rightData);
            if (rightSeq == null || leftSeq.length() == 0) {
                return null;
            }
            Sequence[] sequences = new Sequence[]{leftSeq, rightSeq};
            String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
            Expression[] exps = new Expression[2];
            this.leftTable.setJoinFieldName(names[0]);
            if (xjoinFilterList.size() > 0) {
                exps[1] = Join.toExpression(xjoinFilterList, ctx);
            }
            Table result = Sequence.xjoin((Sequence[])sequences, (Expression[])exps, null, (String[])names, null, (Context)ctx);
            this.rightTable.setJoinFieldName(names[1]);
            this.setLeftTableJoinFieldName(names[0]);
            this.setRightTableJoinFieldName(names[1]);
            if (result == null || result.length() == 0) {
                return null;
            }
            return result;
        }
        int fcount = leftExpList.size();
        Expression[] leftJoinExps = new Expression[fcount];
        Expression[] rightJoinExps = new Expression[fcount];
        leftExpList.toArray(leftJoinExps);
        rightExpList.toArray(rightJoinExps);
        if (this.rightTable.isPrimaryKey(rightJoinExps)) {
            ICursor leftCursor = Join.toCursor(leftData);
            if (leftCursor == null) {
                return null;
            }
            Expression[][] exps = new Expression[][]{leftJoinExps};
            Expression[][] codeExps = new Expression[][]{rightJoinExps};
            Expression[][] newExps = new Expression[][]{{new Expression("~")}};
            String[][] newNames = new String[][]{{joinFieldName}};
            if (this.rightTable.isSortedFields(rightJoinExps) && this.leftTable.isSortedFields(leftJoinExps)) {
                ICursor rightCursor = Join.toCursor(rightData);
                if (rightCursor == null) {
                    return null;
                }
                ICursor[] cursors = new ICursor[]{rightCursor};
                leftCursor = (ICursor)leftCursor.mergeJoinx(null, (Expression[][])exps, cursors, (Expression[][])codeExps, (Expression[][])newExps, newNames, "i", ctx);
            } else {
                Sequence rightSequence = Join.toSequence(rightData);
                if (rightSequence == null) {
                    return null;
                }
                Sequence[] codes = new Sequence[]{rightSequence};
                leftCursor = (ICursor)leftCursor.join(null, null, (Expression[][])exps, codes, (Expression[][])codeExps, (Expression[][])newExps, newNames, "i", ctx);
            }
            this.rightTable.setJoinFieldName(joinFieldName);
            this.setRightTableJoinFieldName(joinFieldName);
            return leftCursor;
        }
        if (this.rightTable.isSortedFields(rightJoinExps) && this.leftTable.isSortedFields(leftJoinExps)) {
            ICursor leftCursor = Join.toCursor(leftData);
            if (leftCursor == null) {
                return null;
            }
            ICursor rightCursor = Join.toCursor(rightData);
            if (rightCursor == null) {
                return null;
            }
            ICursor[] cursors = new ICursor[]{leftCursor, rightCursor};
            String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
            Expression[][] exps = new Expression[][]{leftJoinExps, rightJoinExps};
            ICursor cs = CursorUtil.joinx((ICursor[])cursors, (String[])names, (Expression[][])exps, null, (Context)ctx);
            this.leftTable.setJoinFieldName(names[0]);
            this.rightTable.setJoinFieldName(names[1]);
            this.setLeftTableJoinFieldName(names[0]);
            this.setRightTableJoinFieldName(names[1]);
            return cs;
        }
        Sequence leftSeq = Join.toSequence(leftData);
        if (leftSeq == null) {
            return null;
        }
        Sequence rightSeq = Join.toSequence(rightData);
        if (rightSeq == null) {
            return null;
        }
        Sequence[] sequences = new Sequence[]{leftSeq, rightSeq};
        String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
        Expression[][] totalExps = new Expression[][]{leftJoinExps, rightJoinExps};
        Table result = Sequence.join((Sequence[])sequences, (Expression[][])totalExps, (String[])names, null, (Context)ctx);
        this.leftTable.setJoinFieldName(names[0]);
        this.rightTable.setJoinFieldName(names[1]);
        this.setLeftTableJoinFieldName(names[0]);
        this.setRightTableJoinFieldName(names[1]);
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }
}

