/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.Param;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.Calculate;
import com.scudata.dm.op.Conj;
import com.scudata.dm.op.Operation;
import com.scudata.dm.query.resources.ParseMessage;
import com.scudata.dm.query.sqlplus.And;
import com.scudata.dm.query.sqlplus.Column;
import com.scudata.dm.query.sqlplus.IQuery;
import com.scudata.dm.query.sqlplus.ITable;
import com.scudata.dm.query.sqlplus.IlllIlIIIllllllI;
import com.scudata.dm.query.sqlplus.Join;
import com.scudata.dm.query.sqlplus.SetOperation;
import com.scudata.dm.query.sqlplus.SortItem;
import com.scudata.dm.query.sqlplus.Statement;
import com.scudata.dm.query.sqlplus.SubQuery;
import com.scudata.dm.query.sqlplus.TableNode;
import com.scudata.dm.query.sqlplus.Token;
import com.scudata.dm.query.sqlplus.Tokenizer;
import com.scudata.dm.query.sqlplus.With;
import com.scudata.dm.query.sqlplus.lIllIlllIIIIlIll;
import com.scudata.dm.query.sqlplus.llIIIIIIIlllIlll;
import com.scudata.dm.query.sqlplus.llIIIllllIIlIlII;
import com.scudata.dm.query.sqlplus.llIllIllIIIlIlll;
import com.scudata.dm.query.sqlplus.lllIIIIllIllIIlI;
import com.scudata.expression.Expression;
import com.scudata.pseudo.Pseudo;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.ArrayList;
import java.util.List;

class Select
extends IQuery {
    private Statement statement;
    private With with;
    private Select parent;
    private Token[] tokens;
    private int start;
    private int next;
    private Context ctx;
    private boolean distinct;
    private List<Column> columnList = new ArrayList<Column>();
    private ITable from;
    private Exp where;
    private List<Exp> groupBy;
    private Exp having;
    private List<SortItem> orderBy;
    private int limit;
    private int offset;
    private DataStruct dataStruct;
    private ArrayList<FieldNode> fieldList = new ArrayList();
    private ArrayList<GatherNode> gatherList = new ArrayList();
    private ArrayList<WindowFunction> windowList = new ArrayList();
    private int level = 0;
    private boolean fieldState = false;
    private static final String[] FROMKEYS = new String[]{"JOIN", "ON", "CROSS", "INNER", "LEFT", "RIGHT", "FULL", "WHERE", "GROUP", "HAVING", "ORDER", "LIMIT", "OFFSET"};

    public Select(Statement statement, Token[] tokens, int start, int next, Context ctx) {
        this.statement = statement;
        this.tokens = tokens;
        this.ctx = ctx;
        this.start = start;
        this.next = next;
        this.scanSelect(tokens, start, next);
    }

    public Select(Statement statement, With with, Token[] tokens, int start, int next, Context ctx) {
        this.statement = statement;
        this.with = with;
        this.tokens = tokens;
        this.ctx = ctx;
        this.start = start;
        this.next = next;
        this.scanSelect(tokens, start, next);
    }

    public Select(Select parent, Token[] tokens, int start, int next) {
        this.statement = parent.statement;
        this.with = parent.with;
        this.parent = parent;
        this.ctx = parent.ctx;
        this.tokens = tokens;
        this.start = start;
        this.next = next;
        this.scanSelect(tokens, start, next);
    }

    @Override
    public IQuery dup() {
        return new Select(this.statement, this.with, this.tokens, this.start, this.next, this.ctx);
    }

    public Context getContext() {
        return this.ctx;
    }

    public static boolean isEquals(Exp src, Exp dest) {
        if (src == dest) {
            return true;
        }
        if (src == null || dest == null) {
            return false;
        }
        return src.isEquals(dest);
    }

    public static boolean isEquals(String src, String dest) {
        return src.equalsIgnoreCase(dest);
    }

    public int getLevel() {
        return this.level;
    }

    private int scanNextCaseKeyWord(Token[] tokens, int start, int next) {
        int pos = Tokenizer.scanKeyWord("WHEN", tokens, start, next);
        if (pos != -1) {
            return pos;
        }
        pos = Tokenizer.scanKeyWord("ELSE", tokens, start, next);
        if (pos != -1) {
            return pos;
        }
        return Tokenizer.scanKeyWord("END", tokens, start, next);
    }

    private Case scanCase(Token[] tokens, int start, int next, Part part) {
        int pos;
        int casePos = start++;
        if (start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
        }
        Exp field = null;
        ArrayList<Exp> whenList = new ArrayList<Exp>();
        ArrayList<Exp> thenList = new ArrayList<Exp>();
        Exp defaultExp = null;
        if (!tokens[start].isKeyWord("WHEN")) {
            pos = Tokenizer.scanKeyWord("WHEN", tokens, start + 1, next);
            if (pos == -1) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
            }
            field = this.scanExp(tokens, start, pos, part);
            start = pos;
        }
        while (true) {
            MessageManager mm;
            if (start == next) {
                MessageManager mm2 = ParseMessage.get();
                throw new RQException(String.valueOf(mm2.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            if (tokens[start].isKeyWord("WHEN")) {
                if ((pos = Tokenizer.scanKeyWord("THEN", tokens, ++start, next)) == -1) {
                    mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
                }
                Exp when = this.scanExp(tokens, start, pos, part);
                start = pos + 1;
                if ((pos = this.scanNextCaseKeyWord(tokens, start, next)) == -1) {
                    MessageManager mm3 = ParseMessage.get();
                    throw new RQException(String.valueOf(mm3.getMessage("syntax.error")) + tokens[start].getPos());
                }
                Exp then = this.scanExp(tokens, start, pos, part);
                whenList.add(when);
                thenList.add(then);
                start = pos;
                continue;
            }
            if (!tokens[start].isKeyWord("ELSE")) break;
            pos = Tokenizer.scanKeyWord("END", tokens, start, next);
            if (pos == -1) {
                mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
            }
            defaultExp = this.scanExp(tokens, ++start, pos, part);
            start = pos;
        }
        if (tokens[start].isKeyWord("END")) {
            return new Case(casePos, start + 1, field, whenList, thenList, defaultExp);
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
    }

    private void combineNot(List<Exp> exps) {
        int i = 0;
        int size = exps.size();
        while (i < size) {
            Exp exp = exps.get(i);
            if (exp instanceof Not) {
                Not not = (Not)exp;
                int start = i + 1;
                int next = size;
                int j = i + 1;
                while (j < size) {
                    exp = exps.get(j);
                    if (exp.isLogicalOperator()) {
                        next = j;
                        break;
                    }
                    ++j;
                }
                int count = next - start;
                if (count == 1) {
                    exp = exps.remove(start);
                    not.setExp(exp);
                } else if (count > 1) {
                    ArrayList<Exp> list = new ArrayList<Exp>(count);
                    int j2 = 0;
                    while (j2 < count) {
                        list.add(exps.remove(start));
                        ++j2;
                    }
                    exp = new LogicExp(list);
                    not.setExp(exp);
                } else {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + not.getPos());
                }
                size -= count;
            }
            ++i;
        }
    }

    private Exp removeLastNot(List<Exp> exps) {
        int last = exps.size() - 1;
        if (last >= 0 && exps.get(last) instanceof Not) {
            return exps.remove(last);
        }
        return null;
    }

    private Exp removeLastLogic(List<Exp> exps, String errorInfo) {
        int size = exps.size();
        int start = size - 1;
        while (start >= 0) {
            if (exps.get(start).isLogicalOperator()) break;
            --start;
        }
        int count = size - ++start;
        if (count == 1) {
            return exps.remove(start);
        }
        if (count > 1) {
            ArrayList<Exp> list = new ArrayList<Exp>(count);
            int i = start;
            while (i < size) {
                list.add(exps.remove(start));
                ++i;
            }
            return new LogicExp(list);
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + errorInfo);
    }

    private List<Exp> scanParam(Token[] tokens, int start, int next, Part part) {
        ArrayList<Exp> exps = new ArrayList<Exp>();
        while (start < next) {
            Exp param;
            int comma = Tokenizer.scanComma(tokens, start, next);
            if (comma < 0) {
                param = this.scanExp(tokens, start, next, part);
                exps.add(param);
                break;
            }
            param = this.scanExp(tokens, start, comma, part);
            exps.add(param);
            start = comma + 1;
            if (start != next) continue;
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("function.paramError")) + tokens[comma].getPos());
        }
        return exps;
    }

    private GatherNode addGatherNode(GatherNode gather) {
        for (GatherNode node : this.gatherList) {
            if (!node.isEquals(gather)) continue;
            return node;
        }
        this.gatherList.add(gather);
        gather.setFieldSeq(this.gatherList.size());
        return gather;
    }

    private void addWindow(WindowFunction windowFunction) {
        for (WindowFunction func : this.windowList) {
            if (func.isCompatibal(windowFunction)) continue;
            throw new RQException("The window functions are incompatible.");
        }
        this.gatherList.remove(windowFunction.getLeftFunction());
        this.windowList.add(windowFunction);
    }

    private Function scanFunction(Token[] tokens, int start, int end, Part part) {
        String fnName = tokens[start].getOriginString();
        String opt = null;
        int pos = start + 1;
        if (tokens[pos].getType() == '@') {
            opt = tokens[pos].getOriginString();
            pos += 2;
        } else {
            ++pos;
        }
        if (Tokenizer.isGatherFunction(fnName)) {
            List<Exp> list;
            if (fnName.equalsIgnoreCase("COUNT")) {
                if (tokens[pos].isKeyWord("DISTINCT")) {
                    fnName = "icount";
                    opt = "b";
                    ++pos;
                } else if (tokens[pos].equals("*")) {
                    if (pos + 1 != end) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[pos + 1].getPos());
                    }
                    tokens[pos].setString("1");
                }
            }
            if ((list = this.scanParam(tokens, pos, end, part)).size() != 1) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[pos].getPos());
            }
            Exp param = list.get(0);
            GatherNode gather = new GatherNode(start, end + 1, fnName, opt, param);
            return this.addGatherNode(gather);
        }
        List<Exp> list = this.scanParam(tokens, pos, end, part);
        return new Function(start, end + 1, fnName, opt, list);
    }

    /*
     * Enabled aggressive block sorting
     */
    private WindowFunction scanWindowFunction(Function fn, Token[] tokens, int start, int end, Part part) {
        WindowFunction result;
        String followingExp;
        String precedingExp;
        List<SortItem> orderBy;
        ArrayList<llIIIIIIIlllIlll> partitionBy;
        block27: {
            block28: {
                block30: {
                    block29: {
                        partitionBy = null;
                        orderBy = null;
                        precedingExp = null;
                        followingExp = null;
                        result = new WindowFunction(this, ++start, end, fn);
                        if (tokens[start].equalsIgnoreCase("PARTITION")) {
                            if (++start == end || !tokens[start].isKeyWord("BY")) {
                                MessageManager mm = ParseMessage.get();
                                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
                            }
                            int index = ++start;
                            partitionBy = new ArrayList<llIIIIIIIlllIlll>();
                            while (start <= end) {
                                Exp exp;
                                if (start == end || tokens[start].isKeyWord("ORDER") || tokens[start].equalsIgnoreCase("ROWS") || tokens[start].equalsIgnoreCase("RANGE")) {
                                    exp = this.scanExp(tokens, index, start, part);
                                    partitionBy.add((llIIIIIIIlllIlll)((Object)exp));
                                    break;
                                }
                                if (tokens[start].isComma()) {
                                    exp = this.scanExp(tokens, index, start, part);
                                    partitionBy.add((llIIIIIIIlllIlll)((Object)exp));
                                    index = ++start;
                                    continue;
                                }
                                ++start;
                            }
                        }
                        if (tokens[start].isKeyWord("ORDER")) {
                            if (++start == end || !tokens[start].isKeyWord("BY")) {
                                MessageManager mm = ParseMessage.get();
                                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
                            }
                            int next = end;
                            int i = ++start;
                            while (i < end) {
                                if (tokens[i].equalsIgnoreCase("ROWS") || tokens[i].equalsIgnoreCase("RANGE")) {
                                    next = i;
                                    break;
                                }
                                ++i;
                            }
                            orderBy = this.scanOrderBy(tokens, start, next, part);
                            start = next;
                        }
                        if (!tokens[start].equalsIgnoreCase("ROWS")) break block28;
                        if (++start + 3 > end || !tokens[start].isKeyWord("BETWEEN")) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
                        }
                        if (tokens[++start].equalsIgnoreCase("UNBOUNDED") && tokens[start + 1].equalsIgnoreCase("PRECEDING")) {
                            start += 2;
                        } else if (tokens[start].equalsIgnoreCase("CURRENT") && tokens[start + 1].equalsIgnoreCase("ROW")) {
                            precedingExp = "#";
                            start += 2;
                        } else {
                            if (!tokens[start].isNumber()) {
                                MessageManager mm = ParseMessage.get();
                                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
                            }
                            if (tokens[start + 1].equalsIgnoreCase("PRECEDING")) {
                                precedingExp = "#-" + tokens[start].getString();
                                start += 2;
                            } else if (tokens[start + 1].equalsIgnoreCase("FOLLOWING")) {
                                precedingExp = "#+" + tokens[start].getString();
                                start += 2;
                            } else {
                                precedingExp = tokens[start].getString();
                                ++start;
                            }
                        }
                        if (start + 2 > end || !tokens[start].isKeyWord("AND")) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
                        }
                        if (!tokens[++start].equalsIgnoreCase("UNBOUNDED") || !tokens[start + 1].equalsIgnoreCase("FOLLOWING")) break block29;
                        start += 2;
                        break block27;
                    }
                    if (!tokens[start].equalsIgnoreCase("CURRENT") || !tokens[start + 1].equalsIgnoreCase("ROW")) break block30;
                    followingExp = "#";
                    start += 2;
                    break block27;
                }
                if (!tokens[start].isNumber()) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
                }
                if (tokens[start + 1].equalsIgnoreCase("PRECEDING")) {
                    followingExp = "#-" + tokens[start].getString();
                    start += 2;
                    break block27;
                } else if (tokens[start + 1].equalsIgnoreCase("FOLLOWING")) {
                    followingExp = "#+" + tokens[start].getString();
                    start += 2;
                    break block27;
                } else {
                    followingExp = tokens[start].getString();
                    ++start;
                }
                break block27;
            }
            if (orderBy != null) {
                followingExp = "#";
            }
        }
        if (start != end) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
        }
        result.setPartitionBy(partitionBy);
        result.setOrderBy(orderBy);
        result.setRows(precedingExp, followingExp);
        this.addWindow(result);
        return result;
    }

    private Exp scanExp(Token[] tokens, int start, int next, Part part) {
        ArrayList<Exp> exps = new ArrayList<Exp>();
        Object exp = null;
        boolean hasNot = false;
        int i = start;
        while (i < next) {
            Exp last;
            Token token = tokens[i];
            if (token.getType() == '\u0001') {
                MessageManager mm;
                Function func;
                int pos = i + 1;
                if (pos < next && tokens[pos].getType() == '(') {
                    int end = Tokenizer.scanParen(tokens, pos, next);
                    if (end + 1 < next && tokens[end + 1].equalsIgnoreCase("OVER")) {
                        func = this.scanFunction(tokens, i, end, part);
                        pos = end + 2;
                        if (pos == next || tokens[pos].getType() != '(') {
                            mm = ParseMessage.get();
                            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[end].getPos());
                        }
                        end = Tokenizer.scanParen(tokens, pos, next);
                        exp = this.scanWindowFunction(func, tokens, pos, end, part);
                    } else {
                        exp = this.scanFunction(tokens, i, end, part);
                    }
                    i = end;
                } else if (pos + 1 < next && tokens[pos].getType() == '@' && tokens[pos + 1].getType() == '(') {
                    int end = Tokenizer.scanParen(tokens, pos + 1, next);
                    if (end + 1 < next && tokens[end + 1].equalsIgnoreCase("OVER")) {
                        func = this.scanFunction(tokens, i, end, part);
                        pos = end + 2;
                        if (pos == next || tokens[pos].getType() != '(') {
                            mm = ParseMessage.get();
                            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[end].getPos());
                        }
                        end = Tokenizer.scanParen(tokens, pos, next);
                        exp = this.scanWindowFunction(func, tokens, pos, end, part);
                    } else {
                        exp = this.scanFunction(tokens, i, end, part);
                    }
                    i = end;
                } else if (pos < next && tokens[pos].getType() == '.') {
                    if (++pos == next) {
                        MessageManager mm2 = ParseMessage.get();
                        throw new RQException(String.valueOf(mm2.getMessage("syntax.error")) + tokens[next - 1].getPos());
                    }
                    FieldNode fieldNode = new FieldNode(i, pos + 1, token.getString(), tokens[pos].getString(), part);
                    this.fieldList.add(fieldNode);
                    exp = fieldNode;
                    i = pos;
                } else {
                    FieldNode fieldNode = new FieldNode(i, pos, null, token.getString(), part);
                    this.fieldList.add(fieldNode);
                    exp = fieldNode;
                }
            } else if (token.getType() == '(') {
                int end = Tokenizer.scanParen(tokens, i, next);
                if (tokens[i + 1].isKeyWord("SELECT")) {
                    IQuery query = this.scanQuery(tokens, i + 1, end);
                    exp = new QueryNode(i, end + 1, query);
                } else {
                    exp = this.scanExp(tokens, i + 1, end, part);
                    exp = new Paren(i, end + 1, (Exp)exp);
                }
                i = end;
            } else if (token.isKeyWord("AND")) {
                exp = new CommonNode(i, i + 1, "&&");
            } else if (token.isKeyWord("OR")) {
                exp = new CommonNode(i, i + 1, "||");
            } else if (tokens[i].isKeyWord("NOT")) {
                if (i + 1 == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i].getPos());
                }
                exp = new Not(i, i + 1);
                hasNot = true;
            } else if (token.isKeyWord("LIKE")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                }
                int end = Tokenizer.scanLogicalOperator(tokens, i, next);
                if (end == -1) {
                    end = next;
                }
                Like like = new Like(i, i + 1);
                exp = this.scanExp(tokens, i, end, part);
                like.setRight((Exp)exp);
                last = this.removeLastNot(exps);
                if (last != null) {
                    like.setNot(true);
                }
                last = this.removeLastLogic(exps, "LIKE");
                like.setLeft(last);
                exp = like;
                i = end - 1;
            } else if (token.isKeyWord("IN")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                }
                if (tokens[i].getType() != '(') {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i].getPos());
                }
                int end = Tokenizer.scanParen(tokens, i, next);
                In in = new In(i, end + 1);
                if (tokens[i + 1].isKeyWord("SELECT")) {
                    IQuery query = this.scanQuery(tokens, i + 1, end);
                    in.setRight(query);
                } else {
                    List<Exp> params = this.scanParam(tokens, i + 1, end, part);
                    in.setRight(params);
                }
                last = this.removeLastNot(exps);
                if (last != null) {
                    in.setNot(true);
                }
                last = this.removeLastLogic(exps, "IN");
                in.setLeft(last);
                exp = in;
                i = end;
            } else if (token.isKeyWord("EXISTS")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                }
                if (tokens[i].getType() != '(') {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i].getPos());
                }
                int end = Tokenizer.scanParen(tokens, i, next);
                IQuery query = this.scanQuery(tokens, i + 1, end);
                exp = new Exists(i - 1, end + 1, query);
                i = end;
            } else if (token.isKeyWord("BETWEEN")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                }
                int end = Tokenizer.scanKeyWord("AND", tokens, i, next);
                if (end == -1) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i].getPos());
                }
                Exp from = this.scanExp(tokens, i, end, part);
                i = end + 1;
                if (i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                }
                end = Tokenizer.scanLogicalOperator(tokens, i, next);
                if (end == -1) {
                    end = next;
                }
                Exp to = this.scanExp(tokens, i, end, part);
                Exp not = this.removeLastNot(exps);
                Exp left = this.removeLastLogic(exps, "BETWEEN");
                exp = new Between(left, from, to, not);
                i = end - 1;
            } else if (token.isKeyWord("CASE")) {
                exp = this.scanCase(tokens, i, next, part);
                i = ((Exp)exp).getEnd() - 1;
            } else if (token.isKeyWord("IS")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                }
                Exp left = this.removeLastLogic(exps, "IS");
                if (tokens[i].isKeyWord("NULL")) {
                    exp = new IsNull(i + 1, left, false);
                } else if (tokens[i].isKeyWord("NOT")) {
                    if (++i == next || !tokens[i].isKeyWord("NULL")) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                    }
                    exp = new IsNull(i + 1, left, true);
                }
            } else if (token.equals("!")) {
                if (i + 1 < next && tokens[i + 1].equals("=")) {
                    exp = new CommonNode(i, i + 2, "!=");
                    ++i;
                } else {
                    exp = new CommonNode(i, i + 1, "!");
                }
            } else if (token.equals("=")) {
                if (i + 1 < next && tokens[i + 1].equals("=")) {
                    ++i;
                }
                exp = new CommonNode(i, i + 1, "==");
            } else if (token.equals("<")) {
                if (i + 1 < next && tokens[i + 1].equals(">")) {
                    exp = new CommonNode(i, i + 2, "!=");
                    ++i;
                } else if (i + 1 < next && tokens[i + 1].equals("=")) {
                    exp = new CommonNode(i, i + 2, "<=");
                    ++i;
                } else {
                    exp = new CommonNode(i, i + 1, "<");
                }
            } else if (token.equals(">")) {
                if (i + 1 < next && tokens[i + 1].equals("=")) {
                    exp = new CommonNode(i, i + 2, ">=");
                    ++i;
                } else {
                    exp = new CommonNode(i, i + 1, ">");
                }
            } else if (token.isKeyWord("NULL")) {
                exp = new CommonNode(i, i + 1, "null");
            } else if (token.getType() == '\u0000' && i + 1 < next && tokens[i + 1].getType() == '(') {
                int end = Tokenizer.scanParen(tokens, i + 1, next);
                exp = this.scanFunction(tokens, i, end, part);
                i = end;
            } else if (token.getType() == '\u0000' && i + 2 < next && tokens[i + 1].getType() == '@' && tokens[i + 2].getType() == '(') {
                int end = Tokenizer.scanParen(tokens, i + 2, next);
                exp = this.scanFunction(tokens, i, end, part);
                i = end;
            } else {
                exp = new CommonNode(i, i + 1, token.getString());
            }
            exps.add((Exp)exp);
            ++i;
        }
        if (hasNot) {
            this.combineNot(exps);
        }
        if (exps.size() == 0) {
            return null;
        }
        if (exps.size() == 1) {
            return (Exp)exps.get(0);
        }
        return new LogicExp(exps);
    }

    private void scanSelect(Token[] tokens, int start, int next) {
        int end;
        if (tokens[start].getType() == '(') {
            if (tokens[next - 1].getType() != ')') {
                throw new RuntimeException();
            }
            ++start;
            --next;
        }
        if (!tokens[start].isKeyWord("SELECT")) {
            throw new RuntimeException();
        }
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
        }
        start = this.scanParallel(tokens, start, next);
        int colStart = start = this.scanQuantifies(tokens, start, next);
        int fromPos = -1;
        while (start < next) {
            Token token = tokens[start];
            if (token.isKeyWord("FROM")) {
                fromPos = start;
                break;
            }
            if (token.getType() == '(') {
                start = Tokenizer.scanParen(tokens, start, next);
            }
            ++start;
        }
        if (fromPos == -1) {
            fromPos = next;
            this.scanColumns(tokens, colStart, fromPos);
            return;
        }
        start = this.scanFrom(tokens, fromPos, next);
        this.scanColumns(tokens, colStart, fromPos);
        if (start == next) {
            return;
        }
        String[] keyWords = new String[]{"GROUP", "HAVING", "ORDER", "LIMIT", "OFFSET"};
        if (tokens[start].isKeyWord("WHERE")) {
            if (++start == (end = Tokenizer.scanKeyWords(tokens, start, next, keyWords, 0))) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            this.where = this.scanExp(tokens, start, end, Part.Where);
            if (end == next) {
                return;
            }
            start = end;
        }
        if (tokens[start].isKeyWord("GROUP")) {
            if (++start == next || !tokens[start].isKeyWord("BY")) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            if (++start == (end = Tokenizer.scanKeyWords(tokens, start, next, keyWords, 1))) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            this.scanGroupBy(tokens, start, end);
            if (end == next) {
                return;
            }
            start = end;
        }
        if (tokens[start].isKeyWord("HAVING")) {
            if (++start == (end = Tokenizer.scanKeyWords(tokens, start, next, keyWords, 2))) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            this.having = this.scanExp(tokens, start, end, Part.Having);
            if (end == next) {
                return;
            }
            start = end;
        }
        if (tokens[start].isKeyWord("ORDER")) {
            if (++start == next || !tokens[start].equals("BY")) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            end = Tokenizer.scanKeyWords(tokens, ++start, next, keyWords, 3);
            this.orderBy = this.scanOrderBy(tokens, start, end, Part.Order);
            if (end == next) {
                return;
            }
            start = end;
        }
        if (tokens[start].isKeyWord("LIMIT")) {
            if (++start == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            try {
                this.limit = Integer.parseInt(tokens[start].getString());
            }
            catch (NumberFormatException nfe) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getString());
            }
            if (++start == next) {
                return;
            }
        }
        if (tokens[start].isKeyWord("OFFSET")) {
            if (++start == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            try {
                this.offset = Integer.parseInt(tokens[start].getString());
            }
            catch (NumberFormatException nfe) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getString());
            }
            if (++start == next) {
                return;
            }
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
    }

    private int scanParallel(Token[] tokens, int start, int next) {
        if (start + 5 < next && tokens[start].equals("/") && tokens[start + 1].equals("*") && tokens[start + 2].equals("+") && tokens[start + 3].equalsIgnoreCase("PARALLEL")) {
            if (tokens[start + 4].equals("*") && tokens[start + 5].equals("/")) {
                int parallel = Env.getParallelNum();
                this.statement.setParallelCount(parallel);
                return start + 6;
            }
            if (start + 8 < next && tokens[start + 4].getType() == '(' && tokens[start + 6].getType() == ')' && tokens[start + 7].equals("*") && tokens[start + 8].equals("/")) {
                try {
                    int parallel = Integer.parseInt(tokens[start + 5].getString());
                    this.statement.setParallelCount(parallel);
                }
                catch (NumberFormatException e) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start + 3].getString());
                }
                return start + 9;
            }
        }
        return start;
    }

    private int scanQuantifies(Token[] tokens, int start, int next) {
        Token token = tokens[start];
        if (token.isKeyWord("DISTINCT")) {
            if (++start == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + token.getString());
            }
            this.distinct = true;
            token = tokens[start];
        }
        if (token.isKeyWord("TOP")) {
            if (++start == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + token.getString());
            }
            token = tokens[start];
            if (++start == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + token.getString());
            }
            try {
                this.limit = Integer.parseInt(token.getString());
            }
            catch (NumberFormatException nfe) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + token.getString());
            }
        }
        return start;
    }

    private void scanColumns(Token[] tokens, int start, int next) {
        block1: {
            block2: {
                int comma;
                do {
                    if ((comma = Tokenizer.scanComma(tokens, start, next)) < 0) break block1;
                    if (start >= comma) break block2;
                    this.scanColumnItem(tokens, start, comma);
                } while ((start = comma + 1) != next);
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
        }
        this.scanColumnItem(tokens, start, next);
    }

    private void scanColumnItem(Token[] tokens, int start, int next) {
        if (start + 1 == next && tokens[start].equals("*")) {
            Column column = new Column(this, null);
            this.columnList.add(column);
        } else if (start + 3 == next && tokens[start + 1].getType() == '.' && tokens[start + 2].equals("*")) {
            Column column = new Column(this, tokens[start].getString());
            this.columnList.add(column);
        } else {
            String aliasName = null;
            int expNext = next;
            int index = next - 1;
            if (index > start && tokens[index].getType() == '\u0001') {
                int prev = index - 1;
                if (tokens[prev].isKeyWord("AS")) {
                    if (start == prev) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[prev].getPos());
                    }
                    expNext = prev;
                    aliasName = tokens[index].getString();
                } else if (!tokens[prev].canHaveRightExp()) {
                    expNext = index;
                    aliasName = tokens[index].getString();
                }
            }
            Exp exp = this.scanExp(tokens, start, expNext, Part.Column);
            Column column = new Column(this, exp, aliasName);
            this.columnList.add(column);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int scanTable(Token[] tokens, int start, int next) {
        String aliasName;
        Token token = tokens[start];
        if (token.getType() == '\u0001') {
            String tableName = token.getString();
            Pseudo pseudo = this.statement.getTable(tableName);
            if (pseudo != null) {
                TableNode tableNode = new TableNode(this, tableName, pseudo);
                this.statement.addTable(tableNode);
                this.from = tableNode;
            } else {
                if (this.with == null) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(tableName) + mm.getMessage("syntax.unknownTable") + token.getPos());
                }
                IQuery query = this.with.getQuery(tableName);
                if (query == null) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(tableName) + mm.getMessage("syntax.unknownTable") + token.getPos());
                }
                this.from = new SubQuery(this, query);
                this.from.setAliasName(tableName);
            }
            ++start;
        } else {
            if (token.getType() != '(') {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + token.getPos());
            }
            int end = Tokenizer.scanParen(tokens, start, next);
            IQuery query = this.scanQuery(tokens, start + 1, end);
            this.from = new SubQuery(this, query);
            start = end + 1;
        }
        if (start >= next) return start;
        token = tokens[start];
        if (!token.isKeyWord("AS")) {
            if (token.getType() != '\u0001') return start;
            ++start;
            aliasName = token.getOriginString();
            this.from.setAliasName(aliasName);
            return start;
        }
        if (++start == next) {
            throw new RuntimeException();
        }
        token = tokens[start];
        if (token.getType() != '\u0001') {
            throw new RuntimeException();
        }
        aliasName = token.getOriginString();
        this.from.setAliasName(aliasName);
        return ++start;
    }

    private IQuery scanQuery(Token[] tokens, int start, int next) {
        SetOperation operation = null;
        int i = start;
        while (i < next) {
            SetOperation newOperation;
            MessageManager mm;
            Select select;
            Token token = tokens[i];
            if (token.getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next) + 1;
                continue;
            }
            if (token.isKeyWord("UNION")) {
                SetOperation.Type type;
                select = new Select(this, tokens, start, i);
                if (++i == next) {
                    mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                }
                if (tokens[i].isKeyWord("ALL")) {
                    type = SetOperation.Type.UNIONALL;
                    ++i;
                } else {
                    type = SetOperation.Type.UNION;
                }
                if (operation == null) {
                    operation = new SetOperation(type);
                    operation.setLeft(select);
                } else {
                    operation.setRight(select);
                    SetOperation newOperation2 = new SetOperation(type);
                    newOperation2.setLeft(operation);
                    operation = newOperation2;
                }
                start = i;
                continue;
            }
            if (token.isKeyWord("INTERSECT")) {
                select = new Select(this, tokens, start, i);
                if (++i == next) {
                    mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                }
                if (operation == null) {
                    operation = new SetOperation(SetOperation.Type.INTERSECT);
                    operation.setLeft(select);
                } else {
                    operation.setRight(select);
                    newOperation = new SetOperation(SetOperation.Type.INTERSECT);
                    newOperation.setLeft(operation);
                    operation = newOperation;
                }
                start = i;
                continue;
            }
            if (token.isKeyWord("MINUS")) {
                select = new Select(this, tokens, start, i);
                if (++i == next) {
                    mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[i - 1].getPos());
                }
                if (operation == null) {
                    operation = new SetOperation(SetOperation.Type.MINUS);
                    operation.setLeft(select);
                } else {
                    operation.setRight(select);
                    newOperation = new SetOperation(SetOperation.Type.MINUS);
                    newOperation.setLeft(operation);
                    operation = newOperation;
                }
                start = i;
                continue;
            }
            ++i;
        }
        if (operation == null) {
            return new Select(this, tokens, start, next);
        }
        Select select = new Select(this, tokens, start, next);
        operation.setRight(select);
        return operation;
    }

    private int scanFrom(Token[] tokens, int start, int next) {
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
        }
        start = this.scanTable(tokens, start, next);
        ITable table = this.from;
        while (start < next) {
            Join.Type type;
            MessageManager mm;
            Join join;
            MessageManager mm2;
            if (tokens[start].getType() == ',') {
                if (++start == next) {
                    mm2 = ParseMessage.get();
                    throw new RQException(String.valueOf(mm2.getMessage("syntax.error")) + tokens[start - 1].getPos());
                }
                join = new Join(this, Join.Type.IMPLICIT);
                join.setLeft(table);
                start = this.scanTable(tokens, start, next);
                join.setRight(this.from);
                table = join;
                continue;
            }
            if (tokens[start].isKeyWord("JOIN")) {
                if (++start == next) {
                    mm2 = ParseMessage.get();
                    throw new RQException(String.valueOf(mm2.getMessage("syntax.error")) + tokens[start - 1].getPos());
                }
                join = new Join(this, Join.Type.INNER);
                join.setLeft(table);
                start = this.scanTable(tokens, start, next);
                join.setRight(this.from);
                table = join;
                if (start >= next || !tokens[start].isKeyWord("ON")) continue;
                start = this.scanOn(tokens, start, next, join);
                continue;
            }
            if (tokens[start].isKeyWord("CROSS")) {
                mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
            }
            if (tokens[start].isKeyWord("INNER")) {
                type = Join.Type.INNER;
            } else if (tokens[start].isKeyWord("LEFT")) {
                type = Join.Type.LEFT;
                if (start + 1 < next && tokens[start + 1].isKeyWord("OUTER")) {
                    ++start;
                }
            } else {
                if (tokens[start].isKeyWord("RIGHT")) {
                    mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start].getPos());
                }
                if (!tokens[start].isKeyWord("FULL")) break;
                type = Join.Type.FULL;
            }
            if (++start == next || !tokens[start].isKeyWord("JOIN")) {
                mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            if (++start == next) {
                mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            Join join2 = new Join(this, type);
            join2.setLeft(table);
            start = this.scanTable(tokens, start, next);
            join2.setRight(this.from);
            table = join2;
            if (start >= next || !tokens[start].isKeyWord("ON")) continue;
            start = this.scanOn(tokens, start, next, join2);
        }
        this.from = table;
        return start;
    }

    private int scanOn(Token[] tokens, int start, int next, Join join) {
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
        }
        int end = Tokenizer.scanKeyWords(tokens, start, next, FROMKEYS, 0);
        if (start == end) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
        }
        Exp exp = this.scanExp(tokens, start, end, Part.Join);
        join.setOn(exp);
        return end;
    }

    private void scanGroupBy(Token[] tokens, int start, int next) {
        Exp exp;
        block2: {
            block3: {
                int comma;
                if (start == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
                }
                this.groupBy = new ArrayList<Exp>();
                do {
                    if ((comma = Tokenizer.scanComma(tokens, start, next)) < 0) break block2;
                    if (start >= comma) break block3;
                    exp = this.scanExp(tokens, start, comma, Part.Group);
                    this.groupBy.add(exp);
                } while ((start = comma + 1) != next);
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
        }
        exp = this.scanExp(tokens, start, next, Part.Group);
        this.groupBy.add(exp);
    }

    private List<SortItem> scanOrderBy(Token[] tokens, int start, int next, Part part) {
        ArrayList<SortItem> orderBy;
        block4: {
            block5: {
                int comma;
                if (start == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
                }
                orderBy = new ArrayList<SortItem>();
                do {
                    int end = (comma = Tokenizer.scanComma(tokens, start, next)) < 0 ? next - 1 : comma - 1;
                    String order = null;
                    if (tokens[end].isKeyWord("ASC") || tokens[end].isKeyWord("DESC")) {
                        order = tokens[end].getString();
                    } else {
                        ++end;
                    }
                    Exp exp = this.scanExp(tokens, start, end, part);
                    SortItem sortItem = new SortItem(exp, order);
                    sortItem.setOrder(order);
                    orderBy.add(sortItem);
                    if (comma < 0) break block4;
                    if (start >= comma) break block5;
                } while ((start = comma + 1) != next);
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + tokens[start - 1].getPos());
        }
        return orderBy;
    }

    @Override
    public void setColumnNames(List<String> columnNames) {
        int colCount = columnNames.size();
        if (this.columnList.size() != colCount) {
            throw new RuntimeException();
        }
        int i = 0;
        while (i < colCount) {
            String aliasName = columnNames.get(i);
            this.columnList.get(i).setAliasName(aliasName);
            ++i;
        }
    }

    public String getNextTableParamName() {
        return this.statement.getNextTableParamName();
    }

    @Override
    public DataStruct getDataStruct() {
        if (this.dataStruct == null) {
            ArrayList<String> nameList = new ArrayList<String>();
            for (Column column : this.columnList) {
                column.getResultField(nameList);
            }
            String[] names = new String[nameList.size()];
            nameList.toArray(names);
            this.dataStruct = new DataStruct(names);
        }
        return this.dataStruct;
    }

    public static int getFieldIndex(DataStruct ds, String fieldName) {
        String[] names = ds.getFieldNames();
        int i = 0;
        int fcount = names.length;
        while (i < fcount) {
            if (Select.isEquals(names[i], fieldName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ITable getFromTable(String tableName) {
        return this.from.getTable(tableName);
    }

    public ITable getFrom() {
        return this.from;
    }

    public List<Exp> getGroupBy() {
        return this.groupBy;
    }

    public int getGatherCount() {
        return this.gatherList.size();
    }

    public ITable getFromTable(String tableName, String fieldName) {
        ITable table = this.from.getTable(tableName, fieldName);
        if (table != null) {
            return table;
        }
        if (this.parent != null) {
            return this.parent.getFromTable(tableName, fieldName);
        }
        return null;
    }

    public Column getColumn(String name) {
        for (Column column : this.columnList) {
            if (!column.isEquals(name)) continue;
            return column;
        }
        return null;
    }

    private Object doGroup(Object data) {
        ICursor cs;
        Object result;
        Sequence sequence;
        int i;
        int gatherCount;
        int byCount = this.groupBy == null ? 0 : this.groupBy.size();
        int n = gatherCount = this.gatherList == null ? 0 : this.gatherList.size();
        if (byCount == 0 && gatherCount == 0) {
            return data;
        }
        Expression[] byExps = null;
        String[] byNames = null;
        Expression[] gatherExps = null;
        String[] gatherNames = null;
        if (byCount > 0) {
            byExps = new Expression[byCount];
            byNames = new String[byCount];
            i = 0;
            while (i < byCount) {
                String expStr = this.groupBy.get(i).toSPL();
                Integer findex = Variant.parseInt((String)expStr);
                if (findex != null) {
                    int n2 = findex;
                    if (n2 < 1 || n2 > this.columnList.size()) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(String.valueOf(n2) + mm.getMessage("engine.indexOutofBound"));
                    }
                    Column column = this.columnList.get(n2 - 1);
                    Exp exp = column.getExp();
                    this.groupBy.set(i, exp);
                    expStr = exp.toSPL();
                }
                byExps[i] = new Expression(this.ctx, expStr);
                byNames[i] = "_" + (i + 1);
                ++i;
            }
        }
        if (gatherCount > 0) {
            gatherExps = new Expression[gatherCount];
            gatherNames = new String[gatherCount];
            i = 0;
            int q = byCount + 1;
            while (i < gatherCount) {
                String expStr = this.gatherList.get(i).toSPL();
                gatherExps[i] = new Expression(this.ctx, expStr);
                gatherNames[i] = "_" + q;
                ++i;
                ++q;
            }
        }
        if (byCount == 0 && gatherCount == 1 && this.gatherList.get(0).getFnName().equals("count")) {
            Number result2;
            if (data instanceof Sequence) {
                Sequence sequence2 = (Sequence)data;
                result2 = sequence2.length();
            } else {
                ICursor cs2 = (ICursor)data;
                result2 = cs2.skip();
            }
            Table resultTable = new Table(gatherNames);
            resultTable.newLast(new Object[]{result2});
            return resultTable;
        }
        if (this.from.isSortedFields(byExps)) {
            if (data instanceof Sequence) {
                sequence = (Sequence)data;
                result = sequence.groups(byExps, byNames, gatherExps, gatherNames, "o", this.ctx);
            } else {
                cs = (ICursor)data;
                cs.group(null, byExps, byNames, gatherExps, gatherNames, "s", this.ctx);
                result = cs;
            }
        } else if (data instanceof Sequence) {
            sequence = (Sequence)data;
            result = sequence.groups(byExps, byNames, gatherExps, gatherNames, null, this.ctx);
        } else {
            cs = (ICursor)data;
            result = cs.groups(byExps, byNames, gatherExps, gatherNames, null, this.ctx);
        }
        if (this.having != null) {
            String expStr = this.having.toSPL(byCount);
            Expression exp = new Expression(this.ctx, expStr);
            if (result instanceof Sequence) {
                result = ((Sequence)result).select(exp, "o", this.ctx);
            } else {
                ((ICursor)result).select(null, exp, null, this.ctx);
            }
        }
        return result;
    }

    private String attachGroup(String spl) {
        int i;
        int gatherCount;
        int byCount = this.groupBy == null ? 0 : this.groupBy.size();
        int n = gatherCount = this.gatherList == null ? 0 : this.gatherList.size();
        if (byCount == 0 && gatherCount == 0) {
            return spl;
        }
        spl = String.valueOf(spl) + ".groups(";
        if (byCount > 0) {
            i = 0;
            while (i < byCount) {
                String expStr;
                Integer findex;
                if (i > 0) {
                    spl = String.valueOf(spl) + ",";
                }
                if ((findex = Variant.parseInt((String)(expStr = this.groupBy.get(i).toSPL()))) != null) {
                    int n2 = findex;
                    if (n2 < 1 || n2 > this.columnList.size()) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(String.valueOf(n2) + mm.getMessage("engine.indexOutofBound"));
                    }
                    Column column = this.columnList.get(n2 - 1);
                    Exp exp = column.getExp();
                    this.groupBy.set(i, exp);
                    expStr = exp.toSPL();
                }
                spl = String.valueOf(spl) + expStr;
                spl = String.valueOf(spl) + ":_" + (i + 1);
                ++i;
            }
        }
        if (gatherCount > 0) {
            spl = String.valueOf(spl) + ";";
            i = 0;
            int q = byCount + 1;
            while (i < gatherCount) {
                if (i > 0) {
                    spl = String.valueOf(spl) + ",";
                }
                spl = String.valueOf(spl) + this.gatherList.get(i).toSPL();
                spl = String.valueOf(spl) + ":_" + q;
                ++i;
                ++q;
            }
        }
        spl = String.valueOf(spl) + ")";
        if (this.having != null) {
            spl = String.valueOf(spl) + ".select(";
            spl = String.valueOf(spl) + this.having.toSPL(byCount);
            spl = String.valueOf(spl) + ")";
        }
        return spl;
    }

    private Object doSort(Object data, List<SortItem> orderBy) {
        Sequence sequence;
        if (orderBy == null) {
            return data;
        }
        if (data instanceof Sequence) {
            sequence = (Sequence)data;
        } else {
            sequence = ((ICursor)data).fetch();
            if (sequence == null) {
                return null;
            }
        }
        int byCount = this.groupBy == null ? 0 : this.groupBy.size();
        int count = orderBy.size();
        Expression[] exps = new Expression[count];
        int[] orders = new int[count];
        int i = 0;
        while (i < count) {
            SortItem sortItem = orderBy.get(i);
            String expStr = sortItem.getSortExp().toSPL(byCount);
            Integer findex = Variant.parseInt((String)expStr);
            if (findex != null) {
                int n = findex;
                if (n < 1 || n > this.columnList.size()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(n) + mm.getMessage("engine.indexOutofBound"));
                }
                Column column = this.columnList.get(n - 1);
                expStr = column.toSPL();
            }
            exps[i] = new Expression(this.ctx, expStr);
            orders[i] = sortItem.getOrder();
            ++i;
        }
        return sequence.sort(exps, orders, null, null, this.ctx);
    }

    private String attachSort(String spl) {
        if (this.orderBy == null) {
            return spl;
        }
        spl = String.valueOf(spl) + ".sort(";
        int byCount = this.groupBy == null ? 0 : this.groupBy.size();
        int i = 0;
        while (i < this.orderBy.size()) {
            SortItem sortItem;
            String expStr;
            Integer findex;
            if (i > 0) {
                spl = String.valueOf(spl) + ",";
            }
            if ((findex = Variant.parseInt((String)(expStr = (sortItem = this.orderBy.get(i)).getSortExp().toSPL(byCount)))) != null) {
                int n = findex;
                if (n < 1 || n > this.columnList.size()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(n) + mm.getMessage("engine.indexOutofBound"));
                }
                Column column = this.columnList.get(n - 1);
                expStr = column.toSPL();
            }
            spl = String.valueOf(spl) + expStr;
            spl = String.valueOf(spl) + ":";
            spl = String.valueOf(spl) + sortItem.getOrder();
            ++i;
        }
        spl = String.valueOf(spl) + ")";
        return spl;
    }

    /*
     * WARNING - void declaration
     */
    private Object doNew(Object data) {
        int count = this.columnList.size();
        ArrayList<Expression> expList = new ArrayList<Expression>();
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < count) {
            Column column = this.columnList.get(i);
            if (column.isAllFields()) {
                ArrayList<ITable> tableList = column.getAllTables();
                for (ITable iTable : tableList) {
                    Expression exp;
                    int f;
                    DataStruct ds = iTable.getDataStruct();
                    int fcount = ds.getFieldCount();
                    String joinFieldName = iTable.getJoinFieldName();
                    if (joinFieldName == null) {
                        f = 0;
                        while (f < fcount) {
                            exp = new Expression(this.ctx, "#" + (f + 1));
                            expList.add(exp);
                            nameList.add(ds.getFieldName(f));
                            ++f;
                        }
                        continue;
                    }
                    f = 0;
                    while (f < fcount) {
                        exp = new Expression(this.ctx, String.valueOf(joinFieldName) + ".#" + (f + 1));
                        expList.add(exp);
                        nameList.add(ds.getFieldName(f));
                        ++f;
                    }
                }
            } else {
                Expression exp = new Expression(this.ctx, column.toSPL());
                expList.add(exp);
                nameList.add(column.getAliasName());
            }
            ++i;
        }
        int fcount = expList.size();
        String[] names = new String[fcount];
        Expression[] exps = new Expression[fcount];
        nameList.toArray(names);
        expList.toArray(exps);
        if (data instanceof Table) {
            void var8_11;
            Table table = (Table)data;
            DataStruct ds = table.dataStruct();
            if (!ds.isSameFields(exps, names)) {
                Table table2 = table.newTable(names, exps, this.ctx);
                int[] pkIndex = ds.getPKIndex();
                if (pkIndex != null) {
                    int keyCount = pkIndex.length;
                    String[] keyNames = new String[keyCount];
                    int k = 0;
                    while (k < keyCount) {
                        int i2;
                        block21: {
                            i2 = 0;
                            while (i2 < fcount) {
                                if (exps[i2].getFieldIndex(ds) != k) {
                                    ++i2;
                                    continue;
                                }
                                break block21;
                            }
                            keyNames = null;
                            break;
                        }
                        keyNames[k] = names[i2];
                        ++k;
                    }
                    if (keyNames != null) {
                        table2.setPrimary(keyNames);
                    }
                }
            }
            if (this.distinct) {
                exps = new Expression[fcount];
                int f = 0;
                while (f < fcount) {
                    exps[f] = new Expression(this.ctx, "#" + (f + 1));
                    ++f;
                }
                return var8_11.group(exps, "1", this.ctx);
            }
            return var8_11;
        }
        if (data instanceof Sequence) {
            Sequence sequence = (Sequence)data;
            Table table = sequence.newTable(names, exps, this.ctx);
            if (this.distinct) {
                exps = new Expression[fcount];
                int f = 0;
                while (f < fcount) {
                    exps[f] = new Expression(this.ctx, "#" + (f + 1));
                    ++f;
                }
                return table.group(exps, "1", this.ctx);
            }
            return table;
        }
        ICursor iCursor = (ICursor)data;
        iCursor.newTable(null, exps, names, null, this.ctx);
        if (this.distinct) {
            exps = new Expression[fcount];
            int f = 0;
            while (f < fcount) {
                exps[f] = new Expression(this.ctx, "#" + (f + 1));
                ++f;
            }
            return iCursor.groups(exps, names, null, null, null, this.ctx);
        }
        return iCursor;
    }

    private String attachNew(String spl) {
        spl = String.valueOf(spl) + ".new(";
        int count = this.columnList.size();
        int resultFieldCount = 0;
        int i = 0;
        while (i < count) {
            Column column = this.columnList.get(i);
            if (column.isAllFields()) {
                ArrayList<ITable> tableList = column.getAllTables();
                for (ITable table : tableList) {
                    int f;
                    DataStruct ds = table.getDataStruct();
                    int fcount = ds.getFieldCount();
                    String joinFieldName = table.getJoinFieldName();
                    if (joinFieldName == null) {
                        f = 0;
                        while (f < fcount) {
                            if (resultFieldCount > 0) {
                                spl = String.valueOf(spl) + ",";
                            }
                            ++resultFieldCount;
                            spl = String.valueOf(spl) + "#" + (f + 1);
                            spl = String.valueOf(spl) + ":";
                            spl = String.valueOf(spl) + ds.getFieldName(f);
                            ++f;
                        }
                        continue;
                    }
                    f = 0;
                    while (f < fcount) {
                        if (resultFieldCount > 0) {
                            spl = String.valueOf(spl) + ",";
                        }
                        ++resultFieldCount;
                        spl = String.valueOf(spl) + joinFieldName + ".#" + (f + 1);
                        spl = String.valueOf(spl) + ":";
                        spl = String.valueOf(spl) + ds.getFieldName(f);
                        ++f;
                    }
                }
            } else {
                if (resultFieldCount > 0) {
                    spl = String.valueOf(spl) + ",";
                }
                ++resultFieldCount;
                spl = String.valueOf(spl) + column.toSPL();
                spl = String.valueOf(spl) + ":";
                spl = String.valueOf(spl) + column.getAliasName();
            }
            ++i;
        }
        spl = String.valueOf(spl) + ")";
        if (this.distinct) {
            if (this.isSingleValue()) {
                spl = String.valueOf(spl) + ".id(#1)";
            } else {
                spl = String.valueOf(spl) + ".group@1(#1";
                int f = 2;
                while (f <= resultFieldCount) {
                    spl = String.valueOf(spl) + ",#" + f;
                    ++f;
                }
                spl = String.valueOf(spl) + ")";
            }
        } else if (resultFieldCount == 1) {
            spl = this.isSingleValue() ? String.valueOf(spl) + ".#1" : String.valueOf(spl) + ".(#1)";
        }
        return spl;
    }

    private boolean isSingleValue() {
        boolean flag;
        boolean bl = flag = this.groupBy == null && this.gatherList != null && this.gatherList.size() == 1;
        if (!flag && this.from instanceof SubQuery) {
            IQuery query = ((SubQuery)this.from).getQuery();
            if (query instanceof Select) {
                return ((Select)query).isSingleValue();
            }
            return false;
        }
        return flag;
    }

    private boolean isNull(Object data) {
        if (data == null) {
            return true;
        }
        if (data instanceof Sequence) {
            return ((Sequence)data).length() == 0;
        }
        return false;
    }

    private Object executeWindow(ICursor cs) {
        List<llIIIIIIIlllIlll> groupExpList = null;
        List<lIllIlllIIIIlIll> sortList = null;
        for (WindowFunction window : this.windowList) {
            groupExpList = window.getPartitionBy();
            sortList = window.getOrderBy();
            if (sortList != null) break;
        }
        int gcount = groupExpList.size();
        Expression[] gexps = new Expression[gcount];
        int i = 0;
        while (i < gcount) {
            String expStr = ((Exp)((Object)groupExpList.get(i))).toSPL();
            gexps[i] = new Expression(this.ctx, expStr);
            ++i;
        }
        cs.group(null, gexps, null, this.ctx);
        if (sortList != null) {
            String spl = "~.sort(";
            int i2 = 0;
            int count = sortList.size();
            while (i2 < count) {
                if (i2 > 0) {
                    spl = String.valueOf(spl) + ",";
                }
                SortItem sortItem = (SortItem)((Object)sortList.get(i2));
                spl = String.valueOf(spl) + sortItem.getSortExp().toSPL();
                spl = String.valueOf(spl) + ":" + sortItem.getOrder();
                ++i2;
            }
            spl = String.valueOf(spl) + ")";
            Expression exp = new Expression(this.ctx, spl);
            Calculate calculate = new Calculate(null, exp);
            cs.addOperation((Operation)calculate, this.ctx);
        }
        String spl = null;
        for (WindowFunction window : this.windowList) {
            String expStr = window.toCalcExpression();
            if (expStr == null) continue;
            spl = spl == null ? expStr : String.valueOf(spl) + "," + expStr;
        }
        String newStr = this.attachNew("~");
        spl = spl == null ? newStr : "(" + spl + "," + newStr + ")";
        Expression exp = new Expression(this.ctx, spl);
        Conj op = new Conj(null, exp);
        cs.addOperation((Operation)op, this.ctx);
        Object data = this.doSort(cs, this.orderBy);
        if (this.isNull(data)) {
            return null;
        }
        if (this.isNull(data)) {
            return null;
        }
        if (data instanceof Sequence) {
            this.dataStruct = ((Sequence)data).getFirstRecordDataStruct();
        }
        if (this.limit > 0) {
            if (this.offset > 0) {
                if (data instanceof Sequence) {
                    Sequence sequence = (Sequence)data;
                    sequence = sequence.get(this.offset + 1, this.offset + this.limit + 1);
                    return sequence;
                }
                cs.skip((long)this.offset);
                Sequence sequence = cs.fetch(this.limit);
                return sequence;
            }
            if (data instanceof Sequence) {
                Sequence sequence = (Sequence)data;
                sequence = sequence.get(1, this.limit + 1);
                return sequence;
            }
            Sequence sequence = cs.fetch(this.limit);
            return sequence;
        }
        if (this.offset > 0) {
            if (data instanceof Sequence) {
                Sequence sequence = (Sequence)data;
                sequence = sequence.get(this.offset + 1, sequence.length() + 1);
                return sequence;
            }
            cs.skip((long)this.offset);
            return cs;
        }
        return data;
    }

    private Sequence executeWindow(Sequence data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        List<llIIIIIIIlllIlll> groupExpList = this.windowList.get(0).getPartitionBy();
        List<lIllIlllIIIIlIll> sortList = this.windowList.get(0).getOrderBy();
        Sequence result = null;
        if (groupExpList == null) {
            data = (Sequence)this.doSort(data, sortList);
            for (WindowFunction window : this.windowList) {
                window.setPartitionData(data, this.ctx);
            }
            result = (Sequence)this.doNew(data);
        } else {
            int gcount = groupExpList.size();
            Expression[] gexps = new Expression[gcount];
            int i = 0;
            while (i < gcount) {
                String expStr = ((Exp)((Object)groupExpList.get(i))).toSPL();
                gexps[i] = new Expression(this.ctx, expStr);
                ++i;
            }
            Sequence groups = data.group(gexps, null, this.ctx);
            int i2 = 1;
            int len = groups.length();
            while (i2 <= len) {
                Sequence curGroup = (Sequence)this.doSort(groups.getMem(i2), sortList);
                for (WindowFunction window : this.windowList) {
                    window.setPartitionData(curGroup, this.ctx);
                }
                curGroup = (Sequence)this.doNew(curGroup);
                if (result == null) {
                    result = curGroup;
                } else {
                    result.addAll(curGroup);
                }
                ++i2;
            }
        }
        result = (Sequence)this.doSort(result, this.orderBy);
        this.dataStruct = result.getFirstRecordDataStruct();
        if (this.limit > 0) {
            if (this.offset > 0) {
                result = result.get(this.offset + 1, this.offset + this.limit + 1);
                return result;
            }
            result = result.get(1, this.limit + 1);
            return result;
        }
        if (this.offset > 0) {
            result = result.get(this.offset + 1, result.length() + 1);
            return result;
        }
        return result;
    }

    @Override
    public Object execute() {
        this.analyseFieldNode();
        Object data = this.from.getData(this.where);
        if (this.windowList.size() > 0) {
            if (this.groupBy != null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + "group by");
            }
            List<llIIIIIIIlllIlll> groupExpList = this.windowList.get(0).getPartitionBy();
            String[] sortedFields = this.from.getSortedFieldNames();
            if (data instanceof ICursor && groupExpList != null && sortedFields != null && groupExpList.size() <= sortedFields.length) {
                ITable table = this.from.getSortedTable();
                int gcount = groupExpList.size();
                boolean isSorted = true;
                int i = 0;
                while (i < gcount) {
                    Exp exp = (Exp)((Object)groupExpList.get(i));
                    if (!(exp instanceof FieldNode)) {
                        isSorted = false;
                        break;
                    }
                    FieldNode fieldNode = (FieldNode)exp;
                    if (fieldNode.getTable() != table || !fieldNode.isEqualField(sortedFields[i])) {
                        isSorted = false;
                        break;
                    }
                    ++i;
                }
                if (isSorted) {
                    return this.executeWindow((ICursor)data);
                }
            }
            Sequence sequence = Join.toSequence(data);
            return this.executeWindow(sequence);
        }
        if (this.isNull(data)) {
            return null;
        }
        if (this.isNull(data = this.doGroup(data))) {
            return null;
        }
        if (this.isNull(data = this.doSort(data, this.orderBy))) {
            return null;
        }
        if (this.isNull(data = this.doNew(data))) {
            return null;
        }
        if (data instanceof Sequence) {
            this.dataStruct = ((Sequence)data).getFirstRecordDataStruct();
        }
        if (this.limit > 0) {
            if (this.offset > 0) {
                if (data instanceof Sequence) {
                    Sequence sequence = (Sequence)data;
                    sequence = sequence.get(this.offset + 1, this.offset + this.limit + 1);
                    return sequence;
                }
                ICursor cs = (ICursor)data;
                cs.skip((long)this.offset);
                Sequence sequence = cs.fetch(this.limit);
                return sequence;
            }
            if (data instanceof Sequence) {
                Sequence sequence = (Sequence)data;
                sequence = sequence.get(1, this.limit + 1);
                return sequence;
            }
            ICursor cs = (ICursor)data;
            Sequence sequence = cs.fetch(this.limit);
            return sequence;
        }
        if (this.offset > 0) {
            if (data instanceof Sequence) {
                Sequence sequence = (Sequence)data;
                sequence = sequence.get(this.offset + 1, sequence.length() + 1);
                return sequence;
            }
            ICursor cs = (ICursor)data;
            cs.skip((long)this.offset);
            return cs;
        }
        return data;
    }

    private void analyseFieldNode() {
        if (this.fieldState) {
            return;
        }
        this.fieldState = true;
        for (FieldNode field : this.fieldList) {
            field.analyseFieldNode();
        }
        for (Column column : this.columnList) {
            column.analyseFieldNode();
        }
    }

    Exp toAndExp(List<Exp> andList) {
        int size = andList.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return andList.get(0);
        }
        ArrayList<Exp> expList = new ArrayList<Exp>();
        int i = 0;
        while (i < size) {
            Exp exp = andList.get(i);
            if (i > 0) {
                CommonNode andNode = new CommonNode(exp.getStart() - 1, exp.getStart(), "&&");
                expList.add(andNode);
            }
            expList.add(exp);
            ++i;
        }
        return new LogicExp(expList);
    }

    @Override
    public String toExists() {
        Sequence sequence;
        Object data;
        Exp exp;
        for (FieldNode field : this.fieldList) {
            field.analyseFieldNode();
        }
        if (this.where == null) {
            Object data2 = this.from.getData();
            if (data2 instanceof Sequence) {
                if (((Sequence)data2).length() > 0) {
                    return "true";
                }
                return "false";
            }
            if (((ICursor)data2).skip(1L) > 0L) {
                return "true";
            }
            return "false";
        }
        ArrayList<ITable> tableList = new ArrayList<ITable>();
        this.from.getAllTables(tableList);
        List<And> andList = this.where.splitAnd();
        ArrayList<Exp> expList = new ArrayList<Exp>();
        ArrayList<And> parentAndList = new ArrayList<And>();
        for (And and : andList) {
            if (and.isTable(tableList)) {
                exp = and.getExp();
                if (expList.size() > 0) {
                    CommonNode andNode = new CommonNode(exp.getStart() - 1, exp.getStart(), "&&");
                    expList.add(andNode);
                }
                expList.add(exp);
                continue;
            }
            parentAndList.add(and);
        }
        int expSize = expList.size();
        if (expSize == 0) {
            data = this.from.getData();
        } else if (expSize == 1) {
            data = this.from.getData((Exp)expList.get(0));
        } else {
            exp = new LogicExp(expList);
            data = this.from.getData(exp);
        }
        if (data instanceof ICursor) {
            sequence = ((ICursor)data).fetch();
        } else if (data instanceof Sequence) {
            sequence = (Sequence)data;
        } else {
            return "false";
        }
        if (sequence == null || sequence.length() == 0) {
            return "false";
        }
        if (parentAndList.size() == 0) {
            return "true";
        }
        ArrayList<Expression> subExpList = new ArrayList<Expression>();
        ArrayList<String> parentExpList = new ArrayList<String>();
        for (And and : parentAndList) {
            Exp exp2 = and.getExp();
            if (exp2.splitParentJionExp(tableList, subExpList, parentExpList)) continue;
            subExpList = null;
            parentExpList = null;
            break;
        }
        Context ctx = this.getContext();
        String paramName = this.getNextTableParamName();
        if (subExpList != null && subExpList.size() > 0) {
            int fcount = subExpList.size();
            Expression[] subExps = new Expression[fcount];
            subExpList.toArray(subExps);
            String[] names = new String[fcount];
            int i = 1;
            while (i <= fcount) {
                names[i - 1] = "k" + i;
                ++i;
            }
            Table table = sequence.groups(subExps, names, null, null, null, ctx);
            table.setPrimary(names);
            table.createIndexTable(null);
            ctx.setParamValue(paramName, (Object)table);
            String spl = String.valueOf(paramName) + ".find(";
            if (fcount == 1) {
                spl = String.valueOf(spl) + parentExpList.get(0);
                spl = String.valueOf(spl) + ")";
            } else {
                int i2 = 0;
                while (i2 < fcount) {
                    spl = i2 == 0 ? String.valueOf(spl) + "[" + parentExpList.get(i2) : String.valueOf(spl) + "," + parentExpList.get(i2);
                    ++i2;
                }
                spl = String.valueOf(spl) + "])";
            }
            return spl;
        }
        String filterMain = null;
        for (And and : andList) {
            Exp exp3 = and.getExp();
            String spl = exp3.toSPL();
            filterMain = filterMain == null ? spl : String.valueOf(spl) + "&&" + filterMain;
        }
        ctx.setParamValue(paramName, (Object)sequence);
        String spl = String.valueOf(paramName) + ".select(" + filterMain + ")";
        return spl;
    }

    @Override
    public String toIn(String x) {
        Table table;
        Sequence sequence;
        this.analyseFieldNode();
        Object data = this.from.getData();
        if (data == null) {
            return "false";
        }
        String filterMain = null;
        Context ctx = this.getContext();
        if (this.where != null) {
            List<And> andList = this.where.splitAnd();
            String filter = null;
            ArrayList<ITable> tableList = new ArrayList<ITable>();
            this.from.getAllTables(tableList);
            for (And and : andList) {
                String spl = and.getExp().toSPL();
                if (and.isTable(tableList)) {
                    if (filter == null) {
                        filter = spl;
                        continue;
                    }
                    filter = String.valueOf(filter) + "&&" + spl;
                    continue;
                }
                filterMain = filterMain == null ? spl : String.valueOf(filterMain) + "&&" + spl;
            }
            if (filter != null) {
                Expression exp = new Expression(ctx, filter);
                if (data instanceof ICursor) {
                    ICursor cs = (ICursor)data;
                    data = cs.select(null, exp, null, ctx);
                } else {
                    data = ((Sequence)data).select(exp, "t", ctx);
                }
            }
        }
        String paramName = this.getNextTableParamName();
        if (filterMain != null) {
            sequence = data instanceof ICursor ? ((ICursor)data).fetch() : (Sequence)data;
            String spl = String.valueOf(paramName) + ".select(" + filterMain + ")";
            spl = this.attachGroup(spl);
            spl = this.attachSort(spl);
            spl = this.attachNew(spl);
            if (this.limit == 1) {
                spl = this.offset > 0 ? String.valueOf(spl) + ".m(" + (this.offset + 1) + ")" : String.valueOf(spl) + ".m(1)";
            } else if (this.limit > 0) {
                spl = this.offset > 0 ? String.valueOf(spl) + ".to(" + (this.offset + 1) + "," + (this.offset + this.limit) + ")" : String.valueOf(spl) + ".to(" + this.limit + ")";
            } else if (this.offset > 0) {
                spl = String.valueOf(spl) + ".to(" + (this.offset + 1) + ",)";
            }
            ctx.setParamValue(paramName, (Object)sequence);
            return String.valueOf(spl) + ".contain(" + x + ")";
        }
        if ((data = this.doGroup(data)) == null) {
            return "false";
        }
        data = this.doSort(data, this.orderBy);
        sequence = (data = this.doNew(data)) instanceof ICursor ? ((ICursor)data).fetch() : (Sequence)data;
        if (sequence == null || sequence.length() == 0) {
            return "false";
        }
        if (this.limit > 0) {
            sequence = this.offset > 0 ? sequence.get(this.offset + 1, this.offset + this.limit + 1) : sequence.get(1, this.limit + 1);
        } else if (this.offset > 0) {
            sequence = sequence.get(this.offset + 1, sequence.length() + 1);
        }
        DataStruct ds = sequence.getFirstRecordDataStruct();
        if (ds == null || ds.getFieldCount() != 1) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + "in");
        }
        if (ds.getPKCount() != 1) {
            Expression[] exps = new Expression[]{new Expression("#1")};
            String[] names = new String[]{"_1"};
            table = sequence.groups(exps, names, null, null, null, ctx);
        } else {
            table = sequence.derive("o");
        }
        table.createIndexTable(null);
        ctx.setParamValue(paramName, (Object)table);
        String spl = String.valueOf(paramName) + ".find(" + x + ")";
        return spl;
    }

    @Override
    public String toSPL() {
        String paramName;
        this.analyseFieldNode();
        Object data = this.from.getData();
        if (data == null) {
            return "null";
        }
        String filterMain = null;
        Context ctx = this.getContext();
        if (this.where != null) {
            List<And> andList = this.where.splitAnd();
            String filter = null;
            ArrayList<ITable> tableList = new ArrayList<ITable>();
            this.from.getAllTables(tableList);
            for (And and : andList) {
                String spl = and.getExp().toSPL();
                if (and.isTable(tableList)) {
                    if (filter == null) {
                        filter = spl;
                        continue;
                    }
                    filter = String.valueOf(filter) + "&&" + spl;
                    continue;
                }
                filterMain = filterMain == null ? spl : String.valueOf(filterMain) + "&&" + spl;
            }
            if (filter != null) {
                Expression exp = new Expression(ctx, filter);
                if (data instanceof ICursor) {
                    ICursor cs = (ICursor)data;
                    cs.select(null, exp, null, ctx);
                    data = cs.fetch();
                } else {
                    data = ((Sequence)data).select(exp, "t", ctx);
                }
            }
        }
        Sequence sequence = data instanceof ICursor ? ((ICursor)data).fetch() : (Sequence)data;
        String spl = paramName = this.getNextTableParamName();
        if (filterMain != null) {
            spl = String.valueOf(spl) + ".select(" + filterMain + ")";
            spl = this.attachGroup(spl);
            spl = this.attachSort(spl);
            spl = this.attachNew(spl);
            if (this.limit == 1) {
                spl = this.offset > 0 ? String.valueOf(spl) + ".m(" + (this.offset + 1) + ")" : String.valueOf(spl) + ".m(1)";
            } else if (this.limit > 0) {
                spl = this.offset > 0 ? String.valueOf(spl) + ".to(" + (this.offset + 1) + "," + (this.offset + this.limit) + ")" : String.valueOf(spl) + ".to(" + this.limit + ")";
            } else if (this.offset > 0) {
                spl = String.valueOf(spl) + ".to(" + (this.offset + 1) + ",)";
            }
        } else if (sequence != null && sequence.length() > 0) {
            sequence = (Sequence)this.doGroup(sequence);
            sequence = (Sequence)this.doSort(sequence, this.orderBy);
            sequence = (Sequence)this.doNew(sequence);
            if (this.limit > 0) {
                sequence = this.offset > 0 ? sequence.get(this.offset + 1, this.offset + this.limit + 1) : sequence.get(1, this.limit + 1);
            } else if (this.offset > 0) {
                sequence = sequence.get(this.offset + 1, sequence.length() + 1);
            }
            DataStruct ds = sequence.getFirstRecordDataStruct();
            if (ds != null && ds.getFieldCount() == 1) {
                if (this.isSingleValue()) {
                    spl = String.valueOf(spl) + ".#1";
                } else {
                    sequence = sequence.fieldValues(0);
                }
            }
        }
        ctx.setParamValue(paramName, (Object)sequence);
        return spl;
    }

    @Override
    public String[] getPrimaryKey() {
        int gatherCount;
        if (this.from.getPrimaryKey() != null) {
            return this.from.getPrimaryKey();
        }
        if (this.dataStruct != null) {
            return this.dataStruct.getPrimary();
        }
        int byCount = this.groupBy == null ? 0 : this.groupBy.size();
        int n = gatherCount = this.gatherList == null ? 0 : this.gatherList.size();
        if (byCount == 0 && gatherCount == 0) {
            return null;
        }
        if (byCount == 0) {
            return null;
        }
        String[] pks = new String[byCount];
        int i = 0;
        while (i < byCount) {
            Column col2;
            block6: {
                Exp exp = this.groupBy.get(i);
                for (Column col2 : this.columnList) {
                    if (!col2.isEquals(exp)) continue;
                    break block6;
                }
                return null;
            }
            pks[i] = col2.getAliasName();
            ++i;
        }
        return pks;
    }

    @Override
    public String[] getSortedFieldNames() {
        int gatherCount;
        if (this.orderBy != null) {
            int orderCount = this.orderBy.size();
            String[] names = new String[orderCount];
            int i = 0;
            while (i < orderCount) {
                Column col2;
                block7: {
                    Exp exp = this.orderBy.get(i).getSortExp();
                    for (Column col2 : this.columnList) {
                        if (!col2.isEquals(exp)) continue;
                        break block7;
                    }
                    return null;
                }
                names[i] = col2.getAliasName();
                ++i;
            }
            return names;
        }
        int byCount = this.groupBy == null ? 0 : this.groupBy.size();
        int n = gatherCount = this.gatherList == null ? 0 : this.gatherList.size();
        if (byCount == 0 && gatherCount == 0) {
            return null;
        }
        if (byCount == 0) {
            return null;
        }
        String[] pks = new String[byCount];
        int i = 0;
        while (i < byCount) {
            Column col3;
            block8: {
                Exp exp = this.groupBy.get(i);
                for (Column col3 : this.columnList) {
                    if (!col3.isEquals(exp)) continue;
                    break block8;
                }
                return null;
            }
            pks[i] = col3.getAliasName();
            ++i;
        }
        return pks;
    }

    class Between
    extends Exp {
        private Exp left;
        private Exp from;
        private Exp to;
        private boolean isNot;

        public Between(Exp left, Exp from, Exp to, Exp not) {
            super(left.getStart(), to.getEnd());
            this.left = left;
            this.from = from;
            this.to = to;
            this.isNot = not != null;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof Between)) {
                return false;
            }
            Between other = (Between)node;
            return this.isNot == other.isNot && Select.isEquals(this.left, other.left) && Select.isEquals(this.from, other.from) && Select.isEquals(this.to, other.to);
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            this.left.getFields(resultList);
            this.from.getFields(resultList);
            this.to.getFields(resultList);
        }

        @Override
        public String toSPL() {
            String x = this.left.toSPL();
            String a = this.from.toSPL();
            String b = this.to.toSPL();
            if (this.isNot) {
                return String.valueOf(x) + "<" + a + "||" + x + ">" + b;
            }
            return String.valueOf(x) + ">=" + a + "&&" + x + "<=" + b;
        }

        @Override
        public String toSPL(int groupByCount) {
            String x = this.left.toSPL(groupByCount);
            String a = this.from.toSPL(groupByCount);
            String b = this.to.toSPL(groupByCount);
            if (this.isNot) {
                return String.valueOf(x) + "<" + a + "||" + x + ">" + b;
            }
            return String.valueOf(x) + ">=" + a + "&&" + x + "<=" + b;
        }
    }

    class Case
    extends Exp {
        private Exp field;
        private List<Exp> whenList;
        private List<Exp> thenList;
        private Exp defaultExp;

        public Case(int start, int end, Exp field, List<Exp> whenList, List<Exp> thenList, Exp defaultExp) {
            super(start, end);
            this.field = field;
            this.whenList = whenList;
            this.thenList = thenList;
            this.defaultExp = defaultExp;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof Case)) {
                return false;
            }
            Case other = (Case)node;
            if (!Select.isEquals(this.field, other.field) || !Select.isEquals(this.defaultExp, other.defaultExp)) {
                return false;
            }
            int count = this.whenList.size();
            if (count != other.whenList.size()) {
                return false;
            }
            int i = 0;
            while (i < count) {
                if (!Select.isEquals(this.whenList.get(i), other.whenList.get(i)) || !Select.isEquals(this.thenList.get(i), other.thenList.get(i))) {
                    return false;
                }
                ++i;
            }
            return Select.isEquals(this.defaultExp, other.defaultExp);
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            if (this.field != null) {
                this.field.getFields(resultList);
            }
            for (Exp exp : this.whenList) {
                exp.getFields(resultList);
            }
            for (Exp exp : this.thenList) {
                exp.getFields(resultList);
            }
            if (this.defaultExp != null) {
                this.defaultExp.getFields(resultList);
            }
        }

        @Override
        public String toSPL() {
            String spl;
            if (this.field == null) {
                spl = "if(";
                int size = this.whenList.size();
                int i = 0;
                while (i < size) {
                    if (i > 0) {
                        spl = String.valueOf(spl) + ",";
                    }
                    spl = String.valueOf(spl) + this.whenList.get(i).toSPL();
                    spl = String.valueOf(spl) + ":";
                    spl = String.valueOf(spl) + this.thenList.get(i).toSPL();
                    ++i;
                }
            } else {
                spl = "case(";
                spl = String.valueOf(spl) + this.field.toSPL();
                int size = this.whenList.size();
                int i = 0;
                while (i < size) {
                    spl = String.valueOf(spl) + ",";
                    spl = String.valueOf(spl) + this.whenList.get(i).toSPL();
                    spl = String.valueOf(spl) + ":";
                    spl = String.valueOf(spl) + this.thenList.get(i).toSPL();
                    ++i;
                }
            }
            if (this.defaultExp != null) {
                spl = String.valueOf(spl) + ";";
                spl = String.valueOf(spl) + this.defaultExp.toSPL();
            }
            return String.valueOf(spl) + ")";
        }

        @Override
        public String toSPL(int groupByCount) {
            String spl;
            if (this.field == null) {
                spl = "if(";
                int size = this.whenList.size();
                int i = 0;
                while (i < size) {
                    if (i > 0) {
                        spl = String.valueOf(spl) + ",";
                    }
                    spl = String.valueOf(spl) + this.whenList.get(i).toSPL(groupByCount);
                    spl = String.valueOf(spl) + ":";
                    spl = String.valueOf(spl) + this.thenList.get(i).toSPL(groupByCount);
                    ++i;
                }
            } else {
                spl = "case(";
                spl = String.valueOf(spl) + this.field.toSPL(groupByCount);
                int size = this.whenList.size();
                int i = 0;
                while (i < size) {
                    spl = String.valueOf(spl) + ",";
                    spl = String.valueOf(spl) + this.whenList.get(i).toSPL(groupByCount);
                    spl = String.valueOf(spl) + ":";
                    spl = String.valueOf(spl) + this.thenList.get(i).toSPL(groupByCount);
                    ++i;
                }
            }
            if (this.defaultExp != null) {
                spl = String.valueOf(spl) + ";";
                spl = String.valueOf(spl) + this.defaultExp.toSPL(groupByCount);
            }
            return String.valueOf(spl) + ")";
        }
    }

    class CommonNode
    extends Exp {
        private String exp;

        public CommonNode(int start, int end, String exp) {
            super(start, end);
            this.exp = exp;
        }

        @Override
        public boolean isLogicalOperator() {
            return this.exp.equals("&&") || this.exp.equals("||");
        }

        @Override
        public boolean isAnd() {
            return this.exp.equals("&&");
        }

        @Override
        public boolean isOr() {
            return this.exp.equals("||");
        }

        @Override
        public boolean isEqualOperator() {
            return this.exp.equals("==");
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof CommonNode)) {
                return false;
            }
            CommonNode other = (CommonNode)node;
            return Select.isEquals(other.exp, this.exp);
        }

        @Override
        public String toSPL() {
            return this.exp;
        }
    }

    class Exists
    extends Exp {
        private IQuery query;

        public Exists(int start, int end, IQuery query) {
            super(start, end);
            this.query = query;
        }

        @Override
        public boolean isEquals(Exp node) {
            return node == this;
        }

        @Override
        public String toSPL() {
            return this.query.toExists();
        }
    }

    abstract class Exp {
        protected int start;
        protected int end;

        public Exp(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public boolean isLogicalOperator() {
            return false;
        }

        public int getPos() {
            return Select.this.tokens[this.start].getPos();
        }

        public String getFieldName() {
            return null;
        }

        public abstract boolean isEquals(Exp var1);

        public void getFields(List<FieldNode> resultList) {
        }

        public List<And> splitAnd() {
            ArrayList<FieldNode> fieldList = new ArrayList<FieldNode>();
            this.getFields(fieldList);
            And and = new And(this, fieldList);
            ArrayList<And> result = new ArrayList<And>();
            result.add(and);
            return result;
        }

        public boolean isAnd() {
            return false;
        }

        public boolean isOr() {
            return false;
        }

        public boolean isEqualOperator() {
            return false;
        }

        public abstract String toSPL();

        public String toSPL(int groupByCount) {
            return this.toSPL();
        }

        public boolean splitJionExp(ITable leftTable, ITable rightTable, List<Expression> leftExpList, List<Expression> rightExpList) {
            return false;
        }

        public boolean splitJionExp(List<ITable> tableList, List<Exp> leftExpList, List<Exp> rightExpList) {
            return false;
        }

        public boolean splitParentJionExp(List<ITable> subTableList, List<Expression> subExpList, List<String> parentExpList) {
            return false;
        }
    }

    class FieldNode
    extends Exp {
        private String tableName;
        private String fieldName;
        private Part part;
        private ITable table;

        public FieldNode(int start, int end, String tableName, String fieldName, Part part) {
            super(start, end);
            this.tableName = tableName;
            this.fieldName = fieldName;
            this.part = part;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        public ITable getTable() {
            if (this.table == null) {
                this.table = Select.this.getFromTable(this.tableName, this.fieldName);
                if (this.table == null) {
                    if (this.tableName == null && this.canRefSelectedCol()) {
                        Column column = Select.this.getColumn(this.fieldName);
                        if (column == null) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(String.valueOf(this.fieldName) + mm.getMessage("field.notExist"));
                        }
                    } else {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(String.valueOf(this.fieldName) + mm.getMessage("field.notExist"));
                    }
                }
            }
            return this.table;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof FieldNode)) {
                return false;
            }
            FieldNode other = (FieldNode)node;
            return this.getTable() == other.getTable() && Select.isEquals(this.fieldName, other.fieldName);
        }

        public boolean isEqualField(String field) {
            return Select.isEquals(this.fieldName, field);
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            resultList.add(this);
        }

        public void analyseFieldNode() {
            ITable table = this.getTable();
            if (table != null) {
                table.addUsedField(this.fieldName);
            }
        }

        private boolean canRefSelectedCol() {
            return this.part == Part.Order || this.part == Part.Having;
        }

        @Override
        public String toSPL() {
            Column column;
            if (this.canRefSelectedCol() && this.tableName == null && (column = Select.this.getColumn(this.fieldName)) != null) {
                return column.toSPL();
            }
            ITable table = this.getTable();
            if (table == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.fieldName) + mm.getMessage("ds.fieldNotExist"));
            }
            DataStruct ds = table.getDataStruct();
            int findex = Select.getFieldIndex(ds, this.fieldName);
            if (findex == -1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.fieldName) + mm.getMessage("ds.fieldNotExist"));
            }
            String joinFieldName = table.getJoinFieldName();
            if (joinFieldName != null) {
                return String.valueOf(joinFieldName) + "." + ds.getFieldName(findex);
            }
            int level = Select.this.getLevel() - table.getSelectLevel();
            if (level == 0) {
                return ds.getFieldName(findex);
            }
            return "get(" + level + "," + ds.getFieldName(findex) + ")";
        }

        public String toMoveExp(int move) {
            ITable table = this.getTable();
            if (table == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.fieldName) + mm.getMessage("ds.fieldNotExist"));
            }
            DataStruct ds = table.getDataStruct();
            int findex = Select.getFieldIndex(ds, this.fieldName);
            if (findex == -1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.fieldName) + mm.getMessage("ds.fieldNotExist"));
            }
            String joinFieldName = table.getJoinFieldName();
            if (joinFieldName != null) {
                return String.valueOf(joinFieldName) + "." + ds.getFieldName(findex) + "[" + move + "]";
            }
            int level = Select.this.getLevel() - table.getSelectLevel();
            if (level == 0) {
                return String.valueOf(ds.getFieldName(findex)) + "[" + move + "]";
            }
            return "get(" + level + "," + ds.getFieldName(findex) + ";" + move + ")";
        }
    }

    class Function
    extends Exp {
        protected String fnName;
        protected String opt;
        private List<Exp> params;

        public Function(int start, int end) {
            super(start, end);
        }

        public Function(int start, int end, String fnName, String opt, List<Exp> params) {
            super(start, end);
            this.fnName = this.translateFunction(fnName);
            this.opt = opt;
            this.params = params;
        }

        public String getFnName() {
            return this.fnName;
        }

        public String getOpt() {
            return this.opt;
        }

        public List<Exp> getParams() {
            return this.params;
        }

        private String translateFunction(String fnName) {
            if (fnName.equalsIgnoreCase("coalesce")) {
                return "nvl";
            }
            return fnName;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof Function)) {
                return false;
            }
            Function other = (Function)node;
            if (!Select.isEquals(other.fnName, this.fnName)) {
                return false;
            }
            if (this.opt == null ? other.opt != null : other.opt == null || !this.opt.equals(other.opt)) {
                return false;
            }
            if (this.params == null) {
                return other.params == null;
            }
            if (other.params == null) {
                return false;
            }
            int pcount = this.params.size();
            if (pcount != other.params.size()) {
                return false;
            }
            int i = 0;
            while (i < pcount) {
                if (!Select.isEquals(this.params.get(i), other.params.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            if (this.params != null) {
                for (Exp exp : this.params) {
                    exp.getFields(resultList);
                }
            }
        }

        @Override
        public String toSPL() {
            String spl = this.fnName;
            if (this.opt != null) {
                spl = String.valueOf(spl) + this.opt;
            }
            spl = String.valueOf(spl) + "(";
            if (this.params != null) {
                int size = this.params.size();
                int i = 0;
                while (i < size) {
                    if (i > 0) {
                        spl = String.valueOf(spl) + ",";
                    }
                    spl = String.valueOf(spl) + this.params.get(i).toSPL();
                    ++i;
                }
            }
            spl = String.valueOf(spl) + ")";
            return spl;
        }

        @Override
        public String toSPL(int groupByCount) {
            String spl = this.fnName;
            if (this.opt != null) {
                spl = String.valueOf(spl) + this.opt;
            }
            spl = String.valueOf(spl) + "(";
            if (this.params != null) {
                int size = this.params.size();
                int i = 0;
                while (i < size) {
                    if (i > 0) {
                        spl = String.valueOf(spl) + ",";
                    }
                    spl = String.valueOf(spl) + this.params.get(i).toSPL(groupByCount);
                    ++i;
                }
            }
            spl = String.valueOf(spl) + ")";
            return spl;
        }
    }

    class GatherNode
    extends Function {
        private Exp param;
        private int fieldSeq;

        public GatherNode(int start, int end, String fnName, String opt, Exp param) {
            super(start, end);
            this.fnName = fnName.toLowerCase();
            this.opt = opt;
            this.param = param;
        }

        public int getFieldSeq() {
            return this.fieldSeq;
        }

        public void setFieldSeq(int fieldSeq) {
            this.fieldSeq = fieldSeq;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof GatherNode)) {
                return false;
            }
            GatherNode other = (GatherNode)node;
            if (!Select.isEquals(other.fnName, this.fnName)) {
                return false;
            }
            if (this.opt == null ? other.opt != null : other.opt == null || !this.opt.equals(other.opt)) {
                return false;
            }
            return Select.isEquals(this.param, other.param);
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            this.param.getFields(resultList);
        }

        @Override
        public String toSPL() {
            if (this.opt == null) {
                return String.valueOf(this.fnName) + "(" + this.param.toSPL() + ")";
            }
            return String.valueOf(this.fnName) + "@" + this.opt + "(" + this.param.toSPL() + ")";
        }

        @Override
        public String toSPL(int groupByCount) {
            return "#" + (groupByCount + this.fieldSeq);
        }
    }

    class In
    extends Exp {
        private Exp left;
        private List<Exp> exps;
        private IQuery subQuery;
        private boolean isNot;

        public In(int start, int end) {
            super(start, end);
        }

        public void setLeft(Exp left) {
            this.left = left;
            this.setStart(left.getStart());
        }

        public void setRight(List<Exp> right) {
            this.exps = right;
        }

        public void setRight(IQuery right) {
            this.subQuery = right;
        }

        public void setNot(boolean isNot) {
            this.isNot = isNot;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof In)) {
                return false;
            }
            In other = (In)node;
            if (this.isNot != other.isNot || !Select.isEquals(this.left, other.left)) {
                return false;
            }
            if (this.exps == null || other.exps == null) {
                return false;
            }
            int count = this.exps.size();
            if (count != other.exps.size()) {
                return false;
            }
            int i = 0;
            while (i < count) {
                if (!Select.isEquals(this.exps.get(i), other.exps.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            this.left.getFields(resultList);
            if (this.exps != null) {
                for (Exp exp : this.exps) {
                    exp.getFields(resultList);
                }
            }
        }

        @Override
        public String toSPL() {
            String spl;
            String x = this.left.toSPL();
            if (this.exps == null) {
                spl = this.subQuery.toIn(x);
            } else {
                int size = this.exps.size();
                if (size == 1 && this.exps.get(0) instanceof CommonNode) {
                    String v = this.exps.get(0).toSPL();
                    Param p = Select.this.ctx.getParam(v);
                    spl = p != null && p.getValue() instanceof Sequence ? String.valueOf(v) + ".contain(" + x + ")" : "[" + v + "]" + ".contain(" + x + ")";
                } else {
                    spl = "[";
                    int i = 0;
                    while (i < size) {
                        if (i > 0) {
                            spl = String.valueOf(spl) + ",";
                        }
                        Exp exp = this.exps.get(i);
                        spl = String.valueOf(spl) + exp.toSPL();
                        ++i;
                    }
                    spl = String.valueOf(spl) + "].contain(" + x + ")";
                }
            }
            if (this.isNot) {
                return "!" + spl;
            }
            return spl;
        }

        @Override
        public String toSPL(int groupByCount) {
            String spl;
            String x = this.left.toSPL();
            if (this.exps == null) {
                spl = this.subQuery.toIn(x);
            } else {
                int size = this.exps.size();
                if (size == 1 && this.exps.get(0) instanceof CommonNode) {
                    String v = this.exps.get(0).toSPL(groupByCount);
                    Param p = Select.this.ctx.getParam(v);
                    spl = p != null && p.getValue() instanceof Sequence ? String.valueOf(v) + ".contain(" + x + ")" : "[" + v + "]" + ".contain(" + x + ")";
                } else {
                    spl = "[";
                    int i = 0;
                    while (i < size) {
                        if (i > 0) {
                            spl = String.valueOf(spl) + ",";
                        }
                        Exp exp = this.exps.get(i);
                        spl = String.valueOf(spl) + exp.toSPL(groupByCount);
                        ++i;
                    }
                    spl = String.valueOf(spl) + "].contain(" + x + ")";
                }
            }
            if (this.isNot) {
                return "!" + spl;
            }
            return spl;
        }
    }

    class IsNull
    extends Exp {
        private Exp exp;
        private boolean isNot;

        public IsNull(int end, Exp exp, boolean isNot) {
            super(exp.getStart(), end);
            this.exp = exp;
            this.isNot = isNot;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof IsNull)) {
                return false;
            }
            IsNull other = (IsNull)node;
            return this.isNot == other.isNot && Select.isEquals(this.exp, other.exp);
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            this.exp.getFields(resultList);
        }

        @Override
        public String toSPL() {
            if (this.isNot) {
                return String.valueOf(this.exp.toSPL()) + "!=null";
            }
            return String.valueOf(this.exp.toSPL()) + "==null";
        }

        @Override
        public String toSPL(int groupByCount) {
            if (this.isNot) {
                return String.valueOf(this.exp.toSPL(groupByCount)) + "!=null";
            }
            return String.valueOf(this.exp.toSPL(groupByCount)) + "==null";
        }
    }

    class Like
    extends Exp {
        private Exp left;
        private Exp right;
        private boolean isNot;

        public Like(int start, int end) {
            super(start, end);
        }

        public void setLeft(Exp left) {
            this.left = left;
            this.setStart(left.getStart());
        }

        public void setRight(Exp right) {
            this.right = right;
            this.setEnd(right.getEnd());
        }

        public void setNot(boolean isNot) {
            this.isNot = isNot;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof Like)) {
                return false;
            }
            Like other = (Like)node;
            return this.isNot == other.isNot && Select.isEquals(this.left, other.left) && Select.isEquals(this.right, other.right);
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            this.left.getFields(resultList);
            this.right.getFields(resultList);
        }

        @Override
        public String toSPL() {
            Param p;
            String pattern = this.right.toSPL();
            if (this.right instanceof CommonNode && (p = Select.this.ctx.getParam(pattern)) != null) {
                Object val = p.getValue();
                if (val instanceof String) {
                    pattern = (String)val;
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("like" + mm.getMessage("function.paramTypeError"));
                }
            }
            if (this.isNot) {
                return "!like@s(" + this.left.toSPL() + "," + pattern + ")";
            }
            return "like@s(" + this.left.toSPL() + "," + pattern + ")";
        }

        @Override
        public String toSPL(int groupByCount) {
            Param p;
            String pattern = this.right.toSPL(groupByCount);
            if (this.right instanceof CommonNode && (p = Select.this.ctx.getParam(pattern)) != null) {
                Object val = p.getValue();
                if (val instanceof String) {
                    pattern = (String)val;
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("like" + mm.getMessage("function.paramTypeError"));
                }
            }
            if (this.isNot) {
                return "!like@s(" + this.left.toSPL(groupByCount) + "," + pattern + ")";
            }
            return "like@s(" + this.left.toSPL(groupByCount) + "," + pattern + ")";
        }
    }

    class LogicExp
    extends Exp {
        private List<Exp> exps;

        public LogicExp(List<Exp> exps) {
            super(exps.get(0).getStart(), exps.get(exps.size() - 1).getEnd());
            this.exps = exps;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof LogicExp)) {
                return false;
            }
            LogicExp other = (LogicExp)node;
            int count = this.exps.size();
            if (count != other.exps.size()) {
                return false;
            }
            int i = 0;
            while (i < count) {
                if (!Select.isEquals(this.exps.get(i), other.exps.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public List<And> splitAnd() {
            Exp exp;
            List<Exp> exps = this.exps;
            int start = 0;
            int count = exps.size();
            ArrayList<And> result = new ArrayList<And>();
            int i = 0;
            while (i < count) {
                exp = exps.get(i);
                if (exp.isOr()) {
                    start = 0;
                    result.clear();
                    break;
                }
                if (exp.isAnd()) {
                    ArrayList<Exp> list;
                    int subCount = i - start;
                    if (subCount == 0) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + exp.getPos());
                    }
                    if (subCount == 1) {
                        list = exps.get(start).splitAnd();
                        result.addAll(list);
                    } else {
                        list = new ArrayList(subCount);
                        ArrayList<FieldNode> fieldList = new ArrayList<FieldNode>();
                        while (start < i) {
                            exp = exps.get(start);
                            exp.getFields(fieldList);
                            list.add(exp);
                            ++start;
                        }
                        And and = new And(new LogicExp(list), fieldList);
                        result.add(and);
                    }
                    start = i + 1;
                }
                ++i;
            }
            if (start == 0) {
                ArrayList<FieldNode> fieldList = new ArrayList<FieldNode>();
                while (start < count) {
                    exp = exps.get(start);
                    exp.getFields(fieldList);
                    ++start;
                }
                And and = new And(this, fieldList);
                result.add(and);
            } else {
                ArrayList<Exp> list;
                int subCount = count - start;
                if (subCount == 0) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + exps.get(count - 1).getPos());
                }
                if (subCount == 1) {
                    list = exps.get(start).splitAnd();
                    result.addAll(list);
                } else {
                    list = new ArrayList(subCount);
                    ArrayList<FieldNode> fieldList = new ArrayList<FieldNode>();
                    while (start < count) {
                        Exp exp2 = exps.get(start);
                        exp2.getFields(fieldList);
                        list.add(exp2);
                        ++start;
                    }
                    And and = new And(new LogicExp(list), fieldList);
                    result.add(and);
                }
            }
            return result;
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            for (Exp exp : this.exps) {
                exp.getFields(resultList);
            }
        }

        @Override
        public String toSPL() {
            int size = this.exps.size();
            String spl = this.exps.get(0).toSPL();
            int i = 1;
            while (i < size) {
                spl = String.valueOf(spl) + " ";
                spl = String.valueOf(spl) + this.exps.get(i).toSPL();
                ++i;
            }
            return spl;
        }

        @Override
        public String toSPL(int groupByCount) {
            int size = this.exps.size();
            String spl = this.exps.get(0).toSPL(groupByCount);
            int i = 1;
            while (i < size) {
                spl = String.valueOf(spl) + " ";
                spl = String.valueOf(spl) + this.exps.get(i).toSPL(groupByCount);
                ++i;
            }
            return spl;
        }

        public String toSPL(int start, int next) {
            String spl = this.exps.get(start).toSPL();
            ++start;
            while (start < next) {
                spl = String.valueOf(spl) + " ";
                spl = String.valueOf(spl) + this.exps.get(start).toSPL();
                ++start;
            }
            return spl;
        }

        public Exp getSubExp(int start, int next) {
            if (start + 1 == next) {
                return this.exps.get(start);
            }
            List<Exp> subList = this.exps.subList(start, next);
            return new LogicExp(subList);
        }

        @Override
        public boolean splitJionExp(ITable leftTable, ITable rightTable, List<Expression> leftExpList, List<Expression> rightExpList) {
            ITable table2;
            int size = this.exps.size();
            int equalIndex = -1;
            ArrayList<FieldNode> fieldList1 = new ArrayList<FieldNode>();
            ArrayList<FieldNode> fieldList2 = new ArrayList<FieldNode>();
            int i = 0;
            while (i < size) {
                Exp exp = this.exps.get(i);
                if (exp.isEqualOperator()) {
                    equalIndex = i;
                } else if (equalIndex == -1) {
                    exp.getFields(fieldList1);
                } else {
                    exp.getFields(fieldList2);
                }
                ++i;
            }
            if (equalIndex == -1 || fieldList1.size() == 0 || fieldList2.size() == 0) {
                return false;
            }
            ITable table1 = ((FieldNode)fieldList1.get(0)).getTable();
            if (table1 == (table2 = ((FieldNode)fieldList2.get(0)).getTable())) {
                return false;
            }
            int i2 = 1;
            while (i2 < fieldList1.size()) {
                if (((FieldNode)fieldList1.get(i2)).getTable() != table1) {
                    return false;
                }
                ++i2;
            }
            i2 = 1;
            while (i2 < fieldList2.size()) {
                if (((FieldNode)fieldList2.get(i2)).getTable() != table2) {
                    return false;
                }
                ++i2;
            }
            String spl = this.toSPL(0, equalIndex);
            Expression exp1 = new Expression(Select.this.ctx, spl);
            spl = this.toSPL(equalIndex + 1, size);
            Expression exp2 = new Expression(Select.this.ctx, spl);
            if (table1 == leftTable) {
                leftExpList.add(exp1);
                rightExpList.add(exp2);
            } else {
                leftExpList.add(exp2);
                rightExpList.add(exp1);
            }
            return true;
        }

        @Override
        public boolean splitJionExp(List<ITable> tableList, List<Exp> leftExpList, List<Exp> rightExpList) {
            int size = this.exps.size();
            int equalIndex = -1;
            ArrayList<FieldNode> fieldList1 = new ArrayList<FieldNode>();
            ArrayList<FieldNode> fieldList2 = new ArrayList<FieldNode>();
            int i = 0;
            while (i < size) {
                Exp exp = this.exps.get(i);
                if (exp.isEqualOperator()) {
                    equalIndex = i;
                } else if (equalIndex == -1) {
                    exp.getFields(fieldList1);
                } else {
                    exp.getFields(fieldList2);
                }
                ++i;
            }
            if (equalIndex == -1 || fieldList1.size() == 0 || fieldList2.size() == 0) {
                return false;
            }
            int tableCount = tableList.size();
            ITable rightTable = tableList.get(tableCount - 1);
            if (((FieldNode)fieldList1.get(0)).getTable() == rightTable) {
                int i2 = 1;
                while (i2 < fieldList1.size()) {
                    if (((FieldNode)fieldList1.get(i2)).getTable() != rightTable) {
                        return false;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < fieldList2.size()) {
                    if (((FieldNode)fieldList2.get(i2)).getTable() == rightTable) {
                        return false;
                    }
                    ++i2;
                }
                Exp exp1 = this.getSubExp(0, equalIndex);
                Exp exp2 = this.getSubExp(equalIndex + 1, size);
                leftExpList.add(exp2);
                rightExpList.add(exp1);
                return true;
            }
            if (((FieldNode)fieldList2.get(0)).getTable() == rightTable) {
                int i3 = 1;
                while (i3 < fieldList2.size()) {
                    if (((FieldNode)fieldList2.get(i3)).getTable() != rightTable) {
                        return false;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < fieldList1.size()) {
                    if (((FieldNode)fieldList1.get(i3)).getTable() == rightTable) {
                        return false;
                    }
                    ++i3;
                }
                Exp exp1 = this.getSubExp(0, equalIndex);
                Exp exp2 = this.getSubExp(equalIndex + 1, size);
                leftExpList.add(exp1);
                rightExpList.add(exp2);
                return true;
            }
            return false;
        }

        @Override
        public boolean splitParentJionExp(List<ITable> subTableList, List<Expression> subExpList, List<String> parentExpList) {
            int size = this.exps.size();
            int equalIndex = -1;
            ArrayList<FieldNode> fieldList1 = new ArrayList<FieldNode>();
            ArrayList<FieldNode> fieldList2 = new ArrayList<FieldNode>();
            int i = 0;
            while (i < size) {
                Exp exp = this.exps.get(i);
                if (exp.isEqualOperator()) {
                    equalIndex = i;
                } else if (equalIndex == -1) {
                    exp.getFields(fieldList1);
                } else {
                    exp.getFields(fieldList2);
                }
                ++i;
            }
            if (equalIndex == -1 || fieldList1.size() == 0 || fieldList2.size() == 0) {
                return false;
            }
            ITable table = ((FieldNode)fieldList1.get(0)).getTable();
            if (subTableList.contains(table)) {
                int i2 = 1;
                while (i2 < fieldList1.size()) {
                    table = ((FieldNode)fieldList1.get(i2)).getTable();
                    if (!subTableList.contains(table)) {
                        return false;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < fieldList2.size()) {
                    table = ((FieldNode)fieldList2.get(i2)).getTable();
                    if (subTableList.contains(table)) {
                        return false;
                    }
                    ++i2;
                }
                String spl = this.toSPL(0, equalIndex);
                Expression exp1 = new Expression(Select.this.ctx, spl);
                subExpList.add(exp1);
                spl = this.toSPL(equalIndex + 1, size);
                parentExpList.add(spl);
                return true;
            }
            int i3 = 1;
            while (i3 < fieldList1.size()) {
                table = ((FieldNode)fieldList1.get(i3)).getTable();
                if (subTableList.contains(table)) {
                    return false;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < fieldList2.size()) {
                table = ((FieldNode)fieldList2.get(i3)).getTable();
                if (!subTableList.contains(table)) {
                    return false;
                }
                ++i3;
            }
            String spl = this.toSPL(0, equalIndex);
            parentExpList.add(spl);
            spl = this.toSPL(equalIndex + 1, size);
            Expression exp2 = new Expression(Select.this.ctx, spl);
            subExpList.add(exp2);
            return true;
        }
    }

    class Not
    extends Exp {
        private Exp exp;

        public Not(int start, int end) {
            super(start, end);
        }

        public void setExp(Exp exp) {
            this.exp = exp;
            this.setEnd(exp.getEnd());
        }

        @Override
        public boolean isLogicalOperator() {
            return true;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof Not)) {
                return false;
            }
            Not other = (Not)node;
            return Select.isEquals(this.exp, other.exp);
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            this.exp.getFields(resultList);
        }

        @Override
        public String toSPL() {
            return "!(" + this.exp.toSPL() + ")";
        }

        @Override
        public String toSPL(int groupByCount) {
            return "!(" + this.exp.toSPL(groupByCount) + ")";
        }
    }

    class Paren
    extends Exp {
        private Exp exp;

        public Paren(int start, int end, Exp exp) {
            super(start, end);
            this.exp = exp;
        }

        @Override
        public boolean isEquals(Exp node) {
            if (!(node instanceof Paren)) {
                return false;
            }
            Paren other = (Paren)node;
            return Select.isEquals(this.exp, other.exp);
        }

        @Override
        public void getFields(List<FieldNode> resultList) {
            this.exp.getFields(resultList);
        }

        @Override
        public String toSPL() {
            return "(" + this.exp.toSPL() + ")";
        }

        @Override
        public String toSPL(int groupByCount) {
            return "(" + this.exp.toSPL(groupByCount) + ")";
        }

        @Override
        public List<And> splitAnd() {
            List<And> list = this.exp.splitAnd();
            if (list.size() == 1) {
                list.get(0).setExp(this);
            }
            return list;
        }

        @Override
        public boolean splitJionExp(ITable leftTable, ITable rightTable, List<Expression> leftExpList, List<Expression> rightExpList) {
            return this.exp.splitJionExp(leftTable, rightTable, leftExpList, rightExpList);
        }

        @Override
        public boolean splitJionExp(List<ITable> tableList, List<Exp> leftExpList, List<Exp> rightExpList) {
            return this.exp.splitJionExp(tableList, leftExpList, rightExpList);
        }

        @Override
        public boolean splitParentJionExp(List<ITable> subTableList, List<Expression> subExpList, List<String> parentExpList) {
            return this.exp.splitParentJionExp(subTableList, subExpList, parentExpList);
        }
    }

    static enum Part {
        Column,
        Join,
        Where,
        Group,
        Having,
        Order;

    }

    class QueryNode
    extends Exp {
        private IQuery query;

        public QueryNode(int start, int end, IQuery query) {
            super(start, end);
            this.query = query;
        }

        @Override
        public boolean isEquals(Exp node) {
            return node == this;
        }

        @Override
        public String toSPL() {
            return this.query.toSPL();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WindowFunction
    extends IlllIlIIIllllllI {
        private IlllIlIIIllllllI _$11;
        private List<llIIIIIIIlllIlll> _$10;
        private List<lIllIlllIIIIlIll> _$9;
        private String _$8;
        private String _$7;
        private String _$6;
        private String _$5;
        final /* synthetic */ lllIIIIllIllIIlI _$4;

        public WindowFunction(lllIIIIllIllIIlI lllIIIIllIllIIlI2, int start, int end, IlllIlIIIllllllI leftFunction) {
            this._$4 = lllIIIIllIllIIlI2;
            super(lllIIIIllIllIIlI2, start, end);
            this._$6 = "WindowFunction" + this.hashCode();
            this._$5 = this._$6 + "(#)";
            this._$11 = leftFunction;
        }

        public boolean isCompatibal(WindowFunction other) {
            int i;
            if (this._$10 != null) {
                if (other._$10 == null || this._$10.size() != other._$10.size()) {
                    return false;
                }
                for (i = 0; i < this._$10.size(); ++i) {
                    if (this._$10.get(i).isEquals(other._$10.get(i))) continue;
                    return false;
                }
            } else if (other._$10 != null) {
                return false;
            }
            if (this._$9 == null || other._$9 == null) {
                return true;
            }
            if (this._$9.size() != other._$9.size()) {
                return false;
            }
            for (i = 0; i < this._$9.size(); ++i) {
                if (this._$9.get(i).isEquals(other._$9.get(i))) continue;
                return false;
            }
            return true;
        }

        public IlllIlIIIllllllI getLeftFunction() {
            return this._$11;
        }

        public List<llIIIIIIIlllIlll> getPartitionBy() {
            return this._$10;
        }

        public void setPartitionBy(List<llIIIIIIIlllIlll> partitionBy) {
            this._$10 = partitionBy;
        }

        public List<lIllIlllIIIIlIll> getOrderBy() {
            return this._$9;
        }

        public void setOrderBy(List<lIllIlllIIIIlIll> orderBy) {
            this._$9 = orderBy;
        }

        public String getPrecedingExp() {
            return this._$8;
        }

        public void setPrecedingExp(String precedingExp) {
            this._$8 = precedingExp;
        }

        public String getFollowingExp() {
            return this._$7;
        }

        public void setFollowingExp(String followingExp) {
            this._$7 = followingExp;
        }

        public void setRows(String precedingExp, String followingExp) {
            this._$8 = precedingExp;
            this._$7 = followingExp;
        }

        @Override
        public boolean isEquals(llIIIIIIIlllIlll node) {
            return false;
        }

        @Override
        public void getFields(List<llIllIllIIIlIlll> resultList) {
            this._$11.getFields(resultList);
            if (this._$10 != null) {
                for (llIIIIIIIlllIlll exp : this._$10) {
                    exp.getFields(resultList);
                }
            }
            if (this._$9 != null) {
                for (lIllIlllIIIIlIll sortItem : this._$9) {
                    sortItem.getSortExp().getFields(resultList);
                }
            }
        }

        public String toCalcExpression() {
            if (this._$11 instanceof llIIIllllIIlIlII) {
                if (this._$8 == null && this._$7 == null) {
                    String expStr = this._$6 + "=~." + this._$11.toSPL();
                    this._$5 = this._$6;
                    return expStr;
                }
                String expStr = this._$6 + "=~," + "~.(" + this._$6 + ".to(";
                if (this._$8 != null) {
                    expStr = expStr + this._$8;
                }
                expStr = expStr + ",";
                if (this._$7 != null) {
                    expStr = expStr + this._$7;
                }
                expStr = expStr + ")." + this._$11.toSPL() + ")";
                return this._$6 + "=(" + expStr + ")";
            }
            String fnName = this._$11.getFnName();
            if (fnName.equalsIgnoreCase("row_number")) {
                this._$5 = "#";
                return null;
            }
            if (fnName.equalsIgnoreCase("rank")) {
                String expStr = this._$6 + "=~.(" + this._$3() + ").ranks@o()";
                return expStr;
            }
            if (fnName.equalsIgnoreCase("dense_rank")) {
                String expStr = this._$6 + "=~.(" + this._$3() + ").ranks@oi()";
                return expStr;
            }
            if (fnName.equalsIgnoreCase("lag")) {
                this._$5 = this._$2();
                return null;
            }
            if (fnName.equalsIgnoreCase("lead")) {
                this._$5 = this._$1();
                return null;
            }
            throw new RQException("Unsupported window function: " + fnName);
        }

        public void setPartitionData(Sequence data, Context ctx) {
            Object result;
            ctx.setParamValue(this._$6, (Object)data);
            if (this._$11 instanceof llIIIllllIIlIlII) {
                if (this._$8 == null && this._$7 == null) {
                    String expStr = this._$6 + "." + this._$11.toSPL();
                    Expression exp = new Expression(ctx, expStr);
                    result = exp.calculate(ctx);
                    this._$5 = this._$6;
                } else {
                    String expStr = this._$6 + ".to(";
                    if (this._$8 != null) {
                        expStr = expStr + this._$8;
                    }
                    expStr = expStr + ",";
                    if (this._$7 != null) {
                        expStr = expStr + this._$7;
                    }
                    expStr = expStr + ")." + this._$11.toSPL();
                    Expression exp = new Expression(ctx, expStr);
                    result = data.calc(exp, ctx);
                }
            } else {
                String fnName = this._$11.getFnName();
                if (fnName.equalsIgnoreCase("row_number")) {
                    result = new Sequence(1, data.length());
                } else if (fnName.equalsIgnoreCase("rank")) {
                    result = this._$1(data, false, ctx);
                } else if (fnName.equalsIgnoreCase("dense_rank")) {
                    result = this._$1(data, true, ctx);
                } else if (fnName.equalsIgnoreCase("lag")) {
                    this._$5 = this._$2();
                    result = null;
                } else if (fnName.equalsIgnoreCase("lead")) {
                    this._$5 = this._$1();
                    result = null;
                } else {
                    throw new RQException("Unsupported window function: " + fnName);
                }
            }
            ctx.setParamValue(this._$6, result);
        }

        private String _$3() {
            String expStr;
            int size = this._$9.size();
            if (size == 1) {
                llIIIIIIIlllIlll exp = this._$9.get(0).getSortExp();
                expStr = exp.toSPL();
            } else {
                llIIIIIIIlllIlll exp = this._$9.get(0).getSortExp();
                expStr = "[" + exp.toSPL();
                for (int i = 1; i < size; ++i) {
                    exp = this._$9.get(i).getSortExp();
                    expStr = expStr + "," + exp.toSPL();
                }
                expStr = expStr + "]";
            }
            return expStr;
        }

        private Sequence _$1(Sequence data, boolean isDense, Context ctx) {
            if (this._$9 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$11.getFnName() + mm.getMessage("function.invalidParam"));
            }
            String expStr = this._$3();
            Expression exp = new Expression(ctx, expStr);
            data = data.calc(exp, ctx);
            int len = data.length();
            ObjectArray array = new ObjectArray(len);
            Object prev = data.getMem(1);
            array.push((Object)ObjectCache.getInteger((int)1));
            if (isDense) {
                int rank = 1;
                for (int i = 2; i <= len; ++i) {
                    Object cur = data.getMem(i);
                    if (!Variant.isEquals((Object)prev, (Object)cur)) {
                        ++rank;
                        prev = cur;
                    }
                    array.push((Object)ObjectCache.getInteger((int)rank));
                }
            } else {
                for (int i = 2; i <= len; ++i) {
                    Object cur = data.getMem(i);
                    if (Variant.isEquals((Object)prev, (Object)cur)) {
                        array.push(array.get(i - 1));
                        continue;
                    }
                    prev = cur;
                    array.push((Object)ObjectCache.getInteger((int)i));
                }
            }
            return new Sequence((IArray)array);
        }

        private String _$2() {
            llIIIIIIIlllIlll exp;
            List<llIIIIIIIlllIlll> params = this._$11.getParams();
            if (params == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$11.getFnName() + mm.getMessage("function.invalidParam"));
            }
            int pcount = params.size();
            if (pcount < 1 || pcount > 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$11.getFnName() + mm.getMessage("function.invalidParam"));
            }
            int move = -1;
            if (pcount > 1) {
                String str = params.get(1).toSPL();
                move = Integer.parseInt(str);
                if (move < 1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this._$11.getFnName() + mm.getMessage("function.invalidParam"));
                }
                move = -move;
            }
            if (!((exp = params.get(0)) instanceof llIllIllIIIlIlll)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$11.getFnName() + mm.getMessage("function.invalidParam"));
            }
            String expStr = ((llIllIllIIIlIlll)exp).toMoveExp(move);
            if (pcount == 3) {
                exp = params.get(2);
                return "nvl(" + expStr + "," + exp.toSPL() + ")";
            }
            return expStr;
        }

        private String _$1() {
            String str;
            List<llIIIIIIIlllIlll> params = this._$11.getParams();
            if (params == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$11.getFnName() + mm.getMessage("function.invalidParam"));
            }
            int pcount = params.size();
            if (pcount < 1 || pcount > 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$11.getFnName() + mm.getMessage("function.invalidParam"));
            }
            int move = 1;
            if (pcount > 1 && (move = Integer.parseInt(str = params.get(1).toSPL())) < 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$11.getFnName() + mm.getMessage("function.invalidParam"));
            }
            llIIIIIIIlllIlll exp = params.get(0);
            if (!(exp instanceof llIllIllIIIlIlll)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$11.getFnName() + mm.getMessage("function.invalidParam"));
            }
            String expStr = ((llIllIllIIIlIlll)exp).toMoveExp(move);
            if (pcount == 3) {
                exp = params.get(2);
                return "nvl(" + expStr + "," + exp.toSPL() + ")";
            }
            return expStr;
        }

        @Override
        public String toSPL() {
            return this._$5;
        }

        @Override
        public String toSPL(int groupByCount) {
            throw new RQException();
        }
    }
}

