/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.query.sqlplus.IQuery;
import com.scudata.dm.query.sqlplus.ITable;
import com.scudata.dm.query.sqlplus.Select;
import com.scudata.expression.Expression;

class SubQuery
extends ITable {
    private IQuery query;

    public SubQuery(Select select, IQuery query) {
        super(select);
        this.query = query;
    }

    @Override
    public DataStruct getDataStruct() {
        return this.query.getDataStruct();
    }

    @Override
    public ITable getTable(String tableName, String fieldName) {
        if (tableName != null) {
            if (Select.isEquals(this.aliasName, tableName)) {
                return this;
            }
            return null;
        }
        DataStruct ds = this.getDataStruct();
        int findex = Select.getFieldIndex(ds, fieldName);
        if (findex != -1) {
            return this;
        }
        return null;
    }

    @Override
    public ITable getTable(String tableName) {
        if (Select.isEquals(this.aliasName, tableName)) {
            return this;
        }
        return null;
    }

    @Override
    public void addUsedField(String fieldName) {
    }

    @Override
    public String[] getPrimaryKey() {
        if (this.primaryKey == null) {
            this.primaryKey = this.query.getPrimaryKey();
        }
        return this.primaryKey;
    }

    @Override
    public String[] getSortedFieldNames() {
        if (this.sortedFieldNames == null) {
            this.sortedFieldNames = this.query.getSortedFieldNames();
        }
        return this.sortedFieldNames;
    }

    @Override
    public Object getData(Select.Exp where) {
        DataStruct ds;
        Object data = this.query.execute();
        if (data == null) {
            return null;
        }
        if (data instanceof Sequence) {
            ds = ((Sequence)data).getFirstRecordDataStruct();
            if (ds != null) {
                this.primaryKey = ds.getPrimary();
            }
        } else if (data instanceof ICursor && (ds = ((ICursor)data).getDataStruct()) != null) {
            this.primaryKey = ds.getPrimary();
        }
        Context ctx = this.select.getContext();
        Expression exp = null;
        if (where != null) {
            String spl = where.toSPL();
            exp = new Expression(ctx, spl);
        } else if (this.filter != null) {
            exp = new Expression(ctx, this.filter);
        } else {
            return data;
        }
        if (data instanceof ICursor) {
            ICursor cs = (ICursor)data;
            return cs.select(null, exp, null, ctx);
        }
        Sequence seq = (Sequence)data;
        return seq.select(exp, null, ctx);
    }

    public IQuery getQuery() {
        return this.query;
    }
}

