/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.query.sqlplus.Token;
import com.scudata.resources.ParseMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class Tokenizer {
    public static final char KEYWORD = '\u0000';
    public static final char IDENT = '\u0001';
    public static final char NUMBER = '\u0002';
    public static final char STRING = '\u0003';
    public static final char OPERATOR = '\u0004';
    public static final char LPAREN = '(';
    public static final char RPAREN = ')';
    public static final char COMMA = ',';
    public static final char DOT = '.';
    public static final char PARAMMARK = '?';
    public static final char OPTIONMARK = '@';
    private static final String OPSTRING = "+-*/=<>&|^%!~";
    private static final String[] GATHERS = new String[]{"AVG", "COUNT", "MAX", "MIN", "SUM"};
    public static final String COL_AS = " ";
    public static final String TABLE_AS = " ";
    private static final String[] OPKEYWORDS = new String[]{"AND", "OR", "LIKE", "NOT"};
    private static final String[] SQLKEYWORDS = new String[]{"ALL", "AND", "AS", "ASC", "BETWEEN", "BOTTOM", "BY", "CALL", "CASE", "CREATE", "CROSS", "DESC", "DISTINCT", "DROP", "ELSE", "END", "EXCEPT", "EXISTS", "FETCH", "FIRST", "FROM", "FULL", "GROUP", "HAVING", "IN", "INNER", "INTERSECT", "INTO", "IS", "JOIN", "LEFT", "LIKE", "LIMIT", "MINUS", "NOT", "NULL", "OFFSET", "ON", "ONLY", "OR", "ORDER", "OUTER", "RECURSIVE", "RIGHT", "ROWS", "SELECT", "TABLE", "TEMP", "TEMPORARY", "THEN", "TO", "TOP", "UNION", "WHEN", "WHERE", "WITH"};
    private static final String[] LISTKEYWORDS = new String[]{"DEPTH", "DIM", "FIELD", "FOREIGN", "KEY", "LAYER", "LIST", "METADATA", "OF", "PRIMARY", "SUB", "TABLE", "TYPE"};
    private static final Map<String, String> normalFuncMap = new HashMap<String, String>();

    static {
        normalFuncMap.put("ABS", "abs");
        normalFuncMap.put("ACOS", "acos");
        normalFuncMap.put("ACOSH", "acosh");
        normalFuncMap.put("ASIN", "asin");
        normalFuncMap.put("ASINH", "asinh");
        normalFuncMap.put("ATAN", "atan");
        normalFuncMap.put("ATANH", "atanh");
        normalFuncMap.put("CEIL", "ceil");
        normalFuncMap.put("COMBIN", "combin");
        normalFuncMap.put("COS", "cos");
        normalFuncMap.put("COSH", "cosh");
        normalFuncMap.put("EXP", "exp");
        normalFuncMap.put("FACT", "fact");
        normalFuncMap.put("FLOOR", "floor");
        normalFuncMap.put("GCD", "gcd");
        normalFuncMap.put("INF", "inf");
        normalFuncMap.put("LCM", "lcm");
        normalFuncMap.put("LG", "lg");
        normalFuncMap.put("LN", "ln");
        normalFuncMap.put("PERMUT", "permut");
        normalFuncMap.put("PI", "pi");
        normalFuncMap.put("POWER", "power");
        normalFuncMap.put("RAND", "rand");
        normalFuncMap.put("ROUND", "round");
        normalFuncMap.put("SIN", "sin");
        normalFuncMap.put("SINH", "sinh");
        normalFuncMap.put("SQRT", "sqrt");
        normalFuncMap.put("TAN", "tan");
        normalFuncMap.put("TANH", "tanh");
        normalFuncMap.put("DECIMAL", "decimal");
        normalFuncMap.put("FLOAT", "float");
        normalFuncMap.put("IFNUMBER", "ifnumber");
        normalFuncMap.put("INT", "int");
        normalFuncMap.put("LONG", "long");
        normalFuncMap.put("NUMBER", "number");
        normalFuncMap.put("CONCAT", "concat");
        normalFuncMap.put("FILL", "fill");
        normalFuncMap.put("ISALPHA", "isalpha");
        normalFuncMap.put("ISDIGIT", "isdigit");
        normalFuncMap.put("ISLOWER", "islower");
        normalFuncMap.put("ISUPPER", "isupper");
        normalFuncMap.put("LEN", "len");
        normalFuncMap.put("LIKE", "like");
        normalFuncMap.put("LOWER", "lower");
        normalFuncMap.put("MD5", "md5");
        normalFuncMap.put("MID", "mid");
        normalFuncMap.put("POS", "pos");
        normalFuncMap.put("RANDS", "rands");
        normalFuncMap.put("REPLACE", "replace");
        normalFuncMap.put("STRING", "string");
        normalFuncMap.put("TRIM", "trim");
        normalFuncMap.put("UPPER", "upper");
        normalFuncMap.put("URLENCODE", "urlencode");
        normalFuncMap.put("IFSTRING", "ifstring");
        normalFuncMap.put("AGE", "age");
        normalFuncMap.put("DATE", "date");
        normalFuncMap.put("DATETIME", "datetime");
        normalFuncMap.put("DAY", "day");
        normalFuncMap.put("DAYS", "days");
        normalFuncMap.put("DEQ", "deq");
        normalFuncMap.put("ELAPSE", "elapse");
        normalFuncMap.put("HOUR", "hour");
        normalFuncMap.put("INTERVAL", "interval");
        normalFuncMap.put("MILLISECOND", "millisecond");
        normalFuncMap.put("MINUTE", "minute");
        normalFuncMap.put("MONTH", "month");
        normalFuncMap.put("NOW", "now");
        normalFuncMap.put("PDATE", "pdate");
        normalFuncMap.put("SECOND", "second");
        normalFuncMap.put("TIME", "time");
        normalFuncMap.put("WORKDAY", "workday");
        normalFuncMap.put("YEAR", "year");
        normalFuncMap.put("IFDATE", "ifdate");
        normalFuncMap.put("IFTIME", "iftime");
        normalFuncMap.put("IF", "if");
        normalFuncMap.put("CASE", "case");
    }

    Tokenizer() {
    }

    public static int scanMergeKeyWord(Token[] tokens, int start, int next) {
        int i = start;
        while (i < next) {
            if (tokens[i].isMergeKeyWord()) {
                return i;
            }
            if (tokens[i].getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next);
            }
            ++i;
        }
        return -1;
    }

    public static int scanByDataKeyWord(Token[] tokens, int start, int next) {
        int i = start;
        while (i < next) {
            Token token = tokens[i];
            if (token.getType() == '\u0000') {
                if (token.equals("BY")) {
                    return i;
                }
                if (token.equals("FROM") || token.equals("HAVING") || token.equals("ORDER")) {
                    return -1;
                }
            } else if (tokens[i].getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next);
            }
            ++i;
        }
        return -1;
    }

    public static int scanKeyWord(String key, Token[] tokens, int start, int next) {
        int i = start;
        while (i < next) {
            if (tokens[i].isKeyWord(key)) {
                return i;
            }
            if (tokens[i].getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next);
            }
            ++i;
        }
        return -1;
    }

    public static int scanLogicalOperator(Token[] tokens, int start, int next) {
        int i = start;
        while (i < next) {
            if (tokens[i].isKeyWord("AND") || tokens[i].isKeyWord("OR")) {
                return i;
            }
            if (tokens[i].getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next);
            }
            ++i;
        }
        return -1;
    }

    public static int lastScanKeyWord(String key, Token[] tokens, int start, int next) {
        int i = next - 1;
        while (i >= start) {
            if (tokens[i].isKeyWord(key)) {
                return i;
            }
            if (tokens[i].getType() == ')') {
                i = Tokenizer.lastScanParen(tokens, start, i);
            }
            --i;
        }
        return -1;
    }

    public static int scanKeyWords(String[] keys, Token[] tokens, int start, int next) {
        int keyCount = keys.length;
        int i = start;
        while (i < next) {
            Token token = tokens[i];
            if (token.getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next);
            } else if (token.getType() == '\u0000') {
                int k = 0;
                while (k < keyCount) {
                    if (token.equals(keys[k])) {
                        return i;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int scanComma(Token[] tokens, int start, int next) {
        int i = start;
        while (i < next) {
            char type = tokens[i].getType();
            if (type == ',') {
                return i;
            }
            if (type == '(') {
                i = Tokenizer.scanParen(tokens, i, next);
            }
            ++i;
        }
        return -1;
    }

    public static int scanParen(Token[] tokens, int start, int next) {
        int deep = 0;
        int i = start + 1;
        while (i < next) {
            if (tokens[i].getType() == '(') {
                ++deep;
            } else if (tokens[i].getType() == ')') {
                if (deep == 0) {
                    return i;
                }
                --deep;
            }
            ++i;
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException("(,)" + mm.getMessage("mark.notMatch"));
    }

    public static int lastScanParen(Token[] tokens, int start, int end) {
        int deep = 0;
        int i = end - 1;
        while (i >= start) {
            if (tokens[i].getType() == '(') {
                if (deep == 0) {
                    return i;
                }
                --deep;
            } else if (tokens[i].getType() == ')') {
                ++deep;
            }
            --i;
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException("(,)" + mm.getMessage("mark.notMatch"));
    }

    public static int scanKeyWords(Token[] tokens, int start, int next, String[] keys, int index) {
        int keyCount = keys.length;
        int i = start;
        while (i < next) {
            Token token = tokens[i];
            if (token.getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next);
            } else if (token.getType() == '\u0000') {
                int k = index;
                while (k < keyCount) {
                    if (token.equals(keys[k])) {
                        return i;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return next;
    }

    public static String[] getStrings(Token[] tokens, int start, int next) {
        String[] ts = new String[next - start];
        int i = start;
        while (i < next) {
            ts[i - start] = tokens[i].getString();
            ++i;
        }
        return ts;
    }

    public static boolean isGatherFunction(String name) {
        name = name.toUpperCase();
        return Tokenizer.contains(name, GATHERS);
    }

    public static boolean isOperatorKeyWord(String name) {
        return Tokenizer.contains(name, OPKEYWORDS);
    }

    public static boolean isSQLKeyWord(String id) {
        return Tokenizer.contains(id, SQLKEYWORDS);
    }

    public static boolean isListKeyWord(String id) {
        return Tokenizer.contains(id, LISTKEYWORDS);
    }

    private static boolean contains(String id, String[] keyWords) {
        int i = 0;
        int len = keyWords.length;
        while (i < len) {
            if (keyWords[i].equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    public static boolean isIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch);
    }

    public static Token[] parseSQL(String command) {
        int curIndex = 0;
        command = command.trim();
        int cmdLen = command.length();
        ArrayList<Token> tokenList = new ArrayList<Token>();
        while (curIndex < cmdLen) {
            Token token;
            String id;
            MessageManager mm;
            Token token2;
            String id2;
            char ch = command.charAt(curIndex);
            if (Character.isWhitespace(ch)) {
                ++curIndex;
                continue;
            }
            if (ch == '[' || ch == ']' || ch == '{' || ch == '}' || ch == ':' || ch == '\\' || ch == '~') {
                Token token3 = new Token(ch, "" + ch, curIndex, "" + ch);
                tokenList.add(token3);
                ++curIndex;
                continue;
            }
            if (ch == '@') {
                int next = Tokenizer.scanId(command, curIndex + 1);
                id2 = command.substring(curIndex, next);
                token2 = new Token(ch, id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (Tokenizer.isIdentifierStart(ch)) {
                Token token4;
                int next = Tokenizer.scanId(command, curIndex + 1);
                id2 = command.substring(curIndex, next);
                String upId = id2.toUpperCase();
                if (Tokenizer.isSQLKeyWord(upId)) {
                    token4 = new Token('\u0000', upId, curIndex, id2);
                    tokenList.add(token4);
                } else {
                    token4 = new Token('\u0001', id2, curIndex, id2);
                    tokenList.add(token4);
                }
                curIndex = next;
                continue;
            }
            if (Character.isDigit(ch)) {
                int next = Tokenizer.scanNumber(command, curIndex + 1);
                id2 = command.substring(curIndex, next);
                token2 = new Token('\u0002', id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '.') {
                int next = Tokenizer.scanNumber(command, curIndex);
                id2 = command.substring(curIndex, next);
                if (next > curIndex + 1) {
                    token2 = new Token('\u0002', id2, curIndex, id2);
                    tokenList.add(token2);
                } else {
                    token2 = new Token(ch, id2, curIndex, id2);
                    tokenList.add(token2);
                }
                curIndex = next;
                continue;
            }
            if (ch == '\'') {
                int next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("\",\"" + mm.getMessage("mark.notMatch"));
                }
                id2 = String.valueOf('\"') + command.substring(curIndex + 1, ++next - 1) + '\"';
                token2 = new Token('\u0003', id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '\"') {
                int next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                id2 = String.valueOf('\'') + command.substring(curIndex + 1, ++next - 1) + '\'';
                token2 = new Token('\u0001', id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '?') {
                id = command.substring(curIndex, curIndex + 1);
                token = new Token('?', null, curIndex, id);
                tokenList.add(token);
                ++curIndex;
                continue;
            }
            if (OPSTRING.indexOf(ch) != -1) {
                id = command.substring(curIndex, curIndex + 1);
                token = new Token('\u0004', id, curIndex, id);
                tokenList.add(token);
                ++curIndex;
                continue;
            }
            if (ch == '(' || ch == ')' || ch == ',') {
                id = command.substring(curIndex, curIndex + 1);
                token = new Token(ch, id, curIndex, id);
                tokenList.add(token);
                ++curIndex;
                continue;
            }
            MessageManager mm2 = ParseMessage.get();
            throw new RQException(String.valueOf(mm2.getMessage("syntax.error")) + curIndex);
        }
        int size = tokenList.size();
        Token[] tokens = new Token[size];
        tokenList.toArray(tokens);
        return tokens;
    }

    public static int getLogicSqlStart(String command) {
        int curIndex = 0;
        int cmdLen = command.length();
        while (curIndex < cmdLen) {
            MessageManager mm;
            int next;
            char ch = command.charAt(curIndex);
            if (Character.isWhitespace(ch)) {
                ++curIndex;
                continue;
            }
            if (Character.isJavaIdentifierStart(ch)) {
                next = Tokenizer.scanId(command, curIndex + 1);
                String id = command.substring(curIndex, next).toUpperCase();
                if (id.equals("SELECT") || id.equals("WITH") || id.equals("CREATE") || id.equals("DROP")) {
                    return curIndex;
                }
                curIndex = next;
                continue;
            }
            if (Character.isDigit(ch)) {
                curIndex = Tokenizer.scanNumber(command, curIndex + 1);
                continue;
            }
            if (ch == '\"') {
                next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                curIndex = next + 1;
                continue;
            }
            if (ch == '\'') {
                next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                curIndex = next + 1;
                continue;
            }
            ++curIndex;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static int scanId(String command, int start) {
        len = command.length();
        if (start == len) {
            return start;
        }
        if (command.charAt(start) != '\'') ** GOTO lbl17
        if ((start = Sentence.scanQuotation((String)command, (int)start)) < 0) {
            mm = ParseMessage.get();
            throw new RQException("','" + mm.getMessage("mark.notMatch"));
        }
        if (++start == len) {
            return start;
        }
        ch = command.charAt(start);
        if (Tokenizer.isIdentifierPart(ch)) {
            mm = ParseMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("syntax.error")) + start);
        }
        return start;
        while (Tokenizer.isIdentifierPart(ch = command.charAt(start))) {
            ++start;
lbl17:
            // 2 sources

            if (start < len) continue;
        }
        return start;
    }

    public static int scanNumber(String command, int start) {
        int len = command.length();
        while (start < len) {
            if (!Character.isDigit(command.charAt(start))) break;
            ++start;
        }
        if (start < len && command.charAt(start) == '.') {
            ++start;
            while (start < len) {
                if (!Character.isDigit(command.charAt(start))) break;
                ++start;
            }
        }
        return start;
    }

    public static String replace(String str, char s, String r, boolean ignoreQuote) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(128 + len);
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            if (!(ignoreQuote || ch != '\'' && ch != '\"')) {
                int pos = Sentence.scanQuotation((String)str, (int)i);
                if (pos == -1) {
                    sb.append(str.substring(i));
                    break;
                }
                sb.append(str.substring(i, pos + 1));
                i = pos;
            } else if (ch == s) {
                sb.append(r);
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String replaceTable(String str, String tableName, String exp) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(128 + len);
        int subLen = tableName.length();
        if (tableName == null || exp == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.error"));
        }
        int i = 0;
        while (i < len) {
            int next;
            if (i + subLen >= len) {
                sb.append(str.substring(i));
                break;
            }
            char ch = str.charAt(i);
            if (Tokenizer.isIdentifierStart(ch) || ch == '\"') {
                next = Tokenizer.scanId(str, i);
                if (next - i == subLen && str.charAt(next) == '.' && str.regionMatches(true, i, tableName, 0, subLen)) {
                    sb.append(exp);
                } else {
                    sb.append(str.substring(i, next));
                }
                i = next;
                continue;
            }
            if (ch == '\'') {
                int pos = Sentence.scanQuotation((String)str, (int)i);
                if (pos == -1) {
                    sb.append(str.substring(i));
                    break;
                }
                sb.append(str.substring(i, pos + 1));
                i = pos + 1;
                continue;
            }
            if (ch == '.') {
                sb.append(ch);
                ch = str.charAt(++i);
                if (!Tokenizer.isIdentifierStart(ch) && ch != '\"') continue;
                next = Tokenizer.scanId(str, i);
                sb.append(str.substring(i, next));
                i = next;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static String replace(String str, String sub, String exp, boolean ignoreQuote) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(128 + len);
        int subLen = sub.length();
        int i = 0;
        while (i < len) {
            if (i + subLen - 1 > len) {
                sb.append(str.substring(i));
                break;
            }
            char ch = str.charAt(i);
            if (!(ignoreQuote || ch != '\'' && ch != '\"')) {
                int pos = Sentence.scanQuotation((String)str, (int)i);
                if (pos == -1) {
                    sb.append(str.substring(i));
                    break;
                }
                sb.append(str.substring(i, pos + 1));
                i = pos + 1;
                continue;
            }
            if (str.regionMatches(true, i, sub, 0, subLen)) {
                sb.append(exp);
                i += subLen;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isOperator(String ch) {
        return ch.length() == 1 && OPSTRING.indexOf(ch) != -1;
    }

    public static String parseFunction(String name) {
        String funcName = normalFuncMap.get(name.toUpperCase());
        if (funcName == null) {
            funcName = name.toLowerCase();
        }
        return funcName;
    }
}

