/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.utils;

import com.scudata.common.IOUtils;
import com.scudata.common.RQException;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.query.metadata.DataMaintenanceTable;
import com.scudata.dm.query.metadata.Dictionary;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Visibility;
import com.scudata.dm.query.utils.JsonUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.json.JSONException;

public class IOUtil {
    public static LogicMetaData readLogicMetaData(String fileName) throws Exception {
        FileObject fileObject = new FileObject(fileName, null, "s", null);
        InputStream is = fileObject.getInputStream();
        return IOUtil.readLogicMetaData(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogicMetaData readLogicMetaData(InputStream is) throws Exception {
        BufferedInputStream bis = null;
        bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        try {
            LogicMetaData lmd;
            String json = JsonUtils.readJsonFromStream(bis);
            LogicMetaData logicMetaData = lmd = JsonUtils.getLogicMetaDataFromJson(json);
            return logicMetaData;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
            if (bis != null) {
                bis.close();
                bis = null;
            }
        }
    }

    public static void writeLogicMetaData(String filePath, LogicMetaData lmd) throws IOException, JSONException {
        String homePath = Env.getMainPath();
        if (!IOUtils.isAbsolutePath((String)filePath)) {
            filePath = IOUtils.getPath((String)homePath, (String)filePath);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(filePath));
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        IOUtil.writeLogicMetaData(fos, lmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLogicMetaData(OutputStream os, LogicMetaData lmd) throws IOException, JSONException {
        BufferedOutputStream bos = null;
        bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
        try {
            JsonUtils.writeJsonToStream(bos, lmd.toJsonString());
        }
        finally {
            if (os != null) {
                os.close();
                os = null;
            }
            if (bos != null) {
                bos.close();
                bos = null;
            }
        }
    }

    public static Dictionary readDictionary(String fileName) throws Exception {
        FileObject fileObject = new FileObject(fileName, null, "s", null);
        InputStream is = fileObject.getInputStream();
        return IOUtil.readDictionary(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dictionary readDictionary(InputStream is) throws Exception {
        BufferedInputStream bis = null;
        bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        try {
            Dictionary dct;
            String json = JsonUtils.readJsonFromStream(bis);
            Dictionary dictionary = dct = JsonUtils.getDictionaryFromJson(json);
            return dictionary;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
            if (bis != null) {
                bis.close();
                bis = null;
            }
        }
    }

    public static void writeDictionary(String filePath, Dictionary dct) throws IOException, JSONException {
        String homePath = Env.getMainPath();
        if (!IOUtils.isAbsolutePath((String)filePath)) {
            filePath = IOUtils.getPath((String)homePath, (String)filePath);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(filePath), true);
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        IOUtil.writeDictionary(fos, dct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDictionary(OutputStream os, Dictionary dct) throws IOException, JSONException {
        BufferedOutputStream bos = null;
        bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
        try {
            JsonUtils.writeJsonToStream(bos, dct.toJsonString());
        }
        finally {
            if (os != null) {
                os.close();
                os = null;
            }
            if (bos != null) {
                bos.close();
                bos = null;
            }
        }
    }

    public static Visibility readVisibility(String fileName) throws Exception {
        FileObject fileObject = new FileObject(fileName, null, "s", null);
        InputStream is = fileObject.getInputStream();
        return IOUtil.readVisibility(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Visibility readVisibility(InputStream is) throws Exception {
        BufferedInputStream bis = null;
        bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        try {
            Visibility vsb;
            String json = JsonUtils.readJsonFromStream(bis);
            Visibility visibility = vsb = JsonUtils.getVisibilityFromJson(json);
            return visibility;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
            if (bis != null) {
                bis.close();
                bis = null;
            }
        }
    }

    public static void writeVisibility(String filePath, Visibility vsb) throws IOException, JSONException {
        String homePath = Env.getMainPath();
        if (!IOUtils.isAbsolutePath((String)filePath)) {
            filePath = IOUtils.getPath((String)homePath, (String)filePath);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(filePath), true);
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        IOUtil.writeVisibility(fos, vsb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeVisibility(OutputStream os, Visibility vsb) throws IOException, JSONException {
        BufferedOutputStream bos = null;
        bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
        try {
            JsonUtils.writeJsonToStream(bos, vsb.toJsonString());
        }
        finally {
            if (os != null) {
                os.close();
                os = null;
            }
            if (bos != null) {
                bos.close();
                bos = null;
            }
        }
    }

    public static DataMaintenanceTable readDataMaintenanceTable(String fileName) throws Exception {
        FileObject fileObject = new FileObject(fileName, null, "s", null);
        InputStream is = fileObject.getInputStream();
        return IOUtil.readDataMaintenanceTable(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataMaintenanceTable readDataMaintenanceTable(InputStream is) throws Exception {
        BufferedInputStream bis = null;
        bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        try {
            DataMaintenanceTable table;
            String json = JsonUtils.readJsonFromStream(bis);
            DataMaintenanceTable dataMaintenanceTable = table = JsonUtils.getDataMaintenanceTableFromJson(json);
            return dataMaintenanceTable;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
            if (bis != null) {
                bis.close();
                bis = null;
            }
        }
    }

    public static void writeDataMaintenanceTable(String filePath, DataMaintenanceTable table) throws IOException, JSONException {
        String homePath = Env.getMainPath();
        if (!IOUtils.isAbsolutePath((String)filePath)) {
            filePath = IOUtils.getPath((String)homePath, (String)filePath);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(filePath), true);
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        IOUtil.writeDataMaintenanceTable(fos, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDataMaintenanceTable(OutputStream os, DataMaintenanceTable table) throws IOException, JSONException {
        BufferedOutputStream bos = null;
        bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os);
        try {
            JsonUtils.writeJsonToStream(bos, table.toJsonString());
        }
        finally {
            if (os != null) {
                os.close();
                os = null;
            }
            if (bos != null) {
                bos.close();
                bos = null;
            }
        }
    }
}

