/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.btx.cloud;

import com.scudata.common.MessageManager;
import com.scudata.ide.btx.BTX;
import com.scudata.ide.btx.cloud.FileTreeC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.custom.FileInfo;
import com.scudata.ide.dft.resources.DftMessage;
import com.scudata.ide.spl.ICloudClientIDE;
import com.scudata.ide.spl.base.FileTreeNodeEE;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogCloud
extends JDialog {
    private static final long serialVersionUID = -59148641723520230L;
    static MessageManager mm = DftMessage.get();
    private int m_option = -1;
    JPanel panelRight = new JPanel();
    JButton jBOK = new JButton();
    JButton jBCancel = new JButton();
    JButton jBDownload = new JButton();
    JPanel panelCenter = new JPanel(new GridBagLayout());
    JLabel labelFiles = new JLabel("\u6587\u4ef6");
    FileTreeC fileTree = new FileTreeC();
    JScrollPane spTree = new JScrollPane((Component)((Object)this.fileTree));

    public DialogCloud() {
        super((Frame)GV.appFrame, "\u6587\u4ef6\u4e0b\u8f7d", true);
        try {
            this.rqInit();
            this.resetLangText();
            this.setSize(600, 380);
            GM.setDialogDefaultButton((Window)this, (JButton)this.jBOK, (JButton)this.jBCancel);
        }
        catch (Exception x) {
            GM.showException((Object)x);
        }
    }

    public int getOption() {
        return this.m_option;
    }

    private void resetLangText() {
        this.setTitle(mm.getMessage("dialogcloud.title"));
        this.jBOK.setText(mm.getMessage("button.ok"));
        this.jBCancel.setText(mm.getMessage("button.cancel"));
        this.jBDownload.setText(mm.getMessage("button.download"));
        this.labelFiles.setText(mm.getMessage("label.files"));
    }

    private void download() {
        FileTreeNodeEE node = this.fileTree.getSelectedNode();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        if (!(obj instanceof FileInfo)) {
            return;
        }
        FileInfo fi = (FileInfo)obj;
        int type = fi.getType();
        if (type == 1) {
            return;
        }
        String fileName = fi.getFilename();
        File f = GM.dialogSelectFile((Component)this, (String)"", (String)GV.lastDirectory, null, (String)fileName);
        if (f == null) {
            return;
        }
        ICloudClientIDE cloud = BTX.getCloudClient();
        String cloudPath = FileTreeC.getCloudPath(node);
        cloud.dialogDownloadFile((Component)GV.appFrame, cloudPath, f, node.getArea());
    }

    private void rqInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src == DialogCloud.this.jBDownload) {
                    DialogCloud.this.download();
                } else if (src == DialogCloud.this.jBOK) {
                    DialogCloud.this.jBOK_actionPerformed();
                } else if (src == DialogCloud.this.jBCancel) {
                    DialogCloud.this.jBCancel_actionPerformed();
                }
            }
        };
        this.fileTree.addCloud(BTX.getCloudClient());
        this.panelRight.setLayout((LayoutManager)new VFlowLayout());
        this.panelRight.setForeground(Color.black);
        this.jBOK.setDefaultCapable(true);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(al);
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.setDefaultCapable(false);
        this.jBCancel.addActionListener(al);
        this.jBDownload.setMnemonic('D');
        this.jBDownload.setText("\u4e0b\u8f7d(D)");
        this.jBDownload.addActionListener(al);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogCloud.this.windowClose();
            }
        });
        this.panelCenter.add((Component)this.labelFiles, GM.getGBC((int)1, (int)1));
        GridBagConstraints gbc = GM.getGBC((int)2, (int)1, (boolean)true, (boolean)true);
        gbc.gridwidth = 2;
        this.panelCenter.add((Component)this.spTree, gbc);
        this.panelRight.add(this.jBOK);
        this.panelRight.add(this.jBCancel);
        this.panelRight.add(new JLabel(""));
        this.panelRight.add(this.jBDownload);
        this.getContentPane().add((Component)this.panelCenter, "Center");
        this.getContentPane().add((Component)this.panelRight, "East");
        this.setResizable(true);
    }

    void jBOK_actionPerformed() {
        GM.setWindowDimension((Component)this);
        this.m_option = 0;
        this.dispose();
    }

    void jBCancel_actionPerformed() {
        GM.setWindowDimension((Component)this);
        this.m_option = 2;
        this.dispose();
    }

    void windowClose() {
        GM.setWindowDimension((Component)this);
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        JButton btn = (JButton)e.getSource();
        if (btn == this.jBOK) {
            this.jBOK_actionPerformed();
        } else {
            this.jBCancel_actionPerformed();
        }
    }
}

