/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.btx.cloud;

import com.scudata.app.common.AppUtil;
import com.scudata.common.StringUtils;
import com.scudata.ide.btx.BTX;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.custom.FileInfo;
import com.scudata.ide.spl.FileFilter;
import com.scudata.ide.spl.GVSplEE;
import com.scudata.ide.spl.ICloudClientIDE;
import com.scudata.ide.spl.base.FileTree;
import com.scudata.ide.spl.base.FileTreeNode;
import com.scudata.ide.spl.base.FileTreeNodeEE;
import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class FileTreeC
extends FileTree {
    private static final long serialVersionUID = 1L;
    protected FileTreeNodeEE cloudRoot;
    private boolean isClosing = false;
    public static final String BUSINESS_DIR = mm.getMessage("filetreese.businessdir");
    public static final String BUFFER_DIR = mm.getMessage("filetreese.bufferdir");
    public static final String BACKUP_DIR = mm.getMessage("filetreese.backupdir");
    private List<ICloudClientIDE> cloudList;
    public static String selectCloud;
    private static final String CLOUD_FILE_TREE;
    private static final String NO_CLOUD_FILE_TREE;

    static {
        CLOUD_FILE_TREE = mm.getMessage("filetree.cloudfileresource");
        NO_CLOUD_FILE_TREE = mm.getMessage("filetree.nocloudresource");
    }

    public FileTreeNodeEE getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        return (FileTreeNodeEE)((Object)obj);
    }

    public synchronized void refreshCloud() {
        if (this.cloudList != null && this.cloudList.size() > 0) {
            this.cloudRoot.removeAllChildren();
            int i = 0;
            while (i < this.cloudList.size()) {
                ICloudClientIDE cloud = this.cloudList.get(i);
                if (cloud != null) {
                    FileTreeNodeEE cloudNode = new FileTreeNodeEE(cloud, 2);
                    cloudNode.setDir(true);
                    cloudNode.setTitle(cloud.getName());
                    cloudNode.setCloudName(cloud.getName());
                    if (StringUtils.isValidString((Object)selectCloud) && selectCloud.equals(cloud.getName())) {
                        cloudNode.setExpanded(true);
                    } else {
                        cloudNode.setExpanded(false);
                    }
                    this.loadCloudFileTree(cloudNode, true);
                    this.cloudRoot.add((MutableTreeNode)((Object)cloudNode));
                }
                ++i;
            }
        }
    }

    public void treeNodeWillExpand(FileTreeNode node) {
        this.nodeSelected(node);
        if (node != null && !node.isLoaded()) {
            if (node.getType() == 1) {
                this.loadSubNode(node);
            } else if (node.getType() == 2) {
                this.loadCloudFileTree((FileTreeNodeEE)node, true);
            } else if (node.getType() == 0) {
                this.refreshCloud();
            }
            node.setExpanded(true);
            this.nodeStructureChanged(node);
        }
    }

    protected ImageIcon getLogoImage() {
        return GM.getLogoImage((boolean)true);
    }

    protected JInternalFrame openSheetFile(String file) throws Exception {
        return GV.appFrame.openSheetFile(file);
    }

    protected JInternalFrame openSheetFile(InputStream in, String fileName, byte sheetType) throws Exception {
        return GV.appFrame.openSheetFile(in, fileName, sheetType);
    }

    public JInternalFrame getSheet(String title) {
        return GV.appFrame.getSheet(title);
    }

    public void setClosing() {
        this.isClosing = true;
    }

    protected void showException(Object oMsg) {
        if (this.isClosing) {
            GM.outputMessage((Object)oMsg);
        } else {
            GM.showException((Component)GV.appFrame, (Object)oMsg, (boolean)true, (ImageIcon)this.getLogoImage());
        }
    }

    public void openFile(FileTreeNode node) {
        Object o = node.getUserObject();
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            try {
                this.openSheetFile((String)node.getUserObject());
            }
            catch (Exception e) {
                this.showException(e);
            }
        } else if (o instanceof FileInfo) {
            if (!((FileInfo)o).canRead()) {
                this.showException(mm.getMessage("filetree.filecannotread", (Object)((FileInfo)o).getFilename()));
                return;
            }
            String cloudName = ((FileTreeNodeEE)node).getCloudName();
            try {
                String fileName;
                ICloudClientIDE cloud;
                if (node.getType() == 2) {
                    cloud = FileTreeC.getCloud();
                    if (cloud == null) {
                        new Throwable(mm.getMessage("filetree.servernotconnect", (Object)cloudName));
                    }
                    if (!AppUtil.isSPLFile((String)(fileName = FileTreeC.getCloudPath(node)))) {
                        return;
                    }
                } else {
                    return;
                }
                InputStream in = cloud.open(fileName, (byte)1);
                byte sheetType = 1;
                fileName = this.getCloudSheetName(node);
                this.openSheetFile(in, fileName, sheetType);
            }
            catch (Exception e) {
                this.showException(e);
            }
        }
    }

    protected void nodeSelected(FileTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.getType() == 2) {
            selectCloud = ((FileTreeNodeEE)node).getCloudName();
        }
    }

    private void loadCloudFileTree(FileTreeNodeEE cloudNode, boolean first) {
        FileTreeC.loadCloudTree(cloudNode, first, new FileFilter(){

            @Override
            public boolean isValidFile(String fileName) {
                return FileTreeC.this.isValidFile((byte)2, fileName);
            }
        });
    }

    public static void loadCloudTree(FileTreeNodeEE cloudNode, boolean first, FileFilter filter) {
        if (cloudNode == null) {
            return;
        }
        cloudNode.removeAllChildren();
        if (cloudNode.getUserObject() instanceof ICloudClientIDE) {
            ICloudClientIDE cloud = (ICloudClientIDE)cloudNode.getUserObject();
            if (cloud == null) {
                return;
            }
            String cloudName = cloud.getName();
            FileTreeNodeEE dirNode = new FileTreeNodeEE(BUSINESS_DIR, 2);
            dirNode.setTitle(BUSINESS_DIR);
            dirNode.setDir(true);
            dirNode.setArea((byte)1);
            dirNode.setCloudName(cloudName);
            cloudNode.add((MutableTreeNode)((Object)dirNode));
            FileTreeC.loadCloudTree(dirNode, true, filter);
            dirNode = new FileTreeNodeEE(BUFFER_DIR, 2);
            dirNode.setTitle(BUFFER_DIR);
            dirNode.setDir(true);
            dirNode.setArea((byte)2);
            dirNode.setCloudName(cloudName);
            cloudNode.add((MutableTreeNode)((Object)dirNode));
            FileTreeC.loadCloudTree(dirNode, true, filter);
            dirNode = new FileTreeNodeEE(BACKUP_DIR, 2);
            dirNode.setTitle(BACKUP_DIR);
            dirNode.setDir(true);
            dirNode.setArea((byte)3);
            dirNode.setCloudName(cloudName);
            cloudNode.add((MutableTreeNode)((Object)dirNode));
            FileTreeC.loadCloudTree(dirNode, true, filter);
            cloudNode.setExpanded(true);
        } else if (cloudNode.getUserObject() instanceof FileInfo || cloudNode.getUserObject() instanceof String) {
            boolean isDir;
            FileTreeNodeEE node;
            String fileName;
            List<FileInfo> subFiles;
            ICloudClientIDE cloud = FileTreeC.getCloud();
            if (cloud == null) {
                return;
            }
            byte area = cloudNode.getArea();
            if (cloudNode.getUserObject() instanceof String) {
                subFiles = cloud.listFiles(null, area);
            } else {
                String p = FileTreeC.getCloudPath(cloudNode);
                subFiles = cloud.listFiles(p, area);
            }
            if (subFiles == null || subFiles.size() <= 0) {
                return;
            }
            cloudNode.removeAllChildren();
            for (FileInfo fileInfo : subFiles) {
                if (fileInfo == null || !StringUtils.isValidString((Object)(fileName = fileInfo.getFilename()))) continue;
                node = new FileTreeNodeEE(fileInfo, 2);
                node.setTitle(fileName);
                node.setCloudName(cloud.getName());
                node.setArea(area);
                isDir = fileInfo.isDirectory();
                if (!isDir) continue;
                node.setDir(isDir);
                node.setLoaded(false);
                cloudNode.add((MutableTreeNode)((Object)node));
                if (!first) continue;
                FileTreeC.loadCloudTree(node, false, filter);
            }
            for (FileInfo fileInfo : subFiles) {
                if (fileInfo == null || !StringUtils.isValidString((Object)(fileName = fileInfo.getFilename()))) continue;
                node = new FileTreeNodeEE(fileInfo, 2);
                node.setTitle(fileName);
                node.setCloudName(cloud.getName());
                node.setArea(area);
                isDir = fileInfo.isDirectory();
                if (isDir || !filter.isValidFile(fileName)) continue;
                node.setDir(isDir);
                cloudNode.add((MutableTreeNode)((Object)node));
            }
        }
        cloudNode.setLoaded(false);
    }

    public boolean isValidFile(byte type, String fileName) {
        if (type == 1) {
            return super.isValidFile(type, fileName);
        }
        String lower = fileName.toLowerCase();
        boolean b = lower.endsWith("btx") || lower.endsWith("ctx");
        return b;
    }

    protected String getCloudSheetName(FileTreeNode node) {
        Object o = node.getUserObject();
        if (o instanceof FileInfo) {
            String cloudName = ((FileTreeNodeEE)node).getCloudName();
            ICloudClientIDE cloud = FileTreeC.getCloud();
            if (cloud == null) {
                new Throwable(mm.getMessage("filetree.servernotconnect", (Object)cloudName));
            }
            String fileName = FileTreeC.getCloudPath(node);
            fileName = String.valueOf(cloudName) + ":" + fileName;
            return fileName;
        }
        return null;
    }

    public List<ICloudClientIDE> getCloudList() {
        return this.cloudList;
    }

    public void addCloud(ICloudClientIDE cloud) {
        if (this.cloudRoot == null) {
            this.cloudRoot = new FileTreeNodeEE("", 2);
            this.cloudRoot.setDir(true);
            this.cloudRoot.setTitle(NO_CLOUD_FILE_TREE);
            this.root.add((MutableTreeNode)((Object)this.cloudRoot));
        }
        if (this.cloudList == null) {
            this.cloudList = new ArrayList<ICloudClientIDE>();
        }
        this.cloudList.add(cloud);
        FileTreeNodeEE cloudNode = new FileTreeNodeEE(cloud, 2);
        cloudNode.setDir(true);
        cloudNode.setExpanded(true);
        cloudNode.setTitle(cloud.getName());
        cloudNode.setCloudName(cloud.getName());
        this.cloudRoot.add((MutableTreeNode)((Object)cloudNode));
        this.cloudRoot.setTitle(CLOUD_FILE_TREE);
        this.cloudRoot.setExpanded(true);
        this.cloudRoot.setLoaded(true);
        selectCloud = cloud.getName();
        try {
            this.loadCloudFileTree(cloudNode, true);
        }
        catch (Throwable t) {
            this.showException(t);
        }
        this.nodeStructureChanged(this.root);
        this.nodeStructureChanged(this.cloudRoot);
        selectCloud = cloud.getName();
        this.selectNode(cloudNode);
    }

    public static String getCloudPath(FileTreeNode node) {
        if (node == null || node.getType() != 2) {
            return "/";
        }
        if (node.getUserObject() instanceof ICloudClientIDE || node.getUserObject() instanceof String) {
            return "/";
        }
        if (node.getUserObject() instanceof FileInfo) {
            String path = String.valueOf(File.separator) + node.getName();
            FileTreeNode pNode = (FileTreeNode)node.getParent();
            while (pNode != null && pNode.getType() == 2) {
                String p = pNode.getTitle();
                if (StringUtils.isValidString((Object)p) && pNode.getUserObject() instanceof FileInfo) {
                    path = String.valueOf(File.separator) + p + path;
                }
                pNode = (FileTreeNode)pNode.getParent();
            }
            return path.replaceAll("\\\\", "/");
        }
        return "/";
    }

    public static ICloudClientIDE getCloud() {
        return BTX.getCloudClient();
    }

    public static Vector<String> getCloudNames() {
        Vector<String> cloudNames = new Vector<String>();
        List<ICloudClientIDE> cloudList = GVSplEE.getResourceTree().getCloudList();
        if (cloudList != null) {
            for (ICloudClientIDE cloud : cloudList) {
                cloudNames.add(cloud.getName());
            }
        }
        return cloudNames;
    }
}

