/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.app.common.Section;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.monitor.FileInfo;
import com.scudata.ide.monitor.ServerClient;
import com.scudata.ide.monitor.Util;
import com.scudata.ide.monitor.resources.MonitorMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogSelectRemoteFile
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static MessageManager mm = MonitorMessage.get();
    private JButton btOpen = new JButton(mm.getMessage("button.open"));
    private JButton btCancel = new JButton(mm.getMessage("button.cancel"));
    private JLabel lbPath = new JLabel(mm.getMessage("DialogSelectRemoteFile.title"));
    JTextField tfPath = new JTextField();
    JButton btUp;
    JButton btHome;
    JList listFiles = new JList();
    DefaultListModel listItems = new DefaultListModel();
    JLabel lbSelects = new JLabel("\u6587\u4ef6\u5939\u540d");
    JTextField tfSelects = new JTextField();
    JLabel lbFilter = new JLabel(mm.getMessage("DialogSelectRemoteFile.filetype"));
    JComboBoxEx cbFilter = new JComboBoxEx();
    private int option = 2;
    ServerClient sc;
    boolean onlyDirectory = false;
    String exts = "";

    public DialogSelectRemoteFile(ServerClient sc, String parentPath, String ext, boolean onlyDirectory) {
        super((Frame)GV.appFrame, mm.getMessage("DialogSelectRemoteFile.title"), true);
        this.sc = sc;
        this.tfPath.setText(parentPath);
        this.exts = ext;
        this.onlyDirectory = onlyDirectory;
        this.init();
        this.setSize(600, 380);
        GM.centerWindow((Component)this);
    }

    private void init() {
        if (this.onlyDirectory) {
            this.setTitle(mm.getMessage("button.open"));
            this.lbSelects.setText(mm.getMessage("DialogSelectRemoteFile.selectdirectory"));
        } else {
            this.setTitle(mm.getMessage("button.choice"));
            this.lbSelects.setText(mm.getMessage("DialogSelectRemoteFile.selectfile"));
        }
        this.setTitle(String.valueOf(this.getTitle()) + " " + this.sc.host);
        this.tfPath.setEditable(false);
        this.btOpen.setMnemonic('O');
        this.btOpen.addActionListener(this);
        this.btCancel.setMnemonic('C');
        this.btCancel.addActionListener(this);
        this.btUp = Util.createButton("up", mm.getMessage("button.up"), this);
        this.btHome = Util.createButton("home", mm.getMessage("button.root"), this);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelCenter = new JPanel(new GridBagLayout());
        JPanel panelSouth = new JPanel(new FlowLayout(2));
        panelCenter.add((Component)this.lbPath, GM.getGBC((int)1, (int)1));
        JPanel tmp = new JPanel(new GridBagLayout());
        tmp.add((Component)this.tfPath, GM.getGBC((int)1, (int)1, (boolean)true));
        tmp.add((Component)this.btUp, GM.getGBC((int)1, (int)2));
        tmp.add((Component)this.btHome, GM.getGBC((int)1, (int)3));
        panelCenter.add((Component)tmp, GM.getGBC((int)1, (int)2, (boolean)true));
        GridBagConstraints gbc = GM.getGBC((int)2, (int)1, (boolean)true, (boolean)true);
        gbc.gridwidth = 2;
        panelCenter.add((Component)new JScrollPane(this.listFiles), gbc);
        panelCenter.add((Component)this.lbSelects, GM.getGBC((int)3, (int)1));
        panelCenter.add((Component)this.tfSelects, GM.getGBC((int)3, (int)2, (boolean)true));
        panelCenter.add((Component)this.lbFilter, GM.getGBC((int)4, (int)1));
        panelCenter.add((Component)this.cbFilter, GM.getGBC((int)4, (int)2, (boolean)true));
        this.getContentPane().add((Component)panelCenter, "Center");
        panelSouth.add(this.btOpen);
        panelSouth.add(this.btCancel);
        this.getContentPane().add((Component)panelSouth, "South");
        this.listFiles.setSelectionMode(0);
        this.listFiles.setModel(this.listItems);
        this.listFiles.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return null;
                }
                FileInfo fi = (FileInfo)value;
                JLabel label = new JLabel();
                label.setIcon(fi.getDispIcon());
                label.setText(fi.getName());
                label.setOpaque(true);
                if (isSelected) {
                    label.setBackground(list.getSelectionBackground());
                } else {
                    label.setBackground(list.getBackground());
                }
                return label;
            }
        });
        this.listFiles.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == '\n') {
                    DialogSelectRemoteFile.this.open();
                }
            }
        });
        this.listFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileInfo fi = (FileInfo)DialogSelectRemoteFile.this.listFiles.getSelectedValue();
                if (fi == null) {
                    return;
                }
                String path = fi.getAbsolutePath();
                if (!DialogSelectRemoteFile.this.onlyDirectory && fi.isDir()) {
                    path = "";
                }
                DialogSelectRemoteFile.this.tfSelects.setText(path);
            }
        });
        this.listFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FileInfo fi = (FileInfo)DialogSelectRemoteFile.this.listFiles.getSelectedValue();
                if (fi == null) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    if (fi.isDir()) {
                        DialogSelectRemoteFile.this.load(fi.getAbsolutePath());
                    } else {
                        DialogSelectRemoteFile.this.open();
                    }
                }
            }
        });
        Vector<String> code = new Vector<String>();
        Vector<String> disp = new Vector<String>();
        code.add("");
        disp.add(mm.getMessage("button.all"));
        if (StringUtils.isValidString((Object)this.exts)) {
            Section st = new Section(this.exts);
            int i = st.size() - 1;
            while (i >= 0) {
                code.add(st.get(i));
                disp.add("*." + st.get(i));
                --i;
            }
        }
        this.cbFilter.x_setData(code, disp);
        this.cbFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = DialogSelectRemoteFile.this.tfPath.getText();
                DialogSelectRemoteFile.this.load(path);
            }
        });
        this.cbFilter.setSelectedIndex(code.size() - 1);
    }

    private void load(String parentPath) {
        String ext = (String)this.cbFilter.x_getSelectedItem();
        this.btUp.setEnabled(StringUtils.isValidString((Object)parentPath));
        this.tfPath.setText(parentPath);
        this.listItems.removeAllElements();
        try {
            List files = this.sc.listFiles(parentPath, ext, this.onlyDirectory);
            for (FileInfo fi : files) {
                this.listItems.addElement(fi);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getOption() {
        return this.option;
    }

    public String[] getFiles() {
        return new String[]{this.tfSelects.getText()};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object c = e.getSource();
        if (this.btUp == c) {
            this.up();
        } else if (this.btOpen == c) {
            this.open();
        } else if (this.btHome == c) {
            this.home();
        } else if (this.btCancel == c) {
            this.cancel();
        }
    }

    private void up() {
        File f = new File(this.tfPath.getText());
        String parent = f.getParent();
        this.load(parent);
    }

    private void open() {
        if (!StringUtils.isValidString((Object)this.tfSelects.getText())) {
            return;
        }
        this.option = 0;
        this.dispose();
    }

    private void home() {
        this.load("");
    }

    private void cancel() {
        this.dispose();
    }
}

