/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.JListEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.monitor.DialogIsOverwrite;
import com.scudata.ide.monitor.ServerClient;
import com.scudata.ide.monitor.Util;
import com.scudata.ide.monitor.resources.MonitorMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogUpload
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton buttonUpload = new JButton(mm.getMessage("button.upload"));
    private JButton buttonClose = new JButton(mm.getMessage("button.close"));
    private JLabel labelTarget = new JLabel(mm.getMessage("DialogUpload.target"));
    JComboBoxEx cbTarget = new JComboBoxEx();
    private JLabel labelPath = new JLabel(mm.getMessage("DialogUpload.targetpath"));
    private JLabel labelPathValue = new JLabel();
    private JLabel labelFiles = new JLabel(mm.getMessage("DialogUpload.filelist"));
    private JButton btAdd;
    private JButton btDelete;
    JListEx jListFiles = new JListEx();
    private int maxFileNameLen = 0;
    ServerClient sc;
    JFrame parent;
    static MessageManager mm = MonitorMessage.get();

    public DialogUpload(ServerClient sc) {
        super((Frame)GV.appFrame, mm.getMessage("DialogUpload.title"), true);
        this.sc = sc;
        this.init();
        this.setSize(600, 380);
        GM.centerWindow((Component)this);
    }

    private void init() {
        this.buttonUpload.setMnemonic('U');
        this.buttonUpload.addActionListener(this);
        this.buttonClose.setMnemonic('C');
        this.buttonClose.addActionListener(this);
        this.btAdd = Util.createButton("add", mm.getMessage("button.add"), this);
        this.btDelete = Util.createButton("delete", mm.getMessage("button.delete"), this);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelCenter = new JPanel(new GridBagLayout());
        JPanel panelEast = new JPanel((LayoutManager)new VFlowLayout());
        this.getContentPane().add((Component)panelCenter, "Center");
        this.getContentPane().add((Component)panelEast, "East");
        panelEast.add(this.buttonUpload);
        panelEast.add(this.buttonClose);
        panelCenter.add((Component)this.labelTarget, GM.getGBC((int)1, (int)1));
        panelCenter.add((Component)this.cbTarget, GM.getGBC((int)1, (int)2, (boolean)true));
        panelCenter.add((Component)this.labelPath, GM.getGBC((int)2, (int)1));
        panelCenter.add((Component)this.labelPathValue, GM.getGBC((int)2, (int)2, (boolean)true));
        panelCenter.add((Component)this.labelFiles, GM.getGBC((int)3, (int)1));
        JPanel tmp = new JPanel(new GridBagLayout());
        tmp.add((Component)new JLabel(""), GM.getGBC((int)1, (int)1, (boolean)true));
        tmp.add((Component)this.btAdd, GM.getGBC((int)1, (int)2));
        tmp.add((Component)this.btDelete, GM.getGBC((int)1, (int)3));
        panelCenter.add((Component)tmp, GM.getGBC((int)3, (int)2, (boolean)true));
        GridBagConstraints gbc = GM.getGBC((int)4, (int)1, (boolean)true, (boolean)true);
        gbc.gridwidth = 2;
        this.jListFiles.setSelectedIndex(0);
        try {
            Vector<String> codeData = new Vector<String>();
            Vector<String> dispData = new Vector<String>();
            Object[] paths = this.sc.getUploadPaths();
            ArrayList key = (ArrayList)paths[0];
            ArrayList val = (ArrayList)paths[1];
            int i = 0;
            while (i < key.size()) {
                String name = (String)key.get(i);
                String path = (String)val.get(i);
                codeData.add(path);
                dispData.add(name);
                ++i;
            }
            this.cbTarget.x_setData(codeData, dispData);
            this.cbTarget.addActionListener((ActionListener)this);
            this.cbTarget.setSelectedIndex(this.cbTarget.getItemCount() - 1);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        panelCenter.add((Component)new JScrollPane((Component)this.jListFiles), gbc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object c = e.getSource();
        if (this.buttonUpload == c) {
            this.uploadFile();
        } else if (this.buttonClose == c) {
            this.dispose();
        } else if (this.btAdd == c) {
            this.addFile();
        } else if (this.cbTarget == c) {
            String item = (String)this.cbTarget.x_getSelectedItem();
            this.labelPathValue.setText(item);
        } else if (this.btDelete == c) {
            this.jListFiles.removeSelectedItems();
            if (!this.jListFiles.data.isEmpty()) {
                this.jListFiles.setSelectedIndex(0);
            }
        }
    }

    private void addFile() {
        File[] files = GM.dialogSelectFiles((Component)this, (String)"");
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (!this.jListFiles.data.contains(f)) {
                    if (f.getAbsolutePath().length() > this.maxFileNameLen) {
                        this.maxFileNameLen = f.getAbsolutePath().length();
                    }
                    this.jListFiles.data.addElement(f);
                }
                ++i;
            }
            this.maxFileNameLen += 5;
        }
        this.jListFiles.setSelectionInterval(0, 0);
    }

    private void uploadFile() {
        int c = this.jListFiles.data.size();
        if (c < 1) {
            JOptionPane.showMessageDialog(this.parent, mm.getMessage("DialogUpload.nouploadfile"));
            return;
        }
        String targetDir = this.labelPathValue.getText();
        if (!StringUtils.isValidString((Object)targetDir)) {
            JOptionPane.showMessageDialog(this.parent, mm.getMessage("DialogUpload.emptytarget"));
            return;
        }
        boolean isFinished = true;
        int i = 0;
        while (i < c) {
            Object o = this.jListFiles.data.getElementAt(i);
            if (o instanceof File) {
                isFinished = false;
                break;
            }
            ++i;
        }
        if (isFinished) {
            JOptionPane.showMessageDialog(this.parent, mm.getMessage("DialogUpload.uploadfinish"));
            return;
        }
        boolean isApplyAll = false;
        boolean isOverWrite = true;
        int i2 = 0;
        while (i2 < c) {
            Object o = this.jListFiles.data.getElementAt(i2);
            if (o instanceof File) {
                File f = (File)o;
                String oldFile = f.getAbsolutePath();
                String msg = "";
                try {
                    if (!f.exists()) {
                        throw new Exception(mm.getMessage("DialogUpload.filenotexist"));
                    }
                    String child = f.getName();
                    String dstPathName = new File(targetDir, child).getAbsolutePath();
                    boolean isExist = this.sc.isFileExists(dstPathName);
                    if (isExist) {
                        if (!isApplyAll) {
                            DialogIsOverwrite dio = new DialogIsOverwrite(dstPathName);
                            dio.setVisible(true);
                            if (dio.isApplyAll()) {
                                isApplyAll = true;
                            }
                            isOverWrite = dio.isOverWrite();
                        }
                        if (isOverWrite) {
                            this.sc.uploadFile(f, dstPathName);
                            msg = String.valueOf(oldFile) + this.newSplitString(this.maxFileNameLen - oldFile.length()) + mm.getMessage("DialogUpload.statusOK");
                        } else {
                            msg = String.valueOf(oldFile) + this.newSplitString(this.maxFileNameLen - oldFile.length()) + mm.getMessage("DialogUpload.statusIgnore");
                        }
                    } else {
                        this.sc.uploadFile(f, dstPathName);
                        msg = String.valueOf(oldFile) + this.newSplitString(this.maxFileNameLen - oldFile.length()) + mm.getMessage("DialogUpload.statusOK");
                    }
                }
                catch (Throwable x) {
                    msg = String.valueOf(oldFile) + this.newSplitString(this.maxFileNameLen - oldFile.length()) + mm.getMessage("DialogUpload.failed", (Object)x.getMessage());
                    x.printStackTrace();
                }
                this.jListFiles.data.setElementAt(msg, i2);
            }
            ++i2;
        }
    }

    String newSplitString(int num) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < num) {
            sb.append('-');
            ++i;
        }
        return "     " + sb.toString();
    }
}

