/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.DBConfig;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Table;
import com.scudata.ide.IdeUtil;
import com.scudata.ide.common.AppFrame;
import com.scudata.ide.common.Console;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.DataSourceListModel;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.PanelConsole;
import com.scudata.ide.common.dialog.DialogDataSource;
import com.scudata.ide.common.dialog.DialogInputText;
import com.scudata.ide.common.dialog.DialogMemory;
import com.scudata.ide.common.swing.AllPurposeEditor;
import com.scudata.ide.common.swing.AllPurposeRenderer;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.monitor.BaseTree;
import com.scudata.ide.monitor.BaseTreeNode;
import com.scudata.ide.monitor.DialogAbout;
import com.scudata.ide.monitor.DialogServerOptions;
import com.scudata.ide.monitor.DialogUnitConfigC;
import com.scudata.ide.monitor.DialogUpload;
import com.scudata.ide.monitor.MenuBase;
import com.scudata.ide.monitor.MulticastListener;
import com.scudata.ide.monitor.MulticastMonitor;
import com.scudata.ide.monitor.ServerClient;
import com.scudata.ide.monitor.ServerData;
import com.scudata.ide.monitor.ToolBarBase;
import com.scudata.ide.monitor.UnitData;
import com.scudata.ide.monitor.Util;
import com.scudata.ide.monitor.resources.MonitorMessage;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.base.PanelValue;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.parallel.UnitConfig;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class MONITOR
extends AppFrame
implements MulticastListener {
    private static final long serialVersionUID = 1L;
    public static String IMAGE_SRC = "/com/scudata/ide/monitor/resources/";
    public static MenuBase appMenu;
    public static ToolBarBase appTool;
    MessageManager mm = MonitorMessage.get();
    MessageManager sm = IdeSplMessage.get();
    private JSplitPane spMain = new JSplitPane();
    private JSplitPane spLeft = new JSplitPane();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private MulticastMonitor mcm = null;
    private static String defLogoName;
    transient RaqsoftConfig manageConfig;
    BaseTreeNode currentNode = null;
    private BaseTree baseTree = new BaseTree(new BaseTreeNode(this.mm.getMessage("BaseTree.cluster"))){
        private static final long serialVersionUID = 900520062L;

        @Override
        public void showNode(BaseTreeNode node) {
            MONITOR.this.displayNode(node);
        }
    };
    private JTabbedPane tabTask = new JTabbedPane();
    private JTabbedPane tabParam = new JTabbedPane();
    private final byte COL_INDEX = 0;
    private final byte COL_TASK_ID = 1;
    private final byte COL_DFX_NAME = (byte)2;
    private final byte COL_ARG_DESC = (byte)3;
    private final byte COL_BEGIN_TIME = (byte)4;
    private final String TITLE_INDEX = GM.isChineseLanguage() ? "\u5e8f\u53f7" : "Index";
    private final String TITLE_TASK_ID = this.sm.getMessage("unitconsole.taskid");
    private final String TITLE_DFX_NAME = this.mm.getMessage("monitor.splxname");
    private final String TITLE_ARG_DESC = this.sm.getMessage("unitconsole.argdesc");
    private final String TITLE_BEGIN_TIME = this.sm.getMessage("unitconsole.starttime");
    private JTableEx tableTask = new JTableEx(new String[]{this.TITLE_INDEX, this.TITLE_TASK_ID, this.TITLE_DFX_NAME, this.TITLE_ARG_DESC, this.TITLE_BEGIN_TIME}){
        private static final long serialVersionUID = 1L;

        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            switch (col) {
                case 2: 
                case 3: {
                    DialogInputText dit = new DialogInputText(false);
                    dit.setText((String)this.data.getValueAt(row, col));
                    dit.setVisible(true);
                }
            }
        }

        public void rowfocusChanged(int oldRow, int newRow) {
            MONITOR.this.currentNode.setTaskRow(newRow);
            boolean en = newRow >= 0;
            MONITOR.this.enableStopTask(en);
        }

        public void rightClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            if (e.getButton() != 3) {
                return;
            }
            if (row < 0) {
                return;
            }
            JPopupMenu popMenu = new JPopupMenu();
            JMenuItem mCancelTask = new JMenuItem(MONITOR.this.sm.getMessage("unitconsole.canceltask"));
            mCancelTask.setIcon(GM.getImageIcon((String)"/com/scudata/ide/common/resources/m_delete.gif"));
            mCancelTask.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MONITOR.this.cancelTask();
                }
            });
            popMenu.add(mCancelTask);
            popMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    };
    private final String TITLE_SPACE_NAME = this.sm.getMessage("unitconsole.spacename");
    private final String TITLE_PARAM_NAME = this.sm.getMessage("unitconsole.paramname");
    private final String TITLE_PARAM_VALUE = this.sm.getMessage("unitconsole.paramvalue");
    private final int COL_SPACE_NAME = 1;
    private final int COL_PARAM_NAME = 2;
    private final int COL_PARAM_VALUE = 3;
    private JTableEx tableParam = new JTableEx(new String[]{this.TITLE_INDEX, this.TITLE_SPACE_NAME, this.TITLE_PARAM_NAME, this.TITLE_PARAM_VALUE}){
        private static final long serialVersionUID = 1L;

        public void rowfocusChanged(int oldRow, int newRow) {
            if (newRow >= 0) {
                Object value = MONITOR.this.tableParam.getValueAt(newRow, 3);
                GVSpl.panelValue.tableValue.setValue(value);
                MONITOR.this.currentNode.setParamRow(newRow);
            } else {
                GVSpl.panelValue.tableValue.setValue(null);
            }
        }
    };

    static {
        defLogoName = "monitor_logo.png";
        try {
            ImageIcon ii;
            if (GM.isMacOS() && (ii = IdeUtil.getLogoImage((boolean)true, (String)defLogoName)) != null) {
                GM.setMacOSDockIcon((Image)ii.getImage());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void displayNode(BaseTreeNode node) {
        this.currentNode = node;
        this.enableAll(false);
        if (node == null) {
            return;
        }
        byte type = node.getType();
        Table tasks = null;
        Table params = null;
        int taskRow = -1;
        int paramRow = -1;
        boolean isAlive = false;
        switch (type) {
            case 2: {
                ServerData sd = (ServerData)node.getUserObject();
                isAlive = sd.isAlive();
                this.enableServer(isAlive);
                this.enableDelete(!isAlive);
                this.enableStop(isAlive);
                this.enableUpdate(isAlive && this.canUpdate());
                break;
            }
            case 3: {
                BaseTreeNode pNode = (BaseTreeNode)node.getParent();
                UnitData ud = (UnitData)node.getUserObject();
                isAlive = ud.isAlive();
                this.enableStart(!isAlive && pNode.isAlive());
                this.enableStop(isAlive);
                if (!isAlive) break;
                tasks = ud.getTasks();
                params = ud.getParams();
            }
        }
        this.showTaskList(tasks, taskRow);
        this.showParamList(params, paramRow);
    }

    private boolean canUpdate() {
        String zipPath = Util.zipFileName();
        File f1 = new File(zipPath);
        return f1.exists();
    }

    public MONITOR() throws Exception {
        this.setTitle(this.mm.getMessage("monitor.title"));
        ImageIcon ii = IdeUtil.getLogoImage((boolean)true, (String)defLogoName);
        if (ii != null) {
            this.setIconImage(ii.getImage());
        }
        MONITOR.holdConsole();
        GV.appFrame = this;
        this.mcm = new MulticastMonitor(this);
        this.mcm.start();
        this.manageConfig = MONITOR.load();
        this.init();
        this.rqInit();
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                MONITOR.this.search();
            }
        });
    }

    private static RaqsoftConfig load() {
        try {
            String filePath = GM.getAbsolutePath((String)"config/manageConfig.xml");
            FileInputStream fis = new FileInputStream(filePath);
            return ConfigUtil.load((InputStream)fis);
        }
        catch (Exception x) {
            return new RaqsoftConfig();
        }
    }

    private static void save(RaqsoftConfig config) {
        try {
            String filePath = GM.getAbsolutePath((String)"config/manageConfig.xml");
            ConfigUtil.write((String)filePath, (RaqsoftConfig)config);
        }
        catch (Exception ex) {
            GM.showException((Object)ex);
        }
    }

    private DataSourceListModel getDSModel() {
        DataSourceListModel dsModel = new DataSourceListModel(false);
        List dbConfigs = this.manageConfig.getDBList();
        if (dbConfigs != null) {
            int i = 0;
            while (i < dbConfigs.size()) {
                DBConfig db = (DBConfig)dbConfigs.get(i);
                DataSource ds = new DataSource(db);
                dsModel.addElement((Object)ds);
                ++i;
            }
        }
        return dsModel;
    }

    private void storeDSModel(DataSourceListModel dsModel) {
        ArrayList<DBConfig> dbConfigs = new ArrayList<DBConfig>();
        int i = 0;
        while (i < dsModel.size()) {
            DataSource ds = (DataSource)dsModel.get(i);
            if (ds.isLocal()) {
                dbConfigs.add(new DBConfig((DBConfig)ds.getDBInfo()));
            }
            ++i;
        }
        this.manageConfig.setDBList(dbConfigs);
    }

    private void showTaskList(Table taskTable, int row) {
        this.tableTask.acceptText();
        this.tableTask.removeAllRows();
        this.tableTask.clearSelection();
        if (taskTable == null || taskTable.length() == 0) {
            return;
        }
        int len = taskTable.length();
        int i = 1;
        while (i <= len) {
            BaseRecord record = taskTable.getRecord(i);
            int r = this.tableTask.addRow(false);
            Integer taskId = (Integer)record.getFieldValue("TaskId");
            this.tableTask.data.setValueAt(taskId, r, 1);
            String dfxName = (String)record.getFieldValue("SPLXName");
            this.tableTask.data.setValueAt(dfxName, r, 2);
            String argDesc = (String)record.getFieldValue("ArgDesc");
            this.tableTask.data.setValueAt(argDesc, r, 3);
            Long beginTime = (Long)record.getFieldValue("BeginTime");
            this.tableTask.data.setValueAt(this.dateFormat.format(new Date(beginTime)), r, 4);
            ++i;
        }
        this.tableTask.resetIndex();
        if (row >= len) {
            row = len - 1;
        }
        if (row >= 0) {
            this.tableTask.selectRow(row);
            this.enableStopTask(true);
        }
    }

    private void showParamList(Table paramTable, int row) {
        this.tableParam.acceptText();
        this.tableParam.removeAllRows();
        this.tableParam.clearSelection();
        if (paramTable == null || paramTable.length() == 0) {
            GVSpl.panelValue.tableValue.setValue(null);
            return;
        }
        int len = paramTable.length();
        int i = 1;
        while (i <= len) {
            BaseRecord record = paramTable.getRecord(i);
            int r = this.tableParam.addRow(false);
            String spaceName = (String)record.getFieldValue("SpaceName");
            this.tableParam.data.setValueAt(spaceName, r, 1);
            String paramName = (String)record.getFieldValue("ParamName");
            this.tableParam.data.setValueAt(paramName, r, 2);
            Object paramValue = record.getFieldValue("ParamValue");
            this.tableParam.data.setValueAt(paramValue, r, 3);
            ++i;
        }
        this.tableParam.resetIndex();
        int selectedRow = this.tableParam.getSelectedRow();
        if (selectedRow >= 0) {
            Object value = this.tableParam.getValueAt(selectedRow, 3);
            GVSpl.panelValue.tableValue.setValue(value);
        }
        if (row >= len) {
            row = len - 1;
        }
        this.tableParam.selectRow(row);
    }

    public static void holdConsole() {
        if (GV.console == null) {
            GV.console = new Console(new JTextArea());
        }
    }

    @Override
    public void addClusterServer(final String host, final int port) {
        SwingUtilities.invokeLater(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<MONITOR> clazz = MONITOR.class;
                synchronized (MONITOR.class) {
                    MONITOR.this.baseTree.addClusterServer(host, port);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    private void search() {
        this.mcm.broadcast();
    }

    private void refresh() {
        this.baseTree.refresh();
        this.displayNode(this.baseTree.getSelectedNode());
    }

    private void rqInit() {
        this.tableTask.setIndexCol(0);
        this.tableTask.setColumnEditable(1, false);
        this.tableTask.setColumnEditable(2, false);
        this.tableTask.setColumnEditable(3, false);
        this.tableTask.setColumnEditable(4, false);
        this.tableParam.setIndexCol(0);
        this.tableParam.setColumnEditable(1, false);
        this.tableParam.setColumnEditable(2, false);
        this.tableParam.setColumnWidth(1, 200);
        this.tableTask.setRowHeight(23);
        this.tableParam.setRowHeight(23);
        TableColumn tc = this.tableParam.getColumn(3);
        JTextField tf = new JTextField();
        tf.setEditable(false);
        tc.setCellEditor((TableCellEditor)new AllPurposeEditor(tf, this.tableParam));
        tc.setCellRenderer((TableCellRenderer)new AllPurposeRenderer());
        this.enableAll(false);
    }

    private void init() {
        appMenu = new MenuBase("");
        this.setJMenuBar((JMenuBar)((Object)appMenu));
        appTool = new ToolBarBase();
        this.getContentPane().add((Component)((Object)appTool), "North");
        GVSpl.panelValue = new PanelValue();
        GVSpl.panelValue.valueBar.disablePin();
        this.tabTask.add((Component)new JScrollPane((Component)this.tableTask), this.mm.getMessage("monitor.tasklist"));
        this.tabParam.add((Component)new JScrollPane((Component)this.tableParam), this.mm.getMessage("monitor.paramlist"));
        JPanel panelList = new JPanel(new GridBagLayout());
        panelList.add((Component)this.tabTask, GM.getGBC((int)1, (int)1, (boolean)true, (boolean)true));
        panelList.add((Component)this.tabParam, GM.getGBC((int)2, (int)1, (boolean)true, (boolean)true));
        this.spMain.setOneTouchExpandable(true);
        this.spMain.setDividerSize(8);
        this.spMain.setOrientation(1);
        int POS_DESK = new Double(0.25 * Toolkit.getDefaultToolkit().getScreenSize().getWidth()).intValue();
        this.spMain.setDividerLocation(POS_DESK);
        PanelConsole panelConsole = new PanelConsole(GV.console, false);
        this.spLeft.setOneTouchExpandable(true);
        this.spLeft.setDividerSize(8);
        this.spLeft.setOrientation(0);
        int POS_LEFT = new Double(0.5 * Toolkit.getDefaultToolkit().getScreenSize().getHeight()).intValue();
        this.spLeft.setDividerLocation(POS_LEFT);
        this.spLeft.add((Component)new JScrollPane(this.baseTree), "top");
        this.spLeft.add((Component)panelConsole, "bottom");
        this.spMain.add((Component)this.spLeft, "left");
        this.spMain.add((Component)panelList, "right");
        this.getContentPane().add((Component)this.spMain, "Center");
        this.getContentPane().add((Component)GVSpl.panelValue, "East");
        this.setExtendedState(6);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MONITOR.this.quit();
            }
        });
    }

    public void executeCmd(short cmdId) throws Exception {
        switch (cmdId) {
            case 1001: {
                this.search();
                break;
            }
            case 1005: {
                this.refresh();
                break;
            }
            case 1010: {
                int i;
                if (this.currentNode.getType() == 2 && !this.isAllUnitStopped(this.currentNode)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), this.mm.getMessage("MONITOR.needstopall"));
                    return;
                }
                if (this.currentNode.getType() == 2 && (i = JOptionPane.showConfirmDialog((Component)((Object)this), this.mm.getMessage("monitor.closeserver"), this.mm.getMessage("monitor.hint"), 0)) != 0) {
                    return;
                }
                this.currentNode.stop();
                break;
            }
            case 1015: {
                this.currentNode.start();
                break;
            }
            case 1020: {
                this.cancelTask();
                break;
            }
            case 80: {
                this.quit();
                return;
            }
            case 1050: {
                this.delete();
                break;
            }
            case 1055: {
                this.dataSource();
                break;
            }
            case 1060: {
                this.config();
                break;
            }
            case 1065: {
                this.options();
                break;
            }
            case 1070: {
                this.upload();
                break;
            }
            case 1075: {
                this.update();
                break;
            }
            case 305: {
                DialogAbout da = new DialogAbout((JFrame)((Object)this), this.getTitle());
                da.init();
                da.setVisible(true);
                return;
            }
            case 310: {
                if (GV.dialogMemory == null) {
                    GV.dialogMemory = new DialogMemory();
                }
                GV.dialogMemory.setVisible(true);
                return;
            }
        }
    }

    private void cancelTask() {
        int r = this.tableTask.getSelectedRow();
        Integer taskId = (Integer)this.tableTask.data.getValueAt(r, 1);
        UnitData ud = (UnitData)this.currentNode.getUserObject();
        ud.stopTask(taskId);
        this.refresh();
    }

    public String getReleaseDate() {
        return "2026-01-07";
    }

    private void selectNode(BaseTreeNode node) {
        this.baseTree.selectNode(node);
        this.displayNode(node);
    }

    private void delete() {
        String t2;
        if (this.currentNode == null) {
            return;
        }
        String t1 = this.mm.getMessage("MONITOR.askdelete", (Object)this.currentNode.getName());
        int option = JOptionPane.showConfirmDialog((Component)((Object)this), t1, t2 = this.mm.getMessage("public.hint"), 2);
        if (option != 0) {
            return;
        }
        BaseTreeNode root = this.baseTree.getRoot();
        int index = root.getIndex(this.currentNode);
        root.remove(this.currentNode);
        this.baseTree.nodeStructureChanged(root);
        if (root.getChildCount() == 0) {
            this.selectNode(root);
        } else {
            BaseTreeNode next = index >= root.getChildCount() ? (BaseTreeNode)root.getLastChild() : (BaseTreeNode)root.getChildAt(index);
            this.selectNode(next);
        }
    }

    private void dataSource() {
        GV.config = this.manageConfig;
        GV.dsModel = this.getDSModel();
        DialogDataSource dds = new DialogDataSource(GV.dsModel);
        dds.setVisible(true);
        DataSourceListModel dsModel = dds.getDataSourceListModel();
        this.storeDSModel(dsModel);
        BaseTreeNode root = this.baseTree.getRoot();
        int c = root.getChildCount();
        int i = 0;
        while (i < c) {
            BaseTreeNode nodeNode = (BaseTreeNode)root.getChildAt(i);
            ServerData sd = (ServerData)nodeNode.getUserObject();
            if (sd.isAlive()) {
                RaqsoftConfig optionConfig = sd.getRaqsoftConfig();
                optionConfig.setDBList(this.manageConfig.getDBList());
                sd.setRaqsoftConfig(optionConfig);
            }
            ++i;
        }
    }

    private void config() {
        ServerData sd = (ServerData)this.currentNode.getUserObject();
        DialogUnitConfigC duc = new DialogUnitConfigC((JFrame)((Object)this), this.mm.getMessage("MONITOR.unitConfig"), sd.getUnitConfig(), sd.host, sd.port);
        duc.setVisible(true);
        if (duc.getOption() == 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            UnitConfig uc = duc.getUnitConfig();
            sd.setUnitConfig(uc);
            this.currentNode.reload();
            this.baseTree.nodeStructureChanged(this.currentNode);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void options() {
        ServerData sd = (ServerData)this.currentNode.getUserObject();
        ServerClient sc = new ServerClient(sd.host, sd.port);
        RaqsoftConfig rc = sd.getRaqsoftConfig();
        DialogServerOptions.setClusterEnv(rc, sc);
        DialogServerOptions dso = new DialogServerOptions((JFrame)((Object)this));
        dso.setVisible(true);
        if (dso.getOption() == 0) {
            rc = dso.getClusterConfig();
            sd.setRaqsoftConfig(rc);
        }
    }

    private void upload() {
        ServerData sd = (ServerData)this.currentNode.getUserObject();
        ServerClient sc = new ServerClient(sd.host, sd.port);
        DialogUpload du = new DialogUpload(sc);
        du.setVisible(true);
    }

    private boolean isAllUnitStopped(BaseTreeNode serverNode) {
        int c = serverNode.getChildCount();
        if (c == 0) {
            return true;
        }
        int i = 0;
        while (i < c) {
            BaseTreeNode unitNode = (BaseTreeNode)serverNode.getChildAt(i);
            UnitData ud = (UnitData)unitNode.getUserObject();
            if (ud.isAlive()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void update() {
        if (!this.isAllUnitStopped(this.currentNode)) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.mm.getMessage("MONITOR.needstopall"));
            return;
        }
        ServerData sd = (ServerData)this.currentNode.getUserObject();
        ServerClient sc = new ServerClient(sd.host, sd.port);
        String nodeVersion = sc.getUpdateVersion();
        String localVersion = Util.getVersion();
        if (localVersion.equals(nodeVersion)) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.mm.getMessage("MONITOR.isnewversion"));
            return;
        }
        try {
            String zipFile = Util.zipFileName();
            File localFile = new File(zipFile);
            String dstPathName = sc.getUpdateZipPath();
            Logger.info((Object)this.mm.getMessage("MONITOR.startupdate", (Object)sc));
            sc.uploadFile(localFile, dstPathName);
            sc.updateUnZip();
            Logger.info((Object)this.mm.getMessage("MONITOR.updatefinish"));
        }
        catch (Exception x) {
            GM.showException((Object)x);
        }
    }

    private void enableAll(boolean en) {
        this.enableServer(en);
        this.enableStop(en);
        this.enableStart(en);
        this.enableStopTask(en);
        this.enableDelete(en);
        this.enableUpdate(en);
    }

    private void enableServer(boolean en) {
        short[] cmdIds = new short[]{1055, 1060, 1065, 1070};
        this.enableCmd(cmdIds, en);
    }

    private void enableStop(boolean en) {
        short[] cmdIds = new short[]{1010};
        this.enableCmd(cmdIds, en);
    }

    private void enableStart(boolean en) {
        short[] cmdIds = new short[]{1015};
        this.enableCmd(cmdIds, en);
    }

    private void enableStopTask(boolean en) {
        short[] cmdIds = new short[]{1020};
        this.enableCmd(cmdIds, en);
    }

    private void enableDelete(boolean en) {
        short[] cmdIds = new short[]{1050};
        this.enableCmd(cmdIds, en);
    }

    private void enableUpdate(boolean en) {
        short[] cmdIds = new short[]{1075};
        this.enableCmd(cmdIds, en);
    }

    private void enableCmd(short[] cmds, boolean en) {
        appMenu.setMenuEnabled(cmds, en);
        appTool.setButtonsEnabled(cmds, en);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                IdeUtil.initLNF();
                try {
                    String startHome = System.getProperty("start.home");
                    if (!StringUtils.isValidString((Object)startHome)) {
                        System.setProperty("raqsoft.home", System.getProperty("user.home"));
                    } else {
                        System.setProperty("raqsoft.home", String.valueOf(startHome));
                    }
                    MONITOR monitor = new MONITOR();
                    monitor.setVisible(true);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    try {
                        GM.showException((Object)t);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        });
    }

    public String getProductName() {
        return null;
    }

    public boolean exit() {
        return false;
    }

    public void quit() {
        MONITOR.save(this.manageConfig);
        System.exit(0);
    }

    public JInternalFrame openSheetFile(String fileName) throws Exception {
        return null;
    }

    public void changeMenuAndToolBar(JMenuBar menu, JToolBar toolBar) {
    }

    public boolean closeSheet(Object sheet) {
        return false;
    }

    public boolean closeAll() {
        return false;
    }
}

