/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.monitor.MONITOR;
import com.scudata.ide.spl.update.UpdateManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;

public class Util {
    public static JButton createButton(String icon, String text, ActionListener listener) {
        JButton b = new JButton();
        b.setIcon(GM.getImageIcon((String)(String.valueOf(MONITOR.IMAGE_SRC) + icon + ".gif")));
        b.setToolTipText(text);
        b.addActionListener(listener);
        return b;
    }

    private static String updatePath() {
        String installPath = System.getProperty("start.home");
        installPath = StringUtils.replace((String)installPath, (String)"\\", (String)"/");
        String updatePath = String.valueOf(installPath) + "/update";
        return updatePath;
    }

    public static String zipFileName() {
        String updatePath = Util.updatePath();
        String updateZip = "raqsoftUpdate.zip";
        try {
            String file = updatePath + "/server.txt";
            FileInputStream fis = new FileInputStream(file);
            HashMap map = UpdateManager.readProperties((InputStream)fis);
            updateZip = (String)map.get("updateZip");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return String.valueOf(updatePath) + "/" + updateZip;
    }

    public static String getVersion() {
        String updatePath = Util.updatePath();
        try {
            String file = updatePath + "/server.txt";
            FileInputStream fis = new FileInputStream(file);
            HashMap map = UpdateManager.readProperties((InputStream)fis);
            return (String)map.get("version");
        }
        catch (Exception x) {
            x.printStackTrace();
            return "";
        }
    }

    public static void updateByZip(String installPath, String zipFilePath) throws Exception {
        FileOutputStream fileOut = null;
        InputStream inputStream = null;
        ZipFile zipFile = null;
        try {
            byte[] buf = new byte[1024];
            int readBytes = -1;
            zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                name = StringUtils.replace((String)name, (String)"\\", (String)"/");
                File file = new File(String.valueOf(installPath) + "/" + name);
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    inputStream = zipFile.getInputStream(entry);
                    fileOut = new FileOutputStream(file);
                    while ((readBytes = inputStream.read(buf)) > 0) {
                        fileOut.write(buf, 0, readBytes);
                    }
                }
                finally {
                    try {
                        fileOut.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                    file.setLastModified(entry.getTime());
                }
            }
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

