/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor.server;

import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.monitor.MulticastMonitor;
import com.scudata.ide.monitor.Request;
import com.scudata.ide.monitor.Response;
import com.scudata.ide.monitor.Util;
import com.scudata.ide.monitor.resources.MonitorMessage;
import com.scudata.ide.monitor.server.InputStreamFlusher;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitConfig;
import com.scudata.parallel.UnitContext;
import com.scudata.resources.ParallelMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;

public class CLUSTERSERVER {
    public static CLUSTERSERVER instance;
    ServerSocket serverSocket = null;
    MulticastMonitor multicastMonitor;
    static String csHost;
    static int csPort;
    private volatile boolean stop = false;
    static MessageManager mm;
    static MessageManager cm;

    static {
        csHost = null;
        csPort = 16800;
        mm = ParallelMessage.get();
        cm = MonitorMessage.get();
    }

    private CLUSTERSERVER() {
    }

    private byte[] getFileBytes(String configFile) {
        try {
            FileInputStream is = new FileInputStream(configFile);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int l = ((InputStream)is).read(buf);
            while (l > 0) {
                os.write(buf, 0, l);
                l = ((InputStream)is).read(buf);
            }
            ((InputStream)is).close();
            os.close();
            return os.toByteArray();
        }
        catch (Exception e) {
            Logger.debug((Object)cm.getMessage("CLUSTERSERVER.nofile", (Object)configFile));
            return null;
        }
    }

    public String toString() {
        return String.valueOf(csHost) + ":" + csPort;
    }

    public Response execute(Request req) {
        Response res = new Response();
        try {
            switch (req.getAction()) {
                case 15: {
                    res.setResult(CLUSTERSERVER.getHome());
                    break;
                }
                case 1: {
                    this.actionConfigFile(req, res, "raqsoftConfig.xml");
                    break;
                }
                case 100: {
                    this.stop = true;
                    break;
                }
                case 1001: {
                    String host = (String)req.getAttr("Host");
                    int port = (Integer)req.getAttr("Port");
                    boolean action = (Boolean)req.getAttr("Action");
                    this.unitAction(host, port, action);
                    break;
                }
                case 2: {
                    this.actionConfigFile(req, res, UnitContext.UNIT_XML);
                    break;
                }
                case 12: {
                    String zipPath = Util.zipFileName();
                    Util.updateByZip(CLUSTERSERVER.getHome(), zipPath);
                    res.setResult(true);
                    break;
                }
                case 10: {
                    String version = Util.getVersion();
                    res.setResult(version);
                    break;
                }
                case 11: {
                    String zipPath = Util.zipFileName();
                    res.setResult(zipPath);
                    break;
                }
                case 13: {
                    Object[] paths = this.listTargetPath();
                    res.setResult(paths);
                }
            }
        }
        catch (Exception x) {
            res.setException(x);
        }
        return res;
    }

    private Object[] listTargetPath() throws Exception {
        List searchPaths;
        String envFile = CLUSTERSERVER.getAbsolutePath("config/raqsoftConfig.xml");
        RaqsoftConfig rc = ConfigUtil.load((InputStream)new FileInputStream(envFile), (boolean)false);
        Object[] paths = new Object[2];
        ArrayList<String> key = new ArrayList<String>();
        ArrayList<String> val = new ArrayList<String>();
        key.add(cm.getMessage("CLUSTERSERVER.directoryConfig"));
        val.add(CLUSTERSERVER.getAbsolutePath("config"));
        key.add(cm.getMessage("CLUSTERSERVER.directoryLibrary"));
        val.add(CLUSTERSERVER.getAbsolutePath("lib"));
        String mainPath = rc.getMainPath();
        if (StringUtils.isValidString((Object)mainPath)) {
            key.add(cm.getMessage("CLUSTERSERVER.directoryMainPath"));
            val.add(CLUSTERSERVER.getAbsolutePath(mainPath));
        }
        if ((searchPaths = rc.getSplPathList()) != null) {
            int i = 0;
            while (i < searchPaths.size()) {
                String path = (String)searchPaths.get(i);
                if (StringUtils.isValidString((Object)path)) {
                    key.add(path);
                    val.add(CLUSTERSERVER.getAbsolutePath(path));
                }
                ++i;
            }
        }
        String unitFile = CLUSTERSERVER.getAbsolutePath("config/" + UnitContext.UNIT_XML);
        UnitConfig uc = new UnitConfig();
        FileInputStream fis = new FileInputStream(unitFile);
        uc.load((InputStream)fis);
        fis.close();
        paths[0] = key;
        paths[1] = val;
        return paths;
    }

    private void actionConfigFile(Request req, Response res, String configXML) throws Exception {
        int method = (Integer)req.getAttr("Config method");
        String filePath = GM.getAbsolutePath((String)("config/" + configXML));
        if (method == 0) {
            byte[] buf = this.getFileBytes(filePath);
            res.setResult(buf);
        } else {
            File f = new File(filePath);
            if (!f.exists()) {
                File parent = f.getParentFile();
                parent.mkdirs();
            }
            if (f.exists() && !f.canWrite()) {
                String msg = IdeCommonMessage.get().getMessage("public.readonly", (Object)f.getName());
                throw new RQException(msg);
            }
            FileOutputStream fos = new FileOutputStream(f);
            byte[] buf = (byte[])req.getAttr("Config content");
            fos.write(buf);
            fos.close();
        }
    }

    private void unitAction(String host, int port, boolean isStart) throws Exception {
        String[] args = this.getUnitCmd(host, port, isStart);
        Process p = Runtime.getRuntime().exec(args);
        if (isStart && !HostManager.isWindows()) {
            InputStream errIs = p.getErrorStream();
            InputStreamFlusher isf = new InputStreamFlusher(errIs, host, port);
            isf.start();
            InputStream stdIs = p.getInputStream();
            InputStreamFlusher isf2 = new InputStreamFlusher(stdIs, host, port);
            isf2.start();
        }
    }

    private String[] getUnitCmd(String host, int port, boolean start) throws Exception {
        String startName = HostManager.isWindows() ? "bin/ServerConsole.bat" : "bin/ServerConsole.sh";
        String serverPath = GM.getAbsolutePath((String)startName);
        File f = new File(serverPath);
        if (!f.exists()) {
            throw new Exception(cm.getMessage("CLUSTERSERVER.nofile", (Object)serverPath));
        }
        String cmd = serverPath;
        String node = String.valueOf(host) + ":" + port;
        String[] args = start ? new String[]{cmd, "-p" + node} : new String[]{cmd, "-x" + node};
        return args;
    }

    public static CLUSTERSERVER getInstance() throws Exception {
        if (!StringUtils.isValidString((Object)CLUSTERSERVER.getHome())) {
            throw new Exception(mm.getMessage("UnitServer.nohome"));
        }
        if (instance == null) {
            instance = new CLUSTERSERVER();
        }
        return instance;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized boolean isRunning() {
        return !this.stop;
    }

    public void shutDown() {
        this.stop = true;
    }

    public static String getHome() {
        String home = System.getProperty("start.home");
        if (home == null) {
            throw new RuntimeException(cm.getMessage("CLUSTERSERVER.nohome"));
        }
        return home;
    }

    public static String mergeFilePath(String path, String fileName) {
        if (path.endsWith("\\") || path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String p = System.getProperty("file.separator");
        String filePath = String.valueOf(path) + p + fileName;
        filePath = Sentence.replace((String)filePath, (String)"/", (String)p, (int)1);
        filePath = Sentence.replace((String)filePath, (String)"\\", (String)p, (int)1);
        return filePath;
    }

    public static String getAbsolutePath(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return path;
        }
        return CLUSTERSERVER.mergeFilePath(CLUSTERSERVER.getHome(), path);
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                UnitClient uc = new UnitClient(args[0]);
                csHost = uc.getHost();
                csPort = uc.getPort();
            }
            if (csHost == null) {
                csHost = UnitContext.getDefaultHost();
            }
            CLUSTERSERVER server = CLUSTERSERVER.getInstance();
            server.run();
        }
        catch (Exception x) {
            x.printStackTrace();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.exit(0);
    }
}

