/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor.server;

import com.scudata.app.common.Section;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.ide.monitor.FileInfo;
import com.scudata.ide.monitor.Request;
import com.scudata.ide.monitor.Response;
import com.scudata.parallel.SocketData;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileService {
    public static Response execute(Request req, SocketData sd) {
        int cmd = req.getAction();
        Response res = new Response();
        try {
            switch (cmd) {
                case 10001: {
                    String dstPath = (String)req.getAttr("Dest absolute path");
                    long lastModified = ((Number)req.getAttr("Last modified")).longValue();
                    FileService.upload(dstPath, sd, lastModified);
                    res.setResult(Boolean.TRUE);
                    break;
                }
                case 10003: {
                    String absPath = (String)req.getAttr("Dest absolute path");
                    File f = new File(absPath);
                    res.setResult(f.exists());
                    break;
                }
                case 10002: {
                    String parentPath = (String)req.getAttr("Files path");
                    String fileExt = (String)req.getAttr("Files ext");
                    Boolean onlyDirectory = (Boolean)req.getAttr("Only directory");
                    List<FileInfo> rtn = FileService.listFiles(parentPath, fileExt, onlyDirectory);
                    res.setResult(rtn);
                }
            }
        }
        catch (Exception x) {
            res.setException(x);
        }
        return res;
    }

    private static FileInfo toFileInfo(File f) {
        FileInfo fi = new FileInfo();
        fi.setAbsolutePath(f.getAbsolutePath());
        fi.setFileName(f.getName());
        fi.setDir(f.isDirectory());
        fi.setLastModified(f.lastModified());
        fi.setSize(f.length());
        return fi;
    }

    private static FileFilter getFilter(final String fileExt) {
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (!StringUtils.isValidString((Object)fileExt)) {
                    return true;
                }
                String s = f.getName().toLowerCase();
                Section st = new Section(fileExt);
                int i = st.size() - 1;
                while (i >= 0) {
                    String extName = "." + st.get(i);
                    if (s.endsWith(extName)) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
        };
        return ff;
    }

    private static List<FileInfo> listFiles(String parentPath, String fileExt, boolean onlyDirectory) {
        File[] sub;
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        if (!StringUtils.isValidString((Object)parentPath)) {
            sub = File.listRoots();
        } else {
            File f = new File(parentPath);
            sub = f.listFiles(FileService.getFilter(fileExt));
        }
        File[] afile = sub;
        int j = sub.length;
        int i = 0;
        while (i < j) {
            File f = afile[i];
            if (!(!f.isDirectory() && !f.isFile() || onlyDirectory && f.isFile())) {
                files.add(FileService.toFileInfo(f));
            }
            ++i;
        }
        return files;
    }

    private static void upload(String dstPath, SocketData sd, long lastModified) throws Exception {
        try {
            File uploadFile = new File(dstPath);
            if (uploadFile.exists()) {
                uploadFile.delete();
            } else {
                File p = uploadFile.getParentFile();
                if (!p.exists()) {
                    p.mkdirs();
                }
            }
            BufferedOutputStream outBuff = null;
            outBuff = new BufferedOutputStream(new FileOutputStream(uploadFile));
            try {
                byte[] data = (byte[])sd.read();
                while (data != null) {
                    outBuff.write(data);
                    data = (byte[])sd.read();
                }
                outBuff.flush();
            }
            finally {
                if (outBuff != null) {
                    outBuff.close();
                }
                uploadFile.setLastModified(lastModified);
            }
            Logger.debug((Object)("Receive file:" + uploadFile.getAbsolutePath() + " OK."));
        }
        catch (Exception x) {
            File uploadFile = new File(dstPath);
            if (uploadFile.exists()) {
                uploadFile.delete();
            }
            throw x;
        }
    }

    public static void main(String[] args) {
        File f = new File("d:/");
        File[] sub = f.listFiles(FileService.getFilter(""));
        int i = 0;
        while (i < sub.length) {
            System.out.println(sub[i]);
            ++i;
        }
    }
}

