/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.CellLocation;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.common.dialog.DialogArgument;
import com.scudata.ide.spl.CloudValue;
import com.scudata.ide.spl.GMSplEE;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.GVSplEE;
import com.scudata.ide.spl.ICloudClientIDE;
import com.scudata.ide.spl.MenuSplEE;
import com.scudata.ide.spl.SheetSplSE;
import com.scudata.ide.spl.StepInfo;
import com.scudata.ide.spl.ToolBarSpl;
import com.scudata.ide.spl.base.FileTreeEE;
import com.scudata.ide.spl.control.SplEditor;
import com.scudata.ide.spl.control.SplEditorEE;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.lIllIlIlIlIIlIIl;
import com.scudata.util.CellSetUtil;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetSplEE
extends SheetSplSE {
    private static final long serialVersionUID = 1L;
    public static final byte TYPE_LOCAL = 0;
    public static final byte TYPE_CLOUD = 1;
    private byte _$4 = 0;
    private byte _$3 = (byte)2;
    private Integer _$2 = null;
    byte[][] _$1 = null;

    public SheetSplEE(String filePath, PgmCellSet cs, StepInfo stepInfo) throws Exception {
        super(filePath, cs, stepInfo);
    }

    public void setType(byte type) {
        this._$4 = type;
    }

    public byte getType() {
        return this._$4;
    }

    public void setArea(byte area) {
        this._$3 = area;
    }

    public byte getArea() {
        return this._$3;
    }

    protected DialogArgument newDialogArgument() {
        return new DialogArgument();
    }

    protected SplEditor newSplEditor() {
        return new SplEditorEE(this);
    }

    protected void refresh(boolean keyEvent) {
        this.refresh(keyEvent, true);
    }

    protected void refresh(boolean keyEvent, boolean isRefreshState) {
        this.refresh(keyEvent, isRefreshState, false);
    }

    protected void refresh(boolean keyEvent, boolean isRefreshState, boolean refreshParams) {
        boolean showCloud;
        super.refresh(keyEvent, isRefreshState, refreshParams);
        if (this._$4 == 0) {
            return;
        }
        if (!(GV.appMenu instanceof MenuSplEE)) {
            return;
        }
        MenuSplEE md = (MenuSplEE)GV.appMenu;
        ToolBarSpl tbs = (ToolBarSpl)GV.appTool;
        FileTreeEE resourceTree = GVSplEE.getResourceTree();
        if (GVSplEE.isAIOEnabled.booleanValue()) {
            showCloud = resourceTree.isAIOLogin();
            md.setMenuEnabled((short)2403, showCloud);
            md.setMenuEnabled((short)2441, showCloud);
            md.setMenuEnabled((short)2443, showCloud);
            if (this._$4 == 1) {
                md.setMenuEnabled((short)1233, false);
                md.setMenuEnabled((short)1235, false);
                tbs.setButtonEnabled((short)1233, false);
                tbs.setButtonEnabled((short)1235, false);
            }
        }
        if (SplEditorSE.isNodes()) {
            showCloud = resourceTree.isECloudLogin();
            md.setMenuEnabled((short)2463, showCloud);
            md.setMenuEnabled((short)2471, showCloud);
            md.setMenuEnabled((short)2473, showCloud);
            if (this._$4 == 1) {
                md.setMenuEnabled((short)1233, false);
                md.setMenuEnabled((short)1235, false);
                tbs.setButtonEnabled((short)1233, false);
                tbs.setButtonEnabled((short)1235, false);
            }
        }
        if (this._$4 != 0) {
            md.setMenuEnabled((short)55, false);
            md.setMenuEnabled((short)1005, false);
            md.setMenuEnabled((short)1031, false);
            md.setMenuEnabled((short)1103, false);
            md.setMenuEnabled((short)1101, false);
            tbs.setButtonEnabled((short)1103, false);
            tbs.setButtonEnabled((short)1101, false);
        }
        if (this._$4 != 0 && this._$2 == null) {
            SwingUtilities.invokeLater(new lIllIlIlIlIIlIIl(this, md));
        }
    }

    public boolean save() {
        if (this._$4 == 1) {
            String serverName = this.filePath.substring(0, this.filePath.indexOf(58));
            if (StringUtils.isValidString((Object)serverName)) {
                String fileName = GMSplEE.replaceSlash(this.filePath.substring(this.filePath.indexOf(58) + 1));
                if (fileName.startsWith("/")) {
                    fileName = fileName.substring(1);
                }
                try {
                    ICloudClientIDE cloud;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    if (this.filePath.toLowerCase().endsWith(".spl")) {
                        String cellSetStr = CellSetUtil.toString((PgmCellSet)this.splControl.cellSet);
                        out.write(cellSetStr.getBytes());
                        out.flush();
                    } else {
                        CellSetUtil.writePgmCellSet((OutputStream)out, (PgmCellSet)this.splControl.cellSet);
                    }
                    if (this._$4 == 1 && (cloud = FileTreeEE.getCloud(serverName)) != null) {
                        cloud.save(fileName, out.toByteArray(), this._$3);
                        this.setDataChanged(false);
                        return true;
                    }
                }
                catch (Exception e) {
                    GM.showException((Component)GV.appFrame, (Object)e);
                    return false;
                }
            }
            return false;
        }
        return super.save();
    }

    public synchronized void terminate() {
        super.terminate();
        if (this._$4 == 1) {
            ICloudClientIDE cloud = this.getCloud();
            if (cloud == null) {
                return;
            }
            try {
                cloud.stopRun(this._$2);
            }
            catch (Exception ex) {
                GM.showException((Component)GV.appFrame, (Object)ex);
            }
        }
    }

    protected CellLocation runNext(PgmCellSet cellSet) {
        if (this._$4 != 1) {
            return super.runNext(cellSet);
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud == null) {
            return null;
        }
        CellLocation nextCell = cloud.runNext(this._$2);
        this._$1();
        return nextCell;
    }

    protected boolean runTo(CellLocation toCell) {
        CellLocation nextCell;
        if (this._$4 != 1) {
            return false;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud == null) {
            return false;
        }
        int row = 0;
        int col = 0;
        if (toCell != null) {
            row = toCell.getRow();
            col = toCell.getCol();
        }
        ArrayList breaks = this.splEditor.getComponent().getBreakPoints();
        this.exeLocation = nextCell = cloud.runTo(this._$2, row, col, breaks);
        this._$1();
        return true;
    }

    protected void runCell(int row, int col) {
        if (this._$4 != 1) {
            super.runCell(row, col);
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            cloud.runCell(this._$2, row, col);
            this._$1();
        }
    }

    protected CellLocation runCellSet(PgmCellSet cellSet) {
        if (this._$4 != 1) {
            return super.runCellSet(cellSet);
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            CellLocation cl = cloud.run(this._$2);
            this._$1();
            return cl;
        }
        return null;
    }

    protected void interruptCellSet(PgmCellSet cellSet) {
        if (this._$4 != 1) {
            super.interruptRun(cellSet);
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            cloud.interrupt(this._$2);
        }
    }

    public synchronized void pause() {
        super.pause();
        if (this._$4 != 1) {
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            cloud.interrupt(this._$2);
        }
    }

    protected boolean isValueChanged(String cellId) {
        if (this._$4 != 1) {
            return super.isValueChanged(cellId);
        }
        return true;
    }

    protected void setValue(INormalCell nc, boolean caseLock, boolean isRefresh) {
        if (this._$4 != 1) {
            super.setValue(nc, caseLock, isRefresh);
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        byte dataType = 0;
        Object value = null;
        if (cloud != null) {
            Object val = cloud.getValue(this._$2, nc.getRow(), nc.getCol());
            if (val instanceof CloudValue) {
                CloudValue cv = (CloudValue)val;
                value = cv.getValue();
                dataType = cv.getDataType();
            } else {
                value = val;
            }
        }
        GVSpl.panelValue.tableValue.setValue(value, nc.getCellId());
        if (dataType == 1) {
            // empty if block
        }
    }

    protected Object getValue(INormalCell nc) {
        if (this._$4 != 1) {
            return super.getValue(nc);
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            return cloud.getValue(this._$2, nc.getRow(), nc.getCol());
        }
        return null;
    }

    protected boolean hasReturn(PgmCellSet cellSet) {
        if (this._$4 != 1) {
            return super.hasReturn(cellSet);
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            return cloud.hasReturn(this._$2);
        }
        return false;
    }

    public Sequence peek(int n) {
        String cellId;
        CellLocation cl;
        if (this._$4 != 1) {
            return null;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null && (cl = CellLocation.parse((String)(cellId = GVSpl.panelValue.tableValue.getCellId()))) != null) {
            return cloud.peek(this._$2, cl.getRow(), cl.getCol(), n);
        }
        return null;
    }

    public Sequence getSegmentValue(int row, int col, int from, int num) {
        if (this._$4 != 1) {
            return super.getSegmentValue(row, col, from, num);
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            return cloud.getSegmentValue(this._$2, row, col, from, num);
        }
        return null;
    }

    public byte getCellDispType(int row, int col) {
        if (this._$1 == null) {
            return 6;
        }
        if (row > this._$1.length) {
            return 6;
        }
        byte[] rowCellDispTypes = this._$1[row - 1];
        if (col > rowCellDispTypes.length) {
            return 6;
        }
        return rowCellDispTypes[col - 1];
    }

    private void _$1() {
        ICloudClientIDE cloud;
        if (this._$4 == 1 && (cloud = this.getCloud()) != null) {
            this._$1 = cloud.getCellDispTypes(this._$2);
        }
    }

    public ParamList getContextParamList() {
        if (this._$4 != 1) {
            return super.getContextParamList();
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            return cloud.getContextParamList(this._$2);
        }
        return null;
    }

    public HashMap<String, Param[]> listSpaceParams() {
        if (this._$4 != 1) {
            return super.listSpaceParams();
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            return cloud.getSpaceParams(this._$2);
        }
        return null;
    }

    public ParamList getEnvParamList() {
        if (this._$4 != 1) {
            return super.getEnvParamList();
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            return cloud.getEnvParamList(this._$2);
        }
        return null;
    }

    public Object[] getAllParams() {
        if (this._$4 != 1) {
            return super.getAllParams();
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            return cloud.bindParamsGet(this._$2);
        }
        return null;
    }

    public Object calcExp(String expStr) {
        if (this._$4 != 1) {
            return super.calcExp(expStr);
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            Object val = cloud.calcExp(this._$2, expStr);
            return val;
        }
        return null;
    }

    protected void resetCellSet() {
        if (this._$4 != 1) {
            super.resetCellSet();
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            cloud.resetCellSet(this._$2);
            this._$1();
        }
    }

    protected void resetGlobalEnv() {
        if (this._$4 != 1) {
            super.resetGlobalEnv();
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            cloud.resetGlobal(this._$2);
            this._$1();
        }
    }

    protected void closeSpace() {
        if (this._$4 != 1) {
            super.closeSpace();
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud != null) {
            cloud.closeSpace(this._$2);
        }
    }

    protected void closeResource() {
        if (this._$4 != 1) {
            super.closeResource();
        }
    }

    public ICloudClientIDE getCloud() {
        String serverName = this.filePath.substring(0, this.filePath.indexOf(58));
        if (!StringUtils.isValidString((Object)serverName)) {
            return null;
        }
        ICloudClientIDE cloud = FileTreeEE.getCloud(serverName);
        return cloud;
    }

    public boolean createDebugger() throws Exception {
        int index;
        if (this._$4 != 1) {
            return false;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud == null) {
            return false;
        }
        String serverFilePath = null;
        if (StringUtils.isValidString((Object)this.filePath) && (index = this.filePath.lastIndexOf(":")) > 0 && (serverFilePath = this.filePath.substring(index + 1)).startsWith("/")) {
            serverFilePath = serverFilePath.substring(1);
        }
        this._$2 = cloud.createDebugger(serverFilePath, this._$3);
        this._$1();
        return true;
    }

    protected void setContextParams(ParamList pl) {
        if (this._$4 != 1) {
            super.setContextParams(pl);
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud == null) {
            return;
        }
        cloud.setContextParams(this._$2, pl);
    }

    protected void expChanged(int row, int col, String exp) {
        if (this._$4 != 1) {
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud == null) {
            return;
        }
        cloud.setExp(this._$2, row, col, exp);
        this._$1();
    }

    protected void expChanged(Map<String, String> expMap) {
        if (this._$4 != 1) {
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud == null) {
            return;
        }
        cloud.setExps(this._$2, expMap);
        this._$1();
    }

    protected void stepInto(PgmNormalCell pnc) {
        if (this._$4 != 1) {
            super.stepInto(pnc);
            return;
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud == null) {
            return;
        }
        StepInfo stepInfo = cloud.stepInto(this._$2, pnc.getRow(), pnc.getCol());
        if (stepInfo == null) {
            return;
        }
        PgmCellSet subCellSet = stepInfo.cellSet;
        if (subCellSet == null) {
            return;
        }
        byte stepType = stepInfo.type;
        CellLocation funcLocation = stepInfo.funcLocation;
        CellLocation exeCellLocation = stepInfo.exeLocation;
        int endRow = stepInfo.endRow;
        String filePath = stepInfo.filePath;
        CellLocation parentLocation = new CellLocation(pnc.getRow(), pnc.getCol());
        this.openSubSheet(parentLocation, stepType, subCellSet, funcLocation, exeCellLocation, endRow, filePath);
    }

    protected Object calcReturnValue(PgmCellSet cellSet, PgmNormalCell cell, Context ctx) {
        if (this._$4 != 1) {
            return super.calcReturnValue(cellSet, cell, ctx);
        }
        ICloudClientIDE cloud = this.getCloud();
        if (cloud == null) {
            return null;
        }
        return cloud.calcReturnValue(this._$2, cell.getRow(), cell.getCol());
    }

    public List<NormalCell> insertCol(PgmCellSet cellSet, int col, int count) {
        ICloudClientIDE cloud;
        if (this._$4 == 1 && (cloud = this.getCloud()) != null) {
            try {
                cloud.insertCol(this._$2, col, count);
            }
            catch (Exception ex) {
                GM.showException((Component)GV.appFrame, (Object)ex);
                return null;
            }
        }
        return cellSet.insertCol(col, count);
    }

    public void addCol(PgmCellSet cellSet, int count) {
        ICloudClientIDE cloud;
        if (this._$4 == 1 && (cloud = this.getCloud()) != null) {
            try {
                cloud.addCol(this._$2, count);
            }
            catch (Exception ex) {
                GM.showException((Component)GV.appFrame, (Object)ex);
                return;
            }
        }
        cellSet.addCol(count);
    }

    public List<NormalCell> removeCol(PgmCellSet cellSet, int col, int count) {
        ICloudClientIDE cloud;
        if (this._$4 == 1 && (cloud = this.getCloud()) != null) {
            try {
                cloud.removeCol(this._$2, col, count);
            }
            catch (Exception ex) {
                GM.showException((Component)GV.appFrame, (Object)ex);
                return null;
            }
        }
        return cellSet.removeCol(col, count);
    }

    public List<NormalCell> insertRow(PgmCellSet cellSet, int row, int count) {
        ICloudClientIDE cloud;
        if (this._$4 == 1 && (cloud = this.getCloud()) != null) {
            try {
                cloud.insertRow(this._$2, row, count);
            }
            catch (Exception ex) {
                GM.showException((Component)GV.appFrame, (Object)ex);
                return null;
            }
        }
        return cellSet.insertRow(row, count);
    }

    public void addRow(PgmCellSet cellSet, int count) {
        ICloudClientIDE cloud;
        if (this._$4 == 1 && (cloud = this.getCloud()) != null) {
            try {
                cloud.addRow(this._$2, count);
            }
            catch (Exception ex) {
                GM.showException((Component)GV.appFrame, (Object)ex);
                return;
            }
        }
        cellSet.addRow(count);
    }

    public List<NormalCell> removeRow(PgmCellSet cellSet, int row, int count) {
        ICloudClientIDE cloud;
        if (this._$4 == 1 && (cloud = this.getCloud()) != null) {
            try {
                cloud.removeRow(this._$2, row, count);
            }
            catch (Exception ex) {
                GM.showException((Component)GV.appFrame, (Object)ex);
                return null;
            }
        }
        return cellSet.removeRow(row, count);
    }

    public List<NormalCell> moveRect(CellRect fromRect, CellRect toRect) {
        ICloudClientIDE cloud;
        if (this._$4 == 1 && (cloud = this.getCloud()) != null) {
            try {
                cloud.cut(this._$2, fromRect.getArea(), toRect.getArea());
            }
            catch (Exception ex) {
                GM.showException((Component)GV.appFrame, (Object)ex);
                return null;
            }
        }
        return null;
    }

    public boolean close(boolean isQuit) {
        boolean canClose;
        block3: {
            ICloudClientIDE cloud;
            canClose = super.close(isQuit);
            if (canClose && this._$4 == 1 && (cloud = this.getCloud()) != null) {
                try {
                    cloud.close(this._$2);
                }
                catch (Exception ex) {
                    if (isQuit || !canClose) break block3;
                    Logger.error((Object)ex);
                }
            }
        }
        return canClose;
    }
}

