/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dql;

import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GV;
import com.scudata.ide.spl.dql.ConfigFile;
import com.scudata.ide.spl.dql.DQL;
import com.scudata.ide.spl.dql.GMDql;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class ConfigOptions {
    private static ConfigFile _$2 = null;
    static HashMap<String, Object> _$1 = new HashMap();
    public static Boolean bIdeConsole = Boolean.TRUE;
    public static Boolean bAutoOpen = Boolean.FALSE;
    public static Boolean bAutoBackup = Boolean.TRUE;
    public static Boolean bLogException = Boolean.FALSE;
    public static Boolean bWindowSize = Boolean.FALSE;
    public static Byte iLookAndFeel = new Byte(3);
    public static String sLogFileName = GMDql.getAbsolutePath((String)"log/dql.log");
    public static Boolean bViewWinList = Boolean.TRUE;
    public static Boolean bViewError = Boolean.FALSE;
    public static Boolean bAutoViewError = Boolean.TRUE;
    public static Boolean bCheckValid = Boolean.TRUE;
    public static Boolean bTrimName = Boolean.FALSE;
    public static Boolean bFileTreeDemo = Boolean.FALSE;
    public static Boolean bNoticeExpiration = Boolean.TRUE;
    public static Integer iConsoleLocation = new Integer(-1);
    public static String sFileTreeExpand = "";
    public static Integer iLeftTab = new Integer(0);
    public static String sLogLevel = Logger.INFO;
    public static Byte iLocale = null;
    public static Boolean bSNPrompt = Boolean.TRUE;

    private static void _$1() {
        _$1.put("bAutoBackup", bAutoBackup);
        _$1.put("bAutoOpen", bAutoOpen);
        _$1.put("bCheckValid", bCheckValid);
        _$1.put("bIdeConsole", bIdeConsole);
        _$1.put("bLogException", bLogException);
        _$1.put("bTrimName", bTrimName);
        _$1.put("bViewError", bViewError);
        _$1.put("bAutoViewError", bAutoViewError);
        _$1.put("bViewWinList", bViewWinList);
        _$1.put("bWindowSize", bWindowSize);
        _$1.put("bTextEditorLineWrap", com.scudata.ide.common.ConfigOptions.bTextEditorLineWrap);
        _$1.put("iConsoleLocation", iConsoleLocation);
        _$1.put("iLeftTab", iLeftTab);
        _$1.put("iLookAndFeel", iLookAndFeel);
        _$1.put("sFileTreeExpand", sFileTreeExpand);
        _$1.put("sLogFileName", sLogFileName);
        _$1.put("sLogLevel", sLogLevel);
        _$1.put("bFileTreeDemo", bFileTreeDemo);
        _$1.put("iLocale", iLocale);
        _$1.put("bNoticeExpiration", bNoticeExpiration);
        _$1.put("bSNPrompt", bSNPrompt);
    }

    public static boolean save() throws Throwable {
        return ConfigOptions.save(true);
    }

    public static boolean save(boolean setLogLevel) throws Throwable {
        ConfigOptions._$1();
        _$2 = ConfigFile.getConfigFile();
        _$2.setConfigNode(ConfigFile.NODE_OPTIONS);
        for (String option : _$1.keySet()) {
            Object optionVar = _$1.get(option);
            _$2.setAttrValue(option, optionVar);
        }
        _$2.save();
        return ConfigOptions._$1(setLogLevel);
    }

    public static void load() throws Throwable {
        ConfigOptions.load(true);
    }

    public static void load(boolean setLogLevel) throws Throwable {
        _$2 = ConfigFile.getConfigFile();
        _$2.setConfigNode(ConfigFile.NODE_OPTIONS);
        Iterator<String> it = _$1.keySet().iterator();
        while (it.hasNext()) {
            ConfigOptions._$1(it.next());
        }
        ConfigOptions._$1(setLogLevel);
    }

    public static Vector dispLevels() {
        String[] levelNames = Logger.listLevelNames();
        Vector<String> levels = new Vector<String>();
        if (levelNames != null) {
            for (String levelName : levelNames) {
                levels.add(levelName);
            }
        }
        return levels;
    }

    private static boolean _$1(boolean setLogLevel) {
        if (bIdeConsole.booleanValue()) {
            DQL.holdConsole();
        }
        if (GV.config != null) {
            GV.config.setLogLevel(sLogLevel);
        }
        try {
            Logger.setPropertyConfig((Properties)ConfigOptions.getLoggerProperty());
        }
        catch (Exception e) {
            GMDql.showException((Component)GV.appFrame, (Object)e);
        }
        return true;
    }

    public static Properties getLoggerProperty() {
        Properties props = new Properties();
        String logName = "IDE_CONSOLE";
        String logPath = null;
        if (StringUtils.isValidString((Object)sLogFileName)) {
            logName = logName + ",IDE_LOGFILE";
            logPath = GMDql.getAbsolutePath((String)sLogFileName);
        }
        props.put("Logger", logName);
        String sLogLevel = GV.config.getLogLevel();
        if (logPath != null) {
            props.put("IDE_LOGFILE", logPath);
            props.put("IDE_LOGFILE.Level", sLogLevel);
            props.put("IDE_LOGFILE.Encoding", "UTF-8");
        }
        props.put("IDE_CONSOLE", "Console");
        props.put("IDE_CONSOLE.Level", sLogLevel);
        props.put("IDE_CONSOLE.Encoding", "UTF-8");
        return props;
    }

    public static Locale getLocaleByName(String dispName) {
        if (dispName == null) {
            return null;
        }
        Locale[] locales = Locale.getAvailableLocales();
        if (locales != null) {
            for (int i = 0; i < locales.length; ++i) {
                if (!dispName.equals(locales[i].getDisplayName())) continue;
                return locales[i];
            }
        }
        return null;
    }

    private static void _$1(String option) {
        String val = _$2.getAttrValue(option);
        if (!StringUtils.isValidString((Object)val)) {
            return;
        }
        String type = option.substring(0, 1);
        if (type.equalsIgnoreCase("i")) {
            Integer ii = Integer.valueOf(val);
            if (option.equalsIgnoreCase("iLookAndFeel")) {
                iLookAndFeel = new Byte(ii.byteValue());
            } else if (option.equalsIgnoreCase("iConsoleLocation")) {
                iConsoleLocation = ii;
            } else if (option.equalsIgnoreCase("iLeftTab")) {
                iLeftTab = ii;
            } else if (option.equalsIgnoreCase("iLocale")) {
                iLocale = new Byte(ii.byteValue());
            }
        } else if (type.equalsIgnoreCase("b")) {
            Boolean ii = Boolean.valueOf(val);
            if (option.equalsIgnoreCase("bAutoBackup")) {
                bAutoBackup = ii;
            } else if (option.equalsIgnoreCase("bAutoOpen")) {
                bAutoOpen = ii;
            } else if (option.equalsIgnoreCase("bCheckValid")) {
                bCheckValid = ii;
            } else if (option.equalsIgnoreCase("bIdeConsole")) {
                bIdeConsole = ii;
            } else if (option.equalsIgnoreCase("bLogException")) {
                bLogException = ii;
            } else if (option.equalsIgnoreCase("bTrimName")) {
                bTrimName = ii;
            } else if (option.equalsIgnoreCase("bViewError")) {
                bViewError = ii;
            } else if (option.equalsIgnoreCase("bAutoViewError")) {
                bAutoViewError = ii;
            } else if (option.equalsIgnoreCase("bViewWinList")) {
                bViewWinList = ii;
            } else if (option.equalsIgnoreCase("bWindowSize")) {
                bWindowSize = ii;
            } else if (option.equalsIgnoreCase("bTextEditorLineWrap")) {
                com.scudata.ide.common.ConfigOptions.bTextEditorLineWrap = ii;
            } else if (option.equalsIgnoreCase("bFileTreeDemo")) {
                bFileTreeDemo = ii;
            } else if (option.equalsIgnoreCase("bNoticeExpiration")) {
                bNoticeExpiration = ii;
            } else if (option.equalsIgnoreCase("bSNPrompt")) {
                bSNPrompt = ii;
            }
        } else if (StringUtils.isValidString((Object)val)) {
            if (option.equalsIgnoreCase("sFileTreeExpand")) {
                sFileTreeExpand = val;
            } else if (option.equalsIgnoreCase("sLogFileName")) {
                sLogFileName = val;
            } else if (option.equalsIgnoreCase("sLogLevel")) {
                sLogLevel = val;
            }
        }
    }

    static {
        ConfigOptions._$1();
    }
}

