/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dql;

import com.ibm.icu.text.Collator;
import com.scudata.app.common.Section;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.query.metadata.DataMaintenanceTable;
import com.scudata.dm.query.metadata.Dictionary;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Visibility;
import com.scudata.dm.query.utils.IOUtil;
import com.scudata.ide.common.AppFrame;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.DataSourceListModel;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAppFrame;
import com.scudata.ide.common.TcpServer;
import com.scudata.ide.common.control.PanelConsole;
import com.scudata.ide.spl.EsprocEE;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSplEE;
import com.scudata.ide.spl.ICheckHandler;
import com.scudata.ide.spl.SPL;
import com.scudata.ide.spl.dialog.DialogSplash;
import com.scudata.ide.spl.dql.ConfigFile;
import com.scudata.ide.spl.dql.ConfigOptions;
import com.scudata.ide.spl.dql.GCDql;
import com.scudata.ide.spl.dql.GMDql;
import com.scudata.ide.spl.dql.GVDql;
import com.scudata.ide.spl.dql.ICloudClientDql;
import com.scudata.ide.spl.dql.IIlIIIIllIIIlIll;
import com.scudata.ide.spl.dql.ISheetDql;
import com.scudata.ide.spl.dql.IlIlllIIlIlIlIlI;
import com.scudata.ide.spl.dql.IllIlllIlllIllll;
import com.scudata.ide.spl.dql.LookAndFeelManager;
import com.scudata.ide.spl.dql.MenuBase;
import com.scudata.ide.spl.dql.MenuFactory;
import com.scudata.ide.spl.dql.SheetDataMaintenance;
import com.scudata.ide.spl.dql.SheetDictionary;
import com.scudata.ide.spl.dql.SheetMetaData;
import com.scudata.ide.spl.dql.SheetVisibility;
import com.scudata.ide.spl.dql.ToolBarBase;
import com.scudata.ide.spl.dql.ToolBarFactory;
import com.scudata.ide.spl.dql.base.DqlKeyListener;
import com.scudata.ide.spl.dql.base.FileTree;
import com.scudata.ide.spl.dql.base.ToolBarWindow;
import com.scudata.ide.spl.dql.base.ViewConfig;
import com.scudata.ide.spl.dql.lIlIIIIllIIIlIll;
import com.scudata.ide.spl.dql.resources.IdeDqlMessage;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DQL
extends AppFrame {
    private static final long serialVersionUID = 1L;
    private JPanel _$8 = new JPanel();
    public JSplitPane jSPMain;
    private static final int _$7 = 0;
    private JTabbedPane _$6;
    private PanelConsole _$5;
    public FileTree fileTree;
    private static int _$4 = 50;
    private int _$3;
    public static final String DQL_PORT_KEY = "dql_port";
    public static DialogSplash splashWindow = null;
    private static String _$2 = null;
    public static String spaceId = null;
    private final String _$1 = IdeSplMessage.get().getMessage("dfx.tabconsole");

    public JInternalFrame openSheetFile(String fileName) {
        try {
            JInternalFrame o = this.getSheet(fileName);
            if (o != null) {
                this.showSheet(o);
                GVDql.toolWin.refresh();
                return null;
            }
            ISheetDql sheet = null;
            boolean isNew = false;
            if (fileName.endsWith(".glmd")) {
                LogicMetaData lmd;
                if (fileName.equals(".glmd")) {
                    lmd = GMDql.getDefaultLogicMetaData();
                    fileName = GVDql.getNewName(GCDql.NEW_DQL_MD);
                    isNew = true;
                } else {
                    File f = new File(fileName);
                    if (!f.exists()) {
                        String msg = IdeDqlMessage.get().getMessage("public.filenotexist", (Object)f.getName());
                        throw new Exception(msg);
                    }
                    GMDql.gmldfile = fileName;
                    lmd = IOUtil.readLogicMetaData(fileName);
                }
                sheet = new SheetMetaData(fileName, lmd);
            } else if (fileName.endsWith(".gdct")) {
                Dictionary dct;
                if (fileName.equals(".gdct")) {
                    dct = new Dictionary();
                    fileName = GVDql.getNewName(GCDql.NEW_DICTIONARY);
                    isNew = true;
                } else {
                    File f = new File(fileName);
                    if (!f.exists()) {
                        String msg = IdeDqlMessage.get().getMessage("public.filenotexist", (Object)f.getName());
                        throw new Exception(msg);
                    }
                    dct = IOUtil.readDictionary(fileName);
                }
                sheet = new SheetDictionary(fileName, dct);
            } else if (fileName.endsWith(".gvsb")) {
                Visibility vsb;
                if (!GVDql.isVisiblityEnabled) {
                    return null;
                }
                if (fileName.equals(".gvsb")) {
                    vsb = new Visibility();
                    fileName = GVDql.getNewName(GCDql.NEW_VISIBILITY);
                    isNew = true;
                } else {
                    File f = new File(fileName);
                    if (!f.exists()) {
                        String msg = IdeDqlMessage.get().getMessage("public.filenotexist", (Object)f.getName());
                        throw new Exception(msg);
                    }
                    vsb = IOUtil.readVisibility(fileName);
                }
                sheet = new SheetVisibility(fileName, vsb);
            } else if (fileName.endsWith(".json")) {
                DataMaintenanceTable table;
                if (!GVDql.isDataMaintenanceEnabled) {
                    return null;
                }
                if (fileName.equals(".json")) {
                    table = new DataMaintenanceTable();
                    fileName = GVDql.getNewName(GCDql.NEW_DATA_M);
                    isNew = true;
                } else {
                    File f = new File(fileName);
                    if (!f.exists()) {
                        String msg = IdeDqlMessage.get().getMessage("public.filenotexist", (Object)f.getName());
                        throw new Exception(msg);
                    }
                    table = IOUtil.readDataMaintenanceTable(fileName);
                }
                sheet = new SheetDataMaintenance(fileName, table);
            }
            if (sheet == null) {
                return null;
            }
            return this.openSheet(sheet, !isNew);
        }
        catch (Exception x) {
            GMDql.showException((Component)GV.appFrame, (Object)x);
            return null;
        }
    }

    public JInternalFrame openSheetFile(InputStream in, String fileName, byte sheetType) {
        try {
            JInternalFrame o = this.getSheet(fileName);
            if (o != null) {
                this.showSheet(o);
                GVDql.toolWin.refresh();
                return null;
            }
            ISheetDql sheet = null;
            if (fileName.endsWith(".glmd")) {
                sheet = new SheetMetaData(fileName, in);
                sheet.setType(sheetType);
            } else if (fileName.endsWith(".gdct")) {
                sheet = new SheetDictionary(fileName, in);
                ((SheetDictionary)sheet).setType(sheetType);
            } else if (fileName.endsWith(".gvsb")) {
                if (!GVDql.isVisiblityEnabled) {
                    return null;
                }
                sheet = new SheetVisibility(fileName, in);
                ((SheetVisibility)sheet).setType(sheetType);
            } else if (fileName.endsWith(".json")) {
                if (!GVDql.isDataMaintenanceEnabled) {
                    return null;
                }
                sheet = new SheetDataMaintenance(fileName, in);
                ((SheetDataMaintenance)sheet).setType(sheetType);
            }
            if (sheet == null) {
                return null;
            }
            return this.openSheet(sheet, sheetType == 0);
        }
        catch (Exception x) {
            GMDql.showException((Component)GV.appFrame, (Object)x);
            return null;
        }
    }

    public JInternalFrame openSheet(JInternalFrame sheet, boolean refreshRecentFile) throws Exception {
        if (sheet == null) {
            return null;
        }
        Dimension d = this.desk.getSize();
        boolean loadSheet = GMDql.loadWindowSize((Component)sheet);
        if (!loadSheet) {
            sheet.setBounds(0, 0, d.width, d.height);
        }
        boolean setMax = false;
        if (GVDql.activeSheet != null && GVDql.activeSheet.isMaximum() && !GVDql.activeSheet.isIcon()) {
            GVDql.activeSheet.resumeSheet();
            if (loadSheet) {
                ((ISheetDql)sheet).setForceMax();
            }
            setMax = true;
        }
        sheet.show();
        this.desk.add(sheet);
        if (setMax || !GMDql.loadWindowSize((Component)sheet)) {
            sheet.setMaximum(true);
        }
        sheet.setSelected(true);
        if (refreshRecentFile) {
            GVDql.appMenu.refreshRecentFile(sheet.getTitle());
        }
        if (!GVDql.toolWin.isVisible() && ConfigOptions.bViewWinList.booleanValue()) {
            GVDql.toolWin.setVisible(true);
        }
        GVDql.toolWin.refresh();
        ((ISheetDql)sheet).resetSheetStyle();
        return sheet;
    }

    public DQL() {
        try {
            this.setTitle(this.getFixTitle());
            GVDql.appFrame = this;
            GV.dsModel = new DataSourceListModel();
            GVDql.toolWin = new ToolBarWindow();
            GVDql.toolWin.setVisible(false);
            this._$8.setLayout(new GridLayout());
            this.switchMenu(new MenuBase(), (JToolBar)((Object)new ToolBarBase()));
            this.getContentPane().add((Component)this._$8, "North");
            this.desk = new JDesktopPane();
            this.desk.setDragMode(0);
            this.desk.revalidate();
            GVDql.fileTree = this.fileTree = new FileTree();
            JScrollPane jSPFileTree = new JScrollPane(this.fileTree.getComponent());
            this.fileTree.setMinimumSize(new Dimension(0, 0));
            jSPFileTree.setMinimumSize(new Dimension(0, 0));
            this.jSPMain = new JSplitPane(1);
            this.jSPMain.setOneTouchExpandable(true);
            this.jSPMain.setDividerSize(7);
            this._$6 = new JTabbedPane();
            this._$6.add(IdeDqlMessage.get().getMessage("dql.src"), jSPFileTree);
            this._$6.setMinimumSize(new Dimension(0, 0));
            this.jSPMain.setLeftComponent(this._$6);
            this.jSPMain.setRightComponent(this.desk);
            JPanel panelCenter = new JPanel(new BorderLayout());
            panelCenter.add((Component)GVDql.toolWin, "North");
            panelCenter.add((Component)this.jSPMain, "Center");
            boolean isInit = false;
            if (ConfigOptions.iConsoleLocation != null && ConfigOptions.iConsoleLocation > -1) {
                this._$3 = ConfigOptions.iConsoleLocation;
                if (this._$3 <= _$4) {
                    int POS_MAIN = new Double(0.22 * Toolkit.getDefaultToolkit().getScreenSize().getWidth()).intValue();
                    this.jSPMain.setDividerLocation(POS_MAIN);
                } else {
                    this.jSPMain.setDividerLocation(0);
                }
                this.jSPMain.setDividerLocation(this._$3);
            } else {
                this.jSPMain.setDividerLocation(0);
                isInit = true;
            }
            this.fileTree.changeMainPath(GMDql.getAbsolutePath((String)GV.config.getMainPath()));
            this.getContentPane().add((Component)panelCenter, "Center");
            ImageIcon ii = GMDql.getLogoImage(true);
            if (ii != null) {
                this.setIconImage(ii.getImage());
            }
            try {
                GMDql.loadViewConfigs();
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (GVDql.viewConfigs == null) {
                GVDql.viewConfigs = new ViewConfig[5];
            }
            GVDql.context = new Context();
            if (ConfigOptions.bIdeConsole.booleanValue()) {
                this.consoleVisible(true);
                if (ConfigOptions.iLeftTab == 0) {
                    this._$6.setSelectedIndex(0);
                }
            }
            this.pack();
            this._$1();
            GVDql.allFrames.add(this);
            Toolkit.getDefaultToolkit().addAWTEventListener(new DqlKeyListener(), 8L);
            int width = this.jSPMain.getWidth();
            width = isInit || this._$3 == 0 ? Math.round((float)width * 0.4f) : this._$3;
            this.jSPMain.setLastDividerLocation(width);
            int port = DQL.getDqlPort();
            if (port > -1) {
                new TcpServer(port, (IAppFrame)this, _$2).start();
            }
        }
        catch (Throwable e) {
            GMDql.showException((Component)GV.appFrame, (Object)e, (boolean)true, (ImageIcon)GMDql.getLogoImage(true));
            this.exit();
        }
    }

    public static int getDqlPort() {
        String port = GMSpl.getConfigValue((String)DQL_PORT_KEY);
        int iport = -1;
        if (StringUtils.isValidString((Object)port)) {
            try {
                iport = Integer.parseInt(port);
            }
            catch (Exception e1) {
                Logger.debug((Object)("Invalid dql_port: " + port));
            }
        }
        return iport;
    }

    public void startAutoRecent() {
        try {
            if (StringUtils.isValidString((Object)_$2)) {
                this.openSheetFile(_$2);
            } else if (StringUtils.isValidString((Object)GVDql.autoOpenFileName)) {
                this.openSheetFile(GVDql.autoOpenFileName);
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            GVDql.allFrames.add(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void switchMenu(MenuFactory menu, JToolBar tool) {
        GVDql.appMenu = menu;
        this.setJMenuBar(menu);
        GVDql.appTool = (ToolBarFactory)((Object)tool);
        this._$8.removeAll();
        this._$8.add(tool);
        this.validate();
        this.repaint();
    }

    public String getNewName(String prefix) {
        JInternalFrame[] frames = this.desk.getAllFrames();
        if (frames == null) {
            return prefix + 1;
        }
        Section titles = new Section();
        for (int i = 0; i < frames.length; ++i) {
            String title = frames[i].getTitle();
            File f = new File(title);
            int index = (title = f.getName()).lastIndexOf(".");
            if (index > -1) {
                title = title.substring(0, index);
            }
            titles.addSection(title);
        }
        int index = 1;
        while (titles.containsSection(prefix + index)) {
            ++index;
        }
        return prefix + index;
    }

    public boolean exit() {
        try {
            GMDql.saveViewConfigs();
        }
        catch (Throwable ex) {
            GMDql.writeLog((Object)ex);
        }
        if (this.fileTree != null && this.fileTree instanceof FileTree) {
            this.fileTree.saveExpandState(this.jSPMain.getDividerLocation());
        }
        ConfigOptions.iLeftTab = this._$6.getSelectedIndex();
        try {
            ConfigOptions.save(false);
        }
        catch (Throwable t) {
            // empty catch block
        }
        GVDql.allFrames.remove((Object)this);
        if (spaceId != null) {
            try {
                JobSpaceManager.closeSpace((String)spaceId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closeCloudServer();
        System.exit(0);
        return false;
    }

    protected boolean closeCloudServer() {
        GVDql.fileTree.setClosing();
        List<ICloudClientDql> cloudList = GVDql.fileTree.getCloudList();
        if (cloudList != null && cloudList.size() > 0) {
            for (int i = cloudList.size() - 1; i >= 0; --i) {
                try {
                    ICloudClientDql server = cloudList.get(i);
                    server.setShowMessage(false);
                    GVDql.fileTree.deleteCloud(server);
                    continue;
                }
                catch (Exception ex) {
                    GMDql.writeLog((Object)ex);
                }
            }
        }
        return true;
    }

    public boolean closeSheet(String sheetTitle) throws Exception {
        return this.closeSheet(this.getSheet(sheetTitle));
    }

    public boolean closeSheet(Object sheet) {
        if (sheet == null || !(sheet instanceof ISheetDql)) {
            return false;
        }
        ISheetDql dataSheet = (ISheetDql)sheet;
        String sheetTitle = dataSheet.getSheetTitle();
        if (!dataSheet.close()) {
            return false;
        }
        GVDql.appMenu.removeLiveMenu(sheetTitle);
        try {
            dataSheet.setSelected(false);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        this.desk.getDesktopManager().closeFrame(dataSheet);
        JInternalFrame[] frames = this.desk.getAllFrames();
        if (frames.length == 0) {
            this.switchMenu(new MenuBase(), (JToolBar)((Object)new ToolBarBase()));
            GVDql.activeSheet = null;
            GVDql.toolWin.setVisible(false);
        } else {
            try {
                if (frames.length > 0) {
                    JInternalFrame as = GVDql.appFrame.getActiveSheet();
                    if (as == null) {
                        as = frames[0];
                    }
                    super.showSheet(as, false);
                }
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        GVDql.getDQL().resetTitle();
        GVDql.toolWin.refresh();
        return true;
    }

    public JInternalFrame getActiveSheet() {
        return this.desk.getSelectedFrame();
    }

    private void _$1() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setEnabled(true);
        this.addComponentListener(new IlIlllIIlIlIlIlI(this));
        this.addWindowListener(new IllIlllIlllIllll(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        String splashFile;
        block20: {
            splashFile = null;
            try {
                String sDataMaintenanceEnabled;
                GMDql.setOptionLocale();
                Collator.getInstance((Locale)Locale.getDefault());
                GV.config = ConfigUtilIde.loadConfig((boolean)true);
                ConfigOptions.load(false);
                if (GV.config == null) {
                    GV.config = new RaqsoftConfig();
                } else {
                    Env.setMainPath((String)GV.config.getMainPath());
                }
                ConfigFile sysConfig = ConfigFile.getSystemConfigFile();
                if (sysConfig == null) break block20;
                splashFile = sysConfig.getAttrValue("splashFile");
                GVDql.logo = sysConfig.getAttrValue("logo");
                GVDql.defaultLmd = sysConfig.getAttrValue("defaultLmd");
                String sVisiblityEnabled = sysConfig.getAttrValue("isVisiblityEnabled");
                if (StringUtils.isValidString((Object)sVisiblityEnabled)) {
                    try {
                        GVDql.isVisiblityEnabled = Boolean.parseBoolean(sVisiblityEnabled);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (StringUtils.isValidString((Object)(sDataMaintenanceEnabled = sysConfig.getAttrValue("isDataMaintenanceEnabled")))) {
                    try {
                        GVDql.isDataMaintenanceEnabled = Boolean.parseBoolean(sDataMaintenanceEnabled);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                GVDql.fileExtNames = new Section(GMDql.getFileExts());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            File f = null;
            if (StringUtils.isValidString(splashFile) && !(f = new File(splashFile = GMDql.getAbsolutePath(splashFile))).exists()) {
                f = null;
            }
            if (f == null) {
                splashFile = "/com/scudata/ide/spl/dql/images/dql" + GMDql.getLanguageSuffix() + ".png";
            }
            ImageIcon ii = GMDql.getLogoImage(true);
            try {
                com.scudata.ide.common.ConfigOptions.bNoticeExpiration = ConfigOptions.bNoticeExpiration;
                com.scudata.ide.common.ConfigOptions.bSNPrompt = ConfigOptions.bSNPrompt;
                splashWindow = SPL.check((String)splashFile, (Image)(ii == null ? null : ii.getImage()), (boolean)true, (String)IdeDqlMessage.get().getMessage("appframe.productname"), (String)"dql", (int[])new int[]{7, 6}, (String)DQL_PORT_KEY, (ICheckHandler)new IIlIIIIllIIIlIll());
            }
            finally {
                ConfigOptions.bNoticeExpiration = com.scudata.ide.common.ConfigOptions.bNoticeExpiration;
                ConfigOptions.bSNPrompt = com.scudata.ide.common.ConfigOptions.bSNPrompt;
            }
        }
        catch (Exception e) {
            GMDql.showException((Component)GV.appFrame, (Object)e, (boolean)false, (ImageIcon)GMDql.getLogoImage(true));
            System.exit(0);
        }
        try {
            DQL rf = DQL.main0(args);
            rf.setVisible(true);
            rf.startAutoRecent();
            if (splashWindow != null) {
                splashWindow.dispose();
            }
        }
        catch (Exception e) {
            GMDql.showException((Component)GV.appFrame, (Object)e, (boolean)false, (ImageIcon)GMDql.getLogoImage(true));
            System.exit(0);
        }
    }

    public static DQL main0(String[] args) throws Throwable {
        ConfigFile sysConfig;
        DQL.resetInstallDirectories();
        String arg = "";
        if (args.length == 1 && (arg = args[0].trim()).trim().indexOf(" ") > 0 && arg.charAt(1) != ':') {
            Section st = new Section(arg, ' ');
            args = st.toStringArray();
        }
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                arg = args[i].toLowerCase();
                if (arg.equalsIgnoreCase("com.scudata.ide.spl.dql.DQL") || arg.startsWith("-") || (_$2 = args[i]) == null) continue;
                _$2 = _$2.trim();
            }
        }
        ConfigFile.getConfigFile().setConfigNode(ConfigFile.NODE_OPTIONS);
        GVDql.lastDirectory = ConfigFile.getConfigFile().getAttrValue("fileDirectory");
        UIManager.setLookAndFeel(LookAndFeelManager.getLookAndFeelName());
        String sTmp = System.getProperty("java.version");
        String sPath = System.getProperty("java.home");
        if (sTmp.compareTo("1.6.1") < 0) {
            MessageManager mm = IdeDqlMessage.get();
            String t1 = mm.getMessage("dql.jdkversion", (Object)GVDql.appFrame.getProductName(), (Object)sPath, (Object)sTmp);
            String t2 = mm.getMessage("public.prompt");
            JOptionPane.showMessageDialog(null, t1, t2, 0);
            System.exit(0);
        }
        if ((sysConfig = ConfigFile.getSystemConfigFile()) != null) {
            try {
                String sCloudEnabled = sysConfig.getAttrValue("isAIOEnabled");
                if (sCloudEnabled != null) {
                    GVSplEE.isAIOEnabled = Boolean.parseBoolean(sCloudEnabled);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        EsprocEE.loadCustomFunctions();
        DQL frame = new DQL();
        frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        frame.setExtendedState(6);
        return frame;
    }

    public boolean closeAll() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        try {
            for (int i = 0; i < frames.length; ++i) {
                ISheetDql ids = (ISheetDql)frames[i];
                if (this.closeSheet(ids)) continue;
                return false;
            }
        }
        catch (Exception x) {
            GMDql.showException((Component)GV.appFrame, (Object)x);
            return false;
        }
        SwingUtilities.invokeLater(new lIlIIIIllIIIlIll(this));
        File f = new File(ConfigFile.FILE_PATH());
        if (f.exists()) {
            try {
                ConfigFile.getConfigFile().setConfigNode(ConfigFile.NODE_OPTIONS);
                ConfigFile.getConfigFile().setAttrValue("fileDirectory", GVDql.lastDirectory);
            }
            catch (Throwable x) {
                GMDql.showException((Component)GV.appFrame, (Object)x);
            }
        }
        return true;
    }

    protected void refreshToolBarWindow(JInternalFrame sheet) {
        GVDql.toolWin.refreshSheet(sheet);
    }

    public void switchWinList() {
        ConfigOptions.bViewWinList = new Boolean(ConfigOptions.bViewWinList == false);
        try {
            ConfigOptions.save(false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        GVDql.toolWin.setVisible(ConfigOptions.bViewWinList);
        if (GVDql.toolWin.isVisible()) {
            GVDql.toolWin.refresh();
        }
    }

    public void quit() {
        if (this.closeAll()) {
            this.exit();
        }
    }

    public void refreshOptions() {
        JInternalFrame[] sheets;
        this.fileTree.changeMainPath(com.scudata.ide.common.ConfigOptions.sMainPath);
        if (ConfigOptions.bIdeConsole.booleanValue()) {
            int index = this._$1(this._$1);
            DQL.holdConsole();
            this.consoleVisible(true);
            if (index < 0) {
                if (this._$3 > 0) {
                    this.jSPMain.setDividerLocation(this._$3);
                } else {
                    this.jSPMain.setDividerLocation(0.22);
                }
            }
        } else if (this.jSPMain.getLeftComponent() != null) {
            this._$3 = this.jSPMain.getDividerLocation();
            this.consoleVisible(false);
        }
        if (ConfigOptions.bAutoViewError.booleanValue() && (sheets = this.getAllSheets()) != null) {
            for (JInternalFrame sheet : sheets) {
                if (sheet == null || !(sheet instanceof SheetMetaData)) continue;
                ((SheetMetaData)sheet).autoViewError();
            }
        }
    }

    private int _$1(String tabName) {
        int count = this._$6.getTabCount();
        for (int i = 0; i < count; ++i) {
            if (!this._$6.getTitleAt(i).equals(tabName)) continue;
            return i;
        }
        return -1;
    }

    public void consoleVisible(boolean isVisible) {
        int index = this._$1(this._$1);
        if (isVisible) {
            if (index < 0) {
                if (this._$5 == null) {
                    this._$5 = new PanelConsole(GVDql.console, false);
                    this._$5.setMinimumSize(new Dimension(0, 0));
                } else {
                    GVDql.console.clear();
                }
                this._$6.addTab(this._$1, (Component)this._$5);
            }
            this.showConsoleTab();
        } else if (index > -1) {
            this._$6.remove(index);
        }
    }

    public void showConsoleTab() {
        int index = this._$1(this._$1);
        if (index > -1) {
            this._$6.setSelectedIndex(index);
        }
    }

    void _$2(WindowEvent e) {
        GVDql.appFrame = this;
        GVDql.appMenu.resetLiveMenu();
    }

    void _$1(WindowEvent e) {
        this.update(this.getGraphics());
        if (!this.closeAll()) {
            this.setDefaultCloseOperation(0);
            return;
        }
        this.setDefaultCloseOperation(2);
        this.quit();
    }

    public String getProductName() {
        String title = IdeDqlMessage.get().getMessage("appframe.productname");
        return title;
    }

    public void changeMenuAndToolBar(JMenuBar menu, JToolBar toolBar) {
    }
}

