/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dql.base;

import com.scudata.app.config.ConfigUtil;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.custom.FileInfo;
import com.scudata.ide.spl.base.FileTreeEE;
import com.scudata.ide.spl.dql.ConfigOptions;
import com.scudata.ide.spl.dql.DQL;
import com.scudata.ide.spl.dql.GCDql;
import com.scudata.ide.spl.dql.GMDql;
import com.scudata.ide.spl.dql.GVDql;
import com.scudata.ide.spl.dql.ICloudClientDql;
import com.scudata.ide.spl.dql.ISheetDql;
import com.scudata.ide.spl.dql.base.FileTreeNode;
import com.scudata.ide.spl.dql.base.FileTreeRender;
import com.scudata.ide.spl.dql.base.IllIlIIIlllIIlII;
import com.scudata.ide.spl.dql.base.IllIllIIIIIlIllI;
import com.scudata.ide.spl.dql.base.lIIlllIIIIIlIllI;
import com.scudata.ide.spl.dql.base.lllIllIIIIIlIllI;
import com.scudata.ide.spl.dql.resources.IdeDqlMessage;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTree
extends JTree {
    private static final long serialVersionUID = 1L;
    public static MessageManager mm = IdeSplMessage.get();
    protected FileTreeNode root = new FileTreeNode("", 0);
    protected FileTreeNode localRoot = new FileTreeNode("", 1);
    private static final String _$8 = mm.getMessage("filetree.nomainpath");
    private static final String _$7 = mm.getMessage("filetree.nodemodir");
    public static final String ROOT_TITLE = mm.getMessage("filetree.roottitle");
    public static final byte LOGIN = 20;
    public static final byte LOGOUT = 21;
    public static final byte FILE_SAVE = 22;
    public static final byte FILE_DOWNLOAD = 24;
    public static final byte DIR_DOWNLOAD = 25;
    public static final byte DIR_DOWNLOAD_WITHCHILD = 26;
    public static final byte FILE_UPLOAD = 27;
    public static final byte FILE_REMOVE = 28;
    public static final byte DIR_REMOVE = 29;
    protected FileTreeNode cloudRoot = null;
    private static final String _$6 = mm.getMessage("filetree.cloudfileresource");
    private static final String _$5 = mm.getMessage("filetree.nocloudresource");
    private final String _$4 = "NOT_EXPAND";
    private boolean _$3 = true;
    public static final byte OPEN_FILE = 1;
    public static final byte OPEN_DIR = 2;
    public static final byte OPEN_FILE_DIR = 3;
    public static final byte REFRESH = 4;
    public static final byte SWITCH_PATH = 5;
    protected boolean isCheckNode = false;
    private boolean _$2 = false;
    private List<ICloudClientDql> _$1;
    public static String selectCloud;

    public FileTree() {
        this.root.setDir(true);
        this.root.setTitle(ROOT_TITLE);
        this.root.setExpanded(true);
        this.localRoot.setDir(true);
        if (ConfigOptions.bFileTreeDemo.booleanValue()) {
            this.localRoot.setTitle(_$7);
        } else {
            this.localRoot.setTitle(_$8);
        }
        this.root.add((MutableTreeNode)((Object)this.localRoot));
        this.setModel(new DefaultTreeModel((TreeNode)((Object)this.root)));
        this.setCellRenderer(new FileTreeRender());
        this.setBorder(BorderFactory.createBevelBorder(1));
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel();
        dtsm.setSelectionMode(1);
        this.setSelectionModel(dtsm);
        this.addMouseListener(new IllIlIIIlllIIlII(this));
        this.addTreeWillExpandListener(new lllIllIIIIIlIllI(this));
        this.nodeStructureChanged(this.root);
    }

    public void saveExpandState(int dl) {
        try {
            ConfigOptions.iConsoleLocation = new Integer(dl);
            if (!this.isExpanded(0)) {
                ConfigOptions.sFileTreeExpand = "NOT_EXPAND";
                ConfigOptions.save();
                return;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(this.localRoot.getName());
            Enumeration em = this.localRoot.depthFirstEnumeration();
            while (em.hasMoreElements()) {
                FileTreeNode node = (FileTreeNode)((Object)em.nextElement());
                if (!node.isExpanded()) continue;
                buf.append(",");
                buf.append(node.getFullPath());
            }
            ConfigOptions.sFileTreeExpand = buf.toString();
            ConfigOptions.save();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void refreshLocal() {
        this.localRoot.removeAllChildren();
        String home = System.getProperty("start.home");
        String mainPath = null;
        if (ConfigOptions.bFileTreeDemo.booleanValue()) {
            File demoDir = new File(home, "demo");
            if (demoDir.exists() && (demoDir = GCDql.LANGUAGE == 0 || GCDql.LANGUAGE == 1 ? new File(demoDir, "zh") : new File(demoDir, "en")).exists()) {
                mainPath = demoDir.getAbsolutePath();
            }
            if (mainPath == null) {
                Logger.info((Object)mm.getMessage("filetree.nodemodir"));
            }
        } else {
            mainPath = ConfigUtil.getPath((String)home, (String)GV.config.getMainPath());
        }
        if (StringUtils.isValidString((Object)mainPath)) {
            if (!mainPath.equals(this.localRoot.getUserObject())) {
                this.localRoot.setDir(true);
                this.localRoot.setUserObject(mainPath);
                this.localRoot.setTitle(null);
            }
        } else if (StringUtils.isValidString((Object)this.localRoot.getUserObject())) {
            this.localRoot.setDir(true);
            this.localRoot.setUserObject("");
            if (ConfigOptions.bFileTreeDemo.booleanValue()) {
                this.localRoot.setTitle(_$7);
            } else {
                this.localRoot.setTitle(_$8);
            }
            this.nodeStructureChanged(this.localRoot);
            return;
        }
        this.localRoot.setExpanded(true);
        this.loadSubNode(this.localRoot);
        this.nodeStructureChanged(this.localRoot);
        if (this._$3) {
            this._$3 = false;
            try {
                String sExpand = ConfigOptions.sFileTreeExpand;
                if (!StringUtils.isValidString((Object)sExpand)) {
                    this.collapsePath(new TreePath(this.localRoot.getPath()));
                    this.loadSubNode(this.localRoot);
                    this.nodeStructureChanged(this.localRoot);
                    return;
                }
                if ("NOT_EXPAND".equals(sExpand)) {
                    this.collapsePath(new TreePath(this.localRoot.getPath()));
                    this.localRoot.setExpanded(false);
                    return;
                }
                String[] expands = sExpand.split(",");
                if (expands != null && expands.length > 0) {
                    List<String> expandList = Arrays.asList(expands);
                    int count = this.localRoot.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        this._$1((FileTreeNode)((Object)this.localRoot.getChildAt(i)), expandList);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void treeNodeWillExpand(FileTreeNode node) {
        this.nodeSelected(node);
        if (node != null && !node.isLoaded()) {
            if (node.getType() == 1) {
                this.loadSubNode(node);
            } else if (node.getType() == 2) {
                this.loadCloudFileTree(node, true);
            } else if (node.getType() == 0) {
                this.refreshLocal();
                this.refreshCloud();
            }
            node.setExpanded(true);
            this.nodeStructureChanged(node);
        }
    }

    private void _$1(FileTreeNode pNode, List<String> expandList) {
        if (expandList.contains(pNode.getFullPath())) {
            this.loadSubNode(pNode);
            int count = pNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                this._$1((FileTreeNode)((Object)pNode.getChildAt(i)), expandList);
            }
            pNode.setExpanded(true);
            this.nodeStructureChanged(pNode);
            this.expandPath(new TreePath(pNode.getPath()));
        }
    }

    protected void loadSubNode(FileTreeNode pNode) {
        try {
            String pDir = (String)pNode.getUserObject();
            File dir = new File(pDir);
            if (!dir.isDirectory() || !dir.exists()) {
                return;
            }
            pNode.removeAllChildren();
            File[] files = dir.listFiles();
            files = GM.sortFiles((File[])files);
            if (files == null || files.length == 0) {
                return;
            }
            block2: for (File f : files) {
                String fileName = f.getName();
                if (!StringUtils.isValidString((Object)fileName)) continue;
                FileTreeNode node = new FileTreeNode(f.getAbsolutePath(), 1);
                node.setTitle(fileName);
                boolean isDir = f.isDirectory();
                if (!isDir) continue;
                node.setDir(isDir);
                pNode.add((MutableTreeNode)((Object)node));
                File[] subFiles = f.listFiles();
                subFiles = GM.sortFiles((File[])subFiles);
                if (subFiles == null || subFiles.length <= 0) continue;
                for (File subFile : subFiles) {
                    String subName = subFile.getName();
                    if (!subFile.isDirectory() && (!subFile.isFile() || !this.isValidFile((byte)1, subName))) continue;
                    FileTreeNode subNode = new FileTreeNode(subFile.getAbsolutePath(), 1);
                    subNode.setTitle(subName);
                    subNode.setDir(subFile.isDirectory());
                    node.add((MutableTreeNode)((Object)subNode));
                    continue block2;
                }
            }
            HashSet<String> existNames = new HashSet<String>();
            int cc = pNode.getChildCount();
            for (int i = 0; i < cc; ++i) {
                FileTreeNode subNode = (FileTreeNode)((Object)pNode.getChildAt(i));
                existNames.add(subNode.getTitle());
            }
            for (File f : files) {
                String fileName = f.getName();
                if (!StringUtils.isValidString((Object)fileName) || existNames.contains(fileName)) continue;
                FileTreeNode node = new FileTreeNode(f.getAbsolutePath(), 1);
                node.setTitle(fileName);
                boolean isDir = f.isDirectory();
                if (isDir || !this.isValidFile((byte)1, fileName)) continue;
                node.setDir(isDir);
                pNode.add((MutableTreeNode)((Object)node));
            }
            pNode.setLoaded(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean isValidFile(byte type, String fileName) {
        if (fileName == null) {
            return false;
        }
        if (1 == type) {
            return GMDql.isDqlFile(fileName);
        }
        return true;
    }

    public void showNode(FileTreeNode node) {
    }

    protected JPopupMenu getPopupMenu(FileTreeNode node) {
        MenuListener menuListener = new MenuListener(node);
        JPopupMenu popMenu = new JPopupMenu();
        byte type = node.getType();
        if (type == 1) {
            if (node.isDir()) {
                popMenu.add(this.getMenuItem((byte)2, menuListener));
                popMenu.add(this.getMenuItem((byte)4, menuListener));
            } else {
                popMenu.add(this.getMenuItem((byte)1, menuListener));
                popMenu.add(this.getMenuItem((byte)3, menuListener));
            }
            popMenu.add(this.getMenuItem((byte)5, menuListener));
        } else if (type == 2) {
            if ((node.getUserObject() instanceof ICloudClientDql || node.getUserObject() instanceof FileInfo || node.getUserObject() instanceof String) && type == 2) {
                selectCloud = node.getCloudName();
            }
            if (node.getLevel() == 1) {
                popMenu.add(this.getMenuItem((byte)20, menuListener));
                popMenu.add(this.getMenuItem((byte)4, menuListener));
                return popMenu;
            }
            if (node.getLevel() == 2) {
                popMenu.add(this.getMenuItem((byte)21, menuListener));
                popMenu.add(this.getMenuItem((byte)4, menuListener));
                return popMenu;
            }
            if (node.getLevel() == 3) {
                popMenu.add(this.getMenuItem((byte)21, menuListener));
                popMenu.add(this.getMenuItem((byte)27, menuListener));
                popMenu.add(this.getMenuItem((byte)4, menuListener));
                popMenu.add(this.getMenuItem((byte)25, menuListener));
                popMenu.add(this.getMenuItem((byte)26, menuListener));
                return popMenu;
            }
            if (node.isDir()) {
                popMenu.add(this.getMenuItem((byte)27, menuListener));
                popMenu.add(this.getMenuItem((byte)4, menuListener));
                popMenu.add(this.getMenuItem((byte)25, menuListener));
                popMenu.add(this.getMenuItem((byte)26, menuListener));
            } else {
                FileInfo fi;
                String fileName;
                boolean canOpen = true;
                Object obj = node.getUserObject();
                if (obj instanceof FileInfo && !GMDql.isDqlFile(fileName = (fi = (FileInfo)obj).getFilename())) {
                    canOpen = false;
                }
                if (canOpen) {
                    JMenuItem openMi = this.getMenuItem((byte)1, menuListener);
                    popMenu.add(openMi);
                    JMenuItem saveMenu = this.getMenuItem((byte)22, menuListener);
                    popMenu.add(saveMenu);
                    JInternalFrame o = this.getSheet(this.getCloudSheetName(node));
                    if (o != null) {
                        saveMenu.setEnabled(true);
                    } else {
                        saveMenu.setEnabled(false);
                    }
                }
                popMenu.add(this.getMenuItem((byte)24, menuListener));
                popMenu.add(this.getMenuItem((byte)28, menuListener));
            }
        }
        return popMenu;
    }

    protected JMenuItem getMenuItem(byte action, ActionListener al) {
        String imgPath;
        String title;
        switch (action) {
            case 1: {
                title = mm.getMessage("filetree.open");
                imgPath = "m_open.gif";
                break;
            }
            case 2: {
                title = mm.getMessage("filetree.opendir");
                imgPath = "m_load.gif";
                break;
            }
            case 3: {
                title = mm.getMessage("filetree.openfiledir");
                imgPath = "m_load.gif";
                break;
            }
            case 4: {
                title = mm.getMessage("filetree.refresh");
                imgPath = "m_refresh.gif";
                break;
            }
            case 5: {
                title = ConfigOptions.bFileTreeDemo != false ? mm.getMessage("filetree.switchmain") : mm.getMessage("filetree.switchdemo");
                imgPath = "switchpath.gif";
                break;
            }
            case 20: {
                title = mm.getMessage("filetree.serverlogin");
                imgPath = "m_login.gif";
                break;
            }
            case 21: {
                title = mm.getMessage("filetree.serverlogout");
                imgPath = "m_quit.gif";
                break;
            }
            case 22: {
                title = mm.getMessage("filetree.save");
                imgPath = "m_save.gif";
                break;
            }
            case 27: {
                title = mm.getMessage("filetree.uploadfile");
                imgPath = "m_uploadfile.gif";
                break;
            }
            case 24: {
                title = mm.getMessage("filetree.downloadfile");
                imgPath = "m_loaddata.gif";
                break;
            }
            case 25: {
                title = mm.getMessage("filetree.downloaddir");
                imgPath = "blank.gif";
                break;
            }
            case 26: {
                title = mm.getMessage("filetree.downloaddirwithchild");
                imgPath = "blank.gif";
                break;
            }
            case 29: {
                title = mm.getMessage("filetree.deletetree");
                imgPath = "m_removetable.gif";
                break;
            }
            case 28: {
                title = mm.getMessage("filetree.deletenode");
                imgPath = "m_removerow.gif";
                break;
            }
            default: {
                return null;
            }
        }
        JMenuItem mi = new JMenuItem(title);
        mi.setName(action + "");
        if (imgPath != null) {
            mi.setIcon(GMDql.getImageIcon((String)("/com/scudata/ide/spl/dql/images/" + imgPath)));
        }
        mi.addActionListener(al);
        return mi;
    }

    protected void menuAction(FileTreeNode node, JMenuItem mi) {
        String sAction = mi.getName();
        byte action = Byte.parseByte(sAction);
        switch (action) {
            case 1: {
                this.openFile(node);
                break;
            }
            case 2: {
                try {
                    Desktop.getDesktop().open(new File((String)node.getUserObject()));
                }
                catch (Exception ex) {
                    GMDql.showException((Component)GV.appFrame, (Object)ex);
                }
                break;
            }
            case 3: {
                try {
                    Desktop.getDesktop().open(new File((String)node.getUserObject()).getParentFile());
                }
                catch (Exception ex) {
                    GMDql.showException((Component)GV.appFrame, (Object)ex);
                }
                break;
            }
            case 4: {
                this.refreshNode(node);
                break;
            }
            case 5: {
                ConfigOptions.bFileTreeDemo = ConfigOptions.bFileTreeDemo == false;
                this.refreshLocal();
                break;
            }
            case 20: {
                if (node.getType() != 2) {
                    return;
                }
                short cmdId = 2401;
                try {
                    GMDql.executeCmd(cmdId);
                }
                catch (Exception e) {
                    this.showException(e);
                }
                break;
            }
            case 21: {
                String cloudName = selectCloud;
                new IllIllIIIIIlIllI(this, (JFrame)GVDql.appFrame, this.getLogoImage(), cloudName).setVisible(true);
                this._$1();
                break;
            }
            case 22: {
                if (!(node.getUserObject() instanceof FileInfo)) break;
                try {
                    ISheetDql sheet = (ISheetDql)GVDql.appFrame.getSheet(this.getCloudSheetName(node));
                    sheet.save();
                }
                catch (Throwable t) {
                    this.showException(t);
                }
                break;
            }
            case 27: {
                String cloudName;
                String string = cloudName = node == null ? null : node.getCloudName();
                if (cloudName == null) {
                    cloudName = selectCloud;
                }
                String selectServerName = cloudName;
                lIIlllIIIIIlIllI dcuf = new lIIlllIIIIIlIllI(this, (JFrame)GVDql.appFrame, this.getLogoImage(), "\"" + GMDql.getFileExts() + "\"", selectServerName, node == null ? null : FileTree.getCloudPath(node));
                dcuf.setArea((byte)1);
                dcuf.setVisible(true);
                if (!dcuf.isUploadFile()) break;
                this.refreshNode(node);
                break;
            }
            case 24: {
                if (node == null) {
                    return;
                }
                FileInfo fi = (FileInfo)node.getUserObject();
                String fileName = fi.getFilename();
                File f = GMDql.dialogSelectFile((Component)GV.appFrame, (String)"", (String)GVDql.lastDirectory, null, (String)fileName);
                if (f == null) {
                    return;
                }
                String cloudName = node.getCloudName();
                if (cloudName == null) {
                    cloudName = selectCloud;
                }
                ICloudClientDql cloud = FileTree.getCloud(cloudName);
                String cloudPath = FileTree.getCloudPath(node);
                cloud.dialogDownloadFile((Component)GVDql.appFrame, cloudPath, f, node.getArea());
                return;
            }
            case 25: 
            case 26: {
                if (node == null) {
                    return;
                }
                String localDirPath = GMDql.dialogSelectDirectory((Component)GV.appFrame, (String)GVDql.lastDirectory);
                if (!StringUtils.isValidString((Object)localDirPath)) {
                    return;
                }
                File localDir = new File(localDirPath);
                String cloudName = node.getCloudName();
                if (cloudName == null) {
                    cloudName = selectCloud;
                }
                String dirName = null;
                Object obj = node.getUserObject();
                boolean isRoot = false;
                if (obj instanceof FileInfo) {
                    FileInfo fi = (FileInfo)obj;
                    dirName = new File(fi.getFilename()).getName();
                } else if (obj instanceof String) {
                    dirName = (String)obj;
                    isRoot = true;
                }
                File downloadDir = localDir;
                int option = 0;
                if (dirName != null) {
                    localDir = new File(localDir, dirName);
                    if (isRoot) {
                        downloadDir = localDir;
                    }
                    if (downloadDir.exists()) {
                        option = JOptionPane.showOptionDialog((Component)GVDql.appFrame, IdeDqlMessage.get().getMessage("filetree.existdirmsg", (Object)downloadDir.getAbsolutePath()), IdeDqlMessage.get().getMessage("filetree.download"), 1, 3, null, new String[]{IdeDqlMessage.get().getMessage("filetree.replacefile"), IdeDqlMessage.get().getMessage("filetree.skip"), IdeDqlMessage.get().getMessage("filetree.canceldownload")}, IdeDqlMessage.get().getMessage("filetree.replacefile"));
                        if (option == 2) {
                            return;
                        }
                    } else {
                        downloadDir.mkdirs();
                    }
                }
                ICloudClientDql cloud = FileTree.getCloud(cloudName);
                String cloudPath = FileTree.getCloudPath(node);
                cloud.dialogDownloadDir((Component)GVDql.appFrame, cloudPath, downloadDir, action == 26, option, node.getArea());
                return;
            }
            case 28: {
                ISheetDql sheet;
                ICloudClientDql cloud;
                String cloudName;
                String string = cloudName = node == null ? null : node.getCloudName();
                if (cloudName == null) {
                    cloudName = selectCloud;
                }
                if ((cloud = FileTree.getCloud(cloudName)) == null) {
                    return;
                }
                String sheetName = this.getCloudSheetName(node);
                JInternalFrame jif = ((DQL)GVDql.appFrame).getSheet(sheetName);
                if (jif != null && !((DQL)GVDql.appFrame).closeSheet(sheet = (ISheetDql)jif)) {
                    return;
                }
                String cloudFilePath = FileTree.getCloudPath(node);
                cloud.remove(cloudFilePath, node.getArea());
                FileTreeNode parentNode = (FileTreeNode)((Object)node.getParent());
                if (parentNode != null) {
                    this.refreshNode(parentNode);
                }
                return;
            }
            case 29: {
                return;
            }
        }
    }

    public void refreshActiveNode() {
        FileTreeNode activeNode = this.getActiveNode();
        this.refreshNode(activeNode);
    }

    public void refreshNode(FileTreeNode node) {
        node.setLoaded(false);
        if (node.getType() == 1) {
            this.loadSubNode(node);
        } else if (node.getType() == 0) {
            this.refreshLocal();
            this.refreshCloud();
        } else if (node.getType() == 2) {
            if (node.getLevel() == 1) {
                this.refreshCloud();
            } else {
                this.loadCloudFileTree(node, true);
            }
        }
        this.nodeStructureChanged(node);
        if (node.isDir()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                FileTreeNode subNode = (FileTreeNode)((Object)node.getChildAt(i));
                if (subNode.isDir()) continue;
                TreePath path = new TreePath(subNode.getPath());
                this.expandPath(path);
                break;
            }
        }
    }

    protected void openFile(FileTreeNode node) {
        Object o = node.getUserObject();
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            try {
                this.openSheetFile((String)node.getUserObject());
            }
            catch (Exception e) {
                this.showException(e);
            }
        } else if (o instanceof FileInfo) {
            if (!((FileInfo)o).canRead()) {
                this.showException(mm.getMessage("filetree.filecannotread", (Object)((FileInfo)o).getFilename()));
                return;
            }
            String cloudName = node.getCloudName();
            try {
                String fileName;
                ICloudClientDql cloud;
                if (node.getType() == 2) {
                    cloud = FileTree.getCloud(cloudName);
                    if (cloud == null) {
                        new Throwable(mm.getMessage("filetree.servernotconnect", (Object)cloudName));
                    }
                    if (!GMDql.isDqlFile(fileName = FileTree.getCloudPath(node))) {
                        return;
                    }
                } else {
                    return;
                }
                InputStream in = cloud.open(fileName, (byte)1);
                byte sheetType = 1;
                fileName = this.getCloudSheetName(node);
                this._$1(in, fileName, sheetType);
            }
            catch (Exception e) {
                this.showException(e);
            }
        }
    }

    protected void nodeSelected(FileTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.getType() == 2) {
            selectCloud = node.getCloudName();
        }
    }

    private void _$1(FileTreeNode pNode, byte state) {
        for (int i = 0; i < pNode.getChildCount(); ++i) {
            FileTreeNode subNode = (FileTreeNode)((Object)pNode.getChildAt(i));
            subNode.setSelectedState(state);
            this._$1(subNode, state);
        }
    }

    private void _$1(FileTreeNode node) {
        while (node.getParent() instanceof FileTreeNode) {
            FileTreeNode pNode = (FileTreeNode)((Object)node.getParent());
            byte tempState = 0;
            boolean allSelected = true;
            for (int i = 0; i < pNode.getChildCount(); ++i) {
                FileTreeNode subNode = (FileTreeNode)((Object)pNode.getChildAt(i));
                if (subNode.getSelectedState() != 1) {
                    allSelected = false;
                }
                if (subNode.getSelectedState() <= tempState) continue;
                tempState = subNode.getSelectedState();
            }
            if (tempState == 1 && !allSelected) {
                tempState = 2;
            }
            pNode.setSelectedState(tempState);
            node = pNode;
        }
    }

    public void setCheckNodeModel(boolean isCheckNode) {
        this.isCheckNode = isCheckNode;
    }

    public boolean isCheckNodeModel() {
        return this.isCheckNode;
    }

    public FileTreeNode getActiveNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (FileTreeNode)((Object)path.getLastPathComponent());
    }

    protected FileTreeNode addFileNode(FileTreeNode pNode, String path, Object data) {
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, File.separator);
        ArrayList<String> paths = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            paths.add(st.nextToken());
        }
        if (paths.isEmpty()) {
            return null;
        }
        for (int i = 0; i < paths.size() - 1; ++i) {
            if ((pNode = this.getChildByName(pNode, (String)paths.get(i))) != null) continue;
            return null;
        }
        String lastName = (String)paths.get(paths.size() - 1);
        FileTreeNode fNode = this.getChildByName(pNode, lastName);
        if (fNode != null) {
            return null;
        }
        fNode = new FileTreeNode(data, 1);
        fNode.setTitle(lastName);
        pNode.add((MutableTreeNode)((Object)fNode));
        return fNode;
    }

    protected FileTreeNode locateFileNode(FileTreeNode pNode, String path) {
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, File.separator);
        ArrayList<String> paths = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            paths.add(st.nextToken());
        }
        if (paths.isEmpty()) {
            return null;
        }
        for (int i = 0; i < paths.size(); ++i) {
            if ((pNode = this.getChildByName(pNode, (String)paths.get(i))) != null) continue;
            return null;
        }
        return pNode;
    }

    protected FileTreeNode locateFileNode(FileTreeNode pNode, List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return pNode;
        }
        int size = paths.size();
        for (int i = size - 1; i >= 0; --i) {
            if ((pNode = this.getChildByName(pNode, paths.get(i))) != null) continue;
            return null;
        }
        return pNode;
    }

    protected FileTreeNode getChildByName(FileTreeNode pNode, String nodeName) {
        if (nodeName == null) {
            return null;
        }
        int count = pNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            FileTreeNode childNode = (FileTreeNode)((Object)pNode.getChildAt(i));
            if (!nodeName.equals(childNode.getTitle())) continue;
            return childNode;
        }
        return null;
    }

    protected void selectNode(FileTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.expandPath(path);
        this.setSelectionPath(path);
        this.nodeSelected(node);
    }

    protected void nodeChanged(FileTreeNode node) {
        if (node != null) {
            ((DefaultTreeModel)this.getModel()).nodeChanged((TreeNode)((Object)node));
        }
    }

    protected void nodeStructureChanged(FileTreeNode node) {
        if (node != null) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged((TreeNode)((Object)node));
        }
    }

    public FileTreeNode getRoot() {
        return this.root;
    }

    public Component getComponent() {
        return this;
    }

    public void changeMainPath(String mainPath) {
        GV.config.setMainPath(mainPath);
        this.refreshLocal();
    }

    public synchronized void refreshCloud() {
        this.cloudRoot.removeAllChildren();
        if (this._$1 != null && this._$1.size() > 0) {
            for (int i = 0; i < this._$1.size(); ++i) {
                ICloudClientDql cloud = this._$1.get(i);
                if (cloud == null) continue;
                FileTreeNode cloudNode = new FileTreeNode(cloud, 2);
                cloudNode.setDir(true);
                cloudNode.setTitle(cloud.getName());
                cloudNode.setCloudName(cloud.getName());
                if (StringUtils.isValidString((Object)selectCloud) && selectCloud.equals(cloud.getName())) {
                    cloudNode.setExpanded(true);
                } else {
                    cloudNode.setExpanded(false);
                }
                this.loadCloudFileTree(cloudNode, true);
                this.cloudRoot.add((MutableTreeNode)((Object)cloudNode));
            }
        }
        this.nodeStructureChanged(this.cloudRoot);
    }

    protected ImageIcon getLogoImage() {
        return GMDql.getLogoImage(true);
    }

    protected JInternalFrame openSheetFile(String file) throws Exception {
        return GVDql.appFrame.openSheetFile(file);
    }

    private JInternalFrame _$1(InputStream in, String fileName, byte sheetType) throws Exception {
        return GVDql.appFrame.openSheetFile(in, fileName, sheetType);
    }

    public JInternalFrame getSheet(String title) {
        return GVDql.appFrame.getSheet(title);
    }

    public void setClosing() {
        this._$2 = true;
    }

    protected void showException(Object oMsg) {
        if (this._$2) {
            GMDql.writeLog((Object)oMsg);
        } else {
            GMDql.showException((Component)GV.appFrame, (Object)oMsg);
        }
    }

    private void _$1() {
        boolean hasCloud = this._$1 != null && !this._$1.isEmpty();
        short[] menuIds = new short[]{2403, 2441};
        GVDql.appMenu.setEnable(menuIds, hasCloud);
    }

    protected void loadCloudFileTree(FileTreeNode cloudNode, boolean first) {
        if (cloudNode == null) {
            return;
        }
        cloudNode.removeAllChildren();
        if (cloudNode.getUserObject() instanceof ICloudClientDql) {
            ICloudClientDql cloud = (ICloudClientDql)cloudNode.getUserObject();
            if (cloud == null) {
                return;
            }
            String cloudName = cloud.getName();
            FileTreeNode dirNode = new FileTreeNode(FileTreeEE.BUSINESS_DIR, 2);
            dirNode.setTitle(FileTreeEE.BUSINESS_DIR);
            dirNode.setDir(true);
            dirNode.setArea((byte)1);
            dirNode.setCloudName(cloudName);
            cloudNode.add((MutableTreeNode)((Object)dirNode));
            this.loadCloudFileTree(dirNode, true);
            dirNode = new FileTreeNode(FileTreeEE.BUFFER_DIR, 2);
            dirNode.setTitle(FileTreeEE.BUFFER_DIR);
            dirNode.setDir(true);
            dirNode.setArea((byte)2);
            dirNode.setCloudName(cloudName);
            cloudNode.add((MutableTreeNode)((Object)dirNode));
            this.loadCloudFileTree(dirNode, true);
            dirNode = new FileTreeNode(FileTreeEE.BACKUP_DIR, 2);
            dirNode.setTitle(FileTreeEE.BACKUP_DIR);
            dirNode.setDir(true);
            dirNode.setArea((byte)3);
            dirNode.setCloudName(cloudName);
            cloudNode.add((MutableTreeNode)((Object)dirNode));
            this.loadCloudFileTree(dirNode, true);
            cloudNode.setExpanded(true);
        } else if (cloudNode.getUserObject() instanceof FileInfo || cloudNode.getUserObject() instanceof String) {
            boolean isDir;
            FileTreeNode node;
            String fileName;
            List<FileInfo> subFiles;
            ICloudClientDql cloud = FileTree.getCloud(cloudNode.getCloudName());
            if (cloud == null) {
                return;
            }
            byte area = cloudNode.getArea();
            if (cloudNode.getUserObject() instanceof String) {
                subFiles = cloud.listFiles(null, area);
            } else {
                String p = FileTree.getCloudPath(cloudNode);
                subFiles = cloud.listFiles(p, area);
            }
            if (subFiles == null || subFiles.size() <= 0) {
                return;
            }
            cloudNode.removeAllChildren();
            for (FileInfo fileInfo : subFiles) {
                if (fileInfo == null || !StringUtils.isValidString((Object)(fileName = fileInfo.getFilename()))) continue;
                node = new FileTreeNode(fileInfo, 2);
                node.setTitle(fileName);
                node.setCloudName(cloud.getName());
                node.setArea(area);
                isDir = fileInfo.isDirectory();
                if (!isDir) continue;
                node.setDir(isDir);
                node.setLoaded(false);
                cloudNode.add((MutableTreeNode)((Object)node));
                if (!first) continue;
                this.loadCloudFileTree(node, false);
            }
            for (FileInfo fileInfo : subFiles) {
                if (fileInfo == null || !StringUtils.isValidString((Object)(fileName = fileInfo.getFilename()))) continue;
                node = new FileTreeNode(fileInfo, 2);
                node.setTitle(fileName);
                node.setCloudName(cloud.getName());
                node.setArea(area);
                isDir = fileInfo.isDirectory();
                if (isDir || !this.isValidFile((byte)2, fileName)) continue;
                node.setDir(isDir);
                cloudNode.add((MutableTreeNode)((Object)node));
            }
        }
        cloudNode.setLoaded(false);
    }

    protected String getCloudSheetName(FileTreeNode node) {
        Object o = node.getUserObject();
        if (o instanceof FileInfo) {
            String cloudName = node.getCloudName();
            ICloudClientDql cloud = FileTree.getCloud(cloudName);
            if (cloud == null) {
                new Throwable(mm.getMessage("filetree.servernotconnect", (Object)cloudName));
            }
            String fileName = FileTree.getCloudPath(node);
            fileName = cloudName + ":" + fileName;
            return fileName;
        }
        return null;
    }

    public List<ICloudClientDql> getCloudList() {
        return this._$1;
    }

    public void addCloud(ICloudClientDql cloud) {
        if (this.cloudRoot == null) {
            this.cloudRoot = new FileTreeNode("", 2);
            this.cloudRoot.setDir(true);
            this.cloudRoot.setTitle(_$5);
            this.root.add((MutableTreeNode)((Object)this.cloudRoot));
        }
        if (this._$1 == null) {
            this._$1 = new ArrayList<ICloudClientDql>();
        }
        this._$1.add(cloud);
        FileTreeNode cloudNode = new FileTreeNode(cloud, 2);
        cloudNode.setDir(true);
        cloudNode.setExpanded(true);
        cloudNode.setTitle(cloud.getName());
        cloudNode.setCloudName(cloud.getName());
        this.cloudRoot.add((MutableTreeNode)((Object)cloudNode));
        this.cloudRoot.setTitle(_$6);
        this.cloudRoot.setExpanded(true);
        this.cloudRoot.setLoaded(true);
        selectCloud = cloud.getName();
        try {
            this.loadCloudFileTree(cloudNode, true);
        }
        catch (Throwable t) {
            this.showException(t);
        }
        this.nodeStructureChanged(this.root);
        this.nodeStructureChanged(this.cloudRoot);
        selectCloud = cloud.getName();
        this.selectNode(cloudNode);
    }

    public void deleteCloud(ICloudClientDql cloud) {
        if (this._$1 == null || cloud == null) {
            return;
        }
        List sheetNameList = GVDql.appFrame.getSheetNameList();
        for (String name : sheetNameList) {
            if (!StringUtils.isValidString((Object)name) || !name.startsWith(cloud.getName() + ":")) continue;
            try {
                ((DQL)GVDql.appFrame).closeSheet(name);
            }
            catch (Exception e) {
                this.showException(e);
            }
        }
        try {
            cloud.logout();
        }
        catch (Throwable e) {
            this.showException(e);
        }
        this._$1.remove(cloud);
        this.cloudRoot.setLoaded(false);
        Enumeration children = this.cloudRoot.children();
        while (children.hasMoreElements()) {
            FileTreeNode fileTreeNode = (FileTreeNode)((Object)children.nextElement());
            if (!cloud.getName().equals(fileTreeNode.getCloudName())) continue;
            this.cloudRoot.remove((MutableTreeNode)((Object)fileTreeNode));
        }
        this.loadCloudFileTree(this.cloudRoot, true);
        this.nodeStructureChanged(this.cloudRoot);
        if (cloud.getName().equals(selectCloud) && this._$1.size() > 0) {
            selectCloud = FileTree.getCloudNames().get(0);
        }
    }

    public static String getCloudPath(FileTreeNode node) {
        if (node == null || node.getType() != 2) {
            return "/";
        }
        if (node.getUserObject() instanceof ICloudClientDql) {
            return File.separator.replaceAll("\\\\", "/");
        }
        if (node.getUserObject() instanceof FileInfo) {
            String path = File.separator + node.getName();
            for (FileTreeNode pNode = (FileTreeNode)((Object)node.getParent()); pNode != null && pNode.getType() == 2; pNode = (FileTreeNode)((Object)pNode.getParent())) {
                String p = pNode.getTitle();
                if (!StringUtils.isValidString((Object)p) || !(pNode.getUserObject() instanceof FileInfo)) continue;
                path = File.separator + p + path;
            }
            return path.replaceAll("\\\\", "/");
        }
        return "/";
    }

    public static ICloudClientDql getCloud(String cloudName) {
        if (!StringUtils.isValidString((Object)cloudName)) {
            return null;
        }
        List<ICloudClientDql> cloudList = GVDql.fileTree.getCloudList();
        if (cloudList != null) {
            for (ICloudClientDql cloud : cloudList) {
                if (!cloudName.equals(cloud.getName())) continue;
                return cloud;
            }
        }
        return null;
    }

    public static Vector<String> getCloudNames() {
        Vector<String> cloudNames = new Vector<String>();
        List<ICloudClientDql> cloudList = GVDql.fileTree.getCloudList();
        if (cloudList != null) {
            for (ICloudClientDql cloud : cloudList) {
                cloudNames.add(cloud.getName());
            }
        }
        return cloudNames;
    }

    static /* synthetic */ void _$1(FileTree x0, FileTreeNode x1, byte x2) {
        x0._$1(x1, x2);
    }

    static /* synthetic */ void _$1(FileTree x0, FileTreeNode x1) {
        x0._$1(x1);
    }

    protected class MenuListener
    implements ActionListener {
        FileTreeNode _$2;

        public MenuListener(FileTreeNode node) {
            this._$2 = node;
        }

        public void setFileTreeNode(FileTreeNode node) {
            this._$2 = node;
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            FileTree.this.menuAction(this._$2, mi);
        }
    }
}

