/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dql.base;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.FieldList;
import com.scudata.dm.query.metadata.IField;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.metadata.TableList;
import com.scudata.ide.spl.dql.GCDql;
import com.scudata.ide.spl.dql.GMDql;
import com.scudata.ide.spl.dql.base.IIllllllIllllIII;
import com.scudata.ide.spl.dql.base.View;
import com.scudata.ide.spl.dql.base.ViewConfig;
import com.scudata.ide.spl.dql.base.lIllllllIllllIII;
import com.scudata.ide.spl.dql.base.llIIllllIllllIII;
import com.scudata.ide.spl.dql.dialog.DialogViewAdvance;
import com.scudata.ide.spl.dql.resources.IdeDqlMessage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public abstract class PanelView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Color _$17 = new Color(128, 160, 192).brighter();
    private final Color _$16 = Color.BLACK;
    private final Color _$15 = new Color(203, 254, 203);
    private final Color _$14 = Color.BLACK;
    private final Color _$13 = Color.WHITE;
    private final Color _$12 = Color.BLACK;
    private final Color _$11 = Color.DARK_GRAY;
    private final int _$10 = 20;
    private final int _$9 = 20;
    public static int VIEW_WIDTH = 200;
    public static int SEP_SIZE = 30;
    public static int CENTER_SEP = 100;
    private JScrollPane _$8;
    private View[] _$7;
    private View[] _$6;
    private View _$5;
    private final int _$4 = 5;
    private int _$3 = 1;
    private MessageManager _$2 = IdeDqlMessage.get();
    private boolean _$1 = true;

    public PanelView(JScrollPane parent) {
        this._$8 = parent;
        this.setFont(GCDql.font);
        this._$2();
    }

    public void setViewConfig(ViewConfig vc) {
        this._$1(vc);
        if (this._$5 != null) {
            this._$5 = this._$1(this._$5.type == 1 ? this._$7 : this._$6, this._$5.name);
        }
    }

    public void selectView(String name, byte type) {
        View view;
        switch (type) {
            case 1: {
                view = this._$1(this._$7, name);
                break;
            }
            case 2: {
                view = this._$1(this._$6, name);
                break;
            }
            default: {
                return;
            }
        }
        this._$5 = view;
        this._$4();
    }

    private void _$4() {
        this.revalidate();
        this.repaint();
        if (this._$5 != null) {
            Rectangle rect = new Rectangle(this._$5._$4, this._$5._$3, VIEW_WIDTH, this._$5._$1);
            if (this._$1(this._$8.getViewport(), rect)) {
                this.repaint();
            }
        }
    }

    private boolean _$1(JViewport viewport, Rectangle fieldArea) {
        Rectangle viewArea = viewport.getViewRect();
        if (viewArea.contains(fieldArea)) {
            return false;
        }
        Point pos = new Point();
        int sep = SEP_SIZE;
        pos.x = viewArea.x;
        if (fieldArea.x + fieldArea.width > viewArea.x + viewArea.width) {
            pos.x = fieldArea.x + fieldArea.width - viewArea.width + sep;
        }
        int n = pos.x = pos.x > fieldArea.x ? fieldArea.x - sep : pos.x;
        if (pos.x + viewArea.width > viewport.getView().getWidth()) {
            pos.x = viewport.getView().getWidth() - viewArea.width;
        }
        pos.y = viewArea.y;
        if (fieldArea.y + fieldArea.height > viewArea.y + viewArea.height) {
            pos.y = fieldArea.y + fieldArea.height - viewArea.height + sep;
        }
        int n2 = pos.y = pos.y > fieldArea.y ? fieldArea.y - sep : pos.y;
        if (pos.y + viewArea.height > viewport.getView().getHeight()) {
            pos.y = viewport.getView().getHeight() - viewArea.height;
        }
        viewport.setViewPosition(pos);
        return true;
    }

    public void paint(Graphics g) {
        int i;
        Dimension d = this.getPreferredSize();
        g.clearRect(0, 0, d.width + 9999, d.height + 9999);
        Rectangle dispWin = this._$8.getViewport().getViewRect();
        if (this._$7 != null) {
            for (i = 0; i < this._$7.length; ++i) {
                if (!this._$1(this._$7[i], dispWin)) continue;
                this._$1(g, this._$7[i]);
            }
        }
        if (this._$6 != null) {
            for (i = 0; i < this._$6.length; ++i) {
                if (!this._$1(this._$6[i], dispWin)) continue;
                this._$1(g, this._$6[i]);
            }
        }
        if (this._$7 != null && this._$6 != null) {
            g.setColor(Color.BLACK);
            for (int i2 = 0; i2 < this._$7.length; ++i2) {
                if (!this._$1(this._$7[i2], dispWin)) continue;
                Table t = this.getViewTable(this._$7[i2]);
                String[] fields = this._$7[i2].fields;
                boolean[] fieldsVisible = this._$7[i2].fieldsVisible;
                FieldList fl = t.getFieldList();
                if (fl == null || fields == null) continue;
                int visibleFieldCount = 0;
                for (int j = 0; j < fields.length; ++j) {
                    View dimView;
                    String dimName;
                    if (fieldsVisible != null && !fieldsVisible[j]) continue;
                    ++visibleFieldCount;
                    Field f = fl.getFieldByName(fields[j]);
                    if (f == null || !StringUtils.isValidString((Object)(dimName = this._$1(f))) || (dimView = this._$1(this._$6, dimName)) == null) continue;
                    int x1 = this._$7[i2]._$4;
                    int x2 = dimView._$4;
                    if (this._$7[i2]._$4 == SEP_SIZE) {
                        x1 += VIEW_WIDTH;
                    } else {
                        x2 += VIEW_WIDTH;
                    }
                    int y1 = this._$7[i2]._$3 + 10;
                    int y2 = dimView._$3 + 10;
                    if (!this._$7[i2].isExpand && !f.isPrimary()) continue;
                    if (this._$7[i2].isExpand) {
                        y1 += 20 * visibleFieldCount;
                    }
                    g.drawLine(x1, y1, x2, y2);
                }
            }
        }
        if (this._$5 != null && this._$1(this._$5, dispWin)) {
            g.setColor(this._$11);
            g.drawRect(this._$5._$4 - 1, this._$5._$3 - 1, VIEW_WIDTH + 2, this._$5._$1 + 2);
            g.drawRect(this._$5._$4 - 2, this._$5._$3 - 2, VIEW_WIDTH + 4, this._$5._$1 + 4);
            g.drawRect(this._$5._$4 - 3, this._$5._$3 - 3, VIEW_WIDTH + 6, this._$5._$1 + 6);
        }
    }

    private boolean _$1(View v, Rectangle dispWin) {
        if (v == null || dispWin == null) {
            return true;
        }
        int x1 = dispWin.x;
        int x2 = dispWin.x + dispWin.width;
        int y1 = dispWin.y;
        int y2 = dispWin.y + dispWin.height;
        return (x1 <= v._$4 && v._$4 <= x2 || x1 <= v._$4 + VIEW_WIDTH && v._$4 + VIEW_WIDTH <= x2) && (y1 <= v._$3 && v._$3 <= y2 || y1 <= v._$3 + v._$1 && v._$3 + v._$1 <= y2);
    }

    public Dimension getPreferredSize() {
        if (this._$7 == null && this._$6 == null) {
            return new Dimension(1, 1);
        }
        Rectangle dispWin = this._$8.getViewport().getViewRect();
        int w = 3 * VIEW_WIDTH + 2 * SEP_SIZE + 2 * CENTER_SEP;
        int h = 1;
        if (dispWin != null) {
            w = Math.max(dispWin.width, w);
            h = dispWin.height;
        }
        h = Math.max(h, this._$3);
        return new Dimension(w, h);
    }

    private void _$1(Graphics g, View view) {
        String[] fields;
        Image img;
        Color hfc;
        Color hbc;
        switch (view.type) {
            case 1: {
                hbc = view.isDimTable ? this._$15 : this._$17;
                hfc = this._$16;
                break;
            }
            case 2: {
                hbc = this._$15;
                hfc = this._$14;
                break;
            }
            default: {
                return;
            }
        }
        int x = view._$4;
        int y = view._$3;
        g.setColor(hbc);
        g.fillRect(x, y, VIEW_WIDTH, 20);
        g.setColor(hfc);
        this._$1(g, view.dispName != null ? view.dispName : view.name, x, y, view.type == 1);
        g.setColor(Color.BLACK);
        g.drawRect(x, y, VIEW_WIDTH, 20);
        String sIcon = view.isExpand ? "shrinkview.gif" : "expandview.gif";
        if (view.type == 1) {
            int iconX = x + VIEW_WIDTH - 20;
            g.setColor(Color.WHITE);
            g.fillRect(iconX, y, 20, 20);
            g.setColor(Color.BLACK);
            g.drawRect(iconX, y, 20, 20);
            img = GMDql.getImageIcon((String)("/com/scudata/ide/spl/dql/images/" + sIcon)).getImage();
            g.drawImage(img, iconX + 1, y + 1, 20, 20, null);
        }
        view.setPosition(x, y, VIEW_WIDTH, 20);
        if (view.isExpand && (fields = view.fields) != null) {
            int size = fields.length;
            view._$1 = 20;
            img = GMDql.getImageIcon((String)"/com/scudata/ide/spl/dql/images/pk.png").getImage();
            String[] disps = view.fieldDisps;
            for (int i = 0; i < size; ++i) {
                if (!view.fieldsVisible[i]) continue;
                view._$1 += 20;
                g.setColor(this._$13);
                g.fillRect(x, y += 20, VIEW_WIDTH, 20);
                if (this._$1(view, fields[i])) {
                    g.drawImage(img, x + 3, y + 3, 14, 14, null);
                }
                g.setColor(this._$12);
                String dispField = fields[i];
                if (disps != null && disps[i] != null) {
                    dispField = disps[i];
                }
                this._$1(g, dispField, x + 20 - 5, y, true);
                g.setColor(Color.BLACK);
                g.drawRect(x, y, VIEW_WIDTH, 20);
            }
        }
    }

    private boolean _$1(View view, String field) {
        if (view == null || field == null) {
            return false;
        }
        switch (view.type) {
            case 1: {
                Table t = this.getViewTable(view);
                IField f = t.getField(field);
                if (f == null) {
                    return false;
                }
                return f.isPrimary();
            }
        }
        return false;
    }

    private void _$1(Graphics g, String text, int x, int y, boolean hasIcon) {
        int width = VIEW_WIDTH - 3;
        if (hasIcon) {
            width -= 20;
        }
        this._$1(g, text, x, y, width);
    }

    private void _$1(Graphics g, String text, int x, int y, int maxWidth) {
        if (text == null || text.length() == 0) {
            return;
        }
        text.replaceAll("\r\n", " ");
        text.replaceAll("\r", " ");
        text.replaceAll("\n", " ");
        text.replaceAll("\t", " ");
        text = text.trim();
        FontMetrics fm = g.getFontMetrics(GCDql.font);
        int width = 0;
        int index = -1;
        for (int i = 0; i < text.length(); ++i) {
            if ((width += fm.charWidth(text.charAt(i))) <= maxWidth) continue;
            index = i - 1;
            break;
        }
        if (index > -1) {
            text = text.substring(0, index);
        }
        g.drawString(text, x + 3, y + 20 - 4);
    }

    public abstract Table getViewTable(View var1);

    public abstract void setNodeExpand(View var1);

    public abstract void setDimTableVisible(boolean var1);

    private String _$1(Field f) {
        Field dim = f.getDim();
        if (dim == null) {
            return null;
        }
        Table t = dim.getTable();
        return t == null ? null : t.getName();
    }

    private View _$1(View[] views, String name) {
        if (views == null || name == null) {
            return null;
        }
        for (int i = 0; i < views.length; ++i) {
            if (!name.equals(views[i].name)) continue;
            return views[i];
        }
        return null;
    }

    private View _$2(View[] views, int x, int y) {
        if (views == null) {
            return null;
        }
        for (int i = 0; i < views.length; ++i) {
            int x2 = views[i]._$4 + VIEW_WIDTH;
            int x1 = x2 - 20;
            int y1 = views[i]._$3;
            int y2 = y1 + 20;
            if (x1 >= x || x >= x2 || y1 >= y || y >= y2) continue;
            views[i].isExpand = !views[i].isExpand;
            this.setNodeExpand(views[i]);
            return views[i];
        }
        return null;
    }

    private View _$1(View[] views, int x, int y) {
        return this._$1(views, x, y, false);
    }

    private View _$1(View[] views, int x, int y, boolean caseIcon) {
        if (views == null) {
            return null;
        }
        for (int i = 0; i < views.length; ++i) {
            int y2;
            int y1;
            int x1;
            int x2;
            if (caseIcon) {
                x2 = views[i]._$4 + VIEW_WIDTH;
                x1 = x2 - 20;
                y1 = views[i]._$3;
                y2 = y1 + 20;
                if (x1 < x && x < x2 && y1 < y && y < y2) {
                    return null;
                }
            }
            x1 = views[i]._$4;
            x2 = x1 + views[i]._$2;
            y1 = views[i]._$3;
            y2 = y1 + views[i]._$1;
            if (x1 >= x || x >= x2 || y1 >= y || y >= y2) continue;
            return views[i];
        }
        return null;
    }

    private View _$1(int x, int y) {
        View view = this._$1(this._$7, x, y);
        if (view == null) {
            view = this._$1(this._$6, x, y);
        }
        return view;
    }

    private boolean _$2(View view, int x, int y) {
        int x1 = view._$4 - SEP_SIZE;
        int x2 = view._$4 + VIEW_WIDTH + SEP_SIZE;
        if (x1 - 5 < x && x < x2 + 5) {
            int y1 = view._$3 - SEP_SIZE / 2;
            int y2 = view._$3 + view._$1 + SEP_SIZE / 2;
            return y1 - 5 < y && y < y2 + 5;
        }
        return false;
    }

    private void _$1(View srcView, int x, int y) {
        if (srcView == null) {
            return;
        }
        if (srcView.type == 1) {
            if (this._$7 == null || this._$7.length == 0) {
                return;
            }
            for (int i = 0; i < this._$7.length; ++i) {
                if (!this._$2(this._$7[i], x, y)) continue;
                this._$1(this._$7, srcView, this._$7[i]);
                return;
            }
        } else {
            if (this._$6 == null || this._$6.length == 0) {
                return;
            }
            for (int i = 0; i < this._$6.length; ++i) {
                if (!this._$2(this._$6[i], x, y)) continue;
                this._$1(this._$6, srcView, this._$6[i]);
                return;
            }
        }
    }

    private void _$1(View[] views, View v1, View v2) {
        if (v1.name.equals(v2.name)) {
            return;
        }
        int i1 = -1;
        int i2 = -1;
        for (int i = 0; i < views.length; ++i) {
            if (views[i].name.equals(v1.name)) {
                i1 = i;
                if (i2 <= -1) continue;
                break;
            }
            if (!views[i].name.equals(v2.name)) continue;
            i2 = i;
            if (i1 > -1) break;
        }
        View tmp = views[i1];
        views[i1] = views[i2];
        views[i2] = tmp;
        this.exchangeView(v1.type, views[i1].name, views[i2].name);
    }

    public abstract void exchangeView(byte var1, String var2, String var3);

    public abstract void editObject(String var1, byte var2);

    public abstract void viewSelected(View var1);

    public abstract void expandAllTable(boolean var1);

    private void _$1(ViewConfig vc) {
        this._$7 = null;
        this._$6 = null;
        this._$3 = 1;
        if (vc == null) {
            return;
        }
        this._$7 = this._$1(vc._$2);
        this._$6 = this._$1(vc._$1);
        this._$3();
    }

    private void _$3() {
        int width;
        Rectangle dispWin = this._$8.getViewport().getViewRect();
        int leftX = SEP_SIZE;
        int centerX = SEP_SIZE + VIEW_WIDTH + CENTER_SEP;
        int rightX = SEP_SIZE + 2 * VIEW_WIDTH + 2 * CENTER_SEP;
        if (dispWin != null && (width = dispWin.width) > 3 * VIEW_WIDTH + 2 * SEP_SIZE + 2 * CENTER_SEP) {
            centerX = (dispWin.width - VIEW_WIDTH) / 2;
            rightX = dispWin.x + dispWin.width - SEP_SIZE - VIEW_WIDTH;
        }
        if (this._$7 != null) {
            HashSet<String> usedTables = new HashSet<String>();
            int leftY = 0;
            int rightY = 0;
            for (int i = 0; i < this._$7.length; ++i) {
                TableList tl;
                String tableName = this._$7[i].name;
                if (usedTables.contains(tableName)) continue;
                boolean isLeft = leftY <= rightY;
                this._$7[i]._$4 = isLeft ? leftX : rightX;
                this._$7[i]._$3 = (isLeft ? leftY : rightY) + SEP_SIZE;
                this._$7[i]._$1 = this._$1(this._$7[i]);
                if (isLeft) {
                    leftY = this._$7[i]._$3 + this._$7[i]._$1;
                } else {
                    rightY = this._$7[i]._$3 + this._$7[i]._$1;
                }
                Table t = this.getViewTable(this._$7[i]);
                if (t == null || (tl = t.getAnnexTableList()) == null) continue;
                for (int k = 0; k < tl.size(); ++k) {
                    View gv;
                    Table gt = tl.getTable(k);
                    if (gt == null || (gv = this._$1(this._$7, gt.getName())) == null || gv.name.equals(tableName)) continue;
                    gv._$4 = this._$7[i]._$4;
                    gv._$3 = isLeft ? leftY : rightY;
                    gv._$1 = this._$1(gv);
                    usedTables.add(gv.name);
                    if (isLeft) {
                        leftY = gv._$3 + gv._$1;
                        continue;
                    }
                    rightY = gv._$3 + gv._$1;
                }
            }
            this._$3 = Math.max(leftY, rightY);
        }
        if (this._$6 != null) {
            int centerY = 0;
            for (int i = 0; i < this._$6.length; ++i) {
                this._$6[i]._$4 = centerX;
                this._$6[i]._$3 = centerY += SEP_SIZE + 20;
                this._$6[i]._$1 = 20;
            }
            this._$3 = Math.max(this._$3, centerY);
        }
        this._$3 += SEP_SIZE;
    }

    private int _$1(View view) {
        int h = 20;
        if (view.isExpand && view.fields != null) {
            int fs = view.fields.length;
            if (view.fieldsVisible != null) {
                for (int v = 0; v < view.fieldsVisible.length; ++v) {
                    if (view.fieldsVisible[v]) continue;
                    --fs;
                }
            }
            h += fs * 20;
        }
        return h;
    }

    public void resizePanel() {
        int i;
        int width;
        Rectangle dispWin = this._$8.getViewport().getViewRect();
        int rightX = SEP_SIZE + 2 * VIEW_WIDTH + 2 * CENTER_SEP;
        int centerX = SEP_SIZE + VIEW_WIDTH + CENTER_SEP;
        if (dispWin != null && (width = dispWin.width) > 3 * VIEW_WIDTH + 2 * SEP_SIZE + 2 * CENTER_SEP) {
            centerX = (dispWin.width - VIEW_WIDTH) / 2;
            rightX = dispWin.x + dispWin.width - SEP_SIZE - VIEW_WIDTH;
        }
        if (this._$7 != null) {
            for (i = 0; i < this._$7.length; ++i) {
                if (this._$7[i]._$4 == SEP_SIZE) continue;
                this._$7[i]._$4 = rightX;
            }
        }
        if (this._$6 != null) {
            for (i = 0; i < this._$6.length; ++i) {
                this._$6[i]._$4 = centerX;
            }
        }
    }

    private void _$2() {
        this.addMouseListener(new llIIllllIllllIII(this));
        IIllllllIllllIII dgl = new IIllllllIllllIII(this);
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this, 2, dgl);
        lIllllllIllllIII dtl = new lIllllllIllllIII(this);
        DropTarget dt = new DropTarget(this, dtl);
        this.setDropTarget(dt);
    }

    private void _$1() {
        DialogViewAdvance dva = new DialogViewAdvance();
        dva.setConfig(VIEW_WIDTH, SEP_SIZE, CENTER_SEP);
        dva.setVisible(true);
        if (dva.getOption() == 0) {
            VIEW_WIDTH = dva.getViewWidth();
            SEP_SIZE = dva.getSeparator();
            CENTER_SEP = dva.getCenterSeparator();
            this._$3();
            this._$8.getViewport().setView(this);
        }
    }

    private View[] _$1(View[] views) {
        ArrayList<View> list = new ArrayList<View>();
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                if (views[i].selectedState == 0 || !views[i].isVisible) continue;
                list.add(views[i]);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        int size = list.size();
        View[] visibleViews = new View[size];
        for (int i = 0; i < size; ++i) {
            visibleViews[i] = (View)list.get(i);
        }
        return visibleViews;
    }

    private void _$1(boolean isExpand) {
        if (this._$7 == null) {
            return;
        }
        for (int i = 0; i < this._$7.length; ++i) {
            this._$7[i].isExpand = isExpand;
        }
        this._$3();
        this._$8.getViewport().setView(this);
        this.expandAllTable(isExpand);
    }

    static /* synthetic */ View[] _$7(PanelView x0) {
        return x0._$7;
    }

    static /* synthetic */ View _$2(PanelView x0, View[] x1, int x2, int x3) {
        return x0._$2(x1, x2, x3);
    }

    static /* synthetic */ View[] _$6(PanelView x0) {
        return x0._$6;
    }

    static /* synthetic */ void _$5(PanelView x0) {
        x0._$3();
    }

    static /* synthetic */ View _$1(PanelView x0, View[] x1, int x2, int x3) {
        return x0._$1(x1, x2, x3);
    }

    static /* synthetic */ View _$1(PanelView x0, View x1) {
        x0._$5 = x1;
        return x0._$5;
    }

    static /* synthetic */ View _$4(PanelView x0) {
        return x0._$5;
    }

    static /* synthetic */ View _$1(PanelView x0, View[] x1, int x2, int x3, boolean x4) {
        return x0._$1(x1, x2, x3, x4);
    }

    static /* synthetic */ MessageManager _$3(PanelView x0) {
        return x0._$2;
    }

    static /* synthetic */ void _$2(PanelView x0, boolean x1) {
        x0._$1(x1);
    }

    static /* synthetic */ boolean _$2(PanelView x0) {
        return x0._$1;
    }

    static /* synthetic */ boolean _$1(PanelView x0, boolean x1) {
        x0._$1 = x1;
        return x0._$1;
    }

    static /* synthetic */ void _$1(PanelView x0) {
        x0._$1();
    }

    static /* synthetic */ View _$1(PanelView x0, int x1, int x2) {
        return x0._$1(x1, x2);
    }

    static /* synthetic */ void _$1(PanelView x0, View x1, int x2, int x3) {
        x0._$1(x1, x2, x3);
    }
}

