/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dql.base;

import com.scudata.dm.query.metadata.DataItem;
import com.scudata.dm.query.metadata.Dictionary;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.FieldList;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.metadata.TableItem;
import com.scudata.dm.query.metadata.TableList;
import com.scudata.dm.query.metadata.TableVisibility;
import com.scudata.dm.query.metadata.Visibility;
import com.scudata.ide.spl.dql.GCDql;
import com.scudata.ide.spl.dql.GMDql;
import com.scudata.ide.spl.dql.base.DqlTreeNode;
import com.scudata.ide.spl.dql.base.ITreeDql;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class TableTree
extends ITreeDql {
    private static final long serialVersionUID = 1L;

    public TableTree() {
        this.setModel(new DefaultTreeModel(new DqlTreeNode(GCDql.TITLE_TABLE)));
    }

    public void setConfig(LogicMetaData lmd) {
        this.setConfig(lmd, null, null);
    }

    public void setConfig(LogicMetaData lmd, Dictionary dct, Visibility vsb) {
        TableList tl = lmd.getTableList();
        DqlTreeNode root = this.getRoot();
        root.setCheckNode(this.isCheck);
        root.removeAllChildren();
        if (tl == null) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(root);
            return;
        }
        List<TableItem> til = null;
        if (dct != null) {
            til = dct.getTableItemList();
        }
        for (int i = 0; i < tl.size(); ++i) {
            FieldList fl;
            Table t = (Table)tl.get(i);
            TableVisibility tv = null;
            if (vsb != null) {
                tv = vsb.getTableVisibility(t.getName());
            }
            if (tv != null && tv.isVisible() == 0) continue;
            DqlTreeNode tableNode = new DqlTreeNode((Object)t, 1);
            tableNode.setDispName(t.getName());
            tableNode.setCheckNode(this.isCheck);
            root.add(tableNode);
            TableItem ti = null;
            if (til != null) {
                ti = GMDql.getTableItemByTableName(til, t.getName());
            }
            List<DataItem> dil = null;
            if (ti != null) {
                tableNode.setDispName(ti.getName());
                dil = ti.getDataItemList();
            }
            List<String> ifl = null;
            if (tv != null) {
                ifl = tv.getInvisibleFieldList();
            }
            if ((fl = t.getFieldList()) == null) continue;
            for (int j = 0; j < fl.size(); ++j) {
                Field f = (Field)fl.get(j);
                if (ifl != null && ifl.contains(f.getName())) continue;
                DqlTreeNode fieldNode = new DqlTreeNode((Object)f, 2);
                fieldNode.setCheckNode(this.isCheck);
                tableNode.add(fieldNode);
                DataItem di = GMDql.getDataItemByDataName(dil, f.getName());
                if (di == null) continue;
                fieldNode.setDispName(di.getName());
            }
        }
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(root);
    }

    public void selectTableNode(Table table) {
        if (table == null) {
            return;
        }
        DqlTreeNode root = this.getRoot();
        int size = root.getChildCount();
        for (int i = 0; i < size; ++i) {
            DqlTreeNode tableNode = (DqlTreeNode)root.getChildAt(i);
            if (!table.equals(tableNode.getUserObject())) continue;
            TreePath path = new TreePath(tableNode.getPath());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }
}

