/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm;

import com.scudata.array.BoolArray;
import com.scudata.array.ByteBufferArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.SerialBytesArray;
import com.scudata.array.StringArray;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dw.BufferReader;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.DataBlockType;
import com.scudata.dw.util.BufferUtilNormal;
import com.scudata.pdm.DataBlockReader2;
import com.scudata.pdm.array.DoubleDictArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class DataBlockReader {
    public static IArray readArray(BufferReader reader, ColumnMetaData column, int count) throws IOException {
        return DataBlockReader.readArray(reader, column, count, false);
    }

    public static IArray readArray(BufferReader reader, ColumnMetaData column, int count, boolean isTemp) throws IOException {
        IArray array;
        byte blockType = reader.readByte();
        switch (blockType) {
            case 48: {
                array = DataBlockReader._$15(reader, count);
                break;
            }
            case 126: {
                return DataBlockReader._$18(reader, count);
            }
            case 0: {
                array = new ObjectArray(count);
                array.setSize(count);
                break;
            }
            case 16: {
                array = DataBlockReader._$17(reader, count);
                break;
            }
            case 32: {
                array = DataBlockReader._$16(reader, count);
                break;
            }
            case 64: {
                array = DataBlockReader._$14(reader, count);
                break;
            }
            case 17: {
                array = DataBlockReader._$9(reader, count);
                break;
            }
            case 18: {
                array = DataBlockReader._$8(reader, count);
                break;
            }
            case 20: {
                array = DataBlockReader._$7(reader, count);
                break;
            }
            case 33: {
                array = DataBlockReader._$6(reader, count);
                break;
            }
            case 34: {
                array = DataBlockReader._$5(reader, count);
                break;
            }
            case 36: {
                array = DataBlockReader._$4(reader, count);
                break;
            }
            case 40: {
                array = DataBlockReader._$3(reader, count);
                break;
            }
            case 56: {
                array = DataBlockReader._$2(reader, count);
                break;
            }
            case 80: {
                array = DataBlockReader._$12(reader, count);
                break;
            }
            case 70: {
                array = DataBlockReader._$13(reader, count);
                break;
            }
            case 81: {
                if (isTemp) {
                    array = DataBlockReader._$10(reader, count);
                    break;
                }
                array = DataBlockReader._$11(reader, count);
                break;
            }
            case 127: {
                array = DataBlockReader._$1(reader, column, count);
                break;
            }
            case 3: {
                array = DataBlockReader._$1(reader, count);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (column.getDataType() == 126) {
            return array.toObjectArray();
        }
        return array;
    }

    private static byte[] _$1(BufferReader reader) {
        if (reader.index != 1) {
            int index = reader.index - 1;
            int size = reader.count - index + 1;
            byte[] buffer = new byte[size];
            System.arraycopy(reader.buffer, index, buffer, 0, size);
            return buffer;
        }
        return reader.buffer;
    }

    private static IArray _$18(BufferReader reader, int count) throws IOException {
        ObjectArray array = new ObjectArray(count);
        Object[] arr = array.getDatas();
        for (int i = 1; i <= count; ++i) {
            arr[i] = reader.readObject();
        }
        array.setSize(count);
        return array;
    }

    private static IArray _$17(BufferReader reader, int count) throws IOException {
        IntArray array = new IntArray(count);
        int[] arr = array.getDatas();
        boolean[] isNull = null;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        int repeatCount = reader.repeatCount;
        for (int i = 1; i <= count; ++i) {
            int b;
            if (repeatCount > 0) {
                --repeatCount;
                if (isNull != null) {
                    isNull[i] = isNull[i - 1];
                }
                arr[i] = arr[i - 1];
                continue;
            }
            if (((b = buffer[index++] & 0xFF) & 0xF0) == 112) {
                if ((b & 8) == 0) {
                    repeatCount = (b & 7) + 1;
                } else {
                    int b2 = buffer[index++] & 0xFF;
                    repeatCount = ((b & 7) << 8) + b2 + 1;
                }
                b = buffer[index++] & 0xFF;
            }
            if (b == 0) {
                if (isNull == null) {
                    isNull = new boolean[count + 1];
                }
                isNull[i] = true;
                continue;
            }
            if (b == 16) {
                int n = (buffer[index] & 0xFF) << 8 | buffer[index + 1] & 0xFF;
                index += 2;
                arr[i] = n;
                continue;
            }
            if (b == 17) {
                arr[i] = buffer[index] << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
                index += 4;
                continue;
            }
            int mask = b & 0xF0;
            if (mask == 128) {
                arr[i] = b & 0xF;
                continue;
            }
            if (mask == 144) {
                arr[i] = (b & 0xF) << 8 | buffer[index++] & 0xFF;
                continue;
            }
            throw new RuntimeException();
        }
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$16(BufferReader reader, int count) throws IOException {
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        boolean[] isNull = null;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        int repeatCount = reader.repeatCount;
        for (int i = 1; i <= count; ++i) {
            int b;
            if (repeatCount > 0) {
                --repeatCount;
                if (isNull != null) {
                    isNull[i] = isNull[i - 1];
                }
                arr[i] = arr[i - 1];
                continue;
            }
            if (((b = buffer[index++] & 0xFF) & 0xF0) == 112) {
                if ((b & 8) == 0) {
                    repeatCount = (b & 7) + 1;
                } else {
                    int b2 = buffer[index++] & 0xFF;
                    repeatCount = ((b & 7) << 8) + b2 + 1;
                }
                b = buffer[index++] & 0xFF;
            }
            if (b == 0) {
                if (isNull == null) {
                    isNull = new boolean[count + 1];
                }
                isNull[i] = true;
                continue;
            }
            if (b == 16) {
                arr[i] = ((buffer[index] & 0xFF) << 8) + (buffer[index + 1] & 0xFF);
                index += 2;
                continue;
            }
            if (b == 17) {
                arr[i] = (buffer[index] << 24) + ((buffer[index + 1] & 0xFF) << 16) + ((buffer[index + 2] & 0xFF) << 8) + (buffer[index + 3] & 0xFF);
                index += 4;
                continue;
            }
            int mask = b & 0xF0;
            if (mask == 128) {
                arr[i] = b & 0xF;
                continue;
            }
            if (mask == 144) {
                arr[i] = ((b & 0xF) << 8) + (buffer[index++] & 0xFF);
                continue;
            }
            if (b == 3) {
                arr[i] = 0L;
                continue;
            }
            if (b == 18) {
                arr[i] = ((buffer[index] & 0xFF) << 8) + (buffer[index + 1] & 0xFF);
                index += 2;
                continue;
            }
            if (b == 19) {
                arr[i] = (buffer[index] << 24) + ((buffer[index + 1] & 0xFF) << 16) + ((buffer[index + 2] & 0xFF) << 8) + (buffer[index + 3] & 0xFF);
                index += 4;
                continue;
            }
            if (b == 20) {
                arr[i] = ((long)buffer[index] << 56) + ((long)(buffer[index + 1] & 0xFF) << 48) + ((long)(buffer[index + 2] & 0xFF) << 40) + ((long)(buffer[index + 3] & 0xFF) << 32) + ((long)(buffer[index + 4] & 0xFF) << 24) + (long)((buffer[index + 5] & 0xFF) << 16) + (long)((buffer[index + 6] & 0xFF) << 8) + (long)(buffer[index + 7] & 0xFF);
                index += 8;
                continue;
            }
            throw new RuntimeException();
        }
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$15(BufferReader reader, int count) throws IOException {
        DoubleArray array = new DoubleArray(count);
        double[] arr = array.getDatas();
        boolean[] isNull = null;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        int repeatCount = reader.repeatCount;
        for (int i = 1; i <= count; ++i) {
            int scale;
            int b;
            if (repeatCount > 0) {
                --repeatCount;
                if (isNull != null) {
                    isNull[i] = isNull[i - 1];
                }
                arr[i] = arr[i - 1];
                continue;
            }
            if (((b = buffer[index++] & 0xFF) & 0xF0) == 112) {
                if ((b & 8) == 0) {
                    repeatCount = (b & 7) + 1;
                } else {
                    int b2 = buffer[index++] & 0xFF;
                    repeatCount = ((b & 7) << 8) + b2 + 1;
                }
                b = buffer[index++] & 0xFF;
            }
            if (b == 0) {
                if (isNull == null) {
                    isNull = new boolean[count + 1];
                }
                isNull[i] = true;
                continue;
            }
            if (b == 4) {
                arr[i] = 0.0;
                continue;
            }
            if (b == 21) {
                scale = buffer[index] & 0xC0;
                if (scale == 0) {
                    int n = (buffer[index] & 0xFF) << 8 | buffer[index + 1] & 0xFF;
                    index += 2;
                    arr[i] = n;
                    continue;
                }
                int n = (buffer[index] & 0x3F) << 8 | buffer[index + 1] & 0xFF;
                index += 2;
                if (scale == 64) {
                    arr[i] = (double)n / 100.0;
                    continue;
                }
                if (scale == 128) {
                    arr[i] = (double)n / 10000.0;
                    continue;
                }
                arr[i] = (double)n * 100.0;
                continue;
            }
            if (b == 22) {
                scale = buffer[index] & 0xC0;
                if (scale == 0) {
                    double d = buffer[index] << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
                    index += 4;
                    arr[i] = d;
                    continue;
                }
                int n = (buffer[index] & 0x3F) << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
                index += 4;
                if (scale == 64) {
                    arr[i] = (double)n / 100.0;
                    continue;
                }
                if (scale == 128) {
                    arr[i] = (double)n / 10000.0;
                    continue;
                }
                arr[i] = (double)n * 100.0;
                continue;
            }
            if (b == 23) {
                long l64 = (long)buffer[index] << 56 | (long)(buffer[index + 1] & 0xFF) << 48 | (long)(buffer[index + 2] & 0xFF) << 40 | (long)(buffer[index + 3] & 0xFF) << 32 | (long)(buffer[index + 4] & 0xFF) << 24 | (long)((buffer[index + 5] & 0xFF) << 16) | (long)((buffer[index + 6] & 0xFF) << 8) | (long)(buffer[index + 7] & 0xFF);
                index += 8;
                arr[i] = Double.longBitsToDouble(l64);
                continue;
            }
            throw new RuntimeException();
        }
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$14(BufferReader reader, int count) throws IOException {
        DateArray array = new DateArray(count);
        Date[] arr = array.getDatas();
        for (int i = 1; i <= count; ++i) {
            arr[i] = (Date)reader.readObject();
        }
        array.setSize(count);
        return array;
    }

    private static IArray _$13(BufferReader reader, int count) throws IOException {
        int i;
        SerialBytesArray array = new SerialBytesArray(count);
        long[] arr1 = array.getDatas1();
        long[] arr2 = array.getDatas2();
        int index = reader.index;
        byte[] buffer = reader.buffer;
        for (i = 1; i <= count; ++i) {
            arr1[i] = ((long)buffer[index] << 56) + ((long)(buffer[index + 1] & 0xFF) << 48) + ((long)(buffer[index + 2] & 0xFF) << 40) + ((long)(buffer[index + 3] & 0xFF) << 32) + ((long)(buffer[index + 4] & 0xFF) << 24) + (long)((buffer[index + 5] & 0xFF) << 16) + (long)((buffer[index + 6] & 0xFF) << 8) + (long)(buffer[index + 7] & 0xFF);
            arr2[i] = ((long)buffer[index += 8] << 56) + ((long)(buffer[index + 1] & 0xFF) << 48) + ((long)(buffer[index + 2] & 0xFF) << 40) + ((long)(buffer[index + 3] & 0xFF) << 32) + ((long)(buffer[index + 4] & 0xFF) << 24) + (long)((buffer[index + 5] & 0xFF) << 16) + (long)((buffer[index + 6] & 0xFF) << 8) + (long)(buffer[index + 7] & 0xFF);
            index += 8;
        }
        if (buffer[index++] != 0) {
            for (i = 1; i <= count; ++i) {
                if (buffer[index++] == 0) continue;
                array.set(i, null);
            }
        }
        array.setSize(count);
        return array;
    }

    private static IArray _$12(BufferReader reader, int count) throws IOException {
        StringArray array = new StringArray(count);
        String[] arr = array.getDatas();
        for (int i = 1; i <= count; ++i) {
            arr[i] = (String)reader.readObject();
        }
        array.setSize(count);
        return array;
    }

    private static IArray _$11(BufferReader reader, int count) throws IOException {
        StringArray array = new StringArray(count);
        String[] arr = array.getDatas();
        int idx = reader.index;
        byte[] buf = reader.buffer;
        byte[] len = new byte[count + 1];
        System.arraycopy(buf, idx, len, 1, count);
        idx += count;
        for (int i = 1; i <= count; ++i) {
            arr[i] = new String(buf, idx, (int)len[i]);
            idx += len[i];
        }
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$10(BufferReader reader, int count) throws IOException {
        ByteBufferArray array = new ByteBufferArray(reader.buffer, count);
        int[] pos = array.getPos();
        byte[] len = array.getLen();
        int index = reader.index;
        byte[] buffer = reader.buffer;
        System.arraycopy(buffer, index, len, 1, count);
        int offset = index += count;
        for (int i = 1; i <= count; ++i) {
            pos[i] = offset;
            offset += len[i];
        }
        array.setSize(count);
        return array;
    }

    private static IArray _$9(BufferReader reader, int count) throws IOException {
        int i;
        IntArray array = new IntArray(count);
        int[] arr = array.getDatas();
        boolean[] isNull = null;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        for (i = 1; i <= count; ++i) {
            arr[i] = buffer[index++];
        }
        if (buffer[index++] != 0) {
            isNull = new boolean[count + 1];
            for (i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
        }
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$8(BufferReader reader, int count) throws IOException {
        IntArray array = new IntArray(count);
        int[] arr = array.getDatas();
        boolean[] isNull = null;
        byte[] buffer = reader.buffer;
        int index = reader.index - 1;
        BufferUtilNormal.parseShort((byte[])buffer, (int)index, (int[])arr, (int)(count + 1));
        index += (count + 1) * 2;
        if (buffer[index++] != 0) {
            isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
        }
        arr[0] = 0;
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$7(BufferReader reader, int count) throws IOException {
        IntArray array = new IntArray(count);
        int[] arr = array.getDatas();
        boolean[] isNull = null;
        byte[] buffer = DataBlockReader._$1(reader);
        BufferUtilNormal.parseInt((byte[])buffer, (int[])arr, (int)(count + 1));
        int index = (count + 1) * 4;
        if (buffer[index++] != 0) {
            isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        arr[0] = 0;
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$6(BufferReader reader, int count) throws IOException {
        int i;
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        boolean[] isNull = null;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        for (i = 1; i <= count; ++i) {
            arr[i] = buffer[index++];
        }
        if (buffer[index++] != 0) {
            isNull = new boolean[count + 1];
            for (i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
        }
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$5(BufferReader reader, int count) throws IOException {
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        boolean[] isNull = null;
        byte[] buffer = DataBlockReader._$1(reader);
        BufferUtilNormal.parseShort((byte[])buffer, (long[])arr, (int)(count + 1));
        int index = (count + 1) * 2;
        if (buffer[index++] != 0) {
            isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
        }
        arr[0] = 0L;
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$4(BufferReader reader, int count) throws IOException {
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        boolean[] isNull = null;
        byte[] buffer = DataBlockReader._$1(reader);
        BufferUtilNormal.parseInt((byte[])buffer, (long[])arr, (int)(count + 1));
        int index = (count + 1) * 4;
        if (buffer[index++] != 0) {
            isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        arr[0] = 0L;
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$3(BufferReader reader, int count) throws IOException {
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        boolean[] isNull = null;
        byte[] buffer = DataBlockReader._$1(reader);
        BufferUtilNormal.parseLong((byte[])buffer, (long[])arr, (int)(count + 1));
        int index = (count + 1) * 8;
        if (buffer[index++] != 0) {
            isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        arr[0] = 0L;
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$2(BufferReader reader, int count) throws IOException {
        DoubleArray array = new DoubleArray(count);
        double[] arr = array.getDatas();
        boolean[] isNull = null;
        byte[] buffer = DataBlockReader._$1(reader);
        BufferUtilNormal.parseDouble((byte[])buffer, (double[])arr, (int)(count + 1));
        int index = (count + 1) * 8;
        if (buffer[index++] != 0) {
            isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        arr[0] = 0.0;
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$1(BufferReader reader, ColumnMetaData column, int count) throws IOException {
        ObjectArray array;
        int blockType;
        Object dictArray;
        Object columnDict = column.getDictArray();
        if (reader.read() == 0) {
            dictArray = columnDict;
            blockType = reader.read();
            if (column.getDataType() != blockType) {
                dictArray = DataBlockType.dictToArray((Sequence)column.getDict(), (int)blockType);
            }
        } else {
            Sequence dict = (Sequence)reader.readObject();
            blockType = reader.read();
            dictArray = DataBlockType.dictToArray((Sequence)dict, (int)blockType);
        }
        boolean isConst = reader.readBoolean();
        int constPos = 0;
        if (isConst) {
            constPos = reader.read();
        }
        int index = reader.index;
        byte[] buffer = reader.buffer;
        if (blockType == 0) {
            blockType = column.getDataType();
        }
        switch (blockType) {
            case 126: {
                array = DataBlockReader._$1((Object[])dictArray, index, buffer, isConst, constPos, count);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                array = DataBlockReader._$1((int[])dictArray, index, buffer, isConst, constPos, count);
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 40: {
                array = DataBlockReader._$1((long[])dictArray, index, buffer, isConst, constPos, count);
                break;
            }
            case 48: 
            case 56: {
                array = DataBlockReader._$1((double[])dictArray, index, buffer, isConst, constPos, count);
                break;
            }
            case 64: {
                array = DataBlockReader._$1((Date[])dictArray, index, buffer, isConst, constPos, count);
                break;
            }
            case 80: 
            case 81: {
                array = DataBlockReader._$1((String[])dictArray, index, buffer, isConst, constPos, count);
                break;
            }
            case 70: {
                array = DataBlockReader._$1((SerialBytes[])dictArray, index, buffer, isConst, constPos, count);
                break;
            }
            default: {
                array = DataBlockReader._$1((Object[])dictArray, index, buffer, isConst, constPos, count);
            }
        }
        array.setSize(count);
        return array;
    }

    public static IArray readArray(BufferReader reader, ColumnMetaData column, IArray match, int count) throws IOException {
        IArray array;
        boolean[] matchArray = match instanceof BoolArray && ((BoolArray)match).getSigns() == null ? ((BoolArray)match).getDatas() : match.isTrue().getDatas();
        byte blockType = reader.readByte();
        switch (blockType) {
            case 126: {
                return DataBlockReader._$15(reader, matchArray, count);
            }
            case 0: {
                array = new ObjectArray(count);
                array.setSize(count);
                break;
            }
            case 16: {
                array = DataBlockReader._$14(reader, matchArray, count);
                break;
            }
            case 32: {
                array = DataBlockReader._$13(reader, matchArray, count);
                break;
            }
            case 48: {
                array = DataBlockReader._$12(reader, matchArray, count);
                break;
            }
            case 64: {
                array = DataBlockReader._$11(reader, matchArray, count);
                break;
            }
            case 17: {
                array = DataBlockReader._$9(reader, count);
                break;
            }
            case 18: {
                array = DataBlockReader._$7(reader, matchArray, count);
                break;
            }
            case 20: {
                array = DataBlockReader._$6(reader, matchArray, count);
                break;
            }
            case 33: {
                array = DataBlockReader._$6(reader, count);
                break;
            }
            case 34: {
                array = DataBlockReader._$5(reader, matchArray, count);
                break;
            }
            case 36: {
                array = DataBlockReader._$4(reader, matchArray, count);
                break;
            }
            case 40: {
                array = DataBlockReader._$3(reader, matchArray, count);
                break;
            }
            case 56: {
                array = DataBlockReader._$2(reader, matchArray, count);
                break;
            }
            case 70: {
                array = DataBlockReader._$10(reader, matchArray, count);
                break;
            }
            case 80: {
                array = DataBlockReader._$9(reader, matchArray, count);
                break;
            }
            case 81: {
                array = DataBlockReader._$8(reader, matchArray, count);
                break;
            }
            case 127: {
                array = DataBlockReader._$1(reader, column, matchArray, count);
                break;
            }
            case 3: {
                array = DataBlockReader._$1(reader, matchArray, count);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (column.getDataType() == 126) {
            return array.toObjectArray();
        }
        return array;
    }

    private static IArray _$15(BufferReader reader, boolean[] match, int count) throws IOException {
        ObjectArray array = new ObjectArray(count);
        Object[] arr = array.getDatas();
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = reader.readObject();
                continue;
            }
            reader.skipObject();
        }
        array.setSize(count);
        return array;
    }

    private static IArray _$14(BufferReader reader, boolean[] matchArray, int count) throws IOException {
        IntArray array = new IntArray(count);
        int[] arr = array.getDatas();
        boolean[] isNull = null;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        int repeatCount = reader.repeatCount;
        for (int i = 1; i <= count; ++i) {
            int b;
            if (repeatCount > 0) {
                --repeatCount;
                if (isNull != null) {
                    isNull[i] = isNull[i - 1];
                }
                arr[i] = arr[i - 1];
                continue;
            }
            boolean match = matchArray[i];
            if (((b = buffer[index++] & 0xFF) & 0xF0) == 112) {
                match = true;
                if ((b & 8) == 0) {
                    repeatCount = (b & 7) + 1;
                } else {
                    int b2 = buffer[index++] & 0xFF;
                    repeatCount = ((b & 7) << 8) + b2 + 1;
                }
                b = buffer[index++] & 0xFF;
            }
            if (b == 0) {
                if (isNull == null) {
                    isNull = new boolean[count + 1];
                }
                isNull[i] = true;
                continue;
            }
            if (b == 16) {
                if (match) {
                    arr[i] = (buffer[index] & 0xFF) << 8 | buffer[index + 1] & 0xFF;
                }
                index += 2;
                continue;
            }
            if (b == 17) {
                if (match) {
                    arr[i] = buffer[index] << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
                }
                index += 4;
                continue;
            }
            int mask = b & 0xF0;
            if (mask == 128) {
                arr[i] = b & 0xF;
                continue;
            }
            if (mask == 144) {
                if (match) {
                    arr[i] = (b & 0xF) << 8 | buffer[index] & 0xFF;
                }
                ++index;
                continue;
            }
            throw new RuntimeException();
        }
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$13(BufferReader reader, boolean[] matchArray, int count) throws IOException {
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        boolean[] isNull = null;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        int repeatCount = reader.repeatCount;
        for (int i = 1; i <= count; ++i) {
            int b;
            boolean match = matchArray[i];
            if (repeatCount > 0) {
                --repeatCount;
                if (isNull != null) {
                    isNull[i] = isNull[i - 1];
                }
                arr[i] = arr[i - 1];
                continue;
            }
            if (((b = buffer[index++] & 0xFF) & 0xF0) == 112) {
                match = true;
                if ((b & 8) == 0) {
                    repeatCount = (b & 7) + 1;
                } else {
                    int b2 = buffer[index++] & 0xFF;
                    repeatCount = ((b & 7) << 8) + b2 + 1;
                }
                b = buffer[index++] & 0xFF;
            }
            if (b == 0) {
                if (isNull == null) {
                    isNull = new boolean[count + 1];
                }
                isNull[i] = true;
                continue;
            }
            if (b == 16) {
                if (match) {
                    arr[i] = ((buffer[index] & 0xFF) << 8) + (buffer[index + 1] & 0xFF);
                }
                index += 2;
                continue;
            }
            if (b == 17) {
                if (match) {
                    arr[i] = (buffer[index] << 24) + ((buffer[index + 1] & 0xFF) << 16) + ((buffer[index + 2] & 0xFF) << 8) + (buffer[index + 3] & 0xFF);
                }
                index += 4;
                continue;
            }
            int mask = b & 0xF0;
            if (mask == 128) {
                arr[i] = b & 0xF;
                continue;
            }
            if (mask == 144) {
                if (match) {
                    arr[i] = ((b & 0xF) << 8) + (buffer[index] & 0xFF);
                }
                ++index;
                continue;
            }
            if (b == 3) {
                arr[i] = 0L;
                continue;
            }
            if (b == 18) {
                if (match) {
                    arr[i] = ((buffer[index] & 0xFF) << 8) + (buffer[index + 1] & 0xFF);
                }
                index += 2;
                continue;
            }
            if (b == 19) {
                if (match) {
                    arr[i] = (buffer[index] << 24) + ((buffer[index + 1] & 0xFF) << 16) + ((buffer[index + 2] & 0xFF) << 8) + (buffer[index + 3] & 0xFF);
                }
                index += 4;
                continue;
            }
            if (b == 20) {
                if (match) {
                    arr[i] = ((long)buffer[index] << 56) + ((long)(buffer[index + 1] & 0xFF) << 48) + ((long)(buffer[index + 2] & 0xFF) << 40) + ((long)(buffer[index + 3] & 0xFF) << 32) + ((long)(buffer[index + 4] & 0xFF) << 24) + (long)((buffer[index + 5] & 0xFF) << 16) + (long)((buffer[index + 6] & 0xFF) << 8) + (long)(buffer[index + 7] & 0xFF);
                }
                index += 8;
                continue;
            }
            throw new RuntimeException();
        }
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$12(BufferReader reader, boolean[] matchArray, int count) throws IOException {
        DoubleArray array = new DoubleArray(count);
        double[] arr = array.getDatas();
        boolean[] isNull = null;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        int repeatCount = reader.repeatCount;
        for (int i = 1; i <= count; ++i) {
            int scale;
            int b;
            boolean match = matchArray[i];
            if (repeatCount > 0) {
                --repeatCount;
                if (isNull != null) {
                    isNull[i] = isNull[i - 1];
                }
                arr[i] = arr[i - 1];
                continue;
            }
            if (((b = buffer[index++] & 0xFF) & 0xF0) == 112) {
                match = true;
                if ((b & 8) == 0) {
                    repeatCount = (b & 7) + 1;
                } else {
                    int b2 = buffer[index++] & 0xFF;
                    repeatCount = ((b & 7) << 8) + b2 + 1;
                }
                b = buffer[index++] & 0xFF;
            }
            if (b == 0) {
                if (isNull == null) {
                    isNull = new boolean[count + 1];
                }
                isNull[i] = true;
                continue;
            }
            if (b == 4) {
                arr[i] = 0.0;
                continue;
            }
            if (b == 21) {
                if (!match) {
                    index += 2;
                    continue;
                }
                scale = buffer[index] & 0xC0;
                if (scale == 0) {
                    int n = (buffer[index] & 0xFF) << 8 | buffer[index + 1] & 0xFF;
                    index += 2;
                    arr[i] = n;
                    continue;
                }
                int n = (buffer[index] & 0x3F) << 8 | buffer[index + 1] & 0xFF;
                index += 2;
                if (scale == 64) {
                    arr[i] = (double)n / 100.0;
                    continue;
                }
                if (scale == 128) {
                    arr[i] = (double)n / 10000.0;
                    continue;
                }
                arr[i] = (double)n * 100.0;
                continue;
            }
            if (b == 22) {
                if (!match) {
                    index += 4;
                    continue;
                }
                scale = buffer[index] & 0xC0;
                if (scale == 0) {
                    double d = buffer[index] << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
                    index += 4;
                    arr[i] = d;
                    continue;
                }
                int n = (buffer[index] & 0x3F) << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
                index += 4;
                if (scale == 64) {
                    arr[i] = (double)n / 100.0;
                    continue;
                }
                if (scale == 128) {
                    arr[i] = (double)n / 10000.0;
                    continue;
                }
                arr[i] = (double)n * 100.0;
                continue;
            }
            if (b == 23) {
                if (!match) {
                    index += 8;
                    continue;
                }
                long l64 = (long)buffer[index] << 56 | (long)(buffer[index + 1] & 0xFF) << 48 | (long)(buffer[index + 2] & 0xFF) << 40 | (long)(buffer[index + 3] & 0xFF) << 32 | (long)(buffer[index + 4] & 0xFF) << 24 | (long)((buffer[index + 5] & 0xFF) << 16) | (long)((buffer[index + 6] & 0xFF) << 8) | (long)(buffer[index + 7] & 0xFF);
                index += 8;
                arr[i] = Double.longBitsToDouble(l64);
                continue;
            }
            throw new RuntimeException();
        }
        array.setSize(count);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$11(BufferReader reader, boolean[] match, int count) throws IOException {
        DateArray array = new DateArray(count);
        Date[] arr = array.getDatas();
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = (Date)reader.readObject();
                continue;
            }
            reader.skipObject();
        }
        array.setSize(count);
        return array;
    }

    private static IArray _$10(BufferReader reader, boolean[] match, int count) throws IOException {
        int i;
        SerialBytesArray array = new SerialBytesArray(count);
        long[] arr1 = array.getDatas1();
        long[] arr2 = array.getDatas2();
        int index = reader.index;
        byte[] buffer = reader.buffer;
        for (i = 1; i <= count; ++i) {
            if (match[i]) {
                arr1[i] = ((long)buffer[index] << 56) + ((long)(buffer[index + 1] & 0xFF) << 48) + ((long)(buffer[index + 2] & 0xFF) << 40) + ((long)(buffer[index + 3] & 0xFF) << 32) + ((long)(buffer[index + 4] & 0xFF) << 24) + (long)((buffer[index + 5] & 0xFF) << 16) + (long)((buffer[index + 6] & 0xFF) << 8) + (long)(buffer[index + 7] & 0xFF);
                arr2[i] = ((long)buffer[index += 8] << 56) + ((long)(buffer[index + 1] & 0xFF) << 48) + ((long)(buffer[index + 2] & 0xFF) << 40) + ((long)(buffer[index + 3] & 0xFF) << 32) + ((long)(buffer[index + 4] & 0xFF) << 24) + (long)((buffer[index + 5] & 0xFF) << 16) + (long)((buffer[index + 6] & 0xFF) << 8) + (long)(buffer[index + 7] & 0xFF);
                index += 8;
                continue;
            }
            index += 16;
        }
        if (buffer[index++] != 0) {
            for (i = 1; i <= count; ++i) {
                if (buffer[index++] == 0) continue;
                array.set(i, null);
            }
        }
        array.setSize(count);
        return array;
    }

    private static IArray _$9(BufferReader reader, boolean[] match, int count) throws IOException {
        StringArray array = new StringArray(count);
        String[] arr = array.getDatas();
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = (String)reader.readObject();
                continue;
            }
            reader.skipObject();
        }
        array.setSize(count);
        return array;
    }

    private static IArray _$8(BufferReader reader, boolean[] match, int count) throws IOException {
        StringArray array = new StringArray(count);
        String[] arr = array.getDatas();
        int idx = reader.index;
        byte[] buf = reader.buffer;
        byte[] len = new byte[count + 1];
        System.arraycopy(buf, idx, len, 1, count);
        idx += count;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = new String(buf, idx, (int)len[i]);
            }
            idx += len[i];
        }
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$7(BufferReader reader, boolean[] match, int count) throws IOException {
        IntArray array = new IntArray(count);
        int[] arr = array.getDatas();
        byte[] buffer = reader.buffer;
        int offset = reader.index - 1 + 2;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = buffer[offset + 1] << 8 | buffer[offset] & 0xFF;
            }
            offset += 2;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$6(BufferReader reader, boolean[] match, int count) throws IOException {
        IntArray array = new IntArray(count);
        int[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int offset = 4;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = BufferUtilNormal.parseInt((byte[])buffer, (int)offset);
            }
            offset += 4;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$5(BufferReader reader, boolean[] match, int count) throws IOException {
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int offset = 2;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = BufferUtilNormal.parseShort((byte[])buffer, (int)offset);
            }
            offset += 2;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$4(BufferReader reader, boolean[] match, int count) throws IOException {
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int offset = 4;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = BufferUtilNormal.parseInt((byte[])buffer, (int)offset);
            }
            offset += 4;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$3(BufferReader reader, boolean[] match, int count) throws IOException {
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int offset = 8;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = BufferUtilNormal.parseLong((byte[])buffer, (int)offset);
            }
            offset += 8;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$2(BufferReader reader, boolean[] match, int count) throws IOException {
        DoubleArray array = new DoubleArray(count);
        double[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int offset = 8;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[i] = BufferUtilNormal.parseDouble((byte[])buffer, (int)offset);
            }
            offset += 8;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[count + 1];
            for (int i = 1; i <= count; ++i) {
                isNull[i] = buffer[index++] != 0;
            }
            array.setSigns(isNull);
        }
        array.setSize(count);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$1(BufferReader reader, ColumnMetaData column, boolean[] match, int count) throws IOException {
        ObjectArray array;
        int blockType;
        Object dictArray;
        Object columnDict = column.getDictArray();
        if (reader.read() == 0) {
            dictArray = columnDict;
            blockType = reader.read();
            if (column.getDataType() != blockType) {
                dictArray = DataBlockType.dictToArray((Sequence)column.getDict(), (int)blockType);
            }
        } else {
            Sequence dict = (Sequence)reader.readObject();
            blockType = reader.read();
            dictArray = DataBlockType.dictToArray((Sequence)dict, (int)blockType);
        }
        boolean isConst = reader.readBoolean();
        int constPos = 0;
        if (isConst) {
            constPos = reader.read();
        }
        int index = reader.index;
        byte[] buffer = reader.buffer;
        if (blockType == 0) {
            blockType = column.getDataType();
        }
        switch (blockType) {
            case 126: {
                array = DataBlockReader._$1((Object[])dictArray, index, buffer, isConst, constPos, match, count);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                array = DataBlockReader._$1((int[])dictArray, index, buffer, isConst, constPos, match, count);
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 40: {
                array = DataBlockReader._$1((long[])dictArray, index, buffer, isConst, constPos, match, count);
                break;
            }
            case 48: 
            case 56: {
                array = DataBlockReader._$1((double[])dictArray, index, buffer, isConst, constPos, match, count);
                break;
            }
            case 64: {
                array = DataBlockReader._$1((Date[])dictArray, index, buffer, isConst, constPos, match, count);
                break;
            }
            case 70: {
                array = DataBlockReader._$1((SerialBytes[])dictArray, index, buffer, isConst, constPos, match, count);
                break;
            }
            case 80: 
            case 81: {
                array = DataBlockReader._$1((String[])dictArray, index, buffer, isConst, constPos, match, count);
                break;
            }
            default: {
                array = DataBlockReader._$1((Object[])dictArray, index, buffer, isConst, constPos, match, count);
            }
        }
        array.setSize(count);
        return array;
    }

    public static IArray readSkipArray(BufferReader reader, ColumnMetaData column, IArray match, int count, int matchCount) throws IOException {
        ObjectArray array;
        if (count == matchCount) {
            return DataBlockReader.readArray(reader, column, count);
        }
        boolean[] matchArray = match.isTrue().getDatas();
        byte blockType = reader.readByte();
        switch (blockType) {
            case 126: {
                return DataBlockReader._$17(reader, matchArray, count, matchCount);
            }
            case 0: {
                array = new ObjectArray(matchCount);
                array.setSize(matchCount);
                break;
            }
            case 16: {
                array = DataBlockReader._$16(reader, matchArray, count, matchCount);
                break;
            }
            case 32: {
                array = DataBlockReader._$15(reader, matchArray, count, matchCount);
                break;
            }
            case 48: {
                array = DataBlockReader._$14(reader, matchArray, count, matchCount);
                break;
            }
            case 64: {
                array = DataBlockReader._$13(reader, matchArray, count, matchCount);
                break;
            }
            case 17: {
                array = DataBlockReader._$9(reader, matchArray, count, matchCount);
                break;
            }
            case 18: {
                array = DataBlockReader._$8(reader, matchArray, count, matchCount);
                break;
            }
            case 20: {
                array = DataBlockReader._$7(reader, matchArray, count, matchCount);
                break;
            }
            case 33: {
                array = DataBlockReader._$6(reader, matchArray, count, matchCount);
                break;
            }
            case 34: {
                array = DataBlockReader._$5(reader, matchArray, count, matchCount);
                break;
            }
            case 36: {
                array = DataBlockReader._$4(reader, matchArray, count, matchCount);
                break;
            }
            case 40: {
                array = DataBlockReader._$3(reader, matchArray, count, matchCount);
                break;
            }
            case 56: {
                array = DataBlockReader._$2(reader, matchArray, count, matchCount);
                break;
            }
            case 70: {
                array = DataBlockReader._$12(reader, matchArray, count, matchCount);
                break;
            }
            case 80: {
                array = DataBlockReader._$11(reader, matchArray, count, matchCount);
                break;
            }
            case 81: {
                array = DataBlockReader._$10(reader, matchArray, count, matchCount);
                break;
            }
            case 127: {
                array = DataBlockReader._$1(reader, column, matchArray, count, matchCount);
                break;
            }
            case 3: {
                array = DataBlockReader._$1(reader, matchArray, count, matchCount);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (column.getDataType() == 126) {
            return array.toObjectArray();
        }
        return array;
    }

    private static IArray _$17(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        ObjectArray array = new ObjectArray(matchCount);
        int offset = 1;
        Object[] arr = array.getDatas();
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[offset++] = reader.readObject();
                continue;
            }
            reader.skipObject();
        }
        array.setSize(matchCount);
        return array;
    }

    private static IArray _$16(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        IntArray array = new IntArray(matchCount);
        int[] arr = array.getDatas();
        boolean[] isNull = null;
        int offset = 1;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        int repeatCount = reader.repeatCount;
        Object repeatValue = reader.repeatValue;
        int repeatIntValue = 0;
        for (int i = 1; i <= count; ++i) {
            int b;
            if (repeatCount > 0) {
                --repeatCount;
                if (!match[i]) continue;
                if (repeatValue == null) {
                    if (isNull == null) {
                        isNull = new boolean[matchCount + 1];
                    }
                    isNull[offset++] = true;
                    continue;
                }
                arr[offset++] = repeatIntValue;
                continue;
            }
            if ((b = buffer[index++] & 0xFF) == 0) {
                if (!match[i]) continue;
                if (isNull == null) {
                    isNull = new boolean[matchCount + 1];
                }
                isNull[offset++] = true;
                continue;
            }
            if (b == 16) {
                if (match[i]) {
                    int n = (buffer[index] & 0xFF) << 8 | buffer[index + 1] & 0xFF;
                    index += 2;
                    arr[offset++] = n;
                    continue;
                }
                index += 2;
                continue;
            }
            if (b == 17) {
                if (match[i]) {
                    arr[offset++] = buffer[index] << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
                }
                index += 4;
                continue;
            }
            int mask = b & 0xF0;
            if (mask == 128) {
                if (!match[i]) continue;
                arr[offset++] = b & 0xF;
                continue;
            }
            if (mask == 144) {
                if (match[i]) {
                    arr[offset++] = (b & 0xF) << 8 | buffer[index++] & 0xFF;
                    continue;
                }
                ++index;
                continue;
            }
            if (mask == 112) {
                reader.index = index;
                Object d = reader.readRepeat(b);
                index = reader.index;
                repeatCount = reader.repeatCount;
                repeatValue = reader.repeatValue;
                if (match[i]) {
                    if (d == null) {
                        if (isNull == null) {
                            isNull = new boolean[matchCount + 1];
                        }
                        isNull[offset++] = true;
                        continue;
                    }
                    int n = offset++;
                    int n2 = (Integer)d;
                    arr[n] = n2;
                    repeatIntValue = n2;
                    continue;
                }
                if (d == null) continue;
                repeatIntValue = (Integer)d;
                continue;
            }
            throw new RuntimeException();
        }
        array.setSize(matchCount);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$15(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        LongArray array = new LongArray(matchCount);
        long[] arr = array.getDatas();
        boolean[] isNull = null;
        int offset = 1;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        int repeatCount = reader.repeatCount;
        Object repeatValue = reader.repeatValue;
        long repeatLongValue = 0L;
        for (int i = 1; i <= count; ++i) {
            int b;
            if (repeatCount > 0) {
                --repeatCount;
                if (!match[i]) continue;
                if (repeatValue == null) {
                    if (isNull == null) {
                        isNull = new boolean[matchCount + 1];
                    }
                    isNull[offset++] = true;
                    continue;
                }
                arr[offset++] = repeatLongValue;
                continue;
            }
            if ((b = buffer[index++] & 0xFF) == 0) {
                if (!match[i]) continue;
                if (isNull == null) {
                    isNull = new boolean[matchCount + 1];
                }
                isNull[offset++] = true;
                continue;
            }
            if (b == 16) {
                if (match[i]) {
                    arr[offset++] = ((buffer[index] & 0xFF) << 8) + (buffer[index + 1] & 0xFF);
                }
                index += 2;
                continue;
            }
            if (b == 17) {
                if (match[i]) {
                    arr[offset++] = (buffer[index] << 24) + ((buffer[index + 1] & 0xFF) << 16) + ((buffer[index + 2] & 0xFF) << 8) + (buffer[index + 3] & 0xFF);
                }
                index += 4;
                continue;
            }
            int mask = b & 0xF0;
            if (mask == 128) {
                if (!match[i]) continue;
                arr[offset++] = b & 0xF;
                continue;
            }
            if (mask == 144) {
                if (match[i]) {
                    arr[offset++] = ((b & 0xF) << 8) + (buffer[index] & 0xFF);
                }
                ++index;
                continue;
            }
            if (b == 3) {
                if (!match[i]) continue;
                arr[offset++] = 0L;
                continue;
            }
            if (b == 18) {
                if (match[i]) {
                    arr[offset++] = ((buffer[index] & 0xFF) << 8) + (buffer[index + 1] & 0xFF);
                }
                index += 2;
                continue;
            }
            if (b == 19) {
                if (match[i]) {
                    arr[offset++] = (buffer[index] << 24) + ((buffer[index + 1] & 0xFF) << 16) + ((buffer[index + 2] & 0xFF) << 8) + (buffer[index + 3] & 0xFF);
                }
                index += 4;
                continue;
            }
            if (b == 20) {
                if (match[i]) {
                    arr[offset++] = ((long)buffer[index] << 56) + ((long)(buffer[index + 1] & 0xFF) << 48) + ((long)(buffer[index + 2] & 0xFF) << 40) + ((long)(buffer[index + 3] & 0xFF) << 32) + ((long)(buffer[index + 4] & 0xFF) << 24) + (long)((buffer[index + 5] & 0xFF) << 16) + (long)((buffer[index + 6] & 0xFF) << 8) + (long)(buffer[index + 7] & 0xFF);
                }
                index += 8;
                continue;
            }
            if ((b & 0xF0) == 112) {
                reader.index = index;
                Object d = reader.readRepeat(b);
                index = reader.index;
                repeatCount = reader.repeatCount;
                repeatValue = reader.repeatValue;
                if (match[i]) {
                    if (d == null) {
                        if (isNull == null) {
                            isNull = new boolean[matchCount + 1];
                        }
                        isNull[offset++] = true;
                        continue;
                    }
                    int n = offset++;
                    long l = (Long)d;
                    arr[n] = l;
                    repeatLongValue = l;
                    continue;
                }
                if (d == null) continue;
                repeatLongValue = (Long)d;
                continue;
            }
            throw new RuntimeException();
        }
        array.setSize(matchCount);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$14(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        DoubleArray array = new DoubleArray(matchCount);
        double[] arr = array.getDatas();
        boolean[] isNull = null;
        int offset = 1;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        int repeatCount = reader.repeatCount;
        Object repeatValue = reader.repeatValue;
        double repeatDoubleValue = 0.0;
        for (int i = 1; i <= count; ++i) {
            int b;
            if (repeatCount > 0) {
                --repeatCount;
                if (!match[i]) continue;
                if (repeatValue == null) {
                    if (isNull == null) {
                        isNull = new boolean[matchCount + 1];
                    }
                    isNull[offset++] = true;
                    continue;
                }
                arr[offset++] = repeatDoubleValue;
                continue;
            }
            if ((b = buffer[index++] & 0xFF) == 0) {
                if (!match[i]) continue;
                if (isNull == null) {
                    isNull = new boolean[matchCount + 1];
                }
                isNull[offset++] = true;
                continue;
            }
            if (b == 4) {
                if (!match[i]) continue;
                arr[offset++] = 0.0;
                continue;
            }
            if (b == 21) {
                if (!match[i]) {
                    index += 2;
                    continue;
                }
                int scale = buffer[index] & 0xC0;
                if (scale == 0) {
                    int n = (buffer[index] & 0xFF) << 8 | buffer[index + 1] & 0xFF;
                    index += 2;
                    arr[offset++] = n;
                    continue;
                }
                int n = (buffer[index] & 0x3F) << 8 | buffer[index + 1] & 0xFF;
                index += 2;
                if (scale == 64) {
                    arr[offset++] = (double)n / 100.0;
                    continue;
                }
                if (scale == 128) {
                    arr[offset++] = (double)n / 10000.0;
                    continue;
                }
                arr[offset++] = (double)n * 100.0;
                continue;
            }
            if (b == 22) {
                if (!match[i]) {
                    index += 4;
                    continue;
                }
                int scale = buffer[index] & 0xC0;
                if (scale == 0) {
                    double d = buffer[index] << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
                    index += 4;
                    arr[offset++] = d;
                    continue;
                }
                int n = (buffer[index] & 0x3F) << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
                index += 4;
                if (scale == 64) {
                    arr[offset++] = (double)n / 100.0;
                    continue;
                }
                if (scale == 128) {
                    arr[offset++] = (double)n / 10000.0;
                    continue;
                }
                arr[offset++] = (double)n * 100.0;
                continue;
            }
            if (b == 23) {
                if (!match[i]) {
                    index += 8;
                    continue;
                }
                long l64 = (long)buffer[index] << 56 | (long)(buffer[index + 1] & 0xFF) << 48 | (long)(buffer[index + 2] & 0xFF) << 40 | (long)(buffer[index + 3] & 0xFF) << 32 | (long)(buffer[index + 4] & 0xFF) << 24 | (long)((buffer[index + 5] & 0xFF) << 16) | (long)((buffer[index + 6] & 0xFF) << 8) | (long)(buffer[index + 7] & 0xFF);
                index += 8;
                arr[offset++] = Double.longBitsToDouble(l64);
                continue;
            }
            if ((b & 0xF0) == 112) {
                reader.index = index;
                Object d = reader.readRepeat(b);
                index = reader.index;
                repeatCount = reader.repeatCount;
                repeatValue = reader.repeatValue;
                if (match[i]) {
                    if (d == null) {
                        if (isNull == null) {
                            isNull = new boolean[matchCount + 1];
                        }
                        isNull[offset++] = true;
                        continue;
                    }
                    int n = offset++;
                    double d2 = (Double)d;
                    arr[n] = d2;
                    repeatDoubleValue = d2;
                    continue;
                }
                if (d == null) continue;
                repeatDoubleValue = (Double)d;
                continue;
            }
            throw new RuntimeException();
        }
        array.setSize(matchCount);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$13(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        int offset = 1;
        DateArray array = new DateArray(matchCount);
        Date[] arr = array.getDatas();
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[offset++] = (Date)reader.readObject();
                continue;
            }
            reader.skipObject();
        }
        array.setSize(matchCount);
        return array;
    }

    private static IArray _$12(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        int i;
        int offset = 1;
        SerialBytesArray array = new SerialBytesArray(matchCount);
        long[] arr1 = array.getDatas1();
        long[] arr2 = array.getDatas2();
        int index = reader.index;
        byte[] buffer = reader.buffer;
        for (i = 1; i <= count; ++i) {
            if (match[i]) {
                arr1[offset] = ((long)buffer[index] << 56) + ((long)(buffer[index + 1] & 0xFF) << 48) + ((long)(buffer[index + 2] & 0xFF) << 40) + ((long)(buffer[index + 3] & 0xFF) << 32) + ((long)(buffer[index + 4] & 0xFF) << 24) + (long)((buffer[index + 5] & 0xFF) << 16) + (long)((buffer[index + 6] & 0xFF) << 8) + (long)(buffer[index + 7] & 0xFF);
                arr2[offset] = ((long)buffer[index += 8] << 56) + ((long)(buffer[index + 1] & 0xFF) << 48) + ((long)(buffer[index + 2] & 0xFF) << 40) + ((long)(buffer[index + 3] & 0xFF) << 32) + ((long)(buffer[index + 4] & 0xFF) << 24) + (long)((buffer[index + 5] & 0xFF) << 16) + (long)((buffer[index + 6] & 0xFF) << 8) + (long)(buffer[index + 7] & 0xFF);
                index += 8;
                ++offset;
                continue;
            }
            index += 16;
        }
        if (buffer[index++] != 0) {
            offset = 1;
            for (i = 1; i <= count; ++i) {
                if (match[i]) {
                    if (buffer[index++] == 0) continue;
                    array.set(offset, null);
                    continue;
                }
                ++index;
            }
        }
        array.setSize(matchCount);
        return array;
    }

    private static IArray _$11(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        int offset = 1;
        StringArray array = new StringArray(matchCount);
        String[] arr = array.getDatas();
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[offset++] = (String)reader.readObject();
                continue;
            }
            reader.skipObject();
        }
        array.setSize(matchCount);
        return array;
    }

    private static IArray _$10(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        StringArray array = new StringArray(matchCount);
        String[] arr = array.getDatas();
        int idx = reader.index;
        byte[] buf = reader.buffer;
        byte[] len = new byte[count + 1];
        System.arraycopy(buf, idx, len, 1, count);
        idx += count;
        int offset = 1;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[offset++] = new String(buf, idx, (int)len[i]);
            }
            idx += len[i];
        }
        array.setSize(matchCount);
        return array;
    }

    private static IArray _$9(BufferReader reader, boolean[] match, int count, int matchCount) {
        int i;
        IntArray array = new IntArray(matchCount);
        int[] arr = array.getDatas();
        boolean[] isNull = null;
        int offset = 1;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        for (i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[offset++] = buffer[index++];
                continue;
            }
            ++index;
        }
        if (buffer[index++] != 0) {
            isNull = new boolean[matchCount + 1];
            offset = 1;
            for (i = 1; i <= count; ++i) {
                if (match[i]) {
                    isNull[offset++] = buffer[index++] != 0;
                    continue;
                }
                ++index;
            }
        }
        array.setSize(matchCount);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$8(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        IntArray array = new IntArray(matchCount);
        int[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int off = 1;
        int offset = 2;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[off++] = BufferUtilNormal.parseShort((byte[])buffer, (int)offset);
            }
            offset += 2;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[matchCount + 1];
            off = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    isNull[off++] = buffer[index++] != 0;
                    continue;
                }
                ++index;
            }
            array.setSigns(isNull);
        }
        array.setSize(matchCount);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$7(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        IntArray array = new IntArray(matchCount);
        int[] arr = array.getDatas();
        byte[] buffer = reader.buffer;
        int off = 1;
        int offset = reader.index - 1 + 4;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[off++] = (buffer[offset + 3] << 24) + ((buffer[offset + 2] & 0xFF) << 16) + ((buffer[offset + 1] & 0xFF) << 8) + (buffer[offset] & 0xFF);
            }
            offset += 4;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[matchCount + 1];
            off = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    isNull[off++] = buffer[index++] != 0;
                    continue;
                }
                ++index;
            }
            array.setSigns(isNull);
        }
        array.setSize(matchCount);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$6(BufferReader reader, boolean[] match, int count, int matchCount) {
        int i;
        LongArray array = new LongArray(matchCount);
        long[] arr = array.getDatas();
        boolean[] isNull = null;
        int offset = 1;
        int index = reader.index;
        byte[] buffer = reader.buffer;
        for (i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[offset++] = buffer[index++];
                continue;
            }
            ++index;
        }
        if (buffer[index++] != 0) {
            isNull = new boolean[matchCount + 1];
            offset = 1;
            for (i = 1; i <= count; ++i) {
                if (match[i]) {
                    isNull[offset++] = buffer[index++] != 0;
                    continue;
                }
                ++index;
            }
        }
        array.setSize(matchCount);
        array.setSigns(isNull);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$5(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        LongArray array = new LongArray(matchCount);
        long[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int off = 1;
        int offset = 2;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[off++] = BufferUtilNormal.parseShort((byte[])buffer, (int)offset);
            }
            offset += 2;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[matchCount + 1];
            off = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    isNull[off++] = buffer[index++] != 0;
                    continue;
                }
                ++index;
            }
            array.setSigns(isNull);
        }
        array.setSize(matchCount);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$4(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        LongArray array = new LongArray(matchCount);
        long[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int off = 1;
        int offset = 4;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[off++] = BufferUtilNormal.parseInt((byte[])buffer, (int)offset);
            }
            offset += 4;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[matchCount + 1];
            off = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    isNull[off++] = buffer[index++] != 0;
                    continue;
                }
                ++index;
            }
            array.setSigns(isNull);
        }
        array.setSize(matchCount);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$3(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        LongArray array = new LongArray(matchCount);
        long[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int off = 1;
        int offset = 8;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[off++] = BufferUtilNormal.parseLong((byte[])buffer, (int)offset);
            }
            offset += 8;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[matchCount + 1];
            off = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    isNull[off++] = buffer[index++] != 0;
                    continue;
                }
                ++index;
            }
            array.setSigns(isNull);
        }
        array.setSize(matchCount);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$2(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        DoubleArray array = new DoubleArray(matchCount);
        double[] arr = array.getDatas();
        byte[] buffer = DataBlockReader._$1(reader);
        int off = 1;
        int offset = 8;
        for (int i = 1; i <= count; ++i) {
            if (match[i]) {
                arr[off++] = BufferUtilNormal.parseDouble((byte[])buffer, (int)offset);
            }
            offset += 8;
        }
        int index = offset;
        if (buffer[index++] != 0) {
            boolean[] isNull = new boolean[matchCount + 1];
            off = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    isNull[off++] = buffer[index++] != 0;
                    continue;
                }
                ++index;
            }
            array.setSigns(isNull);
        }
        array.setSize(matchCount);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$1(BufferReader reader, ColumnMetaData column, boolean[] match, int count, int matchCount) throws IOException {
        ObjectArray array;
        int blockType;
        Object dictArray;
        Object columnDict = column.getDictArray();
        if (reader.read() == 0) {
            dictArray = columnDict;
            blockType = reader.read();
            if (column.getDataType() != blockType) {
                dictArray = DataBlockType.dictToArray((Sequence)column.getDict(), (int)blockType);
            }
        } else {
            Sequence dict = (Sequence)reader.readObject();
            blockType = reader.read();
            dictArray = DataBlockType.dictToArray((Sequence)dict, (int)blockType);
        }
        boolean isConst = reader.readBoolean();
        int constPos = 0;
        if (isConst) {
            constPos = reader.read();
        }
        int index = reader.index;
        byte[] buffer = reader.buffer;
        if (blockType == 0) {
            blockType = column.getDataType();
        }
        switch (blockType) {
            case 126: {
                array = DataBlockReader._$1((Object[])dictArray, index, buffer, isConst, constPos, match, matchCount, count);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                array = DataBlockReader._$1((int[])dictArray, index, buffer, isConst, constPos, match, matchCount, count);
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 40: {
                array = DataBlockReader._$1((long[])dictArray, index, buffer, isConst, constPos, match, matchCount, count);
                break;
            }
            case 48: 
            case 56: {
                array = DataBlockReader._$1((double[])dictArray, index, buffer, isConst, constPos, match, matchCount, count);
                break;
            }
            case 64: {
                array = DataBlockReader._$1((Date[])dictArray, index, buffer, isConst, constPos, match, matchCount, count);
                break;
            }
            case 70: {
                array = DataBlockReader._$1((SerialBytes[])dictArray, index, buffer, isConst, constPos, match, matchCount, count);
                break;
            }
            case 80: 
            case 81: {
                array = DataBlockReader._$1((String[])dictArray, index, buffer, isConst, constPos, match, matchCount, count);
                break;
            }
            default: {
                array = DataBlockReader._$1((Object[])dictArray, index, buffer, isConst, constPos, match, matchCount, count);
            }
        }
        return array;
    }

    private static IntArray _$1(int[] dict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        int[] array = new int[count + 1];
        boolean[] sign = null;
        int nullPos = dict[0];
        if (isConst) {
            if (constPos == dict[0]) {
                sign = new boolean[count + 1];
                Arrays.fill(sign, true);
            } else {
                Arrays.fill(array, dict[constPos]);
            }
        } else if (nullPos > 0) {
            for (int i = 1; i <= count; ++i) {
                byte pos;
                if ((pos = buffer[index++]) == nullPos) {
                    if (sign == null) {
                        sign = new boolean[count + 1];
                    }
                    sign[i] = true;
                    continue;
                }
                array[i] = dict[pos];
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                byte pos = buffer[index++];
                array[i] = dict[pos];
            }
        }
        return new IntArray(array, sign, count);
    }

    private static LongArray _$1(long[] dict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        long[] array = new long[count + 1];
        boolean[] sign = null;
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((long)constPos == dict[0]) {
                sign = new boolean[count + 1];
                Arrays.fill(sign, true);
            } else {
                Arrays.fill(array, dict[constPos]);
            }
        } else if (nullPos > 0) {
            for (int i = 1; i <= count; ++i) {
                byte pos;
                if ((pos = buffer[index++]) == nullPos) {
                    if (sign == null) {
                        sign = new boolean[count + 1];
                    }
                    sign[i] = true;
                    continue;
                }
                array[i] = dict[pos];
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                byte pos = buffer[index++];
                array[i] = dict[pos];
            }
        }
        return new LongArray(array, sign, count);
    }

    protected static DoubleArray readDoubleArrayByDict2(double[] dict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        boolean sign = false;
        byte[] posArr = new byte[count + 1];
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((double)constPos == dict[0]) {
                sign = true;
            } else {
                Arrays.fill(posArr, (byte)constPos);
                posArr[0] = 0;
            }
        } else if (nullPos > 0) {
            sign = true;
            for (int i = 1; i <= count; ++i) {
                byte pos;
                posArr[i] = (pos = buffer[index++]) == nullPos ? (byte)0 : pos;
            }
        } else {
            System.arraycopy(buffer, index, posArr, 1, count);
        }
        return new DoubleDictArray(dict, posArr, sign);
    }

    private static DoubleArray _$1(double[] dict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        double[] array = new double[count + 1];
        boolean[] sign = null;
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((double)constPos == dict[0]) {
                sign = new boolean[count + 1];
                Arrays.fill(sign, true);
            } else {
                double value = dict[constPos];
                for (int i = 1; i <= count; ++i) {
                    array[i] = value;
                }
            }
        } else if (nullPos > 0) {
            for (int i = 1; i <= count; ++i) {
                byte pos;
                if ((pos = buffer[index++]) == nullPos) {
                    if (sign == null) {
                        sign = new boolean[count + 1];
                    }
                    sign[i] = true;
                    continue;
                }
                array[i] = dict[pos];
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                byte pos = buffer[index++];
                array[i] = dict[pos];
            }
        }
        return new DoubleArray(array, sign, count);
    }

    private static DateArray _$1(Date[] dict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        Date[] array = new Date[count + 1];
        if (isConst) {
            Date value = dict[constPos];
            for (int i = 1; i <= count; ++i) {
                array[i] = value;
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                byte pos = buffer[index++];
                array[i] = dict[pos];
            }
        }
        return new DateArray(array, count);
    }

    private static StringArray _$1(String[] dict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        String[] array = new String[count + 1];
        if (isConst) {
            String value = dict[constPos];
            for (int i = 1; i <= count; ++i) {
                array[i] = value;
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                byte pos = buffer[index++];
                array[i] = dict[pos];
            }
        }
        return new StringArray(array, count);
    }

    private static SerialBytesArray _$1(SerialBytes[] dict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        long[] array1 = new long[count + 1];
        long[] array2 = new long[count + 1];
        if (isConst) {
            SerialBytes value = dict[constPos];
            if (value == null) {
                for (int i = 1; i <= count; ++i) {
                    array1[i] = 0L;
                    array2[i] = 0L;
                }
            } else {
                for (int i = 1; i <= count; ++i) {
                    array1[i] = value.getValue1();
                    array2[i] = value.getValue2();
                }
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                byte pos;
                SerialBytes value;
                if ((value = dict[pos = buffer[index++]]) == null) {
                    array1[i] = 0L;
                    array2[i] = 0L;
                    continue;
                }
                array1[i] = value.getValue1();
                array2[i] = value.getValue2();
            }
        }
        return new SerialBytesArray(array1, array2, count);
    }

    private static ObjectArray _$1(Object[] dict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        Object[] array = new Object[count + 1];
        if (isConst) {
            Object value = dict[constPos];
            for (int i = 1; i <= count; ++i) {
                array[i] = value;
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                byte pos = buffer[index++];
                array[i] = dict[pos];
            }
        }
        return new ObjectArray(array, count);
    }

    private static IntArray _$1(int[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int count) {
        int[] array = new int[count + 1];
        boolean[] sign = null;
        int nullPos = dict[0];
        if (isConst) {
            if (constPos == dict[0]) {
                sign = new boolean[count + 1];
                Arrays.fill(sign, true);
            } else {
                Arrays.fill(array, dict[constPos]);
            }
        } else if (nullPos > 0) {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos;
                    if ((pos = buffer[index++]) == nullPos) {
                        if (sign == null) {
                            sign = new boolean[count + 1];
                        }
                        sign[i] = true;
                        continue;
                    }
                    array[i] = dict[pos];
                    continue;
                }
                ++index;
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos = buffer[index++];
                    array[i] = dict[pos];
                    continue;
                }
                ++index;
            }
        }
        return new IntArray(array, sign, count);
    }

    private static LongArray _$1(long[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int count) {
        long[] array = new long[count + 1];
        boolean[] sign = null;
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((long)constPos == dict[0]) {
                sign = new boolean[count + 1];
                Arrays.fill(sign, true);
            } else {
                Arrays.fill(array, dict[constPos]);
            }
        } else if (nullPos > 0) {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos;
                    if ((pos = buffer[index++]) == nullPos) {
                        if (sign == null) {
                            sign = new boolean[count + 1];
                        }
                        sign[i] = true;
                        continue;
                    }
                    array[i] = dict[pos];
                    continue;
                }
                ++index;
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos = buffer[index++];
                    array[i] = dict[pos];
                    continue;
                }
                ++index;
            }
        }
        return new LongArray(array, sign, count);
    }

    protected static DoubleArray readDoubleArrayByDict2(double[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int count) {
        boolean sign = false;
        byte[] posArr = new byte[count + 1];
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((double)constPos == dict[0]) {
                sign = true;
            } else {
                Arrays.fill(posArr, (byte)constPos);
                posArr[0] = 0;
            }
        } else if (nullPos > 0) {
            sign = true;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos;
                    if ((pos = buffer[index++]) == nullPos) {
                        posArr[i] = 0;
                        continue;
                    }
                    posArr[i] = pos;
                    continue;
                }
                ++index;
            }
        } else {
            System.arraycopy(buffer, index, posArr, 1, count);
        }
        return new DoubleDictArray(dict, posArr, sign);
    }

    private static DoubleArray _$1(double[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int count) {
        double[] array = new double[count + 1];
        boolean[] sign = null;
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((double)constPos == dict[0]) {
                sign = new boolean[count + 1];
                Arrays.fill(sign, true);
            } else {
                double value = dict[constPos];
                for (int i = 1; i <= count; ++i) {
                    array[i] = value;
                }
            }
        } else if (nullPos > 0) {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos;
                    if ((pos = buffer[index++]) == nullPos) {
                        if (sign == null) {
                            sign = new boolean[count + 1];
                        }
                        sign[i] = true;
                        continue;
                    }
                    array[i] = dict[pos];
                    continue;
                }
                ++index;
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos = buffer[index++];
                    array[i] = dict[pos];
                    continue;
                }
                ++index;
            }
        }
        return new DoubleArray(array, sign, count);
    }

    private static DateArray _$1(Date[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int count) {
        Date[] array = new Date[count + 1];
        if (isConst) {
            Date value = dict[constPos];
            for (int i = 1; i <= count; ++i) {
                array[i] = value;
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos = buffer[index++];
                    array[i] = dict[pos];
                    continue;
                }
                ++index;
            }
        }
        return new DateArray(array, count);
    }

    private static SerialBytesArray _$1(SerialBytes[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int count) {
        long[] array1 = new long[count + 1];
        long[] array2 = new long[count + 1];
        if (isConst) {
            SerialBytes value = dict[constPos];
            if (value == null) {
                for (int i = 1; i <= count; ++i) {
                    array1[i] = 0L;
                    array2[i] = 0L;
                }
            } else {
                for (int i = 1; i <= count; ++i) {
                    array1[i] = value.getValue1();
                    array2[i] = value.getValue2();
                }
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos;
                    SerialBytes value;
                    if ((value = dict[pos = buffer[index++]]) == null) {
                        array1[i] = 0L;
                        array2[i] = 0L;
                        continue;
                    }
                    array1[i] = value.getValue1();
                    array2[i] = value.getValue2();
                    continue;
                }
                ++index;
            }
        }
        return new SerialBytesArray(array1, array2, count);
    }

    private static StringArray _$1(String[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int count) {
        String[] array = new String[count + 1];
        if (isConst) {
            String value = dict[constPos];
            for (int i = 1; i <= count; ++i) {
                array[i] = value;
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos = buffer[index++];
                    array[i] = dict[pos];
                    continue;
                }
                ++index;
            }
        }
        return new StringArray(array, count);
    }

    private static ObjectArray _$1(Object[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int count) {
        Object[] array = new Object[count + 1];
        if (isConst) {
            Object value = dict[constPos];
            for (int i = 1; i <= count; ++i) {
                array[i] = value;
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos = buffer[index++];
                    array[i] = dict[pos];
                    continue;
                }
                ++index;
            }
        }
        return new ObjectArray(array, count);
    }

    private static IntArray _$1(int[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int matchCount, int count) {
        int[] array = new int[matchCount + 1];
        boolean[] sign = null;
        int nullPos = dict[0];
        if (isConst) {
            if (constPos == dict[0]) {
                sign = new boolean[matchCount + 1];
                Arrays.fill(sign, true);
            } else {
                Arrays.fill(array, dict[constPos]);
            }
        } else {
            int offset = 1;
            if (nullPos > 0) {
                for (int i = 1; i <= count; ++i) {
                    if (match[i]) {
                        byte pos;
                        if ((pos = buffer[index++]) == nullPos) {
                            if (sign == null) {
                                sign = new boolean[matchCount + 1];
                            }
                            sign[offset++] = true;
                            continue;
                        }
                        array[offset++] = dict[pos];
                        continue;
                    }
                    ++index;
                }
            } else {
                for (int i = 1; i <= count; ++i) {
                    if (match[i]) {
                        byte pos = buffer[index++];
                        array[offset++] = dict[pos];
                        continue;
                    }
                    ++index;
                }
            }
        }
        return new IntArray(array, sign, matchCount);
    }

    private static LongArray _$1(long[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int matchCount, int count) {
        long[] array = new long[matchCount + 1];
        boolean[] sign = null;
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((long)constPos == dict[0]) {
                sign = new boolean[matchCount + 1];
                Arrays.fill(sign, true);
            } else {
                Arrays.fill(array, dict[constPos]);
            }
        } else {
            int offset = 1;
            if (nullPos > 0) {
                for (int i = 1; i <= count; ++i) {
                    if (match[i]) {
                        byte pos;
                        if ((pos = buffer[index++]) == nullPos) {
                            if (sign == null) {
                                sign = new boolean[matchCount + 1];
                            }
                            sign[offset++] = true;
                            continue;
                        }
                        array[offset++] = dict[pos];
                        continue;
                    }
                    ++index;
                }
            } else {
                for (int i = 1; i <= count; ++i) {
                    if (match[i]) {
                        byte pos = buffer[index++];
                        array[offset++] = dict[pos];
                        continue;
                    }
                    ++index;
                }
            }
        }
        return new LongArray(array, sign, matchCount);
    }

    private static DoubleArray _$1(double[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int matchCount, int count) {
        double[] array = new double[matchCount + 1];
        boolean[] sign = null;
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((double)constPos == dict[0]) {
                sign = new boolean[matchCount + 1];
                Arrays.fill(sign, true);
            } else {
                double value = dict[constPos];
                for (int i = 1; i <= matchCount; ++i) {
                    array[i] = value;
                }
            }
        } else {
            int offset = 1;
            if (nullPos > 0) {
                for (int i = 1; i <= count; ++i) {
                    if (match[i]) {
                        byte pos;
                        if ((pos = buffer[index++]) == nullPos) {
                            if (sign == null) {
                                sign = new boolean[matchCount + 1];
                            }
                            sign[offset++] = true;
                            continue;
                        }
                        array[offset++] = dict[pos];
                        continue;
                    }
                    ++index;
                }
            } else {
                for (int i = 1; i <= count; ++i) {
                    if (match[i]) {
                        byte pos = buffer[index++];
                        array[offset++] = dict[pos];
                        continue;
                    }
                    ++index;
                }
            }
        }
        return new DoubleArray(array, sign, matchCount);
    }

    private static DateArray _$1(Date[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int matchCount, int count) {
        Date[] array = new Date[matchCount + 1];
        if (isConst) {
            Date value = dict[constPos];
            for (int i = 1; i <= matchCount; ++i) {
                array[i] = value;
            }
        } else {
            int offset = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos = buffer[index++];
                    array[offset++] = dict[pos];
                    continue;
                }
                ++index;
            }
        }
        return new DateArray(array, matchCount);
    }

    private static SerialBytesArray _$1(SerialBytes[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int matchCount, int count) {
        long[] array1 = new long[matchCount + 1];
        long[] array2 = new long[matchCount + 1];
        if (isConst) {
            SerialBytes value = dict[constPos];
            if (value == null) {
                for (int i = 1; i <= matchCount; ++i) {
                    array1[i] = 0L;
                    array2[i] = 0L;
                }
            } else {
                for (int i = 1; i <= matchCount; ++i) {
                    array1[i] = value.getValue1();
                    array2[i] = value.getValue2();
                }
            }
        } else {
            int offset = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos;
                    SerialBytes value;
                    if ((value = dict[pos = buffer[index++]]) == null) {
                        array1[offset] = 0L;
                        array2[offset] = 0L;
                    } else {
                        array1[offset] = value.getValue1();
                        array2[offset] = value.getValue2();
                    }
                    ++offset;
                    continue;
                }
                ++index;
            }
        }
        return new SerialBytesArray(array1, array2, matchCount);
    }

    private static StringArray _$1(String[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int matchCount, int count) {
        String[] array = new String[matchCount + 1];
        if (isConst) {
            String value = dict[constPos];
            for (int i = 1; i <= matchCount; ++i) {
                array[i] = value;
            }
        } else {
            int offset = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos = buffer[index++];
                    array[offset++] = dict[pos];
                    continue;
                }
                ++index;
            }
        }
        return new StringArray(array, matchCount);
    }

    private static ObjectArray _$1(Object[] dict, int index, byte[] buffer, boolean isConst, int constPos, boolean[] match, int matchCount, int count) {
        Object[] array = new Object[matchCount + 1];
        if (isConst) {
            Object value = dict[constPos];
            for (int i = 1; i <= matchCount; ++i) {
                array[i] = value;
            }
        } else {
            int offset = 1;
            for (int i = 1; i <= count; ++i) {
                if (match[i]) {
                    byte pos = buffer[index++];
                    array[offset++] = dict[pos];
                    continue;
                }
                ++index;
            }
        }
        return new ObjectArray(array, matchCount);
    }

    private static IArray _$1(BufferReader reader, int count) throws IOException {
        long lastVal;
        Object firstVal = reader.readObject();
        int step = reader.readInt();
        if (firstVal instanceof Integer) {
            int lastVal2;
            IntArray array = new IntArray(count);
            int[] arr = array.getDatas();
            arr[1] = lastVal2 = ((Integer)firstVal).intValue();
            for (int i = 2; i <= count; ++i) {
                arr[i] = lastVal2 += step;
            }
            array.setSize(count);
            array.setSigns(null);
            array.setTemporary(false);
            return array;
        }
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        arr[1] = lastVal = ((Long)firstVal).longValue();
        for (int i = 2; i <= count; ++i) {
            arr[i] = lastVal += (long)step;
        }
        array.setSize(count);
        array.setSigns(null);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$1(BufferReader reader, boolean[] matchArray, int count) throws IOException {
        Object firstObj = reader.readObject();
        int step = reader.readInt();
        if (firstObj instanceof Integer) {
            IntArray array = new IntArray(count);
            int[] arr = array.getDatas();
            int firstVal = (Integer)firstObj;
            for (int i = 1; i <= count; ++i) {
                if (!matchArray[i]) continue;
                arr[i] = firstVal + (i - 1) * step;
            }
            array.setSize(count);
            array.setSigns(null);
            array.setTemporary(false);
            return array;
        }
        LongArray array = new LongArray(count);
        long[] arr = array.getDatas();
        long firstVal = (Long)firstObj;
        for (int i = 1; i <= count; ++i) {
            if (!matchArray[i]) continue;
            arr[i] = firstVal + (long)((i - 1) * step);
        }
        array.setSize(count);
        array.setSigns(null);
        array.setTemporary(false);
        return array;
    }

    private static IArray _$1(BufferReader reader, boolean[] match, int count, int matchCount) throws IOException {
        Object firstObj = reader.readObject();
        int step = reader.readInt();
        if (firstObj instanceof Integer) {
            IntArray array = new IntArray(matchCount);
            int[] arr = array.getDatas();
            int firstVal = (Integer)firstObj;
            int off = 1;
            for (int i = 1; i <= count; ++i) {
                if (!match[i]) continue;
                arr[off++] = firstVal + (i - 1) * step;
            }
            array.setSize(matchCount);
            array.setSigns(null);
            array.setTemporary(false);
            return array;
        }
        LongArray array = new LongArray(matchCount);
        long[] arr = array.getDatas();
        long firstVal = (Long)firstObj;
        int off = 1;
        for (int i = 1; i <= count; ++i) {
            if (!match[i]) continue;
            arr[off++] = firstVal + (long)((i - 1) * step);
        }
        array.setSize(matchCount);
        array.setSigns(null);
        array.setTemporary(false);
        return array;
    }

    public static IArray[] readArrayAndDict(BufferReader reader, ColumnMetaData column, int count, boolean isTemp) throws IOException {
        IArray array;
        byte blockType = reader.readByte();
        switch (blockType) {
            case 48: {
                array = DataBlockReader._$15(reader, count);
                break;
            }
            case 126: {
                array = DataBlockReader._$18(reader, count);
                break;
            }
            case 0: {
                array = new ObjectArray(count);
                array.setSize(count);
                break;
            }
            case 16: {
                array = DataBlockReader._$17(reader, count);
                break;
            }
            case 32: {
                array = DataBlockReader._$16(reader, count);
                break;
            }
            case 64: {
                array = DataBlockReader._$14(reader, count);
                break;
            }
            case 17: {
                array = DataBlockReader._$9(reader, count);
                break;
            }
            case 18: {
                array = DataBlockReader._$8(reader, count);
                break;
            }
            case 20: {
                array = DataBlockReader._$7(reader, count);
                break;
            }
            case 33: {
                array = DataBlockReader._$6(reader, count);
                break;
            }
            case 34: {
                array = DataBlockReader._$5(reader, count);
                break;
            }
            case 36: {
                array = DataBlockReader._$4(reader, count);
                break;
            }
            case 40: {
                array = DataBlockReader._$3(reader, count);
                break;
            }
            case 56: {
                array = DataBlockReader._$2(reader, count);
                break;
            }
            case 80: {
                array = DataBlockReader._$12(reader, count);
                break;
            }
            case 70: {
                array = DataBlockReader._$13(reader, count);
                break;
            }
            case 81: {
                if (isTemp) {
                    array = DataBlockReader._$10(reader, count);
                    break;
                }
                array = DataBlockReader._$11(reader, count);
                break;
            }
            case 127: {
                IArray[] arrays = DataBlockReader2.readArrayAndDict(reader, column, count);
                if (column.getDataType() == 126) {
                    arrays[0] = arrays[0].toObjectArray();
                }
                return arrays;
            }
            case 3: {
                array = DataBlockReader._$1(reader, count);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (column.getDataType() == 126) {
            array = array.toObjectArray();
        }
        return new IArray[]{array, null, null};
    }
}

