/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.IComputeItem;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.pdm.PureTable;
import com.scudata.util.HashUtil;

public class HashIndexTable
extends IndexTable {
    private PureTable _$5;
    private IArray _$4;
    private HashUtil _$3;
    private int[] _$2;
    private int[] _$1;

    public HashIndexTable(int capacity) {
        this._$3 = new HashUtil(capacity);
    }

    public HashIndexTable(int capacity, String opt) {
        this._$3 = new HashUtil(capacity);
    }

    public int getCapacity() {
        return this._$3.getCapacity();
    }

    public void create(PureTable code, IArray keyArray) {
        int len = code.length();
        HashUtil hashUtil = this._$3;
        int[] entries = new int[hashUtil.getCapacity()];
        int[] linkArray = new int[len + 1];
        this._$5 = code;
        this._$4 = keyArray;
        this._$2 = entries;
        this._$1 = linkArray;
        int i = 1;
        while (i <= len) {
            int hash = hashUtil.hashCode(keyArray.hashCode(i));
            linkArray[i] = entries[hash];
            entries[hash] = i++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(PureTable code, Expression exp, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)code);
        stack.push((IComputeItem)current);
        try {
            IArray array = exp.calculateAll(ctx);
            this.create(code, array);
        }
        finally {
            stack.pop();
        }
    }

    public void create(PureTable code, int field) {
        this.create(code, code.getFieldValueArray(field));
    }

    public Object find(Object key) {
        int seq = this._$3.hashCode(key);
        seq = this._$2[seq];
        while (seq != 0) {
            if (this._$4.isEquals(seq, key)) {
                return this._$5.getMem(seq);
            }
            seq = this._$1[seq];
        }
        return null;
    }

    public Object find(Object[] keys) {
        return this.find(keys[0]);
    }

    public int findPos(Object key) {
        int seq = this._$3.hashCode(key);
        seq = this._$2[seq];
        while (seq != 0) {
            if (this._$4.isEquals(seq, key)) {
                return seq;
            }
            seq = this._$1[seq];
        }
        return 0;
    }

    public int findPos(Object[] keys) {
        return this.findPos(keys[0]);
    }

    public int[] findAllPos(IArray keys) {
        if (keys == null) {
            return null;
        }
        HashUtil hashUtil = this._$3;
        IArray keyArray = this._$4;
        int[] entries = this._$2;
        int[] linkArray = this._$1;
        int len = keys.size();
        int[] pos = new int[len + 1];
        block0: for (int i = 1; i <= len; ++i) {
            int seq = hashUtil.hashCode(keys.hashCode(i));
            seq = entries[seq];
            while (seq != 0) {
                if (keyArray.isEquals(seq, keys, i)) {
                    pos[i] = seq;
                    continue block0;
                }
                seq = linkArray[seq];
            }
        }
        return pos;
    }

    public int[] findAllPos(IArray[] keys) {
        return this.findAllPos(keys[0]);
    }

    public int[] findAllPos(IArray keys, BoolArray signArray) {
        if (keys == null) {
            return null;
        }
        HashUtil hashUtil = this._$3;
        IArray keyArray = this._$4;
        int[] entries = this._$2;
        int[] linkArray = this._$1;
        int len = keys.size();
        int[] pos = new int[len + 1];
        boolean[] sign = signArray.isTrue().getDatas();
        block0: for (int i = 1; i <= len; ++i) {
            if (!sign[i]) continue;
            int seq = hashUtil.hashCode(keys.hashCode(i));
            seq = entries[seq];
            while (seq != 0) {
                if (keyArray.isEquals(seq, keys, i)) {
                    pos[i] = seq;
                    continue block0;
                }
                seq = linkArray[seq];
            }
        }
        return pos;
    }

    public int[] findAllPos(IArray[] keys, BoolArray signArray) {
        return this.findAllPos(keys[0], signArray);
    }

    public void findPos(Object key, IntArray out) {
        int seq = this._$3.hashCode(key);
        seq = this._$2[seq];
        while (seq != 0) {
            if (this._$4.isEquals(seq, key)) {
                out.addInt(seq);
                continue;
            }
            seq = this._$1[seq];
        }
    }

    public void findPos(Object[] keys, IntArray out) {
        this.findPos(keys[0], out);
    }
}

