/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.IComputeItem;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.pdm.PureTable;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PureRecord
extends BaseRecord {
    private static final long serialVersionUID = 1L;
    private PureTable _$2;
    private int _$1;

    public PureRecord() {
    }

    public PureRecord(PureTable table, int row) {
        this._$2 = table;
        this._$1 = row;
    }

    public PureTable getTable() {
        return this._$2;
    }

    public void setTable(PureTable table) {
        this._$2 = table;
    }

    public int getRow() {
        return this._$1;
    }

    public void setRow(int row) {
        this._$1 = row;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this._$2);
        out.writeInt(this._$1);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._$2 = (PureTable)((Object)in.readObject());
        this._$1 = in.readInt();
    }

    public byte[] serialize() throws IOException {
        throw new IOException();
    }

    public void fillRecord(byte[] bytes) throws IOException, ClassNotFoundException {
        throw new IOException();
    }

    public boolean isEquals(BaseRecord r) {
        if (r == this) {
            return true;
        }
        if (r == null) {
            return false;
        }
        if (r instanceof PureRecord) {
            IArray[] colDatas2;
            PureRecord pr = (PureRecord)r;
            if (this._$2 == pr._$2) {
                return this._$2.compareRecords(this._$1, pr._$1) == 0;
            }
            IArray[] colDatas1 = this._$2.getColDatas();
            int fcount = colDatas1.length;
            if (fcount != (colDatas2 = pr._$2.getColDatas()).length) {
                return false;
            }
            for (int i = 0; i < fcount; ++i) {
                int result = colDatas1[i].compareTo(this._$1, colDatas2[i], pr._$1);
                if (result == 0) continue;
                return false;
            }
            return true;
        }
        IArray[] colDatas = this._$2.getColDatas();
        int fcount = colDatas.length;
        if (fcount != r.getFieldCount()) {
            return false;
        }
        for (int i = 0; i < fcount; ++i) {
            int result = colDatas[i].compareTo(this._$1, r.getNormalFieldValue(i));
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isEquals(BaseRecord r, int[] fields) {
        if (r == this) {
            return true;
        }
        if (r == null) {
            return false;
        }
        if (r instanceof PureRecord) {
            PureRecord pr = (PureRecord)r;
            IArray[] colDatas1 = this._$2.getColDatas();
            IArray[] colDatas2 = pr._$2.getColDatas();
            for (int f : fields) {
                int result = colDatas1[f].compareTo(this._$1, colDatas2[f], pr._$1);
                if (result == 0) continue;
                return false;
            }
            return true;
        }
        IArray[] colDatas = this._$2.getColDatas();
        for (int f : fields) {
            int result = colDatas[f].compareTo(this._$1, r.getNormalFieldValue(f));
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public int compare(BaseRecord r) {
        int len2;
        if (r == this) {
            return 0;
        }
        if (r == null) {
            return 1;
        }
        if (r instanceof PureRecord) {
            IArray[] colDatas2;
            int len22;
            PureRecord pr = (PureRecord)r;
            if (this._$2 == pr._$2) {
                return this._$2.compareRecords(this._$1, pr._$1);
            }
            IArray[] colDatas1 = this._$2.getColDatas();
            int len1 = colDatas1.length;
            int minLen = len1 > (len22 = (colDatas2 = pr._$2.getColDatas()).length) ? len22 : len1;
            for (int i = 0; i < minLen; ++i) {
                int result = colDatas1[i].compareTo(this._$1, colDatas2[i], pr._$1);
                if (result == 0) continue;
                return result;
            }
            return len1 == len22 ? 0 : (len1 > len22 ? 1 : -1);
        }
        IArray[] colDatas = this._$2.getColDatas();
        int len1 = colDatas.length;
        int minLen = len1 > (len2 = r.getFieldCount()) ? len2 : len1;
        for (int i = 0; i < minLen; ++i) {
            int result = colDatas[i].compareTo(this._$1, r.getNormalFieldValue(i));
            if (result == 0) continue;
            return result;
        }
        return len1 == len2 ? 0 : (len1 > len2 ? 1 : -1);
    }

    public int compare(BaseRecord r, int[] fields) {
        if (r == this) {
            return 0;
        }
        if (r == null) {
            return 1;
        }
        if (r instanceof PureRecord) {
            PureRecord pr = (PureRecord)r;
            IArray[] colDatas1 = this._$2.getColDatas();
            IArray[] colDatas2 = pr._$2.getColDatas();
            for (int f : fields) {
                int result = colDatas1[f].compareTo(this._$1, colDatas2[f], pr._$1);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        IArray[] colDatas = this._$2.getColDatas();
        for (int f : fields) {
            int result = colDatas[f].compareTo(this._$1, r.getNormalFieldValue(f));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public int compare(BaseRecord r, int field) {
        if (r instanceof PureRecord) {
            PureRecord pr = (PureRecord)r;
            IArray[] colDatas1 = this._$2.getColDatas();
            IArray[] colDatas2 = pr._$2.getColDatas();
            return colDatas1[field].compareTo(this._$1, colDatas2[field], pr._$1);
        }
        IArray[] colDatas = this._$2.getColDatas();
        return colDatas[field].compareTo(this._$1, r.getNormalFieldValue(field));
    }

    public int compare(int[] fields, Object[] fvalues) {
        IArray[] colDatas = this._$2.getColDatas();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            int cmp = colDatas[fields[i]].compareTo(this._$1, fvalues[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int compare(int field, IArray values, int index) {
        return this._$2.getFieldValueArray(field).compareTo(this._$1, values, index);
    }

    public DataStruct dataStruct() {
        return this._$2.dataStruct();
    }

    public int getFieldCount() {
        return this._$2.getFieldCount();
    }

    public Object getFieldValue(int index) {
        return this._$2.getFieldValue(this._$1, index);
    }

    public Object getFieldValue(String name) {
        return this._$2.getFieldValue(this._$1, name);
    }

    public Object getFieldValue2(int index) {
        if (index < 0) {
            int i = index + this._$2.getFieldCount();
            if (i >= 0) {
                return this._$2.getFieldValue(this._$1, index);
            }
            return null;
        }
        if (index < this._$2.getFieldCount()) {
            return this._$2.getFieldValue(this._$1, index);
        }
        return null;
    }

    public Object[] getFieldValues() {
        return this._$2.getFieldValues(this._$1);
    }

    public Object getNormalFieldValue(int f) {
        return this._$2.getFieldValue(this._$1, f);
    }

    public void getNormalFieldValue(int index, IArray out) {
        out.push(this._$2.getFieldValueArray(index), this._$1);
    }

    public IArray createFieldValueArray(int f, int len) {
        return this._$2.getFieldValueArray(f).newInstance(len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(Expression[] exps, String[] fields, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        stack.push((IComputeItem)this);
        try {
            int fcount = fields.length;
            for (int f = 0; f < fcount; ++f) {
                int findex = this.getFieldIndex(fields[f]);
                if (findex < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fields[f] + mm.getMessage("ds.fieldNotExist"));
                }
                this.setNormalFieldValue(findex, exps[f].calculate(ctx));
            }
        }
        finally {
            stack.pop();
        }
    }

    public void paste(BaseRecord sr, boolean isName) {
        if (sr == null) {
            return;
        }
        if (isName) {
            DataStruct ds = this.dataStruct();
            String[] srcNames = sr.dataStruct().getFieldNames();
            int count = srcNames.length;
            for (int i = 0; i < count; ++i) {
                int index = ds.getFieldIndex(srcNames[i]);
                if (index < 0) continue;
                this.setNormalFieldValue(index, sr.getNormalFieldValue(i));
            }
        } else {
            int minCount = this._$2.getFieldCount();
            if (sr.getFieldCount() < minCount) {
                minCount = sr.getFieldCount();
            }
            for (int f = 0; f < minCount; ++f) {
                this.setNormalFieldValue(f, sr.getNormalFieldValue(f));
            }
        }
    }

    public void paste(Sequence sequence) {
        if (sequence == null) {
            return;
        }
        int fcount = this._$2.getFieldCount();
        if (sequence.length() < fcount) {
            fcount = sequence.length();
        }
        for (int f = 0; f < fcount; ++f) {
            this.setNormalFieldValue(f, sequence.getMem(f));
        }
    }

    public void paste(Sequence sequence, int start) {
        int fcount = sequence.length() - start + 1;
        if (fcount > this._$2.getFieldCount()) {
            fcount = this._$2.getFieldCount();
        }
        for (int f = 0; f < fcount; ++f) {
            this.setNormalFieldValue(f, sequence.getMem(f + start));
        }
    }

    public void set(int index, Object val) {
        if (index < 0) {
            int i = index + this._$2.getFieldCount();
            if (i < 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(index + mm.getMessage("ds.fieldNotExist"));
            }
            this._$2.setFieldValue(this._$1, i, val);
        } else if (index < this._$2.getFieldCount()) {
            this._$2.setFieldValue(this._$1, index, val);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(index + 1 + mm.getMessage("ds.fieldNotExist"));
        }
    }

    public void set(String name, Object val) {
        this._$2.setFieldValue(this._$1, name, val);
    }

    public void set(BaseRecord r) {
        int fcount = this._$2.getFieldCount();
        for (int f = 0; f < fcount; ++f) {
            this.setNormalFieldValue(f, r.getNormalFieldValue(f));
        }
    }

    public void setNormalFieldValue(int index, Object val) {
        this._$2.setFieldValue(this._$1, index, val);
    }

    public void set2(int index, Object val) {
        if (index < 0) {
            if ((index += this._$2.getFieldCount()) >= 0) {
                this._$2.setFieldValue(this._$1, index, val);
            }
        } else if (index < this._$2.getFieldCount()) {
            this._$2.setFieldValue(this._$1, index, val);
        }
    }

    public void setStart(int index, Object[] objs) {
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            this.setNormalFieldValue(index + i, objs[i]);
        }
    }

    public void setStart(int index, Object[] objs, int len) {
        for (int i = 0; i < len; ++i) {
            this.setNormalFieldValue(index + i, objs[i]);
        }
    }

    public void setStart(int index, BaseRecord r) {
        int count = r.getFieldCount();
        for (int i = 0; i < count; ++i) {
            this.setNormalFieldValue(index + i, r.getNormalFieldValue(i));
        }
    }

    public String toString(String opt) {
        char sep = ',';
        boolean addQuotation = false;
        boolean bTitle = false;
        if (opt != null) {
            if (opt.indexOf(116) != -1) {
                sep = '\t';
            }
            if (opt.indexOf(113) != -1) {
                addQuotation = true;
            }
            if (opt.indexOf(102) != -1) {
                bTitle = true;
            }
        }
        int fcount = this.getFieldCount();
        StringBuffer sb = new StringBuffer(20 * fcount);
        if (bTitle) {
            DataStruct ds = this.dataStruct();
            for (int f = 0; f < fcount; ++f) {
                if (f > 0) {
                    sb.append(sep);
                }
                if (addQuotation) {
                    sb.append('\"');
                    sb.append(ds.getFieldName(f));
                    sb.append('\"');
                    continue;
                }
                sb.append(ds.getFieldName(f));
            }
        } else {
            boolean bFirst = true;
            for (int f = 0; f < fcount; ++f) {
                Object obj = this._$2.getFieldValue(this._$1, f);
                if (!Variant.canConvertToString((Object)obj)) continue;
                if (bFirst) {
                    bFirst = false;
                } else {
                    sb.append(sep);
                }
                if (addQuotation && obj instanceof String) {
                    sb.append('\"');
                    sb.append((String)obj);
                    sb.append('\"');
                    continue;
                }
                sb.append(Variant.toString((Object)obj));
            }
        }
        return sb.toString();
    }

    public Record toRecord() {
        PureTable table = this._$2;
        DataStruct ds = table.dataStruct();
        Record r = new Record(ds);
        int fcount = ds.getFieldCount();
        for (int f = 0; f < fcount; ++f) {
            r.setNormalFieldValue(f, table.getFieldValue(this._$1, f));
        }
        return r;
    }
}

