/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm;

import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.SerialBytesArray;
import com.scudata.array.StringArray;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.IRecord;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.IComputeItem;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Record;
import com.scudata.dm.Region;
import com.scudata.dm.Regions;
import com.scudata.dm.SeqIndexTable;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.comparator.DescComparator;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.IGroupsResult;
import com.scudata.dm.op.Operation;
import com.scudata.dm.op.SwitchRemote;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.Node;
import com.scudata.parallel.ClusterMemoryTable;
import com.scudata.pdm.ArrayMemberComparator;
import com.scudata.pdm.ArraysMemberComparator;
import com.scudata.pdm.HashArrayIndexTable;
import com.scudata.pdm.HashIndexTable;
import com.scudata.pdm.MergeIndexTable;
import com.scudata.pdm.ParallelUtil;
import com.scudata.pdm.PureMemoryTable;
import com.scudata.pdm.PureRecord;
import com.scudata.pdm.TimeIndexTable;
import com.scudata.pdm.array.BoolArraySubset;
import com.scudata.pdm.array.DateArraySubset;
import com.scudata.pdm.array.DoubleArraySubset;
import com.scudata.pdm.array.IntArraySubset;
import com.scudata.pdm.array.LongArraySubset;
import com.scudata.pdm.array.ObjectArraySubset;
import com.scudata.pdm.array.SerialBytesArraySubset;
import com.scudata.pdm.array.StringArraySubset;
import com.scudata.pdm.cursor.PureMemoryCursor;
import com.scudata.pdm.op.GroupsResult;
import com.scudata.pdm.op.Join;
import com.scudata.pdm.op.Switch;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.GroupsJob2;
import com.scudata.thread.Job;
import com.scudata.thread.MultithreadUtil;
import com.scudata.thread.ThreadPool;
import com.scudata.util.CursorUtil;
import com.scudata.util.HashUtil;
import com.scudata.util.MinHeap;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class PureTable
extends Table {
    private static final long serialVersionUID = 1L;
    private IArray[] _$1;

    public PureTable() {
        super(false);
    }

    public PureTable(DataStruct ds) {
        super(false);
        this.ds = ds;
    }

    public PureTable(DataStruct ds, IArray[] colDatas) {
        super(false);
        this.ds = ds;
        this._$1 = colDatas;
    }

    public PureTable(String[] fields, IArray[] colDatas) {
        super(false);
        this.ds = new DataStruct(fields);
        this._$1 = colDatas;
    }

    public PureTable(Sequence seq) {
        super(false);
        int field;
        DataStruct ds = seq.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        int fcount = ds.getFieldCount();
        IArray[] arrays = new IArray[fcount];
        IArray mems = seq.getMems();
        int size = mems.size();
        BaseRecord r = null;
        int i = 1;
        while (i <= size) {
            if ((r = (BaseRecord)mems.get(i++)) == null) continue;
            for (field = 0; field < fcount; ++field) {
                IArray array;
                arrays[field] = array = r.createFieldValueArray(field, size);
                for (int n = 2; n < i; ++n) {
                    array.pushNull();
                }
                r.getNormalFieldValue(field, array);
            }
        }
        while (i <= size) {
            r = (BaseRecord)mems.get(i);
            if (r != null) {
                for (field = 0; field < fcount; ++field) {
                    r.getNormalFieldValue(field, arrays[field]);
                }
            } else {
                for (field = 0; field < fcount; ++field) {
                    arrays[field].pushNull();
                }
            }
            ++i;
        }
        this.ds = ds;
        this._$1 = arrays;
    }

    public IArray[] getColDatas() {
        return this._$1;
    }

    public void setColDatas(IArray[] colDatas) {
        this._$1 = colDatas;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        out.writeRecord((IRecord)this.ds);
        int len = this.length();
        out.writeInt(len);
        if (len > 0) {
            for (IArray array : this._$1) {
                out.writeObject((Object)array, true);
            }
        }
        return out.toByteArray();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        this.ds = new DataStruct();
        in.readRecord((IRecord)this.ds);
        int len = in.readInt();
        if (len > 0) {
            int fcount = this.ds.getFieldCount();
            this._$1 = new IArray[fcount];
            for (int f = 0; f < fcount; ++f) {
                this._$1[f] = (IArray)in.readObject(true);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.ds);
        int len = this.length();
        out.writeInt(len);
        if (len > 0) {
            for (IArray array : this._$1) {
                out.writeObject(array);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.ds = (DataStruct)in.readObject();
        int len = in.readInt();
        if (len > 0) {
            int fcount = this.ds.getFieldCount();
            this._$1 = new IArray[fcount];
            for (int f = 0; f < fcount; ++f) {
                this._$1[f] = (IArray)in.readObject();
            }
        }
    }

    private void _$2() {
        if (this.mems != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.modifyError"));
        }
    }

    private void _$1() {
        int fcount = this.ds.getFieldCount();
        if (this._$1 == null) {
            this._$1 = new IArray[fcount];
        }
        for (int i = 0; i < fcount; ++i) {
            if (this._$1[i] != null) continue;
            this._$1[i] = new ObjectArray(8);
        }
    }

    public void add(Object val) {
        if (val instanceof BaseRecord && ((BaseRecord)val).dataStruct() == this.ds) {
            this._$1();
            Object[] values = ((BaseRecord)val).getFieldValues();
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                this._$1[i].add(values[i]);
            }
            if (this.mems != null) {
                PureRecord r = new PureRecord(this, this.mems.size() + 1);
                this.mems.add((Object)r);
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.modifyError"));
        }
    }

    public void addAll(Object[] objs) {
        for (Object obj : objs) {
            this.add(obj);
        }
    }

    public void addAll(Sequence sequence) {
        if (sequence == null || sequence.length() == 0) {
            return;
        }
        if (sequence instanceof PureTable) {
            PureTable table = (PureTable)sequence;
            int fcount = table.getFieldCount();
            if (this.getFieldCount() != fcount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.dsNotMatch"));
            }
            IArray[] appendDatas = table._$1;
            if (this.length() == 0) {
                this._$1 = appendDatas;
            } else {
                for (int i = 0; i < fcount; ++i) {
                    this._$1[i].addAll(appendDatas[i]);
                }
            }
            IArray mems = this.mems;
            if (mems != null) {
                int newSize = this._$1[0].size();
                for (int i = mems.size() + 1; i <= newSize; ++i) {
                    PureRecord r = new PureRecord(this, i);
                    mems.add((Object)r);
                }
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.modifyError"));
        }
    }

    public Sequence append(Sequence seq) {
        if (seq.length() == 0) {
            return this;
        }
        if (seq instanceof PureTable) {
            PureTable table = (PureTable)seq;
            if (this.ds.isCompatible(table.ds)) {
                int i;
                if (this.length() == 0) {
                    this._$1 = table._$1;
                } else {
                    int fcount = table.getFieldCount();
                    IArray[] appendDatas = table._$1;
                    for (i = 0; i < fcount; ++i) {
                        this._$1[i].addAll(appendDatas[i]);
                    }
                }
                IArray mems = this.mems;
                if (mems != null) {
                    int newSize = this._$1[0].size();
                    for (i = mems.size() + 1; i <= newSize; ++i) {
                        PureRecord r = new PureRecord(this, i);
                        mems.add((Object)r);
                    }
                }
                return this;
            }
        }
        Sequence result = new Sequence(this.length() + seq.length());
        result.addAll((Sequence)this);
        result.addAll(seq);
        return result;
    }

    public Sequence conj(Sequence seq, boolean bMerge) {
        if (seq instanceof PureTable) {
            PureTable table = (PureTable)seq;
            if (this.ds.isCompatible(table.ds)) {
                int len1 = this.length();
                int len2 = table.length();
                if (len1 == 0) {
                    return table.derive(null);
                }
                if (len2 == 0) {
                    return this.derive(null);
                }
                int total = len1 + len2;
                int fcount = table.getFieldCount();
                IArray[] appendDatas = table._$1;
                IArray[] resultArrays = new IArray[fcount];
                for (int i = 0; i < fcount; ++i) {
                    resultArrays[i] = this._$1[i].getClass() == appendDatas[i].getClass() ? this._$1[i].newInstance(total) : new ObjectArray(total);
                    resultArrays[i].addAll(this._$1[i]);
                    resultArrays[i].addAll(appendDatas[i]);
                }
                return new PureTable(this.ds, resultArrays);
            }
        }
        Sequence result = new Sequence(this.length() + seq.length());
        result.addAll((Sequence)this);
        result.addAll(seq);
        return result;
    }

    public Sequence conj(Sequence seq, int resultCapacity) {
        if (seq instanceof PureTable) {
            PureTable table = (PureTable)seq;
            if (this.ds.isCompatible(table.ds)) {
                int fcount = table.getFieldCount();
                IArray[] appendDatas = table._$1;
                IArray[] resultArrays = new IArray[fcount];
                for (int i = 0; i < fcount; ++i) {
                    resultArrays[i] = this._$1[i].getClass() == appendDatas[i].getClass() ? this._$1[i].newInstance(resultCapacity) : new ObjectArray(resultCapacity);
                    resultArrays[i].addAll(this._$1[i]);
                    resultArrays[i].addAll(appendDatas[i]);
                }
                return new PureTable(this.ds, resultArrays);
            }
        }
        Sequence result = new Sequence(resultCapacity);
        result.addAll((Sequence)this);
        result.addAll(seq);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence calc(Expression exp, Context ctx) {
        if (exp == null) {
            return this;
        }
        if (this.length() == 0) {
            return new Sequence(0);
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            IArray array = exp.calculateAll(ctx);
            array = array.reserve(false);
            Sequence sequence = new Sequence(array);
            return sequence;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence calc(Expression exp, String opt, Context ctx) {
        if (this.length() == 0) {
            return new Sequence(0);
        }
        if (opt == null || opt.indexOf(109) == -1) {
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current((Sequence)this);
            stack.push((IComputeItem)current);
            try {
                IArray array = exp.calculateAll(ctx);
                if (opt == null || opt.indexOf(111) == -1) {
                    array = array.reserve(false);
                } else {
                    array.setTemporary(false);
                }
                Sequence sequence = new Sequence(array);
                return sequence;
            }
            finally {
                stack.pop();
            }
        }
        return ParallelUtil.calc(this, exp, ctx);
    }

    public void ensureCapacity(int minCapacity) {
        if (this._$1 == null) {
            return;
        }
        for (IArray array : this._$1) {
            array.ensureCapacity(minCapacity);
        }
    }

    public void clear() {
        if (this.length() > 0) {
            this._$2();
            for (IArray data : this._$1) {
                data.clear();
            }
        }
    }

    public int hashCode() {
        if (this._$1 == null) {
            return 0;
        }
        return this._$1.hashCode();
    }

    public int length() {
        if (this._$1 == null || this._$1[0] == null) {
            return 0;
        }
        return this._$1[0].size();
    }

    public int count() {
        if (this._$1 == null || this._$1[0] == null) {
            return 0;
        }
        return this._$1[0].size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(Expression exp, Context ctx) {
        if (exp == null) {
            return this.count();
        }
        if (this.length() == 0) {
            return 0;
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            IArray array = exp.calculateAll(ctx);
            int n = array.count();
            return n;
        }
        finally {
            stack.pop();
        }
    }

    public void delete(int index) {
        this._$2();
        int oldLen = this.length();
        if (index > 0 && index <= oldLen) {
            for (IArray data : this._$1) {
                data.remove(index);
            }
            this.rebuildIndexTable();
        } else if (index < 0 && (index += oldLen + 1) > 0) {
            for (IArray data : this._$1) {
                data.remove(index);
            }
            this.rebuildIndexTable();
        }
    }

    public void delete(int from, int to) {
        this._$2();
        if (from < 1 || to < from || to > this.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(from + ":" + to + mm.getMessage("engine.indexOutofBound"));
        }
        for (IArray data : this._$1) {
            data.removeRange(from, to);
        }
    }

    public Object delete(int index, String opt) {
        if (opt == null || opt.indexOf(110) == -1) {
            this.delete(index);
            return this;
        }
        this._$2();
        int oldLen = this.length();
        if (index > 0 && index <= oldLen) {
            Record r = new Record(this.ds);
            int fcount = this._$1.length;
            for (int i = 0; i < fcount; ++i) {
                r.setNormalFieldValue(i, this._$1[i].get(index));
                this._$1[i].remove(index);
            }
            this.rebuildIndexTable();
            return r;
        }
        if (index < 0 && (index += oldLen + 1) > 0) {
            Record r = new Record(this.ds);
            int fcount = this._$1.length;
            for (int i = 0; i < fcount; ++i) {
                r.setNormalFieldValue(i, this._$1[i].get(index));
                this._$1[i].remove(index);
            }
            this.rebuildIndexTable();
            return r;
        }
        return null;
    }

    public Sequence delete(Sequence sequence, String opt) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void deleteNullFieldRecord(int f) {
        block6: {
            int i;
            int nullCount;
            BoolArray signArray;
            IArray[] colDatas;
            block5: {
                colDatas = this._$1;
                if (colDatas == null || colDatas[0] == null) {
                    return;
                }
                IArray array = colDatas[f];
                int len = array.size();
                signArray = new BoolArray(len);
                nullCount = 0;
                for (i = 1; i <= len; ++i) {
                    if (array.isNull(i)) {
                        ++nullCount;
                        signArray.pushBool(false);
                        continue;
                    }
                    signArray.pushBool(true);
                }
                if (nullCount != len) break block5;
                for (IArray data : colDatas) {
                    data.clear();
                }
                break block6;
            }
            if (nullCount <= 0) break block6;
            int fcount = colDatas.length;
            for (i = 0; i < fcount; ++i) {
                colDatas[i] = colDatas[i].select((IArray)signArray);
            }
        }
    }

    public void deleteNullFieldRecord(String fieldName) {
        this.deleteNullFieldRecord(this.ds.getFieldIndex(fieldName));
    }

    public Table derive(String opt) {
        DataStruct dataStruct = this.ds.dup();
        if (this.length() == 0) {
            return new Table(dataStruct);
        }
        if (opt == null || opt.indexOf(111) == -1) {
            int fcount = this._$1.length;
            IArray[] resultDatas = new IArray[fcount];
            for (int i = 0; i < fcount; ++i) {
                resultDatas[i] = this._$1[i].dup();
            }
            return new PureTable(dataStruct, resultDatas);
        }
        return new PureTable(dataStruct, this._$1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table derive(DataStruct newDs, Expression[] exps, String opt, Context ctx) {
        PureTable result;
        boolean refOrign;
        if (opt != null && opt.indexOf(109) != -1) {
            return ParallelUtil.derive(this, newDs, exps, opt, ctx);
        }
        boolean bl = refOrign = opt != null && opt.indexOf(111) != -1;
        if (this.length() == 0) {
            if (refOrign) {
                this.ds = newDs;
                this._$1 = null;
                return this;
            }
            return new PureTable(newDs);
        }
        int addColCount = exps.length;
        int oldColCount = this.ds.getFieldCount();
        int newColCount = newDs.getFieldCount();
        IArray[] resultDatas = new IArray[newColCount];
        if (refOrign) {
            System.arraycopy(this._$1, 0, resultDatas, 0, oldColCount);
            result = this;
            this._$1 = resultDatas;
            this.ds = newDs;
        } else {
            for (int i = 0; i < oldColCount; ++i) {
                resultDatas[i] = this._$1[i].dup();
            }
            result = new PureTable(newDs, resultDatas);
        }
        ComputeStack stack = ctx.getComputeStack();
        Current newCurrent = new Current((Sequence)result);
        stack.push((IComputeItem)newCurrent);
        try {
            for (int i = 0; i < addColCount; ++i) {
                IArray array = exps[i].calculateAll(ctx);
                resultDatas[oldColCount + i] = array.reserve(refOrign);
            }
        }
        finally {
            stack.pop();
        }
        if (opt != null && opt.indexOf(105) != -1) {
            IArray array = resultDatas[oldColCount];
            int len = array.size();
            boolean[] signs = new boolean[len + 1];
            for (int i = 1; i <= len; ++i) {
                signs[i] = !array.isNull(i);
            }
            for (int c = oldColCount + 1; c < newColCount; ++c) {
                array = resultDatas[c];
                for (int i = 1; i <= len; ++i) {
                    if (!array.isNull(i)) continue;
                    signs[i] = false;
                }
            }
            BoolArray signArray = new BoolArray(signs, null, len);
            return result.select((IArray)signArray);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table derive(Expression filter, DataStruct newDs, Expression[] exps, String opt, Context ctx) {
        if (this.length() == 0) {
            return new PureTable(newDs);
        }
        int addColCount = exps.length;
        int oldColCount = this.ds.getFieldCount();
        int newColCount = newDs.getFieldCount();
        IArray[] resultDatas = new IArray[newColCount];
        System.arraycopy(this._$1, 0, resultDatas, 0, oldColCount);
        PureTable result = new PureTable(newDs, resultDatas);
        ComputeStack stack = ctx.getComputeStack();
        Current newCurrent = new Current((Sequence)result);
        stack.push((IComputeItem)newCurrent);
        try {
            int i;
            IArray signArray = filter.calculateAll(ctx);
            for (i = 0; i < addColCount; ++i) {
                resultDatas[oldColCount + i] = exps[i].calculateAll(ctx, signArray, true);
            }
            for (i = 0; i < newColCount; ++i) {
                resultDatas[i] = resultDatas[i].select(signArray);
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    public Table derive(String[] names, Expression[] exps, String opt, Context ctx) {
        int addColCount = exps.length;
        for (int i = 0; i < addColCount; ++i) {
            if (names[i] == null || names[i].length() == 0) {
                if (exps[i] == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("derive" + mm.getMessage("function.invalidParam"));
                }
                names[i] = exps[i].getFieldName(this.ds);
                continue;
            }
            if (exps[i] != null) continue;
            exps[i] = Expression.NULL;
        }
        String[] oldNames = this.ds.getFieldNames();
        int oldColCount = oldNames.length;
        String[] totalNames = new String[oldColCount + addColCount];
        System.arraycopy(oldNames, 0, totalNames, 0, oldColCount);
        System.arraycopy(names, 0, totalNames, oldColCount, addColCount);
        DataStruct newDs = this.ds.create(totalNames);
        return this.derive(newDs, exps, opt, ctx);
    }

    public Table newTable(String[] names, Expression[] exps, String opt, Context ctx) {
        if (names == null || exps == null || names.length != exps.length) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("new" + mm.getMessage("function.invalidParam"));
        }
        this.getNewFieldNames(exps, names, "new");
        DataStruct ds = new DataStruct(names);
        return this.newTable(ds, exps, opt, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PureTable newTable(Expression filter, DataStruct ds, Expression[] exps, String opt, Context ctx) {
        if (this.length() == 0) {
            return new PureTable(ds);
        }
        int fcount = ds.getFieldCount();
        IArray[] resultDatas = new IArray[fcount];
        PureTable result = new PureTable(ds, resultDatas);
        String[] oldFieldNames = this.dataStruct().getFieldNames();
        int oldFieldCount = oldFieldNames.length;
        String[] tempFieldNames = new String[oldFieldCount + fcount];
        System.arraycopy(oldFieldNames, 0, tempFieldNames, 0, oldFieldCount);
        System.arraycopy(ds.getFieldNames(), 0, tempFieldNames, oldFieldCount, fcount);
        IArray[] tempArrays = new IArray[oldFieldCount + fcount];
        System.arraycopy(this._$1, 0, tempArrays, 0, oldFieldCount);
        PureTable tempTable = new PureTable(tempFieldNames, tempArrays);
        ComputeStack stack = ctx.getComputeStack();
        Current newCurrent = new Current((Sequence)tempTable);
        stack.push((IComputeItem)newCurrent);
        try {
            int i;
            IArray signArray = filter.calculateAll(ctx);
            for (i = 0; i < fcount; ++i) {
                resultDatas[i] = exps[i].calculateAll(ctx, signArray, true);
                tempArrays[oldFieldCount + i] = resultDatas[i];
            }
            for (i = 0; i < fcount; ++i) {
                resultDatas[i] = resultDatas[i].select(signArray);
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PureTable newTable(DataStruct ds, Expression[] exps, String opt, Context ctx) {
        if (opt != null && opt.indexOf(109) != -1) {
            return ParallelUtil.newTable(this, ds, exps, opt, ctx);
        }
        if (this.length() == 0) {
            return new PureTable(ds);
        }
        int fcount = ds.getFieldCount();
        IArray[] resultDatas = new IArray[fcount];
        PureTable result = new PureTable(ds, resultDatas);
        boolean refOrign = opt != null && opt.indexOf(111) != -1;
        String[] oldFieldNames = this.dataStruct().getFieldNames();
        int oldFieldCount = oldFieldNames.length;
        String[] tempFieldNames = new String[oldFieldCount + fcount];
        System.arraycopy(oldFieldNames, 0, tempFieldNames, 0, oldFieldCount);
        System.arraycopy(ds.getFieldNames(), 0, tempFieldNames, oldFieldCount, fcount);
        IArray[] tempArrays = new IArray[oldFieldCount + fcount];
        System.arraycopy(this._$1, 0, tempArrays, 0, oldFieldCount);
        PureTable tempTable = new PureTable(tempFieldNames, tempArrays);
        ComputeStack stack = ctx.getComputeStack();
        Current newCurrent = new Current((Sequence)tempTable);
        stack.push((IComputeItem)newCurrent);
        try {
            for (int i = 0; i < fcount; ++i) {
                IArray array = exps[i].calculateAll(ctx);
                resultDatas[i] = array.reserve(refOrign);
                tempArrays[oldFieldCount + i] = array;
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    public Table fieldsValues(String[] fieldNames) {
        if (this.length() == 0) {
            return new PureTable(new DataStruct(fieldNames));
        }
        int newCount = fieldNames.length;
        String[] newNames = new String[newCount];
        IArray[] resultDatas = new IArray[newCount];
        for (int i = 0; i < newCount; ++i) {
            int q = this.ds.getFieldIndex(fieldNames[i]);
            if (q < 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(fieldNames[i] + mm.getMessage("ds.fieldNotExist"));
            }
            resultDatas[i] = this._$1[q];
            newNames[i] = this.ds.getFieldName(q);
        }
        return new PureTable(newNames, resultDatas);
    }

    public Sequence fieldValues(int field) {
        if (this.length() == 0) {
            return new Sequence(0);
        }
        return new Sequence(this._$1[field]);
    }

    public Sequence fieldValues(String fieldName) {
        int q = this.ds.getFieldIndex(fieldName);
        if (q < 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
        }
        return this.fieldValues(q);
    }

    public IArray getFieldValueArray(int field) {
        if (this._$1 == null) {
            return null;
        }
        return this._$1[field];
    }

    public Object getCurrent(int seq) {
        if (this.ds.getFieldName(0).equals("~")) {
            return this._$1[0].get(seq);
        }
        return this.getMems().get(seq);
    }

    public boolean containField(String fieldName) {
        if (this.ds.getFieldIndex(fieldName) != -1) {
            return true;
        }
        if (this.ds.getFieldName(0).equals("~")) {
            IArray leftArray = this._$1[0];
            Object src = leftArray.get(1);
            if (src instanceof Sequence) {
                Sequence seq = (Sequence)src;
                src = seq.length() > 0 ? seq.getMem(1) : null;
            }
            if (src instanceof BaseRecord) {
                BaseRecord r = (BaseRecord)src;
                return r.getFieldIndex(fieldName) != -1;
            }
            return false;
        }
        return false;
    }

    public IArray getFieldValueArray(String fieldName) {
        int f;
        if (this._$1 == null) {
            return null;
        }
        if (this.ds.getFieldName(0).equals("~")) {
            BaseRecord r;
            Sequence seq;
            Object src;
            int i;
            IArray leftArray = this._$1[0];
            if (leftArray == null) {
                int f2 = this.ds.getFieldIndex(fieldName);
                if (f2 != -1) {
                    return this._$1[f2];
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
            }
            int len = leftArray.size();
            IArray result = null;
            int col = -1;
            for (i = 1; i <= len; ++i) {
                src = leftArray.get(i);
                if (src instanceof Sequence) {
                    seq = (Sequence)src;
                    src = seq.length() > 0 ? seq.getMem(1) : null;
                }
                if (src instanceof BaseRecord) {
                    r = (BaseRecord)src;
                    col = r.getFieldIndex(fieldName);
                    if (col == -1) break;
                    result = r.createFieldValueArray(col, len);
                    for (int n = 1; n < i; ++n) {
                        result.pushNull();
                    }
                    r.getNormalFieldValue(col, result);
                    break;
                }
                if (src != null) break;
            }
            if (result != null) {
                ++i;
                while (i <= len) {
                    src = leftArray.get(i);
                    if (src instanceof Sequence) {
                        seq = (Sequence)src;
                        src = seq.length() > 0 ? seq.getMem(1) : null;
                    }
                    if (src instanceof BaseRecord) {
                        r = (BaseRecord)src;
                        r.getNormalFieldValue(col, result);
                    } else if (src == null) {
                        result.push(null);
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                    }
                    ++i;
                }
                return result;
            }
        }
        if ((f = this.ds.getFieldIndex(fieldName)) != -1) {
            return this._$1[f];
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
    }

    public IArray getFieldValueArray(IArray posArray, String fieldName) {
        IArray valueArray = this.getFieldValueArray(fieldName);
        if (valueArray != null) {
            return valueArray.get(posArray);
        }
        return new ConstArray(null, posArray.size());
    }

    public IArray getFieldValueArray(IArray posArray, int field) {
        IArray valueArray = this.getFieldValueArray(field);
        if (valueArray != null) {
            return valueArray.get(posArray);
        }
        return new ConstArray(null, posArray.size());
    }

    public Object getFieldValue(int row, int field) {
        return this._$1[field].get(row);
    }

    public Object getFieldValue(int row, String field) {
        int index = this.ds.getFieldIndex(field);
        if (index != -1) {
            return this._$1[index].get(row);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(field + mm.getMessage("ds.fieldNotExist"));
    }

    public Object[] getFieldValues(int row) {
        int fcount = this._$1.length;
        Object[] result = new Object[fcount];
        for (int f = 0; f < fcount; ++f) {
            result[f] = this._$1[f].get(row);
        }
        return result;
    }

    public void setFieldValue(int row, int field, Object val) {
        this._$1[field].set(row, val);
    }

    public void setFieldValue(int row, String field, Object val) {
        int index = this.ds.getFieldIndex(field);
        if (index == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(field + mm.getMessage("ds.fieldNotExist"));
        }
        this._$1[index].set(row, val);
    }

    public int compareRecords(int r1, int r2) {
        IArray[] colDatas;
        for (IArray array : colDatas = this._$1) {
            int cmp = array.memberCompare(r1, r2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IArray getMems() {
        if (this.mems == null) {
            PureTable pureTable = this;
            synchronized (pureTable) {
                if (this.mems != null) {
                    return this.mems;
                }
                int size = this._$1 == null ? 0 : this._$1[0].size();
                ObjectArray array = new ObjectArray(size);
                for (int i = 1; i <= size; ++i) {
                    PureRecord r = new PureRecord(this, i);
                    array.push((Object)r);
                }
                this.mems = array;
            }
        }
        return this.mems;
    }

    public IArray getCurrentMems() {
        if (this.ds.getFieldName(0).equals("~")) {
            return this._$1[0];
        }
        return this.getMems();
    }

    public Object getMem(int seq) {
        return this.getMems().get(seq);
    }

    public Object get(int seq) {
        if (seq < 1 || seq > this.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(seq + mm.getMessage("engine.indexOutofBound"));
        }
        return this.getMems().get(seq);
    }

    public Table get(int start, int end) {
        int fcount = this._$1.length;
        IArray[] resultDatas = new IArray[fcount];
        for (int i = 0; i < fcount; ++i) {
            resultDatas[i] = this._$1[i].get(start, end);
        }
        return new PureTable(this.ds, resultDatas);
    }

    public PureTable get(IntArray indexArray) {
        int fcount = this._$1.length;
        IArray[] resultDatas = new IArray[fcount];
        for (int i = 0; i < fcount; ++i) {
            resultDatas[i] = this._$1[i].get((IArray)indexArray);
        }
        return new PureTable(this.ds, resultDatas);
    }

    public PureTable get(int[] indexArray) {
        int fcount = this._$1.length;
        IArray[] resultDatas = new IArray[fcount];
        for (int i = 0; i < fcount; ++i) {
            resultDatas[i] = this._$1[i].get(indexArray);
        }
        return new PureTable(this.ds, resultDatas);
    }

    public BaseRecord getRecord(int pos) {
        if (pos < 1 || pos > this.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos + mm.getMessage("engine.indexOutofBound"));
        }
        return (BaseRecord)this.getMems().get(pos);
    }

    public IArray[] getPKArrays() {
        if (this.length() == 0) {
            return null;
        }
        int[] pks = this.ds.getPKIndex();
        if (pks == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        if (pks.length == 1) {
            return new IArray[]{this._$1[pks[0]]};
        }
        int pkCount = pks.length;
        IArray[] arrays = new IArray[pkCount];
        for (int i = 0; i < pkCount; ++i) {
            arrays[i] = this._$1[pks[i]];
        }
        return arrays;
    }

    public Sequence getPKeyValues() {
        int len = this.length();
        if (len == 0) {
            return new Sequence(0);
        }
        int[] pks = this.ds.getPKIndex();
        if (pks == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        if (pks.length == 1) {
            IArray result = this._$1[pks[0]];
            return new Sequence(result);
        }
        IArray[] colDatas = this._$1;
        int keyCount = pks.length;
        ObjectArray result = new ObjectArray(len);
        for (int i = 1; i <= len; ++i) {
            Sequence seq = new Sequence(keyCount);
            result.push((Object)seq);
            for (int k = 0; k < keyCount; ++k) {
                Object obj = colDatas[pks[k]].get(i);
                if (obj instanceof BaseRecord) {
                    obj = ((BaseRecord)obj).getPKValue();
                }
                if (obj instanceof Sequence) {
                    seq.addAll((Sequence)obj);
                    continue;
                }
                seq.add(obj);
            }
        }
        return new Sequence((IArray)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence align(Expression exp, int n, String opt, Context ctx) {
        IArray valArray;
        int valSize;
        boolean isAll = false;
        boolean isRepeat = false;
        boolean isPos = false;
        boolean isPure = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                isAll = true;
            }
            if (opt.indexOf(112) != -1) {
                isPos = true;
            } else if (opt.indexOf(118) != -1) {
                isPure = true;
            }
            if (opt.indexOf(114) != -1) {
                isAll = true;
                isRepeat = true;
            }
        }
        if ((valSize = this.length()) == 0) {
            Sequence result = new Sequence(valSize);
            if (isAll) {
                for (int i = 0; i < n; ++i) {
                    result.add((Object)new Sequence(0));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    result.add(null);
                }
            }
            return result;
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            valArray = exp.calculateAll(ctx);
        }
        finally {
            stack.pop();
        }
        if (isPure) {
            if (isAll) {
                Object[] resultVals = new Object[n + 1];
                ObjectArray resultArray = new ObjectArray(resultVals, n);
                IArray[] colDatas = this._$1;
                int fcount = colDatas.length;
                int[] seqs = new int[valSize];
                if (isRepeat) {
                    for (int k = 1; k <= n; ++k) {
                        int curCount = 0;
                        block6: for (int i = 1; i <= valSize; ++i) {
                            Object val = valArray.get(i);
                            if (val instanceof Sequence) {
                                IArray posArray = ((Sequence)val).getMems();
                                int count = posArray.size();
                                for (int p = 1; p <= count; ++p) {
                                    if (posArray.isNull(i) || posArray.getInt(i) != k) continue;
                                    seqs[curCount++] = i;
                                    continue block6;
                                }
                                continue;
                            }
                            if (val == null) continue;
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("engine.needIntSeries"));
                        }
                        if (curCount > 0) {
                            IArray[] resultDatas = new IArray[fcount];
                            for (int f = 0; f < fcount; ++f) {
                                resultDatas[f] = colDatas[f].get(seqs, 0, curCount - 1, false);
                            }
                            resultVals[k] = new PureTable(this.ds, resultDatas);
                            continue;
                        }
                        resultVals[k] = new PureTable(this.ds);
                    }
                } else {
                    for (int k = 1; k <= n; ++k) {
                        int curCount = 0;
                        for (int i = 1; i <= valSize; ++i) {
                            if (valArray.isNull(i) || valArray.getInt(i) != k) continue;
                            seqs[curCount++] = i;
                        }
                        if (curCount > 0) {
                            IArray[] resultDatas = new IArray[fcount];
                            for (int f = 0; f < fcount; ++f) {
                                resultDatas[f] = colDatas[f].get(seqs, 0, curCount - 1, false);
                            }
                            resultVals[k] = new PureTable(this.ds, resultDatas);
                            continue;
                        }
                        resultVals[k] = new PureTable(this.ds);
                    }
                }
                return new Sequence((IArray)resultArray);
            }
            int[] seqs = new int[n + 1];
            for (int i = 1; i <= valSize; ++i) {
                int index;
                if (valArray.isNull(i) || (index = valArray.getInt(i)) <= 0 || index > n || seqs[index] != 0) continue;
                seqs[index] = i;
            }
            IArray[] colDatas = this._$1;
            int fcount = colDatas.length;
            IArray[] resultDatas = new IArray[fcount];
            for (int f = 0; f < fcount; ++f) {
                resultDatas[f] = colDatas[f].get(seqs, 1, n, true);
            }
            return new PureTable(this.ds, resultDatas);
        }
        if (isPos) {
            if (isAll) {
                int i;
                Object[] resultVals = new Sequence[n];
                for (i = 0; i < n; ++i) {
                    resultVals[i] = new Sequence(4);
                }
                if (isRepeat) {
                    for (i = 1; i <= valSize; ++i) {
                        Object val = valArray.get(i);
                        if (val instanceof Sequence) {
                            IArray posArray = ((Sequence)val).getMems();
                            int count = posArray.size();
                            for (int p = 1; p <= count; ++p) {
                                int index = posArray.getInt(p);
                                if (index <= 0 || index > n) continue;
                                resultVals[index - 1].add((Object)ObjectCache.getInteger((int)i));
                            }
                            continue;
                        }
                        if (val == null) continue;
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needIntSeries"));
                    }
                } else {
                    for (i = 1; i <= valSize; ++i) {
                        int index;
                        if (valArray.isNull(i) || (index = valArray.getInt(i)) <= 0 || index > n) continue;
                        resultVals[index - 1].add((Object)ObjectCache.getInteger((int)i));
                    }
                }
                return new Sequence(resultVals);
            }
            Object[] resultVals = new Object[n + 1];
            ObjectArray resultArray = new ObjectArray(resultVals, n);
            for (int i = 1; i <= valSize; ++i) {
                int index;
                if (valArray.isNull(i) || (index = valArray.getInt(i)) <= 0 || index > n || resultVals[index] != null) continue;
                resultVals[index] = ObjectCache.getInteger((int)i);
            }
            return new Sequence((IArray)resultArray);
        }
        if (isAll) {
            int i;
            IArray mems = this.getMems();
            Object[] resultVals = new Sequence[n];
            for (i = 0; i < n; ++i) {
                resultVals[i] = new Sequence(4);
            }
            if (isRepeat) {
                for (i = 1; i <= valSize; ++i) {
                    Object val = valArray.get(i);
                    if (val instanceof Sequence) {
                        IArray posArray = ((Sequence)val).getMems();
                        int count = posArray.size();
                        for (int p = 1; p <= count; ++p) {
                            int index = posArray.getInt(p);
                            if (index <= 0 || index > n) continue;
                            resultVals[index - 1].add(mems.get(i));
                        }
                        continue;
                    }
                    if (val == null) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needIntSeries"));
                }
            } else {
                for (i = 1; i <= valSize; ++i) {
                    int index;
                    if (valArray.isNull(i) || (index = valArray.getInt(i)) <= 0 || index > n) continue;
                    resultVals[index - 1].add(mems.get(i));
                }
            }
            return new Sequence(resultVals);
        }
        Object[] resultVals = new Object[n + 1];
        ObjectArray resultArray = new ObjectArray(resultVals, n);
        IArray mems = this.getMems();
        for (int i = 1; i <= valSize; ++i) {
            int index;
            if (valArray.isNull(i) || (index = valArray.getInt(i)) <= 0 || index > n || resultVals[index] != null) continue;
            resultVals[index] = mems.get(i);
        }
        return new Sequence((IArray)resultArray);
    }

    public IGroupsResult getGroupsResult(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        return new GroupsResult(exps, names, calcExps, calcNames, opt, ctx);
    }

    public Table groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        return this.groups(exps, names, calcExps, calcNames, opt, ctx, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int hashCapacity) {
        if (opt != null && opt.indexOf(122) != -1) {
            opt = opt.replace("m", "");
        }
        if (opt != null && opt.indexOf(109) != -1) {
            int len = this.length();
            int parallelNum = Env.getParallelNum();
            if (len > MultithreadUtil.SINGLE_PROSS_COUNT && parallelNum > 1) {
                opt = opt.replace("m", "");
                ICursor cs = CursorUtil.cursor((Sequence)this, (int)parallelNum, (String)opt, (Context)ctx);
                return cs.groups(exps, names, calcExps, calcNames, opt, ctx);
            }
        } else if (opt != null && opt.indexOf(122) != -1) {
            IntArray hashValue;
            IArray[] key;
            int capacity = hashCapacity > 0 ? hashCapacity : Env.getDefaultHashCapacity();
            HashUtil hashUtil = new HashUtil(capacity);
            capacity = hashUtil.getCapacity();
            int parallelNum = Env.getParallelNum();
            ThreadPool pool = ThreadPool.newInstance((int)parallelNum);
            GroupsJob2[] jobs = new GroupsJob2[parallelNum];
            int keyCount = exps.length;
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current((Sequence)this);
            stack.push((IComputeItem)current);
            try {
                int len = this.length();
                int[] hash = new int[len + 1];
                if (keyCount == 1) {
                    IArray[] array = exps[0].calculateAll(ctx);
                    for (int i = 1; i <= len; ++i) {
                        hash[i] = hashUtil.hashCode(array.hashCode(i));
                    }
                    key = array;
                } else {
                    IArray[] arrays = new IArray[keyCount];
                    int[] hashCodes = new int[keyCount];
                    for (int k = 0; k < keyCount; ++k) {
                        arrays[k] = exps[k].calculateAll(ctx);
                    }
                    for (int i = 1; i <= len; ++i) {
                        for (int k = 0; k < keyCount; ++k) {
                            hashCodes[k] = arrays[k].hashCode(i);
                        }
                        hash[i] = hashUtil.hashCode(hashCodes, keyCount);
                    }
                    key = arrays;
                }
                hashValue = new IntArray(hash, null, len);
            }
            finally {
                stack.pop();
            }
            Table groupsResult = null;
            try {
                int i;
                for (i = 0; i < parallelNum; ++i) {
                    Context tmpCtx = ctx.newComputeContext();
                    Expression[] tmpExps = Operation.dupExpressions((Expression[])exps, (Context)tmpCtx);
                    Expression[] tmpCalcExps = Operation.dupExpressions((Expression[])calcExps, (Context)tmpCtx);
                    GroupsJob2 job = new GroupsJob2((Sequence)this, (Object)key, hashValue, tmpExps, names, tmpCalcExps, calcNames, opt, tmpCtx, capacity);
                    job.setHashStart(i);
                    job.setHashEnd(parallelNum);
                    jobs[i] = job;
                    pool.submit((Job)jobs[i]);
                }
                for (i = 0; i < parallelNum; ++i) {
                    jobs[i].join();
                    if (i == 0) {
                        groupsResult = jobs[i].getGroupsResult().getResultTable();
                        continue;
                    }
                    Table t = jobs[i].getGroupsResult().getResultTable();
                    groupsResult.addAll((Sequence)t);
                }
            }
            finally {
                pool.shutdown();
            }
            return groupsResult;
        }
        GroupsResult groupsResult = new GroupsResult(exps, names, calcExps, calcNames, opt, ctx);
        groupsResult.push((Sequence)this, ctx);
        return groupsResult.getResultTable();
    }

    public Sequence group(Expression exp, String opt, Context ctx) {
        if (this.length() == 0) {
            return new Sequence(0);
        }
        if (opt != null) {
            if (opt.indexOf(111) != -1) {
                return this._$2(exp, opt, ctx);
            }
            if (opt.indexOf(110) != -1) {
                return this._$1(exp, opt, ctx);
            }
        }
        Object result = super.group(exp, opt, ctx);
        if (opt != null && opt.indexOf(118) != -1) {
            if (opt.indexOf(115) != -1 || opt.indexOf(49) != -1) {
                if (result.length() > 0) {
                    result = new PureTable((Sequence)result);
                }
            } else {
                IArray resultMems = result.getMems();
                int resultLen = resultMems.size();
                for (int i = 1; i <= resultLen; ++i) {
                    Sequence seq = (Sequence)resultMems.get(i);
                    resultMems.set(i, (Object)new PureTable(seq));
                }
            }
        }
        return result;
    }

    public Sequence group(Expression[] exps, String opt, Context ctx) {
        int keyCount = exps.length;
        if (keyCount == 1) {
            return this.group(exps[0], opt, ctx);
        }
        Object result = super.group(exps, opt, ctx);
        if (opt != null && opt.indexOf(118) != -1) {
            if (opt.indexOf(115) != -1 || opt.indexOf(49) != -1) {
                if (result.length() > 0) {
                    result = new PureTable((Sequence)result);
                }
            } else {
                IArray resultMems = result.getMems();
                int resultLen = resultMems.size();
                for (int i = 1; i <= resultLen; ++i) {
                    Sequence seq = (Sequence)resultMems.get(i);
                    resultMems.set(i, (Object)new PureTable(seq));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence _$2(Expression exp, String opt, Context ctx) {
        IArray valArray;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            valArray = exp.calculateAll(ctx);
        }
        finally {
            stack.pop();
        }
        int size = valArray.size();
        Object result = new Sequence(size / 4);
        int start = 1;
        if (opt.indexOf(48) != -1) {
            for (int i = 1; i <= size && valArray.isNull(i); ++i) {
                ++start;
            }
            if (start > size) {
                return new Sequence(0);
            }
        }
        if (opt.indexOf(49) == -1) {
            if (opt.indexOf(118) != -1) {
                IArray[] srcArrays = this._$1;
                int fcount = srcArrays.length;
                int last = size + 1;
                for (int i = start + 1; i < last; ++i) {
                    if (valArray.isMemberEquals(start, i)) continue;
                    IArray[] resultArrays = new IArray[fcount];
                    for (int f = 0; f < fcount; ++f) {
                        resultArrays[f] = srcArrays[f].get(start, i);
                    }
                    PureTable group = new PureTable(this.ds, resultArrays);
                    result.add((Object)group);
                    start = i;
                }
                IArray[] resultArrays = new IArray[fcount];
                for (int f = 0; f < fcount; ++f) {
                    resultArrays[f] = srcArrays[f].get(start, last);
                }
                PureTable group = new PureTable(this.ds, resultArrays);
                result.add((Object)group);
            } else {
                IArray mems = this.getMems();
                Sequence group = new Sequence();
                group.add(mems.get(start));
                result.add((Object)group);
                for (int i = start + 1; i <= size; ++i) {
                    if (valArray.isMemberEquals(i - 1, i)) {
                        group.add(mems.get(i));
                        continue;
                    }
                    group = new Sequence();
                    group.add(mems.get(i));
                    result.add((Object)group);
                }
            }
        } else if (opt.indexOf(118) != -1) {
            IArray[] srcArrays = this._$1;
            int fcount = srcArrays.length;
            IArray[] resultArrays = new IArray[fcount];
            int initLen = size / 2;
            for (int f = 0; f < fcount; ++f) {
                resultArrays[f] = this._$1[f].newInstance(initLen);
                resultArrays[f].push(this._$1[f], start);
            }
            for (int i = start + 1; i <= size; ++i) {
                if (valArray.isMemberEquals(i - 1, i)) continue;
                for (int f = 0; f < fcount; ++f) {
                    resultArrays[f].add(this._$1[f], i);
                }
            }
            result = new PureTable(this.ds, resultArrays);
        } else {
            IArray mems = this.getMems();
            result = new Sequence(size / 2);
            result.add(mems.get(start));
            for (int i = start + 1; i <= size; ++i) {
                if (valArray.isMemberEquals(i - 1, i)) continue;
                result.add(mems.get(i));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence _$1(Expression exp, String opt, Context ctx) {
        IArray posArray;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            posArray = exp.calculateAll(ctx);
        }
        finally {
            stack.pop();
        }
        IArray mems = this.getMems();
        int size = posArray.size();
        Object result = new Sequence(size / 4);
        IArray resultMems = result.getMems();
        int len = 0;
        if (opt.indexOf(49) == -1) {
            int i;
            for (i = 1; i <= size; ++i) {
                int index = posArray.getInt(i);
                if (index > len) {
                    resultMems.ensureCapacity(index);
                    for (int j = len; j < index; ++j) {
                        resultMems.add((Object)new Sequence(7));
                    }
                    len = index;
                } else if (index < 1) continue;
                Sequence group = (Sequence)resultMems.get(index);
                group.add(mems.get(i));
            }
            if (opt.indexOf(115) != -1) {
                result = result.conj(null);
                if (opt.indexOf(118) != -1 && result.length() > 0) {
                    result = new PureTable((Sequence)result);
                }
            } else if (opt.indexOf(48) != -1) {
                result.deleteNull(true);
                if (opt.indexOf(118) != -1) {
                    int resultLen = resultMems.size();
                    for (i = 1; i <= resultLen; ++i) {
                        Sequence seq = (Sequence)resultMems.get(i);
                        resultMems.set(i, (Object)new PureTable(seq));
                    }
                }
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                int index = posArray.getInt(i);
                if (index > len) {
                    resultMems.ensureCapacity(index);
                    for (int j = len; j < index; ++j) {
                        resultMems.add(null);
                    }
                    len = index;
                } else if (index < 1) continue;
                if (resultMems.get(index) != null) continue;
                resultMems.set(index, mems.get(i));
            }
            if (opt.indexOf(48) != -1) {
                result.deleteNull(false);
                if (opt.indexOf(118) != -1 && result.length() > 0) {
                    result = new PureTable((Sequence)result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object maxp(Expression exp, String opt, Context ctx) {
        int len;
        boolean bAll = false;
        boolean bLast = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                bAll = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
        }
        if ((len = this.length()) == 0) {
            return bAll ? new Sequence(0) : null;
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            IArray array = exp.calculateAll(ctx);
            IntArray indexArray = array.ptop(-1, bAll, bLast, true);
            int resultSize = indexArray.size();
            if (resultSize == 0) {
                if (bAll) {
                    Sequence sequence = new Sequence();
                    return sequence;
                }
                Object var12_13 = null;
                return var12_13;
            }
            if (bAll) {
                IArray mems = this.getMems();
                Sequence result = new Sequence(resultSize);
                for (int i = 1; i <= resultSize; ++i) {
                    result.add(mems.get(indexArray.getInt(i)));
                }
                Sequence sequence = result;
                return sequence;
            }
            Object object = this.getMem(indexArray.getInt(1));
            return object;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object minp(Expression exp, String opt, Context ctx) {
        int len;
        boolean bAll = false;
        boolean bLast = false;
        boolean ignoreNull = true;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                bAll = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
            if (opt.indexOf(48) != -1) {
                ignoreNull = false;
            }
        }
        if ((len = this.length()) == 0) {
            return bAll ? new Sequence(0) : null;
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            IArray array = exp.calculateAll(ctx);
            IntArray indexArray = array.ptop(1, bAll, bLast, ignoreNull);
            int resultSize = indexArray.size();
            if (resultSize == 0) {
                if (bAll) {
                    Sequence sequence = new Sequence();
                    return sequence;
                }
                Object var13_14 = null;
                return var13_14;
            }
            if (bAll) {
                IArray mems = this.getMems();
                Sequence result = new Sequence(resultSize);
                for (int i = 1; i <= resultSize; ++i) {
                    result.add(mems.get(indexArray.getInt(i)));
                }
                Sequence sequence = result;
                return sequence;
            }
            Object object = this.getMem(indexArray.getInt(1));
            return object;
        }
        finally {
            stack.pop();
        }
    }

    public Sequence multiply(int k) {
        int len = this.length();
        if (len == 0) {
            return new PureTable(this.ds);
        }
        int fcount = this._$1.length;
        IArray[] resultArrays = new IArray[fcount];
        for (int f = 0; f < fcount; ++f) {
            IArray array = this._$1[f];
            resultArrays[f] = array.newInstance(len * k);
            for (int i = 0; i < k; ++i) {
                resultArrays[f].addAll(array);
            }
        }
        return new PureTable(this.ds, resultArrays);
    }

    public Object nvl(Expression exp, Context ctx) {
        return this.calc(exp, ctx).nvl();
    }

    public int pfindByKey(Object key, boolean isSorted) {
        int len = this.length();
        if (len == 0) {
            return -1;
        }
        int[] pks = this.ds.getPKIndex();
        if (pks == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        int keyCount = pks.length;
        if (isSorted) {
            if (keyCount == 1) {
                return this._$1[pks[0]].binarySearch(key);
            }
            if (this.ds.getTimeKeyCount() > 0) {
                return super.pfindByKey(key, isSorted);
            }
            if (!(key instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
            }
            Sequence seq = (Sequence)key;
            if (seq.length() != keyCount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
            }
            IArray keyMems = seq.getMems();
            IArray[] colDatas = this._$1;
            int low = 1;
            int high = len;
            int cmp = 0;
            while (low <= high) {
                int mid = low + high >> 1;
                for (int k = 0; k < keyCount && (cmp = colDatas[pks[k]].compareTo(mid, keyMems, k + 1)) == 0; ++k) {
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low;
        }
        if (this.indexTable != null) {
            if (keyCount == 1) {
                return this.indexTable.findPos(key);
            }
            if (this.ds.getTimeKeyCount() > 0) {
                if (key instanceof Sequence) {
                    Sequence seq = (Sequence)key;
                    int valueCount = seq.length();
                    if (valueCount == keyCount || valueCount == keyCount - 1) {
                        return this.indexTable.findPos(seq.toArray());
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
                }
                if (keyCount == 2) {
                    return this.indexTable.findPos(key);
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
            }
            if (!(key instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
            }
            Sequence seq = (Sequence)key;
            int valueCount = seq.length();
            if (valueCount == keyCount) {
                return this.indexTable.findPos(seq.toArray());
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
        }
        if (keyCount == 1) {
            return this._$1[pks[0]].firstIndexOf(key, 1);
        }
        if (this.ds.getTimeKeyCount() > 0) {
            return super.pfindByKey(key, isSorted);
        }
        if (!(key instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
        }
        Sequence seq = (Sequence)key;
        if (seq.length() != keyCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
        }
        IArray[] colDatas = this._$1;
        Object[] keyVals = seq.toArray();
        int index = 1;
        block2: while (index <= len) {
            int k;
            int pos = index;
            for (k = 0; k < keyCount; ++k) {
                if ((pos = colDatas[pks[k]].firstIndexOf(keyVals[k], pos)) >= 1) continue;
                return 0;
            }
            if (pos == index) {
                return pos;
            }
            int count = keyCount - 1;
            for (k = 0; k < count; ++k) {
                if (colDatas[pks[k]].isEquals(pos, keyVals[k])) continue;
                index = pos + 1;
                continue block2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pmax(Expression exp, String opt, Context ctx) {
        if (this.length() == 0) {
            if (opt == null || opt.indexOf(97) == -1) {
                return null;
            }
            return new Sequence(0);
        }
        boolean bAll = false;
        boolean bLast = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                bAll = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            IArray array = exp.calculateAll(ctx);
            IntArray indexArray = array.ptop(-1, bAll, bLast, true);
            if (bAll) {
                Sequence sequence = new Sequence((IArray)indexArray);
                return sequence;
            }
            Object object = indexArray.get(1);
            return object;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pmin(Expression exp, String opt, Context ctx) {
        if (this.length() == 0) {
            if (opt == null || opt.indexOf(97) == -1) {
                return null;
            }
            return new Sequence(0);
        }
        boolean bAll = false;
        boolean bLast = false;
        boolean ignoreNull = true;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                bAll = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
            if (opt.indexOf(48) != -1) {
                ignoreNull = false;
            }
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            IArray array = exp.calculateAll(ctx);
            IntArray indexArray = array.ptop(1, bAll, bLast, ignoreNull);
            if (bAll) {
                Sequence sequence = new Sequence((IArray)indexArray);
                return sequence;
            }
            Object object = indexArray.get(1);
            return object;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pselect(Expression exp, String opt, Context ctx) {
        if (opt == null || opt.indexOf(97) == -1 || opt.indexOf(98) != -1) {
            return super.pselect(exp, opt, ctx);
        }
        int size = this.length();
        if (size == 0) {
            if (opt.indexOf(48) != -1) {
                return null;
            }
            return new Sequence(0);
        }
        if (exp == null) {
            return new Sequence(1, this.length());
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            IArray array = exp.calculateAll(ctx);
            int count = array.count();
            if (count == 0) {
                if (opt.indexOf(48) != -1) {
                    Object var9_9 = null;
                    return var9_9;
                }
                Sequence sequence = new Sequence(0);
                return sequence;
            }
            ObjectArray resultArray = new ObjectArray(count);
            for (int i = 1; i <= size; ++i) {
                if (!array.isTrue(i)) continue;
                resultArray.push((Object)ObjectCache.getInteger((int)i));
            }
            Sequence sequence = new Sequence((IArray)resultArray);
            return sequence;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pselect(Expression[] fltExps, Object[] vals, String opt, Context ctx) {
        Sequence result;
        int len;
        boolean isAll = false;
        boolean isLast = false;
        boolean isSorted = false;
        boolean isInsertPos = false;
        boolean isN = false;
        boolean isZero = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                isAll = true;
            }
            if (opt.indexOf(122) != -1) {
                isLast = true;
            }
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
            if (opt.indexOf(115) != -1) {
                isSorted = true;
                isInsertPos = true;
            }
            if (opt.indexOf(110) != -1) {
                isN = true;
            }
            if (opt.indexOf(48) != -1) {
                isZero = true;
            }
        }
        if ((len = this.length()) == 0) {
            if (isInsertPos) {
                return -1;
            }
            if (isAll) {
                if (opt.indexOf(48) != -1) {
                    return null;
                }
                return new Sequence(0);
            }
            if (isZero) {
                return ObjectCache.getInteger((int)0);
            }
            if (isN) {
                return ObjectCache.getInteger((int)1);
            }
            return null;
        }
        int colCount = fltExps.length;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        IArray[] arrays = new IArray[colCount];
        try {
            for (int c = 0; c < colCount; ++c) {
                arrays[c] = fltExps[c].calculateAll(ctx);
            }
        }
        finally {
            stack.pop();
        }
        if (isSorted) {
            int first;
            int c;
            int low = 1;
            int high = len;
            int pos = -1;
            while (low <= high) {
                int mid = low + high >> 1;
                int cmp = 0;
                for (c = 0; c < colCount && (cmp = arrays[c].compareTo(mid, vals[c])) == 0; ++c) {
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                pos = mid;
                break;
            }
            if (pos == -1) {
                if (isAll) {
                    if (isZero) {
                        return null;
                    }
                    return new Sequence(0);
                }
                if (isInsertPos) {
                    return -low;
                }
                if (isZero) {
                    return ObjectCache.getInteger((int)0);
                }
                if (isN) {
                    return ObjectCache.getInteger((int)(len + 1));
                }
                return null;
            }
            int last = pos;
            if (isAll || !isLast) {
                block6: for (first = pos; first > 1; --first) {
                    for (c = 0; c < colCount; ++c) {
                        if (!arrays[c].isEquals(first - 1, vals[c])) break block6;
                    }
                }
            }
            if (isAll || isLast) {
                block8: while (last < len) {
                    for (c = 0; c < colCount; ++c) {
                        if (!arrays[c].isEquals(last + 1, vals[c])) break block8;
                    }
                    ++last;
                }
            }
            if (isAll) {
                Sequence result2 = new Sequence(last - first + 1);
                IArray resultMems = result2.getMems();
                if (isLast) {
                    while (last >= first) {
                        resultMems.add((Object)ObjectCache.getInteger((int)last));
                        --last;
                    }
                } else {
                    while (first <= last) {
                        resultMems.add((Object)ObjectCache.getInteger((int)first));
                        ++first;
                    }
                }
                return result2;
            }
            return ObjectCache.getInteger((int)(isLast ? last : first));
        }
        Sequence sequence = result = isAll ? new Sequence() : null;
        if (isLast) {
            block12: for (int i = len; i > 0; --i) {
                for (int c = 0; c < colCount; ++c) {
                    if (!arrays[c].isEquals(i, vals[c])) continue block12;
                }
                if (!isAll) {
                    return i;
                }
                result.add((Object)i);
            }
        } else {
            block14: for (int i = 1; i <= len; ++i) {
                for (int c = 0; c < colCount; ++c) {
                    if (!arrays[c].isEquals(i, vals[c])) continue block14;
                }
                if (!isAll) {
                    return i;
                }
                result.add((Object)i);
            }
        }
        if (isAll) {
            if (isZero && result.length() == 0) {
                return null;
            }
            return result;
        }
        if (isZero) {
            return ObjectCache.getInteger((int)0);
        }
        if (isN) {
            return ObjectCache.getInteger((int)(len + 1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object ptop(int count, Expression exp, String opt, Context ctx) {
        int len = this.length();
        if (len == 0 || count == 0) {
            return null;
        }
        if (exp.isConstExpression()) {
            if (opt == null || opt.indexOf(49) == -1) {
                if (count > 0) {
                    if (count > len) {
                        count = len;
                    }
                    IntArray result = new IntArray(count);
                    for (int i = 1; i <= count; ++i) {
                        result.pushInt(i);
                    }
                    return new Sequence((IArray)result);
                }
                IntArray result = new IntArray(-count);
                int i = len + count + 1;
                if (i < 1) {
                    i = 1;
                }
                while (i <= len) {
                    result.pushInt(i);
                    ++i;
                }
                return new Sequence((IArray)result);
            }
            if (count > 0) {
                return ObjectCache.getInteger((int)1);
            }
            return ObjectCache.getInteger((int)len);
        }
        boolean bAll = true;
        boolean ignoreNull = true;
        boolean isRank = false;
        boolean isDistinct = false;
        if (opt != null) {
            if (opt.indexOf(49) != -1) {
                bAll = false;
            }
            if (opt.indexOf(48) != -1) {
                ignoreNull = false;
            }
            if (opt.indexOf(105) != -1) {
                isRank = true;
                isDistinct = true;
            } else if (opt.indexOf(114) != -1) {
                isRank = true;
            }
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            IArray array = exp.calculateAll(ctx);
            IntArray indexArray = isRank ? array.ptopRank(count, ignoreNull, isDistinct) : array.ptop(count, bAll, false, ignoreNull);
            if (bAll) {
                Sequence sequence = new Sequence((IArray)indexArray);
                return sequence;
            }
            Object object = indexArray.get(1);
            return object;
        }
        finally {
            stack.pop();
        }
    }

    public void reserve(int start, int end) {
        int size = this.length();
        if (size == 0) {
            return;
        }
        if (start == 0) {
            start = 1;
        } else if (start < 0 && (start += size + 1) < 1) {
            start = 1;
        }
        if (end == 0) {
            end = size;
        } else if (end < 0) {
            end += size + 1;
        } else if (end > size) {
            end = size;
        }
        if (end < start) {
            this._$1 = null;
            this.mems = null;
        } else if (start != 1 || end != size) {
            if (this.mems != null) {
                this.mems.reserve(start, end);
            }
            for (IArray array : this._$1) {
                array.reserve(start, end);
            }
        }
    }

    public void reset() {
        this.mems = null;
        if (this.length() > 0) {
            for (IArray array : this._$1) {
                array.clear();
            }
        }
    }

    public Sequence rvs() {
        if (this.length() == 0) {
            return new Table(this.ds);
        }
        int fcount = this._$1.length;
        IArray[] resultDatas = new IArray[fcount];
        for (int f = 0; f < fcount; ++f) {
            resultDatas[f] = this._$1[f].rvs();
        }
        return new PureTable(this.ds, resultDatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object select(Expression exp, String opt, Context ctx) {
        int len;
        boolean isForward = true;
        boolean isBool = true;
        boolean isTable = false;
        boolean isZero = false;
        if (opt != null) {
            if (opt.indexOf(109) != -1) {
                return ParallelUtil.select(this, exp, opt, ctx);
            }
            if (opt.indexOf(49) != -1) {
                return super.select(exp, opt, ctx);
            }
            if (opt.indexOf(122) != -1) {
                isForward = false;
            }
            if (opt.indexOf(98) != -1) {
                isBool = false;
            }
            if (opt.indexOf(48) != -1) {
                isZero = true;
            }
            if (opt.indexOf(118) != -1 || opt.indexOf(105) != -1) {
                isTable = true;
            }
        }
        if ((len = this.length()) == 0) {
            if (isTable) {
                return this;
            }
            if (isZero) {
                return null;
            }
            return new Sequence(0);
        }
        if (exp == null) {
            if (isTable) {
                return this;
            }
            IArray array = this.getMems().dup();
            return new Sequence(array);
        }
        if (isBool) {
            IArray signArray;
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current((Sequence)this);
            stack.push((IComputeItem)current);
            try {
                signArray = exp.calculateAll(ctx);
            }
            finally {
                stack.pop();
            }
            if (isTable) {
                int fcount = this._$1.length;
                IArray[] resultDatas = new IArray[fcount];
                for (int f = 0; f < fcount; ++f) {
                    resultDatas[f] = this._$1[f].select(signArray);
                }
                return new PureTable(this.ds, resultDatas);
            }
            int count = signArray.count();
            if (count == 0) {
                if (isZero) {
                    return null;
                }
                return new Sequence(0);
            }
            IArray mems = this.getMems();
            ObjectArray resultArray = new ObjectArray(count);
            for (int i = 1; i <= len; ++i) {
                if (!signArray.isTrue(i)) continue;
                resultArray.push(mems.get(i));
            }
            return new Sequence((IArray)resultArray);
        }
        Regions regions = this.binarySelect(exp.getHome(), this.ds, ctx);
        if (regions == null) {
            Sequence result = this._$1(exp, isForward, isTable, ctx);
            if (isZero && result.length() == 0) {
                return null;
            }
            return result;
        }
        if (isTable) {
            ArrayList list = regions.getRegionList();
            if (list.size() == 1) {
                Region region = (Region)list.get(0);
                return this.get(region.start, region.end + 1);
            }
            int total = 0;
            for (Region region : list) {
                total += region.end - region.start + 1;
            }
            int fcount = this._$1.length;
            IArray[] resultDatas = new IArray[fcount];
            for (int f = 0; f < fcount; ++f) {
                IArray resultArray;
                IArray array = this._$1[f];
                resultDatas[f] = resultArray = array.newInstance(total);
                for (Region region : list) {
                    int end = region.end;
                    for (int n = region.start; n <= end; ++n) {
                        resultArray.push(array, n);
                    }
                }
            }
            return new PureTable(this.ds, resultDatas);
        }
        ArrayList list = regions.getRegionList();
        int total = 0;
        for (Region region : list) {
            total += region.end - region.start + 1;
        }
        if (total == 0) {
            if (isZero) {
                return null;
            }
            return new Sequence(0);
        }
        IArray mems = this.getMems();
        ObjectArray resultArray = new ObjectArray(total);
        for (Region region : list) {
            int end = region.end;
            for (int i = region.start; i <= end; ++i) {
                resultArray.push(mems.get(i));
            }
        }
        return new Sequence((IArray)resultArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence _$1(Expression exp, boolean isForward, boolean isTable, Context ctx) {
        int last;
        int first;
        block26: {
            int size = this.length();
            first = 0;
            last = 0;
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current((Sequence)this);
            stack.push((IComputeItem)current);
            try {
                MessageManager mm;
                current.setCurrent(1);
                Object objFirst = exp.calculate(ctx);
                current.setCurrent(size);
                Object objLast = exp.calculate(ctx);
                if (!(objFirst instanceof Number) || !(objLast instanceof Number)) {
                    MessageManager mm2 = EngineMessage.get();
                    throw new RQException(mm2.getMessage("engine.needIntExp"));
                }
                double valFirst = ((Number)objFirst).doubleValue();
                double valLast = ((Number)objLast).doubleValue();
                if (valFirst > 0.0 || valLast < 0.0) {
                    PureTable pureTable = new PureTable(this.ds);
                    return pureTable;
                }
                if (valFirst == valLast) {
                    first = 1;
                    last = size;
                    break block26;
                }
                int low = 1;
                int high = size;
                int pos = -1;
                while (low <= high) {
                    int mid = low + high >> 1;
                    current.setCurrent(mid);
                    Object obj = exp.calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm3 = EngineMessage.get();
                        throw new RQException(mm3.getMessage("engine.needIntExp"));
                    }
                    double value = ((Number)obj).doubleValue();
                    if (value < 0.0) {
                        low = mid + 1;
                        continue;
                    }
                    if (value > 0.0) {
                        high = mid - 1;
                        continue;
                    }
                    pos = mid;
                    break;
                }
                if (pos == -1) {
                    PureTable mid = new PureTable(this.ds);
                    return mid;
                }
                for (first = pos; first > 1; --first) {
                    current.setCurrent(first - 1);
                    Object obj = exp.calculate(ctx);
                    if (!(obj instanceof Number)) {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needIntExp"));
                    }
                    if (((Number)obj).doubleValue() != 0.0) break;
                }
                for (last = pos; last < size; ++last) {
                    current.setCurrent(last + 1);
                    Object obj = exp.calculate(ctx);
                    if (!(obj instanceof Number)) {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needIntExp"));
                    }
                    if (((Number)obj).doubleValue() == 0.0) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                stack.pop();
            }
        }
        if (isTable) {
            if (isForward) {
                return this.get(first, last + 1);
            }
            int fcount = this._$1.length;
            IArray[] resultDatas = new IArray[fcount];
            int total = last - first + 1;
            for (int i = 0; i < fcount; ++i) {
                IArray resultArray;
                IArray array = this._$1[i];
                resultDatas[i] = resultArray = array.newInstance(total);
                for (int n = last; n >= first; --n) {
                    resultArray.push(array, n);
                }
            }
            return new PureTable(this.ds, resultDatas);
        }
        IArray mems = this.getMems();
        ObjectArray resultArray = new ObjectArray(last - first + 1);
        if (isForward) {
            while (first <= last) {
                resultArray.push(mems.get(first));
                ++first;
            }
        } else {
            while (last >= first) {
                resultArray.push(mems.get(last));
                --last;
            }
        }
        return new Sequence((IArray)resultArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object select(Expression[] fltExps, Object[] vals, String opt, Context ctx) {
        int len;
        boolean isSorted = false;
        boolean isTable = false;
        boolean isZero = false;
        if (opt != null) {
            if (opt.indexOf(109) != -1) {
                return ParallelUtil.select(this, fltExps, vals, opt, ctx);
            }
            if (opt.indexOf(49) != -1 || opt.indexOf(122) != -1 || opt.indexOf(114) != -1 || opt.indexOf(99) != -1) {
                return super.select(fltExps, vals, opt, ctx);
            }
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
            if (opt.indexOf(48) != -1) {
                isZero = true;
            }
            if (opt.indexOf(118) != -1 || opt.indexOf(105) != -1) {
                isTable = true;
            }
        }
        if ((len = this.length()) == 0) {
            if (isTable) {
                return this;
            }
            if (isZero) {
                return null;
            }
            return new Sequence(0);
        }
        int fltCount = fltExps.length;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            Sequence resultDatas;
            if (isSorted) {
                int last;
                int first;
                Object flt;
                int low = 1;
                int high = len;
                int pos = -1;
                while (low <= high) {
                    int mid = low + high >> 1;
                    current.setCurrent(mid);
                    int cmp = 0;
                    for (int c = 0; c < fltCount && (cmp = Variant.compare((Object)(flt = fltExps[c].calculate(ctx)), (Object)vals[c], (boolean)true)) == 0; ++c) {
                    }
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    pos = mid;
                    break;
                }
                if (pos == -1) {
                    if (isZero) {
                        Object mid = null;
                        return mid;
                    }
                    Table mid = new Table(this.ds);
                    return mid;
                }
                block12: for (first = pos; first > 1; --first) {
                    current.setCurrent(first - 1);
                    for (int c = 0; c < fltCount; ++c) {
                        Object flt2 = fltExps[c].calculate(ctx);
                        if (!Variant.isEquals((Object)flt2, (Object)vals[c])) break block12;
                    }
                }
                block14: for (last = pos; last < len; ++last) {
                    current.setCurrent(last + 1);
                    for (int c = 0; c < fltCount; ++c) {
                        flt = fltExps[c].calculate(ctx);
                        if (!Variant.isEquals((Object)flt, (Object)vals[c])) break block14;
                    }
                }
                if (isTable) {
                    Table c = this.get(first, last + 1);
                    return c;
                }
                IArray mems = this.getMems();
                ObjectArray resultArray = new ObjectArray(last - first + 1);
                while (first <= last) {
                    resultArray.push(mems.get(first));
                    ++first;
                }
                Sequence sequence = new Sequence((IArray)resultArray);
                return sequence;
            }
            BoolArray boolArray = null;
            for (int i = 0; i < fltCount; ++i) {
                IArray array;
                if (boolArray == null) {
                    array = fltExps[i].calculateAll(ctx);
                    boolArray = array.calcRelation(vals[i], 1);
                    continue;
                }
                array = fltExps[i].calculateAll(ctx, boolArray, true);
                array.calcRelations(vals[i], 1, boolArray, true);
            }
            if (isTable) {
                int fcount = this._$1.length;
                resultDatas = new IArray[fcount];
                for (int i = 0; i < fcount; ++i) {
                    resultDatas[i] = this._$1[i].select((IArray)boolArray);
                }
                PureTable i = new PureTable(this.ds, (IArray[])resultDatas);
                return i;
            }
            int count = boolArray.count();
            if (count == 0) {
                if (isZero) {
                    resultDatas = null;
                    return resultDatas;
                }
                resultDatas = new Sequence(0);
                return resultDatas;
            }
            IArray mems = this.getMems();
            ObjectArray resultArray = new ObjectArray(count);
            for (int i = 1; i <= len; ++i) {
                if (!boolArray.isTrue(i)) continue;
                resultArray.push(mems.get(i));
            }
            Sequence sequence = new Sequence((IArray)resultArray);
            return sequence;
        }
        finally {
            stack.pop();
        }
    }

    public Sequence split(int pos) {
        int fcount = this._$1.length;
        IArray[] resultDatas = new IArray[fcount];
        for (int f = 0; f < fcount; ++f) {
            resultDatas[f] = this._$1[f].split(pos);
        }
        return new PureTable(this.ds, resultDatas);
    }

    public Sequence split(int from, int to) {
        int fcount = this._$1.length;
        IArray[] resultDatas = new IArray[fcount];
        for (int f = 0; f < fcount; ++f) {
            resultDatas[f] = this._$1[f].split(from, to);
        }
        return new PureTable(this.ds, resultDatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object top(int count, Expression[] exps, String opt, Context ctx, boolean getPos) {
        boolean isAll;
        int len = this.length();
        if (len == 0 || count == 0) {
            return null;
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        int fcount = exps.length;
        IArray[] arrays = new IArray[fcount];
        try {
            for (int f = 0; f < fcount; ++f) {
                arrays[f] = exps[f].calculateAll(ctx);
            }
        }
        finally {
            stack.pop();
        }
        boolean bl = isAll = opt == null || opt.indexOf(49) == -1;
        if (count == 1 || count == -1) {
            int f;
            int i;
            if (isAll) {
                int f2;
                int i2;
                IntArray posArray = new IntArray(8);
                block4: for (i2 = 1; i2 <= len; ++i2) {
                    for (f2 = 0; f2 < fcount; ++f2) {
                        if (arrays[f2].isNull(i2)) continue block4;
                    }
                    posArray.addInt(i2);
                    break;
                }
                if (count == 1) {
                    ++i2;
                    while (i2 <= len) {
                        block42: {
                            for (f2 = 0; f2 < fcount; ++f2) {
                                if (!arrays[f2].isNull(i2)) {
                                    int cmp = arrays[f2].memberCompare(i2, posArray.getInt(1));
                                    if (cmp < 0) {
                                        posArray.clear();
                                        posArray.addInt(i2);
                                    } else if (cmp <= 0) {
                                        continue;
                                    }
                                }
                                break block42;
                            }
                            posArray.addInt(i2);
                        }
                        ++i2;
                    }
                } else {
                    ++i2;
                    while (i2 <= len) {
                        block43: {
                            for (f2 = 0; f2 < fcount; ++f2) {
                                if (!arrays[f2].isNull(i2)) {
                                    int cmp = arrays[f2].memberCompare(i2, posArray.getInt(1));
                                    if (cmp > 0) {
                                        posArray.clear();
                                        posArray.addInt(i2);
                                    } else if (cmp >= 0) {
                                        continue;
                                    }
                                }
                                break block43;
                            }
                            posArray.addInt(i2);
                        }
                        ++i2;
                    }
                }
                if (getPos) {
                    return new Sequence((IArray)posArray);
                }
                return this.get(posArray);
            }
            int pos = 0;
            block10: for (i = 1; i <= len; ++i) {
                for (f = 0; f < fcount; ++f) {
                    if (arrays[f].isNull(i)) continue block10;
                }
                pos = i;
                break;
            }
            if (count == 1) {
                ++i;
                while (i <= len) {
                    for (f = 0; f < fcount && !arrays[f].isNull(i); ++f) {
                        int cmp = arrays[f].memberCompare(i, pos);
                        if (cmp < 0) {
                            pos = i;
                            break;
                        }
                        if (cmp > 0) break;
                    }
                    ++i;
                }
            } else {
                ++i;
                while (i <= len) {
                    for (f = 0; f < fcount && !arrays[f].isNull(i); ++f) {
                        int cmp = arrays[f].memberCompare(i, pos);
                        if (cmp > 0) {
                            pos = i;
                            break;
                        }
                        if (cmp < 0) break;
                    }
                    ++i;
                }
            }
            if (getPos) {
                return ObjectCache.getInteger((int)pos);
            }
            return this.get(pos);
        }
        ArraysMemberComparator comparator = new ArraysMemberComparator(arrays);
        if (count < 0) {
            count = -count;
            comparator = new DescComparator((Comparator)comparator);
        }
        MinHeap minHeap = new MinHeap(count, (Comparator)comparator);
        block16: for (int i = 1; i <= len; ++i) {
            for (int f = 0; f < fcount; ++f) {
                if (arrays[f].isNull(i)) continue block16;
            }
            minHeap.insert((Object)ObjectCache.getInteger((int)i));
        }
        int size = minHeap.size();
        Object[] positions = minHeap.toArray();
        Arrays.sort(positions, comparator);
        if (getPos) {
            Sequence result = new Sequence(size);
            for (int i = 0; i < size; ++i) {
                result.add(positions[i]);
            }
            return result;
        }
        int[] ps = new int[size];
        for (int i = 0; i < size; ++i) {
            ps[i] = ((Number)positions[i]).intValue();
        }
        return this.get(ps);
    }

    public void trimToSize() {
        if (this.length() > 0) {
            for (IArray array : this._$1) {
                array.trimToSize();
            }
        }
    }

    public Object switchFk(Function function, String[] fkNames, String[] timeNames, Object[] codes, Expression[] exps, Expression[] timeExps, String opt, Context ctx) {
        int count = codes.length;
        Sequence[] seqs = new Sequence[count];
        boolean hasClusterTable = false;
        for (int i = 0; i < count; ++i) {
            if (codes[i] instanceof Sequence) {
                seqs[i] = (Sequence)codes[i];
                continue;
            }
            if (codes[i] instanceof ClusterMemoryTable) {
                hasClusterTable = true;
                continue;
            }
            if (codes[i] == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.paramTypeError"));
        }
        Object op = hasClusterTable ? new SwitchRemote(function, fkNames, codes, exps, opt) : new Switch(function, fkNames, timeNames, seqs, exps, timeExps, opt);
        PureTable result = (PureTable)op.process((Sequence)this, ctx);
        if (result == null || result.length() == 0) {
            this.clear();
        } else {
            this.ds = result.ds;
            this._$1 = result._$1;
        }
        return this;
    }

    public void switchFk(String fkName, Sequence code, Expression exp, String opt, Context ctx) {
        String[] fkNames = new String[]{fkName};
        Object[] codes = new Object[]{code};
        Expression[] exps = new Expression[]{exp};
        PureTable result = (PureTable)((Object)this.switchFk(null, fkNames, null, codes, exps, null, opt, ctx));
        if (result == null || result.length() == 0) {
            this.clear();
        } else {
            this.ds = result.ds;
            this._$1 = result._$1;
        }
    }

    public void setMems(IArray mems) {
        this.mems = mems;
    }

    public void shift(int pos, int move) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"shift"));
    }

    public BaseRecord insert(int pos) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"insert"));
    }

    public void insert(int pos, Object val) {
        this._$2();
        if (val instanceof BaseRecord && ((BaseRecord)val).dataStruct() == this.ds) {
            Object[] values = ((BaseRecord)val).getFieldValues();
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                this._$1[i].insert(pos, values[i]);
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"insert"));
        }
    }

    public Sequence modify(int pos, Sequence src, boolean isInsert, String opt) {
        if (!isInsert || !(src instanceof PureTable)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"insert"));
        }
        PureTable table = (PureTable)src;
        if (!table.ds.isCompatible(this.ds)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"insert"));
        }
        if (pos == 0) {
            pos = this.length() + 1;
        } else if (pos < 0 && (pos += this.length() + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - this.length() - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        int fcount = this._$1.length;
        for (int f = 0; f < fcount; ++f) {
            this._$1[f].insertAll(pos, table._$1[f]);
        }
        return this;
    }

    public void set(int pos, Object val) {
        if (val instanceof BaseRecord && ((BaseRecord)val).dataStruct() == this.ds) {
            Object[] values = ((BaseRecord)val).getFieldValues();
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                this._$1[i].set(pos, values[i]);
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"set"));
        }
    }

    public BaseRecord newLast() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"newLast"));
    }

    public BaseRecord newLast(Object[] initVals) {
        int len = initVals.length;
        for (int i = 0; i < len; ++i) {
            this._$1[i].add(initVals[i]);
        }
        if (this.mems != null) {
            PureRecord r = new PureRecord(this, this.mems.size() + 1);
            this.mems.add((Object)r);
            return r;
        }
        int size = this._$1[0].size();
        ObjectArray array = new ObjectArray(size);
        for (int i = 1; i <= size; ++i) {
            PureRecord r = new PureRecord(this, i);
            array.add((Object)r);
        }
        this.mems = array;
        return (PureRecord)((Object)this.mems.get(size));
    }

    public void newLast(IArray[] initVals, int row) {
        int len = initVals.length;
        for (int i = 0; i < len; ++i) {
            this._$1[i].add(initVals[i], row);
        }
        if (this.mems != null) {
            PureRecord r = new PureRecord(this, this.mems.size() + 1);
            this.mems.add((Object)r);
        }
    }

    public void alter(String[] fields) {
        DataStruct oldDs = this.ds;
        int newCount = fields.length;
        IArray[] arrays = null;
        if (this.length() > 0) {
            arrays = new IArray[newCount];
            for (int i = 0; i < newCount; ++i) {
                int index = oldDs.getFieldIndex(fields[i]);
                if (index == -1) continue;
                fields[i] = oldDs.getFieldName(index);
                arrays[i] = this._$1[index];
            }
        }
        DataStruct newDs = oldDs.create(fields);
        this._$1 = arrays;
        this.ds = newDs;
    }

    public void alter(String[] fields, String[] oldFields) {
        if (fields == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("alter" + mm.getMessage("function.paramValNull"));
        }
        DataStruct oldDs = this.ds;
        int newCount = fields.length;
        IArray[] arrays = null;
        if (this.length() > 0) {
            int i;
            arrays = new IArray[newCount];
            if (oldFields == null) {
                for (i = 0; i < newCount; ++i) {
                    int index = oldDs.getFieldIndex(fields[i]);
                    arrays[i] = this._$1[index];
                }
            } else {
                for (i = 0; i < newCount; ++i) {
                    int index;
                    if (oldFields[i] == null) {
                        index = oldDs.getFieldIndex(fields[i]);
                        arrays[i] = this._$1[index];
                        continue;
                    }
                    index = oldDs.getFieldIndex(oldFields[i]);
                    arrays[i] = this._$1[index];
                }
            }
        }
        DataStruct newDs = oldDs.create(fields);
        this._$1 = arrays;
        this.ds = newDs;
    }

    public Sequence insert(int pos, int count, String opt) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"insert"));
    }

    public void insert(int pos, Object[] values, String[] fields) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"insert"));
    }

    public BaseRecord insert(int pos, Expression[] exps, String[] fields, Context ctx) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.unsupportedMethod", (Object)"insert"));
    }

    public PureTable select(IArray signArray) {
        if (this._$1 == null || this._$1[0] == null) {
            return new PureTable(this.ds);
        }
        int fcount = this._$1.length;
        IArray[] resultDatas = new IArray[fcount];
        for (int i = 0; i < fcount; ++i) {
            resultDatas[i] = this._$1[i].select(signArray);
        }
        return new PureTable(this.ds, resultDatas);
    }

    public Table toRowTable() {
        DataStruct ds = this.ds.dup();
        int len = this.length();
        if (len == 0) {
            return new Table(ds);
        }
        IArray[] colDatas = this._$1;
        int fcount = colDatas.length;
        Table result = new Table(ds, len);
        IArray mems = result.getMems();
        for (int i = 1; i <= len; ++i) {
            Record r = new Record(ds);
            mems.push((Object)r);
            for (int f = 0; f < fcount; ++f) {
                r.setNormalFieldValue(f, colDatas[f].get(i));
            }
        }
        return result;
    }

    public IndexTable newIndexTable() {
        return this.newIndexTable(this.length());
    }

    public IndexTable newIndexTable(int capacity) {
        int[] pkIndex = this.ds.getPKIndex();
        if (pkIndex == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        if (this.ds.getTimeKeyCount() == 1) {
            return new TimeIndexTable(this, pkIndex, capacity);
        }
        if (pkIndex.length == 1) {
            HashIndexTable it = new HashIndexTable(capacity);
            it.create(this, pkIndex[0]);
            return it;
        }
        HashArrayIndexTable it = new HashArrayIndexTable(capacity);
        it.create(this, pkIndex);
        return it;
    }

    public IndexTable newIndexTable(Expression exp, Context ctx) {
        return this.newIndexTable(exp, ctx, this.length());
    }

    public IndexTable newIndexTable(Expression exp, Context ctx, int capacity) {
        if (exp == null) {
            return this.newIndexTable(capacity);
        }
        HashIndexTable it = new HashIndexTable(capacity);
        it.create(this, exp, ctx);
        return it;
    }

    public IndexTable newIndexTable(int[] fields, int capacity, String opt) {
        if (fields.length == 1) {
            if (this.ds.isSeqKey() || opt != null && opt.indexOf(110) != -1) {
                return new SeqIndexTable((Sequence)this, fields[0]);
            }
            HashIndexTable it = new HashIndexTable(capacity, opt);
            it.create(this, fields[0]);
            return it;
        }
        if (this.ds.getTimeKeyCount() == 1) {
            return new TimeIndexTable(this, fields, capacity);
        }
        HashArrayIndexTable it = new HashArrayIndexTable(capacity, opt);
        it.create(this, fields);
        return it;
    }

    public IndexTable newIndexTable(Expression[] exps, Context ctx) {
        return this.newIndexTable(exps, ctx, this.length());
    }

    public IndexTable newIndexTable(Expression[] exps, Context ctx, int capacity) {
        int[] pkIndex;
        if (exps == null) {
            return this.newIndexTable(capacity);
        }
        if (exps.length == 1) {
            return this.newIndexTable(exps[0], ctx, capacity);
        }
        if (this.ds.getTimeKeyCount() == 1 && this.ds.isSameFields(exps, pkIndex = this.ds.getPKIndex())) {
            return new TimeIndexTable(this, pkIndex, capacity);
        }
        HashArrayIndexTable it = new HashArrayIndexTable(capacity);
        it.create(this, exps, ctx);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexTable newMergeIndexTable(Expression[] exps, Context ctx) {
        IArray[] arrays;
        if (exps == null) {
            arrays = this.getPKArrays();
        } else {
            int count = exps.length;
            arrays = new IArray[count];
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current((Sequence)this);
            stack.push((IComputeItem)current);
            try {
                for (int i = 0; i < count; ++i) {
                    arrays[i] = exps[i].calculateAll(ctx);
                }
            }
            finally {
                stack.pop();
            }
        }
        return new MergeIndexTable(this, arrays);
    }

    public void finishGather1(Node[] gathers) {
        if (gathers == null || this.length() == 0) {
            return;
        }
        int valCount = gathers.length;
        int i = 0;
        int f = this.ds.getPKCount();
        while (i < valCount) {
            if (gathers[i].needFinish1()) {
                this._$1[f] = gathers[i].finish1(this._$1[f]);
            }
            ++i;
            ++f;
        }
    }

    public void finishGather(Node[] gathers) {
        if (gathers == null || this.length() == 0) {
            return;
        }
        int valCount = gathers.length;
        int i = 0;
        int f = this.ds.getPKCount();
        while (i < valCount) {
            if (gathers[i].needFinish()) {
                this._$1[f] = gathers[i].finish(this._$1[f]);
            }
            ++i;
            ++f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence sort(Expression exp, String loc, String opt, Context ctx) {
        IArray valArray;
        boolean isTable = false;
        boolean isDesc = false;
        if (opt != null) {
            if (loc != null || opt.indexOf(117) != -1 || opt.indexOf(110) != -1 || opt.indexOf(48) != -1) {
                return super.sort(exp, loc, opt, ctx);
            }
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(118) != -1) {
                isTable = true;
            }
        }
        if (this.length() == 0) {
            if (isTable) {
                return this;
            }
            return new Sequence(0);
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            valArray = exp.calculateAll(ctx);
        }
        finally {
            stack.pop();
        }
        ArrayMemberComparator comparator = new ArrayMemberComparator(valArray);
        if (isDesc) {
            comparator = new DescComparator((Comparator)comparator);
        }
        int len = valArray.size();
        Object[] positions = new Integer[len];
        for (int i = 0; i < len; ++i) {
            positions[i] = ObjectCache.getInteger((int)(i + 1));
        }
        MultithreadUtil.sort((Object[])positions, (int)0, (int)len, (Comparator)comparator);
        if (isTable) {
            int[] index = new int[len];
            for (int i = 0; i < len; ++i) {
                index[i] = (Integer)positions[i];
            }
            int fcount = this._$1.length;
            IArray[] resultDatas = new IArray[fcount];
            for (int f = 0; f < fcount; ++f) {
                resultDatas[f] = this._$1[f].get(index);
            }
            return new PureTable(this.ds, resultDatas);
        }
        IArray mems = this.getMems();
        ObjectArray resultArray = new ObjectArray(len);
        for (int i = 0; i < len; ++i) {
            resultArray.push(mems.get(((Integer)positions[i]).intValue()));
        }
        return new Sequence((IArray)resultArray);
    }

    public void sortFields(int[] colIndex) {
        int i;
        if (this.length() == 0) {
            return;
        }
        int fcount = colIndex.length;
        IArray[] arrays = new IArray[fcount];
        for (int f = 0; f < fcount; ++f) {
            arrays[f] = this._$1[colIndex[f]];
        }
        ArraysMemberComparator comparator = new ArraysMemberComparator(arrays);
        int len = arrays[0].size();
        Object[] positions = new Integer[len];
        for (int i2 = 0; i2 < len; ++i2) {
            positions[i2] = ObjectCache.getInteger((int)(i2 + 1));
        }
        MultithreadUtil.sort((Object[])positions, (int)0, (int)len, (Comparator)comparator);
        int[] index = new int[len];
        for (i = 0; i < len; ++i) {
            index[i] = (Integer)positions[i];
        }
        for (i = 0; i < this._$1.length; ++i) {
            this._$1[i] = this._$1[i].get(index);
        }
    }

    public ICursor cursor() {
        return new PureMemoryCursor(this);
    }

    public ICursor cursor(int start, int end) {
        return new PureMemoryCursor(this, start, end);
    }

    public Sequence memory(String option) {
        PureTable srcTable = this;
        if (option != null && option.indexOf(111) != -1) {
            return new PureMemoryTable(srcTable);
        }
        PureTable table = (PureTable)srcTable.derive("o");
        return new PureMemoryTable(table);
    }

    public Sequence Join(Expression[][] exps, Sequence[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        Join join = new Join(null, exps, codes, dataExps, newExps, newNames, null);
        return join.process((Sequence)this, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression[] assignExps, Expression[] exps, Context ctx) {
        if (assignExps == null || assignExps.length == 0) {
            super.run(assignExps, exps, ctx);
            return;
        }
        int colCount = assignExps.length;
        int[] fields = new int[colCount];
        for (int i = 0; i < colCount; ++i) {
            if (assignExps[i] == null) {
                super.run(assignExps, exps, ctx);
                return;
            }
            fields[i] = assignExps[i].getFieldIndex(this.ds);
            if (fields[i] >= 0) continue;
            super.run(assignExps, exps, ctx);
            return;
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current((Sequence)this);
        stack.push((IComputeItem)current);
        try {
            for (int i = 0; i < colCount; ++i) {
                IArray array = exps[i].calculateAll(ctx);
                if (array instanceof ConstArray) {
                    this._$1[fields[i]] = array.toPureArray();
                    continue;
                }
                if (array.isTemporary()) {
                    array.setTemporary(false);
                    this._$1[fields[i]] = array;
                    continue;
                }
                IArray oldArray = this._$1[fields[i]];
                if (oldArray == array) continue;
                if (oldArray.getClass() == array.getClass()) {
                    oldArray.clear();
                    oldArray.addAll(array);
                    continue;
                }
                this._$1[fields[i]] = array.dup();
            }
        }
        finally {
            stack.pop();
        }
    }

    public void run(Expression[] assignExps, Expression[] exps, String option, Context ctx) {
        if (option == null || option.indexOf(109) == -1) {
            this.run(assignExps, exps, ctx);
        } else {
            MultithreadUtil.run((Sequence)this, (Expression[])assignExps, (Expression[])exps, (Context)ctx);
        }
    }

    public PureTable getSubset(int start, int end) {
        IArray[] colDatas = this.getColDatas();
        int fcount = colDatas.length;
        IArray[] resultDatas = new IArray[fcount];
        for (int f = 0; f < fcount; ++f) {
            if (colDatas[f] instanceof LongArray) {
                resultDatas[f] = new LongArraySubset((LongArray)colDatas[f], start, end);
                continue;
            }
            if (colDatas[f] instanceof DoubleArray) {
                resultDatas[f] = new DoubleArraySubset((DoubleArray)colDatas[f], start, end);
                continue;
            }
            if (colDatas[f] instanceof IntArray) {
                resultDatas[f] = new IntArraySubset((IntArray)colDatas[f], start, end);
                continue;
            }
            if (colDatas[f] instanceof ConstArray) {
                resultDatas[f] = new ConstArray(((ConstArray)colDatas[f]).getData(), end - start + 1);
                continue;
            }
            if (colDatas[f] instanceof BoolArray) {
                resultDatas[f] = new BoolArraySubset((BoolArray)colDatas[f], start, end);
                continue;
            }
            if (colDatas[f] instanceof DateArray) {
                resultDatas[f] = new DateArraySubset((DateArray)colDatas[f], start, end);
                continue;
            }
            if (colDatas[f] instanceof StringArray) {
                resultDatas[f] = new StringArraySubset((StringArray)colDatas[f], start, end);
                continue;
            }
            if (colDatas[f] instanceof ObjectArray) {
                resultDatas[f] = new ObjectArraySubset((ObjectArray)colDatas[f], start, end);
                continue;
            }
            if (colDatas[f] instanceof SerialBytesArray) {
                resultDatas[f] = new SerialBytesArraySubset((SerialBytesArray)colDatas[f], start, end);
                continue;
            }
            throw new RuntimeException();
        }
        return new PureTable(this.ds, resultDatas);
    }
}

