/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.IndexTable;
import com.scudata.pdm.PureTable;
import com.scudata.resources.EngineMessage;
import com.scudata.util.HashUtil;

public class TimeIndexTable
extends IndexTable {
    private PureTable _$4;
    private IArray[] _$3;
    private int _$2;
    protected HashUtil hashUtil;
    private IntArrayList[] _$1;

    public TimeIndexTable(PureTable code, int[] fields, int capacity) {
        int totalKeyCount;
        HashUtil hashUtil = new HashUtil(capacity);
        this._$4 = code;
        this.hashUtil = hashUtil;
        IntArrayList[] posListArray = new IntArrayList[hashUtil.getCapacity()];
        this._$1 = posListArray;
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        this._$2 = totalKeyCount = fields.length;
        int keyCount = totalKeyCount - 1;
        IArray[] keysArray = new IArray[totalKeyCount];
        this._$3 = keysArray;
        for (int k = 0; k < totalKeyCount; ++k) {
            keysArray[k] = code.getFieldValueArray(k);
        }
        int len = code.length();
        for (int i = 1; i <= len; ++i) {
            int hash = hashUtil.hashCode(keysArray, i, keyCount);
            if (posListArray[hash] == null) {
                posListArray[hash] = new IntArrayList(INIT_GROUPSIZE);
                posListArray[hash].addInt(i);
                continue;
            }
            int index = TimeIndexTable._$1(keysArray, totalKeyCount, posListArray[hash], i);
            if (index < 0) {
                posListArray[hash].addInt(-index - 1, i);
                continue;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dupKeys"));
        }
    }

    private static int _$1(IArray[] keysArray, int totalKeyCount, IntArrayList posList, int r) {
        int low = 0;
        int high = posList.size() - 1;
        int cmp = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            int pos = posList.getInt(mid);
            for (int k = 0; k < totalKeyCount && (cmp = keysArray[k].memberCompare(pos, r)) == 0; ++k) {
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int _$1(IArray keyArray, IntArrayList posList, Object value) {
        int low = 0;
        int high = posList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int pos = posList.getInt(mid);
            int cmp = keyArray.compareTo(pos, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int _$1(IArray keyArray, IntArrayList posList, IArray valueArray, int index) {
        int low = 0;
        int high = posList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int pos = posList.getInt(mid);
            int cmp = keyArray.compareTo(pos, valueArray, index);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int _$1(IArray[] keysArray, int totalKeyCount, IntArrayList posList, Object[] values) {
        int low = 0;
        int high = posList.size() - 1;
        int cmp = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            int pos = posList.getInt(mid);
            for (int k = 0; k < totalKeyCount && (cmp = keysArray[k].compareTo(pos, values[k])) == 0; ++k) {
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int _$1(IArray[] keysArray, int totalKeyCount, IntArrayList posList, IArray[] valuesArray, int index) {
        int low = 0;
        int high = posList.size() - 1;
        int cmp = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            int pos = posList.getInt(mid);
            for (int k = 0; k < totalKeyCount && (cmp = keysArray[k].compareTo(pos, valuesArray[k], index)) == 0; ++k) {
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int getCapacity() {
        return this.hashUtil.getCapacity();
    }

    public Object find(Object key) {
        int hash = this.hashUtil.hashCode(key);
        IntArrayList posList = this._$1[hash];
        if (posList == null) {
            return null;
        }
        IArray keyArray = this._$3[0];
        int index = TimeIndexTable._$1(keyArray, posList, key);
        if (index > 0) {
            int i = index + 1;
            int size = posList.size();
            while (i < size && keyArray.isEquals(posList.getInt(i), key)) {
                index = i++;
            }
            return this._$4.getMem(posList.getInt(index));
        }
        return null;
    }

    public Object find(Object[] keys) {
        int count = keys.length;
        if (count == this._$2) {
            int keyCount = count - 1;
            int hash = this.hashUtil.hashCode(keys, keyCount);
            IntArrayList posList = this._$1[hash];
            if (posList == null) {
                return null;
            }
            IArray[] keysArray = this._$3;
            int index = TimeIndexTable._$1(keysArray, count, posList, keys);
            if (index > 0) {
                return this._$4.getMem(posList.getInt(index));
            }
            if ((index = -index - 2) > 0) {
                int pos = posList.getInt(index);
                for (int k = 0; k < keyCount; ++k) {
                    if (keysArray[k].compareTo(pos, keys[k]) == 0) continue;
                    return null;
                }
                return this._$4.getMem(pos);
            }
            return null;
        }
        int hash = this.hashUtil.hashCode(keys, count);
        IntArrayList posList = this._$1[hash];
        if (posList == null) {
            return null;
        }
        IArray[] keysArray = this._$3;
        int index = TimeIndexTable._$1(keysArray, count, posList, keys);
        if (index > 0) {
            int i = index + 1;
            int size = posList.size();
            block1: while (i < size) {
                int pos = posList.getInt(i);
                for (int k = 0; k < count; ++k) {
                    if (keysArray[k].compareTo(pos, keys[k]) != 0) break block1;
                }
                index = i++;
            }
            return this._$4.getMem(posList.getInt(index));
        }
        return null;
    }

    public int findPos(Object key) {
        int hash = this.hashUtil.hashCode(key);
        IntArrayList posList = this._$1[hash];
        if (posList == null) {
            return 0;
        }
        IArray keyArray = this._$3[0];
        int index = TimeIndexTable._$1(keyArray, posList, key);
        if (index > 0) {
            int i = index + 1;
            int size = posList.size();
            while (i < size && keyArray.isEquals(posList.getInt(i), key)) {
                index = i++;
            }
            return posList.getInt(index);
        }
        return 0;
    }

    public int findPos(Object[] keys) {
        int count = keys.length;
        if (count == this._$2) {
            int keyCount = count - 1;
            int hash = this.hashUtil.hashCode(keys, keyCount);
            IntArrayList posList = this._$1[hash];
            if (posList == null) {
                return 0;
            }
            IArray[] keysArray = this._$3;
            int index = TimeIndexTable._$1(keysArray, count, posList, keys);
            if (index > 0) {
                return posList.getInt(index);
            }
            if ((index = -index - 2) > 0) {
                int pos = posList.getInt(index);
                for (int k = 0; k < keyCount; ++k) {
                    if (keysArray[k].compareTo(pos, keys[k]) == 0) continue;
                    return 0;
                }
                return pos;
            }
            return 0;
        }
        int hash = this.hashUtil.hashCode(keys, count);
        IntArrayList posList = this._$1[hash];
        if (posList == null) {
            return 0;
        }
        IArray[] keysArray = this._$3;
        int index = TimeIndexTable._$1(keysArray, count, posList, keys);
        if (index > 0) {
            int i = index + 1;
            int size = posList.size();
            block1: while (i < size) {
                int pos = posList.getInt(i);
                for (int k = 0; k < count; ++k) {
                    if (keysArray[k].compareTo(pos, keys[k]) != 0) break block1;
                }
                index = i++;
            }
            return posList.getInt(index);
        }
        return 0;
    }

    public int[] findAllPos(IArray valueArray) {
        IntArrayList[] posListArray = this._$1;
        HashUtil hashUtil = this.hashUtil;
        IArray keyArray = this._$3[0];
        int len = valueArray.size();
        int[] results = new int[len + 1];
        for (int i = 1; i <= len; ++i) {
            int index;
            int hash = hashUtil.hashCode(valueArray.hashCode(i));
            IntArrayList posList = posListArray[hash];
            if (posList == null || (index = TimeIndexTable._$1(keyArray, posList, valueArray, i)) <= 0) continue;
            int pos = posList.getInt(index);
            int size = posList.size();
            for (int p = index + 1; p < size && keyArray.isMemberEquals(posList.getInt(p), pos); ++p) {
                pos = posList.getInt(p);
            }
            results[i] = pos;
        }
        return results;
    }

    public int[] findAllPos(IArray[] valuesArray) {
        IntArrayList[] posListArray = this._$1;
        HashUtil hashUtil = this.hashUtil;
        IArray[] keysArray = this._$3;
        int count = valuesArray.length;
        int len = valuesArray[0].size();
        int[] results = new int[len + 1];
        if (count == this._$2) {
            int keyCount = count - 1;
            block0: for (int i = 1; i <= len; ++i) {
                int hash = hashUtil.hashCode(valuesArray, i, keyCount);
                IntArrayList posList = posListArray[hash];
                if (posList == null) continue;
                int index = TimeIndexTable._$1(keysArray, count, posList, valuesArray, i);
                if (index > 0) {
                    results[i] = posList.getInt(index);
                    continue;
                }
                if ((index = -index - 2) <= 0) continue;
                int pos = posList.getInt(index);
                for (int k = 0; k < keyCount; ++k) {
                    if (!keysArray[k].isEquals(pos, valuesArray[k], i)) continue block0;
                }
                results[i] = pos;
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                int index;
                int hash = hashUtil.hashCode(valuesArray, i, count);
                IntArrayList posList = posListArray[hash];
                if (posList == null || (index = TimeIndexTable._$1(keysArray, count, posList, valuesArray, i)) <= 0) continue;
                int pos = posList.getInt(index);
                int size = posList.size();
                block3: for (int p = index + 1; p < size; ++p) {
                    int nextPos = posList.getInt(p);
                    for (int k = 0; k < count; ++k) {
                        if (!keysArray[k].isMemberEquals(pos, nextPos)) break block3;
                    }
                    pos = nextPos;
                }
                results[i] = pos;
            }
        }
        return results;
    }

    public int[] findAllPos(IArray valueArray, BoolArray signArray) {
        IntArrayList[] posListArray = this._$1;
        HashUtil hashUtil = this.hashUtil;
        IArray keyArray = this._$3[0];
        int len = valueArray.size();
        int[] results = new int[len + 1];
        for (int i = 1; i <= len; ++i) {
            int index;
            int hash;
            IntArrayList posList;
            if (signArray.isFalse(i) || (posList = posListArray[hash = hashUtil.hashCode(valueArray.hashCode(i))]) == null || (index = TimeIndexTable._$1(keyArray, posList, valueArray, i)) <= 0) continue;
            int pos = posList.getInt(index);
            int size = posList.size();
            for (int p = index + 1; p < size && keyArray.isMemberEquals(posList.getInt(p), pos); ++p) {
                pos = posList.getInt(p);
            }
            results[i] = pos;
        }
        return results;
    }

    public int[] findAllPos(IArray[] valuesArray, BoolArray signArray) {
        IntArrayList[] posListArray = this._$1;
        HashUtil hashUtil = this.hashUtil;
        IArray[] keysArray = this._$3;
        int count = valuesArray.length;
        int len = valuesArray[0].size();
        int[] results = new int[len + 1];
        if (count == this._$2) {
            int keyCount = count - 1;
            block0: for (int i = 1; i <= len; ++i) {
                int hash;
                IntArrayList posList;
                if (signArray.isFalse(i) || (posList = posListArray[hash = hashUtil.hashCode(valuesArray, i, keyCount)]) == null) continue;
                int index = TimeIndexTable._$1(keysArray, count, posList, valuesArray, i);
                if (index > 0) {
                    results[i] = posList.getInt(index);
                    continue;
                }
                if ((index = -index - 2) <= 0) continue;
                int pos = posList.getInt(index);
                for (int k = 0; k < keyCount; ++k) {
                    if (!keysArray[k].isEquals(pos, valuesArray[k], i)) continue block0;
                }
                results[i] = pos;
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                int index;
                int hash = hashUtil.hashCode(valuesArray, i, count);
                IntArrayList posList = posListArray[hash];
                if (posList == null || (index = TimeIndexTable._$1(keysArray, count, posList, valuesArray, i)) <= 0) continue;
                int pos = posList.getInt(index);
                int size = posList.size();
                block3: for (int p = index + 1; p < size; ++p) {
                    int nextPos = posList.getInt(p);
                    for (int k = 0; k < count; ++k) {
                        if (!keysArray[k].isMemberEquals(pos, nextPos)) break block3;
                    }
                    pos = nextPos;
                }
                results[i] = pos;
            }
        }
        return results;
    }
}

