/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoolArraySubset
extends BoolArray {
    private static final long serialVersionUID = 1L;
    private BoolArray _$7;
    private boolean[] _$6;
    private boolean[] _$5;
    private int _$4;
    private int _$3;
    private int _$2;
    private int _$1;

    public BoolArraySubset(BoolArray array, int start, int end) {
        super(array.getDatas(), array.getSigns(), array.size());
        this._$6 = array.getDatas();
        this._$5 = array.getSigns();
        this._$4 = start;
        this._$3 = end;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
        this._$7 = array;
    }

    public boolean[] getDatas() {
        int len = this._$2 + 1;
        boolean[] newDatas = new boolean[len];
        System.arraycopy(this._$6, this._$4, newDatas, 0, len);
        return newDatas;
    }

    public boolean[] getSigns() {
        int len = this._$2 + 1;
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[len];
            System.arraycopy(this._$5, this._$4, newSigns, 0, len);
        }
        return newSigns;
    }

    public boolean getSign(int index) {
        return this._$5[index + this._$1];
    }

    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.Boolean");
    }

    public BoolArray dup() {
        int len = this._$2 + 1;
        boolean[] newDatas = new boolean[len];
        System.arraycopy(this._$6, this._$4, newDatas, 0, len);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[len];
            System.arraycopy(this._$5, this._$4, newSigns, 0, len);
        }
        return new BoolArray(newDatas, newSigns, this._$2);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new RuntimeException();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    public byte[] serialize() throws IOException {
        throw new RuntimeException();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    public IArray newInstance(int count) {
        return new BoolArray(count);
    }

    public void add(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int index, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insert(int index, Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void add(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void set(int curIndex, IArray array, int index) {
        this.set(curIndex, array.get(index));
    }

    public void addBool(boolean b) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(boolean n) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushBool(boolean n) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushNull() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public Object get(int index) {
        if (this._$5 == null || !this._$5[index += this._$1]) {
            return this._$6[index];
        }
        return null;
    }

    public boolean getBool(int index) {
        return this._$6[index + this._$1];
    }

    public int getInt(int index) {
        throw new RuntimeException();
    }

    public long getLong(int index) {
        throw new RuntimeException();
    }

    public IArray get(int[] indexArray) {
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        int len = indexArray.length;
        BoolArray result = new BoolArray(len);
        int offset = this._$1;
        if (signs == null) {
            for (int i : indexArray) {
                result.pushBool(datas[i += offset]);
            }
        } else {
            for (int i : indexArray) {
                if (signs[i += offset]) {
                    result.pushNull();
                    continue;
                }
                result.pushBool(datas[i]);
            }
        }
        return result;
    }

    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        int len = end - start + 1;
        BoolArray result = new BoolArray(len);
        int offset = this._$1;
        if (doCheck) {
            if (signs == null) {
                while (start <= end) {
                    int q = indexArray[start];
                    if (q > 0) {
                        result.pushBool(datas[q + offset]);
                    } else {
                        result.pushNull();
                    }
                    ++start;
                }
            } else {
                while (start <= end) {
                    int q = indexArray[start];
                    if (q < 1 || signs[q + offset]) {
                        result.pushNull();
                    } else {
                        result.pushBool(datas[q + offset]);
                    }
                    ++start;
                }
            }
        } else if (signs == null) {
            while (start <= end) {
                result.pushBool(datas[indexArray[start + offset]]);
                ++start;
            }
        } else {
            while (start <= end) {
                int q = indexArray[start];
                if (signs[q + offset]) {
                    result.pushNull();
                } else {
                    result.pushBool(datas[q + offset]);
                }
                ++start;
            }
        }
        return result;
    }

    public IArray get(IArray indexArray) {
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        int len = indexArray.size();
        BoolArray result = new BoolArray(len);
        if (signs == null) {
            for (int i = 1; i <= len; ++i) {
                result.pushBool(datas[indexArray.getInt(i) + this._$1]);
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                int index = indexArray.getInt(i);
                if (signs[index]) {
                    result.pushNull();
                    continue;
                }
                result.pushBool(datas[index + this._$1]);
            }
        }
        return result;
    }

    public IArray get(int start, int end) {
        int newSize = end - start;
        boolean[] newDatas = new boolean[newSize + 1];
        System.arraycopy(this._$6, start + this._$1, newDatas, 1, newSize);
        if (this._$5 == null) {
            return new BoolArray(newDatas, null, newSize);
        }
        boolean[] newSigns = new boolean[newSize + 1];
        System.arraycopy(this._$5, start + this._$1, newSigns, 1, newSize);
        return new BoolArray(newDatas, newSigns, newSize);
    }

    public void ensureCapacity(int minCapacity) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void trimToSize() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public boolean isNull(int index) {
        return this._$5 != null && this._$5[index + this._$1];
    }

    public BoolArray isTrue() {
        if (this._$5 == null) {
            if (this.isTemporary()) {
                return this;
            }
            boolean[] resultDatas = new boolean[this._$2 + 1];
            System.arraycopy(this._$6, this._$4, resultDatas, 1, this._$2);
            BoolArray result = new BoolArray(resultDatas, this._$2);
            result.setTemporary(true);
            return result;
        }
        int size = this._$2;
        boolean[] resultDatas = new boolean[size + 1];
        System.arraycopy(this._$6, this._$4, resultDatas, 1, size);
        boolean[] signs = this._$5;
        int i = 1;
        int off = this._$4;
        while (i <= size) {
            if (signs[off]) {
                resultDatas[i] = false;
            }
            ++i;
            ++off;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray isFalse() {
        int i;
        int size = this._$2;
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (signs == null) {
            i = 1;
            int off = this._$4;
            while (i <= size) {
                resultDatas[i] = !datas[off];
                ++i;
                ++off;
            }
        } else {
            i = 1;
            int off = this._$4;
            while (i <= size) {
                resultDatas[i] = signs[off] || !datas[off];
                ++i;
                ++off;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isTrue(int index) {
        return this._$6[index + this._$1] && (this._$5 == null || !this._$5[index + this._$1]);
    }

    public boolean isFalse(int index) {
        return !this._$6[index + this._$1] || this._$5 != null && this._$5[index + this._$1];
    }

    public boolean isTemporary() {
        return false;
    }

    public void setTemporary(boolean ifTemporary) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeLast() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeRange(int fromIndex, int toIndex) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int[] seqs) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void reserve(int start, int end) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int size() {
        return this._$2;
    }

    public int count() {
        int size;
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        int count = size = this._$2;
        int end = this._$3;
        if (signs == null) {
            for (int i = this._$4; i <= end; ++i) {
                if (datas[i]) continue;
                --count;
            }
        } else {
            for (int i = this._$4; i <= end; ++i) {
                if (!signs[i] && datas[i]) continue;
                --count;
            }
        }
        return count;
    }

    public boolean containTrue() {
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        int end = this._$3;
        if (signs == null) {
            for (int i = this._$4; i <= end; ++i) {
                if (!datas[i]) continue;
                return true;
            }
        } else {
            for (int i = this._$4; i <= end; ++i) {
                if (signs[i] || !datas[i]) continue;
                return true;
            }
        }
        return false;
    }

    public Object ifn() {
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        boolean[] signs = this._$5;
        if (signs == null) {
            return this._$6[this._$4];
        }
        for (int i = this._$4; i <= this._$3; ++i) {
            if (signs[i]) continue;
            return this._$6[i];
        }
        return null;
    }

    public void set(int index, boolean b) {
        this._$6[index += this._$1] = b;
        if (this._$5 != null) {
            this._$5[index] = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int index, Object obj) {
        index += this._$1;
        if (obj == null) {
            if (this._$5 == null) {
                BoolArray boolArray = this._$7;
                synchronized (boolArray) {
                    if (super.getSigns() != null) {
                        this._$5 = super.getSigns();
                    } else {
                        this._$5 = new boolean[this._$6.length];
                        this._$7.setSigns(this._$5);
                        super.setSigns(this._$5);
                    }
                }
            }
            this._$5[index] = true;
        } else if (obj instanceof Boolean) {
            this._$6[index] = (Boolean)obj;
            if (this._$5 != null) {
                this._$5[index] = false;
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", (Object)mm.getMessage("DataType.Boolean"), (Object)Variant.getDataType((Object)obj)));
        }
    }

    public void clear() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int binarySearch(Object elem) {
        int idx = super.binarySearch(elem, this._$4, this._$3);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(Object elem, int start, int end) {
        int idx = super.binarySearch(elem, start + this._$1, end + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public boolean contains(Object elem) {
        if (elem instanceof Boolean) {
            boolean v = (Boolean)elem;
            boolean[] datas = this._$6;
            boolean[] signs = this._$5;
            int end = this._$3;
            if (signs == null) {
                for (int i = this._$4; i <= end; ++i) {
                    if (datas[i] != v) continue;
                    return true;
                }
            } else {
                for (int i = this._$4; i <= end; ++i) {
                    if (signs[i] || datas[i] != v) continue;
                    return true;
                }
            }
            return false;
        }
        if (elem == null) {
            boolean[] signs = this._$5;
            if (signs == null) {
                return false;
            }
            int end = this._$3;
            for (int i = this._$4; i <= end; ++i) {
                if (!signs[i]) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (isSorted) {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.binarySearch(array.get(i)) >= 1) continue;
                result.set(i, false);
            }
        } else {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.contains(array.get(i))) continue;
                result.set(i, false);
            }
        }
    }

    public boolean objectContains(Object elem) {
        return false;
    }

    public int firstIndexOf(Object elem, int start) {
        if (elem instanceof Boolean) {
            boolean v = (Boolean)elem;
            boolean[] datas = this._$6;
            boolean[] signs = this._$5;
            int size = this._$2;
            if (signs == null) {
                for (int i = start; i <= size; ++i) {
                    if (datas[i + this._$1] != v) continue;
                    return i;
                }
            } else {
                for (int i = start; i <= size; ++i) {
                    if (signs[i + this._$1] || datas[i + this._$1] != v) continue;
                    return i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this._$5;
            if (signs == null) {
                return 0;
            }
            int size = this._$2;
            for (int i = start; i <= size; ++i) {
                if (!this.getSign(i)) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public int lastIndexOf(Object elem, int start) {
        if (elem instanceof Boolean) {
            boolean v = (Boolean)elem;
            boolean[] signs = this._$5;
            if (signs == null) {
                for (int i = start; i > 0; --i) {
                    if (this.getBool(i) != v) continue;
                    return i;
                }
            } else {
                for (int i = start; i > 0; --i) {
                    if (this.getSign(i) || this.getBool(i) != v) continue;
                    return i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this._$5;
            if (signs == null) {
                return 0;
            }
            for (int i = start; i > 0; --i) {
                if (!this.getSign(i)) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        int size = this._$2;
        boolean[] signs = this._$5;
        if (elem == null) {
            IntArray result = new IntArray(7);
            if (signs != null) {
                if (isSorted) {
                    if (isFromHead) {
                        for (int i = start; i <= size && this.getSign(i); ++i) {
                            result.addInt(i);
                        }
                    } else {
                        for (int i = start; i > 0; --i) {
                            if (!this.getSign(i)) continue;
                            result.addInt(i);
                        }
                    }
                } else if (isFromHead) {
                    for (int i = start; i <= size; ++i) {
                        if (!this.getSign(i)) continue;
                        result.addInt(i);
                    }
                } else {
                    for (int i = start; i > 0; --i) {
                        if (!this.getSign(i)) continue;
                        result.addInt(i);
                    }
                }
            }
            return result;
        }
        if (!(elem instanceof Boolean)) {
            return new IntArray(1);
        }
        boolean b = (Boolean)elem;
        boolean[] datas = this._$6;
        IntArray result = new IntArray(7);
        int offset = this._$1;
        if (isFromHead) {
            if (signs == null) {
                for (int i = start; i <= size; ++i) {
                    if (datas[i + offset] != b) continue;
                    result.addInt(i);
                }
            } else {
                for (int i = start; i <= size; ++i) {
                    if (signs[i + offset] || datas[i + offset] != b) continue;
                    result.addInt(i);
                }
            }
        } else if (signs == null) {
            for (int i = start; i > 0; --i) {
                if (datas[i + offset] != b) continue;
                result.addInt(i);
            }
        } else {
            for (int i = start; i > 0; --i) {
                if (signs[i + offset] || datas[i + offset] != b) continue;
                result.addInt(i);
            }
        }
        return result;
    }

    public IArray abs() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(this.getDataType() + mm.getMessage("Variant2.illAbs"));
    }

    public IArray negate() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(this.getDataType() + mm.getMessage("Variant2.illNegate"));
    }

    public IArray not() {
        int i;
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        int size = this._$2;
        if (this.isTemporary()) {
            if (signs == null) {
                int i2 = 1;
                int f = this._$4;
                while (i2 <= size) {
                    datas[f] = !datas[f];
                    ++i2;
                    ++f;
                }
            } else {
                this._$5 = null;
                int i3 = 1;
                int f = this._$4;
                while (i3 <= size) {
                    datas[f] = signs[f] || !datas[f];
                    ++i3;
                    ++f;
                }
            }
            return this;
        }
        boolean[] newDatas = new boolean[size + 1];
        if (signs == null) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                newDatas[i] = !datas[f];
                ++i;
                ++f;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                newDatas[i] = signs[f] || !datas[f];
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isNumberArray() {
        return false;
    }

    public IArray memberAdd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberAdd(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberSubtract(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    public IArray memberMultiply(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberMultiply(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberDivide(IArray array) {
        if (array instanceof StringArray) {
            return this.dup().memberDivide((IArray)((StringArray)array));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    public IArray memberMod(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    public IArray memberIntDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof IntArray) {
            return this.calcRelation((IntArray)array, relation);
        }
        if (array instanceof LongArray) {
            return this.calcRelation((LongArray)array, relation);
        }
        if (array instanceof DoubleArray) {
            return this.calcRelation((DoubleArray)array, relation);
        }
        return this.dup().calcRelation(array, relation);
    }

    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof Boolean) {
            return this._$1((Boolean)value, relation);
        }
        if (value == null) {
            return this._$1(relation);
        }
        int size = this._$2;
        boolean[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean b = Variant.isTrue((Object)value);
        if (relation == 7) {
            boolean[] resultDatas = new boolean[size + 1];
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            if (!b) {
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = false;
                }
            } else if (s1 == null) {
                if (resultDatas != d1) {
                    System.arraycopy(d1, this._$4, resultDatas, 1, size);
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] && d1[f];
                    ++i;
                    ++f;
                }
            }
            return result;
        }
        if (relation == 8) {
            boolean[] resultDatas = new boolean[size + 1];
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            if (b) {
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = true;
                }
            } else if (s1 == null) {
                if (resultDatas != d1) {
                    System.arraycopy(d1, this._$4, resultDatas, 1, size);
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] && d1[f];
                    ++i;
                    ++f;
                }
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
    }

    private BoolArray _$1(boolean[] s2, int relation) {
        int i;
        int size = this._$2;
        boolean[] d1 = this._$6;
        boolean[] s1 = this._$5;
        if (this.isTemporary()) {
            if (relation == 7) {
                if (s1 == null) {
                    if (s2 != null) {
                        int i2 = 1;
                        int f = this._$4;
                        while (i2 <= size) {
                            if (s2[i2]) {
                                d1[f] = false;
                            }
                            ++i2;
                            ++f;
                        }
                    }
                } else if (s2 == null) {
                    int i3 = 1;
                    int f = this._$4;
                    while (i3 <= size) {
                        if (s1[f]) {
                            d1[f] = false;
                        }
                        ++i3;
                        ++f;
                    }
                } else {
                    int i4 = 1;
                    int f = this._$4;
                    while (i4 <= size) {
                        if (s1[f] || s2[i4]) {
                            d1[f] = false;
                        }
                        ++i4;
                        ++f;
                    }
                }
            } else if (s2 == null) {
                int i5 = 1;
                int f = this._$4;
                while (i5 <= size) {
                    d1[f] = true;
                    ++i5;
                    ++f;
                }
            } else if (s1 == null) {
                int i6 = 1;
                int f = this._$4;
                while (i6 <= size) {
                    if (!s2[i6]) {
                        d1[f] = true;
                    }
                    ++i6;
                    ++f;
                }
            } else {
                int i7 = 1;
                int f = this._$4;
                while (i7 <= size) {
                    if (!s2[i7]) {
                        d1[f] = true;
                    } else if (s1[f]) {
                        d1[f] = false;
                    }
                    ++i7;
                    ++f;
                }
            }
            this._$5 = null;
            return this;
        }
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 7) {
            if (s1 == null) {
                if (s2 == null) {
                    System.arraycopy(d1, this._$4, resultDatas, 1, size);
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = d1[f] && !s2[i];
                        ++i;
                        ++f;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] && d1[f];
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s2[i] && !s1[f] && d1[f];
                    ++i;
                    ++f;
                }
            }
        } else if (s2 == null) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else if (s1 == null) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] || !s2[i];
                ++i;
                ++f;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = !s2[i] || !s1[f] && d1[f];
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(IntArray array, int relation) {
        if (relation != 7 && relation != 8) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
        }
        return this._$1(array.getSigns(), relation);
    }

    protected BoolArray calcRelation(LongArray array, int relation) {
        if (relation != 7 && relation != 8) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
        }
        return this._$1(array.getSigns(), relation);
    }

    protected BoolArray calcRelation(DoubleArray array, int relation) {
        if (relation != 7 && relation != 8) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
        }
        return this._$1(array.getSigns(), relation);
    }

    private static int _$1(boolean b1, Object o2) {
        if (o2 instanceof Boolean) {
            return Variant.compare((boolean)b1, (boolean)((Boolean)o2));
        }
        if (o2 == null) {
            return 1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", (Object)b1, o2, (Object)mm.getMessage("DataType.Boolean"), (Object)Variant.getDataType((Object)o2)));
    }

    private BoolArray _$1(boolean value, int relation) {
        BoolArray result;
        block29: {
            boolean[] s1;
            boolean[] d1;
            int size;
            block39: {
                boolean[] resultDatas;
                block38: {
                    block35: {
                        block37: {
                            block36: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block28: {
                                                        size = this._$2;
                                                        d1 = this._$6;
                                                        s1 = this._$5;
                                                        resultDatas = new boolean[size + 1];
                                                        result = new BoolArray(resultDatas, size);
                                                        result.setTemporary(true);
                                                        if (relation != 1) break block28;
                                                        if (s1 == null) {
                                                            int i = 1;
                                                            int f = this._$4;
                                                            while (i <= size) {
                                                                resultDatas[i] = Variant.compare((boolean)d1[f], (boolean)value) == 0;
                                                                ++i;
                                                                ++f;
                                                            }
                                                        } else {
                                                            int i = 1;
                                                            int f = this._$4;
                                                            while (i <= size) {
                                                                resultDatas[i] = s1[f] ? false : Variant.compare((boolean)d1[f], (boolean)value) == 0;
                                                                ++i;
                                                                ++f;
                                                            }
                                                        }
                                                        break block29;
                                                    }
                                                    if (relation != 2) break block30;
                                                    if (s1 == null) {
                                                        int i = 1;
                                                        int f = this._$4;
                                                        while (i <= size) {
                                                            resultDatas[i] = Variant.compare((boolean)d1[f], (boolean)value) > 0;
                                                            ++i;
                                                            ++f;
                                                        }
                                                    } else {
                                                        int i = 1;
                                                        int f = this._$4;
                                                        while (i <= size) {
                                                            resultDatas[i] = s1[f] ? false : Variant.compare((boolean)d1[f], (boolean)value) > 0;
                                                            ++i;
                                                            ++f;
                                                        }
                                                    }
                                                    break block29;
                                                }
                                                if (relation != 3) break block31;
                                                if (s1 == null) {
                                                    int i = 1;
                                                    int f = this._$4;
                                                    while (i <= size) {
                                                        resultDatas[i] = Variant.compare((boolean)d1[f], (boolean)value) >= 0;
                                                        ++i;
                                                        ++f;
                                                    }
                                                } else {
                                                    int i = 1;
                                                    int f = this._$4;
                                                    while (i <= size) {
                                                        resultDatas[i] = s1[f] ? false : Variant.compare((boolean)d1[f], (boolean)value) >= 0;
                                                        ++i;
                                                        ++f;
                                                    }
                                                }
                                                break block29;
                                            }
                                            if (relation != 4) break block32;
                                            if (s1 == null) {
                                                int i = 1;
                                                int f = this._$4;
                                                while (i <= size) {
                                                    resultDatas[i] = Variant.compare((boolean)d1[f], (boolean)value) < 0;
                                                    ++i;
                                                    ++f;
                                                }
                                            } else {
                                                int i = 1;
                                                int f = this._$4;
                                                while (i <= size) {
                                                    resultDatas[i] = s1[f] ? true : Variant.compare((boolean)d1[f], (boolean)value) < 0;
                                                    ++i;
                                                    ++f;
                                                }
                                            }
                                            break block29;
                                        }
                                        if (relation != 5) break block33;
                                        if (s1 == null) {
                                            int i = 1;
                                            int f = this._$4;
                                            while (i <= size) {
                                                resultDatas[i] = Variant.compare((boolean)d1[f], (boolean)value) <= 0;
                                                ++i;
                                                ++f;
                                            }
                                        } else {
                                            int i = 1;
                                            int f = this._$4;
                                            while (i <= size) {
                                                resultDatas[i] = s1[f] ? true : Variant.compare((boolean)d1[f], (boolean)value) <= 0;
                                                ++i;
                                                ++f;
                                            }
                                        }
                                        break block29;
                                    }
                                    if (relation != 6) break block34;
                                    if (s1 == null) {
                                        int i = 1;
                                        int f = this._$4;
                                        while (i <= size) {
                                            resultDatas[i] = Variant.compare((boolean)d1[f], (boolean)value) != 0;
                                            ++i;
                                            ++f;
                                        }
                                    } else {
                                        int i = 1;
                                        int f = this._$4;
                                        while (i <= size) {
                                            resultDatas[i] = s1[f] ? true : Variant.compare((boolean)d1[f], (boolean)value) != 0;
                                            ++i;
                                            ++f;
                                        }
                                    }
                                    break block29;
                                }
                                if (relation != 7) break block35;
                                if (value) break block36;
                                for (int i = 1; i <= size; ++i) {
                                    resultDatas[i] = false;
                                }
                                break block29;
                            }
                            if (s1 != null) break block37;
                            if (resultDatas == d1) break block29;
                            System.arraycopy(d1, this._$4, resultDatas, 1, size);
                            break block29;
                        }
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            resultDatas[i] = !s1[f] && d1[f];
                            ++i;
                            ++f;
                        }
                        break block29;
                    }
                    if (!value) break block38;
                    for (int i = 1; i <= size; ++i) {
                        resultDatas[i] = true;
                    }
                    break block29;
                }
                if (s1 != null) break block39;
                if (resultDatas == d1) break block29;
                System.arraycopy(d1, this._$4, resultDatas, 1, size);
                break block29;
            }
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = !s1[f] && d1[f];
                ++i;
                ++f;
            }
        }
        return result;
    }

    private BoolArray _$1(int relation) {
        BoolArray result;
        block16: {
            boolean[] signs;
            boolean[] datas;
            int size;
            block24: {
                boolean[] resultDatas;
                block23: {
                    block22: {
                        block20: {
                            block21: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block14: {
                                                block15: {
                                                    size = this._$2;
                                                    datas = this._$6;
                                                    signs = this._$5;
                                                    resultDatas = new boolean[size + 1];
                                                    result = new BoolArray(resultDatas, size);
                                                    result.setTemporary(true);
                                                    if (relation != 1) break block14;
                                                    if (signs == null) break block15;
                                                    System.arraycopy(signs, this._$4, resultDatas, 1, size);
                                                    break block16;
                                                }
                                                if (resultDatas != datas) break block16;
                                                for (int i = 1; i <= size; ++i) {
                                                    resultDatas[i] = false;
                                                }
                                                break block16;
                                            }
                                            if (relation != 2) break block17;
                                            if (signs == null) {
                                                for (int i = 1; i <= size; ++i) {
                                                    resultDatas[i] = true;
                                                }
                                            } else {
                                                int i = 1;
                                                int f = this._$4;
                                                while (i <= size) {
                                                    resultDatas[i] = !signs[f];
                                                    ++i;
                                                    ++f;
                                                }
                                            }
                                            break block16;
                                        }
                                        if (relation != 3) break block18;
                                        for (int i = 1; i <= size; ++i) {
                                            resultDatas[i] = true;
                                        }
                                        break block16;
                                    }
                                    if (relation != 4) break block19;
                                    if (resultDatas != datas) break block16;
                                    for (int i = 1; i <= size; ++i) {
                                        resultDatas[i] = false;
                                    }
                                    break block16;
                                }
                                if (relation != 5) break block20;
                                if (signs == null) break block21;
                                System.arraycopy(signs, this._$4, resultDatas, 1, size);
                                break block16;
                            }
                            if (resultDatas != datas) break block16;
                            for (int i = 1; i <= size; ++i) {
                                resultDatas[i] = false;
                            }
                            break block16;
                        }
                        if (relation != 6) break block22;
                        if (signs == null) {
                            for (int i = 1; i <= size; ++i) {
                                resultDatas[i] = true;
                            }
                        } else {
                            int i = 1;
                            int f = this._$4;
                            while (i <= size) {
                                resultDatas[i] = !signs[f];
                                ++i;
                                ++f;
                            }
                        }
                        break block16;
                    }
                    if (relation != 7) break block23;
                    if (resultDatas != datas) break block16;
                    for (int i = 1; i <= size; ++i) {
                        resultDatas[i] = false;
                    }
                    break block16;
                }
                if (signs != null) break block24;
                if (resultDatas == datas) break block16;
                System.arraycopy(datas, this._$4, resultDatas, 1, size);
                break block16;
            }
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = !signs[f] && datas[f];
                ++i;
                ++f;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int compareTo(IArray array) {
        int f;
        Object[] d2;
        int result;
        int size;
        boolean[] s1;
        boolean[] d1;
        block20: {
            int f2;
            block19: {
                int f3;
                boolean d22;
                block18: {
                    int f4;
                    boolean[] s2;
                    boolean[] d23;
                    block15: {
                        block16: {
                            Object value;
                            block17: {
                                block14: {
                                    int size1 = this._$2;
                                    int size2 = array.size();
                                    d1 = this._$6;
                                    s1 = this._$5;
                                    size = size1;
                                    result = 0;
                                    if (size1 < size2) {
                                        result = -1;
                                    } else if (size1 > size2) {
                                        result = 1;
                                        size = size2;
                                    }
                                    if (!(array instanceof BoolArray)) break block14;
                                    BoolArray array2 = (BoolArray)array;
                                    d23 = array2.getDatas();
                                    s2 = array2.getSigns();
                                    f4 = this._$4;
                                    break block15;
                                }
                                if (!(array instanceof ConstArray)) break block16;
                                value = array.get(1);
                                if (!(value instanceof Boolean)) break block17;
                                d22 = (Boolean)value;
                                f3 = this._$4;
                                break block18;
                            }
                            if (value != null) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)array.getDataType()));
                            }
                            if (s1 == null) {
                                return 1;
                            }
                            f2 = this._$4;
                            break block19;
                        }
                        if (!(array instanceof ObjectArray)) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
                        }
                        ObjectArray array2 = (ObjectArray)array;
                        d2 = array2.getDatas();
                        f = this._$4;
                        break block20;
                    }
                    for (int i = 1; i <= size; ++i, ++f4) {
                        if (s1 == null || !s1[f4]) {
                            if (s2 != null && s2[i]) {
                                return 1;
                            }
                            int cmp = Variant.compare((boolean)d1[f4], (boolean)d23[i]);
                            if (cmp == 0) continue;
                            return cmp;
                        }
                        if (s2 != null && s2[i]) continue;
                        return -1;
                    }
                    return result;
                }
                for (int i = 1; i <= size; ++i, ++f3) {
                    if (s1 != null && s1[f3]) {
                        return -1;
                    }
                    int cmp = Variant.compare((boolean)d1[f3], (boolean)d22);
                    if (cmp == 0) continue;
                    return cmp;
                }
                return result;
            }
            for (int i = 1; i <= size; ++i, ++f2) {
                if (s1[f2]) continue;
                return 1;
            }
            return result;
        }
        for (int i = 1; i <= size; ++i, ++f) {
            if (s1 == null || !s1[f]) {
                int cmp = BoolArraySubset._$1(d1[f], d2[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            if (d2[i] == null) continue;
            return -1;
        }
        return result;
    }

    public int memberCompare(int index1, int index2) {
        index1 += this._$1;
        index2 += this._$1;
        if (this._$5 == null) {
            return Variant.compare((boolean)this._$6[index1], (boolean)this._$6[index2]);
        }
        if (this._$5[index1]) {
            return this._$5[index2] ? 0 : -1;
        }
        if (this._$5[index2]) {
            return 1;
        }
        return Variant.compare((boolean)this._$6[index1], (boolean)this._$6[index2]);
    }

    public boolean isMemberEquals(int index1, int index2) {
        index1 += this._$1;
        index2 += this._$1;
        if (this._$5 == null) {
            return this._$6[index1] == this._$6[index2];
        }
        if (this._$5[index1]) {
            return this._$5[index2];
        }
        if (this._$5[index2]) {
            return false;
        }
        return this._$6[index1] == this._$6[index2];
    }

    public boolean isEquals(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex += this._$1)) {
            return array.isNull(index);
        }
        if (array.isNull(index)) {
            return false;
        }
        if (array instanceof BoolArray) {
            return this._$6[curIndex] == ((BoolArray)array).getBool(index);
        }
        Object obj = array.get(index);
        return obj instanceof Boolean && (Boolean)obj == this._$6[curIndex];
    }

    public boolean isEquals(int curIndex, Object value) {
        curIndex += this._$1;
        if (value instanceof Boolean) {
            if (this._$5 == null || !this._$5[curIndex]) {
                return this._$6[curIndex] == (Boolean)value;
            }
            return false;
        }
        if (value == null) {
            return this._$5 != null && this._$5[curIndex];
        }
        return false;
    }

    public int compareTo(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index) ? 0 : -1;
        }
        if (array.isNull(index)) {
            return 1;
        }
        if (array instanceof BoolArray) {
            return Variant.compare((boolean)this._$6[curIndex + this._$1], (boolean)((BoolArray)array).getBool(index));
        }
        return BoolArraySubset._$1(this._$6[curIndex + this._$1], array.get(index));
    }

    public int compareTo(int curIndex, Object value) {
        if (this.isNull(curIndex)) {
            return value == null ? 0 : -1;
        }
        if (value == null) {
            return 1;
        }
        return BoolArraySubset._$1(this._$6[curIndex + this._$1], value);
    }

    private static int _$1(boolean value) {
        return value ? 1231 : 1237;
    }

    public int hashCode(int index) {
        if (this._$5 == null || !this._$5[index += this._$1]) {
            return BoolArraySubset._$1(this._$6[index]);
        }
        return 0;
    }

    public Object sum() {
        return null;
    }

    public Object average() {
        return null;
    }

    public Object max() {
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        if (signs == null) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f]) {
                    return Boolean.TRUE;
                }
                ++i;
                ++f;
            }
            return Boolean.FALSE;
        }
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (!signs[f] && datas[f]) {
                return Boolean.TRUE;
            }
            ++i;
            ++f;
        }
        return Boolean.FALSE;
    }

    public Object min() {
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        if (signs == null) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!datas[f]) {
                    return Boolean.FALSE;
                }
                ++i;
                ++f;
            }
            return Boolean.TRUE;
        }
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (!signs[f] && !datas[f]) {
                return Boolean.FALSE;
            }
            ++i;
            ++f;
        }
        return Boolean.TRUE;
    }

    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof BoolArray) {
            this._$1((BoolArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else {
            this.dup().calcRelations(array, relation, result, isAnd);
        }
    }

    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof Boolean) {
            this._$1((Boolean)value, relation, result, isAnd);
        } else if (value == null) {
            this.dup().calcRelations(value, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(BoolArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        boolean[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && d1[f] != d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || d1[f] != d2[i])) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || d1[f] != d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] != s2[i] || !s1[f] && d1[f] != d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Variant.compare((boolean)d1[f], (boolean)d2[i]) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || !s2[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Variant.compare((boolean)d1[f], (boolean)d2[i]) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s2[i] && (s1[f] || Variant.compare((boolean)d1[f], (boolean)d2[i]) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) >= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || Variant.compare((boolean)d1[f], (boolean)d2[i]) >= 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Variant.compare((boolean)d1[f], (boolean)d2[i]) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s2[i] || !s1[f] && Variant.compare((boolean)d1[f], (boolean)d2[i]) >= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) > 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || Variant.compare((boolean)d1[f], (boolean)d2[i]) > 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Variant.compare((boolean)d1[f], (boolean)d2[i]) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (s2[i] || Variant.compare((boolean)d1[f], (boolean)d2[i]) > 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && d1[f] == d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && d1[f] == d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && d1[f] == d2[i]) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && s1[f] == s2[i] && (s1[f] || d1[f] == d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[f] == d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && d1[f] == d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && d1[f] == d2[i]) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? s2[i] : !s2[i] && d1[f] == d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) > 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || Variant.compare((boolean)d1[f], (boolean)d2[i]) > 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Variant.compare((boolean)d1[f], (boolean)d2[i]) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || s1[f] || !s2[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) >= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || Variant.compare((boolean)d1[f], (boolean)d2[i]) >= 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Variant.compare((boolean)d1[f], (boolean)d2[i]) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s2[i] || !s1[f] && Variant.compare((boolean)d1[f], (boolean)d2[i]) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Variant.compare((boolean)d1[f], (boolean)d2[i]) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || s2[i] || !s1[f] && Variant.compare((boolean)d1[f], (boolean)d2[i]) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Variant.compare((boolean)d1[f], (boolean)d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || !s2[i] && Variant.compare((boolean)d1[f], (boolean)d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[f] != d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || d1[f] != d2[i])) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || d1[f] != d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? !s2[i] : s2[i] || d1[f] != d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(boolean value, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        boolean[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && d1[f] != value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || d1[f] != value)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)value) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Variant.compare((boolean)d1[f], (boolean)value) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)value) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Variant.compare((boolean)d1[f], (boolean)value) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Variant.compare((boolean)d1[f], (boolean)value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Variant.compare((boolean)d1[f], (boolean)value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && d1[f] == value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && d1[f] == value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && d1[f] == value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && d1[f] == value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Variant.compare((boolean)d1[f], (boolean)value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Variant.compare((boolean)d1[f], (boolean)value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)value) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Variant.compare((boolean)d1[f], (boolean)value) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Variant.compare((boolean)d1[f], (boolean)value) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Variant.compare((boolean)d1[f], (boolean)value) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && d1[f] != value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || d1[f] != value)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
        }
    }

    public IArray bitwiseAnd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("and" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("or" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseXOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseNot() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("not" + mm.getMessage("function.paramTypeError"));
    }

    public IArray select(IArray signArray) {
        int size = signArray.size();
        boolean[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        int resultSize = 0;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                boolean[] d2 = array.getDatas();
                boolean[] s2 = array.getSigns();
                if (s2 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (d2[i]) {
                            resultDatas[++resultSize] = d1[f];
                        }
                        ++i;
                        ++f;
                    }
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!s2[i] && d2[i]) {
                            resultDatas[++resultSize] = d1[f];
                        }
                        ++i;
                        ++f;
                    }
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        resultDatas[++resultSize] = d1[f];
                    }
                    ++i;
                    ++f;
                }
            }
            return new BoolArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (signArray.isTrue(i)) {
                ++resultSize;
                if (s1[f]) {
                    resultSigns[resultSize] = true;
                } else {
                    resultDatas[resultSize] = d1[f];
                }
            }
            ++i;
            ++f;
        }
        return new BoolArray(resultDatas, resultSigns, resultSize);
    }

    public IArray select(int start, int end, IArray signArray) {
        boolean[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[end - start + 1];
        int resultSize = 0;
        int offset = this._$1;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                boolean[] d2 = array.getDatas();
                boolean[] s2 = array.getSigns();
                if (s2 == null) {
                    for (int i = start; i < end; ++i) {
                        if (!d2[i]) continue;
                        resultDatas[++resultSize] = d1[i + offset];
                    }
                } else {
                    for (int i = start; i < end; ++i) {
                        if (s2[i] || !d2[i]) continue;
                        resultDatas[++resultSize] = d1[i + offset];
                    }
                }
            } else {
                for (int i = start; i < end; ++i) {
                    if (!signArray.isTrue(i)) continue;
                    resultDatas[++resultSize] = d1[i + offset];
                }
            }
            return new BoolArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[end - start + 1];
        for (int i = start; i < end; ++i) {
            if (!signArray.isTrue(i)) continue;
            ++resultSize;
            if (s1[i + offset]) {
                resultSigns[resultSize] = true;
                continue;
            }
            resultDatas[resultSize] = d1[i + offset];
        }
        return new BoolArray(resultDatas, resultSigns, resultSize);
    }

    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public Object[] toArray() {
        int size = this._$2;
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        Object[] result = new Object[size];
        if (signs == null) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                result[i - 1] = datas[f];
                ++i;
                ++f;
            }
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!signs[f]) {
                    result[i - 1] = datas[f];
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    public void toArray(Object[] result) {
        int size = this._$2;
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        if (signs == null) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                result[i - 1] = datas[f];
                ++i;
                ++f;
            }
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!signs[f]) {
                    result[i - 1] = datas[f];
                }
                ++i;
                ++f;
            }
        }
    }

    public IArray split(int pos) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray split(int from, int to) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void sort() {
        int size = this._$2;
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        int offset = this._$1;
        if (signs == null) {
            int i;
            int trueCount = 0;
            int i2 = 1;
            int f = this._$4;
            while (i2 <= size) {
                if (datas[f]) {
                    ++trueCount;
                }
                ++i2;
                ++f;
            }
            int falseCount = size - trueCount;
            for (i = 1; i <= falseCount; ++i) {
                datas[i + offset] = false;
            }
            for (i = falseCount + 1; i <= size; ++i) {
                datas[i + offset] = true;
            }
        } else {
            int i;
            int i3;
            int nullCount = 0;
            int trueCount = 0;
            for (i3 = 1; i3 <= size; ++i3) {
                if (signs[i3 + offset]) {
                    signs[i3 + offset] = false;
                    ++nullCount;
                    continue;
                }
                if (!datas[i3 + offset]) continue;
                ++trueCount;
            }
            for (i3 = 1; i3 <= nullCount; ++i3) {
                signs[i3 + offset] = true;
            }
            int falseEnd = size - trueCount;
            for (i = nullCount + 1; i <= falseEnd; ++i) {
                datas[i + offset] = false;
            }
            for (i = falseEnd + 1; i <= size; ++i) {
                datas[offset] = true;
            }
        }
    }

    public void sort(Comparator<Object> comparator) {
        int size = this._$2;
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        Object[] values = new Boolean[size + 1];
        if (signs == null) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                values[i] = datas[f];
                ++i;
                ++f;
            }
            MultithreadUtil.sort((Object[])values, (int)1, (int)(size + 1), comparator);
            i = 1;
            f = this._$4;
            while (i <= size) {
                datas[f] = (Boolean)values[i];
                ++i;
                ++f;
            }
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!signs[f]) {
                    values[i] = datas[f];
                }
                ++i;
                ++f;
            }
            MultithreadUtil.sort((Object[])values, (int)1, (int)(size + 1), comparator);
            i = 1;
            f = this._$4;
            while (i <= size) {
                if (values[i] != null) {
                    datas[f] = (Boolean)values[i];
                    signs[f] = false;
                } else {
                    signs[f] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    public boolean hasRecord() {
        return false;
    }

    public boolean isPmt(boolean isPure) {
        return false;
    }

    public IArray rvs() {
        int size = this._$2;
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        int offset = this._$1;
        if (signs == null) {
            int q = size;
            for (int i = 1; i <= size; ++i) {
                resultDatas[i] = datas[q-- + offset];
            }
            return new BoolArray(resultDatas, null, size);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        int q = size;
        while (i <= size) {
            if (signs[q + offset]) {
                resultSigns[i] = true;
            } else {
                resultDatas[i] = datas[q + offset];
            }
            ++i;
            --q;
        }
        return new BoolArray(resultDatas, resultSigns, size);
    }

    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        throw new RuntimeException();
    }

    public void setSize(int size) {
        this._$2 = size;
    }

    public ObjectArray toObjectArray() {
        int size = this._$2;
        boolean[] datas = this._$6;
        boolean[] signs = this._$5;
        Object[] resultDatas = new Object[size + 1];
        if (signs == null) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = datas[f];
                ++i;
                ++f;
            }
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!signs[f]) {
                    resultDatas[i] = datas[f];
                }
                ++i;
                ++f;
            }
        }
        return new ObjectArray(resultDatas, size);
    }

    public IArray toPureArray() {
        return this;
    }

    public IArray reserve(boolean refOrigin) {
        if (this.isTemporary()) {
            this.setTemporary(false);
            return this;
        }
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    public IArray combine(IArray signArray, IArray other) {
        return this.dup().combine(signArray, other);
    }

    public IArray combine(IArray signArray, Object value) {
        return this.dup().combine(signArray, value);
    }

    public Object pos(IArray array, String opt) {
        if (array instanceof BoolArray) {
            int len = this._$2;
            BoolArray boolArray = (BoolArray)array;
            int subLen = boolArray.size();
            if (len < subLen) {
                return null;
            }
            boolean isSorted = false;
            boolean isIncre = false;
            boolean isContinuous = false;
            if (opt != null) {
                if (opt.indexOf(98) != -1) {
                    isSorted = true;
                }
                if (opt.indexOf(105) != -1) {
                    isIncre = true;
                }
                if (opt.indexOf(99) != -1) {
                    isContinuous = true;
                }
            }
            if (isIncre) {
                IntArray result = new IntArray(subLen);
                if (isSorted) {
                    int pos = 1;
                    for (int t = 1; t <= subLen; ++t) {
                        pos = this.binarySearch(boolArray.get(t), pos, len);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                            continue;
                        }
                        return null;
                    }
                } else {
                    int pos = 1;
                    for (int t = 1; t <= subLen; ++t) {
                        pos = this.firstIndexOf(boolArray.get(t), pos);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                            continue;
                        }
                        return null;
                    }
                }
                return new Sequence((IArray)result);
            }
            if (isContinuous) {
                int maxCandidate = len - subLen + 1;
                if (isSorted) {
                    int candidate = 1;
                    block2: while (candidate <= maxCandidate) {
                        int result = this.compareTo(candidate, (IArray)boolArray, 1);
                        if (result < 0) {
                            ++candidate;
                            continue;
                        }
                        if (result == 0) {
                            int i = 2;
                            int j = candidate + 1;
                            while (i <= subLen) {
                                if (!this.isEquals(j, (IArray)boolArray, i)) {
                                    ++candidate;
                                    continue block2;
                                }
                                ++i;
                                ++j;
                            }
                            return candidate;
                        }
                        return null;
                    }
                } else {
                    block4: for (int candidate = 1; candidate <= maxCandidate; ++candidate) {
                        int i = 1;
                        int j = candidate;
                        while (i <= subLen) {
                            if (!this.isEquals(j, (IArray)boolArray, i)) continue block4;
                            ++i;
                            ++j;
                        }
                        return candidate;
                    }
                }
                return null;
            }
            IntArray result = new IntArray(subLen);
            if (isSorted) {
                for (int t = 1; t <= subLen; ++t) {
                    int pos = this.binarySearch(boolArray.get(t));
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                }
            } else {
                for (int t = 1; t <= subLen; ++t) {
                    int pos = this.firstIndexOf(boolArray.get(t), 1);
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                }
            }
            return new Sequence((IArray)result);
        }
        return ArrayUtil.pos((IArray)this.dup(), (IArray)array, (String)opt);
    }

    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }
}

