/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateArraySubset
extends DateArray {
    private static final long serialVersionUID = 1L;
    private Date[] _$5;
    private int _$4;
    private int _$3;
    private int _$2;
    private int _$1;

    public DateArraySubset(Date[] datas, boolean[] signs, int start, int end) {
        this._$5 = datas;
        this._$4 = start;
        this._$3 = end;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
    }

    public DateArraySubset(DateArray array, int start, int end) {
        super(array.getDatas(), array.size());
        this._$5 = array.getDatas();
        this._$4 = start;
        this._$3 = end;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
    }

    public Date[] getDatas() {
        int len = this._$2 + 1;
        Date[] newDatas = new Date[len];
        System.arraycopy(this._$5, this._$4, newDatas, 0, len);
        return newDatas;
    }

    public static int compare(Date d1, Date d2) {
        long t2;
        if (d1 == null) {
            return d2 == null ? 0 : -1;
        }
        if (d2 == null) {
            return 1;
        }
        long t1 = d1.getTime();
        return t1 < (t2 = d2.getTime()) ? -1 : (t1 > t2 ? 1 : 0);
    }

    private static int _$1(Date d1, long t2) {
        if (d1 != null) {
            long t1 = d1.getTime();
            return t1 < t2 ? -1 : (t1 > t2 ? 1 : 0);
        }
        return 0;
    }

    private static int _$1(Date d1, Object d2) {
        if (d2 == null) {
            return d1 == null ? 0 : 1;
        }
        if (d2 instanceof Date) {
            long t2;
            if (d1 == null) {
                return -1;
            }
            long t1 = d1.getTime();
            return t1 < (t2 = ((Date)d2).getTime()) ? -1 : (t1 > t2 ? 1 : 0);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", (Object)d1, d2, (Object)mm.getMessage("DataType.Date"), (Object)Variant.getDataType((Object)d2)));
    }

    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.Date");
    }

    public DateArray dup() {
        int len = this._$2 + 1;
        Date[] newDatas = new Date[len];
        System.arraycopy(this._$5, this._$4, newDatas, 0, len);
        return new DateArray(newDatas, this._$2);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public byte[] serialize() throws IOException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray newInstance(int count) {
        return new DateArray(count);
    }

    public void add(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int index, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insert(int index, Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(Date date) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushDate(Date date) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushNull() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void add(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void set(int curIndex, IArray array, int index) {
        this.set(curIndex, array.get(index));
    }

    public Object get(int index) {
        return this._$5[index + this._$1];
    }

    public Date getDate(int index) {
        return this._$5[index + this._$1];
    }

    public int getInt(int index) {
        throw new RuntimeException();
    }

    public long getLong(int index) {
        throw new RuntimeException();
    }

    public IArray get(int[] indexArray) {
        Date[] datas = this._$5;
        int len = indexArray.length;
        DateArray result = new DateArray(len);
        int offset = this._$1;
        for (int i : indexArray) {
            result.pushDate(datas[i + offset]);
        }
        return result;
    }

    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        Date[] datas = this._$5;
        int len = end - start + 1;
        Date[] resultDatas = new Date[len + 1];
        int offset = this._$1;
        if (doCheck) {
            int i = 1;
            while (start <= end) {
                int q = indexArray[start];
                if (q > 0) {
                    resultDatas[i] = datas[q + offset];
                }
                ++start;
                ++i;
            }
        } else {
            int i = 1;
            while (start <= end) {
                resultDatas[i++] = datas[indexArray[start] + offset];
                ++start;
            }
        }
        return new DateArray(resultDatas, len);
    }

    public IArray get(IArray indexArray) {
        Date[] datas = this._$5;
        int len = indexArray.size();
        DateArray result = new DateArray(len);
        int offset = this._$1;
        for (int i = 1; i <= len; ++i) {
            result.pushDate(datas[indexArray.getInt(i) + offset]);
        }
        return result;
    }

    public IArray get(int start, int end) {
        int newSize = end - start;
        Date[] newDatas = new Date[newSize + 1];
        System.arraycopy(this._$5, start + this._$1, newDatas, 1, newSize);
        return new DateArray(newDatas, newSize);
    }

    public void ensureCapacity(int minCapacity) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void trimToSize() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public boolean isNull(int index) {
        return this._$5[index + this._$1] == null;
    }

    public BoolArray isTrue() {
        int size = this._$2;
        Date[] datas = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = datas[f] != null;
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray isFalse() {
        int size = this._$2;
        Date[] datas = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = datas[f] == null;
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isTrue(int index) {
        return this._$5[index + this._$1] != null;
    }

    public boolean isFalse(int index) {
        return this._$5[index + this._$1] == null;
    }

    public boolean isTemporary() {
        return false;
    }

    public void setTemporary(boolean ifTemporary) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeLast() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeRange(int fromIndex, int toIndex) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int[] seqs) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void reserve(int start, int end) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int size() {
        return this._$2;
    }

    public int count() {
        int size;
        Date[] datas = this._$5;
        int count = size = this._$2;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] == null) {
                --count;
            }
            ++i;
            ++f;
        }
        return count;
    }

    public boolean containTrue() {
        int size = this._$2;
        if (size == 0) {
            return false;
        }
        Date[] datas = this._$5;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                return true;
            }
            ++i;
            ++f;
        }
        return false;
    }

    public Object ifn() {
        int size = this._$2;
        Date[] datas = this._$5;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                return datas[f];
            }
            ++i;
            ++f;
        }
        return null;
    }

    public void set(int index, Object obj) {
        index += this._$1;
        if (obj instanceof Date) {
            this._$5[index] = (Date)obj;
        } else if (obj == null) {
            this._$5[index] = null;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", (Object)mm.getMessage("DataType.Date"), (Object)Variant.getDataType((Object)obj)));
        }
    }

    public void clear() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int binarySearch(Object elem) {
        int idx = super.binarySearch(elem, this._$4, this._$3);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(Object elem, int start, int end) {
        int idx = super.binarySearch(elem, start + this._$1, end + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public boolean contains(Object elem) {
        if (elem instanceof Date) {
            long v = ((Date)elem).getTime();
            Date[] datas = this._$5;
            int size = this._$2;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null && datas[f].getTime() == v) {
                    return true;
                }
                ++i;
                ++f;
            }
            return false;
        }
        if (elem == null) {
            int size = this._$2;
            Date[] datas = this._$5;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] == null) {
                    return true;
                }
                ++i;
                ++f;
            }
            return false;
        }
        return false;
    }

    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (isSorted) {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.binarySearch(array.get(i)) >= 1) continue;
                result.set(i, false);
            }
        } else {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.contains(array.get(i))) continue;
                result.set(i, false);
            }
        }
    }

    public boolean objectContains(Object elem) {
        Date[] datas = this._$5;
        int offset = this._$1;
        int size = this._$2;
        for (int i = 1; i <= size; ++i) {
            if (datas[i + offset] != elem) continue;
            return true;
        }
        return false;
    }

    public int firstIndexOf(Object elem, int start) {
        int offset = this._$1;
        if (elem instanceof Date) {
            long v = ((Date)elem).getTime();
            Date[] datas = this._$5;
            int size = this._$2;
            for (int i = start; i <= size; ++i) {
                if (datas[i + offset] == null || datas[i + offset].getTime() != v) continue;
                return i;
            }
            return 0;
        }
        if (elem == null) {
            int size = this._$2;
            Date[] datas = this._$5;
            for (int i = start; i <= size; ++i) {
                if (datas[i + offset] != null) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public int lastIndexOf(Object elem, int start) {
        int offset = this._$1;
        if (elem instanceof Date) {
            long v = ((Date)elem).getTime();
            Date[] datas = this._$5;
            for (int i = start; i > 0; --i) {
                if (datas[i + offset] == null || datas[i + offset].getTime() != v) continue;
                return i;
            }
            return 0;
        }
        if (elem == null) {
            Date[] datas = this._$5;
            for (int i = start; i > 0; --i) {
                if (datas[i + offset] != null) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        int size = this._$2;
        Date[] datas = this._$5;
        int offset = this._$1;
        if (elem == null) {
            IntArray result = new IntArray(7);
            if (isSorted) {
                if (isFromHead) {
                    for (int i = start; i <= size && datas[i + offset] == null; ++i) {
                        result.addInt(i);
                    }
                } else {
                    for (int i = start; i > 0; --i) {
                        if (datas[i + offset] != null) continue;
                        result.addInt(i);
                    }
                }
            } else if (isFromHead) {
                for (int i = start; i <= size; ++i) {
                    if (datas[i + offset] != null) continue;
                    result.addInt(i);
                }
            } else {
                for (int i = start; i > 0; --i) {
                    if (datas[i + offset] != null) continue;
                    result.addInt(i);
                }
            }
            return result;
        }
        if (!(elem instanceof Date)) {
            return new IntArray(1);
        }
        Date date = (Date)elem;
        if (isSorted) {
            int last;
            int first;
            int index;
            int end = size;
            if (isFromHead) {
                end = start;
                start = 1;
            }
            if ((index = this.binarySearch(date, start, end)) < 1) {
                return new IntArray(1);
            }
            for (first = index; first > start && DateArraySubset.compare(datas[first - 1 + offset], date) == 0; --first) {
            }
            for (last = index; last < end && DateArraySubset.compare(datas[last + 1 + offset], date) == 0; ++last) {
            }
            IntArray result = new IntArray(last - first + 1);
            if (isFromHead) {
                while (first <= last) {
                    result.pushInt(first);
                    ++first;
                }
            } else {
                while (last >= first) {
                    result.pushInt(last);
                    --last;
                }
            }
            return result;
        }
        IntArray result = new IntArray(7);
        if (isFromHead) {
            for (int i = start; i <= size; ++i) {
                if (DateArraySubset.compare(datas[i + offset], date) != 0) continue;
                result.addInt(i);
            }
        } else {
            for (int i = start; i > 0; --i) {
                if (DateArraySubset.compare(datas[i + offset], date) != 0) continue;
                result.addInt(i);
            }
        }
        return result;
    }

    public IArray abs() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(this.getDataType() + mm.getMessage("Variant2.illAbs"));
    }

    public IArray negate() {
        int size = this._$2;
        Date[] datas = this._$5;
        if (this.isTemporary()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null) {
                    datas[f] = Variant.negate((Date)datas[f]);
                }
                ++i;
                ++f;
            }
            return this;
        }
        Date[] newDatas = new Date[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                newDatas[i] = Variant.negate((Date)datas[f]);
            }
            ++i;
            ++f;
        }
        DateArray result = new DateArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray not() {
        Date[] datas = this._$5;
        int size = this._$2;
        boolean[] newDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            newDatas[i] = datas[f] == null;
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isNumberArray() {
        return false;
    }

    public IArray memberAdd(IArray array) {
        if (array instanceof ConstArray) {
            return this.memberAdd(array.get(1));
        }
        if (array instanceof NumberArray) {
            return this.memberAdd((NumberArray)array);
        }
        if (array instanceof ObjectArray) {
            return this.memberAdd((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberAdd(Object value) {
        if (value instanceof Number) {
            int v = ((Number)value).intValue();
            int size = this._$2;
            Date[] datas = this._$5;
            Calendar calendar = Calendar.getInstance();
            if (this.isTemporary()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (datas[f] != null) {
                        datas[f] = Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)v);
                    }
                    ++i;
                    ++f;
                }
                return this;
            }
            Date[] newDatas = new Date[size + 1];
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null) {
                    newDatas[i] = Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)v);
                }
                ++i;
                ++f;
            }
            DateArray result = new DateArray(newDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return this;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illAdd"));
    }

    protected IArray memberAdd(NumberArray array) {
        int size = this._$2;
        Date[] datas = this._$5;
        Calendar calendar = Calendar.getInstance();
        if (this.isTemporary()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null && !array.isNull(i)) {
                    datas[f] = Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)array.getInt(i));
                }
                ++i;
                ++f;
            }
            return this;
        }
        Date[] newDatas = new Date[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                newDatas[i] = !array.isNull(i) ? Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)array.getInt(i)) : datas[f];
            }
            ++i;
            ++f;
        }
        DateArray result = new DateArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected IArray memberAdd(ObjectArray array) {
        if (!array.isNumberArray()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
        }
        int size = this._$2;
        Date[] datas = this._$5;
        Calendar calendar = Calendar.getInstance();
        if (this.isTemporary()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null && !array.isNull(i)) {
                    datas[f] = Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)array.getInt(i));
                }
                ++i;
                ++f;
            }
            return this;
        }
        Date[] newDatas = new Date[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                newDatas[i] = !array.isNull(i) ? Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)array.getInt(i)) : datas[f];
            }
            ++i;
            ++f;
        }
        DateArray result = new DateArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberSubtract(IArray array) {
        if (array instanceof ConstArray) {
            return this._$1(array.get(1));
        }
        if (array instanceof DateArray) {
            return this._$1((DateArray)array);
        }
        if (array.isNumberArray()) {
            int size = this._$2;
            Date[] datas = this._$5;
            Calendar calendar = Calendar.getInstance();
            if (this.isTemporary()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (datas[f] != null && !array.isNull(i)) {
                        datas[f] = Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)(-array.getInt(i)));
                    }
                    ++i;
                    ++f;
                }
                return this;
            }
            Date[] newDatas = new Date[size + 1];
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null) {
                    newDatas[i] = !array.isNull(i) ? Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)(-array.getInt(i))) : datas[f];
                }
                ++i;
                ++f;
            }
            DateArray result = new DateArray(newDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (array instanceof ObjectArray) {
            return this._$1((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray _$1(Object value) {
        if (value == null) {
            return this;
        }
        int size = this._$2;
        Date[] datas = this._$5;
        if (value instanceof Number) {
            int n = ((Number)value).intValue();
            if (n == 0) {
                return this;
            }
            Calendar calendar = Calendar.getInstance();
            if (this.isTemporary()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (datas[f] != null) {
                        datas[f] = Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)(-n));
                    }
                    ++i;
                    ++f;
                }
                return this;
            }
            Date[] resultDatas = new Date[size + 1];
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null) {
                    resultDatas[i] = Variant.dayElapse((Calendar)calendar, (Date)datas[f], (int)(-n));
                }
                ++i;
                ++f;
            }
            return new DateArray(resultDatas, size);
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null) {
                    resultDatas[i] = Variant.dayInterval((Date)date, (Date)datas[f]);
                } else {
                    if (resultSigns == null) {
                        resultSigns = new boolean[size + 1];
                    }
                    resultSigns[i] = true;
                }
                ++i;
                ++f;
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illSubtract"));
    }

    private LongArray _$1(DateArray array) {
        int size = this._$2;
        Date[] d1 = this._$5;
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = null;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (d1[f] != null && array.getDate(i) != null) {
                resultDatas[i] = Variant.dayInterval((Date)array.getDate(i), (Date)d1[f]);
            } else {
                if (resultSigns == null) {
                    resultSigns = new boolean[size + 1];
                }
                resultSigns[i] = true;
            }
            ++i;
            ++f;
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    private LongArray _$1(ObjectArray array) {
        int size = this._$2;
        Date[] datas = this._$5;
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = null;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] == null || array.get(i) == null) {
                if (resultSigns == null) {
                    resultSigns = new boolean[size + 1];
                }
                resultSigns[i] = true;
            } else if (array.get(i) instanceof Date) {
                resultDatas[i] = Variant.dayInterval((Date)((Date)array.get(i)), (Date)datas[f]);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)array.get(i)) + mm.getMessage("Variant2.illSubtract"));
            }
            ++i;
            ++f;
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberMultiply(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberMultiply(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberDivide(IArray array) {
        if (array instanceof StringArray) {
            return this._$1((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private StringArray _$1(StringArray array) {
        int size = this._$2;
        Date[] d1 = this._$5;
        String[] resultDatas = new String[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (array.getString(i) != null) {
                resultDatas[i] = d1 != null ? d1[f] + array.getString(i) : array.getString(i);
            } else if (d1 != null) {
                resultDatas[i] = d1[f].toString();
            }
            ++i;
            ++f;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberMod(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    public IArray memberIntDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof DateArray) {
            return this._$1((DateArray)array, relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        if (array instanceof BoolArray) {
            return ((BoolArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof IntArray) {
            return ((IntArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof LongArray) {
            return ((LongArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DoubleArray) {
            return ((DoubleArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof StringArray) {
            return this.calcRelation((StringArray)array, relation);
        }
        return array.calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
    }

    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof Date) {
            return this._$1((Date)value, relation);
        }
        if (value == null) {
            return ArrayUtil.calcRelationNull((Object[])this._$5, (int)this._$4, (int)this._$3, (int)this._$2, (int)relation);
        }
        boolean b = Variant.isTrue((Object)value);
        int size = this._$2;
        Date[] datas = this._$5;
        if (relation == 7) {
            BoolArray result;
            if (!b) {
                result = new BoolArray(false, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = datas[f] != null;
                    ++i;
                    ++f;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            if (b) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = datas[f] != null;
                    ++i;
                    ++f;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
    }

    private BoolArray _$1(Date value, int relation) {
        int i;
        int size = this._$2;
        Date[] d1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        long time = value.getTime();
        if (relation == 1) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], time) == 0;
                ++i;
                ++f;
            }
        } else if (relation == 2) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], time) > 0;
                ++i;
                ++f;
            }
        } else if (relation == 3) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], time) >= 0;
                ++i;
                ++f;
            }
        } else if (relation == 4) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], time) < 0;
                ++i;
                ++f;
            }
        } else if (relation == 5) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], time) <= 0;
                ++i;
                ++f;
            }
        } else if (relation == 6) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], time) != 0;
                ++i;
                ++f;
            }
        } else if (relation == 7) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null;
                ++i;
                ++f;
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray _$1(DateArray array, int relation) {
        int i;
        int size = this._$2;
        Date[] d1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset.compare(d1[f], array.getDate(i)) == 0;
                ++i;
                ++f;
            }
        } else if (relation == 2) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset.compare(d1[f], array.getDate(i)) > 0;
                ++i;
                ++f;
            }
        } else if (relation == 3) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset.compare(d1[f], array.getDate(i)) >= 0;
                ++i;
                ++f;
            }
        } else if (relation == 4) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset.compare(d1[f], array.getDate(i)) < 0;
                ++i;
                ++f;
            }
        } else if (relation == 5) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset.compare(d1[f], array.getDate(i)) <= 0;
                ++i;
                ++f;
            }
        } else if (relation == 6) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset.compare(d1[f], array.getDate(i)) != 0;
                ++i;
                ++f;
            }
        } else if (relation == 7) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null && array.getDate(i) != null;
                ++i;
                ++f;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null || array.getDate(i) != null;
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(StringArray array, int relation) {
        int size = this._$2;
        Date[] d1 = this._$5;
        if (relation == 7) {
            boolean[] resultDatas = new boolean[size + 1];
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null && array.getString(i) != null;
                ++i;
                ++f;
            }
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            boolean[] resultDatas = new boolean[size + 1];
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null || array.getString(i) != null;
                ++i;
                ++f;
            }
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
    }

    protected BoolArray calcRelation(ObjectArray array, int relation) {
        int i;
        int size = this._$2;
        Date[] d1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], array.get(i)) == 0;
                ++i;
                ++f;
            }
        } else if (relation == 2) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], array.get(i)) > 0;
                ++i;
                ++f;
            }
        } else if (relation == 3) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], array.get(i)) >= 0;
                ++i;
                ++f;
            }
        } else if (relation == 4) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], array.get(i)) < 0;
                ++i;
                ++f;
            }
        } else if (relation == 5) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], array.get(i)) <= 0;
                ++i;
                ++f;
            }
        } else if (relation == 6) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = DateArraySubset._$1(d1[f], array.get(i)) != 0;
                ++i;
                ++f;
            }
        } else if (relation == 7) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null && Variant.isTrue((Object)array.get(i));
                ++i;
                ++f;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null || Variant.isTrue((Object)array.get(i));
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int compareTo(IArray array) {
        int f;
        int result;
        int size;
        Date[] d1;
        block15: {
            int f2;
            block14: {
                int f3;
                Date d2;
                block13: {
                    int f4;
                    block10: {
                        block11: {
                            Object value;
                            block12: {
                                block9: {
                                    int size1 = this._$2;
                                    int size2 = array.size();
                                    d1 = this._$5;
                                    size = size1;
                                    result = 0;
                                    if (size1 < size2) {
                                        result = -1;
                                    } else if (size1 > size2) {
                                        result = 1;
                                        size = size2;
                                    }
                                    if (!(array instanceof DateArray)) break block9;
                                    f4 = this._$4;
                                    break block10;
                                }
                                if (!(array instanceof ConstArray)) break block11;
                                value = array.get(1);
                                if (!(value instanceof Date)) break block12;
                                d2 = (Date)value;
                                f3 = this._$4;
                                break block13;
                            }
                            if (value != null) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)array.getDataType()));
                            }
                            f2 = this._$4;
                            break block14;
                        }
                        if (!(array instanceof ObjectArray)) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
                        }
                        f = this._$4;
                        break block15;
                    }
                    for (int i = 1; i <= size; ++i, ++f4) {
                        int cmp = DateArraySubset._$1(d1[f4], array.get(i));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return result;
                }
                for (int i = 1; i <= size; ++i, ++f3) {
                    int cmp = DateArraySubset.compare(d1[f3], d2);
                    if (cmp == 0) continue;
                    return cmp;
                }
                return result;
            }
            for (int i = 1; i <= size; ++i, ++f2) {
                if (d1[f2] == null) continue;
                return 1;
            }
            return result;
        }
        for (int i = 1; i <= size; ++i, ++f) {
            int cmp = DateArraySubset._$1(d1[f], array.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return result;
    }

    public int memberCompare(int index1, int index2) {
        return DateArraySubset.compare(this._$5[index1 + this._$1], this._$5[index2 + this._$1]);
    }

    public boolean isMemberEquals(int index1, int index2) {
        index2 += this._$1;
        if (this._$5[index1 += this._$1] == null) {
            return this._$5[index2] == null;
        }
        if (this._$5[index2] == null) {
            return false;
        }
        return this._$5[index1].getTime() == this._$5[index2].getTime();
    }

    public boolean isEquals(int curIndex, IArray array, int index) {
        curIndex += this._$1;
        Object value = array.get(index);
        if (value instanceof Date) {
            return ((Date)value).equals(this._$5[curIndex]);
        }
        if (value == null) {
            return this._$5[curIndex] == null;
        }
        return false;
    }

    public boolean isEquals(int curIndex, Object value) {
        curIndex += this._$1;
        if (value instanceof Date) {
            return ((Date)value).equals(this._$5[curIndex]);
        }
        if (value == null) {
            return this._$5[curIndex] == null;
        }
        return false;
    }

    public int compareTo(int curIndex, IArray array, int index) {
        return DateArraySubset._$1(this._$5[curIndex += this._$1], array.get(index));
    }

    public int compareTo(int curIndex, Object value) {
        return DateArraySubset._$1(this._$5[curIndex += this._$1], value);
    }

    public int hashCode(int index) {
        if (this._$5[index += this._$1] != null) {
            return this._$5[index].hashCode();
        }
        return 0;
    }

    public Object sum() {
        return null;
    }

    public Object average() {
        return null;
    }

    public Object max() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        Date[] datas = this._$5;
        Date max = null;
        int offset = this._$1;
        for (i = 1; i <= size; ++i) {
            if (datas[i + offset] == null) continue;
            max = datas[i + offset];
            break;
        }
        ++i;
        while (i <= size) {
            if (datas[i + offset] != null && max.getTime() < datas[i + offset].getTime()) {
                max = datas[i + offset];
            }
            ++i;
        }
        return max;
    }

    public Object min() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        Date[] datas = this._$5;
        Date min = null;
        int offset = this._$1;
        for (i = 1; i <= size; ++i) {
            if (datas[i + offset] == null) continue;
            min = datas[i + offset];
            break;
        }
        ++i;
        while (i <= size) {
            if (datas[i + offset] != null && min.getTime() > datas[i + offset].getTime()) {
                min = datas[i + offset];
            }
            ++i;
        }
        return min;
    }

    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof DateArray) {
            this._$1((DateArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
        }
    }

    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof Date) {
            this._$1((Date)value, relation, result, isAnd);
        } else if (value == null) {
            ArrayUtil.calcRelationsNull((Object[])this._$5, (int)this._$2, (int)relation, (BoolArray)result, (boolean)isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(Date value, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        Date[] d1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        long time = value.getTime();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], time) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], time) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], time) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], time) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], time) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], time) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], time) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], time) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], time) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], time) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], time) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], time) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(DateArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        Date[] d1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset.compare(d1[f], array.getDate(i)) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        Date[] d1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && DateArraySubset._$1(d1[f], array.get(i)) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    public IArray bitwiseAnd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("and" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("or" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseXOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseNot() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("not" + mm.getMessage("function.paramTypeError"));
    }

    public IArray select(IArray signArray) {
        int size = signArray.size();
        Date[] d1 = this._$5;
        Date[] resultDatas = new Date[size + 1];
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (d2[i]) {
                        resultDatas[++count] = d1[f];
                    }
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!s2[i] && d2[i]) {
                        resultDatas[++count] = d1[f];
                    }
                    ++i;
                    ++f;
                }
            }
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (signArray.isTrue(i)) {
                    resultDatas[++count] = d1[f];
                }
                ++i;
                ++f;
            }
        }
        return new DateArray(resultDatas, count);
    }

    public IArray select(int start, int end, IArray signArray) {
        Date[] d1 = this._$5;
        Date[] resultDatas = new Date[end - start + 1];
        int count = 0;
        int offset = this._$1;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                for (int i = start; i < end; ++i) {
                    if (!d2[i]) continue;
                    resultDatas[++count] = d1[i + offset];
                }
            } else {
                for (int i = start; i < end; ++i) {
                    if (s2[i] || !d2[i]) continue;
                    resultDatas[++count] = d1[i + offset];
                }
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!signArray.isTrue(i)) continue;
                resultDatas[++count] = d1[i + offset];
            }
        }
        return new DateArray(resultDatas, count);
    }

    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public Object[] toArray() {
        Object[] result = new Object[this._$2];
        System.arraycopy(this._$5, this._$4, result, 0, this._$2);
        return result;
    }

    public void toArray(Object[] result) {
        System.arraycopy(this._$5, this._$4, result, 0, this._$2);
    }

    public IArray split(int pos) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray split(int from, int to) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void sort() {
        MultithreadUtil.sort((Date[])this._$5, (int)this._$4, (int)(this._$3 + 1));
    }

    public void sort(Comparator<Object> comparator) {
        MultithreadUtil.sort((Object[])this._$5, (int)this._$4, (int)(this._$3 + 1), comparator);
    }

    public boolean hasRecord() {
        return false;
    }

    public boolean isPmt(boolean isPure) {
        return false;
    }

    public IArray rvs() {
        int size = this._$2;
        Date[] datas = this._$5;
        Date[] resultDatas = new Date[size + 1];
        int offset = this._$1;
        int q = size;
        for (int i = 1; i <= size; ++i) {
            resultDatas[i] = datas[q-- + offset];
        }
        return new DateArray(resultDatas, size);
    }

    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        throw new RuntimeException();
    }

    public void setSize(int size) {
        this._$2 = size;
    }

    public ObjectArray toObjectArray() {
        Object[] resultDatas = new Object[this._$2 + 1];
        System.arraycopy(this._$5, this._$4, resultDatas, 1, this._$2);
        return new ObjectArray(resultDatas, this._$2);
    }

    public IArray toPureArray() {
        return this.dup();
    }

    public IArray reserve(boolean refOrigin) {
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    public IArray combine(IArray signArray, IArray other) {
        return this.dup().combine(signArray, other);
    }

    public IArray combine(IArray signArray, Object value) {
        return this.dup().combine(signArray, value);
    }

    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos((IArray)this.dup(), (IArray)array, (String)opt);
    }

    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }
}

