/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.expression.Relation;
import com.scudata.expression.fn.math.And;
import com.scudata.expression.fn.math.Bit1;
import com.scudata.expression.fn.math.Not;
import com.scudata.expression.fn.math.Or;
import com.scudata.expression.fn.math.Xor;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.CursorUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArraySubset
extends ObjectArray {
    private static final long serialVersionUID = 1L;
    private Object[] _$5;
    private int _$4;
    private int _$3;
    private int _$2;
    private int _$1;

    public ObjectArraySubset(Object[] datas, boolean[] signs, int start, int end) {
        this._$5 = datas;
        this._$4 = start;
        this._$3 = end;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
    }

    public ObjectArraySubset(ObjectArray array, int start, int end) {
        super(array.getDatas(), array.size());
        this._$5 = array.getDatas();
        this._$4 = start;
        this._$3 = end;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
    }

    public Object[] getDatas() {
        int len = this._$2 + 1;
        Object[] newDatas = new String[len];
        System.arraycopy(this._$5, this._$4, newDatas, 0, len);
        return newDatas;
    }

    public String getDataType() {
        Object[] datas = this._$5;
        int size = this._$2;
        for (int i = 1; i <= size; ++i) {
            if (datas[i + this._$1] == null) continue;
            return Variant.getDataType((Object)datas[i + this._$1]);
        }
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.Null");
    }

    public IArray dup() {
        int len = this._$2 + 1;
        Object[] newDatas = new Object[len];
        System.arraycopy(this._$5, this._$4, newDatas, 0, len);
        return new ObjectArray(newDatas, this._$2);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public byte[] serialize() throws IOException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray newInstance(int count) {
        return new ObjectArray(count);
    }

    public void add(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int index, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insert(int index, Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushNull() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void add(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void set(int curIndex, IArray array, int index) {
        this._$5[curIndex + this._$1] = array.get(index);
    }

    public Object get(int index) {
        return this._$5[index + this._$1];
    }

    public int getInt(int index) {
        return ((Number)this._$5[index + this._$1]).intValue();
    }

    public long getLong(int index) {
        return ((Number)this._$5[index + this._$1]).longValue();
    }

    public IArray get(int[] indexArray) {
        Object[] datas = this._$5;
        int len = indexArray.length;
        ObjectArray result = new ObjectArray(len);
        for (int i : indexArray) {
            result.push(datas[i + this._$1]);
        }
        return result;
    }

    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        Object[] datas = this._$5;
        int len = end - start + 1;
        Object[] resultDatas = new Object[len + 1];
        int offset = this._$1;
        if (doCheck) {
            int i = 1;
            while (start <= end) {
                int q = indexArray[start];
                if (q > 0) {
                    resultDatas[i] = datas[q + offset];
                }
                ++start;
                ++i;
            }
        } else {
            int i = 1;
            while (start <= end) {
                resultDatas[i++] = datas[indexArray[start] + offset];
                ++start;
            }
        }
        return new ObjectArray(resultDatas, len);
    }

    public IArray get(IArray indexArray) {
        Object[] datas = this._$5;
        int len = indexArray.size();
        ObjectArray result = new ObjectArray(len);
        int offset = this._$1;
        for (int i = 1; i <= len; ++i) {
            result.push(datas[indexArray.getInt(i) + offset]);
        }
        return result;
    }

    public IArray get(int start, int end) {
        int newSize = end - start;
        Object[] newDatas = new Object[newSize + 1];
        System.arraycopy(this._$5, start + this._$1, newDatas, 1, newSize);
        return new ObjectArray(newDatas, newSize);
    }

    public void ensureCapacity(int minCapacity) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void trimToSize() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public boolean isNull(int index) {
        return this._$5[index + this._$1] == null;
    }

    public BoolArray isTrue() {
        int size = this._$2;
        Object[] datas = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.isTrue((Object)datas[f]);
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray isFalse() {
        int size = this._$2;
        Object[] datas = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.isFalse((Object)datas[f]);
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isTrue(int index) {
        return Variant.isTrue((Object)this._$5[index + this._$1]);
    }

    public boolean isFalse(int index) {
        return Variant.isFalse((Object)this._$5[index + this._$1]);
    }

    public boolean isTemporary() {
        return false;
    }

    public void setTemporary(boolean ifTemporary) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeLast() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeRange(int fromIndex, int toIndex) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int[] seqs) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void reserve(int start, int end) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int size() {
        return this._$2;
    }

    public int count() {
        int size;
        Object[] datas = this._$5;
        int count = size = this._$2;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (Variant.isFalse((Object)datas[f])) {
                --count;
            }
            ++i;
            ++f;
        }
        return count;
    }

    public boolean containTrue() {
        int size = this._$2;
        if (size == 0) {
            return false;
        }
        Object[] datas = this._$5;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (Variant.isTrue((Object)datas[f])) {
                return true;
            }
            ++i;
            ++f;
        }
        return false;
    }

    public Object ifn() {
        int size = this._$2;
        Object[] datas = this._$5;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                return datas[f];
            }
            ++i;
            ++f;
        }
        return null;
    }

    public void set(int index, Object obj) {
        this._$5[index + this._$1] = obj;
    }

    public void clear() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int binarySearch(Object elem) {
        int idx = super.binarySearch(elem, this._$4, this._$3);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(Object elem, int start, int end) {
        int idx = super.binarySearch(elem, start + this._$1, end + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public boolean contains(Object elem) {
        if (elem != null) {
            Object[] datas = this._$5;
            int size = this._$2;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (Variant.isEquals((Object)datas[f], (Object)elem)) {
                    return true;
                }
                ++i;
                ++f;
            }
            return false;
        }
        int size = this._$2;
        Object[] datas = this._$5;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] == null) {
                return true;
            }
            ++i;
            ++f;
        }
        return false;
    }

    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (isSorted) {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.binarySearch(array.get(i)) >= 1) continue;
                result.set(i, false);
            }
        } else {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.contains(array.get(i))) continue;
                result.set(i, false);
            }
        }
    }

    public boolean objectContains(Object elem) {
        Object[] datas = this._$5;
        int offset = this._$1;
        int size = this._$2;
        for (int i = 1; i <= size; ++i) {
            if (datas[i + offset] != elem) continue;
            return true;
        }
        return false;
    }

    public int firstIndexOf(Object elem, int start) {
        int offset = this._$1;
        if (elem != null) {
            Object[] datas = this._$5;
            int size = this._$2;
            for (int i = start; i <= size; ++i) {
                if (!Variant.isEquals((Object)datas[i + offset], (Object)elem)) continue;
                return i;
            }
            return 0;
        }
        int size = this._$2;
        Object[] datas = this._$5;
        for (int i = start; i <= size; ++i) {
            if (datas[i + offset] != null) continue;
            return i;
        }
        return 0;
    }

    public int lastIndexOf(Object elem, int start) {
        int offset = this._$1;
        if (elem != null) {
            Object[] datas = this._$5;
            for (int i = start; i > 0; --i) {
                if (!Variant.isEquals((Object)datas[i + offset], (Object)elem)) continue;
                return i;
            }
            return 0;
        }
        Object[] datas = this._$5;
        for (int i = start; i > 0; --i) {
            if (datas[i + offset] != null) continue;
            return i;
        }
        return 0;
    }

    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        int size = this._$2;
        Object[] datas = this._$5;
        int offset = this._$1;
        if (elem == null) {
            IntArray result = new IntArray(7);
            if (isSorted) {
                if (isFromHead) {
                    for (int i = start; i <= size && datas[i + offset] == null; ++i) {
                        result.addInt(i);
                    }
                } else {
                    for (int i = start; i > 0; --i) {
                        if (datas[i + offset] != null) continue;
                        result.addInt(i);
                    }
                }
            } else if (isFromHead) {
                for (int i = start; i <= size; ++i) {
                    if (datas[i + offset] != null) continue;
                    result.addInt(i);
                }
            } else {
                for (int i = start; i > 0; --i) {
                    if (datas[i + offset] != null) continue;
                    result.addInt(i);
                }
            }
            return result;
        }
        if (isSorted) {
            int last;
            int first;
            int index;
            int end = size;
            if (isFromHead) {
                end = start;
                start = 1;
            }
            if ((index = this.binarySearch(elem, start, end)) < 1) {
                return new IntArray(1);
            }
            for (first = index; first > start && Variant.isEquals((Object)datas[first - 1 + offset], (Object)elem); --first) {
            }
            for (last = index; last < end && Variant.isEquals((Object)datas[last + 1 + offset], (Object)elem); ++last) {
            }
            IntArray result = new IntArray(last - first + 1);
            if (isFromHead) {
                while (first <= last) {
                    result.pushInt(first);
                    ++first;
                }
            } else {
                while (last >= first) {
                    result.pushInt(last);
                    --last;
                }
            }
            return result;
        }
        IntArray result = new IntArray(7);
        if (isFromHead) {
            for (int i = start; i <= size; ++i) {
                if (!Variant.isEquals((Object)datas[i + offset], (Object)elem)) continue;
                result.addInt(i);
            }
        } else {
            for (int i = start; i > 0; --i) {
                if (!Variant.isEquals((Object)datas[i + offset], (Object)elem)) continue;
                result.addInt(i);
            }
        }
        return result;
    }

    public IArray abs() {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] newDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            newDatas[i] = Variant.abs((Object)datas[f]);
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray negate() {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] newDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object obj = datas[f];
            if (obj instanceof Number) {
                newDatas[i] = Variant.negate((Number)((Number)obj));
            } else if (obj instanceof Date) {
                newDatas[i] = Variant.negate((Date)((Date)obj));
            } else if (obj instanceof String) {
                newDatas[i] = Variant.negate((String)((String)obj));
            } else if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\"-\"" + mm.getMessage("operator.numberRightOperation"));
            }
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray not() {
        Object[] datas = this._$5;
        int size = this._$2;
        boolean[] newDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            newDatas[i] = Variant.isFalse((Object)datas[f]);
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isNumberArray() {
        Object[] datas = this._$5;
        int size = this._$2;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null && !(datas[f] instanceof Number)) {
                return false;
            }
            ++i;
            ++f;
        }
        return true;
    }

    public IArray memberAdd(IArray array) {
        if (array instanceof IntArray) {
            return this.memberAdd((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberAdd((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberAdd((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberAdd(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$6((ObjectArray)array);
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).memberAdd((IArray)this);
        }
        if (array instanceof StringArray) {
            return this.memberAdd((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberAdd(Object value) {
        if (value == null) {
            return this;
        }
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.add((Object)datas[f], (Object)value);
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected IArray memberAdd(IntArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = array.getInt(i);
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() + (double)array.getInt(i);
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).add(new BigDecimal(array.getInt(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.add(new BigDecimal(array.getInt(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() + (long)array.getInt(i);
            } else if (v instanceof String) {
                Number number = Variant.parseNumber((String)((String)v));
                resultDatas[i] = number == null ? (Number)array.getInt(i) : (Number)(number instanceof Double ? (Number)(number.doubleValue() + (double)array.getInt(i)) : (Number)(number.longValue() + (long)array.getInt(i)));
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)((Date)v), (int)array.getInt(i), null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    protected IArray memberAdd(LongArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = array.getLong(i);
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() + (double)array.getLong(i);
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).add(new BigDecimal(array.getLong(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.add(new BigDecimal(array.getLong(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() + array.getLong(i);
            } else if (v instanceof String) {
                Number number = Variant.parseNumber((String)((String)v));
                resultDatas[i] = number == null ? (Number)array.getLong(i) : (Number)(number instanceof Double ? (Number)(number.doubleValue() + (double)array.getLong(i)) : (Number)(number.longValue() + array.getLong(i)));
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)((Date)v), (int)((int)array.getLong(i)), null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    protected IArray memberAdd(DoubleArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = array.getDouble(i);
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).add(new BigDecimal(array.getDouble(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.add(new BigDecimal(array.getDouble(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() + array.getDouble(i);
            } else if (v instanceof String) {
                Number number = Variant.parseNumber((String)((String)v));
                resultDatas[i] = number == null ? Double.valueOf(array.getDouble(i)) : Double.valueOf(number.doubleValue() + array.getDouble(i));
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)((Date)v), (int)((int)array.getDouble(i)), null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    protected ObjectArray memberAdd(StringArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.add((Object)d1[f], (Object)array.getString(i));
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private ObjectArray _$6(ObjectArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.add((Object)d1[f], (Object)array.get(i));
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberSubtract(IArray array) {
        if (array instanceof IntArray) {
            return this._$4((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$4((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$4((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$4(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$5((ObjectArray)array);
        }
        if (array instanceof DateArray) {
            return this._$1((DateArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray _$4(Object value) {
        if (value == null) {
            return this;
        }
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.subtract((Object)datas[f], (Object)value);
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private IArray _$4(IntArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = -array.getInt(i);
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof Long) {
                resultDatas[i] = (Long)v - (long)array.getInt(i);
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() - (double)array.getInt(i);
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).subtract(new BigDecimal(array.getInt(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.subtract(new BigDecimal(array.getInt(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).intValue() - array.getInt(i);
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)((Date)v), (int)(-array.getInt(i)), null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private IArray _$4(LongArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = -array.getLong(i);
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() - (double)array.getLong(i);
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).subtract(new BigDecimal(array.getLong(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.subtract(new BigDecimal(array.getLong(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() - array.getLong(i);
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)((Date)v), (int)(-((int)array.getLong(i))), null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private IArray _$4(DoubleArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = -array.getDouble(i);
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).subtract(new BigDecimal(array.getDouble(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.subtract(new BigDecimal(array.getDouble(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() - array.getDouble(i);
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)((Date)v), (int)(-((int)array.getDouble(i))), null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private ObjectArray _$5(ObjectArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.subtract((Object)d1[f], (Object)array.get(i));
            ++i;
            ++f;
        }
        return result;
    }

    private LongArray _$1(DateArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = null;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (d1[f] == null || array.getDate(i) == null) {
                if (resultSigns == null) {
                    resultSigns = new boolean[size + 1];
                }
                resultSigns[i] = true;
            }
            if (!(d1[f] instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)d1[f]) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
            }
            resultDatas[i] = Variant.dayInterval((Date)array.getDate(i), (Date)((Date)d1[f]));
            ++i;
            ++f;
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberMultiply(IArray array) {
        if (array instanceof IntArray) {
            return this.memberMultiply((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberMultiply((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberMultiply((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberMultiply(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$4((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberMultiply(Object value) {
        if (value == null) {
            return new ConstArray(null, this._$2);
        }
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.multiply((Object)datas[f], (Object)value);
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected ObjectArray memberMultiply(IntArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (array.isNull(i)) {
                resultDatas[i] = null;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() * (double)array.getInt(i);
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).multiply(new BigDecimal(array.getInt(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.multiply(new BigDecimal(array.getInt(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() * (long)array.getInt(i);
            } else if (v instanceof Sequence) {
                Sequence sequence = (Sequence)v;
                resultDatas[i] = sequence.multiply(array.getInt(i));
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    protected ObjectArray memberMultiply(LongArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (array.isNull(i)) {
                resultDatas[i] = null;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() * (double)array.getLong(i);
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).multiply(new BigDecimal(array.getLong(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.multiply(new BigDecimal(array.getLong(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() * array.getLong(i);
            } else if (v instanceof Sequence) {
                Sequence sequence = (Sequence)v;
                resultDatas[i] = sequence.multiply((int)array.getLong(i));
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    protected ObjectArray memberMultiply(DoubleArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (array.isNull(i)) {
                resultDatas[i] = null;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).multiply(new BigDecimal(array.getDouble(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.multiply(new BigDecimal(array.getDouble(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() * array.getDouble(i);
            } else if (v instanceof Sequence) {
                Sequence sequence = (Sequence)v;
                resultDatas[i] = sequence.multiply((int)array.getDouble(i));
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private ObjectArray _$4(ObjectArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.multiply((Object)d1[f], (Object)array.get(i));
            ++i;
            ++f;
        }
        return result;
    }

    public IArray memberDivide(IArray array) {
        if (array instanceof IntArray) {
            return this._$3((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$3((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$3((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$3(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$3((ObjectArray)array);
        }
        if (array instanceof StringArray) {
            return this._$1((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray _$3(Object value) {
        if (value == null) {
            return new ConstArray(null, this._$2);
        }
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.divide((Object)datas[f], (Object)value);
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private ObjectArray _$3(IntArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (array.isNull(i)) {
                resultDatas[i] = v instanceof String ? v : null;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).divide(new BigDecimal(array.getInt(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.divide(new BigDecimal(array.getInt(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() / (double)array.getInt(i);
            } else if (v instanceof String) {
                resultDatas[i] = (String)v + array.getInt(i);
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private ObjectArray _$3(LongArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (array.isNull(i)) {
                resultDatas[i] = v instanceof String ? v : null;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).divide(new BigDecimal(array.getLong(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.divide(new BigDecimal(array.getLong(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() / (double)array.getLong(i);
            } else if (v instanceof String) {
                resultDatas[i] = (String)v + array.getLong(i);
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private ObjectArray _$3(DoubleArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = datas[f];
            if (array.isNull(i)) {
                resultDatas[i] = v instanceof String ? v : null;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).divide(new BigDecimal(array.getDouble(i)));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.divide(new BigDecimal(array.getDouble(i)));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() / array.getDouble(i);
            } else if (v instanceof String) {
                resultDatas[i] = (String)v + array.getDouble(i);
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private StringArray _$1(StringArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        String[] resultDatas = new String[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (array.getString(i) != null) {
                resultDatas[i] = d1 != null ? d1[f] + array.getString(i) : array.getString(i);
            } else if (d1 != null) {
                resultDatas[i] = d1[f].toString();
            }
            ++i;
            ++f;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private ObjectArray _$3(ObjectArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Variant.divide((Object)d1[f], (Object)array.get(i));
            ++i;
            ++f;
        }
        return result;
    }

    public IArray memberMod(IArray array) {
        if (array instanceof IntArray) {
            return this._$2((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$2((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$2((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$2(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$2((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private IArray _$2(IntArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            BigInteger bi;
            MessageManager mm;
            Object v = d1[f];
            if (array.isNull(i)) {
                if (v instanceof Number || v == null) {
                    resultDatas[i] = null;
                } else {
                    if (!(v instanceof Sequence)) {
                        mm = EngineMessage.get();
                        throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
                    }
                    resultDatas[i] = v;
                }
            } else if (v instanceof Long) {
                resultDatas[i] = ((Number)v).longValue() % (long)array.getInt(i);
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() % (double)array.getInt(i);
            } else if (v instanceof BigDecimal) {
                bi = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf(array.getInt(i))));
            } else if (v instanceof BigInteger) {
                bi = (BigInteger)v;
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf(array.getInt(i))));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).intValue() % array.getInt(i);
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add((Object)array.getInt(i));
                resultDatas[i] = CursorUtil.xor((Sequence)((Sequence)v), (Sequence)seq2);
            } else if (v != null) {
                mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IArray _$2(LongArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            BigInteger bi;
            MessageManager mm;
            Object v = d1[f];
            if (array.isNull(i)) {
                if (v instanceof Number || v == null) {
                    resultDatas[i] = null;
                } else {
                    if (!(v instanceof Sequence)) {
                        mm = EngineMessage.get();
                        throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
                    }
                    resultDatas[i] = v;
                }
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() % (double)array.getLong(i);
            } else if (v instanceof BigDecimal) {
                bi = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf(array.getLong(i))));
            } else if (v instanceof BigInteger) {
                bi = (BigInteger)v;
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf(array.getLong(i))));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() % array.getLong(i);
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add((Object)array.getLong(i));
                resultDatas[i] = CursorUtil.xor((Sequence)((Sequence)v), (Sequence)seq2);
            } else if (v != null) {
                mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IArray _$2(DoubleArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            BigInteger bi;
            MessageManager mm;
            Object v = d1[f];
            if (array.isNull(i)) {
                if (v instanceof Number || v == null) {
                    resultDatas[i] = null;
                } else {
                    if (!(v instanceof Sequence)) {
                        mm = EngineMessage.get();
                        throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
                    }
                    resultDatas[i] = v;
                }
            } else if (v instanceof BigDecimal) {
                bi = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf((long)array.getDouble(i))));
            } else if (v instanceof BigInteger) {
                bi = (BigInteger)v;
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf((long)array.getDouble(i))));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() % array.getDouble(i);
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add((Object)array.getDouble(i));
                resultDatas[i] = CursorUtil.xor((Sequence)((Sequence)v), (Sequence)seq2);
            } else if (v != null) {
                mm = EngineMessage.get();
                throw new RQException(Variant.getDataType((Object)v) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private IArray _$2(Object value) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.mod((Object)datas[f], (Object)value);
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private IArray _$2(ObjectArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.mod((Object)d1[f], (Object)array.get(i));
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberIntDivide(IArray array) {
        if (array instanceof IntArray) {
            return this._$1((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$1((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$1((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$1(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$1((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray _$1(IntArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = d1[f];
            if (v == null || array.isNull(i)) {
                resultDatas[i] = null;
            } else if (v instanceof Long || v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).longValue() / (long)array.getInt(i);
            } else if (v instanceof BigDecimal) {
                BigInteger bi1 = ((BigDecimal)v).toBigInteger();
                BigInteger bi2 = BigInteger.valueOf(array.getInt(i));
                resultDatas[i] = new BigDecimal(bi1.divide(bi2));
            } else if (v instanceof BigInteger) {
                BigInteger bi2 = BigInteger.valueOf(array.getInt(i));
                resultDatas[i] = new BigDecimal(((BigInteger)v).divide(bi2));
            } else if (v instanceof Number) {
                resultDatas[i] = ObjectCache.getInteger((int)(((Number)v).intValue() / array.getInt(i)));
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add((Object)array.getInt(i));
                resultDatas[i] = ((Sequence)v).diff(seq2, false);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private IArray _$1(LongArray array) {
        Object[] resultDatas;
        ObjectArraySubset result;
        int size = this._$2;
        Object[] d1 = this._$5;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = d1[f];
            if (v == null || array.isNull(i)) {
                resultDatas[i] = null;
            } else if (v instanceof BigDecimal) {
                BigInteger bi1 = ((BigDecimal)v).toBigInteger();
                BigInteger bi2 = BigInteger.valueOf(array.getLong(i));
                resultDatas[i] = new BigDecimal(bi1.divide(bi2));
            } else if (v instanceof BigInteger) {
                BigInteger bi2 = BigInteger.valueOf(array.getLong(i));
                resultDatas[i] = new BigDecimal(((BigInteger)v).divide(bi2));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() / array.getLong(i);
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add((Object)array.getLong(i));
                resultDatas[i] = ((Sequence)v).diff(seq2, false);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private IArray _$1(DoubleArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = d1[f];
            if (v == null || array.isNull(i)) {
                resultDatas[i] = null;
            } else if (v instanceof BigDecimal) {
                BigInteger bi1 = ((BigDecimal)v).toBigInteger();
                BigInteger bi2 = BigInteger.valueOf((long)array.getDouble(i));
                resultDatas[i] = new BigDecimal(bi1.divide(bi2));
            } else if (v instanceof BigInteger) {
                BigInteger bi2 = BigInteger.valueOf((long)array.getDouble(i));
                resultDatas[i] = new BigDecimal(((BigInteger)v).divide(bi2));
            } else if (v instanceof Number) {
                resultDatas[i] = (double)((Number)v).longValue() / array.getDouble(i);
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add((Object)array.getDouble(i));
                resultDatas[i] = ((Sequence)v).diff(seq2, false);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    private IArray _$1(Object value) {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.intDivide((Object)datas[f], (Object)value);
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private IArray _$1(ObjectArray array) {
        int size = this._$2;
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.intDivide((Object)d1[f], (Object)array.get(i));
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof IntArray) {
            return ((IntArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof LongArray) {
            return ((LongArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DoubleArray) {
            return ((DoubleArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof StringArray) {
            return ((StringArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof BoolArray) {
            return ((BoolArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof ObjectArray) {
            return this._$1((ObjectArray)array, relation);
        }
        return array.calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
    }

    public BoolArray calcRelation(Object value, int relation) {
        boolean b;
        int i;
        if (value == null) {
            return ArrayUtil.calcRelationNull((Object[])this._$5, (int)this._$2, (int)relation);
        }
        int size = this._$2;
        Object[] d1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)value) == 0;
                ++i;
                ++f;
            }
        } else if (relation == 2) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)value) > 0;
                ++i;
                ++f;
            }
        } else if (relation == 3) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)value) >= 0;
                ++i;
                ++f;
            }
        } else if (relation == 4) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)value) < 0;
                ++i;
                ++f;
            }
        } else if (relation == 5) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)value) <= 0;
                ++i;
                ++f;
            }
        } else if (relation == 6) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)value) != 0;
                ++i;
                ++f;
            }
        } else if (relation == 7) {
            b = Variant.isTrue((Object)value);
            if (b) {
                int i2 = 1;
                int f = this._$4;
                while (i2 <= size) {
                    resultDatas[i2] = Variant.isTrue((Object)d1[f]);
                    ++i2;
                    ++f;
                }
            }
        } else {
            b = Variant.isTrue((Object)value);
            if (b) {
                for (int i3 = 1; i3 <= size; ++i3) {
                    resultDatas[i3] = true;
                }
            } else {
                int i4 = 1;
                int f = this._$4;
                while (i4 <= size) {
                    resultDatas[i4] = Variant.isTrue((Object)d1[f]);
                    ++i4;
                    ++f;
                }
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray _$1(ObjectArray array, int relation) {
        int i;
        int size = this._$2;
        Object[] d1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)array.get(i)) == 0;
                ++i;
                ++f;
            }
        } else if (relation == 2) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)array.get(i)) > 0;
                ++i;
                ++f;
            }
        } else if (relation == 3) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)array.get(i)) >= 0;
                ++i;
                ++f;
            }
        } else if (relation == 4) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)array.get(i)) < 0;
                ++i;
                ++f;
            }
        } else if (relation == 5) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)array.get(i)) <= 0;
                ++i;
                ++f;
            }
        } else if (relation == 6) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.compare((Object)d1[f], (Object)array.get(i)) != 0;
                ++i;
                ++f;
            }
        } else if (relation == 7) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.isTrue((Object)d1[f]) && Variant.isTrue((Object)array.get(i));
                ++i;
                ++f;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = Variant.isTrue((Object)d1[f]) || Variant.isTrue((Object)array.get(i));
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public int compareTo(IArray array) {
        if (array instanceof ObjectArray) {
            int size1 = this._$2;
            int size2 = array.size();
            Object[] d1 = this._$5;
            int size = size1;
            int result = 0;
            if (size1 < size2) {
                result = -1;
            } else if (size1 > size2) {
                result = 1;
                size = size2;
            }
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                int cmp = Variant.compare((Object)d1[f], (Object)array.get(i), (boolean)true);
                if (cmp != 0) {
                    return cmp;
                }
                ++i;
                ++f;
            }
            return result;
        }
        if (array instanceof ConstArray) {
            int size1 = this._$2;
            int size2 = array.size();
            Object[] d1 = this._$5;
            Object d2 = array.get(1);
            int size = size1;
            int result = 0;
            if (size1 < size2) {
                result = -1;
            } else if (size1 > size2) {
                result = 1;
                size = size2;
            }
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                int cmp = Variant.compare((Object)d1[f], (Object)d2, (boolean)true);
                if (cmp != 0) {
                    return cmp;
                }
                ++i;
                ++f;
            }
            return result;
        }
        return -array.compareTo((IArray)this);
    }

    public int memberCompare(int index1, int index2) {
        return Variant.compare((Object)this._$5[index1 + this._$1], (Object)this._$5[index2 + this._$1]);
    }

    public boolean isMemberEquals(int index1, int index2) {
        return Variant.isEquals((Object)this._$5[index1 + this._$1], (Object)this._$5[index2 + this._$1]);
    }

    public boolean isEquals(int curIndex, IArray array, int index) {
        return Variant.isEquals((Object)this._$5[curIndex + this._$1], (Object)array.get(index));
    }

    public boolean isEquals(int curIndex, Object value) {
        return Variant.isEquals((Object)this._$5[curIndex + this._$1], (Object)value);
    }

    public int compareTo(int curIndex, IArray array, int index) {
        return Variant.compare((Object)this._$5[curIndex + this._$1], (Object)array.get(index), (boolean)true);
    }

    public int compareTo(int curIndex, Object value) {
        return Variant.compare((Object)this._$5[curIndex + this._$1], (Object)value, (boolean)true);
    }

    public IArray memberAdd(int curIndex, IArray array, int index) {
        if (!array.isNull(index)) {
            Object obj = array.get(index);
            this._$5[curIndex + this._$1] = Variant.add((Object)this._$5[curIndex + this._$1], (Object)obj);
        }
        return this;
    }

    public int hashCode(int index) {
        if (this._$5[index + this._$1] != null) {
            return this._$5[index + this._$1].hashCode();
        }
        return 0;
    }

    public Object sum() {
        int size = this._$2;
        if (size < 1) {
            return null;
        }
        Object[] datas = this._$5;
        Object result = datas[1 + this._$1];
        int offset = this._$1;
        for (int i = 2; i <= size; ++i) {
            result = Variant.add((Object)result, (Object)datas[i + offset]);
        }
        return result;
    }

    public Object average() {
        int i;
        Object[] datas = this._$5;
        int size = this._$2;
        Number sum = null;
        int count = 0;
        int offset = this._$1;
        for (i = 1; i <= size; ++i) {
            if (!(datas[i + offset] instanceof Number)) continue;
            ++count;
            sum = (Number)datas[i + offset];
            break;
        }
        ++i;
        while (i <= size) {
            if (datas[i + offset] instanceof Number) {
                sum = Variant.addNum((Number)sum, (Number)((Number)datas[i + offset]));
                ++count;
            }
            ++i;
        }
        return Variant.avg(sum, (int)count);
    }

    public Object max() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        Object[] datas = this._$5;
        Object max = null;
        int offset = this._$1;
        for (i = 1; i <= size; ++i) {
            if (datas[i + offset] == null) continue;
            max = datas[i + offset];
            break;
        }
        ++i;
        while (i <= size) {
            if (datas[i + offset] != null && Variant.compare((Object)max, (Object)datas[i + offset], (boolean)true) < 0) {
                max = datas[i + offset];
            }
            ++i;
        }
        return max;
    }

    public Object min() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        Object[] datas = this._$5;
        Object min = null;
        int offset = this._$1;
        for (i = 1; i <= size; ++i) {
            if (datas[i + offset] == null) continue;
            min = datas[i + offset];
            break;
        }
        ++i;
        while (i <= size) {
            if (datas[i + offset] != null && Variant.compare((Object)min, (Object)datas[i + offset], (boolean)true) > 0) {
                min = datas[i + offset];
            }
            ++i;
        }
        return min;
    }

    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof IntArray) {
            ((IntArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof LongArray) {
            ((LongArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof DoubleArray) {
            ((DoubleArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof StringArray) {
            ((StringArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof DateArray) {
            ((DateArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof BoolArray) {
            ((BoolArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            array.calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        Object[] d1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)value) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        Object[] d1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare((Object)d1[f], (Object)array.get(i)) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    public IArray bitwiseAnd(IArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("and" + mm.getMessage("function.paramTypeError"));
            }
            ObjectArray result = new ObjectArray(size);
            result.setTemporary(true);
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                result.push(And.and((Object)datas[f], (Object)value));
                ++i;
                ++f;
            }
            return result;
        }
        ObjectArray result = new ObjectArray(size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            result.push(And.and((Object)datas[f], (Object)array.get(i)));
            ++i;
            ++f;
        }
        return result;
    }

    public IArray bitwiseOr(IArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            ObjectArray result = new ObjectArray(size);
            result.setTemporary(true);
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                result.push(Or.or((Object)datas[f], (Object)value));
                ++i;
                ++f;
            }
            return result;
        }
        ObjectArray result = new ObjectArray(size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            result.push(Or.or((Object)datas[f], (Object)array.get(i)));
            ++i;
            ++f;
        }
        return result;
    }

    public IArray bitwiseXOr(IArray array) {
        int size = this._$2;
        Object[] datas = this._$5;
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            ObjectArray result = new ObjectArray(size);
            result.setTemporary(true);
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                result.push(Xor.xor((Object)datas[f], (Object)value));
                ++i;
                ++f;
            }
            return result;
        }
        ObjectArray result = new ObjectArray(size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            result.push(Xor.xor((Object)datas[f], (Object)array.get(i)));
            ++i;
            ++f;
        }
        return result;
    }

    public IArray bitwiseNot() {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = Not.not((Object)datas[f]);
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray select(IArray signArray) {
        int size = signArray.size();
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (d2[i]) {
                        resultDatas[++count] = d1[f];
                    }
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!s2[i] && d2[i]) {
                        resultDatas[++count] = d1[f];
                    }
                    ++i;
                    ++f;
                }
            }
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (signArray.isTrue(i)) {
                    resultDatas[++count] = d1[f];
                }
                ++i;
                ++f;
            }
        }
        return new ObjectArray(resultDatas, count);
    }

    public IArray select(int start, int end, IArray signArray) {
        Object[] d1 = this._$5;
        Object[] resultDatas = new Object[end - start + 1];
        int count = 0;
        int offset = this._$1;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                for (int i = start; i < end; ++i) {
                    if (!d2[i]) continue;
                    resultDatas[++count] = d1[i + offset];
                }
            } else {
                for (int i = start; i < end; ++i) {
                    if (s2[i] || !d2[i]) continue;
                    resultDatas[++count] = d1[i + offset];
                }
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!signArray.isTrue(i)) continue;
                resultDatas[++count] = d1[i + offset];
            }
        }
        return new ObjectArray(resultDatas, count);
    }

    public Object[] toArray() {
        Object[] result = new Object[this._$2];
        System.arraycopy(this._$5, this._$4, result, 0, this._$2);
        return result;
    }

    public void toArray(Object[] result) {
        System.arraycopy(this._$5, this._$4, result, 0, this._$2);
    }

    public IArray split(int pos) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray split(int from, int to) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void sort() {
        MultithreadUtil.sort((Object[])this._$5, (int)this._$4, (int)(this._$3 + 1));
    }

    public void sort(Comparator<Object> comparator) {
        MultithreadUtil.sort((Object[])this._$5, (int)this._$4, (int)(this._$3 + 1), comparator);
    }

    public boolean hasRecord() {
        Object[] datas = this._$5;
        int i = 1;
        int size = this._$2;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] instanceof BaseRecord) {
                return true;
            }
            ++i;
            ++f;
        }
        return false;
    }

    public boolean isPmt(boolean isPure) {
        Object[] datas = this._$5;
        int size = this._$2;
        int offset = this._$1;
        if (size == 0) {
            return false;
        }
        if (isPure) {
            if (!(datas[1 + offset] instanceof BaseRecord)) {
                return false;
            }
            DataStruct ds = ((BaseRecord)datas[1 + offset]).dataStruct();
            for (int i = 2; i <= size; ++i) {
                if (datas[i + offset] instanceof BaseRecord && ((BaseRecord)datas[i + offset]).dataStruct().isCompatible(ds)) continue;
                return false;
            }
            return true;
        }
        boolean hasRecord = false;
        for (int i = 1; i <= size; ++i) {
            if (datas[i + offset] instanceof BaseRecord) {
                hasRecord = true;
                continue;
            }
            if (datas[i + offset] == null) continue;
            return false;
        }
        return hasRecord;
    }

    public IArray rvs() {
        int size = this._$2;
        Object[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int offset = this._$1;
        int q = size;
        for (int i = 1; i <= size; ++i) {
            resultDatas[i] = datas[q-- + offset];
        }
        return new ObjectArray(resultDatas, size);
    }

    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        throw new RuntimeException();
    }

    public void setSize(int size) {
        this._$2 = size;
    }

    public ObjectArray toObjectArray() {
        return this;
    }

    public IArray toPureArray() {
        int size = this._$2;
        Object[] datas = this._$5;
        IntArray resultArray = null;
        int numType = 0;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object obj = datas[f];
            if (obj instanceof String) {
                resultArray = new StringArray(size);
                break;
            }
            if (obj instanceof Date) {
                resultArray = new DateArray(size);
                break;
            }
            if (obj instanceof Double) {
                resultArray = new DoubleArray(size);
                break;
            }
            if (obj instanceof Long) {
                numType = 2;
            } else if (obj instanceof Integer) {
                if (numType < 1) {
                    numType = 1;
                }
            } else {
                if (obj instanceof Boolean) {
                    resultArray = new BoolArray(size);
                    break;
                }
                if (obj != null) {
                    return this;
                }
            }
            ++i;
            ++f;
        }
        if (resultArray == null) {
            if (numType == 1) {
                resultArray = new IntArray(size);
            } else if (numType == 2) {
                resultArray = new LongArray(size);
            } else {
                return this;
            }
        }
        i = 1;
        f = this._$4;
        while (i <= size) {
            resultArray.push(datas[f]);
            ++i;
            ++f;
        }
        return resultArray;
    }

    public IArray reserve(boolean refOrigin) {
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    public IArray combine(IArray signArray, IArray other) {
        return this.dup().combine(signArray, other);
    }

    public IArray combine(IArray signArray, Object value) {
        return this.dup().combine(signArray, value);
    }

    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos((IArray)this.dup(), (IArray)array, (String)opt);
    }

    public int bit1() {
        Object[] datas = this._$5;
        int size = this._$2;
        int sum = 0;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            sum += Bit1.bitCount((Object)datas[f]);
            ++i;
            ++f;
        }
        return sum;
    }
}

