/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.SerialBytesArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.SerialBytes;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.HashUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialBytesArraySubset
extends SerialBytesArray {
    private static final long _$6 = 0L;
    private long[] _$5;
    private long[] _$4;
    private int _$3;
    private int _$2;
    private int _$1;

    public SerialBytesArraySubset(long[] datas1, long[] datas2, boolean[] signs, int start, int end) {
        this._$5 = datas1;
        this._$4 = datas2;
        this._$3 = start;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
    }

    public SerialBytesArraySubset(SerialBytesArray array, int start, int end) {
        super(array.getDatas1(), array.getDatas2(), array.size());
        this._$5 = array.getDatas1();
        this._$4 = array.getDatas2();
        this._$3 = start;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new RuntimeException();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    public byte[] serialize() throws IOException {
        throw new RuntimeException();
    }

    public void fillRecord(byte[] bytes) throws IOException, ClassNotFoundException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.SerialBytes");
    }

    public void add(long value1, long value2) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void add(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int index, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insert(int index, Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insert(int index, long value1, long value2) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(long value1, long value2) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushNull() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void add(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void set(int curIndex, IArray array, int index) {
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            this._$5[curIndex += this._$1] = sba.getDatas1()[index];
            this._$4[curIndex] = sba.getDatas2()[index];
        } else {
            this.set(curIndex, array.get(index));
        }
    }

    public Object get(int index) {
        if (this._$5[index += this._$1] != 0L || this._$4[index] != 0L) {
            return new SerialBytes(this._$5[index], this._$4[index]);
        }
        return null;
    }

    public IArray get(int[] indexArray) {
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int len = indexArray.length;
        long[] resultDatas1 = new long[len + 1];
        long[] resultDatas2 = new long[len + 1];
        int offset = this._$1;
        int seq = 1;
        for (int i : indexArray) {
            resultDatas1[seq] = datas1[(i += offset) + offset];
            resultDatas2[seq] = datas2[i + offset];
            ++seq;
        }
        return new SerialBytesArray(resultDatas1, resultDatas2, len);
    }

    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int len = end - start + 1;
        long[] resultDatas1 = new long[len + 1];
        long[] resultDatas2 = new long[len + 1];
        int offset = this._$1;
        if (doCheck) {
            int seq = 1;
            while (start <= end) {
                int index = indexArray[start];
                if (index > 0) {
                    resultDatas1[seq] = datas1[index + offset];
                    resultDatas2[seq] = datas2[index + offset];
                } else {
                    resultDatas1[seq] = 0L;
                    resultDatas2[seq] = 0L;
                }
                ++start;
                ++seq;
            }
        } else {
            int seq = 1;
            while (start <= end) {
                resultDatas1[seq] = datas1[offset + indexArray[start]];
                resultDatas2[seq] = datas2[offset + indexArray[start]];
                ++start;
                ++seq;
            }
        }
        return new SerialBytesArray(resultDatas1, resultDatas2, len);
    }

    public IArray get(int start, int end) {
        int newSize = end - start;
        long[] newDatas1 = new long[newSize + 1];
        long[] newDatas2 = new long[newSize + 1];
        System.arraycopy(this._$5, start + this._$1, newDatas1, 1, newSize);
        System.arraycopy(this._$4, start + this._$1, newDatas2, 1, newSize);
        return new SerialBytesArray(newDatas1, newDatas2, newSize);
    }

    public IArray get(IArray indexArray) {
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int len = indexArray.size();
        long[] resultDatas1 = new long[len + 1];
        long[] resultDatas2 = new long[len + 1];
        int offset = this._$1;
        for (int i = 1; i <= len; ++i) {
            resultDatas1[i] = datas1[offset + indexArray.getInt(i)];
            resultDatas2[i] = datas2[offset + indexArray.getInt(i)];
        }
        return new SerialBytesArray(resultDatas1, resultDatas2, len);
    }

    public int getInt(int index) {
        throw new RuntimeException();
    }

    public long getLong(int index) {
        throw new RuntimeException();
    }

    public void ensureCapacity(int minCapacity) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public boolean isNull(int index) {
        return this._$5[index += this._$1] == 0L && this._$4[index] == 0L;
    }

    public BoolArray isTrue() {
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            if (datas1[f] != 0L || datas2[f] != 0L) {
                resultDatas[i] = true;
            }
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray isFalse() {
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            if (datas1[f] == 0L && datas2[f] == 0L) {
                resultDatas[i] = true;
            }
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isTrue(int index) {
        return this._$5[index + this._$1] != 0L || this._$4[index + this._$1] != 0L;
    }

    public boolean isFalse(int index) {
        return this._$5[index + this._$1] == 0L && this._$4[index + this._$1] == 0L;
    }

    public boolean isTemporary() {
        return false;
    }

    public void setTemporary(boolean ifTemporary) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeLast() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int[] seqs) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeRange(int fromIndex, int toIndex) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int size() {
        return this._$2;
    }

    public void setSize(int size) {
        this._$2 = size;
    }

    public int count() {
        int size;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int count = size = this._$2;
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            if (datas1[f] == 0L && datas2[f] == 0L) {
                --count;
            }
            ++i;
            ++f;
        }
        return count;
    }

    public boolean containTrue() {
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int size = this._$2;
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            if (datas1[f] != 0L || datas2[f] != 0L) {
                return true;
            }
            ++i;
            ++f;
        }
        return false;
    }

    public Object ifn() {
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int size = this._$2;
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            if (datas1[f] != 0L || datas2[f] != 0L) {
                new SerialBytes(datas1[f], datas2[f]);
            }
            ++i;
            ++f;
        }
        return null;
    }

    public void set(int index, Object obj) {
        index += this._$1;
        if (obj instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)obj;
            this._$5[index] = sb.getValue1();
            this._$4[index] = sb.getValue2();
        } else if (obj == null) {
            this._$5[index] = 0L;
            this._$4[index] = 0L;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", (Object)mm.getMessage("DataType.SerialBytes"), (Object)Variant.getDataType((Object)obj)));
        }
    }

    public void clear() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int binarySearch(Object elem) {
        return this.binarySearch(elem, 1, this._$2);
    }

    public int binarySearch(long value1, long value2, int start, int end) {
        int idx = super.binarySearch(value1, value2, start + this._$1, end + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(Object elem, int start, int end) {
        int idx = super.binarySearch(elem, start + this._$1, end + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public boolean contains(long value1, long value2) {
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int size = this._$2;
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            if (datas1[f] == value1 && datas2[f] == value2) {
                return true;
            }
            ++i;
            ++f;
        }
        return false;
    }

    public boolean contains(Object elem) {
        if (elem instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)elem;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            int size = this._$2;
            int i = 1;
            int f = this._$3;
            while (i <= size) {
                if (datas1[f] == value1 && datas2[f] == value2) {
                    return true;
                }
                ++i;
                ++f;
            }
            return false;
        }
        if (elem == null) {
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            int size = this._$2;
            int i = 1;
            int f = this._$3;
            while (i <= size) {
                if (datas1[f] == 0L && datas2[f] == 0L) {
                    return true;
                }
                ++i;
                ++f;
            }
            return false;
        }
        return false;
    }

    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            long[] datas1 = sba.getDatas1();
            long[] datas2 = sba.getDatas2();
            int size = this._$2;
            if (isSorted) {
                for (int i = 1; i <= resultSize; ++i) {
                    if (!result.isTrue(i) || this.binarySearch(datas1[i], datas2[i], 1, size) >= 1) continue;
                    result.set(i, false);
                }
            } else {
                for (int i = 1; i <= resultSize; ++i) {
                    if (!result.isTrue(i) || this.contains(datas1[i], datas2[i])) continue;
                    result.set(i, false);
                }
            }
        } else if (isSorted) {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.binarySearch(array.get(i)) >= 1) continue;
                result.set(i, false);
            }
        } else {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.contains(array.get(i))) continue;
                result.set(i, false);
            }
        }
    }

    public boolean objectContains(Object elem) {
        return false;
    }

    public int firstIndexOf(Object elem, int start) {
        if (elem instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)elem;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            int size = this._$2;
            int offset = this._$1;
            for (int i = start; i <= size; ++i) {
                if (datas1[i + offset] != value1 || datas2[i + offset] != value2) continue;
                return i;
            }
            return 0;
        }
        if (elem == null) {
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            int size = this._$2;
            for (int i = start; i <= size; ++i) {
                if (datas1[i + this._$1] != 0L || datas2[i + this._$1] != 0L) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public int lastIndexOf(Object elem, int start) {
        if (elem instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)elem;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            int offset = this._$1;
            for (int i = start; i > 0; --i) {
                if (datas1[i + offset] != value1 || datas2[i + offset] != value2) continue;
                return i;
            }
            return 0;
        }
        if (elem == null) {
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            int offset = this._$1;
            for (int i = start; i > 0; --i) {
                if (datas1[i + offset] != 0L || datas2[i + offset] != 0L) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int offset = this._$1;
        if (elem instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)elem;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            if (isSorted) {
                int last;
                int first;
                int index;
                int end = size;
                if (isFromHead) {
                    end = start;
                    start = 1;
                }
                if ((index = this.binarySearch(sb, start, end)) < 1) {
                    return new IntArray(1);
                }
                for (first = index; first > start && datas1[first - 1 + offset] == value1 && datas2[first - 1 + offset] == value2; --first) {
                }
                for (last = index; last < end && datas1[last + 1 + offset] == value1 && datas2[last + 1 + offset] == value2; ++last) {
                }
                IntArray result = new IntArray(last - first + 1);
                if (isFromHead) {
                    while (first <= last) {
                        result.pushInt(first);
                        ++first;
                    }
                } else {
                    while (last >= first) {
                        result.pushInt(last);
                        --last;
                    }
                }
                return result;
            }
            IntArray result = new IntArray(7);
            if (isFromHead) {
                for (int i = start; i <= size; ++i) {
                    if (datas1[i + offset] != value1 || datas2[i + offset] != value2) continue;
                    result.addInt(i);
                }
            } else {
                for (int i = start; i > 0; --i) {
                    if (datas1[i + offset] != value1 || datas2[i + offset] != value2) continue;
                    result.addInt(i);
                }
            }
            return result;
        }
        if (elem == null) {
            IntArray result = new IntArray(7);
            if (isSorted) {
                if (isFromHead) {
                    for (int i = start; i <= size && datas1[i + offset] == 0L && datas2[i + offset] == 0L; ++i) {
                        result.addInt(i);
                    }
                } else {
                    for (int i = start; i > 0; --i) {
                        if (datas1[i + offset] != 0L || datas2[i + offset] != 0L) continue;
                        result.addInt(i);
                    }
                }
            } else if (isFromHead) {
                for (int i = start; i <= size; ++i) {
                    if (datas1[i + offset] != 0L || datas2[i + offset] != 0L) continue;
                    result.addInt(i);
                }
            } else {
                for (int i = start; i > 0; --i) {
                    if (datas1[i + offset] != 0L || datas2[i + offset] != 0L) continue;
                    result.addInt(i);
                }
            }
            return result;
        }
        return new IntArray(1);
    }

    public IArray dup() {
        int len = this._$2 + 1;
        long[] newDatas1 = new long[len];
        long[] newDatas2 = new long[len];
        System.arraycopy(this._$5, this._$3, newDatas1, 0, len);
        System.arraycopy(this._$4, this._$3, newDatas2, 0, len);
        return new SerialBytesArray(newDatas1, newDatas2, this._$2);
    }

    public IArray newInstance(int count) {
        return new SerialBytesArray(count);
    }

    public IArray abs() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(this.getDataType() + mm.getMessage("Variant2.illAbs"));
    }

    public IArray negate() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(this.getDataType() + mm.getMessage("Variant2.illNegate"));
    }

    public IArray not() {
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int size = this._$2;
        boolean[] newDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            newDatas[i] = datas1[f] == 0L && datas2[f] == 0L;
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isNumberArray() {
        return false;
    }

    public IArray memberAdd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberAdd(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberSubtract(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    public IArray memberMultiply(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberMultiply(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    public IArray memberMod(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    public IArray memberIntDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof SerialBytesArray) {
            return this._$1((SerialBytesArray)array, relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
    }

    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof SerialBytes) {
            int i;
            int size = this._$2;
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            SerialBytes sb = (SerialBytes)value;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            boolean[] resultDatas = new boolean[size + 1];
            if (relation == 1) {
                i = 1;
                int f = this._$3;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) == 0;
                    ++i;
                    ++f;
                }
            } else if (relation == 2) {
                i = 1;
                int f = this._$3;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) > 0;
                    ++i;
                    ++f;
                }
            } else if (relation == 3) {
                i = 1;
                int f = this._$3;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) >= 0;
                    ++i;
                    ++f;
                }
            } else if (relation == 4) {
                i = 1;
                int f = this._$3;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) < 0;
                    ++i;
                    ++f;
                }
            } else if (relation == 5) {
                i = 1;
                int f = this._$3;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) <= 0;
                    ++i;
                    ++f;
                }
            } else if (relation == 6) {
                i = 1;
                int f = this._$3;
                while (i <= size) {
                    resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) != 0;
                    ++i;
                    ++f;
                }
            } else if (relation == 7) {
                i = 1;
                int f = this._$3;
                while (i <= size) {
                    resultDatas[i] = !(datas1[f] == 0L && datas2[f] == 0L || value1 == 0L && value2 == 0L);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$3;
                while (i <= size) {
                    resultDatas[i] = datas1[f] != 0L || datas2[f] != 0L || value1 != 0L || value2 != 0L;
                    ++i;
                    ++f;
                }
            }
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            int i;
            boolean[] resultDatas = new boolean[this._$2 + 1];
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            if (relation == 1) {
                i = 1;
                int f = this._$3;
                while (i <= this._$2) {
                    if (datas1[f] == 0L && datas2[f] == 0L) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else if (relation == 2) {
                i = 1;
                int f = this._$3;
                while (i <= this._$2) {
                    if (datas1[f] == 0L || datas2[f] == 0L) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else if (relation == 3) {
                for (i = 1; i <= this._$2; ++i) {
                    resultDatas[i] = true;
                }
            } else if (relation != 4) {
                if (relation == 5) {
                    i = 1;
                    int f = this._$3;
                    while (i <= this._$2) {
                        if (datas1[f] == 0L && datas2[f] == 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                } else if (relation == 6) {
                    i = 1;
                    int f = this._$3;
                    while (i <= this._$2) {
                        if (datas1[f] != 0L || datas2[f] != 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                } else if (relation == 8) {
                    i = 1;
                    int f = this._$3;
                    while (i <= this._$2) {
                        if (datas1[f] != 0L || datas2[f] != 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            BoolArray result = new BoolArray(resultDatas, this._$2);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
    }

    private BoolArray _$1(SerialBytesArray other, int relation) {
        int i;
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            int f = this._$3;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) == 0;
                ++i;
                ++f;
            }
        } else if (relation == 2) {
            i = 1;
            int f = this._$3;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) > 0;
                ++i;
                ++f;
            }
        } else if (relation == 3) {
            i = 1;
            int f = this._$3;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) >= 0;
                ++i;
                ++f;
            }
        } else if (relation == 4) {
            i = 1;
            int f = this._$3;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) < 0;
                ++i;
                ++f;
            }
        } else if (relation == 5) {
            i = 1;
            int f = this._$3;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) <= 0;
                ++i;
                ++f;
            }
        } else if (relation == 6) {
            i = 1;
            int f = this._$3;
            while (i <= size) {
                resultDatas[i] = SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) != 0;
                ++i;
                ++f;
            }
        } else if (relation == 7) {
            i = 1;
            int f = this._$3;
            while (i <= size) {
                resultDatas[i] = !(datas1[f] == 0L && datas2[f] == 0L || other.getData1(i) == 0L && other.getData2(i) == 0L);
                ++i;
                ++f;
            }
        } else {
            i = 1;
            int f = this._$3;
            while (i <= size) {
                resultDatas[i] = datas1[f] != 0L || datas2[f] != 0L || other.getData1(i) != 0L || other.getData2(i) != 0L;
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(ObjectArray array, int relation) {
        int i;
        int size = this._$2;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = this.compareTo(i, array.get(i)) == 0;
            }
        } else if (relation == 2) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = this.compareTo(i, array.get(i)) > 0;
            }
        } else if (relation == 3) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = this.compareTo(i, array.get(i)) >= 0;
            }
        } else if (relation == 4) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = this.compareTo(i, array.get(i)) < 0;
            }
        } else if (relation == 5) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = this.compareTo(i, array.get(i)) <= 0;
            }
        } else if (relation == 6) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = this.compareTo(i, array.get(i)) != 0;
            }
        } else if (relation == 7) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = this.isTrue(i) && Variant.isTrue((Object)array.get(i));
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = this.isTrue(i) || Variant.isTrue((Object)array.get(i));
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof SerialBytesArray) {
            this._$1((SerialBytesArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof SerialBytes) {
            int size = this._$2;
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            SerialBytes sb = (SerialBytes)value;
            long value1 = sb.getValue1();
            long value2 = sb.getValue2();
            boolean[] resultDatas = result.getDatas();
            if (isAnd) {
                if (relation == 1) {
                    int i = 1;
                    int f = this._$3;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else if (relation == 2) {
                    int i = 1;
                    int f = this._$3;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else if (relation == 3) {
                    int i = 1;
                    int f = this._$3;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else if (relation == 4) {
                    int i = 1;
                    int f = this._$3;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else if (relation == 5) {
                    int i = 1;
                    int f = this._$3;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    if (relation != 6) throw new RuntimeException();
                    int i = 1;
                    int f = this._$3;
                    while (i <= size) {
                        if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 1) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)value1, (long)value2) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (value == null) {
            long[] datas1 = this._$5;
            long[] datas2 = this._$4;
            boolean[] resultDatas = result.getDatas();
            if (isAnd) {
                if (relation == 1) {
                    int i = 1;
                    int f = this._$3;
                    while (i <= this._$2) {
                        if (datas1[f] != 0L || datas2[f] != 0L) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else if (relation == 2) {
                    int i = 1;
                    int f = this._$3;
                    while (i <= this._$2) {
                        if (datas1[f] == 0L && datas2[f] == 0L) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    if (relation == 3) return;
                    if (relation == 4) {
                        for (int i = 1; i <= this._$2; ++i) {
                            resultDatas[i] = false;
                        }
                        return;
                    } else if (relation == 5) {
                        int i = 1;
                        int f = this._$3;
                        while (i <= this._$2) {
                            if (datas1[f] != 0L || datas2[f] != 0L) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        if (relation != 6) throw new RuntimeException();
                        int i = 1;
                        int f = this._$3;
                        while (i <= this._$2) {
                            if (datas1[f] == 0L && datas2[f] == 0L) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                }
                return;
            } else if (relation == 1) {
                int i = 1;
                int f = this._$3;
                while (i <= this._$2) {
                    if (datas1[f] == 0L && datas2[f] == 0L) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$3;
                while (i <= this._$2) {
                    if (datas1[f] != 0L || datas2[f] != 0L) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                for (int i = 1; i <= this._$2; ++i) {
                    resultDatas[i] = true;
                }
                return;
            } else {
                if (relation == 4) return;
                if (relation == 5) {
                    int i = 1;
                    int f = this._$3;
                    while (i <= this._$2) {
                        if (datas1[f] == 0L && datas2[f] == 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    if (relation != 6) throw new RuntimeException();
                    int i = 1;
                    int f = this._$3;
                    while (i <= this._$2) {
                        if (datas1[f] != 0L || datas2[f] != 0L) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(SerialBytesArray other, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$3;
                while (i <= size) {
                    if (resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            int f = this._$3;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            int f = this._$3;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            int f = this._$3;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            int f = this._$3;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            int f = this._$3;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            int f = this._$3;
            while (i <= size) {
                if (!resultDatas[i] && SerialBytes.compare((long)datas1[f], (long)datas2[f], (long)other.getData1(i), (long)other.getData2(i)) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                for (int i = 1; i <= size; ++i) {
                    if (!resultDatas[i] || this.compareTo(i, array.get(i)) == 0) continue;
                    resultDatas[i] = false;
                }
                return;
            } else if (relation == 2) {
                for (int i = 1; i <= size; ++i) {
                    if (!resultDatas[i] || this.compareTo(i, array.get(i)) > 0) continue;
                    resultDatas[i] = false;
                }
                return;
            } else if (relation == 3) {
                for (int i = 1; i <= size; ++i) {
                    if (!resultDatas[i] || this.compareTo(i, array.get(i)) >= 0) continue;
                    resultDatas[i] = false;
                }
                return;
            } else if (relation == 4) {
                for (int i = 1; i <= size; ++i) {
                    if (!resultDatas[i] || this.compareTo(i, array.get(i)) < 0) continue;
                    resultDatas[i] = false;
                }
                return;
            } else if (relation == 5) {
                for (int i = 1; i <= size; ++i) {
                    if (!resultDatas[i] || this.compareTo(i, array.get(i)) <= 0) continue;
                    resultDatas[i] = false;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                for (int i = 1; i <= size; ++i) {
                    if (!resultDatas[i] || this.compareTo(i, array.get(i)) != 0) continue;
                    resultDatas[i] = false;
                }
            }
            return;
        } else if (relation == 1) {
            for (int i = 1; i <= size; ++i) {
                if (resultDatas[i] || this.compareTo(i, array.get(i)) != 0) continue;
                resultDatas[i] = true;
            }
            return;
        } else if (relation == 2) {
            for (int i = 1; i <= size; ++i) {
                if (resultDatas[i] || this.compareTo(i, array.get(i)) <= 0) continue;
                resultDatas[i] = true;
            }
            return;
        } else if (relation == 3) {
            for (int i = 1; i <= size; ++i) {
                if (resultDatas[i] || this.compareTo(i, array.get(i)) < 0) continue;
                resultDatas[i] = true;
            }
            return;
        } else if (relation == 4) {
            for (int i = 1; i <= size; ++i) {
                if (resultDatas[i] || this.compareTo(i, array.get(i)) >= 0) continue;
                resultDatas[i] = true;
            }
            return;
        } else if (relation == 5) {
            for (int i = 1; i <= size; ++i) {
                if (resultDatas[i] || this.compareTo(i, array.get(i)) > 0) continue;
                resultDatas[i] = true;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            for (int i = 1; i <= size; ++i) {
                if (resultDatas[i] || this.compareTo(i, array.get(i)) == 0) continue;
                resultDatas[i] = true;
            }
        }
    }

    public IArray bitwiseAnd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("and" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("or" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseXOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseNot() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("not" + mm.getMessage("function.paramTypeError"));
    }

    public int memberCompare(int index1, int index2) {
        return SerialBytes.compare((long)this._$5[index1 += this._$1], (long)this._$4[index1], (long)this._$5[index2 += this._$1], (long)this._$4[index2]);
    }

    public boolean isMemberEquals(int index1, int index2) {
        return this._$5[index1 += this._$1] == this._$5[index2 += this._$1] && this._$4[index1] == this._$4[index2];
    }

    /*
     * Enabled aggressive block sorting
     */
    public int compareTo(IArray array) {
        int result;
        int size;
        block15: {
            int f;
            long[] datas2;
            long[] datas1;
            block14: {
                int f2;
                long value2;
                long value1;
                block13: {
                    int f3;
                    SerialBytesArray other;
                    block10: {
                        block11: {
                            Object value;
                            block12: {
                                block9: {
                                    int size1 = this._$2;
                                    int size2 = array.size();
                                    datas1 = this._$5;
                                    datas2 = this._$4;
                                    size = size1;
                                    result = 0;
                                    if (size1 < size2) {
                                        result = -1;
                                    } else if (size1 > size2) {
                                        result = 1;
                                        size = size2;
                                    }
                                    if (!(array instanceof SerialBytesArray)) break block9;
                                    other = (SerialBytesArray)array;
                                    f3 = this._$3;
                                    break block10;
                                }
                                if (!(array instanceof ConstArray)) break block11;
                                value = array.get(1);
                                if (!(value instanceof SerialBytes)) break block12;
                                SerialBytes sb = (SerialBytes)value;
                                value1 = sb.getValue1();
                                value2 = sb.getValue2();
                                f2 = this._$3;
                                break block13;
                            }
                            if (value != null) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)array.getDataType()));
                            }
                            f = this._$3;
                            break block14;
                        }
                        if (!(array instanceof ObjectArray)) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
                        }
                        break block15;
                    }
                    for (int i = 1; i <= size; ++i, ++f3) {
                        int cmp = SerialBytes.compare((long)datas1[f3], (long)datas2[f3], (long)other.getData1(i), (long)other.getData2(i));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return result;
                }
                for (int i = 1; i <= size; ++i, ++f2) {
                    int cmp = SerialBytes.compare((long)datas1[f2], (long)datas2[f2], (long)value1, (long)value2);
                    if (cmp == 0) continue;
                    return cmp;
                }
                return result;
            }
            for (int i = 1; i <= size; ++i, ++f) {
                if (datas1[f] == 0L && datas2[f] == 0L) continue;
                return 1;
            }
            return result;
        }
        for (int i = 1; i <= size; ++i) {
            int cmp = this.compareTo(i, array.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return result;
    }

    public int hashCode(int index) {
        return HashUtil.hashCode((long)(this._$5[index += this._$1] + this._$4[index]));
    }

    public Object sum() {
        return null;
    }

    public Object average() {
        return null;
    }

    public Object max() {
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int offset = this._$1;
        long max1 = datas1[1 + offset];
        long max2 = datas2[1 + offset];
        for (int i = 2; i <= size; ++i) {
            if (SerialBytes.compare((long)max1, (long)max2, (long)datas1[i + offset], (long)datas2[i + offset]) >= 0) continue;
            max1 = datas1[i + offset];
            max2 = datas2[i + offset];
        }
        if (max1 != 0L || max2 != 0L) {
            return new SerialBytes(max1, max2);
        }
        return null;
    }

    public Object min() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        long min1 = 0L;
        long min2 = 0L;
        int offset = this._$1;
        for (i = 1; i <= size; ++i) {
            if (datas1[i + offset] == 0L && datas2[i + offset] == 0L) continue;
            min1 = datas1[i + offset];
            min2 = datas2[i + offset];
            break;
        }
        ++i;
        while (i <= size) {
            if ((datas1[i + offset] != 0L || datas2[i + offset] != 0L) && SerialBytes.compare((long)min1, (long)min2, (long)datas1[i + offset], (long)datas2[i + offset]) > 0) {
                min1 = datas1[i + offset];
                min2 = datas2[i + offset];
            }
            ++i;
        }
        if (min1 != 0L || min2 != 0L) {
            return new SerialBytes(min1, min2);
        }
        return null;
    }

    public void reserve(int start, int end) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public Object[] toArray() {
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        Object[] result = new Object[size];
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            if (datas1[f] != 0L || datas2[f] != 0L) {
                result[i - 1] = new SerialBytes(datas1[f], datas2[f]);
            }
            ++i;
            ++f;
        }
        return result;
    }

    public void toArray(Object[] result) {
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            result[i - 1] = datas1[f] != 0L || datas2[f] != 0L ? new SerialBytes(datas1[f], datas2[f]) : null;
            ++i;
            ++f;
        }
    }

    public IArray split(int pos) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray split(int from, int to) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void trimToSize() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray select(IArray signArray) {
        int size = signArray.size();
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        long[] newDatas1 = new long[size + 1];
        long[] newDatas2 = new long[size + 1];
        int count = 0;
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            if (signArray.isTrue(i)) {
                newDatas1[++count] = datas1[f];
                newDatas2[count] = datas2[f];
            }
            ++i;
            ++f;
        }
        return new SerialBytesArray(newDatas1, newDatas2, count);
    }

    public IArray select(int start, int end, IArray signArray) {
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        long[] newDatas1 = new long[end - start + 1];
        long[] newDatas2 = new long[end - start + 1];
        int count = 0;
        int offset = this._$1;
        for (int i = start; i < end; ++i) {
            if (!signArray.isTrue(i)) continue;
            newDatas1[++count] = datas1[i + offset];
            newDatas2[count] = datas2[i + offset];
        }
        return new SerialBytesArray(newDatas1, newDatas2, count);
    }

    public boolean isEquals(int curIndex, IArray array, int index) {
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            return this._$5[curIndex + this._$1] == sba.getData1(index) && this._$4[curIndex + this._$1] == sba.getData2(index);
        }
        return this.isEquals(curIndex, array.get(index));
    }

    public boolean isEquals(int curIndex, Object value) {
        curIndex += this._$1;
        if (value instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)value;
            return this._$5[curIndex] == sb.getValue1() && this._$4[curIndex] == sb.getValue2();
        }
        if (value == null) {
            return this._$5[curIndex] == 0L && this._$4[curIndex] == 0L;
        }
        return false;
    }

    public int compareTo(int curIndex, IArray array, int index) {
        if (array instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)array;
            return SerialBytes.compare((long)this._$5[curIndex + this._$1], (long)this._$4[curIndex + this._$1], (long)sba.getData1(index), (long)sba.getData2(index));
        }
        return this.compareTo(curIndex, array.get(index));
    }

    public int compareTo(int curIndex, Object value) {
        if (value instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)value;
            return SerialBytes.compare((long)this._$5[curIndex += this._$1], (long)this._$4[curIndex], (long)sb.getValue1(), (long)sb.getValue2());
        }
        if (value == null) {
            return this._$5[curIndex += this._$1] != 0L || this._$4[curIndex] != 0L ? 1 : 0;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(curIndex), value, (Object)mm.getMessage("DataType.SerialBytes"), (Object)Variant.getDataType((Object)value)));
    }

    public void sort() {
        Object[] sbs = new SerialBytes[this._$2];
        this.toArray(sbs);
        MultithreadUtil.sort((Object[])sbs);
        int i = 0;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int offset = this._$1;
        for (Object sb : sbs) {
            ++i;
            if (sb == null) {
                datas1[i + offset] = 0L;
                datas2[i + offset] = 0L;
                continue;
            }
            datas1[i + offset] = sb.getValue1();
            datas2[i + offset] = sb.getValue2();
        }
    }

    public void sort(Comparator<Object> comparator) {
        Object[] sbs = new SerialBytes[this._$2];
        this.toArray(sbs);
        MultithreadUtil.sort((Object[])sbs, comparator);
        int i = 0;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        int offset = this._$1;
        for (Object sb : sbs) {
            ++i;
            if (sb == null) {
                datas1[i + offset] = 0L;
                datas2[i + offset] = 0L;
                continue;
            }
            datas1[i + offset] = sb.getValue1();
            datas2[i + offset] = sb.getValue2();
        }
    }

    public boolean hasRecord() {
        return false;
    }

    public boolean isPmt(boolean isPure) {
        return false;
    }

    public IArray rvs() {
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        long[] resultDatas1 = new long[size + 1];
        long[] resultDatas2 = new long[size + 1];
        int offset = this._$1;
        int i = 1;
        int q = size;
        while (i <= size) {
            resultDatas1[i] = datas1[q + offset];
            resultDatas2[i] = datas2[q + offset];
            ++i;
            --q;
        }
        return new SerialBytesArray(resultDatas1, resultDatas2, size);
    }

    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        throw new RuntimeException();
    }

    public ObjectArray toObjectArray() {
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$3;
        while (i <= size) {
            if (datas1[f] != 0L || datas2[f] != 0L) {
                resultDatas[i] = new SerialBytes(datas1[f], datas2[f]);
            }
            ++i;
            ++f;
        }
        return new ObjectArray(resultDatas, size);
    }

    public IArray toPureArray() {
        return this;
    }

    public IArray reserve(boolean refOrigin) {
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    public IArray combine(IArray signArray, IArray other) {
        if (other instanceof ConstArray) {
            return this.combine(signArray, ((ConstArray)other).getData());
        }
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        if (other instanceof SerialBytesArray) {
            SerialBytesArray sba = (SerialBytesArray)other;
            long[] resultDatas1 = new long[size + 1];
            long[] resultDatas2 = new long[size + 1];
            System.arraycopy(datas1, this._$3, resultDatas1, 1, size);
            System.arraycopy(datas2, this._$3, resultDatas2, 1, size);
            for (int i = 1; i <= size; ++i) {
                if (!signArray.isFalse(i)) continue;
                resultDatas1[i] = sba.getData1(i);
                resultDatas2[i] = sba.getData2(i);
            }
            SerialBytesArray result = new SerialBytesArray(resultDatas1, resultDatas2, size);
            result.setTemporary(true);
            return result;
        }
        Object[] resultDatas = new Object[size + 1];
        for (int i = 1; i <= size; ++i) {
            resultDatas[i] = signArray.isFalse(i) ? other.get(i) : this.get(i);
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray combine(IArray signArray, Object value) {
        int size = this._$2;
        long[] datas1 = this._$5;
        long[] datas2 = this._$4;
        if (value instanceof SerialBytes || value == null) {
            long value1 = 0L;
            long value2 = 0L;
            if (value != null) {
                SerialBytes sb = (SerialBytes)value;
                value1 = sb.getValue1();
                value2 = sb.getValue2();
            }
            long[] resultDatas1 = new long[size + 1];
            long[] resultDatas2 = new long[size + 1];
            System.arraycopy(datas1, this._$3, resultDatas1, 1, size);
            System.arraycopy(datas2, this._$3, resultDatas2, 1, size);
            for (int i = 1; i <= size; ++i) {
                if (!signArray.isFalse(i)) continue;
                resultDatas1[i] = value1;
                resultDatas2[i] = value2;
            }
            SerialBytesArray result = new SerialBytesArray(resultDatas1, resultDatas2, size);
            result.setTemporary(true);
            return result;
        }
        Object[] resultDatas = new Object[size + 1];
        for (int i = 1; i <= size; ++i) {
            resultDatas[i] = signArray.isFalse(i) ? value : this.get(i);
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public long[] getDatas1() {
        int len = this._$2 + 1;
        long[] newDatas1 = new long[len];
        System.arraycopy(this._$5, this._$3, newDatas1, 0, len);
        return newDatas1;
    }

    public long[] getDatas2() {
        int len = this._$2 + 1;
        long[] newDatas2 = new long[len];
        System.arraycopy(this._$4, this._$3, newDatas2, 0, len);
        return newDatas2;
    }

    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos((IArray)this.dup(), (IArray)array, (String)opt);
    }

    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    public long getData1(int index) {
        return this._$5[index + this._$1];
    }

    public long getData2(int index) {
        return this._$4[index + this._$1];
    }
}

