/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.column.reader;

import com.scudata.array.IArray;
import com.scudata.common.RQException;
import com.scudata.dm.ObjectReader;
import com.scudata.dw.BlockLink;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BufferReader;
import com.scudata.dw.ColumnMetaData;
import com.scudata.pdm.BlockLinkReader2;
import com.scudata.pdm.DataBlockReader;
import com.scudata.pdm.column.reader.IColumnMetaDataReader;
import com.scudata.pdm.column.reader.RowCountReader;
import java.io.IOException;
import java.io.InputStream;

public class ColumnMetaDataReader
implements IColumnMetaDataReader {
    protected ColumnMetaData column;
    protected ObjectReader segmentReader;
    protected BlockLinkReader2 colReader;
    protected long curBlockPos;
    private Object _$4;
    private Object _$3;
    private Object _$2;
    protected RowCountReader rowCountReader;
    private boolean _$1;

    public ColumnMetaDataReader(RowCountReader rowCountReader) {
        this.rowCountReader = rowCountReader;
    }

    public ColumnMetaDataReader(ColumnMetaData column, RowCountReader rowCountReader) {
        this.column = column;
        this.rowCountReader = rowCountReader;
        this.colReader = ColumnMetaDataReader.getColReader(column);
        this.segmentReader = column.getSegmentReader();
    }

    public static BlockLinkReader2 getColReader(ColumnMetaData col) {
        BlockLink dataBlockLink = col.getDataBlockLink();
        int serialBytesLen = col.getSerialBytesLen();
        BlockLinkReader2 reader = new BlockLinkReader2(dataBlockLink, serialBytesLen);
        reader.setDecompressBufferSize(4096);
        reader.setDict(col.getDict());
        try {
            reader.loadFirstBlock();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        return reader;
    }

    public BlockLinkReader2 getColReader() {
        return ColumnMetaDataReader.getColReader(this.column);
    }

    public int readBlockRowCount(int blockNum) throws IOException {
        return this.rowCountReader.readBlockRowCount(blockNum);
    }

    public void readSegmentInfoAndSeek() throws IOException {
        long pos = this.segmentReader.readLong40();
        this._$3 = this.segmentReader.readObject();
        this._$4 = this.segmentReader.readObject();
        this.segmentReader.skipObject();
        this.colReader.seek(pos);
    }

    public void readSegmentInfo() throws IOException {
        this.curBlockPos = this.segmentReader.readLong40();
        this._$3 = this.segmentReader.readObject();
        this._$4 = this.segmentReader.readObject();
        this.segmentReader.skipObject();
    }

    public void skipSegmentInfo() throws IOException {
        this.curBlockPos = this.segmentReader.readLong40();
        this.segmentReader.skipObject();
        this.segmentReader.skipObject();
        this.segmentReader.skipObject();
    }

    public Object getCurBlockMaxValue() {
        return this._$4;
    }

    public Object getCurBlockMinValue() {
        return this._$3;
    }

    public Object getCurBlockStartValue() {
        return this._$2;
    }

    public IArray readNextArray() throws IOException {
        BufferReader bufReader = this.colReader.readBlockData2();
        return DataBlockReader.readArray(bufReader, this.column, this.rowCountReader.getCurBlockRowCount());
    }

    public IArray readArray() throws IOException {
        BufferReader bufReader = this.colReader.readBlockData2(this.curBlockPos);
        return DataBlockReader.readArray(bufReader, this.column, this.rowCountReader.getCurBlockRowCount(), this._$1);
    }

    public IArray readArray(IArray match) throws IOException {
        BufferReader bufReader = this.colReader.readBlockData2(this.curBlockPos);
        return DataBlockReader.readArray(bufReader, this.column, match, this.rowCountReader.getCurBlockRowCount());
    }

    public IArray readSkipArray(IArray match, int matchCount) throws IOException {
        BufferReader bufReader = this.colReader.readBlockData2(this.curBlockPos);
        return DataBlockReader.readSkipArray(bufReader, this.column, match, this.rowCountReader.getCurBlockRowCount(), matchCount);
    }

    public String getColumnName() {
        return this.column.getColName();
    }

    public void close() {
        try {
            this.colReader.close();
            this.segmentReader.close();
            if (this.rowCountReader != null) {
                this.rowCountReader.close();
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.segmentReader = null;
            this.colReader = null;
            this.rowCountReader = null;
        }
    }

    public void setColumnName(String columnName) {
    }

    public void setTemporary(boolean b) {
        this._$1 = b;
    }

    public ObjectReader getSegmentReader() {
        return this.segmentReader;
    }

    public RowCountReader getRowCountReader() {
        return this.rowCountReader;
    }

    public ColumnMetaData getColumn() {
        return this.column;
    }

    public RowCountReader getNewRowCountReaderInstance() {
        return new RowCountReader(this.rowCountReader);
    }

    public ObjectReader getNewSegmentReaderInstance() {
        ObjectReader segmentReader = new ObjectReader(this.segmentReader);
        BlockLinkReader reader = (BlockLinkReader)segmentReader.getInputStream();
        segmentReader.setInputStream((InputStream)new BlockLinkReader(reader));
        return segmentReader;
    }

    public IArray[] readArrayAndDict() throws IOException {
        BufferReader bufReader = this.colReader.readBlockData2(this.curBlockPos);
        return DataBlockReader.readArrayAndDict(bufReader, this.column, this.rowCountReader.getCurBlockRowCount(), this._$1);
    }
}

