/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.cursor;

import com.scudata.array.BoolArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.DBSession;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.SQLTool;
import com.scudata.common.Sentence;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DBObject;
import com.scudata.dm.DataStruct;
import com.scudata.dm.IResource;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dw.PhyTable;
import com.scudata.pdm.DatabaseUtil;
import com.scudata.pdm.IPureCursor;
import com.scudata.resources.DataSetMessage;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class DBCursor
extends IPureCursor {
    private String _$19;
    private Object[] _$18;
    private byte[] _$17;
    private DBObject _$16;
    private ResultSet _$15 = null;
    private PreparedStatement _$14 = null;
    private Connection _$13 = null;
    private ResultSetMetaData _$12;
    private int[] _$11;
    private String _$10 = null;
    private String _$9 = null;
    private boolean _$8 = false;
    private boolean _$7 = true;
    private int _$6 = 0;
    private boolean _$5 = true;
    private boolean _$4 = false;
    private boolean _$3;
    private boolean _$2;
    private String _$1;

    public DBCursor(String sql, Object[] params, byte[] types, DBObject db, String opt, Context ctx) {
        this._$19 = sql;
        this._$18 = params;
        this._$17 = types;
        this._$16 = db;
        this.ctx = ctx;
        this._$1 = db.isLower() ? (opt == null ? "l" : opt + "l") : opt;
        this._$1(sql, params, types, db.getDbSession(), opt);
        if (ctx != null) {
            ctx.addResource((IResource)this);
        }
    }

    protected long skipOver(long n) {
        if (this._$15 == null || n == 0L) {
            return 0L;
        }
        long count = n;
        try {
            while (n > 0L && (this._$4 || !this._$15.isLast()) && this._$15.next()) {
                --n;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (n > 0L) {
            return count - n;
        }
        return count;
    }

    public synchronized void close() {
        super.close();
        if (this._$16 != null) {
            try {
                if (this.ctx != null) {
                    this.ctx.removeResource((IResource)this);
                }
                if (this._$15 != null) {
                    this._$15.close();
                }
                if (this._$14 != null) {
                    this._$14.close();
                }
                if (this._$1 != null && this._$1.indexOf(120) != -1 && this._$16.canClose()) {
                    this._$16.close();
                    this._$16 = null;
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
            finally {
                this._$15 = null;
                this._$14 = null;
                this._$13 = null;
                this._$12 = null;
                this.dataStruct = null;
            }
        }
    }

    protected Sequence get(int n) {
        if (this._$15 == null || n < 1) {
            return null;
        }
        Table table = null;
        int length = n;
        if (n > INITSIZE) {
            length = INITSIZE;
        }
        try {
            int colCount = this._$12.getColumnCount();
            if (this._$2) {
                IArray[] cas = new IArray[colCount];
                int[] setmodes = new int[colCount];
                int count = 0;
                while (this._$15.next()) {
                    ++count;
                    for (int c = 1; c <= colCount; ++c) {
                        Object ca = cas[c - 1];
                        int setmode = setmodes[c - 1];
                        if (setmode > 0) {
                            if (setmode == 1) {
                                int v = this._$15.getInt(c);
                                ((IntArray)ca).addInt(v);
                                continue;
                            }
                            if (setmode == 6) {
                                double v = this._$15.getDouble(c);
                                ((DoubleArray)ca).addDouble(v);
                                continue;
                            }
                            if (setmode == 2) {
                                long v = this._$15.getLong(c);
                                ((com.scudata.dm.LongArray)ca).add(v);
                                continue;
                            }
                            if (setmode != 12) continue;
                            boolean v = this._$15.getBoolean(c);
                            ((BoolArray)ca).addBool(v);
                            continue;
                        }
                        try {
                            Object v = DatabaseUtil.tranData(this._$11[c - 1], this._$6, this._$15, c, this._$7, this._$10, this._$9, this._$5, this._$1);
                            if (ca == null && v != null) {
                                if (v != null) {
                                    if (v instanceof Integer) {
                                        ca = new IntArray(length);
                                        setmodes[c - 1] = 1;
                                    } else if (v instanceof Long) {
                                        ca = new LongArray(length);
                                        setmodes[c - 1] = 2;
                                    } else if (v instanceof Boolean) {
                                        ca = new BoolArray(length);
                                        setmodes[c - 1] = 12;
                                    } else if (v instanceof Double) {
                                        ca = new DoubleArray(length);
                                        setmodes[c - 1] = 6;
                                    } else {
                                        ca = v instanceof Date ? new DateArray(length) : (v instanceof String ? new StringArray(length) : new ObjectArray(length));
                                    }
                                }
                                if (ca != null) {
                                    for (int i = 1; i < count; ++i) {
                                        ca.add(null);
                                    }
                                }
                            }
                            if (ca == null) continue;
                            ca.add(v);
                            cas[c - 1] = ca;
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (count < n) continue;
                }
                table = DatabaseUtil.getPureTable(this.dataStruct, cas, table);
            } else {
                table = new Table(this.dataStruct, length);
                while (!(n <= 0 || !this._$4 && this._$15.isLast() || !this._$15.next() || !this._$4 && this._$15.isAfterLast())) {
                    --n;
                    this._$1(table, colCount);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (table.length() > 0) {
            if (this._$3) {
                return table.fieldValues(0);
            }
            return table;
        }
        return null;
    }

    private void _$1(String sql, Object[] params, byte[] types, DBSession dbs, String opt) {
        try {
            int pos;
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                this._$13 = (Connection)session;
            }
            if (this._$13 == null || this._$13.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", (Object)name));
            }
            if (dsConfig != null) {
                this._$10 = dsConfig.getDBCharset();
                this._$8 = dsConfig.getNeedTranSentence();
                this._$7 = dsConfig.getNeedTranContent();
                if ((this._$7 || this._$8) && this._$10 == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", (Object)name));
                }
                this._$9 = dsConfig.getClientCharset();
                if ((this._$7 || this._$8) && this._$9 == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", (Object)name));
                }
                this._$6 = dsConfig.getDBType();
            } else {
                this._$7 = false;
            }
            if (this._$8) {
                sql = new String(sql.getBytes(), this._$10);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                pos = 0;
                for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
                    pos = Sentence.indexOf((String)sql, (String)"?", (int)(pos + 1), (int)18);
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] == null) continue;
                    if (args[paramIndex] instanceof Sequence && this._$7) {
                        Sequence l = (Sequence)args[paramIndex];
                        int size = l.length();
                        for (int i = 1; i <= size; ++i) {
                            Object o = l.get(i);
                            if (!(o instanceof String) || !this._$8) continue;
                            o = new String(((String)o).getBytes(), this._$10);
                            l.set(i, o);
                        }
                    } else if (args[paramIndex] instanceof String && this._$8) {
                        args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), this._$10);
                    }
                    if (!(args[paramIndex] instanceof Sequence)) continue;
                    Object[] objs = ((Sequence)args[paramIndex]).toArray();
                    int objCount = objs.length;
                    StringBuffer sb = new StringBuffer(2 * objCount);
                    for (int iObj = 0; iObj < objCount; ++iObj) {
                        sb.append("?,");
                    }
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    if (sb.length() > 1) {
                        sql = sql.substring(0, pos) + sb.toString() + sql.substring(pos + 1);
                    }
                    pos += sb.length();
                }
            }
            try {
                DBInfo info;
                int rsType = 1003;
                if (opt != null && opt.indexOf("z") > -1) {
                    rsType = 1004;
                }
                if (rsType == 1003) {
                    this._$4 = true;
                }
                if (this._$13.getClass().getName().equals("com.microsoft.sqlserver.jdbc.SQLServerConnection")) {
                    Class<?> clss = Class.forName("com.microsoft.sqlserver.jdbc.SQLServerResultSet");
                    Field fld = clss.getField("TYPE_SS_SERVER_CURSOR_FORWARD_ONLY");
                    if (opt != null && opt.indexOf("z") > -1) {
                        fld = clss.getField("TYPE_SS_SCROLL_KEYSET");
                    }
                    rsType = fld.getInt(null);
                }
                if ((info = dbs.getInfo()) != null && info.getDBType() == 15) {
                    Logger.info((Object)"Setting POSTGRESQL...");
                    this._$13.setAutoCommit(false);
                    this._$14 = this._$13.prepareStatement(sql, rsType, 1003);
                    this._$14.setFetchSize(1000);
                } else if (info != null && info.getDBType() == 20) {
                    Logger.info((Object)"Setting DBONE...");
                    this._$13.setAutoCommit(false);
                    this._$14 = this._$13.prepareStatement(sql, rsType, 1003);
                    this._$14.setFetchSize(1000);
                } else if (info != null && info.getDBType() == 2) {
                    this._$13.setAutoCommit(false);
                    this._$14 = this._$13.prepareStatement(sql, rsType, 1007);
                    this._$14.setFetchSize(1000);
                } else if (info != null && info.getDBType() == 10) {
                    this._$13.setAutoCommit(false);
                    this._$14 = this._$13.prepareStatement(sql);
                    this._$14.setFetchSize(1000);
                } else {
                    this._$14 = this._$13.prepareStatement(sql, rsType, 1007);
                }
            }
            catch (SQLException e) {
                Logger.debug((Object)e.getMessage());
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", (Object)name2, (Object)sql), (Throwable)e);
            }
            if (args != null && args.length > 0) {
                pos = 0;
                for (int iArg = 0; iArg < args.length; ++iArg) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        if (args[iArg] != null && args[iArg] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[iArg]).toArray();
                            for (int iObj = 0; iObj < objs.length; ++iObj) {
                                SQLTool.setObject((int)this._$6, (PreparedStatement)this._$14, (int)pos, (Object)objs[iObj], (int)type);
                                ++pos;
                            }
                            --pos;
                            continue;
                        }
                        SQLTool.setObject((int)this._$6, (PreparedStatement)this._$14, (int)pos, (Object)args[iArg], (int)type);
                        continue;
                    }
                    catch (Exception e) {
                        String name3 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name3 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", (Object)name3, (Object)Integer.toString(iArg + 1)));
                    }
                }
            }
            try {
                this._$15 = this._$14.executeQuery();
            }
            catch (SQLException e) {
                Logger.debug((Object)e.getMessage());
                String name4 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name4 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", (Object)name4, (Object)sql));
            }
            DataStruct ds = this._$1(this._$15, this._$16.isLower());
            if (opt != null && opt.indexOf("t") > -1) {
                int i;
                String[] fields = null;
                int colCount = this._$12.getColumnCount();
                String tableName = this._$12.getTableName(1);
                if (sql.indexOf(" as ") < 0) {
                    fields = new String[colCount];
                    String[][] tableCols = new String[colCount][];
                    for (int c = 1; c <= colCount; ++c) {
                        fields[c - 1] = this._$12.getColumnLabel(c);
                        String[] tCol = new String[]{this._$12.getColumnLabel(c)};
                        tableCols[c - 1] = tCol;
                    }
                } else {
                    String selCols = sql.substring(sql.indexOf("select") + 6, sql.indexOf("from")).trim();
                    String[] cols = selCols.split(",");
                    if (cols != null && cols.length > 0) {
                        int length = cols.length;
                        String[][] tableCols = new String[length][];
                        fields = new String[length];
                        for (i = 0; i < length; ++i) {
                            String col = cols[i];
                            if (col.indexOf(" as ") < 0) {
                                fields[i] = col;
                                String[] tCol = new String[]{col};
                                tableCols[i] = tCol;
                                continue;
                            }
                            String[] sets = col.split(" ");
                            fields[i] = sets[sets.length - 1];
                            String[] tCol = new String[]{sets[0]};
                            tableCols[i] = tCol;
                        }
                    }
                }
                if (opt != null && opt.indexOf("u") > -1) {
                    DatabaseMetaData dmd = this._$13.getMetaData();
                    this._$15 = dmd.getPrimaryKeys(this._$13.getCatalog(), null, tableName);
                    int count = 0;
                    ArrayList<String> nameList = new ArrayList<String>();
                    while (this._$15.next()) {
                        String keyName = this._$15.getString("COLUMN_NAME");
                        if (keyName == null || keyName.trim().length() <= 0) continue;
                        nameList.add(keyName);
                        ++count;
                    }
                    if (count > 0) {
                        String[] pks = new String[count];
                        for (i = 0; i < count; ++i) {
                            pks[i] = (String)nameList.get(i);
                        }
                        ds.setPrimary(pks);
                    }
                }
            }
            if (opt != null) {
                if (opt.indexOf(118) > -1) {
                    this._$2 = true;
                }
                if (opt.indexOf(105) != -1 && ds.getFieldCount() == 1) {
                    this._$3 = true;
                }
            }
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    private DataStruct _$1(ResultSet rs, boolean lowercase) throws SQLException, UnsupportedEncodingException {
        if (rs == null) {
            return null;
        }
        this._$12 = rs.getMetaData();
        int colCount = this._$12.getColumnCount();
        this._$11 = new int[colCount];
        String[] colNames = new String[colCount];
        for (int c = 1; c <= colCount; ++c) {
            colNames[c - 1] = lowercase ? this._$12.getColumnLabel(c).toLowerCase() : this._$12.getColumnLabel(c);
            this._$11[c - 1] = this._$12.getColumnType(c);
        }
        if (this._$7 && (this._$9 == null || this._$9.trim().length() == 0)) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.toCharset"));
        }
        if (this._$9 != null) {
            this._$5 = this._$9.equalsIgnoreCase(this._$10) || this._$10 == null;
        }
        DataStruct ds = new DataStruct(colNames);
        this.setDataStruct(ds);
        return ds;
    }

    private void _$1(Table table, int colCount) throws SQLException, UnsupportedEncodingException {
        BaseRecord record = table.newLast();
        for (int n = 1; n <= colCount; ++n) {
            try {
                Object obj = DatabaseUtil.tranData(this._$11[n - 1], this._$6, this._$15, n, this._$7, this._$10, this._$9, this._$5, this._$1);
                record.set(n - 1, obj);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean reset() {
        this.close();
        if (this._$16 != null) {
            this._$1(this._$19, this._$18, this._$17, this._$16.getDbSession(), this._$1);
            if (this.ctx != null) {
                this.ctx.addResource((IResource)this);
            }
            return true;
        }
        return false;
    }

    public void setAppendData(Sequence seq) {
        throw new RQException("setAppendData(seq) is not supported yet");
    }

    public void setSegment(int startBlock, int endBlock) {
        throw new RQException("setSegment(startBlock, endBlock) is not supported yet");
    }

    public PhyTable getTableMetaData() {
        throw new RQException("getTableMetaData() is not supported yet");
    }

    protected Sequence getStartBlockData(int n) {
        throw new RQException("getStartBlockData(n) is not supported yet");
    }

    public void setCache(Sequence cache) {
        throw new RQException("setCache(cache) is not supported yet");
    }

    public int getStartBlock() {
        throw new RQException("getStartBlock() is not supported yet");
    }

    public int getEndBlock() {
        throw new RQException("getEndBlock() is not supported yet");
    }

    public void setEndBlock(int endBlock) {
        throw new RQException("setEndBlock(endBlock) is not supported yet");
    }
}

