/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.op;

import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.IComputeItem;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.Expression;
import com.scudata.expression.Gather;

class PrimaryJoinItem {
    private Context ctx;
    private ICursor cursor;
    private Expression[] keyExps;
    private Expression[] newExps;
    private int joinType;
    private IArray[] keyArrays;
    private IArray[] newArrays;
    private IArray[] cacheKeyArrays;
    private IArray[] cacheNewArrays;
    private int keyCount = 0;
    private int newCount = 0;
    private int seq;
    private boolean isMatch = false;

    public PrimaryJoinItem(ICursor cursor, Expression[] keyExps, Expression[] newExps, int joinType, Context ctx) {
        this.ctx = new Context(ctx);
        this.cursor = cursor;
        this.keyExps = keyExps;
        this.newExps = newExps;
        this.joinType = joinType;
        this.keyCount = keyExps.length;
        this.keyArrays = new IArray[this.keyCount];
        if (newExps != null) {
            this.newCount = newExps.length;
            this.newArrays = new IArray[this.newCount];
            Expression[] expressionArray = newExps;
            int n = newExps.length;
            int n2 = 0;
            while (n2 < n) {
                Expression exp = expressionArray[n2];
                if (exp.getHome() instanceof Gather) {
                    cursor.group(null, keyExps, null, newExps, null, "s", ctx);
                    int q = 1;
                    Expression[] exps = new Expression[this.keyCount];
                    int i = 0;
                    while (i < this.keyCount) {
                        exps[i] = new Expression("#" + q);
                        ++i;
                        ++q;
                    }
                    this.keyExps = exps;
                    exps = new Expression[this.newCount];
                    i = 0;
                    while (i < this.newCount) {
                        exps[i] = new Expression("#" + q);
                        ++i;
                        ++q;
                    }
                    this.newExps = exps;
                    break;
                }
                ++n2;
            }
        }
    }

    public void cacheData() {
        if (this.cacheKeyArrays != null) {
            System.arraycopy(this.cacheKeyArrays, 0, this.keyArrays, 0, this.keyCount);
            if (this.newCount > 0) {
                System.arraycopy(this.cacheNewArrays, 0, this.newArrays, 0, this.newCount);
                this.cacheNewArrays = null;
            }
            this.seq = 1;
            this.cacheKeyArrays = null;
            return;
        }
        Sequence data = this.cursor.fuzzyFetch(ICursor.FETCHCOUNT);
        if (data != null && data.length() > 0) {
            ComputeStack stack = this.ctx.getComputeStack();
            Current current = new Current(data);
            try {
                stack.push((IComputeItem)current);
                this.seq = 1;
                int i = 0;
                while (i < this.keyCount) {
                    this.keyArrays[i] = this.keyExps[i].calculateAll(this.ctx);
                    ++i;
                }
                i = 0;
                while (i < this.newCount) {
                    this.newArrays[i] = this.newExps[i].calculateAll(this.ctx);
                    ++i;
                }
            }
            finally {
                stack.pop();
            }
        } else {
            this.seq = -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean filterJoin(IArray[] srcKeyArrays, int index) {
        joinType = this.joinType;
        if (this.seq == -1) {
            return joinType != 0;
        }
        keyArrays = this.keyArrays;
        keyCount = this.keyCount;
        cmp = 0;
        block0: while (true) {
            f = 0;
            while (f < keyCount) {
                cmp = srcKeyArrays[f].compareTo(index, keyArrays[f], this.seq);
                if (cmp > 0) {
                    ++this.seq;
                    if (this.seq <= keyArrays[0].size()) continue block0;
                    this.cacheData();
                    if (this.seq == -1) ** break;
                    continue block0;
                    this.isMatch = false;
                    return joinType != 0;
                }
                if (cmp < 0) {
                    this.isMatch = false;
                    return joinType != 0;
                }
                ++f;
            }
            break;
        }
        this.isMatch = true;
        return joinType != 2;
    }

    /*
     * Unable to fully structure code
     */
    public boolean timeKeyJoin(IArray[] srcKeyArrays, int index) {
        block18: {
            joinType = this.joinType;
            if (this.seq == -1) {
                return joinType != 0;
            }
            keyArrays = this.keyArrays;
            keyCount = this.keyCount;
            timeIndex = keyCount - 1;
            cmp = 0;
            block0: while (true) {
                f = 0;
                while (f < timeIndex) {
                    cmp = srcKeyArrays[f].compareTo(index, keyArrays[f], this.seq);
                    if (cmp > 0) {
                        ++this.seq;
                        if (this.seq <= keyArrays[0].size()) continue block0;
                        this.cacheData();
                        if (this.seq == -1) ** break;
                        continue block0;
                        this.isMatch = false;
                        return joinType != 0;
                    }
                    if (cmp < 0) {
                        this.isMatch = false;
                        return joinType != 0;
                    }
                    ++f;
                }
                break;
            }
            cmp = srcKeyArrays[timeIndex].compareTo(index, keyArrays[timeIndex], this.seq);
            if (cmp < 0) {
                this.isMatch = false;
                return joinType != 0;
            }
            if (cmp == 0) {
                this.isMatch = true;
                return joinType != 2;
            }
            do {
                prevSeq = this.seq;
                len = keyArrays[0].size();
                q = prevSeq + 1;
                while (q <= len) {
                    i = 0;
                    while (i < timeIndex) {
                        if (!keyArrays[i].isMemberEquals(prevSeq, q)) {
                            this.seq = q - 1;
                            break block18;
                        }
                        ++i;
                    }
                    cmp = srcKeyArrays[timeIndex].compareTo(index, keyArrays[timeIndex], q);
                    if (cmp < 0) {
                        this.seq = q - 1;
                        break block18;
                    }
                    if (cmp == 0) {
                        this.seq = q;
                        break block18;
                    }
                    ++q;
                }
                prevSeq = len;
                prevKeyArrays = new IArray[keyCount];
                prevNewArrays = null;
                System.arraycopy(keyArrays, 0, prevKeyArrays, 0, keyCount);
                if (this.newCount > 0) {
                    prevNewArrays = new IArray[this.newCount];
                    System.arraycopy(this.newArrays, 0, prevNewArrays, 0, this.newCount);
                }
                this.cacheData();
                if (this.seq == -1) {
                    this.seq = prevSeq;
                    System.arraycopy(prevKeyArrays, 0, keyArrays, 0, keyCount);
                    if (this.newCount > 0) {
                        System.arraycopy(prevNewArrays, 0, this.newArrays, 0, this.newCount);
                    }
                } else {
                    f = 0;
                    while (f < keyCount) {
                        cmp = srcKeyArrays[f].compareTo(index, keyArrays[f], this.seq);
                        if (cmp != 0) break;
                        ++f;
                    }
                    if (cmp >= 0) continue;
                    this.cacheKeyArrays = keyArrays;
                    this.cacheNewArrays = this.newArrays;
                    this.keyArrays = prevKeyArrays;
                    this.newArrays = prevNewArrays;
                    this.seq = prevSeq;
                }
                break block18;
            } while (cmp != 0);
            this.isMatch = true;
            return joinType != 2;
        }
        this.isMatch = true;
        return joinType != 2;
    }

    public void getNewValues(IArray[] resultArrays, int fieldIndex, int capacity) {
        block6: {
            if (this.newCount <= 0) break block6;
            if (this.isMatch) {
                IArray[] iArrayArray = this.newArrays;
                int n = this.newArrays.length;
                int n2 = 0;
                while (n2 < n) {
                    IArray array = iArrayArray[n2];
                    if (resultArrays[fieldIndex] == null) {
                        resultArrays[fieldIndex] = array.newInstance(capacity);
                    }
                    resultArrays[fieldIndex++].push(array, this.seq);
                    ++n2;
                }
            } else {
                IArray[] iArrayArray = this.newArrays;
                int n = this.newArrays.length;
                int n3 = 0;
                while (n3 < n) {
                    IArray array = iArrayArray[n3];
                    if (resultArrays[fieldIndex] == null) {
                        resultArrays[fieldIndex] = array.newInstance(capacity);
                    }
                    resultArrays[fieldIndex++].pushNull();
                    ++n3;
                }
            }
        }
    }

    public boolean hasNext() {
        return this.seq > 0;
    }

    public void next() {
        ++this.seq;
        this.isMatch = false;
        if (this.seq > this.keyArrays[0].size()) {
            this.cacheData();
        }
    }

    public void match(IArray[] resultArrays, int fieldIndex, int capacity) {
        this.isMatch = true;
        if (this.newCount > 0) {
            IArray[] iArrayArray = this.newArrays;
            int n = this.newArrays.length;
            int n2 = 0;
            while (n2 < n) {
                IArray array = iArrayArray[n2];
                if (resultArrays[fieldIndex] == null) {
                    resultArrays[fieldIndex] = array.newInstance(capacity);
                }
                resultArrays[fieldIndex++].add(array, this.seq);
                ++n2;
            }
        }
    }

    public void unmatch(IArray[] resultArrays, int fieldIndex, int capacity) {
        block6: {
            if (this.newCount <= 0) break block6;
            if (this.newArrays != null) {
                IArray[] iArrayArray = this.newArrays;
                int n = this.newArrays.length;
                int n2 = 0;
                while (n2 < n) {
                    IArray array = iArrayArray[n2];
                    if (resultArrays[fieldIndex] == null) {
                        resultArrays[fieldIndex] = array.newInstance(capacity);
                    }
                    resultArrays[fieldIndex++].add(null);
                    ++n2;
                }
            } else {
                int i = 0;
                while (i < this.newCount) {
                    if (resultArrays[fieldIndex] == null) {
                        resultArrays[fieldIndex] = new ObjectArray(capacity);
                    }
                    resultArrays[fieldIndex++].add(null);
                    ++i;
                }
            }
        }
    }

    public boolean isMatch() {
        return this.isMatch;
    }

    public void getKeyValue(int keySeq, IArray outArray) {
        outArray.add(this.keyArrays[keySeq], this.seq);
    }

    public IArray getKeyValue(int keySeq) {
        IArray result = this.keyArrays[keySeq].newInstance(ICursor.FETCHCOUNT);
        result.push(this.keyArrays[keySeq], this.seq);
        return result;
    }

    public int compare(IArray[] srcKeyArrays, int index) {
        return this.compare(this.keyArrays, this.seq, srcKeyArrays, index, this.keyCount);
    }

    public int compare(PrimaryJoinItem item) {
        return this.compare(this.keyArrays, this.seq, item.keyArrays, item.seq, this.keyCount);
    }

    private int compare(IArray[] arrays1, int index1, IArray[] arrays2, int index2, int count) {
        int f = 0;
        while (f < count) {
            int cmp = arrays1[f].compareTo(index1, arrays2[f], index2);
            if (cmp != 0) {
                return cmp;
            }
            ++f;
        }
        return 0;
    }
}

