/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pseudo;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.DBSession;
import com.scudata.common.Escape;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.Context;
import com.scudata.dm.DBObject;
import com.scudata.dm.KeyWord;
import com.scudata.dm.Param;
import com.scudata.expression.ArgNode;
import com.scudata.expression.ArgParam;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Calc;
import com.scudata.expression.ConstParam;
import com.scudata.expression.Constant;
import com.scudata.expression.CreateRecord;
import com.scudata.expression.CurrentCell;
import com.scudata.expression.CurrentCellSeq;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.CurrentElementId;
import com.scudata.expression.CurrentSeq;
import com.scudata.expression.DfxFunction;
import com.scudata.expression.ElementRef;
import com.scudata.expression.FieldFuzzyRef;
import com.scudata.expression.FieldId;
import com.scudata.expression.FieldRef;
import com.scudata.expression.ForCellCurSeq;
import com.scudata.expression.Function;
import com.scudata.expression.FunctionLib;
import com.scudata.expression.FuzzyFieldRef;
import com.scudata.expression.IParam;
import com.scudata.expression.IterateParam;
import com.scudata.expression.MemberFunction;
import com.scudata.expression.Move;
import com.scudata.expression.Moves;
import com.scudata.expression.Node;
import com.scudata.expression.Operator;
import com.scudata.expression.SubVal;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.ValueList;
import com.scudata.expression.VarParam;
import com.scudata.expression.fn.PCSFunction;
import com.scudata.expression.operator.Add;
import com.scudata.expression.operator.AddAssign;
import com.scudata.expression.operator.And;
import com.scudata.expression.operator.Assign;
import com.scudata.expression.operator.Comma;
import com.scudata.expression.operator.Conj;
import com.scudata.expression.operator.ConjAssign;
import com.scudata.expression.operator.Diff;
import com.scudata.expression.operator.Divide;
import com.scudata.expression.operator.DivideAssign;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.ISect;
import com.scudata.expression.operator.ISectAssign;
import com.scudata.expression.operator.IntDivideAssign;
import com.scudata.expression.operator.MemAdd;
import com.scudata.expression.operator.MemDivide;
import com.scudata.expression.operator.MemIntDivide;
import com.scudata.expression.operator.MemMod;
import com.scudata.expression.operator.MemMultiply;
import com.scudata.expression.operator.MemSubtract;
import com.scudata.expression.operator.Mod;
import com.scudata.expression.operator.ModAssign;
import com.scudata.expression.operator.Multiply;
import com.scudata.expression.operator.MultiplyAssign;
import com.scudata.expression.operator.Negative;
import com.scudata.expression.operator.Not;
import com.scudata.expression.operator.NotEquals;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Or;
import com.scudata.expression.operator.Plus;
import com.scudata.expression.operator.Smaller;
import com.scudata.expression.operator.Subtract;
import com.scudata.expression.operator.SubtractAssign;
import com.scudata.expression.operator.Union;
import com.scudata.expression.operator.UnionAssign;
import com.scudata.pseudo.LocationInfo;
import com.scudata.pseudo.ParamParser;
import com.scudata.resources.EngineMessage;
import com.scudata.util.EnvUtil;
import com.scudata.util.Variant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ExpStrProcessor {
    private String expStr;
    private int location;
    private int locationOffset = 0;
    private Node home;
    private ICellSet cs;
    private Map<Node, LocationInfo> nodeIntMap = new HashMap<Node, LocationInfo>();

    public ExpStrProcessor(String expStr) {
        this.expStr = expStr;
    }

    public ExpStrProcessor(String expStr, int locationOffset) {
        this.expStr = expStr;
        this.locationOffset = locationOffset;
    }

    public void parse(Context ctx) {
        int len = this.expStr.length();
        int inBrackets = 0;
        Comma preNode = null;
        block23: while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c)) {
                ++this.location;
                continue;
            }
            Object node = null;
            int location_bak = this.location++;
            switch (c) {
                case '(': {
                    if (preNode != null && !(preNode instanceof Operator)) {
                        node = new ElementRef();
                        ((Function)node).setParameter(this.cs, ctx, this.scanParameter());
                        break;
                    }
                    if (preNode instanceof DotOperator) {
                        node = new Calc();
                        ((Function)node).setParameter(this.cs, ctx, this.scanParameter());
                        break;
                    }
                    ++inBrackets;
                    ++this.location;
                    continue block23;
                }
                case ')': {
                    if (--inBrackets >= 0) continue block23;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
                }
                case '+': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '+') {
                        node = new MemAdd();
                        ++this.location;
                        break;
                    }
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new AddAssign();
                        ++this.location;
                        break;
                    }
                    if (preNode != null && !(preNode instanceof Operator)) {
                        node = new Add();
                        break;
                    }
                    node = new Plus();
                    break;
                }
                case '-': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '-') {
                        node = new MemSubtract();
                        ++this.location;
                        break;
                    }
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new SubtractAssign();
                        ++this.location;
                        break;
                    }
                    if (preNode != null && !(preNode instanceof Operator)) {
                        node = new Subtract();
                        break;
                    }
                    node = new Negative();
                    break;
                }
                case '*': {
                    if (preNode == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("\"*\"" + mm.getMessage("operator.missingLeftOperation"));
                    }
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '*') {
                        node = new MemMultiply();
                        ++this.location;
                        break;
                    }
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new MultiplyAssign();
                        ++this.location;
                        break;
                    }
                    node = new Multiply();
                    break;
                }
                case '/': {
                    MessageManager mm;
                    if (preNode == null) {
                        MessageManager mm2 = EngineMessage.get();
                        throw new RQException("\"*\"" + mm2.getMessage("operator.missingLeftOperation"));
                    }
                    ++this.location;
                    if (this.location < len) {
                        char nextChar = this.expStr.charAt(this.location);
                        if (nextChar == '/') {
                            node = new MemDivide();
                            ++this.location;
                            break;
                        }
                        if (nextChar == '=') {
                            node = new DivideAssign();
                            ++this.location;
                            break;
                        }
                        if (nextChar == '*') {
                            this.location = ExpStrProcessor.scanAnnotation(this.expStr, this.location);
                            if (this.location == -1) {
                                mm = EngineMessage.get();
                                throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + "/*");
                            }
                            ++this.location;
                            continue block23;
                        }
                        node = new Divide();
                        break;
                    }
                    node = new Divide();
                    break;
                }
                case '%': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '%') {
                        node = new MemMod();
                        ++this.location;
                        break;
                    }
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new ModAssign();
                        ++this.location;
                        break;
                    }
                    node = new Mod();
                    break;
                }
                case '=': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new Equals();
                        ++this.location;
                        break;
                    }
                    node = new Assign();
                    break;
                }
                case '!': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new NotEquals();
                        ++this.location;
                        break;
                    }
                    node = new Not();
                    break;
                }
                case '>': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new NotSmaller();
                        ++this.location;
                        break;
                    }
                    node = new Greater();
                    break;
                }
                case '<': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new NotGreater();
                        ++this.location;
                        break;
                    }
                    node = new Smaller();
                    break;
                }
                case '&': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '&') {
                        node = new And();
                        ++this.location;
                        break;
                    }
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new UnionAssign();
                        ++this.location;
                        break;
                    }
                    node = new Union();
                    break;
                }
                case '^': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new ISectAssign();
                        ++this.location;
                        break;
                    }
                    node = new ISect();
                    break;
                }
                case '|': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '|') {
                        node = new Or();
                        ++this.location;
                        break;
                    }
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new ConjAssign();
                        ++this.location;
                        break;
                    }
                    node = new Conj();
                    break;
                }
                case '\\': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '\\') {
                        node = new MemIntDivide();
                        ++this.location;
                        break;
                    }
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new IntDivideAssign();
                        ++this.location;
                        break;
                    }
                    node = new Diff();
                    break;
                }
                case ',': {
                    node = new Comma();
                    ++this.location;
                    break;
                }
                case '.': {
                    if (preNode == null || preNode instanceof Operator) {
                        ++this.location;
                        String id = String.valueOf('.') + this.scanId();
                        Object obj = Variant.parse((String)id);
                        if (obj instanceof String) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + id);
                        }
                        node = new Constant(obj);
                        break;
                    }
                    node = new DotOperator();
                    ++this.location;
                    break;
                }
                case '\"': {
                    MessageManager mm;
                    int dqmatch = Sentence.scanQuotation((String)this.expStr, (int)this.location);
                    if (dqmatch == -1) {
                        mm = EngineMessage.get();
                        throw new RQException("\"" + mm.getMessage("Expression.illMatched"));
                    }
                    String str = this.expStr.substring(this.location + 1, dqmatch);
                    this.location = dqmatch + 1;
                    node = new Constant((Object)Escape.remove((String)str));
                    break;
                }
                case '\'': {
                    int qmatch = Sentence.scanQuotation((String)this.expStr, (int)this.location);
                    if (qmatch == -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("'" + mm.getMessage("Expression.illMatched"));
                    }
                    String strID = this.expStr.substring(this.location + 1, qmatch);
                    this.location = qmatch + 1;
                    if (preNode instanceof DotOperator) {
                        node = new FieldRef(strID);
                        break;
                    }
                    node = new UnknownSymbol(strID);
                    break;
                }
                case '[': {
                    int match = Sentence.scanBracket((String)this.expStr, (int)this.location);
                    if (match == -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("[,]" + mm.getMessage("Expression.illMatched"));
                    }
                    node = preNode == null || preNode instanceof Operator ? new ValueList() : new Move();
                    ((Function)node).setParameter(this.cs, ctx, this.expStr.substring(this.location + 1, match));
                    this.location = match + 1;
                    break;
                }
                case '{': {
                    int match = Sentence.scanBrace((String)this.expStr, (int)this.location);
                    if (match == -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("{,}" + mm.getMessage("Expression.illMatched"));
                    }
                    node = preNode == null || preNode instanceof Operator ? new CreateRecord() : new Moves();
                    ((Function)node).setParameter(this.cs, ctx, this.expStr.substring(this.location + 1, match));
                    this.location = match + 1;
                    break;
                }
                default: {
                    node = this.createNode(this.cs, ctx, (Node)preNode);
                }
            }
            if (node != null) {
                this.saveNodeInfo((Node)node, location_bak, this.location - location_bak);
            }
            if (preNode instanceof Constant && node instanceof Constant && ((Constant)preNode).append((Constant)node)) continue;
            node.setInBrackets(inBrackets);
            preNode = node;
            if (this.home == null) {
                this.home = node;
                continue;
            }
            Node right = this.home;
            Node parent = null;
            while (right != null && right.getPriority() < node.getPriority()) {
                parent = right;
                right = right.getRight();
            }
            node.setLeft(right);
            if (parent != null) {
                parent.setRight((Node)node);
                continue;
            }
            this.home = node;
        }
        if (inBrackets > 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
        }
    }

    private Node createNode(ICellSet cs, Context ctx, Node preNode) {
        Object value;
        DBSession dbs;
        Param var;
        int index;
        int match;
        String id = this.scanId();
        int idLen = id.length();
        if (idLen < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(mm.getMessage("Expression.unknownExpression")) + this.expStr.charAt(this.location));
        }
        if (KeyWord.isCurrentElement((String)id)) {
            return new CurrentElement();
        }
        if (KeyWord.isIterateParam((String)id)) {
            return new IterateParam();
        }
        if (KeyWord.isCurrentSeq((String)id)) {
            return new CurrentSeq();
        }
        if (KeyWord.isFieldId((String)id)) {
            return new FieldId(id);
        }
        if (KeyWord.isCurrentCellSeq((String)id)) {
            return new CurrentCellSeq();
        }
        if (KeyWord.isElementId((String)id)) {
            return new CurrentElementId(id);
        }
        if (KeyWord.isArg((String)id)) {
            return new ArgNode(id);
        }
        if (preNode instanceof DotOperator) {
            return this.createMemberNode(cs, id, ctx);
        }
        if (id.startsWith("#")) {
            INormalCell cell;
            if (cs instanceof PgmCellSet && (cell = cs.getCell(id.substring(1))) != null) {
                return new ForCellCurSeq((PgmCellSet)cs, cell.getRow(), cell.getCol());
            }
            return new FieldFuzzyRef(id.substring(1));
        }
        if (id.equals("$") && this.isNextChar('[') && (match = Sentence.scanBracket((String)this.expStr, (int)(index = this.expStr.indexOf(91, this.location)))) != -1) {
            this.location = match + 1;
            return new Constant((Object)Escape.remove((String)this.expStr.substring(index + 1, match).trim()));
        }
        if (cs != null) {
            INormalCell cell = cs.getCell(id);
            if (cell != null) {
                return new CSVariable(cell);
            }
            if (KeyWord.isCurrentCell((String)id)) {
                return new CurrentCell(cs);
            }
            if (KeyWord.isSubCodeBlock((String)id) && cs instanceof PgmCellSet) {
                return new SubVal((PgmCellSet)cs);
            }
        }
        if ((var = EnvUtil.getParam((String)id, (Context)ctx)) != null) {
            Object val = var.getValue();
            if (val instanceof DBSession) {
                return new Constant((Object)new DBObject((DBSession)val));
            }
            byte kind = var.getKind();
            switch (kind) {
                case 0: {
                    return new VarParam(var);
                }
                case 1: {
                    return new ArgParam(var);
                }
            }
            return new ConstParam(id, var.getValue());
        }
        if (this.isNextChar('(')) {
            PgmCellSet.FuncInfo funcInfo;
            int atIdx = id.indexOf(64);
            String fnName = id;
            String fnOpt = null;
            if (atIdx != -1) {
                fnName = id.substring(0, atIdx);
                fnOpt = id.substring(atIdx + 1);
            }
            if (FunctionLib.isFnName((String)fnName)) {
                Function fn = FunctionLib.newFunction((String)fnName);
                fn.setOption(fnOpt);
                String str = this.scanParameter();
                fn.setParameter(cs, ctx, str);
                if (str != null) {
                    int loc = this.locationOffset + this.location - str.length() - 1;
                    ParamParser paramParser = new ParamParser();
                    IParam param = paramParser.parse(str, cs, ctx, loc);
                    fn.setParam(param);
                    this.nodeIntMap.putAll(paramParser.getNodeIntMap());
                }
                return fn;
            }
            DfxFunction dfx = Context.getDFXFunction((String)fnName, (Context)ctx);
            if (dfx != null) {
                String param = this.scanParameter();
                return dfx.newFunction(cs, ctx, fnOpt, param);
            }
            if (cs instanceof PgmCellSet && (funcInfo = ((PgmCellSet)cs).getFuncInfo(fnName)) != null) {
                PCSFunction fn = new PCSFunction(funcInfo);
                fn.setOption(fnOpt);
                fn.setParameter(cs, ctx, this.scanParameter());
                return fn;
            }
        }
        if (ctx != null && (dbs = ctx.getDBSession(id)) != null) {
            return new Constant((Object)new DBObject(dbs));
        }
        if (this.isNextChar('.') && this.isNumber(id)) {
            int prevPos = this.location++;
            if (this.isNextChar('(')) {
                this.location = prevPos;
            } else {
                Object obj = Variant.parse((String)(String.valueOf(id) + '.' + this.scanId()));
                if (obj instanceof String) {
                    this.location = prevPos;
                } else {
                    return new Constant(obj);
                }
            }
        }
        if ((value = Variant.parse((String)id)) instanceof String) {
            return new UnknownSymbol((String)value);
        }
        return new Constant(value);
    }

    private void saveNodeInfo(Node node, int location, int len) {
        this.nodeIntMap.put(node, new LocationInfo(this.locationOffset + location, len));
    }

    public LocationInfo getNodeInfo(Node node) {
        if (node instanceof DotOperator) {
            LocationInfo info = this.nodeIntMap.get(node);
            LocationInfo leftInfo = this.getNodeInfo(node.getLeft());
            LocationInfo rightInfo = this.getNodeInfo(node.getRight());
            int len = info.len;
            int loc = info.location;
            if (leftInfo != null) {
                loc = leftInfo.location;
                len += leftInfo.len;
            }
            if (rightInfo != null) {
                len += rightInfo.len;
            }
            return new LocationInfo(loc, len);
        }
        return this.nodeIntMap.get(node);
    }

    private boolean isNextChar(char c) {
        int len = this.expStr.length();
        int i = this.location;
        while (i < len) {
            if (this.expStr.charAt(i) == c) {
                return true;
            }
            if (!Character.isWhitespace(this.expStr.charAt(i))) {
                return false;
            }
            ++i;
        }
        return false;
    }

    private boolean isNumber(String num) {
        int length = num.length();
        int i = 0;
        while (i < length) {
            char c = num.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Node createMemberNode(ICellSet cs, String id, Context ctx) {
        if (this.isNextChar('(')) {
            int atIdx = id.indexOf(64);
            String fnName = id;
            String fnOpt = null;
            if (atIdx == 0) {
                fnOpt = id.substring(1);
                Calc calc = new Calc();
                calc.setOption(fnOpt);
                calc.setParameter(cs, ctx, this.scanParameter());
                return calc;
            }
            if (atIdx != -1) {
                fnName = id.substring(0, atIdx);
                fnOpt = id.substring(atIdx + 1);
            }
            if (FunctionLib.isMemberFnName((String)fnName)) {
                MemberFunction mfn = FunctionLib.newMemberFunction((String)fnName);
                mfn.setOption(fnOpt);
                mfn.setParameter(cs, ctx, this.scanParameter());
                return mfn;
            }
        }
        if (id.startsWith("#")) {
            return new FuzzyFieldRef(id.substring(1));
        }
        return new FieldRef(id);
    }

    private static int scanAnnotation(String str, int start) {
        int i = start + 1;
        int len = str.length() - 1;
        while (i < len) {
            char ch = str.charAt(i);
            if (ch == '*') {
                if (str.charAt(i + 1) == '/') {
                    return i + 1;
                }
            } else if (ch == '/' && str.charAt(i + 1) == '*' && (i = ExpStrProcessor.scanAnnotation(str, i + 1)) == -1) {
                return -1;
            }
            ++i;
        }
        return -1;
    }

    private String scanId() {
        int len = this.expStr.length();
        int begin = this.location;
        while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (KeyWord.isSymbol((char)c)) break;
            ++this.location;
        }
        return this.expStr.substring(begin, this.location);
    }

    private String scanParameter() {
        char c;
        int len = this.expStr.length();
        while (this.location < len) {
            c = this.expStr.charAt(this.location);
            if (!Character.isWhitespace(c)) break;
            ++this.location;
        }
        if (this.location == len) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.missingParam"));
        }
        c = this.expStr.charAt(this.location);
        if (c != '(') {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.missingParam"));
        }
        int match = ExpStrProcessor.scanParenthesis(this.expStr, this.location);
        if (match == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
        }
        String param = this.expStr.substring(this.location + 1, match);
        this.location = match + 1;
        return param;
    }

    public static int scanParenthesis(String str, int start) {
        int len = str.length();
        int i = start + 1;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '(': {
                    i = ExpStrProcessor.scanParenthesis(str, i);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    int q = Sentence.scanQuotation((String)str, (int)i, (char)'\\');
                    if (q < 0) {
                        ++i;
                        break;
                    }
                    i = q + 1;
                    break;
                }
                case '[': {
                    int q;
                    if (i > start && str.charAt(i - 1) == '$') {
                        q = Sentence.scanBracket((String)str, (int)i, (char)'\\');
                        if (q < 0) {
                            ++i;
                            break;
                        }
                        i = q + 1;
                        break;
                    }
                    ++i;
                    break;
                }
                case ')': {
                    return i;
                }
                default: {
                    ++i;
                }
            }
        }
        return -1;
    }

    public void printMap() {
        if (this.nodeIntMap.isEmpty()) {
            System.out.println("NodeIntMap\u4e3a\u7a7a");
            return;
        }
        System.out.println(this.expStr);
        for (Map.Entry<Node, LocationInfo> entry : this.nodeIntMap.entrySet()) {
            Node node = entry.getKey();
            LocationInfo info = entry.getValue();
            System.out.printf("Node@%s -> Location: %d, Length: %d, %s %n", node.getClass().getSimpleName(), info.location, info.len, this.extractSubstring(this.expStr, info));
        }
    }

    private String extractSubstring(String source, LocationInfo info) {
        return source.substring(info.location, info.location + info.len);
    }

    public String parseString(Map<String, LocationInfo> map) {
        String src = this.expStr;
        if (src == null || map == null || map.isEmpty()) {
            return src;
        }
        StringBuilder result = new StringBuilder(src);
        if (map.size() == 1) {
            Map.Entry<String, LocationInfo> entry = map.entrySet().iterator().next();
            result.replace(entry.getValue().location, entry.getValue().location + entry.getValue().len, entry.getKey());
        } else {
            ArrayList<Map.Entry<String, LocationInfo>> entries = new ArrayList<Map.Entry<String, LocationInfo>>(map.entrySet());
            entries.sort(new Comparator<Map.Entry<String, LocationInfo>>(){

                @Override
                public int compare(Map.Entry<String, LocationInfo> e1, Map.Entry<String, LocationInfo> e2) {
                    return e2.getValue().location - e1.getValue().location;
                }
            });
            for (Map.Entry entry : entries) {
                LocationInfo info = (LocationInfo)entry.getValue();
                result.replace(info.location, info.location + info.len, (String)entry.getKey());
            }
        }
        return result.toString();
    }

    public Node getHome() {
        return this.home;
    }

    public Map<Node, LocationInfo> getNodeIntMap() {
        return this.nodeIntMap;
    }
}

