/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pseudo;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.Context;
import com.scudata.dm.ParamList;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.pseudo.ExpStrProcessor;
import com.scudata.pseudo.LocationInfo;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ParamParser {
    private Map<Node, LocationInfo> nodeIntMap = new HashMap<Node, LocationInfo>();

    ParamParser() {
    }

    public static IParam newLeafParam(String paramStr, ICellSet cs, Context ctx) {
        if (paramStr == null) {
            return null;
        }
        if ((paramStr = paramStr.trim()).length() == 0) {
            return null;
        }
        return new LeafParam(new Expression(cs, ctx, paramStr, true, false));
    }

    public Map<? extends Node, ? extends LocationInfo> getNodeIntMap() {
        return this.nodeIntMap;
    }

    public IParam parse(String paramStr, ICellSet cs, Context ctx, int locOffset) {
        return this.parse(paramStr, cs, ctx, '\u0000', false, true, locOffset);
    }

    public IParam parse(String paramStr, ICellSet cs, Context ctx, boolean doMacro, int locOffset) {
        return this.parse(paramStr, cs, ctx, '\u0000', doMacro, true, locOffset);
    }

    public IParam parse(String paramStr, ICellSet cs, Context ctx, boolean doMacro, boolean doOpt, int locOffset) {
        return this.parse(paramStr, cs, ctx, '\u0000', doMacro, doOpt, locOffset);
    }

    private IParam parse(String paramStr, ICellSet cs, Context ctx, char prevLevel, boolean doMacro, boolean doOpt, int locOffset) {
        if (paramStr == null) {
            return null;
        }
        if ((paramStr = paramStr.trim()).length() == 0) {
            return null;
        }
        if (prevLevel == ':') {
            ExpStrProcessor esp = new ExpStrProcessor(paramStr, locOffset);
            esp.parse(ctx);
            this.nodeIntMap.putAll(esp.getNodeIntMap());
            return new LeafParam(new Expression(esp.getHome()));
        }
        char level = ParamParser.getNextLevel(prevLevel);
        while (!ParamParser.hasSeparator(paramStr, level)) {
            if (level == ':') {
                ExpStrProcessor esp = new ExpStrProcessor(paramStr, locOffset);
                esp.parse(ctx);
                this.nodeIntMap.putAll(esp.getNodeIntMap());
                return new LeafParam(new Expression(esp.getHome()));
            }
            level = ParamParser.getNextLevel(level);
        }
        SymbolParam param = new SymbolParam(level);
        ArgumentTokenizer arg = new ArgumentTokenizer(paramStr, level);
        while (arg.hasMoreElements()) {
            String s = arg.nextToken();
            param.addSub(this.parse(s, cs, ctx, level, doMacro, doOpt, locOffset));
            locOffset += s.length();
        }
        return param;
    }

    private static char getNextLevel(char prevLevel) {
        switch (prevLevel) {
            case '\u0000': {
                return ';';
            }
            case ';': {
                return ',';
            }
            case ',': {
                return ':';
            }
        }
        throw new RQException();
    }

    private static boolean hasSeparator(String str, char separator) {
        int len = str.length();
        int index = 0;
        while (index < len) {
            int tmp;
            char ch = str.charAt(index);
            if (ch == separator) {
                return true;
            }
            if (ch == '\"' || ch == '\'') {
                tmp = Sentence.scanQuotation((String)str, (int)index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            if (ch == '(') {
                tmp = Expression.scanParenthesis((String)str, (int)index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            if (ch == '[') {
                tmp = Sentence.scanBracket((String)str, (int)index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            if (ch == '{') {
                tmp = Sentence.scanBrace((String)str, (int)index);
                if (tmp < 0) {
                    return false;
                }
                index = tmp + 1;
                continue;
            }
            ++index;
        }
        return false;
    }

    private static class LeafParam
    implements IParam {
        private Expression exp;

        public LeafParam(Expression exp) {
            this.exp = exp;
        }

        public boolean isLeaf() {
            return true;
        }

        public int getSubSize() {
            return 0;
        }

        public IParam getSub(int index) {
            throw new RuntimeException();
        }

        public char getType() {
            return '\u0000';
        }

        public Expression getLeafExpression() {
            return this.exp;
        }

        public void getAllLeafExpression(ArrayList<Expression> list) {
            list.add(this.exp);
        }

        public Expression[] toArray(String function, boolean canNull) {
            return new Expression[]{this.exp};
        }

        public String[] toStringArray(String function, boolean canNull) {
            return new String[]{this.exp.toString()};
        }

        public String[] toIdentifierNames(String function) {
            return new String[]{this.exp.getIdentifierName()};
        }

        public IParam create(int start, int end) {
            return start > 0 ? this : null;
        }

        public boolean containParam(String name) {
            return this.exp.containParam(name);
        }

        public void getUsedParams(Context ctx, ParamList resultList) {
            this.exp.getUsedParams(ctx, resultList);
        }

        public void getUsedFields(Context ctx, List<String> resultList) {
            this.exp.getUsedFields(ctx, resultList);
        }

        public void getUsedCells(List<INormalCell> resultList) {
            this.exp.getUsedCells(resultList);
        }

        public void reset() {
            this.exp.reset();
        }

        public boolean optimize(Context ctx) {
            this.exp.optimize(ctx);
            Node home = this.exp.getHome();
            return home instanceof Constant;
        }

        public boolean canCalculateAll() {
            return this.exp.canCalculateAll();
        }
    }

    private static class SymbolParam
    implements IParam {
        private char level;
        private ArrayList<IParam> paramList = new ArrayList(3);

        public SymbolParam(char level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return false;
        }

        public int getSubSize() {
            return this.paramList.size();
        }

        public IParam getSub(int index) {
            return this.paramList.get(index);
        }

        public char getType() {
            return this.level;
        }

        public Expression getLeafExpression() {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("function.invalidParam"));
        }

        public void getAllLeafExpression(ArrayList<Expression> list) {
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub == null) {
                    list.add(null);
                } else {
                    sub.getAllLeafExpression(list);
                }
                ++i;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public Expression[] toArray(String function, boolean canNull) {
            int size = this.getSubSize();
            Expression[] exps = new Expression[size];
            int i = 0;
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub != null) {
                    if (!sub.isLeaf()) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(String.valueOf(function) + mm.getMessage("function.invalidParam"));
                    }
                    exps[i] = sub.getLeafExpression();
                } else if (!canNull) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(function) + mm.getMessage("function.invalidParam"));
                }
                ++i;
            }
            return exps;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String[] toStringArray(String function, boolean canNull) {
            int size = this.getSubSize();
            String[] expStrs = new String[size];
            int i = 0;
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub != null) {
                    if (!sub.isLeaf()) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(String.valueOf(function) + mm.getMessage("function.invalidParam"));
                    }
                    expStrs[i] = sub.getLeafExpression().toString();
                } else if (!canNull) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(function) + mm.getMessage("function.invalidParam"));
                }
                ++i;
            }
            return expStrs;
        }

        public String[] toIdentifierNames(String function) {
            int size = this.getSubSize();
            String[] expStrs = new String[size];
            int i = 0;
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub == null || !sub.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(function) + mm.getMessage("function.invalidParam"));
                }
                expStrs[i] = sub.getLeafExpression().getIdentifierName();
                ++i;
            }
            return expStrs;
        }

        public IParam create(int start, int end) {
            if (end == start + 1) {
                return this.getSub(start);
            }
            SymbolParam param = new SymbolParam(this.level);
            while (start < end) {
                param.paramList.add(this.paramList.get(start));
                ++start;
            }
            return param;
        }

        void addSub(IParam param) {
            this.paramList.add(param);
        }

        public boolean containParam(String name) {
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub != null && sub.containParam(name)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void getUsedParams(Context ctx, ParamList resultList) {
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub != null) {
                    sub.getUsedParams(ctx, resultList);
                }
                ++i;
            }
        }

        public void getUsedFields(Context ctx, List<String> resultList) {
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub != null) {
                    sub.getUsedFields(ctx, resultList);
                }
                ++i;
            }
        }

        public void getUsedCells(List<INormalCell> resultList) {
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub != null) {
                    sub.getUsedCells(resultList);
                }
                ++i;
            }
        }

        public void reset() {
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub != null) {
                    sub.reset();
                }
                ++i;
            }
        }

        public boolean optimize(Context ctx) {
            boolean opt = true;
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub != null && !sub.optimize(ctx)) {
                    opt = false;
                }
                ++i;
            }
            return opt;
        }

        public boolean canCalculateAll() {
            int i = 0;
            int size = this.getSubSize();
            while (i < size) {
                IParam sub = this.getSub(i);
                if (sub != null && !sub.canCalculateAll()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

