/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pseudo;

import com.scudata.common.ICloneable;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileReader;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.IResource;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dw.ComTable;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.PhyTable;
import com.scudata.dw.PhyTableGroup;
import com.scudata.expression.Expression;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.pseudo.PseudoColumn;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PseudoDefination
implements Cloneable,
ICloneable {
    public static final String PD_TABLE_NAME = "name";
    public static final String PD_FILE = "file";
    public static final String PD_ZONE = "zone";
    public static final String PD_DATE = "date";
    public static final String PD_KEYS = "keys";
    public static final String PD_KEY = "key";
    public static final String PD_COLUMN = "column";
    public static final String PD_VAR = "var";
    private Object file;
    private Sequence zone;
    private String date;
    private String[] keys;
    private String key;
    private Object var;
    private List<PseudoColumn> columns;
    private String name;
    private List<IPhyTable> tables;
    private PhyTableGroup tableGroup;
    private List<Object> maxValues;
    private List<Object> minValues;
    private Sequence memoryTable;
    private FileObject fileObject;
    private DataStruct bfileDs;
    private boolean isBFile = false;
    private String[] sortedFields;

    public PseudoDefination() {
    }

    public PseudoDefination(BaseRecord pd, Context ctx) {
        SplEditorSE.checkDQL();
        this.file = PseudoDefination.getFieldValue(pd, PD_FILE);
        this.zone = (Sequence)PseudoDefination.getFieldValue(pd, PD_ZONE);
        this.date = (String)PseudoDefination.getFieldValue(pd, PD_DATE);
        this.keys = (String[])PseudoDefination.getFieldValue(pd, PD_KEYS);
        this.var = PseudoDefination.getFieldValue(pd, PD_VAR);
        this.name = (String)PseudoDefination.getFieldValue(pd, PD_TABLE_NAME);
        Sequence seq = (Sequence)PseudoDefination.getFieldValue(pd, PD_COLUMN);
        if (seq != null) {
            this.columns = new ArrayList<PseudoColumn>();
            int size = seq.length();
            int i = 1;
            while (i <= size) {
                Record rec = (Record)seq.get(i);
                this.columns.add(new PseudoColumn((BaseRecord)rec));
                ++i;
            }
        }
        if (this.file == null && this.var == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileNotExist", (Object)"NULL"));
        }
        if (this.file != null) {
            if (!this.checkBFile(ctx)) {
                this.parseFileToTable(ctx);
            } else {
                BFileCursor cursor = new BFileCursor(this.fileObject, null, null, null);
                this.memoryTable = cursor.fetch();
                this.key = (String)PseudoDefination.getFieldValue(pd, PD_KEY);
                if (this.key != null) {
                    int atIndex = this.key.indexOf(64);
                    int leftParenIndex = this.key.indexOf(40);
                    int rightParenIndex = this.key.lastIndexOf(41);
                    if (leftParenIndex == -1 || rightParenIndex == -1 || leftParenIndex >= rightParenIndex) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("function.invalidParam", (Object)this.key));
                    }
                    String valuesStr = this.key.substring(leftParenIndex + 1, rightParenIndex);
                    String[] cols = valuesStr.split(",");
                    String atToParen = null;
                    if (atIndex != -1) {
                        atToParen = this.key.substring(atIndex + 1, leftParenIndex);
                    }
                    if (cols != null && cols[0].equals("#")) {
                        ((Table)this.memoryTable).createIndexTable("n");
                    } else {
                        ((Table)this.memoryTable).setPrimary(cols, atToParen);
                        ((Table)this.memoryTable).createIndexTable(null);
                    }
                }
            }
            this.sortedFields = this.getAllSortedColNames();
        } else if (this.var != null && this.var instanceof Sequence) {
            this.memoryTable = (Sequence)this.var;
        }
    }

    public PseudoDefination(PseudoDefination pd) {
        this.file = pd.file;
        this.zone = pd.zone;
        this.date = pd.date;
        this.keys = pd.keys;
        this.key = pd.key;
        this.var = pd.var;
        this.name = pd.name;
        this.tables = pd.tables;
        this.maxValues = pd.maxValues;
        this.minValues = pd.minValues;
        this.memoryTable = pd.memoryTable;
        this.fileObject = pd.fileObject;
        this.isBFile = pd.isBFile;
        this.sortedFields = pd.sortedFields;
        this.bfileDs = pd.bfileDs;
        this.tableGroup = pd.tableGroup;
        if (pd.columns != null) {
            this.columns = new ArrayList<PseudoColumn>();
            this.columns.addAll(pd.columns);
        }
    }

    public Object getFile() {
        return this.file;
    }

    public void setFile(Object file) {
        this.file = file;
    }

    public Sequence getZone() {
        return this.zone;
    }

    public void setZone(Sequence zone) {
        this.zone = zone;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public Object getVar() {
        return this.var;
    }

    public void setVar(Object var) {
        this.var = var;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PseudoColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<PseudoColumn> columns) {
        this.columns = columns;
    }

    public List<IPhyTable> getTables() {
        return this.tables;
    }

    public void setTables(List<IPhyTable> tables) {
        this.tables = tables;
    }

    public Sequence getMemoryTable() {
        return this.memoryTable;
    }

    public void setMemoryTable(Sequence memoryTable) {
        this.memoryTable = memoryTable;
    }

    public static void setFieldValue(BaseRecord pd, String name, Object value) {
        int index = pd.getFieldIndex(name);
        if (index != -1) {
            pd.setNormalFieldValue(index, value);
        }
    }

    public static Object getFieldValue(BaseRecord pd, String name) {
        int index = pd.getFieldIndex(name);
        if (index != -1) {
            return pd.getFieldValue(index);
        }
        return null;
    }

    public PseudoColumn findColumnByName(String name) {
        if (name == null || this.columns == null || this.columns.size() == 0) {
            return null;
        }
        for (PseudoColumn col : this.columns) {
            if (col.getName() == null || !name.equals(col.getName())) continue;
            return col;
        }
        return null;
    }

    public PseudoColumn findColumnByPseudoName(String pname) {
        if (pname == null || this.columns == null || this.columns.size() == 0) {
            return null;
        }
        for (PseudoColumn col : this.columns) {
            if (col.getDateName() != null && pname.equals(col.getDateName())) {
                return col;
            }
            if (col.getName() != null && col.getExp() != null && col.containAlias(pname)) {
                return col;
            }
            if (col.get_enum() != null && pname.equals(col.get_enum())) {
                return col;
            }
            if (col.getBits() == null || col.getBits().firstIndexOf((Object)pname) == 0) continue;
            return col;
        }
        return this.findColumnByAlias(pname);
    }

    public PseudoColumn findColumnByAlias(String alias) {
        if (alias == null || this.columns == null || this.columns.size() == 0) {
            return null;
        }
        for (PseudoColumn col : this.columns) {
            if (col.getName() != null && col.containAlias(alias)) {
                return col;
            }
            if (col.get_enum() != null && col.containAlias(alias)) {
                return col;
            }
            if (col.getBits() == null || !col.containAlias(alias)) continue;
            return col;
        }
        return null;
    }

    private void parseFileToTable(String fn, int[] partitions, Context ctx) {
        if (partitions == null) {
            FileObject fo = new FileObject(fn, null, null, ctx);
            File f = fo.getLocalFile().file();
            PhyTable t = ComTable.openBaseTable((File)f, (Context)ctx);
            this.tables.add((IPhyTable)t);
            ctx.removeResource((IResource)t.getGroupTable());
        } else {
            int pcount = partitions.length;
            int i = 0;
            while (i < pcount) {
                File file = Env.getPartitionFile((int)partitions[i], (String)fn);
                PhyTable table = ComTable.openBaseTable((File)file, (Context)ctx);
                table.getGroupTable().setPartition(Integer.valueOf(partitions[i]));
                this.tables.add((IPhyTable)table);
                ++i;
            }
            if (pcount > 1) {
                IPhyTable[] tbls = new IPhyTable[pcount];
                int i2 = 0;
                while (i2 < pcount) {
                    tbls[i2] = this.tables.get(i2);
                    ++i2;
                }
                this.tableGroup = new PhyTableGroup(fn, tbls, partitions, null, ctx);
            }
        }
    }

    private void parseFileToTable(Context ctx) {
        Object file = this.file;
        int[] partitions = null;
        Sequence zone = this.getZone();
        if (zone != null) {
            partitions = zone.toIntArray();
        }
        this.tables = new ArrayList<IPhyTable>();
        if (!(file instanceof String)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("function.invalidParam"));
        }
        this.parseFileToTable((String)file, partitions, ctx);
        if (this.date != null) {
            String dateName = this.date;
            this.maxValues = new ArrayList<Object>();
            this.minValues = new ArrayList<Object>();
            for (IPhyTable t : this.tables) {
                try {
                    Object[] values = ((PhyTable)t).getMaxMinValue(dateName);
                    if (values == null) continue;
                    this.maxValues.add(values[0]);
                    this.minValues.add(values[1]);
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage());
                }
            }
        }
    }

    public PhyTableGroup getTableMetaDataGroup() {
        return this.tableGroup;
    }

    public String getUgrp() {
        String[] names = this.getAllColNames();
        if (names == null) {
            return null;
        }
        return names[0];
    }

    public String[] getAllRealColNames() {
        if (this.isBFile) {
            return this.memoryTable.dataStruct().getFieldNames();
        }
        if (this.var == null) {
            String[] names = this.tables.get(0).getAllColNames();
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                list.add(name);
                ++n2;
            }
            if (this.columns != null) {
                for (PseudoColumn pcol : this.columns) {
                    if (pcol.get_enum() == null) continue;
                    list.add(pcol.get_enum());
                }
            }
            String[] arr = new String[list.size()];
            list.toArray(arr);
            return arr;
        }
        return this.memoryTable.dataStruct().getFieldNames();
    }

    public String[] getAllColNames() {
        if (this.isBFile) {
            return this.memoryTable.dataStruct().getFieldNames();
        }
        if (this.var == null) {
            String[] names = this.tables.get(0).getAllColNames();
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                PseudoColumn pcol = this.findColumnByName(name);
                if (pcol != null) {
                    if (pcol.get_enum() != null) {
                        list.add(pcol.get_enum());
                    } else if (pcol.getDateName() != null) {
                        list.add(pcol.getDateName());
                    } else if (pcol.getBits() != null) {
                        Sequence seq = pcol.getBits();
                        int i = 1;
                        int len = seq.length();
                        while (i <= len) {
                            list.add((String)seq.get(i));
                            ++i;
                        }
                    }
                }
                list.add(name);
                ++n2;
            }
            String[] arr = new String[list.size()];
            list.toArray(arr);
            return arr;
        }
        return this.memoryTable.dataStruct().getFieldNames();
    }

    public String[] getAllKeyColNames() {
        if (this.isBFile) {
            return this.memoryTable.dataStruct().getPrimary();
        }
        if (this.var == null) {
            if (((PhyTable)this.tables.get(0)).hasPrimaryKey()) {
                return this.tables.get(0).getAllKeyColNames();
            }
            return null;
        }
        return this.memoryTable.dataStruct().getPrimary();
    }

    public String[] getAllSortedColNames() {
        if (this.isBFile) {
            return this.memoryTable.dataStruct().getPrimary();
        }
        if (this.var == null) {
            if (((PhyTable)this.tables.get((int)0)).isSorted) {
                return this.tables.get(0).getAllSortedColNames();
            }
            return null;
        }
        return this.memoryTable.dataStruct().getPrimary();
    }

    public void addPseudoColumn(PseudoColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<PseudoColumn>();
        }
        this.columns.add(column);
    }

    public String getDistribute() {
        if (this.isBFile) {
            return null;
        }
        if (this.var == null) {
            return this.tables.get(0).getDistribute();
        }
        return null;
    }

    public Integer getPartition() {
        if (this.isBFile) {
            return null;
        }
        if (this.var == null && this.tables.get(0) instanceof PhyTable) {
            return ((PhyTable)this.tables.get(0)).getGroupTable().getPartition();
        }
        return null;
    }

    public boolean isSortedFields(String[] fields) {
        if (this.sortedFields == null || fields == null) {
            return false;
        }
        int len = fields.length;
        if (len > this.sortedFields.length || len == 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (fields[i] == null) {
                return false;
            }
            if (!fields[i].equals(this.sortedFields[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private boolean checkBFile(Context ctx) {
        if (!(this.file instanceof String)) {
            return false;
        }
        FileObject fo = new FileObject((String)this.file, null, null, ctx);
        BFileReader reader = new BFileReader(fo);
        reader.open();
        reader.close();
        this.setFileObject(fo);
        this.isBFile = true;
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
        catch (Exception e) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public boolean isBFile() {
        return this.isBFile;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void setFileObject(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public List<Object> getMaxValues() {
        return this.maxValues;
    }

    public List<Object> getMinValues() {
        return this.minValues;
    }

    public Object deepClone() {
        return new PseudoDefination(this);
    }

    public void close() {
        if (this.tables != null) {
            for (IPhyTable table : this.tables) {
                table.close();
            }
        }
    }

    public Expression parseAliasFields(Expression exp) {
        if (exp == null || this.columns == null || this.columns.size() == 0) {
            return exp;
        }
        String str = exp.getIdentifierName();
        for (PseudoColumn col : this.columns) {
            if (col.get_enum() != null || col.getBits() != null || col.getName() == null || col.getAlias() == null) continue;
            Sequence seq = col.getAlias();
            String realName = col.getName();
            int i = 1;
            int len = seq.length();
            while (i <= len) {
                String n = (String)seq.get(i);
                str = str.replaceAll(n, realName);
                ++i;
            }
        }
        return new Expression(str);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

