/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pseudo;

import com.scudata.common.DateFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MergeCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.Conj;
import com.scudata.dm.op.Group;
import com.scudata.dm.op.Join;
import com.scudata.dm.op.New;
import com.scudata.dm.op.Operable;
import com.scudata.dm.op.Operation;
import com.scudata.dm.op.Select;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.Cursor;
import com.scudata.dw.IFilter;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.PhyTable;
import com.scudata.dw.PhyTableGroup;
import com.scudata.dw.RowCursor;
import com.scudata.dw.RowPhyTable;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldRef;
import com.scudata.expression.Function;
import com.scudata.expression.Gather;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.VarParam;
import com.scudata.expression.fn.If;
import com.scudata.expression.mfn.sequence.Contain;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.NotEquals;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Smaller;
import com.scudata.pdm.mfn.dw.CreateCursor;
import com.scudata.pdm.op.PrimaryJoin;
import com.scudata.pseudo.ExpStrProcessor;
import com.scudata.pseudo.LocationInfo;
import com.scudata.pseudo.Pseudo;
import com.scudata.pseudo.PseudoBFile;
import com.scudata.pseudo.PseudoColumn;
import com.scudata.pseudo.PseudoDefination;
import com.scudata.pseudo.PseudoMemory;
import com.scudata.resources.EngineMessage;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PseudoTable
extends Pseudo {
    protected String[] fkNames;
    protected Sequence[] codes;
    protected String[] opts;
    protected int pathCount;
    protected ArrayList<Operation> extraOpList = new ArrayList();
    protected PseudoTable mcsTable;
    protected boolean hasPseudoColumns = false;
    protected boolean hasV;

    public PseudoTable() {
    }

    public PseudoTable(BaseRecord rec, int n, Context ctx) {
        this.pd = new PseudoDefination(rec, ctx);
        this.pathCount = n;
        this.ctx = ctx;
        this.extraNameList = new ArrayList();
        this.init();
    }

    public PseudoTable(PseudoDefination pd, int n, String opt, Context ctx) {
        this.pd = pd;
        this.pathCount = n;
        this.ctx = ctx;
        this.extraNameList = new ArrayList();
        this.hasV = opt != null && opt.indexOf(118) != -1;
        this.init();
    }

    public PseudoTable(BaseRecord rec, PseudoTable mcs, Context ctx) {
        this(rec, 0, ctx);
        this.mcsTable = mcs;
    }

    public static PseudoTable create(BaseRecord rec, int n, String option, Context ctx) {
        PseudoDefination pd = new PseudoDefination(rec, ctx);
        if (pd.getMemoryTable() != null) {
            return new PseudoMemory(rec, n, ctx);
        }
        if (pd.isBFile()) {
            return new PseudoBFile(pd, n, ctx);
        }
        PseudoTable t = new PseudoTable(pd, n, option, ctx);
        t.getSortedColNames();
        return t;
    }

    protected void init() {
        if (this.getPd() != null) {
            String[] names;
            this.allNameList = new ArrayList();
            String[] stringArray = names = this.getPd().getAllRealColNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.allNameList.add(name);
                ++n2;
            }
            if (this.getPd().getColumns() != null) {
                List<PseudoColumn> columns = this.getPd().getColumns();
                for (PseudoColumn column : columns) {
                    if (column.getBits() == null && column.getList() == null && column.getDateName() == null) continue;
                    this.hasPseudoColumns = true;
                }
            }
        }
    }

    @Override
    public void addPKeyNames() {
        this.addColNames(this.getPd().getAllKeyColNames());
    }

    @Override
    public void addColNames(String[] nameArray) {
        String[] stringArray = nameArray;
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.addColName(name);
            ++n2;
        }
    }

    @Override
    public void addColName(String name) {
        if (name == null) {
            return;
        }
        if (this.allNameList.contains(name) && !this.extraNameList.contains(name)) {
            this.extraNameList.add(name);
        }
    }

    protected void setFetchInfo(Expression[] exps, String[] fields) {
        this.exps = null;
        this.names = null;
        boolean needNew = this.extraNameList.size() > 0;
        Expression[] newExps = null;
        this.extraOpList.clear();
        if (this.fkNameList != null) {
            int size = this.fkNameList.size();
            this.fkNames = new String[size];
            this.fkNameList.toArray(this.fkNames);
            this.codes = new Sequence[size];
            this.codeList.toArray(this.codes);
            this.opts = new String[size];
            this.optList.toArray(this.opts);
        }
        if (exps == null) {
            int i;
            int len;
            if (fields == null) {
                fields = this.pd.getAllColNames();
                len = fields.length;
                exps = new Expression[len];
                i = 0;
                while (i < len) {
                    exps[i] = new Expression(fields[i]);
                    ++i;
                }
            } else {
                len = fields.length;
                exps = new Expression[len];
                i = 0;
                while (i < len) {
                    exps[i] = new Expression(fields[i]);
                    ++i;
                }
            }
        }
        newExps = (Expression[])exps.clone();
        ArrayList<String> tempList = new ArrayList<String>();
        for (String name : this.extraNameList) {
            if (tempList.contains(name)) continue;
            tempList.add(name);
        }
        Expression[] expressionArray = exps;
        int n = exps.length;
        int n2 = 0;
        while (n2 < n) {
            Expression exp = expressionArray[n2];
            String expName = exp.getIdentifierName();
            if (tempList.contains(expName)) {
                tempList.remove(expName);
            }
            ++n2;
        }
        ArrayList<String> tempNameList = new ArrayList<String>();
        ArrayList<Expression> tempExpList = new ArrayList<Expression>();
        int size = exps.length;
        int i = 0;
        while (i < size) {
            Expression exp = exps[i];
            String name = fields[i];
            Node node = exp.getHome();
            if (node instanceof UnknownSymbol || node instanceof VarParam) {
                String expName = exp.getIdentifierName();
                PseudoColumn col = this.pd.findColumnByPseudoName(expName);
                PseudoColumn col2 = this.pd.findColumnByName(expName);
                if (col2 != null && col == null && col2.getExp() != null && (col2.getAlias() == null || col2.getAlias().length() == 0)) {
                    newExps[i] = new Expression(col2.getExp());
                    needNew = true;
                    if (!tempNameList.contains(expName)) {
                        tempExpList.add(new Expression(expName));
                        tempNameList.add(expName);
                    }
                } else if (col != null) {
                    if (col.getExp() != null) {
                        newExps[i] = new Expression(col.getExp());
                        needNew = true;
                        ArrayList list = new ArrayList();
                        newExps[i].getUsedFields(this.ctx, list);
                        for (String field : list) {
                            if (tempNameList.contains(field)) continue;
                            tempExpList.add(new Expression(field));
                            tempNameList.add(field);
                        }
                    } else if (col.getDateName() != null) {
                        name = col.getName();
                        newExps[i] = new Expression("date@o(" + name + ")");
                        exp = new Expression(name);
                        needNew = true;
                        if (!tempNameList.contains(name)) {
                            tempExpList.add(exp);
                            tempNameList.add(name);
                        }
                    } else if (col.get_enum() != null) {
                        String var = "pseudo_enum_value_" + i;
                        this.ctx.setParamValue(var, (Object)col.getList());
                        name = col.getName();
                        newExps[i] = new Expression(String.valueOf(var) + "(" + name + ")");
                        exp = new Expression(name);
                        needNew = true;
                        if (!tempNameList.contains(name)) {
                            tempExpList.add(exp);
                            tempNameList.add(name);
                        }
                    } else if (col.getBits() != null) {
                        name = col.getName();
                        String pname = ((UnknownSymbol)node).getName();
                        if (col.containAlias(pname)) {
                            pname = col.aliasToName(pname);
                        }
                        Sequence seq = col.getBits();
                        int idx = seq.firstIndexOf((Object)pname) - 1;
                        int bit = 1 << idx;
                        String str = "and(" + col.getName() + "," + bit + ")!=0";
                        newExps[i] = new Expression(str);
                        exp = new Expression(name);
                        needNew = true;
                        tempExpList.add(exp);
                        tempNameList.add(name);
                    } else if (col.getAlias() != null) {
                        needNew = true;
                        String realName = col.getName();
                        if (!tempNameList.contains(realName)) {
                            tempExpList.add(new Expression(realName));
                            tempNameList.add(realName);
                        }
                        newExps[i] = new Expression(realName);
                    }
                } else if (this.allNameList.contains(expName)) {
                    if (!tempNameList.contains(name)) {
                        tempExpList.add(exp);
                        tempNameList.add(name);
                    }
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(expName) + mm.getMessage("ds.fieldNotExist"));
                }
            }
            ++i;
        }
        String date = this.pd.getDate();
        String ugrp = this.pd.getUgrp();
        if (date != null && !tempNameList.contains(ugrp)) {
            needNew = true;
            tempList.add(ugrp);
        }
        for (String name : tempList) {
            tempExpList.add(new Expression(name));
            tempNameList.add(name);
        }
        size = tempExpList.size();
        this.exps = new Expression[size];
        tempExpList.toArray(this.exps);
        this.names = new String[size];
        tempNameList.toArray(this.names);
        if (needNew) {
            New _new = new New(newExps, fields, null);
            this.extraOpList.add((Operation)_new);
        }
    }

    public String[] getFetchColNames(String[] fields) {
        ArrayList<String> tempList = new ArrayList<String>();
        if (fields != null) {
            String[] stringArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                tempList.add(name);
                ++n2;
            }
        }
        for (String name : this.extraNameList) {
            if (tempList.contains(name)) continue;
            tempList.add(name);
        }
        int size = tempList.size();
        if (size == 0) {
            return null;
        }
        String[] newFields = new String[size];
        tempList.toArray(newFields);
        return newFields;
    }

    public ICursor[] getCursors(boolean isColumn) {
        List<IPhyTable> tables = this.getPd().getTables();
        int size = tables.size();
        ICursor[] cursors = new ICursor[size];
        int i = 0;
        while (i < size) {
            cursors[i] = this.getCursor(tables.get(i), null, true, isColumn);
            ++i;
        }
        return cursors;
    }

    private ICursor getCursor(IPhyTable table, ICursor mcs, boolean addOpt, boolean isColumn) {
        ICursor cursor = null;
        if (isColumn) {
            return this.getCursorV(table, mcs, addOpt);
        }
        Expression[] exps = Operation.dupExpressions((Expression[])this.exps, (Context)this.ctx);
        Expression filter = Operation.dupExpression((Expression)this.filter, (Context)this.ctx);
        if (this.fkNames != null) {
            cursor = mcs != null ? (mcs instanceof MultipathCursors ? table.cursor(null, this.names, filter, this.fkNames, this.codes, this.opts, (MultipathCursors)mcs, null, this.ctx) : (exps == null ? table.cursor(null, this.names, filter, this.fkNames, this.codes, this.opts, null, this.ctx) : table.cursor(exps, this.names, filter, this.fkNames, this.codes, this.opts, null, this.ctx))) : (this.pathCount > 1 ? (exps == null ? table.cursor(null, this.names, filter, this.fkNames, this.codes, this.opts, this.pathCount, null, this.ctx) : table.cursor(exps, this.names, filter, this.fkNames, this.codes, this.opts, this.pathCount, null, this.ctx)) : (exps == null ? table.cursor(null, this.names, filter, this.fkNames, this.codes, this.opts, null, this.ctx) : table.cursor(exps, this.names, filter, this.fkNames, this.codes, this.opts, null, this.ctx)));
        } else if (mcs != null) {
            if (mcs instanceof MultipathCursors) {
                cursor = table.cursor(null, this.names, filter, null, null, null, (MultipathCursors)mcs, null, this.ctx);
            } else if (exps == null) {
                cursor = table.cursor(this.names, filter, this.ctx);
            }
        } else {
            cursor = this.pathCount > 1 ? (exps == null ? table.cursor(null, this.names, filter, null, null, null, this.pathCount, null, this.ctx) : table.cursor(exps, this.names, filter, null, null, null, this.pathCount, null, this.ctx)) : (exps == null ? table.cursor(this.names, filter, this.ctx) : table.cursor(exps, this.names, filter, null, null, null, null, this.ctx));
        }
        if (addOpt) {
            if (this.opList != null) {
                for (Operation op : this.opList) {
                    cursor.addOperation(op, this.ctx);
                }
            }
            if (this.extraOpList != null) {
                for (Operation op : this.extraOpList) {
                    cursor.addOperation(op, this.ctx);
                }
            }
        }
        return cursor;
    }

    private ICursor getCursorV(IPhyTable table, ICursor mcs, boolean addOpt) {
        ICursor cursor = null;
        Expression[] exps = Operation.dupExpressions((Expression[])this.exps, (Context)this.ctx);
        Expression filter = Operation.dupExpression((Expression)this.filter, (Context)this.ctx);
        if (table instanceof ColPhyTable) {
            cursor = this.fkNames != null ? (mcs != null ? (mcs instanceof MultipathCursors ? CreateCursor.cursor((ColPhyTable)table, null, this.names, filter, this.fkNames, this.codes, this.opts, (MultipathCursors)mcs, null, this.ctx) : CreateCursor.cursor((ColPhyTable)table, exps, this.names, filter, this.fkNames, this.codes, this.opts, this.ctx)) : (this.pathCount > 1 ? CreateCursor.cursor((ColPhyTable)table, exps, this.names, filter, this.fkNames, this.codes, this.opts, this.pathCount, null, this.ctx) : CreateCursor.cursor((ColPhyTable)table, exps, this.names, filter, this.fkNames, this.codes, this.opts, this.ctx))) : (mcs != null ? (mcs instanceof MultipathCursors ? CreateCursor.cursor((ColPhyTable)table, null, this.names, filter, null, null, null, (MultipathCursors)mcs, null, this.ctx) : CreateCursor.cursor((ColPhyTable)table, exps, this.names, filter, null, null, null, this.ctx)) : (this.pathCount > 1 ? CreateCursor.cursor((ColPhyTable)table, exps, this.names, filter, null, null, null, this.pathCount, null, this.ctx) : CreateCursor.cursor((ColPhyTable)table, exps, this.names, filter, null, null, null, this.ctx)));
        } else if (table instanceof PhyTableGroup) {
            cursor = this.fkNames != null ? (mcs != null ? (mcs instanceof MultipathCursors ? CreateCursor.cursor((PhyTableGroup)table, null, this.names, filter, this.fkNames, this.codes, this.opts, (MultipathCursors)mcs, null, this.ctx) : CreateCursor.cursor((PhyTableGroup)table, exps, this.names, filter, this.fkNames, this.codes, this.opts, null, this.ctx)) : (this.pathCount > 1 ? CreateCursor.cursor((PhyTableGroup)table, exps, this.names, filter, this.fkNames, this.codes, this.opts, this.pathCount, null, this.ctx) : CreateCursor.cursor((PhyTableGroup)table, exps, this.names, filter, this.fkNames, this.codes, this.opts, null, this.ctx))) : (mcs != null ? (mcs instanceof MultipathCursors ? CreateCursor.cursor((PhyTableGroup)table, null, this.names, filter, null, null, null, (MultipathCursors)mcs, null, this.ctx) : CreateCursor.cursor((PhyTableGroup)table, exps, this.names, filter, null, null, null, null, this.ctx)) : (this.pathCount > 1 ? CreateCursor.cursor((PhyTableGroup)table, exps, this.names, filter, null, null, null, this.pathCount, null, this.ctx) : CreateCursor.cursor((PhyTableGroup)table, exps, this.names, filter, null, null, null, null, this.ctx)));
        }
        if (addOpt) {
            if (this.opList != null) {
                for (Operation op : this.opList) {
                    cursor.addOperation(op, this.ctx);
                }
            }
            if (this.extraOpList != null) {
                for (Operation op : this.extraOpList) {
                    cursor.addOperation(op, this.ctx);
                }
            }
        }
        return cursor;
    }

    static ICursor mergeCursor(ICursor[] cursors, PseudoDefination pd, Context ctx) {
        if (pd.getDate() == null) {
            return new ConjxCursor(cursors);
        }
        String ugrp = pd.getUgrp();
        DataStruct ds = cursors[0].getDataStruct();
        int index = ds.getFieldIndex(ugrp);
        if (index == -1) {
            return new ConjxCursor(cursors);
        }
        return new MergeCursor(cursors, new int[]{index}, null, ctx);
    }

    static ICursor mergeCursor(ICursor[] cursors, Context ctx) {
        return new ConjxCursor(cursors);
    }

    static void groupByUser(ICursor cursor, String user, String ugrp, Context ctx) {
        if (user != null && ugrp != null && user.equals(ugrp)) {
            Expression[] exps = new Expression[]{new Expression(ugrp)};
            cursor.addOperation((Operation)new Group(exps, null), ctx);
            cursor.addOperation((Operation)new Conj(new Expression("~.group(" + user + ")")), ctx);
        }
    }

    private ICursor addOptionToCursor(ICursor cursor) {
        if (this.extraOpList != null) {
            for (Operation op : this.extraOpList) {
                cursor.addOperation(op, this.ctx);
            }
        }
        if (this.opList != null) {
            for (Operation op : this.opList) {
                cursor.addOperation(op, this.ctx);
            }
        }
        return cursor;
    }

    private List<IPhyTable> filterTables(List<IPhyTable> tables) {
        block8: {
            IFilter dateFilter;
            block10: {
                Object obj;
                String dateName;
                block9: {
                    IPhyTable table;
                    if (this.filter == null || this.pd.getDate() == null) break block8;
                    dateName = this.pd.getDate();
                    PseudoColumn dateCol = this.pd.findColumnByPseudoName(dateName);
                    if (dateCol != null && dateCol.getExp() != null) {
                        dateName = dateCol.getName();
                    }
                    obj = (table = tables.get(0)) instanceof ColPhyTable ? Cursor.parseFilter((ColPhyTable)((ColPhyTable)table), (Expression)this.filter, (Context)this.ctx) : RowCursor.parseFilter((RowPhyTable)((RowPhyTable)table), (Node)this.filter.getHome(), (Context)this.ctx);
                    dateFilter = null;
                    if (!(obj instanceof IFilter)) break block9;
                    if (!((IFilter)obj).getColumnName().equals(dateName)) break block10;
                    dateFilter = (IFilter)obj;
                    break block10;
                }
                if (obj instanceof ArrayList) {
                    ArrayList list = (ArrayList)obj;
                    for (Object f : list) {
                        if (!(f instanceof IFilter) || !((IFilter)f).getColumnName().equals(dateName)) continue;
                        dateFilter = (IFilter)f;
                        break;
                    }
                }
            }
            if (dateFilter != null) {
                int count = tables.size();
                ArrayList<IPhyTable> list = new ArrayList<IPhyTable>(count);
                List<Object> max = this.pd.getMaxValues();
                List<Object> min = this.pd.getMinValues();
                int i = 0;
                while (i < count) {
                    PhyTable t = (PhyTable)tables.get(i);
                    if (t.getTotalRecordCount() != 0L && dateFilter.match(min.get(i), max.get(i))) {
                        list.add((IPhyTable)t);
                    }
                    ++i;
                }
                return list;
            }
        }
        int count = tables.size();
        ArrayList<IPhyTable> list = new ArrayList<IPhyTable>(count);
        int i = 0;
        while (i < count) {
            PhyTable t = (PhyTable)tables.get(i);
            if (t.getTotalRecordCount() != 0L) {
                list.add((IPhyTable)t);
            }
            ++i;
        }
        return list;
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] names) {
        return this.cursor(exps, names, this.hasV);
    }

    @Override
    public ICursor cursor(Expression[] exps, String[] names, boolean isColumn) {
        int i;
        ICursor mcs;
        IPhyTable t;
        this.setFetchInfo(exps, names);
        List<IPhyTable> tables = this.getPd().getTables();
        int size = tables.size();
        if (isColumn && (t = tables.get(0)) instanceof ColPhyTable && !((PhyTable)t).getGroupTable().isPureFormat()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.oldVersion"));
        }
        PseudoTable mcsTable = this.mcsTable;
        if (mcsTable != null) {
            String[] fetchs = this.names;
            String[] keys = this.getPrimaryKey();
            boolean flag = false;
            if (keys != null) {
                String key = keys[0];
                String[] stringArray = fetchs;
                int n = fetchs.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (name.equals(key)) {
                        flag = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!flag) {
                mcsTable = null;
            }
        }
        if (size == 0) {
            return new MemoryCursor(null);
        }
        if (size == 1) {
            ICursor cs;
            if (this.pathCount <= 1) {
                cs = this.getCursor(tables.get(0), null, false, isColumn);
            } else if (mcsTable == null) {
                cs = this.getCursor(tables.get(0), null, false, isColumn);
            } else {
                mcs = mcsTable.cursor(this.pathCount);
                cs = this.getCursor(tables.get(0), mcs, false, isColumn);
                mcs.close();
            }
            return this.addOptionToCursor(cs);
        }
        tables = this.filterTables(tables);
        size = tables.size();
        ICursor[] cursors = new ICursor[size];
        if (size == 0) {
            return new MemoryCursor(null);
        }
        if (this.pathCount <= 1) {
            int i2 = 0;
            while (i2 < size) {
                cursors[i2] = this.getCursor(tables.get(i2), null, false, isColumn);
                ++i2;
            }
            return this.addOptionToCursor(PseudoTable.mergeCursor(cursors, this.pd, this.ctx));
        }
        if (mcsTable == null) {
            cursors[0] = this.getCursor(tables.get(0), null, false, isColumn);
            mcs = cursors[0];
            if (mcs.getSortFields() == null) {
                mcs = null;
            }
            i = 1;
            while (i < size) {
                cursors[i] = this.getCursor(tables.get(i), mcs, false, isColumn);
                ++i;
            }
        } else {
            mcs = mcsTable.cursor(this.pathCount);
            i = 0;
            while (i < size) {
                cursors[i] = this.getCursor(tables.get(i), mcs, false, isColumn);
                ++i;
            }
            mcs.close();
            if (!(cursors[0] instanceof MultipathCursors)) {
                return this.addOptionToCursor(PseudoTable.mergeCursor(cursors, this.pd, this.ctx));
            }
        }
        int mcount = ((MultipathCursors)cursors[0]).getPathCount();
        ICursor[] mcursors = new ICursor[mcount];
        int m = 0;
        while (m < mcount) {
            if (size == 1) {
                mcursors[m] = ((MultipathCursors)cursors[0]).getCursors()[m];
            } else {
                ICursor[] cursorArray = new ICursor[size];
                int i3 = 0;
                while (i3 < size) {
                    cursorArray[i3] = ((MultipathCursors)cursors[i3]).getCursors()[m];
                    ++i3;
                }
                mcursors[m] = PseudoTable.mergeCursor(cursorArray, this.pd, this.ctx);
            }
            ++m;
        }
        return this.addOptionToCursor((ICursor)new MultipathCursors(mcursors, this.ctx));
    }

    private ICursor cursor(int pathCount) {
        List<IPhyTable> tables = this.getPd().getTables();
        return tables.get(0).cursor(null, null, null, null, null, null, pathCount, null, this.ctx);
    }

    @Override
    public Object clone(Context ctx) {
        PseudoTable obj = new PseudoTable();
        obj.hasPseudoColumns = this.hasPseudoColumns;
        obj.pathCount = this.pathCount;
        obj.mcsTable = this.mcsTable;
        obj.hasV = this.hasV;
        obj.fkNames = this.fkNames == null ? null : (String[])this.fkNames.clone();
        obj.codes = this.codes == null ? null : (Sequence[])this.codes.clone();
        this.cloneField(obj);
        obj.ctx = ctx;
        return obj;
    }

    @Override
    public Pseudo setPathCount(int pathCount) {
        PseudoTable table = null;
        table = (PseudoTable)((Object)this.clone(this.ctx));
        table.pathCount = pathCount;
        return table;
    }

    @Override
    public PseudoTable getMcsTable() {
        return this.mcsTable;
    }

    @Override
    public void setMcsTable(Pseudo mcsTable) {
        this.mcsTable = (PseudoTable)mcsTable;
    }

    private PseudoColumn findEnumNode(Node node) {
        if (node instanceof UnknownSymbol) {
            String pname = ((UnknownSymbol)node).getName();
            return this.getPd().findColumnByPseudoName(pname);
        }
        if (node instanceof DotOperator && node.getLeft() instanceof CurrentElement && node.getRight() instanceof FieldRef) {
            FieldRef fieldNode = (FieldRef)node.getRight();
            String pname = fieldNode.getName();
            return this.getPd().findColumnByPseudoName(pname);
        }
        return null;
    }

    private void gatherNodeReplacements(Node node, Map<Node, String> replacementMap) {
        if (node == null) {
            return;
        }
        if (node instanceof UnknownSymbol) {
            String pname = ((UnknownSymbol)node).getName();
            PseudoColumn col = this.getPd().findColumnByPseudoName(pname);
            if (col != null) {
                if (col.getBits() != null) {
                    Sequence seq = col.getBits();
                    if (col.containAlias(pname)) {
                        pname = col.aliasToName(pname);
                    }
                    int idx = seq.firstIndexOf((Object)pname) - 1;
                    int bit = 1 << idx;
                    String str = "and(" + col.getName() + "," + bit + ")!=0";
                    replacementMap.put(node.getLeft(), str);
                } else if (col.get_enum() != null) {
                    replacementMap.put(node, col.getName());
                } else {
                    replacementMap.put(node.getLeft(), col.getName());
                }
            }
        } else if (node instanceof Greater || node instanceof Smaller || node instanceof NotGreater || node instanceof NotSmaller) {
            Integer days;
            java.util.Date obj;
            PseudoColumn col = this.findEnumNode(node.getLeft());
            if (col != null && col.getDateName() != null) {
                replacementMap.put(node.getLeft(), col.getName());
                obj = (java.util.Date)node.getRight().calculate(this.ctx);
                days = ObjectCache.getInteger((int)DateFactory.toDays((java.util.Date)obj));
                replacementMap.put(node.getRight(), days.toString());
            }
            if ((col = this.findEnumNode(node.getRight())) != null && col.getDateName() != null) {
                replacementMap.put(node.getRight(), col.getName());
                obj = (java.util.Date)node.getLeft().calculate(this.ctx);
                days = ObjectCache.getInteger((int)DateFactory.toDays((java.util.Date)obj));
                replacementMap.put(node.getLeft(), days.toString());
            }
        } else if (node instanceof Equals || node instanceof NotEquals) {
            Integer days;
            java.util.Date obj;
            Integer obj2;
            Sequence seq;
            PseudoColumn col = this.findEnumNode(node.getLeft());
            if (col != null) {
                if (col.get_enum() != null) {
                    seq = col.getList();
                    obj2 = seq.firstIndexOf(node.getRight().calculate(this.ctx));
                    replacementMap.put(node.getLeft(), col.getName());
                    replacementMap.put(node.getRight(), obj2.toString());
                } else if (col.getAlias() != null) {
                    replacementMap.put(node.getLeft(), col.getName());
                } else if (col.getDateName() != null) {
                    replacementMap.put(node.getLeft(), col.getName());
                    obj = (java.util.Date)node.getRight().calculate(this.ctx);
                    days = ObjectCache.getInteger((int)DateFactory.toDays((java.util.Date)obj));
                    replacementMap.put(node.getRight(), days.toString());
                }
            }
            if ((col = this.findEnumNode(node.getRight())) != null) {
                if (col.get_enum() != null) {
                    seq = col.getList();
                    obj2 = seq.firstIndexOf(node.getLeft().calculate(this.ctx));
                    replacementMap.put(node.getRight(), col.getName());
                    replacementMap.put(node.getLeft(), obj2.toString());
                } else if (col.getAlias() != null) {
                    replacementMap.put(node.getRight(), col.getName());
                } else if (col.getDateName() != null) {
                    replacementMap.put(node.getRight(), col.getName());
                    obj = (java.util.Date)node.getLeft().calculate(this.ctx);
                    days = ObjectCache.getInteger((int)DateFactory.toDays((java.util.Date)obj));
                    replacementMap.put(node.getLeft(), days.toString());
                }
            }
        } else if (node instanceof DotOperator) {
            if (node.getRight() instanceof Contain) {
                Object val;
                Contain contain = (Contain)node.getRight();
                IParam param = contain.getParam();
                if (param == null || !param.isLeaf()) {
                    return;
                }
                PseudoColumn col = null;
                Node containNode = param.getLeafExpression().getHome();
                if (containNode instanceof UnknownSymbol) {
                    UnknownSymbol un = (UnknownSymbol)param.getLeafExpression().getHome();
                    col = this.getPd().findColumnByPseudoName(un.getName());
                }
                if (col != null && col.getList() != null && (val = node.getLeft().calculate(this.ctx)) instanceof Sequence) {
                    replacementMap.put((Node)contain, "contain(" + col.getName() + ")");
                    Sequence value = (Sequence)val;
                    Sequence newValue = new Sequence();
                    int size = value.length();
                    int i = 1;
                    while (i <= size) {
                        Integer obj = col.getList().firstIndexOf(value.get(i));
                        newValue.add((Object)obj);
                        ++i;
                    }
                    replacementMap.put(node.getLeft(), newValue.toString());
                }
            }
        } else if (!(node instanceof Gather)) {
            if (node instanceof If) {
                IParam param = ((If)node).getParam();
                if (param != null) {
                    if (param.isLeaf()) {
                        this.gatherNodeReplacements(param.getLeafExpression().getHome(), replacementMap);
                    } else {
                        int n = param.getSubSize();
                        int i = 0;
                        while (i < n) {
                            Node sub = param.getSub(i).getLeafExpression().getHome();
                            this.gatherNodeReplacements(sub, replacementMap);
                            ++i;
                        }
                    }
                }
            } else {
                this.gatherNodeReplacements(node.getLeft(), replacementMap);
                this.gatherNodeReplacements(node.getRight(), replacementMap);
            }
        }
    }

    public String makeString(String src, Map<String, LocationInfo> map) {
        if (src == null || map == null || map.isEmpty()) {
            return src;
        }
        StringBuilder result = new StringBuilder(src);
        if (map.size() == 1) {
            Map.Entry<String, LocationInfo> entry = map.entrySet().iterator().next();
            result.replace(entry.getValue().location, entry.getValue().location + entry.getValue().len, entry.getKey());
        } else {
            ArrayList<Map.Entry<String, LocationInfo>> entries = new ArrayList<Map.Entry<String, LocationInfo>>(map.entrySet());
            entries.sort(new Comparator<Map.Entry<String, LocationInfo>>(){

                @Override
                public int compare(Map.Entry<String, LocationInfo> e1, Map.Entry<String, LocationInfo> e2) {
                    return e2.getValue().location - e1.getValue().location;
                }
            });
            for (Map.Entry entry : entries) {
                LocationInfo info = (LocationInfo)entry.getValue();
                result.replace(info.location, info.location + info.len, (String)entry.getKey());
            }
        }
        return result.toString();
    }

    @Override
    public Operable addOperation(Operation op, Context ctx) {
        if (op == null) {
            return this;
        }
        if (this.hasPseudoColumns) {
            if (op instanceof Select) {
                Expression exp = ((Select)op).getFilterExpression();
                ExpStrProcessor esp = new ExpStrProcessor(exp.toString());
                esp.parse(ctx);
                HashMap<Node, String> replacementMap = new HashMap<Node, String>();
                this.gatherNodeReplacements(esp.getHome(), replacementMap);
                if (replacementMap.size() > 0) {
                    HashMap<String, LocationInfo> replacementString = new HashMap<String, LocationInfo>();
                    for (Map.Entry entry : replacementMap.entrySet()) {
                        Node n = (Node)entry.getKey();
                        LocationInfo info = esp.getNodeInfo(n);
                        String s = (String)entry.getValue();
                        replacementString.put(s, info);
                    }
                    String expstr = this.makeString(exp.toString(), replacementString);
                    ((Select)op).setFltExp(new Expression(expstr));
                }
            } else {
                return super.addOperation(op, ctx);
            }
        }
        return super.addOperation(op, ctx);
    }

    private ICursor convertPseudoColumn(ICursor cursor, List<PseudoColumn> columns, String[] fields, Context ctx) {
        DataStruct ds = new DataStruct(fields);
        int size = ds.getFieldCount();
        Sequence seq = cursor.peek(1);
        BaseRecord rec = (BaseRecord)seq.get(1);
        DataStruct ds2 = rec.dataStruct();
        boolean isCompatible = true;
        int i = 0;
        while (i < size) {
            if (ds2.getFieldIndex(fields[i]) == -1) {
                isCompatible = false;
                break;
            }
            ++i;
        }
        if (ctx == null) {
            ctx = new Context();
        }
        Expression[] exps = new Expression[size];
        String[] names = new String[size];
        int c = 0;
        while (c < size) {
            exps[c] = new Expression(fields[c]);
            names[c] = fields[c];
            ++c;
        }
        if (isCompatible) {
            New _new = new New(exps, names, null);
            cursor.addOperation((Operation)_new, ctx);
            return cursor;
        }
        size = columns.size();
        c = 0;
        while (c < size) {
            PseudoColumn column = columns.get(c);
            String pseudoName = column.get_enum();
            Sequence bitNames = column.getBits();
            int idx = ds.getFieldIndex(column.getName());
            if (ds2.getFieldIndex(column.getName()) != -1) {
                exps[idx] = new Expression(column.getName());
                names[idx] = column.getName();
            } else if (column.getExp() != null) {
                exps[idx] = new Expression(column.getExp());
                names[idx] = column.getName();
            } else if (pseudoName != null && column.getList() != null) {
                String var = "pseudo_enum_value_" + c;
                ctx.setParamValue(var, (Object)column.getList());
                exps[idx] = new Expression(String.valueOf(var) + ".pos(" + pseudoName + ")");
                names[idx] = column.getName();
            } else if (bitNames != null) {
                String exp = "0";
                int len = bitNames.length();
                int i2 = 1;
                while (i2 <= len) {
                    String field = (String)bitNames.get(i2);
                    int bit = 1 << i2 - 1;
                    exp = String.valueOf(exp) + "+ if(" + field + "," + bit + ",0)";
                    ++i2;
                }
                exps[idx] = new Expression(exp);
                names[idx] = column.getName();
            }
            ++c;
        }
        seq = cursor.fetch(1);
        MemoryCursor cs0 = new MemoryCursor(seq);
        cursor = new ConjxCursor(new ICursor[]{cs0, cursor});
        New _new = new New(exps, names, null);
        cursor.addOperation((Operation)_new, ctx);
        return cursor;
    }

    @Override
    public void append(ICursor cursor, String option, Context ctx) {
        List<IPhyTable> tables = this.getPd().getTables();
        IPhyTable table = null;
        boolean flag = true;
        int size = tables.size();
        if (size == 0) {
            return;
        }
        if (option != null && option.indexOf("y") != -1) {
            table = tables.get(0);
            flag = false;
        } else if (size == 1) {
            table = tables.get(0);
        } else {
            if (!(cursor instanceof MultipathCursors)) {
                option = option == null ? "x" : String.valueOf(option) + "x";
            }
            table = this.getPd().getTableMetaDataGroup();
        }
        List<PseudoColumn> columns = this.pd.getColumns();
        if (columns != null) {
            String[] fields = table.getAllColNames();
            cursor = this.convertPseudoColumn(cursor, columns, fields, ctx);
        }
        try {
            if (flag) {
                option = option == null ? "i" : String.valueOf(option) + "i";
            }
            table.append(cursor, option);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    public void update(ICursor cursor, String opt, Context ctx) {
        List<IPhyTable> tables = this.getPd().getTables();
        IPhyTable table = tables.get(0);
        List<PseudoColumn> columns = this.pd.getColumns();
        if (columns != null) {
            String[] fields = table.getAllColNames();
            cursor = this.convertPseudoColumn(cursor, columns, fields, ctx);
        }
        try {
            if (opt != null && opt.indexOf(105) != -1) {
                opt = opt.replace("i", "");
            }
            ((ColPhyTable)table).update(cursor, opt);
        }
        catch (IOException e) {
            throw new RQException((Throwable)e);
        }
    }

    @Override
    public Sequence update(Sequence data, String opt) {
        ColPhyTable colTable;
        List<IPhyTable> tables = this.getPd().getTables();
        int size = tables.size();
        if (size == 0) {
            return null;
        }
        IPhyTable table = tables.get(size - 1);
        if (table instanceof ColPhyTable && !(colTable = (ColPhyTable)table).getGroupTable().isPureFormat()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.oldVersion2"));
        }
        List<PseudoColumn> columns = this.pd.getColumns();
        if (columns != null) {
            String[] fields = table.getAllColNames();
            MemoryCursor cursor = new MemoryCursor(data);
            cursor = this.convertPseudoColumn((ICursor)cursor, columns, fields, this.ctx);
            data = cursor.fetch();
        }
        try {
            return table.update(data, opt);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(ICursor cursor, String opt) {
        ColPhyTable colTable;
        List<IPhyTable> tables = this.getPd().getTables();
        int size = tables.size();
        if (size == 0) {
            return;
        }
        IPhyTable table = tables.get(size - 1);
        if (table instanceof ColPhyTable && !(colTable = (ColPhyTable)table).getGroupTable().isPureFormat()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.oldVersion2"));
        }
        List<PseudoColumn> columns = this.pd.getColumns();
        if (columns != null) {
            String[] fields = table.getAllColNames();
            cursor = this.convertPseudoColumn(cursor, columns, fields, this.ctx);
        }
        try {
            ((ColPhyTable)table).update(cursor, opt);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Sequence delete(Sequence data, String opt) {
        List<IPhyTable> tables = this.getPd().getTables();
        int size = tables.size();
        if (size == 0) {
            return null;
        }
        Sequence result = null;
        for (IPhyTable table : tables) {
            try {
                result = table.delete(data, opt);
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public String[] getFieldNames() {
        return this.getPd().getAllColNames();
    }

    protected static byte getProperDataType(Object value) {
        if (value instanceof String) {
            return 11;
        }
        if (value instanceof Double || value instanceof Float) {
            return 6;
        }
        if (value instanceof Integer) {
            return 1;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
            return 2;
        }
        if (value instanceof Time) {
            return 9;
        }
        if (value instanceof Timestamp) {
            return 10;
        }
        if (value instanceof Date) {
            return 8;
        }
        if (value instanceof BigDecimal) {
            return 7;
        }
        if (value instanceof Boolean) {
            return 12;
        }
        return 11;
    }

    public byte[] getFieldTypes() {
        Sequence data;
        if (this.getPd().isBFile()) {
            data = this.getPd().getMemoryTable();
        } else {
            List<IPhyTable> tables = this.getPd().getTables();
            ICursor cursor = tables.get(0).cursor(null, null, null, null, null, null, 1, null, this.ctx);
            data = cursor.fetch(1);
            cursor.close();
        }
        if (data == null || data.length() == 0) {
            return null;
        }
        BaseRecord record = (BaseRecord)data.getMem(1);
        Object[] objs = record.getFieldValues();
        int len = objs.length;
        byte[] types = new byte[len];
        int i = 0;
        while (i < len) {
            types[i] = PseudoTable.getProperDataType(objs[i]);
            ++i;
        }
        return types;
    }

    public Operable join(Function function, String fname, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        if (opt != null) {
            opt.equals("i");
        }
        if (this.hasV) {
            com.scudata.pdm.op.Join op = new com.scudata.pdm.op.Join(function, fname, exps, codes, dataExps, newExps, newNames, opt);
            return this.addOperation((Operation)op, ctx);
        }
        Join op = new Join(function, fname, exps, codes, dataExps, newExps, newNames, opt);
        return this.addOperation((Operation)op, ctx);
    }

    public Operable pjoin(Function function, Expression[] srcKeyExps, Expression[] srcNewExps, String[] srcNewNames, ICursor[] cursors, String[] options, Expression[][] keyExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        if (this.hasV) {
            PrimaryJoin op = new PrimaryJoin(function, srcKeyExps, srcNewExps, srcNewNames, cursors, options, keyExps, newExps, newNames, opt, ctx);
            return this.addOperation(op, ctx);
        }
        com.scudata.dm.op.PrimaryJoin op = new com.scudata.dm.op.PrimaryJoin(function, srcKeyExps, srcNewExps, srcNewNames, cursors, options, keyExps, newExps, newNames, opt, ctx);
        return this.addOperation((Operation)op, ctx);
    }

    public String parserExp(String expStr) {
        ExpStrProcessor esp = new ExpStrProcessor(expStr);
        esp.parse(this.ctx);
        HashMap<Node, String> replacementMap = new HashMap<Node, String>();
        this.gatherNodeReplacements(esp.getHome(), replacementMap);
        if (replacementMap.size() > 0) {
            HashMap<String, LocationInfo> replacementString = new HashMap<String, LocationInfo>();
            for (Map.Entry entry : replacementMap.entrySet()) {
                Node n = (Node)entry.getKey();
                LocationInfo info = esp.getNodeInfo(n);
                String s = (String)entry.getValue();
                replacementString.put(s, info);
            }
            return this.makeString(expStr, replacementString);
        }
        return null;
    }
}

