/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server;

import com.scudata.app.common.Section;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Logger;
import com.scudata.common.SplServerConfig;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.PerfMonitor;
import com.scudata.parallel.ProxyMonitor;
import com.scudata.parallel.Request;
import com.scudata.parallel.Response;
import com.scudata.parallel.Task;
import com.scudata.parallel.TaskManager;
import com.scudata.parallel.TempFileMonitor;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitContext;
import com.scudata.resources.ParallelMessage;
import com.scudata.server.StartUnitListener;
import com.scudata.server.unit.UnitServer;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;

public class UnitServerImpl
extends UnitServer {
    ServerSocket serverSocket = null;
    UnitContext unitContext = null;
    TempFileMonitor tempFileMonitor = null;
    ProxyMonitor proxyMonitor;
    private volatile boolean stop = true;
    private String specifyHost = null;
    private int specifyPort = 0;
    StartUnitListener listener = null;
    HostManager hostManager = HostManager.instance();
    private RaqsoftConfig rc = null;
    private static Object initLock = new Object();
    private static Response initResult = new Response();
    boolean isQuit = false;

    public void setRaqsoftConfig(RaqsoftConfig rc) {
        this.rc = rc;
    }

    public RaqsoftConfig getRaqsoftConfig() {
        return this.rc;
    }

    public void setStartUnitListener(StartUnitListener listen) {
        this.listener = listen;
    }

    public UnitContext getUnitContext() {
        return this.unitContext;
    }

    private UnitServerImpl() {
    }

    private UnitServerImpl(String host, int port) throws Exception {
        this.specifyHost = host;
        this.specifyPort = port;
    }

    private String getArgDesc(List argValues) {
        if (argValues == null || argValues.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < argValues.size()) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(argValues.get(i));
            ++i;
        }
        return sb.toString();
    }

    public Response execute(Request req) {
        Response res = new Response();
        switch (req.getAction()) {
            case 2: {
                List list = TaskManager.getTaskList();
                Table table = new Table(new String[]{"Port", "TaskId", "SPLXName", "ArgDesc", "BeginTime", "FinishTime"});
                int i = 0;
                while (i < list.size()) {
                    Task t = (Task)list.get(i);
                    if (t.getFinishTime() <= 0L && !t.isProcessCaller()) {
                        table.newLast(new Object[]{this.hostManager.getPort(), new Integer(t.getTaskID()), t.getDfxName(), this.getArgDesc(t.getArgList()), new Long(t.getCallTime()), new Long(t.getFinishTime())});
                    }
                    ++i;
                }
                res.setResult((Object)table);
                break;
            }
            case 5: {
                Table tableParam = new Table(new String[]{"Port", "SpaceName", "ParamName", "ParamValue"});
                HashMap hm = JobSpaceManager.listSpaceParams();
                for (String id : hm.keySet()) {
                    Param[] params = (Param[])hm.get(id);
                    if (params == null) continue;
                    int i = 0;
                    while (i < params.length) {
                        Param p = params[i];
                        tableParam.newLast(new Object[]{this.hostManager.getPort(), id, p.getName(), p.getValue()});
                        ++i;
                    }
                }
                ParamList gList = Env.getParamList();
                int i = 0;
                while (i < gList.count()) {
                    Param p = gList.get(i);
                    tableParam.newLast(new Object[]{this.hostManager.getPort(), "Global", p.getName(), p.getValue()});
                    ++i;
                }
                res.setResult((Object)tableParam);
                break;
            }
            case 50: {
                int maxNum = this.hostManager.getMaxTaskNum();
                res.setResult((Object)maxNum);
                break;
            }
            case 1: {
                if (this.listener != null) {
                    this.listener.doStop();
                    break;
                }
                this.shutDown();
                break;
            }
            case 4: {
                int[] result = new int[]{this.hostManager.getPreferredTaskNum(), this.hostManager.getCurrentTasks()};
                res.setResult((Object)result);
                break;
            }
            case 54: {
                String J = (String)req.getAttr("Task name");
                res.setResult((Object)Env.getAreaNo((String)J));
                break;
            }
            case 6: {
                res.setResult((Object)new Integer(PerfMonitor.getConcurrentTasks()));
                break;
            }
            case 10: {
                String spaceId = (String)req.getAttr("Space id");
                JobSpaceManager.closeSpace((String)spaceId);
                break;
            }
            case 22: {
                try {
                    String spaceId = (String)req.getAttr("Space id");
                    String tableName = (String)req.getAttr("Table name");
                    Sequence tableObj = UnitClient.getMemoryTable((String)spaceId, (String)tableName, (String)this.unitContext.toString());
                    res.setResult((Object)new Integer(tableObj.length()));
                    break;
                }
                catch (Exception x) {
                    res.setException(x);
                }
            }
        }
        return res;
    }

    public static UnitServer getInstance() throws Exception {
        return UnitServerImpl.getInstance(null, 0);
    }

    public static UnitServer getInstance(String specifyHost, int specifyPort) throws Exception {
        if (!StringUtils.isValidString((Object)UnitServerImpl.getHome())) {
            throw new Exception(ParallelMessage.get().getMessage("UnitServer.nohome"));
        }
        if (instance == null) {
            instance = new UnitServerImpl(specifyHost, specifyPort);
        }
        return instance;
    }

    public static UnitServer getInstance(String host, int port, String cfgPath) throws Exception {
        if (instance == null) {
            UnitServerImpl usi = new UnitServerImpl(host, port);
            FileInputStream is = new FileInputStream(cfgPath);
            SplServerConfig ssc = SplServerConfig.getCfg((InputStream)is);
            ((InputStream)is).close();
            usi.unitContext = new UnitContext(ssc);
            usi.rc = usi.unitContext.getRaqsoftConfig();
            usi.hostManager.setHost(host);
            usi.hostManager.setPort(port);
            instance = usi;
        }
        return instance;
    }

    public void checkContext() throws Exception {
        if (this.unitContext == null) {
            this.unitContext = new UnitContext(this.specifyHost, this.specifyPort);
            this.unitContext.setRaqsoftConfig(this.rc);
        }
    }

    public static Response init(int i, int N, String j) {
        return UnitServerImpl.init(i, N, j, true);
    }

    private static void outputInitMsg() {
        Exception x = initResult.getException();
        if (x != null) {
            Logger.debug((Object)x.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response init(final int i, final int N, final String j, final boolean waitResult) {
        String dfx = "init.splx";
        Object object = initLock;
        synchronized (object) {
            if (isIniting) {
                initResult.setException(new Exception("UnitServer is initing, please try again later."));
                if (!waitResult) {
                    UnitServerImpl.outputInitMsg();
                }
                return initResult;
            }
            FileObject fo = new FileObject("init.splx", "s");
            if (!fo.isExists()) {
                initResult.setException(new Exception("init.splx is not exists."));
                if (!waitResult) {
                    UnitServerImpl.outputInitMsg();
                }
                return initResult;
            }
            initResult.setException(null);
            isIniting = true;
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int intId = UnitServer.nextId();
                String msg = "init(" + i + "," + N + "," + j + ") ";
                Logger.debug((Object)(String.valueOf(msg) + "begin."));
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(i);
                args.add(N);
                args.add(j);
                String spaceId = UUID.randomUUID().toString();
                Task task = new Task((Object)"init.splx", args, intId, spaceId);
                initResult = task.execute();
                Logger.debug((Object)(String.valueOf(msg) + " finished."));
                Object object = initLock;
                synchronized (object) {
                    isIniting = false;
                }
                if (!waitResult) {
                    UnitServerImpl.outputInitMsg();
                }
            }
        };
        t.start();
        if (waitResult) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                initResult.setException((Exception)e);
            }
        }
        return initResult;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized boolean isRunning() {
        return !this.stop;
    }

    private synchronized void setStop(boolean b, int port) {
        this.stop = b;
        if (!this.stop && this.listener != null) {
            this.listener.serverStarted(port);
        }
    }

    public void quit() {
        this.isQuit = true;
    }

    public void shutDown() {
        this.stop = true;
    }

    public static void main(String[] args) {
        try {
            String buf;
            String specifyHost = null;
            int specifyPort = 0;
            Section sect = new Section();
            int i = 0;
            while (i < args.length) {
                buf = args[i];
                if (buf.indexOf(" ") > -1) {
                    StringTokenizer st = new StringTokenizer(buf, " ");
                    while (st.hasMoreTokens()) {
                        sect.addSection(st.nextToken());
                    }
                } else {
                    sect.addSection(buf);
                }
                ++i;
            }
            args = sect.toStringArray();
            i = 0;
            while (i < args.length) {
                buf = args[i];
                int index = buf.lastIndexOf(58);
                if (index > 0 && specifyHost == null) {
                    specifyHost = buf.substring(0, index).trim();
                    specifyPort = Integer.parseInt(buf.substring(index + 1).trim());
                }
                ++i;
            }
            UnitServer server = UnitServerImpl.getInstance(specifyHost, specifyPort);
            server.run();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        System.exit(0);
    }

    public String getHost() {
        return this.unitContext.toString();
    }

    public String getIP() {
        return this.unitContext.getLocalHost();
    }

    public boolean isAutoStart() {
        try {
            this.checkContext();
            return this.unitContext.isAutoStart();
        }
        catch (Exception x) {
            return false;
        }
    }
}

