/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.trial.optimize;

import com.scudata.trial.optimize.ParamType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLineParser {
    private List<String> cells = new ArrayList<String>();
    private List<String> codes = new ArrayList<String>();
    private Map<String, ParamType> variableTypes = new ConcurrentHashMap<String, ParamType>();

    public CommandLineParser(String input) {
        String[] lines;
        input = input.replaceAll("\r", "");
        input = input.replaceAll("\n", "");
        String[] stringArray = lines = input.split(";");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null) {
                if (line.indexOf("-code") != -1) {
                    this.parseCode(line);
                } else if (line.indexOf("-type") != -1) {
                    this.parseType2(line);
                } else if (line.contains(":") && !line.contains("(")) {
                    this.parseType(line);
                }
            }
            ++n2;
        }
    }

    public List<String> getCells() {
        return this.cells;
    }

    public void setCells(List<String> cells) {
        this.cells = cells;
    }

    public List<String> getCodes() {
        return this.codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public Map<String, ParamType> getVariableTypes() {
        return this.variableTypes;
    }

    public void setVariableTypes(Map<String, ParamType> variableTypes) {
        this.variableTypes = variableTypes;
    }

    private void parseCode(String line) {
        String pattern = "-code \"([^\"]*)\"";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(line);
        if (m.find()) {
            this.codes.add(m.group(1));
        }
    }

    private static String[] getColumns(String input) {
        int startIndex = input.indexOf("{");
        int endIndex = input.indexOf("}");
        if (startIndex == -1 || endIndex == -1 || startIndex >= endIndex) {
            throw new IllegalArgumentException("\u8f93\u5165\u5b57\u7b26\u4e32\u683c\u5f0f\u9519\u8bef\uff0c'{' \u548c '}' \u4e0d\u5339\u914d\u3002");
        }
        String columnsStr = input.substring(startIndex + 1, endIndex);
        return columnsStr.split(",");
    }

    private void parseType(String line) {
        String[] parts = line.split(":");
        if (parts.length == 2) {
            String[] variableNames;
            String type = parts[1];
            String[] columns = null;
            if (type.startsWith("table{") && type.indexOf("}") != -1) {
                columns = CommandLineParser.getColumns(type);
                type = "table";
            }
            String[] stringArray = variableNames = parts[0].split(",");
            int n = variableNames.length;
            int n2 = 0;
            while (n2 < n) {
                String variableName = stringArray[n2];
                Integer ty = Integer.MAX_VALUE;
                if (type.equals("int")) {
                    ty = 1;
                } else if (type.equals("long")) {
                    ty = 2;
                } else if (type.equals("double")) {
                    ty = 3;
                } else if (type.equals("float")) {
                    ty = 3;
                } else if (type.equals("bool") || type.equals("boolean")) {
                    ty = 4;
                } else if (type.equals("table")) {
                    ty = 5;
                }
                ParamType pt = new ParamType(ty, variableName, columns);
                this.variableTypes.put(variableName, pt);
                ++n2;
            }
        }
    }

    private void parseType2(String line) {
        String pattern = "-type ([^:]+):([^:]+)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(line);
        if (m.find()) {
            String[] variables;
            String variablesStr = m.group(1);
            String type = m.group(2);
            String[] columns = null;
            if (type.startsWith("table{") && type.indexOf("}") != -1) {
                columns = CommandLineParser.getColumns(type);
                type = "table";
            }
            Integer ty = Integer.MAX_VALUE;
            if (type.equals("int")) {
                ty = 1;
            } else if (type.equals("long")) {
                ty = 2;
            } else if (type.equals("double")) {
                ty = 3;
            } else if (type.equals("float")) {
                ty = 3;
            } else if (type.equals("bool") || type.equals("boolean")) {
                ty = 4;
            }
            String[] stringArray = variables = variablesStr.split(",");
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                String variable = stringArray[n2];
                ParamType pt = new ParamType(ty, variable, columns);
                this.variableTypes.put(variable.trim(), pt);
                ++n2;
            }
        }
    }
}

