/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.trial.optimize;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.compile.CodeCompiler;
import com.scudata.compile.CompilerUtil;
import com.scudata.compile.DataType;
import com.scudata.compile.SplxCompiler;
import com.scudata.compile.VarItem;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldRef;
import com.scudata.expression.FunctionLib;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.Operator;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.VarParam;
import com.scudata.expression.fn.math.Cos;
import com.scudata.expression.fn.math.Pow;
import com.scudata.expression.fn.math.Sin;
import com.scudata.expression.fn.math.Sqrt;
import com.scudata.expression.mfn.sequence.Derive;
import com.scudata.expression.mfn.sequence.Select;
import com.scudata.expression.operator.Add;
import com.scudata.expression.operator.And;
import com.scudata.expression.operator.Divide;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.Multiply;
import com.scudata.expression.operator.NotEquals;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Smaller;
import com.scudata.expression.operator.Subtract;
import com.scudata.trial.optimize.CommandLineParser;
import com.scudata.trial.optimize.NodeInfo;
import com.scudata.trial.optimize.ParamType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class Optimizer {
    public static final int TYPE_INT = 1;
    public static final int TYPE_LONG = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_BOOL = 4;
    public static final int TYPE_TABLE = 5;
    public static final int TYPE_OBJECT = 6;
    public static final int TYPE_NONE = Integer.MAX_VALUE;
    public static final String[] TYPE_NAMES = new String[]{"", "int", "long", "double", "boolean", "Table", "Object", ""};

    public static Object compile(String fp, String arg) {
        String[] args = new String[]{};
        if (arg != null) {
            args = arg.split(" ");
        }
        return SplxCompiler.compile(fp, args);
    }

    public static Object run(PgmCellSet cellSet) {
        return cellSet.execute();
    }

    public static PgmCellSet open(String file) {
        if (file.endsWith(".splb")) {
            return SplxCompiler.open(file);
        }
        if (file.endsWith(".splx")) {
            return Optimizer.openSplx(file);
        }
        return null;
    }

    public static PgmCellSet openSplx(String file) {
        int cnt = 0;
        try {
            PgmCellSet cellSet = AppUtil.readCellSet((String)file);
            int col = cellSet.getColCount();
            int row = cellSet.getRowCount();
            int r = 1;
            while (r <= row) {
                int c = 1;
                while (c <= col) {
                    String tip;
                    PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                    if (cell.getExpression() != null && cell.getExpString() != null && (tip = cell.getTip()) != null) {
                        CommandLineParser parser = new CommandLineParser(tip);
                        List<String> codes = parser.getCodes();
                        Map<String, ParamType> types = parser.getVariableTypes();
                        if (types.size() > 0) {
                            if (codes.size() > 0) {
                                for (String code : parser.getCodes()) {
                                    if (cell.getExpString().indexOf(code) == -1) continue;
                                    cnt += Optimizer.parse(cell, code, types);
                                }
                            } else {
                                cnt += Optimizer.parse(cell, types);
                            }
                        }
                    }
                    ++c;
                }
                ++r;
            }
            System.out.println("Optimization done! Number of optimized items: " + cnt);
            return cellSet;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ConcurrentHashMap<String, Integer> getTypes(String typeStr) {
        String[] lines;
        ConcurrentHashMap<String, Integer> types = new ConcurrentHashMap<String, Integer>();
        typeStr = typeStr.replaceAll("\r", "");
        typeStr = typeStr.replaceAll("\n", "");
        String[] stringArray = lines = typeStr.split(";");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] subs;
            String line = stringArray[n2];
            if (line != null && !line.contains("(") && (subs = line.split(":")).length == 2 && subs[0] != null && subs[1] != null) {
                Integer ty = null;
                if (subs[1].equals("int")) {
                    ty = 1;
                } else if (subs[1].equals("long")) {
                    ty = 2;
                } else if (subs[1].equals("double")) {
                    ty = 3;
                } else if (subs[1].equals("bool") || subs[1].equals("boolean")) {
                    ty = 4;
                }
                if (ty != null) {
                    types.put(subs[0], ty);
                }
            }
            ++n2;
        }
        return types;
    }

    private static int countSubstringOccurrences(String str, String subStr) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(subStr, index)) != -1) {
            ++count;
            index += subStr.length();
        }
        return count;
    }

    private static int parse(PgmNormalCell cell, String code, Map<String, ParamType> types) {
        if (types == null) {
            return 0;
        }
        String expStr = cell.getExpString();
        try {
            int num;
            Expression e = new Expression(code);
            String nodeStr = Optimizer.compile(e, types);
            if (nodeStr != null && (num = Optimizer.countSubstringOccurrences(expStr, code)) > 0) {
                expStr = expStr.replaceAll(Pattern.quote(code), nodeStr);
            }
        }
        catch (Exception e) {
            return 0;
        }
        cell.setExpString(expStr);
        return 1;
    }

    private static int parse(PgmNormalCell cell, Map<String, ParamType> types) {
        Expression exp = cell.getExpression();
        if (types == null) {
            return 0;
        }
        int cnt = 0;
        String expStr = cell.getExpString();
        try {
            ArrayList<Expression> list = new ArrayList<Expression>();
            Optimizer.getExps2(exp, list, types);
            for (Expression e : list) {
                int num;
                String str = e.getIdentifierName();
                String nodeStr = Optimizer.compile(e, types);
                if (nodeStr == null || (num = Optimizer.countSubstringOccurrences(expStr, str)) <= 0) continue;
                expStr = expStr.replaceAll(Pattern.quote(str), nodeStr);
                ++cnt;
            }
        }
        catch (Exception e) {
            return 0;
        }
        cell.setExpString(expStr);
        return cnt;
    }

    public static void getExps(Expression exp, List<Expression> list) {
        Optimizer.getSubExps(exp.getHome(), list);
        list.add(exp);
    }

    private static void getExps2(Expression exp, List<Expression> list, Map<String, ParamType> types) {
        Optimizer.getSubExps2(exp.getHome(), list, types);
        list.add(exp);
    }

    private static void getSubExps(Node node, List<Expression> list) {
        if (node instanceof Operator) {
            Optimizer.getSubExps(node.getLeft(), list);
            Optimizer.getSubExps(node.getRight(), list);
        } else if (node instanceof Derive) {
            Expression[] exps2;
            Derive derive = (Derive)node;
            IParam param = derive.getParam();
            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
            Expression[] expressionArray = exps2 = pi.getExpressions1();
            int n = exps2.length;
            int n2 = 0;
            while (n2 < n) {
                Expression exp = expressionArray[n2];
                Optimizer.getSubExps(exp.getHome(), list);
                list.add(exp);
                ++n2;
            }
        } else if (node instanceof Select) {
            String opt = ((Select)node).getOption();
            if (opt == null) {
                Expression[] exps;
                Expression[] expressionArray = exps = ((Select)node).getParamExpressions(null, false);
                int exp = exps.length;
                int exps2 = 0;
                while (exps2 < exp) {
                    Expression exp2 = expressionArray[exps2];
                    Optimizer.getSubExps(exp2.getHome(), list);
                    list.add(exp2);
                    ++exps2;
                }
            }
        } else if (node instanceof Sqrt) {
            Sqrt sqrt = (Sqrt)node;
            IParam param = sqrt.getParam();
            if (param.isLeaf()) {
                Expression param1 = param.getLeafExpression();
                Optimizer.getSubExps(param1.getHome(), list);
                list.add(param1);
            } else {
                IParam sub0 = param.getSub(0);
                IParam sub1 = param.getSub(1);
                Expression param1 = sub0.getLeafExpression();
                Expression param2 = sub1.getLeafExpression();
                Optimizer.getSubExps(param1.getHome(), list);
                list.add(param1);
                Optimizer.getSubExps(param2.getHome(), list);
                list.add(param2);
            }
        } else if (node instanceof Pow) {
            Pow pow = (Pow)node;
            IParam param = pow.getParam();
            if (param.isLeaf()) {
                Expression param1 = param.getLeafExpression();
                Optimizer.getSubExps(param1.getHome(), list);
                list.add(param1);
            } else {
                IParam sub0 = param.getSub(0);
                IParam sub1 = param.getSub(1);
                Expression param1 = sub0.getLeafExpression();
                Expression param2 = sub1.getLeafExpression();
                Optimizer.getSubExps(param1.getHome(), list);
                list.add(param1);
                Optimizer.getSubExps(param2.getHome(), list);
                list.add(param2);
            }
        } else if (node instanceof Sin) {
            Sin sin = (Sin)node;
            IParam param = sin.getParam();
            Expression param1 = param.getLeafExpression();
            Optimizer.getSubExps(param1.getHome(), list);
            list.add(param1);
        } else if (node instanceof Cos) {
            Cos cos = (Cos)node;
            IParam param = cos.getParam();
            Expression param1 = param.getLeafExpression();
            Optimizer.getSubExps(param1.getHome(), list);
            list.add(param1);
        }
    }

    private static void getSubExps2(Node node, List<Expression> list, Map<String, ParamType> types) {
        block4: {
            Expression[] exps;
            String opt;
            block5: {
                Expression[] exps2;
                block3: {
                    if (!(node instanceof Operator)) break block3;
                    Optimizer.getSubExps2(node.getLeft(), list, types);
                    Optimizer.getSubExps2(node.getRight(), list, types);
                    break block4;
                }
                if (!(node instanceof Derive)) break block5;
                Derive derive = (Derive)node;
                IParam param = derive.getParam();
                ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
                Expression[] expressionArray = exps2 = pi.getExpressions1();
                int n = exps2.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression exp = expressionArray[n2];
                    Optimizer.getSubExps2(exp.getHome(), list, types);
                    list.add(exp);
                    ++n2;
                }
                break block4;
            }
            if (!(node instanceof Select) || (opt = ((Select)node).getOption()) != null) break block4;
            Expression[] expressionArray = exps = ((Select)node).getParamExpressions(null, false);
            int n = exps.length;
            int n3 = 0;
            while (n3 < n) {
                Expression exp = expressionArray[n3];
                if (exp.getHome() instanceof Operator) {
                    list.add(exp);
                }
                ++n3;
            }
        }
    }

    private static int getType(String var, Map<String, ParamType> types) {
        if (types.containsKey(var)) {
            return types.get(var).getType();
        }
        if (types.containsKey("default")) {
            return types.get("default").getType();
        }
        return Integer.MAX_VALUE;
    }

    public static int getNodeType(Node node, Map<String, ParamType> types) {
        String name = Optimizer.getVarName(node);
        if (name != null) {
            return Optimizer.getType(name, types);
        }
        if (node instanceof DotOperator && node.getRight() instanceof FieldRef && (name = ((FieldRef)node.getRight()).getName()) != null) {
            return Optimizer.getType(name, types);
        }
        if (node instanceof Operator) {
            int t1 = Optimizer.getNodeType(node.getLeft(), types);
            int t2 = Optimizer.getNodeType(node.getRight(), types);
            return Integer.max(t1, t2);
        }
        if (node instanceof Sqrt || node instanceof Sin || node instanceof Cos) {
            return 3;
        }
        if (node instanceof Pow) {
            IParam param = ((Pow)node).getParam();
            if (param.isLeaf()) {
                return Optimizer.getNodeType(param.getLeafExpression().getHome(), types);
            }
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    private static String getVarName(UnknownSymbol us) {
        return us.getName();
    }

    private static String getVarName(VarParam vp) {
        return vp.getParam().getName();
    }

    private static String getVarName(Node node) {
        if (node instanceof UnknownSymbol) {
            return Optimizer.getVarName((UnknownSymbol)node);
        }
        if (node instanceof CSVariable) {
            return Optimizer.getVarName((Node)((CSVariable)node));
        }
        if (node instanceof VarParam) {
            return Optimizer.getVarName((VarParam)node);
        }
        return null;
    }

    public static String compile(Expression exp, Map<String, ParamType> types) {
        String newExpStr;
        Node home = exp.getHome();
        NodeInfo info = new NodeInfo();
        if (home instanceof DotOperator) {
            Node right = home.getRight();
            boolean cfr_ignored_0 = right instanceof Derive;
        }
        if (home instanceof Operator) {
            int t2;
            Node left = home.getLeft();
            Node right = home.getRight();
            int t1 = Optimizer.getNodeType(left, types);
            int t = Integer.max(t1, t2 = Optimizer.getNodeType(right, types));
            if (t > 6) {
                return null;
            }
            newExpStr = Optimizer.parseNode(home, t, info);
        } else {
            int t = Optimizer.getNodeType(home, types);
            newExpStr = Optimizer.parseNode(home, t, info);
        }
        info.setExp(newExpStr);
        Class<?> cls = Optimizer.compile(info);
        if (cls == null) {
            return null;
        }
        FunctionLib.addFunction((String)cls.getSimpleName(), cls);
        return String.valueOf(info.getClassName()) + "()";
    }

    private static String parseNode(Node node, int type, NodeInfo info) {
        String name;
        IParam sub0;
        String s;
        IParam param;
        String s2;
        if (node instanceof Operator) {
            if (node instanceof DotOperator) {
                String right = Optimizer.parseNode(node.getRight(), type, info);
                String left = node.getRight() instanceof FieldRef ? Optimizer.parseNode(node.getLeft(), type, null) : Optimizer.parseNode(node.getLeft(), type, info);
                String name2 = String.valueOf(left) + "__" + right;
                String nodeName = String.valueOf(name2) + "_Node";
                String typeName = TYPE_NAMES[type];
                VarItem var = new VarItem(name2, new DataType(typeName), "(" + Optimizer.upperFirstChar(typeName) + ")" + nodeName + ".calculate(ctx)");
                VarItem nodeVar = new VarItem(nodeName, null, String.valueOf(left) + "." + right);
                if (info != null) {
                    info.addLocalVar(var);
                    info.addNodeVar(nodeVar);
                }
                return name2;
            }
            String left = Optimizer.parseNode(node.getLeft(), type, info);
            String right = Optimizer.parseNode(node.getRight(), type, info);
            if (node instanceof Equals) {
                if (type == 1) {
                    return String.valueOf(left) + "==" + right;
                }
                if (type == 2) {
                    return String.valueOf(left) + "==" + right;
                }
                if (type == 3) {
                    return "Double.compare(" + left + ", " + right + ")==0";
                }
            } else if (node instanceof NotEquals) {
                if (type == 1) {
                    return String.valueOf(left) + "!=" + right;
                }
                if (type == 2) {
                    return String.valueOf(left) + "!=" + right;
                }
                if (type == 3) {
                    return "Double.compare(" + left + ", " + right + ")!=0";
                }
            } else {
                if (node instanceof Greater) {
                    return String.valueOf(left) + ">" + right;
                }
                if (node instanceof Smaller) {
                    return String.valueOf(left) + "<" + right;
                }
                if (node instanceof NotGreater) {
                    if (type == 1) {
                        return String.valueOf(left) + "<=" + right;
                    }
                    if (type == 2) {
                        return String.valueOf(left) + "<=" + right;
                    }
                    if (type == 3) {
                        return String.valueOf(left) + "<=" + right;
                    }
                } else if (node instanceof NotSmaller) {
                    if (type == 1) {
                        return String.valueOf(left) + ">=" + right;
                    }
                    if (type == 2) {
                        return String.valueOf(left) + ">=" + right;
                    }
                    if (type == 3) {
                        return String.valueOf(left) + ">=" + right;
                    }
                } else {
                    if (node instanceof Add) {
                        return "(" + left + ")+(" + right + ")";
                    }
                    if (node instanceof Multiply) {
                        return "(" + left + ")*(" + right + ")";
                    }
                    if (node instanceof Divide) {
                        if (type == 1) {
                            return "((double)" + left + ")/" + "((double)" + right + ")";
                        }
                        if (type == 2) {
                            return "((double)" + left + ")/" + "((double)" + right + ")";
                        }
                        if (type == 3) {
                            return "(" + left + ")/(" + right + ")";
                        }
                    } else {
                        if (node instanceof Subtract) {
                            return "(" + left + ")-(" + right + ")";
                        }
                        if (node instanceof And) {
                            return "(" + left + ")&&(" + right + ")";
                        }
                    }
                }
            }
        }
        if (node instanceof Sin) {
            s2 = Optimizer.parseNode(((Sin)node).getParam().getLeafExpression().getHome(), type, info);
            return "Math.sin(" + s2 + ")";
        }
        if (node instanceof Cos) {
            s2 = Optimizer.parseNode(((Cos)node).getParam().getLeafExpression().getHome(), type, info);
            return "Math.cos(" + s2 + ")";
        }
        if (node instanceof Sqrt) {
            param = ((Sqrt)node).getParam();
            if (param.isLeaf()) {
                s = Optimizer.parseNode(param.getLeafExpression().getHome(), type, info);
                return "Math.sqrt(" + s + ")";
            }
            sub0 = param.getSub(0);
            IParam sub1 = param.getSub(1);
            String s0 = Optimizer.parseNode(sub0.getLeafExpression().getHome(), type, info);
            String s1 = Optimizer.parseNode(sub1.getLeafExpression().getHome(), type, info);
            if (type != 3) {
                s1 = "(double)" + s1;
            }
            return "Math.pow(" + s0 + ",1 / (" + s1 + "))";
        }
        if (node instanceof Pow) {
            param = ((Pow)node).getParam();
            if (param.isLeaf()) {
                s = Optimizer.parseNode(param.getLeafExpression().getHome(), type, info);
                return String.valueOf(s) + "*" + s;
            }
            sub0 = param.getSub(0);
            IParam sub1 = param.getSub(1);
            String s0 = Optimizer.parseNode(sub0.getLeafExpression().getHome(), type, info);
            String s1 = Optimizer.parseNode(sub1.getLeafExpression().getHome(), type, info);
            return "Math.pow(" + s0 + "," + s1 + ")";
        }
        if (node instanceof UnknownSymbol) {
            name = ((UnknownSymbol)node).getName();
            String nodeName = String.valueOf(name) + "_Node";
            String typeName = TYPE_NAMES[type];
            VarItem var = new VarItem(name, new DataType(typeName), "(" + Optimizer.upperFirstChar(typeName) + ")" + nodeName + ".calculate(ctx)");
            VarItem nodeVar = new VarItem(nodeName, null, name);
            if (info != null) {
                info.addLocalVar(var);
                info.addNodeVar(nodeVar);
            }
            return name;
        }
        if (node instanceof FieldRef) {
            name = ((FieldRef)node).getName();
            return name;
        }
        if (node instanceof Constant) {
            Object val = ((Constant)node).getValue();
            return val.toString();
        }
        throw new RuntimeException(node.toString());
    }

    private static String upperFirstChar(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    private static Class<?> compile(NodeInfo info) {
        String clsName = "Node_" + info.hashCode();
        StringBuffer sb = new StringBuffer();
        sb.append("package com.scudata.optimize.function;");
        sb.append(System.lineSeparator());
        sb.append("import com.scudata.dm.*;");
        sb.append("import com.scudata.expression.*;");
        sb.append("import com.scudata.array.*;");
        sb.append("import com.scudata.array.LongArray;");
        sb.append("import com.scudata.expression.mfn.sequence.*;");
        sb.append("import com.scudata.compile.function.*;");
        sb.append("import com.scudata.compile.op.*;");
        sb.append("import com.scudata.dm.op.*;");
        sb.append(System.lineSeparator());
        sb.append("public class " + clsName + " extends Function {");
        sb.append(System.lineSeparator());
        HashMap<String, VarItem> nodeVars = info.getNodeVars();
        for (Map.Entry<String, VarItem> entry : nodeVars.entrySet()) {
            VarItem item = entry.getValue();
            sb.append("Node " + item.getName() + "= new Expression(\"" + item.getInitValue() + "\").getHome()");
            sb.append(";");
            sb.append(System.lineSeparator());
        }
        sb.append("public Object calculate(Context ctx) {");
        sb.append(System.lineSeparator());
        String expStr = info.getExp();
        List<String> strs = CompilerUtil.splitByAnd(expStr);
        if (strs.size() > 1) {
            sb.append("boolean flag;");
            sb.append(System.lineSeparator());
            ArrayList<String> outs = new ArrayList<String>();
            HashMap<String, VarItem> localVars = info.getLocalVars();
            int i = 0;
            int len = strs.size();
            while (i < len) {
                String str = strs.get(i);
                Set<String> strSets = CompilerUtil.extractVariables(str);
                for (Map.Entry<String, VarItem> entry : localVars.entrySet()) {
                    VarItem item = entry.getValue();
                    String key = entry.getKey();
                    if (!strSets.contains(key) || outs.contains(key)) continue;
                    outs.add(key);
                    sb.append(item.getType() + " " + item.getName() + "=" + item.getInitValue());
                    sb.append(";");
                    sb.append(System.lineSeparator());
                }
                sb.append("flag = " + str + ";");
                sb.append(System.lineSeparator());
                if (i != len - 1) {
                    sb.append("if (!flag) {\r\n\t\t\treturn Boolean.FALSE; \r\n\t\t}");
                    sb.append(System.lineSeparator());
                }
                ++i;
            }
            sb.append("if (flag) {\r\n\t\t\treturn Boolean.TRUE; \r\n\t\t} else {\r\n\t\t\treturn Boolean.FALSE;\r\n\t\t}");
            sb.append(System.lineSeparator());
        } else {
            HashMap<String, VarItem> localVars = info.getLocalVars();
            for (Map.Entry<String, VarItem> entry : localVars.entrySet()) {
                VarItem item = entry.getValue();
                sb.append(item.getType() + " " + item.getName() + "=" + item.getInitValue());
                sb.append(";");
                sb.append(System.lineSeparator());
            }
            sb.append("return " + info + ";");
        }
        sb.append(System.lineSeparator());
        sb.append("}");
        sb.append(System.lineSeparator());
        sb.append("\tpublic Node optimize(Context ctx) {\r\n\t\treturn this;\r\n\t}");
        sb.append(System.lineSeparator());
        sb.append("}");
        String src = sb.toString();
        String fullClassName = "com.scudata.optimize.function." + clsName;
        CodeCompiler.debug = true;
        Class<?> cls = CodeCompiler.compile0(fullClassName, src);
        info.setClassName(clsName);
        info.setFullClassName(fullClassName);
        return cls;
    }
}

