/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

public class Blob
implements java.sql.Blob {
    private byte[] bs;

    public Blob(byte[] bs) {
        this.bs = bs;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.bs);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return this.getSubBytes(this.bs, pos, length);
    }

    private byte[] getSubBytes(byte[] bytes, long pos, int length) throws SQLException {
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            result[i] = bytes[new Long(pos + (long)i).intValue()];
            ++i;
        }
        return result;
    }

    public byte[] getBytes() throws SQLException {
        return this.bs;
    }

    @Override
    public long length() throws SQLException {
        if (this.bs == null) {
            return 0L;
        }
        return this.bs.length;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        long i = start;
        while (i < (long)this.bs.length) {
            block3: {
                int j = 0;
                while (j < pattern.length) {
                    if (pattern[j] == this.bs[new Long(i + (long)j).intValue()]) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long position(java.sql.Blob pattern, long start) throws SQLException {
        byte[] patt = pattern.getBytes(0L, new Long(pattern.length()).intValue());
        return this.position(patt, start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        int i = 0;
        while (i < bytes.length) {
            if ((long)i + pos == (long)this.bs.length) break;
            this.bs[new Long((long)((long)i + pos)).intValue()] = bytes[i];
            ++i;
        }
        return i;
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return this.setBytes(pos, this.getSubBytes(bytes, offset, len));
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.getSubBytes(this.bs, pos, new Long((long)this.bs.length - pos + 1L).intValue()));
            return baos;
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len < (long)this.bs.length) {
            byte[] t = new byte[new Long(len).intValue()];
            int i = 0;
            while ((long)i < len) {
                t[i] = this.bs[i];
                ++i;
            }
            this.bs = t;
        }
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        byte[] bsSub = this.getBytes(pos, (int)length);
        return new ByteArrayInputStream(bsSub);
    }
}

