/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.InternalConnection;
import com.esproc.jdbc.InternalPStatement;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.ParamList;
import com.scudata.dm.Table;
import com.scudata.parallel.UnitClient;
import com.scudata.util.CellSetUtil;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class InternalCStatement
extends InternalPStatement
implements CallableStatement,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> paramNames = null;

    public InternalCStatement() {
    }

    public InternalCStatement(int id, String sql) {
        super(id, sql);
    }

    public synchronized int getParameterIndex(String parameterName) throws SQLException {
        if (!StringUtils.isValidString(parameterName)) {
            throw new SQLException(JDBCMessage.get().getMessage("error.emptyparamname"));
        }
        if (this.paramNames == null && StringUtils.isValidString(this.sql)) {
            try {
                byte sqlType = JDBCUtil.getJdbcSqlType(this.sql);
                if (2 == sqlType && this.sql.length() > 1) {
                    this.paramNames = this.getSplParamNames(this.sql.substring(1));
                } else if (3 == sqlType || 4 == sqlType) {
                    this.paramNames = this.getCallParamNames(this.sql, this.getConnection(), this.queryTimeout);
                }
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e.getMessage(), e);
            }
        }
        int paramIndex = -1;
        if (this.paramNames != null) {
            paramIndex = this.paramNames.indexOf(parameterName);
        }
        if (paramIndex < 0) {
            throw new SQLException(JDBCMessage.get().getMessage("error.paramnamenotfound", parameterName));
        }
        return paramIndex + 1;
    }

    private ArrayList<String> getSplParamNames(String spl) {
        PgmCellSet pcs = CellSetUtil.toPgmCellSet(spl);
        pcs.setParamToContext();
        ArrayList<String> paramNames = new ArrayList<String>();
        ParamList pl = pcs.getParamList();
        if (pl != null) {
            int i = 0;
            while (i < pl.count()) {
                paramNames.add(pl.get(i).getName());
                ++i;
            }
        }
        return paramNames;
    }

    private ArrayList<String> getCallParamNames(String spl, InternalConnection connt, int queryTimeout) throws Exception {
        Table t;
        String splName = JDBCUtil.getSplName(spl);
        if (!StringUtils.isValidString(splName)) {
            throw new SQLException(JDBCMessage.get().getMessage("error.emptysplname"));
        }
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        if (connt.isOnlyServer()) {
            UnitClient uc = connt.getUnitClient(queryTimeout * 1000);
            int connId = connt.getUnitConnectionId();
            t = uc.JDBCGetSplParams(connId, splName, false);
        } else {
            List<String> hosts;
            t = JDBCUtil.getSplParams(splName);
            if (!(t != null && t.length() != 0 || (hosts = connt.getHostNames()) == null || hosts.isEmpty())) {
                UnitClient uc = null;
                try {
                    uc = connt.getUnitClient(queryTimeout * 1000);
                }
                catch (Exception ex) {
                    Logger.error(ex);
                }
                if (uc != null) {
                    int connId = connt.getUnitConnectionId();
                    t = uc.JDBCGetSplParams(connId, splName, false);
                }
            }
        }
        if (t == null || t.length() == 0) {
            throw new SQLException(JDBCMessage.get().getMessage("error.splnotfound", splName));
        }
        int len = t.length();
        ParamList pl = null;
        if (len == 1) {
            pl = (ParamList)t.getRecord(1).getFieldValue("PARAM_LIST");
        } else {
            String[] splTypes;
            String[] stringArray = splTypes = "splx,spl,dfx".split(",");
            int n = splTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String splType = stringArray[n2];
                int r = 1;
                while (r <= len) {
                    String fileName = (String)t.getRecord(r).getFieldValue("PROCEDURE_NAME");
                    if (fileName != null && fileName.toLowerCase().endsWith(splType)) {
                        pl = (ParamList)t.getRecord(r).getFieldValue("PARAM_LIST");
                        break;
                    }
                    ++r;
                }
                ++n2;
            }
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        if (pl != null) {
            int i = 0;
            while (i < pl.count()) {
                paramNames.add(pl.get(i).getName());
                ++i;
            }
        }
        return paramNames;
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getArray(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getArray(int parameterIndex)"));
        return null;
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getArray(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getArray(String parameterName)"));
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getBigDecimal(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getBigDecimal(int parameterIndex)"));
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getBigDecimal(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getBigDecimal(String parameterName)"));
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        JDBCUtil.log("InternalCStatement.getBigDecimal(" + parameterIndex + "," + scale + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getBigDecimal(int parameterIndex, int scale)"));
        return null;
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getBlob(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getBlob(int parameterIndex)"));
        return null;
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getBlob(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getBlob(String parameterName)"));
        return null;
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getBoolean(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getBoolean(int parameterIndex)"));
        return false;
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getBoolean(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getBoolean(String parameterName)"));
        return false;
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getByte(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getByte(int parameterIndex)"));
        return 0;
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getByte(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getByte(String parameterName)"));
        return 0;
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getBytes(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getBytes(int parameterIndex)"));
        return null;
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getBytes(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getBytes(String parameterName)"));
        return null;
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getClob(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getClob(int parameterIndex)"));
        return null;
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getClob(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getClob(String parameterName)"));
        return null;
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getDate(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getDate(int parameterIndex)"));
        return null;
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getDate(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getDate(String parameterName)"));
        return null;
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalCStatement.getDate(" + parameterIndex + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getDate(int parameterIndex, Calendar cal)"));
        return null;
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalCStatement.getDate(" + parameterName + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getDate(String parameterName, Calendar cal)"));
        return null;
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getDouble(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getDouble(int parameterIndex)"));
        return 0.0;
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getDouble(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getDouble(String parameterName)"));
        return 0.0;
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getFloat(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getFloat(int parameterIndex)"));
        return 0.0f;
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getFloat(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getFloat(String parameterName)"));
        return 0.0f;
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getInt(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getInt(int parameterIndex)"));
        return 0;
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getInt(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getInt(String parameterName)"));
        return 0;
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getLong(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getLong(int parameterIndex)"));
        return 0L;
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getLong(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getLong(String parameterName)"));
        return 0L;
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getObject(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(int parameterIndex)"));
        return null;
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getObject(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(String parameterName)"));
        return null;
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getRef(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getRef(int parameterIndex)"));
        return null;
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getRef(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getRef(String parameterName)"));
        return null;
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getShort(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getShort(int parameterIndex)"));
        return 0;
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getShort(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getShort(String parameterName)"));
        return 0;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getString(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getString(int parameterIndex)"));
        return null;
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getString(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getString(String parameterName)"));
        return null;
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getTime(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTime(int parameterIndex)"));
        return null;
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getTime(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTime(String parameterName)"));
        return null;
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalCStatement.getTime(" + parameterIndex + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTime(int parameterIndex, Calendar cal)"));
        return null;
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalCStatement.getTime(" + parameterName + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTime(String parameterName, Calendar cal)"));
        return null;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getTimestamp(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTimestamp(int parameterIndex)"));
        return null;
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getTimestamp(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTimestamp(String parameterName)"));
        return null;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalCStatement.getTimestamp(" + parameterIndex + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTimestamp(int parameterIndex, Calendar cal)"));
        return null;
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalCStatement.getTimestamp(" + parameterName + "," + cal + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getTimestamp(String parameterName, Calendar cal)"));
        return null;
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getURL(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getURL(int parameterIndex)"));
        return null;
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getURL(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getURL(String parameterName)"));
        return null;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        JDBCUtil.log("InternalCStatement.registerOutParameter(" + parameterIndex + "," + sqlType + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "registerOutParameter(int parameterIndex, int sqlType)"));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        JDBCUtil.log("InternalCStatement.registerOutParameter(" + parameterName + "," + sqlType + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "registerOutParameter(String parameterName, int sqlType)"));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        JDBCUtil.log("InternalCStatement.registerOutParameter(" + parameterIndex + "," + sqlType + "," + scale + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "registerOutParameter(int parameterIndex, int sqlType, int scale)"));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        JDBCUtil.log("InternalCStatement.registerOutParameter(" + parameterIndex + "," + sqlType + "," + typeName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "registerOutParameter(int parameterIndex, int sqlType, String typeName)"));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        JDBCUtil.log("InternalCStatement.registerOutParameter(" + parameterName + "," + sqlType + "," + scale + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "registerOutParameter(registerOutParameter(String parameterName, int sqlType, int scale)"));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        JDBCUtil.log("InternalCStatement.registerOutParameter(" + parameterName + "," + sqlType + "," + typeName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "registerOutParameter(String parameterName, int sqlType, String typeName)"));
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setAsciiStream(" + parameterName + ",InputStream x," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setAsciiStream(paramIndex, x, length);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setBigDecimal(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setBigDecimal(paramIndex, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setBinaryStream(" + parameterName + ",InputStream x," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setBinaryStream(paramIndex, x, length);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setBoolean(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setBoolean(paramIndex, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setByte(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setByte(paramIndex, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setBytes(" + parameterName + ",byte[] x)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setBytes(paramIndex, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setCharacterStream(" + parameterName + ",Reader reader," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setCharacterStream(paramIndex, reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setDate(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setDate(paramIndex, x);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalCStatement.setDate(" + parameterName + "," + x + "," + cal + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setDate(paramIndex, x, cal);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setDouble(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setDouble(paramIndex, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setFloat(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setFloat(paramIndex, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setInt(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setInt(paramIndex, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setLong(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setLong(paramIndex, x);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        JDBCUtil.log("InternalCStatement.setNull(" + parameterName + "," + sqlType + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setNull(paramIndex, sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        JDBCUtil.log("InternalCStatement.setNull(" + parameterName + "," + sqlType + "," + typeName + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setObject(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setObject(paramIndex, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        JDBCUtil.log("InternalCStatement.setObject(" + parameterName + "," + x + "," + targetSqlType + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setObject(paramIndex, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        JDBCUtil.log("InternalCStatement.setObject(" + parameterName + "," + x + "," + targetSqlType + "," + scale + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setObject(paramIndex, x, targetSqlType, scale);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setShort(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setShort(paramIndex, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setString(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setString(paramIndex, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setTime(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setTime(paramIndex, x);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalCStatement.setTime(" + parameterName + "," + x + "," + cal + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setTime(paramIndex, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setTimestamp(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setTimestamp(paramIndex, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalCStatement.setTimestamp(" + parameterName + "," + x + "," + cal + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setTimestamp(paramIndex, x, cal);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        JDBCUtil.log("InternalCStatement.setURL(" + parameterName + "," + val + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setURL(paramIndex, val);
    }

    @Override
    public boolean wasNull() throws SQLException {
        JDBCUtil.log("InternalCStatement.wasNull()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "wasNull()"));
        return false;
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getCharacterStream(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getCharacterStream(int parameterIndex)"));
        return null;
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getCharacterStream(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getCharacterStream(String parameterName)"));
        return null;
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getNCharacterStream(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNCharacterStream(int parameterIndex)"));
        return null;
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getNCharacterStream(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNCharacterStream(String parameterName)"));
        return null;
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getNClob(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNClob(int parameterIndex)"));
        return null;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getNClob(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNClob(String parameterName)"));
        return null;
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getNString(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNString(int parameterIndex)"));
        return null;
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getNString(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getNString(String parameterName)"));
        return null;
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        JDBCUtil.log("InternalCStatement.getObject(" + parameterIndex + "," + map + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(int parameterIndex, Map<String, Class<?>> map)"));
        return null;
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        JDBCUtil.log("InternalCStatement.getObject(" + parameterName + "," + map + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(String parameterName, Map<String, Class<?>> map)"));
        return null;
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getRowId(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getRowId(int parameterIndex)"));
        return null;
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getRowId(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getRowId(String parameterName)"));
        return null;
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        JDBCUtil.log("InternalCStatement.getSQLXML(" + parameterIndex + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getSQLXML(int parameterIndex)"));
        return null;
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        JDBCUtil.log("InternalCStatement.getSQLXML(" + parameterName + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getSQLXML(String parameterName)"));
        return null;
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setAsciiStream(" + parameterName + ",InputStream x)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setAsciiStream(paramIndex, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setAsciiStream(" + parameterName + ",InputStream x," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setAsciiStream(paramIndex, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setBinaryStream(" + parameterName + ",InputStream x)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setBinaryStream(paramIndex, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setBinaryStream(" + parameterName + ",InputStream x," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setBinaryStream(paramIndex, x, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setBlob(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setBlob(paramIndex, x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        JDBCUtil.log("InternalCStatement.setBlob(" + parameterName + ",InputStream x)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setBlob(paramIndex, inputStream);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setBlob(" + parameterName + ",InputStream x," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setBlob(paramIndex, inputStream, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        JDBCUtil.log("InternalCStatement.setCharacterStream(" + parameterName + ",Reader reader)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setCharacterStream(paramIndex, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setCharacterStream(" + parameterName + ",Reader reader," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setCharacterStream(paramIndex, reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setClob(" + parameterName + "," + x + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setClob(paramIndex, x);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        JDBCUtil.log("InternalCStatement.setClob(" + parameterName + ",Reader reader)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setClob(paramIndex, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setClob(" + parameterName + ",Reader reader," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setClob(paramIndex, reader, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        JDBCUtil.log("InternalCStatement.setNCharacterStream(" + parameterName + ",Reader reader)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setNCharacterStream(paramIndex, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setNCharacterStream(" + parameterName + ",Reader reader," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setNCharacterStream(paramIndex, value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        JDBCUtil.log("InternalCStatement.setNClob(" + parameterName + "," + value + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setNClob(paramIndex, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        JDBCUtil.log("InternalCStatement.setNClob(" + parameterName + ",Reader reader)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setNClob(paramIndex, reader);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        JDBCUtil.log("InternalCStatement.setNClob(" + parameterName + ",Reader reader," + length + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setNClob(paramIndex, reader, length);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        JDBCUtil.log("InternalCStatement.setNString(" + parameterName + "," + value + ")");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setNString(paramIndex, value);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        JDBCUtil.log("InternalCStatement.setRowId(" + parameterName + ",RowId x)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setRowId(paramIndex, x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        JDBCUtil.log("InternalCStatement.setSQLXML(" + parameterName + ",SQLXML xmlObject)");
        int paramIndex = this.getParameterIndex(parameterName);
        this.setSQLXML(paramIndex, xmlObject);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        JDBCUtil.log("InternalCStatement.getObject(" + parameterIndex + "," + type + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(int parameterIndex, Class<T> type)"));
        return null;
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        JDBCUtil.log("InternalCStatement.getObject(" + parameterName + "," + type + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getObject(String parameterName, Class<T> type)"));
        return null;
    }
}

