/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.DatabaseMetaData;
import com.esproc.jdbc.InternalCStatement;
import com.esproc.jdbc.InternalDriver;
import com.esproc.jdbc.InternalPStatement;
import com.esproc.jdbc.InternalStatement;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.esproc.jdbc.ResultSet;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.DBSession;
import com.scudata.common.ISessionFactory;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.common.UUID;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Table;
import com.scudata.parallel.UnitClient;
import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public abstract class InternalConnection
implements Connection,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String url = null;
    protected Properties clientInfo = null;
    protected volatile boolean closed = false;
    protected List<InternalStatement> stats = new ArrayList<InternalStatement>();
    protected DatabaseMetaData metaData;
    protected String driverName;
    protected int driverMajorVersion;
    protected int driverMinorVersion;
    private int stMaxId = 0;
    private volatile boolean isOnlyServer = false;
    private UnitClient unitClient = null;
    private int unitConnectionId;
    private RaqsoftConfig raqsoftConfig = null;
    private Map<String, Class<?>> typeMap;
    protected List<String> hostNames = null;
    protected volatile int connectTimeout = 5000;
    protected Map<String, Object> jobVars = null;
    private Context parentCtx = new Context();
    private JobSpace jobSpace = null;

    public InternalConnection(InternalDriver driver, RaqsoftConfig config, List<String> hostNames) throws SQLException {
        this(driver, config, hostNames, null);
    }

    public InternalConnection(InternalDriver driver, RaqsoftConfig config, List<String> hostNames, Map<String, Object> jobVars) throws SQLException {
        this.raqsoftConfig = config;
        this.hostNames = hostNames;
        this.driverName = driver.getClass().getName();
        this.driverMajorVersion = driver.getMajorVersion();
        this.driverMinorVersion = driver.getMinorVersion();
        if (!StringUtils.isValidString(Env.getMainPath())) {
            Env.setMainPath(System.getProperty("user.dir"));
        }
        this.initContext(this.parentCtx, jobVars);
    }

    public abstract void checkExec() throws SQLException;

    public Context getParentContext() {
        return this.parentCtx;
    }

    public boolean isAutoConnection(String dbName, DBSession dbSession) {
        DBSession autoConnectDB = this.parentCtx.getDBSession(dbName);
        return autoConnectDB != null && autoConnectDB == dbSession;
    }

    private void initContext(Context ctx, Map<String, Object> jobVars) {
        ctx.setJobSpace(this.getJobSpace());
        if (this.jobSpace != null && jobVars != null) {
            for (String paramName : jobVars.keySet()) {
                Object value = jobVars.get(paramName);
                this.jobSpace.setParamValue(paramName, value);
            }
        }
        if (this.raqsoftConfig != null) {
            this.autoConnect(this.raqsoftConfig.getAutoConnectList(), ctx);
        }
    }

    private synchronized JobSpace getJobSpace() {
        if (this.jobSpace == null) {
            String uuid = UUID.randomUUID().toString();
            this.jobSpace = JobSpaceManager.getSpace(uuid);
        }
        return this.jobSpace;
    }

    private void autoConnect(List<String> autoList, Context ctx) {
        if (autoList == null) {
            return;
        }
        int i = 0;
        while (i < autoList.size()) {
            String name = autoList.get(i);
            try {
                Logger.debug("Auto connect database [" + name + "]");
                ISessionFactory isf = Env.getDBSessionFactory(name);
                if (isf == null) {
                    isf = ctx.getDBSessionFactory(name);
                }
                if (isf != null) {
                    ctx.setDBSession(name, isf.getSession());
                }
            }
            catch (Exception e) {
                Logger.error("Auto connect database [" + name + "] failed: " + e.getMessage());
                Logger.error(e);
            }
            ++i;
        }
    }

    protected synchronized int nextStatementId() {
        if (this.stMaxId == Integer.MAX_VALUE) {
            this.stMaxId = 1;
        }
        ++this.stMaxId;
        return this.stMaxId;
    }

    public RaqsoftConfig getRaqsoftConfig() {
        return this.raqsoftConfig;
    }

    public InternalStatement getStatement(int id) throws SQLException {
        if (this.closed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        int i = 0;
        while (i < this.stats.size()) {
            InternalStatement ist = this.stats.get(i);
            if (ist.getID() == id) {
                return ist;
            }
            ++i;
        }
        return null;
    }

    public void setOnlyServer(boolean isOnlyServer) {
        this.isOnlyServer = isOnlyServer;
    }

    public boolean isOnlyServer() {
        return this.isOnlyServer;
    }

    public List<InternalStatement> getStatements() throws SQLException {
        if (this.closed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement(InternalStatement st) throws SQLException {
        if (st == null) {
            return;
        }
        if (this.closed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        if (this.unitClient != null) {
            try {
                this.unitClient.JDBCCloseStatement(this.unitConnectionId, st.getUnitStatementID());
            }
            catch (Throwable e) {
                Logger.warn(e.getMessage(), e);
            }
        }
        List<InternalStatement> list = this.stats;
        synchronized (list) {
            this.stats.remove(st);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<String> getHostNames() {
        return this.hostNames;
    }

    public RaqsoftConfig getConfig() {
        return this.raqsoftConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized UnitClient getUnitClient(int timeoutMS) throws SQLException {
        if (this.unitClient == null) {
            List<String> hosts = this.hostNames;
            if (hosts == null || hosts.isEmpty()) {
                throw new SQLException(JDBCMessage.get().getMessage("jdbcutil.noserverconfig"));
            }
            int unitCount = hosts.size();
            HashSet<Integer> errorIndex = new HashSet<Integer>();
            while (true) {
                int index;
                if (errorIndex.contains(new Integer(index = this.randomIndex(unitCount)))) {
                    continue;
                }
                String host = hosts.get(index);
                if (StringUtils.isValidString(host)) {
                    int port;
                    int sepIndex = host.indexOf(":");
                    if (sepIndex <= 0) throw new SQLException(JDBCMessage.get().getMessage("jdbcutil.errorhostformat", host));
                    String ip = host.substring(0, sepIndex);
                    String sport = host.substring(sepIndex + 1);
                    try {
                        port = Integer.parseInt(sport);
                    }
                    catch (Exception e) {
                        throw new SQLException(JDBCMessage.get().getMessage("jdbcutil.errorportformat", sport));
                    }
                    this.unitClient = new UnitClient(ip, port);
                    this.unitClient.setConnectTimeout(timeoutMS);
                    if (this.unitClient.isAlive()) {
                        try {
                            this.unitConnectionId = this.unitClient.JDBCConnect();
                            return this.unitClient;
                        }
                        catch (Exception e) {
                            throw new SQLException(e.getMessage(), e);
                        }
                    }
                    errorIndex.add(new Integer(index));
                    Logger.warn("Unit: " + host + " is not alive.");
                } else {
                    errorIndex.add(new Integer(index));
                    Logger.warn("Unit " + (index + 1) + " is null.");
                }
                if (errorIndex.size() == unitCount) throw new SQLException("All units are not alive.");
            }
        }
        this.unitClient.setConnectTimeout(timeoutMS);
        return this.unitClient;
    }

    public int getUnitConnectionId() {
        return this.unitConnectionId;
    }

    private int randomIndex(int count) {
        int index = (int)(Math.random() * (double)(count + 1) % (double)count);
        if (index < 0) {
            index = 0;
        } else if (index > count - 1) {
            index = count - 1;
        }
        return index;
    }

    public ResultSet getProcedures(String procedureNamePattern) throws SQLException {
        Table t;
        JDBCUtil.log("InternalConnection.getProcedures(" + procedureNamePattern + ")");
        if (this.isOnlyServer()) {
            UnitClient uc = this.getUnitClient(this.connectTimeout);
            int unitConnectionId = this.getUnitConnectionId();
            try {
                t = uc.JDBCGetProcedures(unitConnectionId, procedureNamePattern, false);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e.getMessage(), e);
            }
        } else {
            t = JDBCUtil.getProcedures(procedureNamePattern);
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(t);
        return new ResultSet(1, paramList);
    }

    public ResultSet getProcedureColumns(String procedureNamePattern, String columnNamePattern) throws SQLException {
        Table t;
        JDBCUtil.log("InternalConnection.getProcedureColumns(" + procedureNamePattern + "," + columnNamePattern + ")");
        if (this.isOnlyServer()) {
            UnitClient uc = this.getUnitClient(this.connectTimeout);
            int connId = this.getUnitConnectionId();
            try {
                t = uc.JDBCGetProcedureColumns(connId, procedureNamePattern, columnNamePattern, false);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e.getMessage(), e);
            }
        } else {
            t = JDBCUtil.getProcedureColumns(procedureNamePattern, columnNamePattern);
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(t);
        return new ResultSet(2, paramList);
    }

    public ResultSet getTables(String tableNamePattern) throws SQLException {
        Table t;
        JDBCUtil.log("InternalConnection.getTables(" + tableNamePattern + ")");
        if (this.isOnlyServer()) {
            UnitClient uc = this.getUnitClient(this.connectTimeout);
            int unitConnectionId = this.getUnitConnectionId();
            try {
                t = uc.JDBCGetTables(unitConnectionId, tableNamePattern, false);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e.getMessage(), e);
            }
        } else {
            t = JDBCUtil.getTables(tableNamePattern);
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(t);
        return new ResultSet(4, paramList);
    }

    public ResultSet getColumns(String tableNamePattern, String columnNamePattern) throws SQLException {
        Table t;
        JDBCUtil.log("InternalConnection.getColumns(" + tableNamePattern + "," + columnNamePattern + ")");
        if (this.isOnlyServer()) {
            UnitClient uc = this.getUnitClient(this.connectTimeout);
            int connId = this.getUnitConnectionId();
            try {
                t = uc.JDBCGetColumns(connId, tableNamePattern, columnNamePattern, false);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e.getMessage(), e);
            }
        } else {
            t = JDBCUtil.getColumns(tableNamePattern, columnNamePattern, this.parentCtx);
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(t);
        return new ResultSet(5, paramList);
    }

    @Override
    public Statement createStatement() throws SQLException {
        JDBCUtil.log("InternalConnection.createStatement()");
        if (this.closed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        InternalStatement st = new InternalStatement(this.nextStatementId()){

            @Override
            public InternalConnection getConnection() {
                return InternalConnection.this;
            }
        };
        st.setQueryTimeout(this.connectTimeout);
        this.stats.add(st);
        return st;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        JDBCUtil.log("InternalConnection.prepareStatement(" + sql + ")");
        if (this.closed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        InternalPStatement st = new InternalPStatement(this.nextStatementId(), sql){

            @Override
            public InternalConnection getConnection() {
                return InternalConnection.this;
            }
        };
        st.setQueryTimeout(this.connectTimeout);
        this.stats.add(st);
        return st;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        JDBCUtil.log("InternalConnection.prepareCall(" + sql + ")");
        if (this.closed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        InternalCStatement st = new InternalCStatement(this.nextStatementId(), sql){
            private static final long serialVersionUID = 1L;

            @Override
            public InternalConnection getConnection() {
                return InternalConnection.this;
            }
        };
        st.setQueryTimeout(this.connectTimeout);
        this.stats.add(st);
        return st;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        JDBCUtil.log("InternalConnection.nativeSQL(" + sql + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "nativeSQL(String sql)"));
        return null;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        JDBCUtil.log("InternalConnection.setAutoCommit(" + autoCommit + ")");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        JDBCUtil.log("InternalConnection.getAutoCommit()");
        return false;
    }

    @Override
    public void commit() throws SQLException {
        JDBCUtil.log("InternalConnection.commit()");
    }

    @Override
    public void rollback() throws SQLException {
        JDBCUtil.log("InternalConnection.rollback()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        JDBCUtil.log("InternalConnection.close()");
        List<InternalStatement> list = this.stats;
        synchronized (list) {
            int i = 0;
            while (i < this.stats.size()) {
                this.stats.get(i).close();
                ++i;
            }
        }
        if (this.jobSpace != null) {
            this.jobSpace.closeResource();
            JobSpaceManager.closeSpace(this.jobSpace.getID());
        }
        this.closeUnitClient();
        this.closed = true;
    }

    private void closeUnitClient() {
        if (this.unitClient != null) {
            try {
                this.unitClient.JDBCCloseConnection(this.unitConnectionId);
            }
            catch (Exception e) {
                Logger.warn(e.getMessage(), e);
            }
        }
        this.unitClient = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        JDBCUtil.log("InternalConnection.isClosed()");
        return this.closed;
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        JDBCUtil.log("InternalConnection.getMetaData()");
        if (this.closed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        if (this.metaData == null) {
            this.metaData = new DatabaseMetaData(this.url, this.driverName, this.driverMajorVersion, this.driverMinorVersion){

                @Override
                public InternalConnection getConnection() {
                    return InternalConnection.this;
                }
            };
        }
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        JDBCUtil.log("InternalConnection.setReadOnly(" + readOnly + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setReadOnly(boolean readOnly)"));
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        JDBCUtil.log("InternalConnection.isReadOnly()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "isReadOnly()"));
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        JDBCUtil.log("InternalConnection.setCatalog(" + catalog + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setCatalog(String catalog)"));
    }

    @Override
    public String getCatalog() throws SQLException {
        JDBCUtil.log("InternalConnection.getCatalog()");
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        JDBCUtil.log("InternalConnection.setTransactionIsolation(" + level + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setTransactionIsolation(int level)"));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        JDBCUtil.log("InternalConnection.getTransactionIsolation()");
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        JDBCUtil.log("InternalConnection.getWarnings()");
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        JDBCUtil.log("InternalConnection.clearWarnings()");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        JDBCUtil.log("InternalConnection.createStatement(" + resultSetType + "," + resultSetConcurrency + ")");
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        JDBCUtil.log("InternalConnection.prepareStatement(" + sql + "," + resultSetType + "," + resultSetConcurrency + ")");
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        JDBCUtil.log("InternalConnection.prepareCall(" + sql + "," + resultSetType + "," + resultSetConcurrency + ")");
        return this.prepareCall(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        JDBCUtil.log("InternalConnection.getTypeMap()");
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        JDBCUtil.log("InternalConnection.setTypeMap(Map<String, Class<?>> map)");
        this.typeMap = map;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        JDBCUtil.log("InternalConnection.setHoldability(" + holdability + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setHoldability(int holdability)"));
    }

    @Override
    public int getHoldability() throws SQLException {
        JDBCUtil.log("InternalConnection.getHoldability()");
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        JDBCUtil.log("InternalConnection.setSavepoint()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setSavepoint()"));
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        JDBCUtil.log("InternalConnection.setSavepoint(" + name + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setSavepoint(String name)"));
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        JDBCUtil.log("InternalConnection.rollback(Savepoint savepoint)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "rollback(Savepoint savepoint)"));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        JDBCUtil.log("InternalConnection.releaseSavepoint(Savepoint savepoint)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "releaseSavepoint(Savepoint savepoint)"));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDBCUtil.log("InternalConnection.createStatement(" + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")");
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDBCUtil.log("InternalConnection.prepareStatement(" + sql + "," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")");
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDBCUtil.log("InternalConnection.prepareCall(" + sql + "," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")");
        return this.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        JDBCUtil.log("InternalConnection.prepareStatement(" + sql + "," + autoGeneratedKeys + ")");
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        JDBCUtil.log("InternalConnection.prepareStatement(" + sql + "," + JDBCUtil.array2String(columnIndexes) + ")");
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        JDBCUtil.log("InternalConnection.prepareStatement(" + sql + "," + JDBCUtil.array2String(columnNames) + ")");
        return this.prepareStatement(sql);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        JDBCUtil.log("InternalConnection.createArrayOf(" + typeName + ",Object[] elements)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "createArrayOf(String typeName, Object[] elements)"));
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        JDBCUtil.log("InternalConnection.createBlob()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "createBlob()"));
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        JDBCUtil.log("InternalConnection.createClob()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "createClob()"));
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        JDBCUtil.log("InternalConnection.createNClob()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "createNClob()"));
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        JDBCUtil.log("InternalConnection.createSQLXML()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "createSQLXML()"));
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        JDBCUtil.log("InternalConnection.createStruct(" + typeName + ",Object[] attributes)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "createStruct(String typeName, Object[] attributes)"));
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        JDBCUtil.log("InternalConnection.isValid(" + timeout + ")");
        return !this.isClosed();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        JDBCUtil.log("InternalConnection.getClientInfo()");
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        JDBCUtil.log("InternalConnection.getClientInfo(" + name + ")");
        if (this.clientInfo == null) {
            return null;
        }
        return this.clientInfo.getProperty(name);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        JDBCUtil.log("InternalConnection.setClientInfo(Properties properties)");
        this.clientInfo = properties;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        JDBCUtil.log("InternalConnection.setClientInfo(" + name + "," + value + ")");
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.put(name, value);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        JDBCUtil.log("InternalConnection.isWrapperFor(Class<?> iface)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "isWrapperFor(Class<?> iface)"));
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        JDBCUtil.log("InternalConnection.unwrap(Class<?> iface)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "unwrap(Class<T> iface)"));
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        JDBCUtil.log("InternalConnection.setSchema(" + schema + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setSchema(String schema)"));
    }

    @Override
    public String getSchema() throws SQLException {
        JDBCUtil.log("InternalConnection.getSchema()");
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        JDBCUtil.log("InternalConnection.abort(Executor executor)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "abort(Executor executor)"));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        JDBCUtil.log("InternalConnection.setNetworkTimeout(Executor executor," + milliseconds + ")");
        this.connectTimeout = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        JDBCUtil.log("InternalConnection.getNetworkTimeout()");
        return this.connectTimeout;
    }
}

