/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.InternalConnection;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.common.IOUtils;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.dm.LocalFile;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class InternalDriver
implements Driver,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> paramNames = null;
    protected List<String> hostNames = new ArrayList<String>();
    protected RaqsoftConfig config = null;
    private static final String CONFIG_FILE = "raqsoftConfig.xml";
    protected String currentConfig = null;
    protected int connectionCount = 0;
    protected Object countLock = new Object();
    private static final String KEY_CONFIG = "config";
    private static final String KEY_ONLY_SERVER = "onlyServer";
    private static final String KEY_JOB_VARS = "jobVars";
    private static final String KEY_DEBUGMODE = "debugmode";
    private static final String KEY_COMPATIBLESQL = "compatiblesql";

    static {
        try {
            DriverManager.registerDriver(new InternalDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(JDBCMessage.get().getMessage("error.cantregist"), e);
        }
    }

    public InternalDriver() {
        JDBCUtil.log("InternalDriver()");
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        JDBCUtil.log("InternalDriver.connect(" + url + "," + info + ")");
        return this.connect(url, info, null);
    }

    public Connection connect(String url, Properties info, RaqsoftConfig rc) throws SQLException {
        if (!this.acceptsURL(url)) {
            throw new SQLException(JDBCMessage.get().getMessage("jdbcdriver.incorrecturl", this.getDemoUrl()));
        }
        Properties props = this.getProperties(url, info);
        String sconfig = props.getProperty(KEY_CONFIG);
        String sonlyServer = props.getProperty(KEY_ONLY_SERVER);
        String sjobVars = props.getProperty(KEY_JOB_VARS);
        String sdebugmode = props.getProperty(KEY_DEBUGMODE);
        String scompatiblesql = props.getProperty(KEY_COMPATIBLESQL);
        boolean isOnlyServer = false;
        if (StringUtils.isValidString(sonlyServer)) {
            try {
                isOnlyServer = Boolean.valueOf(sonlyServer);
            }
            catch (Exception e) {
                com.scudata.common.Logger.warn("Invalid onlyServer parameter: " + sonlyServer);
            }
        }
        JDBCUtil.log("onlyServer=" + isOnlyServer);
        HashMap<String, Object> jobVars = null;
        if (StringUtils.isValidString(sjobVars)) {
            ArgumentTokenizer at = new ArgumentTokenizer(sjobVars);
            while (at.hasMoreTokens()) {
                int index;
                String pv = at.nextToken();
                if (!StringUtils.isValidString(pv) || (index = pv.indexOf(":")) < 1 || index == pv.length() - 1) continue;
                String paramName = pv.substring(0, index);
                String valueStr = pv.substring(index + 1, pv.length());
                if (!StringUtils.isValidString(paramName)) continue;
                paramName = paramName.trim();
                Object value = null;
                if (StringUtils.isValidString(valueStr)) {
                    value = Variant.parse(valueStr);
                }
                if (jobVars == null) {
                    jobVars = new HashMap<String, Object>();
                }
                jobVars.put(paramName, value);
            }
        }
        JDBCUtil.log("jobVars=" + sjobVars);
        boolean isDebugMode = false;
        if (StringUtils.isValidString(sdebugmode)) {
            try {
                isDebugMode = Boolean.valueOf(sdebugmode);
            }
            catch (Exception pv) {
                // empty catch block
            }
        }
        JDBCUtil.isDebugMode = isDebugMode;
        boolean isCompatiblesql = false;
        if (StringUtils.isValidString(scompatiblesql)) {
            try {
                isCompatiblesql = Boolean.valueOf(scompatiblesql);
            }
            catch (Exception index) {
                // empty catch block
            }
        }
        JDBCUtil.isCompatiblesql = isCompatiblesql;
        this.initConfig(rc, sconfig);
        InternalConnection con = this.newConnection(this.config, this.hostNames, jobVars);
        if (con != null) {
            con.setUrl(url);
            con.setClientInfo(info);
            con.setOnlyServer(isOnlyServer);
        }
        return con;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        JDBCUtil.log("InternalDriver.acceptsURL(" + url + ")");
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith(this.getAcceptUrl());
    }

    protected String getAcceptUrl() {
        return "jdbc:esproc:local:";
    }

    protected String getDemoUrl() {
        return "jdbc:esproc:local://";
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        JDBCUtil.log("InternalDriver.getPropertyInfo(" + url + "," + info + ")");
        Properties props = this.getProperties(url, info);
        DriverPropertyInfo[] dpis = new DriverPropertyInfo[]{new DriverPropertyInfo(KEY_CONFIG, props.getProperty(KEY_CONFIG)), new DriverPropertyInfo(KEY_ONLY_SERVER, props.getProperty(KEY_ONLY_SERVER)), new DriverPropertyInfo(KEY_JOB_VARS, props.getProperty(KEY_JOB_VARS))};
        return dpis;
    }

    @Override
    public int getMajorVersion() {
        JDBCUtil.log("InternalDriver.getMajorVersion()");
        return 1;
    }

    @Override
    public int getMinorVersion() {
        JDBCUtil.log("InternalDriver.getMinorVersion()");
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        JDBCUtil.log("InternalDriver.jdbcCompliant()");
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        JDBCUtil.log("InternalDriver.getParentLogger()");
        com.scudata.common.Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getParentLogger()"));
        return null;
    }

    protected InternalConnection newConnection(RaqsoftConfig config, List<String> hostNames, Map<String, Object> jobVars) throws SQLException {
        InternalConnection con = new InternalConnection(this, config, hostNames, jobVars){
            private static final long serialVersionUID = 1L;

            @Override
            public void close() throws SQLException {
                super.close();
                InternalDriver.this.reduceConnectionCount();
            }

            @Override
            public void checkExec() throws SQLException {
                InternalDriver.this.checkRunState();
            }
        };
        this.addConnectionCount();
        return con;
    }

    protected void checkRunState() throws SQLException {
    }

    protected Properties getProperties(String url, Properties info) {
        Properties props = new Properties();
        if (info != null) {
            props.putAll((Map<?, ?>)info);
        }
        if (url != null) {
            String[] parts;
            List<String> paramNames = this.getValidParamNames();
            String[] stringArray = parts = url.split("&");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                for (String paramName : paramNames) {
                    int index = part.toLowerCase().indexOf(String.valueOf(paramName) + "=");
                    if (index < 0) continue;
                    String key = part.substring(index, index + paramName.length());
                    String value = part.substring(index + paramName.length() + 1);
                    try {
                        key = URLDecoder.decode(key, StandardCharsets.UTF_8.toString());
                        value = URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
                    }
                    catch (Exception ex) {
                        com.scudata.common.Logger.warn("Invalid URL parameter: " + part);
                        continue;
                    }
                    props.put(key, value);
                }
                ++n2;
            }
        }
        return props;
    }

    protected boolean isValidParamName(String paramName) {
        return this.getValidParamNames().contains(paramName.toLowerCase());
    }

    protected List<String> getValidParamNames() {
        if (this.paramNames == null) {
            this.paramNames = new ArrayList<String>();
            this.paramNames.add(KEY_CONFIG.toLowerCase());
            this.paramNames.add(KEY_ONLY_SERVER.toLowerCase());
            this.paramNames.add(KEY_DEBUGMODE.toLowerCase());
            this.paramNames.add(KEY_COMPATIBLESQL.toLowerCase());
            this.paramNames.add(KEY_JOB_VARS.toLowerCase());
        }
        return this.paramNames;
    }

    protected synchronized void initConfig(RaqsoftConfig rc, String sconfig) throws SQLException {
        if (rc != null) {
            this.config = rc;
            try {
                ConfigUtil.setConfig(Env.getApplication(), System.getProperty("start.home"), this.config, true, false, true);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        } else {
            this.loadConfig(sconfig);
        }
    }

    protected boolean loadConfig(String sconfig) throws SQLException {
        block40: {
            block39: {
                if (this.config != null) {
                    if (StringUtils.isValidString(sconfig) && (this.currentConfig == null || !this.currentConfig.equalsIgnoreCase(sconfig))) {
                        com.scudata.common.Logger.info(JDBCMessage.get().getMessage("server.configloadonce"));
                    }
                    return false;
                }
                InputStream is = null;
                String fileName = sconfig;
                try {
                    if (StringUtils.isValidString(sconfig)) {
                        if ((sconfig = sconfig.trim()).startsWith("\"") && sconfig.endsWith("\"")) {
                            sconfig = Escape.removeEscAndQuote(sconfig, '\"');
                        } else if (sconfig.startsWith("'") && sconfig.endsWith("'")) {
                            sconfig = sconfig.substring(1, sconfig.length() - 1);
                        }
                        fileName = sconfig;
                        LocalFile lf = new LocalFile(fileName, "s");
                        is = lf.getInputStream();
                    } else {
                        is = this.findResource(CONFIG_FILE);
                        fileName = CONFIG_FILE;
                    }
                }
                catch (Exception lf) {
                    // empty catch block
                }
                if (is != null) {
                    try {
                        try {
                            this.config = ConfigUtil.load(is, true, true);
                            this.currentConfig = sconfig;
                            com.scudata.common.Logger.info(JDBCMessage.get().getMessage("error.configloaded", fileName));
                            com.scudata.common.Logger.debug("parallelNum=" + this.config.getParallelNum());
                            break block39;
                        }
                        catch (Exception e) {
                            String errorMessage = JDBCMessage.get().getMessage("error.loadconfigerror", fileName);
                            com.scudata.common.Logger.error(errorMessage, e);
                            throw new SQLException(String.valueOf(errorMessage) + " : " + e.getMessage(), e);
                        }
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                String errorMessage = JDBCMessage.get().getMessage("error.confignotfound", fileName);
                if (StringUtils.isValidString(sconfig)) {
                    throw new SQLException(errorMessage);
                }
            }
            this.hostNames = new ArrayList<String>();
            if (this.config != null) {
                String logConfig;
                Properties sps;
                List<String> units = this.config.getUnitList();
                if (units != null && !units.isEmpty()) {
                    for (String unit : units) {
                        this.hostNames.add(unit);
                    }
                }
                if ((sps = this.config.getServerProperties()) != null && StringUtils.isValidString(logConfig = sps.getProperty("logConfig"))) {
                    logConfig = logConfig.trim();
                    InputStream lcis = null;
                    try {
                        try {
                            LocalFile logFile = new LocalFile(logConfig, "s");
                            if (logFile.exists()) {
                                lcis = logFile.getInputStream();
                                if (lcis != null) {
                                    Properties p = new Properties();
                                    p.load(lcis);
                                    com.scudata.common.Logger.setPropertyConfig(p);
                                    com.scudata.common.Logger.debug(JDBCMessage.get().getMessage("internaldriver.loadlogconfig", logConfig));
                                }
                                break block40;
                            }
                            com.scudata.common.Logger.debug(JDBCMessage.get().getMessage("internaldriver.logconfignotfound", logConfig));
                        }
                        catch (Exception e1) {
                            com.scudata.common.Logger.debug(JDBCMessage.get().getMessage("internaldriver.loadlogconfigfailed", logConfig));
                            com.scudata.common.Logger.error(e1);
                            if (lcis == null) break block40;
                            try {
                                lcis.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    finally {
                        if (lcis != null) {
                            try {
                                lcis.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        }
        return true;
    }

    protected InputStream findResource(String fileName) {
        InputStream in;
        block12: {
            ClassLoader cl;
            in = null;
            if (in == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
                try {
                    URL url = cl.getResource(fileName);
                    if (url == null) break block12;
                    try {
                        in = url.openStream();
                        if (in != null) {
                            com.scudata.common.Logger.info("JDBC config load from : " + url.toString());
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (in == null) {
            try {
                URL url = IOUtils.class.getResource(fileName);
                if (url != null) {
                    try {
                        in = url.openStream();
                        com.scudata.common.Logger.info("JDBC config load from : " + url.toString());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnectionCount() {
        Object object = this.countLock;
        synchronized (object) {
            ++this.connectionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reduceConnectionCount() {
        Object object = this.countLock;
        synchronized (object) {
            --this.connectionCount;
        }
    }
}

