/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.ResultSet;
import com.esproc.jdbc.ResultSetMetaData;
import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.common.Types;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.KeyWord;
import com.scudata.dm.LocalFile;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.RetryException;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.query.SimpleSQL;
import com.scudata.expression.fn.Eval;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCUtil {
    private static final int GET_COLUMNS_BUFF = 1000;
    private static final int GET_COLUMNS_TIME = 100;
    public static boolean isDebugMode = false;
    public static boolean isCompatiblesql = false;
    private static final int MAX_SPL_LENGTH = 65536;

    public static byte getJdbcSqlType(String sql) {
        if (!StringUtils.isValidString(sql)) {
            return 0;
        }
        if ((sql = JDBCUtil.trimSql(sql)).startsWith(">")) {
            return 1;
        }
        if (sql.startsWith("=")) {
            return 2;
        }
        if (sql.toLowerCase().startsWith("calls")) {
            return 4;
        }
        if (sql.toLowerCase().startsWith("call")) {
            return 3;
        }
        if (sql.startsWith("$")) {
            String s = sql;
            if ((s = s.substring(1).trim()).startsWith("(")) {
                if ((s = s.substring(1).trim()).startsWith(")")) {
                    return 7;
                }
                Command command = Command.parse(sql);
                if (command.getType() == 12) {
                    return 6;
                }
            } else if (AppUtil.isSQL(sql)) {
                return 7;
            }
        } else if (AppUtil.isSQL(sql) && isCompatiblesql) {
            return 7;
        }
        return 0;
    }

    public static Object execute(String sql, ArrayList<Object> parameters, Context ctx) throws Exception {
        return JDBCUtil.execute(sql, parameters, ctx, true);
    }

    public static Object execute(String sql, ArrayList<?> parameters, Context ctx, boolean logInfo) throws Exception {
        String params;
        String splName;
        String[] nameParam;
        int paramCount;
        if (logInfo) {
            Logger.debug("SQL:[" + sql + "]");
        }
        if (!StringUtils.isValidString(sql)) {
            return null;
        }
        sql = JDBCUtil.trimSql(sql);
        int n = paramCount = parameters == null ? 0 : parameters.size();
        if (logInfo) {
            Logger.debug("param size=" + paramCount);
        }
        boolean hasReturn = true;
        boolean isGrid = false;
        boolean isCalls = false;
        if (sql.startsWith(">")) {
            hasReturn = false;
        } else if (sql.startsWith("=")) {
            sql = sql.substring(1);
            isGrid = AppUtil.isGrid(sql);
        } else if (sql.toLowerCase().startsWith("calls")) {
            nameParam = JDBCUtil.getCallsNameParam(sql, parameters);
            splName = nameParam[0];
            params = nameParam[1];
            isCalls = true;
            sql = JDBCUtil.getCallExp(splName, params, paramCount);
        } else if (sql.toLowerCase().startsWith("call")) {
            nameParam = JDBCUtil.getCallNameParam(sql);
            splName = nameParam[0];
            params = nameParam[1];
            sql = JDBCUtil.getCallExp(splName, params, paramCount);
        } else if (sql.startsWith("$")) {
            String s = sql;
            if ((s = s.substring(1).trim()).startsWith("(")) {
                if ((s = s.substring(1).trim()).startsWith(")")) {
                    sql = s.substring(1).trim();
                    return AppUtil.executeSql(sql, parameters, ctx);
                }
                Command command = Command.parse(sql);
                if (command.getType() == 12) {
                    Sequence arg = JDBCUtil.prepareArg(parameters);
                    sql = AppUtil.prepareSql(sql, arg);
                    return AppUtil.execute(sql, arg, ctx);
                }
            } else if (AppUtil.isSQL(sql)) {
                return AppUtil.executeSql(s, parameters, ctx);
            }
        } else {
            if (AppUtil.isSQL(sql) && isCompatiblesql) {
                return AppUtil.executeSql(sql, parameters, ctx);
            }
            nameParam = JDBCUtil.getSplNameParam(sql);
            splName = nameParam[0];
            params = nameParam[1];
            sql = JDBCUtil.getCallExp(splName, params, paramCount);
        }
        Sequence arg = isCalls ? JDBCUtil.prepareCallsArg(parameters) : JDBCUtil.prepareArg(parameters);
        if (isGrid) {
            Object val = AppUtil.execute(sql, arg, ctx);
            return val;
        }
        boolean isOldCall = false;
        if (sql.startsWith("jdbccall")) {
            int i1 = sql.indexOf("(");
            int i2 = sql.indexOf(")");
            if (i2 > i1) {
                String params2 = sql.substring(i1 + 1, i2);
                ArgumentTokenizer at = new ArgumentTokenizer(params2, ',');
                while (at.hasNext()) {
                    String param = at.next();
                    if (param == null || !param.trim().equals("?")) continue;
                    isOldCall = true;
                    break;
                }
            }
        }
        if (sql.startsWith("=") || sql.startsWith(">")) {
            sql = sql.substring(1);
        }
        Object o = isOldCall ? Eval.calc(sql, arg, null, ctx) : AppUtil.execute1(sql, arg, ctx);
        if (!hasReturn) {
            return null;
        }
        return o;
    }

    public static Object executeGateway(String sql, ArrayList<Object> parameters, Context ctx, String gateway) throws SQLException, RetryException {
        PgmCellSet cellSet;
        Sequence args = JDBCUtil.prepareArg(parameters);
        try {
            cellSet = AppUtil.readCellSet(gateway);
        }
        catch (Exception e) {
            throw new SQLException(JDBCMessage.get().getMessage("jdbcutil.nogatewayfile", gateway), e);
        }
        Context csCtx = cellSet.getContext();
        ParamList list = cellSet.getParamList();
        if (list != null) {
            ParamList varList = new ParamList();
            list.getAllVarParams(varList);
            boolean isDynamicParam = cellSet.isDynamicParam();
            int paramCount = varList.count();
            int argCount = args.length();
            if (paramCount > 0) {
                if (isDynamicParam) {
                    if (paramCount == 1) {
                        if (argCount == 0) {
                            csCtx.setParamValue(varList.get(0).getName(), sql);
                        } else {
                            Sequence dynamicParam = new Sequence();
                            dynamicParam.add(sql);
                            dynamicParam.add(args);
                            csCtx.setParamValue(varList.get(0).getName(), dynamicParam);
                        }
                    } else {
                        args.insert(1, sql);
                        AppUtil.setParamToCellSet(cellSet, args);
                    }
                } else {
                    args.insert(1, sql);
                    AppUtil.setParamToCellSet(cellSet, args);
                }
            }
        }
        csCtx.setEnv(ctx);
        cellSet.calculateResult();
        return cellSet;
    }

    public static String trimSql(String sql) {
        if (!StringUtils.isValidString(sql)) {
            return null;
        }
        if ((sql = sql.trim()).startsWith("{") && sql.endsWith("}")) {
            sql = sql.substring(1, sql.length() - 1);
            sql = sql.trim();
        }
        return sql;
    }

    public static String getCallExp(String splName, String params, int paramCount) throws SQLException {
        return JDBCUtil.getCallExp(splName, params, paramCount, null);
    }

    public static String getCallExp(String splName, String params, int paramCount, String opt) throws SQLException {
        if (!StringUtils.isValidString(params)) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < paramCount) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append("?");
                ++i;
            }
            params = buf.toString();
        } else {
            params = params.trim();
        }
        opt = StringUtils.isValidString(opt) ? "@" + opt : "";
        String sql = "jdbccall" + opt + "(\"" + splName + "\"" + (params.length() > 0 ? "," + params : "") + ")";
        return sql;
    }

    public static String getCallExp(String splName, String params, boolean isOnlyServer, List<String> hostNames) throws SQLException {
        String sql;
        params = params == null ? "" : params.trim();
        String hosts = JDBCUtil.getNodesString(splName, isOnlyServer, hostNames);
        if (hosts != null) {
            if (params.length() > 0) {
                if (params.indexOf(",") > -1) {
                    String[] ps = params.split(",");
                    if (ps != null && ps.length > 0) {
                        StringBuffer callxParams = new StringBuffer();
                        int i = 0;
                        while (i < ps.length) {
                            if (i > 0) {
                                callxParams.append(",");
                            }
                            callxParams.append("[");
                            callxParams.append(ps[i]);
                            callxParams.append("]");
                            ++i;
                        }
                        params = callxParams.toString();
                    }
                } else {
                    params = "[" + params + "]";
                }
            } else {
                params = "";
            }
            if (!splName.startsWith("\"") || !splName.endsWith("\"")) {
                splName = Escape.addEscAndQuote(splName, true);
            }
            sql = "callx@j(" + splName + (params.length() > 0 ? "," + params : "") + hosts + ")(1)";
        } else {
            if (isOnlyServer) {
                throw new SQLException(JDBCMessage.get().getMessage("jdbcutil.noserverconfig"));
            }
            sql = "call(\"" + splName + "\"" + (params.length() > 0 ? "," + params : "") + ")";
        }
        return sql;
    }

    public static boolean isCallsStatement(String sql) {
        if (!StringUtils.isValidString(sql)) {
            return false;
        }
        byte sqlType = JDBCUtil.getJdbcSqlType(sql);
        return sqlType == 4;
    }

    public static String[] getCallsNameParam(String sql, ArrayList<?> parameters) throws SQLException {
        return JDBCUtil.getCallsNameParam(sql, parameters, true);
    }

    public static String[] getCallsNameParam(String sql, ArrayList<?> parameters, boolean isExecute) throws SQLException {
        String params;
        String name;
        sql = sql.substring("calls".length());
        int left = (sql = sql.trim()).indexOf(40);
        if (left == -1 && sql.lastIndexOf(41) == -1) {
            name = sql.replaceAll("'", "");
            params = null;
        } else if (left > 0 && sql.endsWith(")")) {
            name = sql.substring(0, left);
            name = name.replaceAll("'", "");
            params = sql.substring(left + 1, sql.length() - 1).trim();
            if (isExecute) {
                if (parameters.isEmpty()) {
                    StringBuffer totalParams = new StringBuffer();
                    ArgumentTokenizer at = new ArgumentTokenizer(params, ',');
                    while (at.hasNext()) {
                        String param;
                        if (totalParams.length() > 0) {
                            totalParams.append(",");
                        }
                        if ((param = at.next()) != null && KeyWord.isArg(param = param.trim())) {
                            totalParams.append(param);
                            continue;
                        }
                        totalParams.append("[" + (param == null ? "" : param.trim()) + "]");
                    }
                    params = totalParams.toString();
                } else {
                    Sequence seq = (Sequence)parameters.get(0);
                    int len = seq.length();
                    if (len >= 1) {
                        boolean needTransParam = false;
                        StringBuffer totalParams = new StringBuffer();
                        ArgumentTokenizer at = new ArgumentTokenizer(params, ',');
                        while (at.hasNext()) {
                            String param;
                            if (totalParams.length() > 0) {
                                totalParams.append(",");
                            }
                            if ((param = at.next()) != null && KeyWord.isArg(param = param.trim())) {
                                totalParams.append(param);
                                continue;
                            }
                            needTransParam = true;
                            StringBuffer repParams = new StringBuffer();
                            int i = 0;
                            while (i < len) {
                                if (repParams.length() > 0) {
                                    repParams.append(",");
                                }
                                if (param == null) {
                                    repParams.append("");
                                } else {
                                    repParams.append(param.trim());
                                }
                                ++i;
                            }
                            totalParams.append("[" + repParams.toString() + "]");
                        }
                        if (needTransParam) {
                            params = totalParams.toString();
                        }
                    }
                }
            }
        } else {
            throw new SQLException(JDBCMessage.get().getMessage("jdbcutil.errorcallsformat"));
        }
        String splName = name;
        if (splName != null && (splName = splName.trim()).startsWith("\"") && splName.endsWith("\"")) {
            splName = splName.substring(1, splName.length() - 2);
            splName = splName.trim();
        }
        return new String[]{splName, params};
    }

    public static String[] getCallNameParam(String sql) throws SQLException {
        String params;
        String name;
        sql = sql.substring("call".length());
        int left = (sql = sql.trim()).indexOf(40);
        if (left == -1 && sql.lastIndexOf(41) == -1) {
            name = sql.replaceAll("'", "");
            params = null;
        } else if (left > 0 && sql.endsWith(")")) {
            name = sql.substring(0, left);
            name = name.replaceAll("'", "");
            params = sql.substring(left + 1, sql.length() - 1).trim();
        } else {
            throw new SQLException(JDBCMessage.get().getMessage("jdbcutil.errorcallformat"));
        }
        String splName = name;
        if (splName != null && (splName = splName.trim()).startsWith("\"") && splName.endsWith("\"")) {
            splName = splName.substring(1, splName.length() - 2);
            splName = splName.trim();
        }
        return new String[]{splName, params};
    }

    public static String[] getSplNameParam(String sql) {
        String spl = sql = sql.trim();
        String params = null;
        if (sql.endsWith(")") && sql.indexOf("(") > 0) {
            ArgumentTokenizer at = new ArgumentTokenizer(sql, '(');
            if (at.hasNext()) {
                spl = at.next();
            } else {
                int paramStart = sql.indexOf("(");
                spl = sql.substring(0, paramStart);
            }
            if (spl.length() < sql.length()) {
                params = sql.substring(spl.length() + 1, sql.length() - 1);
            }
        } else {
            ArgumentTokenizer at = new ArgumentTokenizer(sql, ' ');
            if (at.hasNext() && (spl = at.next()).length() < sql.length()) {
                params = sql.substring(spl.length(), sql.length());
            }
        }
        if (params != null) {
            params = params.trim();
        }
        return new String[]{spl, params};
    }

    public static String getSplName(String sql) throws SQLException {
        String splName;
        byte sqlType = JDBCUtil.getJdbcSqlType(sql = JDBCUtil.trimSql(sql));
        if (sqlType == 4) {
            String[] nameParam = JDBCUtil.getCallsNameParam(sql, null, false);
            splName = nameParam[0];
        } else if (sqlType == 3) {
            String[] nameParam = JDBCUtil.getCallNameParam(sql);
            splName = nameParam[0];
        } else if (sqlType == 5) {
            String[] nameParam = JDBCUtil.getSplNameParam(sql);
            splName = nameParam[0];
        } else {
            throw new SQLException(JDBCMessage.get().getMessage("error.onlycallsetparam"));
        }
        return splName;
    }

    public static Sequence prepareArg(List<Object> parameters) throws SQLException {
        Sequence arg = new Sequence();
        if (parameters != null && parameters.size() > 0) {
            int i = 0;
            while (i < parameters.size()) {
                Object obj = parameters.get(i);
                obj = JDBCUtil.transParamValue(obj);
                arg.add(obj);
                Logger.debug("param" + (i + 1) + "=[" + obj + "]");
                ++i;
            }
        }
        return arg;
    }

    public static Sequence prepareCallsArg(List<Sequence> parameters) throws SQLException {
        Sequence arg = new Sequence();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.size()) {
                Sequence seq = parameters.get(i);
                Sequence sub = new Sequence();
                int j = 1;
                while (j <= seq.length()) {
                    Object obj = seq.get(j);
                    obj = JDBCUtil.transParamValue(obj);
                    sub.add(obj);
                    ++j;
                }
                Logger.debug("param" + (i + 1) + "=" + seq.toString());
                arg.add(sub);
                ++i;
            }
        }
        return arg;
    }

    private static Object transParamValue(Object obj) {
        Sequence s = new Sequence();
        if (obj instanceof Object[][]) {
            Object[][] oss = (Object[][])obj;
            int rowCount = oss.length;
            if (rowCount < 1) {
                return null;
            }
            Object[] firstRow = oss[0];
            int colCount = firstRow.length;
            if (colCount < 1) {
                return null;
            }
            String[] fields = new String[colCount];
            DataStruct ds = new DataStruct();
            int c = 0;
            while (c < colCount) {
                Object o = firstRow[c];
                if (o == null || !(o instanceof String)) {
                    fields = null;
                    break;
                }
                fields[c] = o.toString();
                ++c;
            }
            int dataStart = 1;
            if (fields == null) {
                fields = new String[colCount];
                dataStart = 0;
            }
            ds = new DataStruct(fields);
            Table t = new Table(ds);
            int r = dataStart;
            while (r < rowCount) {
                t.newLast(oss[r]);
                ++r;
            }
            return t;
        }
        if (obj instanceof Object[]) {
            Object[] os = (Object[])obj;
            int j = 0;
            while (j < os.length) {
                s.add(os[j]);
                ++j;
            }
            return s;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            int j = 0;
            while (j < list.size()) {
                s.add(list.get(j));
                ++j;
            }
            return s;
        }
        if (obj instanceof Vector) {
            Vector vec = (Vector)obj;
            int j = 0;
            while (j < vec.size()) {
                s.add(vec.get(j));
                ++j;
            }
            return s;
        }
        if (obj instanceof short[]) {
            short[] os = (short[])obj;
            int j = 0;
            while (j < os.length) {
                s.add(new Short(os[j]));
                ++j;
            }
            return s;
        }
        if (obj instanceof int[]) {
            int[] os = (int[])obj;
            int j = 0;
            while (j < os.length) {
                s.add(new Integer(os[j]));
                ++j;
            }
            return s;
        }
        if (obj instanceof long[]) {
            long[] os = (long[])obj;
            int j = 0;
            while (j < os.length) {
                s.add(new Long(os[j]));
                ++j;
            }
            return s;
        }
        if (obj instanceof double[]) {
            double[] os = (double[])obj;
            int j = 0;
            while (j < os.length) {
                s.add(new Double(os[j]));
                ++j;
            }
            return s;
        }
        if (obj instanceof float[]) {
            float[] os = (float[])obj;
            int j = 0;
            while (j < os.length) {
                s.add(new Float(os[j]));
                ++j;
            }
            return s;
        }
        if (obj instanceof boolean[]) {
            boolean[] os = (boolean[])obj;
            int j = 0;
            while (j < os.length) {
                s.add(new Boolean(os[j]));
                ++j;
            }
            return s;
        }
        return obj;
    }

    public static Table getSplParams(String splPath) throws SQLException {
        Table t = new Table(new String[]{"PROCEDURE_NAME", "PARAM_LIST"});
        try {
            ParamList pl;
            PgmCellSet cs = AppUtil.readCellSet(splPath);
            if (cs != null && (pl = cs.getParamList()) != null) {
                String splName = new File(splPath).getName();
                t.newLast(new Object[]{splName, pl});
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
        return t;
    }

    public static Table getProcedures(String procedureNamePattern) throws SQLException {
        Map<String, String> map = JDBCUtil.getSplList(procedureNamePattern);
        Iterator<String> iter = map.keySet().iterator();
        Table t = new Table(new String[]{"PROCEDURE_NAME", "PROCEDURE_FILE"});
        while (iter.hasNext()) {
            String key = iter.next();
            String value = map.get(key);
            t.newLast(new Object[]{value, key});
        }
        return t;
    }

    public static Table getProcedureColumns(String procedureNamePattern, String columnNamePattern) throws SQLException {
        Map<String, ParamList> map = JDBCUtil.getProcedureColumnMap(procedureNamePattern, columnNamePattern);
        Iterator<String> iter = map.keySet().iterator();
        Table t = new Table(new String[]{"PROCEDURE_NAME", "PARAM_LIST"});
        while (iter.hasNext()) {
            String key = iter.next();
            ParamList value = map.get(key);
            t.newLast(new Object[]{key, value});
        }
        return t;
    }

    public static Map<String, ParamList> getProcedureColumnMap(String procedureNamePattern, String columnNamePattern) throws SQLException {
        Map<String, String> map = JDBCUtil.getSplList(procedureNamePattern);
        HashMap<String, ParamList> paramMap = new HashMap<String, ParamList>();
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key;
            String splPath = key = iter.next().toString();
            try {
                ParamList pl;
                PgmCellSet cs = AppUtil.readCellSet(splPath);
                if (cs == null || (pl = cs.getParamList()) == null) continue;
                Pattern columnPattern = JDBCUtil.getPattern(columnNamePattern, null);
                if (columnPattern != null) {
                    ParamList filterParams = new ParamList();
                    int i = 0;
                    while (i < pl.count()) {
                        Matcher m;
                        Param param = pl.get(i);
                        if (param != null && StringUtils.isValidString(param.getName()) && (m = columnPattern.matcher(param.getName())).matches()) {
                            filterParams.add(param);
                        }
                        ++i;
                    }
                    pl = filterParams;
                    cs.setParamList(pl);
                }
                String splName = new File(splPath).getName();
                paramMap.put(splName, pl);
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage(), e);
            }
        }
        return paramMap;
    }

    public static Table getTables(String tableNamePattern) throws SQLException {
        Map<String, String> map = JDBCUtil.getTableMap(tableNamePattern);
        Iterator<String> iter = map.keySet().iterator();
        Table t = new Table(new String[]{"TABLE_NAME"});
        while (iter.hasNext()) {
            String key = iter.next().toString();
            String value = map.get(key).toString();
            t.newLast(new Object[]{value});
        }
        return t;
    }

    public static Pattern getPattern(String filter, List<String> fileExts) {
        Pattern pattern = null;
        if (StringUtils.isValidString(filter)) {
            if ("%".equals(filter)) {
                filter = null;
            } else {
                filter = filter.replaceAll("%", ".*");
                filter = filter.replaceAll("_", ".?");
                String PS = File.separator;
                if (AppUtil.isWindowsOS()) {
                    filter = filter.replaceAll("/", "\\" + PS);
                    if (fileExts != null && fileExts.size() > 1) {
                        filter = filter.replaceAll("\\\\", "\\\\\\\\");
                    }
                }
            }
            if (StringUtils.isValidString(filter)) {
                pattern = Pattern.compile(filter);
            }
        }
        return pattern;
    }

    public static Table getColumns(String tableNamePattern, String columnNamePattern, Context ctx) throws SQLException {
        Map<String, String> map = JDBCUtil.getTableMap(tableNamePattern);
        Iterator<String> iter = map.keySet().iterator();
        Table t = new Table(new String[]{"TABLE_NAME", "COLUMN_NAME", "DATA_TYPE"});
        int COL_DATA_TYPE = 2;
        Pattern columnPattern = JDBCUtil.getPattern(columnNamePattern, null);
        block5: while (iter.hasNext()) {
            DataStruct ds;
            String key = iter.next().toString();
            String name = map.get(key).toString();
            SimpleSQL ss = new SimpleSQL("select * from " + Escape.addEscAndQuote(name), null, ctx);
            ICursor cursor = null;
            try {
                cursor = ss.query();
                ds = ss.getDataStruct();
            }
            catch (Exception e) {
                throw new SQLException(String.valueOf(JDBCMessage.get().getMessage("jdbcutil.dserror", name)) + e.getMessage(), e);
            }
            try {
                if (ds == null) continue;
                HashMap colTypes = new HashMap();
                Sequence data = cursor.fetch(1);
                Vector<String> fieldNames = new Vector<String>();
                Vector<String> totalFieldNames = new Vector<String>();
                int i = 0;
                while (i < ds.getFieldCount()) {
                    String colName = ds.getFieldName(i);
                    fieldNames.add(colName);
                    totalFieldNames.add(colName);
                    t.newLast(new Object[]{name, colName, (byte)11});
                    ++i;
                }
                if (data != null) {
                    data = cursor.fetch(1000);
                }
                int times = 0;
                while (data != null) {
                    ++times;
                    Vector<String> finishFieldNames = new Vector<String>();
                    for (String fname : fieldNames) {
                        Integer tmp;
                        Matcher m;
                        if (columnPattern != null && !(m = columnPattern.matcher(fname)).matches()) continue;
                        int colType = 0;
                        if (colTypes != null && (tmp = (Integer)colTypes.get(fname)) != null) {
                            colType = tmp;
                        }
                        if (colType == 0 && data != null) {
                            Sequence colData = data.fieldValues(fname);
                            int j = 1;
                            int len = colData.length();
                            while (j <= len) {
                                Object o = colData.get(j);
                                if (o != null) {
                                    colType = JDBCUtil.getType(o, colType);
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (colType == 0) continue;
                        colType = Types.getTypeBySQLType(colType);
                        int fIndex = totalFieldNames.indexOf(fname);
                        BaseRecord record = t.getRecord(fIndex + 1);
                        record.setNormalFieldValue(2, colType);
                        finishFieldNames.add(fname);
                    }
                    fieldNames.removeAll(finishFieldNames);
                    if (fieldNames.isEmpty()) {
                        continue block5;
                    }
                    if (times >= 100) {
                        continue block5;
                    }
                    data = cursor.fetch(1000);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return t;
    }

    public static Map<String, String> getSplList(String filter) {
        String[] exts;
        ArrayList<String> fileExts = new ArrayList<String>();
        String[] stringArray = exts = "splx,spl,dfx".split(",");
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            fileExts.add("." + ext);
            ++n2;
        }
        return JDBCUtil.getFiles(filter, fileExts, false);
    }

    public static Map<String, String> getFiles(String filter, List<String> fileExts, boolean matchAll) {
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern pattern = JDBCUtil.getPattern(filter, fileExts);
        String mainPath = Env.getMainPath();
        if (StringUtils.isValidString(mainPath)) {
            File mainDir = new File(mainPath);
            JDBCUtil.getDirFiles(mainDir.getAbsolutePath().length(), mainDir, map, pattern, fileExts, matchAll);
        }
        return map;
    }

    private static void getDirFiles(int rootLen, File pfile, Map<String, String> map, Pattern pattern, List<String> fileExts, boolean matchAll) {
        block10: {
            block11: {
                if (pfile == null) {
                    return;
                }
                if (!pfile.isDirectory()) break block11;
                File[] subFiles = pfile.listFiles();
                if (subFiles == null) {
                    return;
                }
                File[] fileArray = subFiles;
                int n = subFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File sf = fileArray[n2];
                    JDBCUtil.getDirFiles(rootLen, sf, map, pattern, fileExts, matchAll);
                    ++n2;
                }
                break block10;
            }
            String fileName = pfile.getName();
            if (!pfile.isFile()) break block10;
            for (String fileExt : fileExts) {
                if (!fileName.toLowerCase().endsWith(fileExt)) continue;
                if (pattern != null) {
                    boolean find;
                    if (matchAll) {
                        fileName = JDBCUtil.getSubPath(rootLen, pfile);
                        find = JDBCUtil.matchPattern(pattern, pfile, fileName, fileExt);
                    } else {
                        find = JDBCUtil.matchPattern(pattern, pfile, fileName, fileExt);
                        if (!find) {
                            fileName = JDBCUtil.getSubPath(rootLen, pfile);
                            find = JDBCUtil.matchPattern(pattern, pfile, fileName, fileExt);
                        }
                    }
                    if (!find) break;
                }
                if (matchAll) {
                    fileName = JDBCUtil.getSubPath(rootLen, pfile);
                } else {
                    fileName = pfile.getName();
                    fileName = fileName.substring(0, fileName.length() - fileExt.length());
                }
                map.put(pfile.getPath(), fileName);
                break;
            }
        }
    }

    private static boolean matchPattern(Pattern pattern, File file, String fileName, String fileExt) {
        boolean find = false;
        Matcher m = pattern.matcher(fileName);
        find = m.matches();
        if (!find) {
            fileName = fileName.substring(0, fileName.length() - fileExt.length());
            m = pattern.matcher(fileName);
            find = m.matches();
        }
        if (!find) {
            String sPattern = pattern.toString();
            if (!sPattern.toLowerCase().endsWith(fileExt)) {
                sPattern = String.valueOf(sPattern) + fileExt;
            }
            find = JDBCUtil.sameFileName(sPattern, file.getAbsolutePath());
        }
        return find;
    }

    private static boolean sameFileName(String file1, String file2) {
        if (file1 == null || file2 == null) {
            return false;
        }
        file1 = new File(Env.getMainPath(), file1).getAbsolutePath();
        file2 = new File(file2).getAbsolutePath();
        return file1.equals(file2);
    }

    private static final String getSubPath(int rootLen, File f) {
        String path = f.getPath();
        path = path.substring(rootLen);
        while (path.startsWith("\\") || path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static Map<String, String> getTableMap(String filter) {
        String[] exts;
        ArrayList<String> fileExts = new ArrayList<String>();
        String[] stringArray = exts = "btx,txt,csv,xls,xlsx".split(",");
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            fileExts.add("." + ext);
            ++n2;
        }
        return JDBCUtil.getFiles(filter, fileExts, true);
    }

    public static String getNodesString(String spl, boolean isOnlyServer, List<String> hosts) {
        LocalFile f;
        if (!StringUtils.isValidString(spl)) {
            return null;
        }
        if (!isOnlyServer && (f = new LocalFile(spl, "s")).exists()) {
            return null;
        }
        if (hosts.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int size = hosts.size();
        while (i < size) {
            String host = hosts.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(Escape.addEscAndQuote(host, '\"'));
            ++i;
        }
        return ";[" + sb.toString() + "]";
    }

    public static java.sql.ResultSet generateResultSet(Object obj) throws SQLException {
        return JDBCUtil.generateResultSet(obj, null);
    }

    public static java.sql.ResultSet generateResultSet(Object obj, Integer fetchSize) throws SQLException {
        return JDBCUtil.generateResultSet(obj, "Field", fetchSize);
    }

    public static java.sql.ResultSet generateResultSet(Object obj, String colName, Integer fetchSize) throws SQLException {
        if (obj == null) {
            return null;
        }
        String[] fields = null;
        int[] types = null;
        int[] dealTypes = null;
        ArrayList<ArrayList<Object>> datas = null;
        if (obj instanceof Table) {
            Table t = (Table)obj;
            fields = t.dataStruct().getFieldNames();
            types = new int[fields.length];
            JDBCUtil.initColumnTypes(types);
            dealTypes = new int[fields.length];
            datas = new ArrayList<ArrayList<Object>>(t.length());
            int i = 1;
            while (i <= t.length()) {
                int j;
                ArrayList<Object> row = new ArrayList<Object>(fields.length);
                BaseRecord r = t.getRecord(i);
                if (r != null) {
                    j = 0;
                    while (j < fields.length) {
                        Object o = r.getFieldValue(fields[j]);
                        row.add(o);
                        if (o != null && dealTypes[j] != 1) {
                            types[j] = JDBCUtil.getType(o, types[j]);
                            dealTypes[j] = 1;
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < fields.length) {
                        row.add(null);
                        ++j;
                    }
                }
                datas.add(row);
                ++i;
            }
        } else if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            if (seq.length() == 0) {
                fields = new String[]{colName};
                types = new int[fields.length];
                JDBCUtil.initColumnTypes(types);
                datas = new ArrayList(seq.length());
            } else {
                Object first = seq.get(1);
                if (first == null || !(first instanceof BaseRecord)) {
                    fields = new String[]{colName};
                    types = new int[fields.length];
                    JDBCUtil.initColumnTypes(types);
                    dealTypes = new int[fields.length];
                    datas = new ArrayList(seq.length());
                    int i = 1;
                    while (i <= seq.length()) {
                        Object o = seq.get(i);
                        ArrayList<Object> row = new ArrayList<Object>(1);
                        row.add(o);
                        datas.add(row);
                        if (o != null) {
                            types[0] = JDBCUtil.getType(o, types[0]);
                            if (dealTypes[0] != 1) {
                                types[0] = JDBCUtil.getType(o, types[0]);
                                dealTypes[0] = 1;
                            }
                        }
                        ++i;
                    }
                } else {
                    fields = ((BaseRecord)first).dataStruct().getFieldNames();
                    types = new int[fields.length];
                    JDBCUtil.initColumnTypes(types);
                    dealTypes = new int[fields.length];
                    datas = new ArrayList(seq.length());
                    int i = 1;
                    while (i <= seq.length()) {
                        ArrayList<Object> row = new ArrayList<Object>(fields.length);
                        Object seqi = seq.get(i);
                        if (seqi != null && seqi instanceof BaseRecord) {
                            BaseRecord r = (BaseRecord)seq.get(i);
                            int j = 0;
                            while (j < fields.length) {
                                Object o = null;
                                try {
                                    o = r.getFieldValue(fields[j]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                row.add(o);
                                if (o != null && dealTypes[j] != 1) {
                                    types[j] = JDBCUtil.getType(o, types[j]);
                                    dealTypes[j] = 1;
                                }
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < fields.length) {
                                row.add(null);
                                ++j;
                            }
                        }
                        datas.add(row);
                        ++i;
                    }
                }
            }
        } else if (obj instanceof BaseRecord) {
            BaseRecord r = (BaseRecord)obj;
            fields = r.dataStruct().getFieldNames();
            types = new int[fields.length];
            JDBCUtil.initColumnTypes(types);
            datas = new ArrayList(1);
            ArrayList<Object> row = new ArrayList<Object>(fields.length);
            int i = 0;
            while (i < fields.length) {
                Object o = r.getFieldValue(i);
                row.add(o);
                if (o != null) {
                    types[i] = JDBCUtil.getType(o, types[i]);
                }
                ++i;
            }
            datas.add(row);
        } else {
            if (obj instanceof ICursor) {
                ICursor c = (ICursor)obj;
                ResultSet set = new ResultSet(c);
                return set;
            }
            fields = new String[]{colName};
            types = new int[1];
            JDBCUtil.initColumnTypes(types);
            datas = new ArrayList(1);
            ArrayList<Object> row = new ArrayList<Object>(1);
            row.add(obj);
            if (obj != null) {
                types[0] = JDBCUtil.getType(obj, types[0]);
            }
            datas.add(row);
        }
        ResultSetMetaData metaData = new ResultSetMetaData(fields, types);
        ResultSet set = new ResultSet(datas, metaData);
        if (fetchSize != null) {
            set.setFetchSize(fetchSize);
        }
        return set;
    }

    public static java.sql.ResultSet getEmptyResultSet() throws SQLException {
        return new ResultSet(0);
    }

    private static void initColumnTypes(int[] types) {
        if (types == null || types.length == 0) {
            return;
        }
        int i = 0;
        while (i < types.length) {
            types[i] = 0;
            ++i;
        }
    }

    public static int getType(Object o, int type) {
        if (o == null) {
            return type;
        }
        if (type == 2000) {
            return type;
        }
        byte newType = JDBCUtil.getProperDataType(o);
        int newSQLType = JDBCUtil.getSQLTypeByType(newType);
        if (type == 0) {
            return newSQLType;
        }
        if (type != newSQLType) {
            if (JDBCUtil.isIntType(type) && JDBCUtil.isIntType(newSQLType)) {
                return 4;
            }
            if (JDBCUtil.isNumberType(type) && JDBCUtil.isNumberType(newSQLType)) {
                return 8;
            }
            if (JDBCUtil.isDateType(type) && JDBCUtil.isDateType(newSQLType)) {
                return 93;
            }
            return 2000;
        }
        return newSQLType;
    }

    public static byte getProperDataType(Object o) {
        if (o instanceof Integer) {
            return 1;
        }
        return Types.getProperDataType(o);
    }

    private static boolean isIntType(int type) {
        return type == -6 || type == 5 || type == 4;
    }

    private static boolean isNumberType(int type) {
        return type == 6 || type == 8 || JDBCUtil.isIntType(type);
    }

    private static boolean isDateType(int type) {
        return type == 91 || type == 92 || type == 93;
    }

    public static int getSQLTypeByType(byte type) {
        switch (type) {
            case 1: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 2: 
            case 4: {
                return -5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 91;
            }
            case 9: {
                return 92;
            }
            case 10: {
                return 93;
            }
            case 11: {
                return 12;
            }
            case 12: {
                return 16;
            }
            case 62: {
                return -2;
            }
        }
        return 2000;
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 4: {
                return "INTEGER";
            }
            case 5: {
                return "SMALLINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 12: {
                return "VARCHAR";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -2: {
                return "BINARY";
            }
        }
        return "JAVA_OBJECT";
    }

    public static String getTypeClassName(int type) {
        switch (type) {
            case 4: {
                return "java.lang.Integer";
            }
            case 5: {
                return "java.lang.Short";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 6: {
                return "java.lang.Float";
            }
            case 8: {
                return "java.lang.Double";
            }
            case 3: {
                return "java.math.BigDecimal";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 12: {
                return "java.lang.String";
            }
            case 16: {
                return "java.lang.Boolean";
            }
            case -2: {
                return "java.lang.Object";
            }
        }
        return "java.lang.Object";
    }

    public static void writeArrayList(ObjectOutput out, ArrayList<Object> list) throws IOException {
        if (list == null) {
            out.writeShort(0);
        } else {
            int size = list.size();
            out.writeShort((short)size);
            int i = 0;
            while (i < size) {
                out.writeObject(list.get(i));
                ++i;
            }
        }
    }

    public static ArrayList<Object> readArrayList(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = in.readShort();
        ArrayList<Object> list = null;
        if (count > 0) {
            list = new ArrayList<Object>();
            int i = 0;
            while (i < count) {
                list.add(in.readObject());
                ++i;
            }
        }
        return list;
    }

    public static void writeArrayList2(ObjectOutput out, ArrayList<ArrayList<Object>> list) throws IOException {
        if (list == null) {
            out.writeShort(0);
        } else {
            int size = list.size();
            out.writeShort((short)size);
            int i = 0;
            while (i < size) {
                JDBCUtil.writeArrayList(out, list.get(i));
                ++i;
            }
        }
    }

    public static ArrayList<ArrayList<Object>> readArrayList2(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = in.readShort();
        ArrayList<ArrayList<Object>> list = null;
        if (count > 0) {
            list = new ArrayList<ArrayList<Object>>();
            int i = 0;
            while (i < count) {
                list.add(JDBCUtil.readArrayList(in));
                ++i;
            }
        }
        return list;
    }

    public static String clobToString(Clob x) throws SQLException {
        StringBuffer buf = new StringBuffer();
        Reader is = null;
        try {
            try {
                is = x.getCharacterStream();
                BufferedReader br = new BufferedReader(is);
                String s = br.readLine();
                while (s != null) {
                    buf.append(s);
                    s = br.readLine();
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buf.toString();
    }

    public static void log(String info) {
        if (isDebugMode) {
            Logger.debug(info);
        }
    }

    public static void checkSqlLength(String sql) throws SQLException {
        if (sql == null) {
            return;
        }
        if (sql.length() > 65536) {
            throw new SQLException(JDBCMessage.get().getMessage("error.maxlen", 65536));
        }
    }

    public static String array2String(Object[] objs) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        if (objs != null) {
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(obj);
                ++n2;
            }
        }
        buf.append("]");
        return buf.toString();
    }

    public static String array2String(int[] ints) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        if (ints != null) {
            int[] nArray = ints;
            int n = ints.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(i);
                ++n2;
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

